;
	PAGE	58,132
	NAME	VIDDVR
	TITLE	ROM VERSION OF CORVUS VIDEO DRIVER
;
; --- THIS MODULE USES INCLUDE FILES: SYSTEM.EQU, VIDDVR.LIB
;     TO MAKE A SIMPLE BINARY "ROM" MODULE TO TEST THE DRIVERS.
;     THE MODULE STARTS WITH A TABLE OF 1 "NEAR" JUMP.
;
;
;
CSEG	SEGMENT PARA PUBLIC 'CODE'
;
;
;*******************
;*   M A C R O S   *
;*******************
;
;
F_CALL	MACRO	SegVal,OffVal
	DB	   9Ah			; direct intersegment CALL opcode
	DW	OffVal			; offset portion of operand
	DW	SegVal			; segment portion of operand
	ENDM
;
F_JMP	MACRO	SegVal,OffVal
	DB	  0EAh			; direct intersegment JMP opcode
	DW	OffVal			; offset portion of operand
	DW	SegVal			; segment portion of operand
	ENDM
;
PRINTE	MACRO	MSG,N
	IF2
	%OUT	* MSG N *
	ENDIF
	ENDM
;
; Miscellaneous Corvus equates
;
TRUE		EQU	0FFFFH		; logical true
FALSE		EQU	    0		; logical false
garbage 	EQU	    0		;
BEL		EQU	  007h		; ASCII bell character
LF		EQU	  00Ah		; ASCII linefeed character
CR		EQU	  00Dh		; ASCII carriage return character
ROMSEG		=	    0		; set default rom segment
;
;
;*************************************
;*   S T A R T	 O F   D R I V E R   *
;*************************************
;
	INCLUDE	SYSTEM.EQU	; INCLUDE SYSTEM SPECS.
;
VIDDVR	PROC	FAR
;
	ASSUME	CS:CSEG,ES:CSEG,DS:CSEG
BEGIN:
START		EQU	$
;
;
ROMJMPS	EQU	$
;
	JMP	VIDEO
;
	INSTMG			; GET PART OF MESSAGE FROM INCLUDE FILE
	DB	' VIDEO driver routine'
;
; --- MAKE BUILTIN "ROM" ROUTINE ON SEGMENT BOUNDARY ---
;
	 IF ($-START) MOD 16
	ORG	($-START)+16-(($-START) MOD 16)
	 ENDIF
;
	INCLUDE	VIDDVR.LIB		;  LOAD DRIVER IN
;
;
;**********************************************************
;* Reserve 80 hex bytes of patch space for fooling around *
;**********************************************************
;
PATCH   DB	80h DUP (0)		;
;
;***********************************************************************
;
VIDDVR	ENDP				; end of main proc
CSEG	ENDS				; end of code seg defn
	END	BEGIN
