PAGE	58,132
NAME	SINIT
TITLE	SINIT - SHADOW DRIVE initialization program
;
IF2
	%OUT	<Starting Pass Two>
ENDIF
;
;
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;									      *
; Filename:	SINIT.ASM  (written for the Microsoft MACRO Assembler v3.00)  *
;									      *
; Purpose:	This program does the setup and initialization for a SHADOW   *
;		drive pair.  It will also reset a SHADOW pair back to normal  *
;		drives. 						      *
;									      *
; Author:	Norman O. Doyle  nod					      *
;									      *
; Created:	2/11/85 						      *
; Modified:	2/05/86 						      *
; Version:	0.03c							      *
; Change Log:								      *
;									      *
;      2/11/85	0.01a - Preliminary version - nod			      *
;      8/13/85	0.02a - Changed HELP screen - nod			      *
;      8/20/85	0.02b - Changed 'drive' to 'node' on copy question. - nod     *
;      8/29/85	0.02c - Bug in NBRBLKS that loaded the sector # to read       *
;			into the wrong data area. - nod 		      *
;      9/06/85	0.03a - Do NOT compare PIPE volumes. - nod		      *
;      9/11/85	0.03b - Disabled the print screen function while doing a      *
;			drive copy and drive compare. - nod		      *
;      2/05/86	0.03c - Don't allow subroutine CHKSRV to wait forever         *
;			while doing a WHO ARE YOU call. - nod		      *
;									      *
;	  (c) Copyright 1985 Corvus Systems, Inc.  All rights reserved.       *
;									      *
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;
;
CSEG	SEGMENT PARA PUBLIC 'CODE'

	ASSUME	CS:CSEG,DS:CSEG,ES:CSEG

	ORG	100H			;
START:	JMP	MAIN			;

;**************************************************************************
;
; EQUATES
;
;**************************************************************************
;
VER	EQU	0			; Version number
REVNBR	EQU	0			; Revision number
SUBREV	EQU	3			; Sub-revision number
REVLTR	EQU	'c'                     ; Revision letter (lower case)
;
; Version of the Corvus driver (CORDRV) required to run this program
;
CORVER	EQU	6			;CORDRV version and revision needed
CORREV	EQU	0			;
;
; ASCII equates
;
BACKSPC EQU	08H			;ASCII backspace
BELL	EQU	07H			;ASCII bell
BLANK	EQU	20H			;ASCII blank
CR	EQU	0DH			;ASCII carriage return
DOT	EQU	2EH			;ASCII period
ESCAPE	EQU	1BH			;ASCII ESCAPE character
LF	EQU	0AH			;ASCII line feed
TAB	EQU	09H			;ASCII horizontal tab
NULL	EQU	00H			;ASCII null
;
; Screen character equates
;
CMDPOS	EQU	1519H			;cursor position to input command
CMDWND	EQU	1500H			;upper left corner of command window
CONTPOS EQU	1800H			;bottom left corner
CMPPOS1 EQU	151BH			;cursor pos for compare (1st drive)
CMPPOS2 EQU	161BH			;cursor pos for compare (2st drive)
CPYPOS1 EQU	151DH			;cursor position for copy from
CPYPOS2 EQU	161DH			;cursor position for copy to
ERRLINE EQU	1800H			;cursor position for the error line
LIN2POS EQU	0C00H			;cursor position for line number 2
MSPOS1	EQU	152DH			;cursor position for getting MASTER
MSPOS2	EQU	162DH			;cursor position for getting SLAVE
NMLPOS	EQU	1539H			;cursor position for setting NORMAL
ODLPOS	EQU	0700H			;cursor position for drive statuses
PSWPOS1 EQU	1518H			;cursor position for new password 1
PSWPOS2 EQU	1623H			;cursor position for new password 2
SCTRSZ1 EQU	162DH			;cursor position for current sector
SCTRSZ2 EQU	1641H			;cursor position for total sectors
TEMPOS1 EQU	1425H			;cursor position for the template
TEMPOS2 EQU	1525H			;cursor position for the template
TEMPOS3 EQU	1625H			;cursor position for the template
TEMPOS4 EQU	1725H			;cursor position for the template
;
; Drive type (OmniDrive or generic)
;
DSKSERV EQU	1			;generic disk server device type
ODRIVE	EQU	6			;Omni drive device type
;
; SHADOW drive type ( see CORDRV.ASM for further details)
; (ONLY CHANGE THESE VALUES IF THEY ARE FIRST CHANGED IN CORDRV.ASM)
;
DT_OFFLINE	EQU    -1		;drive is down and cannot be used.
DT_NORMAL	EQU	0		;drive is a normal drive (not shadow)
DT_MASTER	EQU	1		;drive is a master in a shadow pair
DT_SLAVE	EQU	2		;drive is a slave in a shadow pair
NO_SHADOW_PROM	EQU	3		;drive doesn't have the SHADOW PROM
;
; Server table Equates
;
NODENUM 	EQU	0		;node number offset
SRVRNAM 	EQU	1		;server name offset
SRVRSIZ 	EQU	11		;server size offset
;					;server sizes are stored using the same
;					;method as for sending an OmniDrive
;					;a sector number. (ie. d, lsb, msb)
;					; d  =the most significant byte, add
;					;     10H to it and swap the nibbles.
;					; lsb=the least significant byte
;					; msb=the middle byte
ENTRYSZ 	EQU	14		;size of one entry
TBLSZ		EQU	64		;number of entries
;
; Drive type table Equates
;
DT_TBLSZ	EQU	6		;number of entries
DT_ENTSIZ	EQU	5		;size of one entry (in bytes)
DT_OUTPUT	EQU	1		;offset for ascii string to output
;
; Misc Equates
;
ROMDATA 	EQU	50H		;Location of the BIOS data segment
PrtStat 	EQU	0		;Offset for print screen status byte
COLOR		EQU	0		;
MONOCHROME	EQU	1		;
%ODLLEN 	EQU	38		;length of string "%ODLINE"
SHDO_OFST	EQU	42		;offset into CORTAb to find the
;					;... ptr to SHADOW_TBL
;BUFFSIZ	 EQU	 1		 ;number of sectors to buffer up for
;					;... a compare.
INBUF_SIZ	EQU	8		;size of %INBUFF
OUTSTR_SIZ	EQU	6		;max number of digits in %OUTSTR
TEN		EQU	10
ONEHUNDRED	EQU	100
ONETHOUSAND	EQU	1000
TENTHOUSAND	EQU	10000		;
TWOK		EQU	2048		;decimal value for 2k bytes
WAIT		EQU	00AH		;# of .86 sec ticks to wait on disk
;					; server
RDBUF_SIZ	EQU	20		;Size of the read/write buffer
RETRIES 	EQU	00AH		;# of retransmissions before aborting
Strtblk 	EQU	10		;Offset into DRIVE VOL TABLE for the
					;... address of the 1st block of volume
Endblk		EQU	14		;Offset into DRIVE VOL TABLE for the
					;... address of the last block of vol.
DVblks		EQU	60		;Offset into BLK 8 for DRV VOL TBL size
DVaddr		EQU	74		;Offset into BLK 8 for DRV VOL TBL addr
TRUE		EQU	0FFFFH		;Logical true
FALSE		EQU	0		;Logical false
;
;**************************************************************************
;
; STORAGE
;
;**************************************************************************

EVEN
;
;  This is the PASSWORD locator followed by the encrypted password.
;  Its location is critical.  PLEASE DO NOT MOVE.
;
CORVUS_STRING	DB	"Corvus"        ;Users password is found in the
;					;...following 8 bytes
PASSWORD:	DB	069H,049H,055H,09AH ;user's password (encrypted)
		DB	02FH,016H,064H,074H ;... password is "HAI" to start
BACKDOOR:	DB	0C5H,08DH,028H,0F0H ;Binary code for the backdoor
		DB	030H,017H,065H,075H ;... encrypted password
;
;
PIPEVOL 	DW	FALSE		;Default to no pipe volume on drive
PVOLSTRT_HI	DB	0		;Pipe volume starting sector (hi byte)
PVOLSTRT_LO	DW	0		;Pipe volume starting sector (low word)
PVOLEND_HI	DB	0		;Pipe volume ending sector (hi byte)
PVOLEND_LO	DW	0		;Pipe volume ending sector (low word)
DRVVOLTBL_SIZ	DW	0		;Size of the Drive volume table in blks
msb_lsb 	DW	0		;
d		DB	0		;
msb_lsb2	DW	0		;
d2		DB	0		;
FRSTBLK 	DB	0		;
VIDEO:		DD	0		;address of video driver
CORPTR: 	DD	0		;address of CORTAB
PARMTAB:	DD	0		;offset & segment of parameter table
HANDLE: 	DW	0		;file handle
DRTN:		DW	0		;address of current display routine
TIMMULT:	DW	0		;time multiplier
%NUMOD: 	DW	0		;# of OmniDrives on the net (default=1)
%SRVR_TBL_PTR	DW	0		;pointer to the correct entry in the
;					;... %SRVTBL
SCTNBR: 	DW	0		;
DATE		DW	0		;Saved file date stamp
TIME		DW	0		;Saved file time stamp
DATTIM		DW	0		;0=Success in getting date/time stamp
SCREEN_TYPE	DB	MONOCHROME	;Default to a monochrome screen
ROWCOL		LABEL	WORD
COL		DB	0
ROW		DB	0
XMITDESC	LABEL	WORD
		DB	WAIT		;# of .86 sec ticks to wait on disk srvr
		DB	RETRIES 	;# of retransmissions before aborting

%CRYPPSW:	DB	8 DUP (0)	;encrypted password (what was entered)
SAVPSW: 	DB	8 DUP (" ")     ;saved area for first password entered
%NUMBER:	DB	0		;1 = only allow numbers for input
%ECHO:		DB	0		;0 = echo character
%MAXCHR:	DB	0		;maximum number of characters wanted
%CHRTYP:	DB	0		;number of characters entered
%INBUFF:	DB	INBUF_SIZ DUP(0) ;input buffer from console
%OUTSTR:	DB	15,OUTSTR_SIZ DUP (" "),"$"
RDWRBUF:	DB	RDBUF_SIZ DUP (0)      ;Read/write buffer
Prt_Sc		DB	0		;Enable/disable print screen function
;					; Enable = 0, Disable = 1

FILENM: 	DB	"SINIT.COM",0   ;name of program
FILEHANDL	DW	0

PIPENAM:	DB	"PIPES     "
UTILSTR:	DB	"UTILHOOK",0    ;device 'UTILHOOK'
MAXCHR: 	DB	0		;maximum # of chars to input
CMD:		DB	0		;number chars read & cmd char
XPORTER:	DB	0FFH		;transporter # (gets patched in later)
NODE1		LABEL	NEAR
MNODE:		DB	0		;node number for the master
NODE2		LABEL	NEAR
SNODE:		DB	0		;node number for the slave
;
; CONSTELLATION II server commands
;
EVEN
WHOAREYOU LABEL NEAR
	DB	01,0FEH 		;protocol ID
	DB	02,0			;message type
	DB	0			;
WAYSRC: DB	0			;source
WAYDEV: DB	0,0FFH			;responding device type wanted

ID	LABEL	NEAR
	DW	0			;protocol ID
	DW	0			;message type
	DB	0			;
IDSRC:	DB	0			;sending station's address
	DB	0			;
IDDEV:	DB	0			;sending station's device type
IDNM:	DB	10 DUP (0)		;sending station's name

GETDRVPARMS	LABEL	NEAR
	DB	16			;protocol ID
DRVNBR: DB	1			;which drive do you want to respond

DRVPARMS LABEL	NEAR
	DB	37 DUP (0)		;1st 37 bytes returned are not needed
CAPACTY:DB	 3 DUP (0)		;capacity of drive in 512 byte sectors
	DB	88 DUP (0)		;last 88 bytes returned are not needed
;
CMDSTR	LABEL	NEAR
LSHOST	DB	0
LSDRIVE DB	0
LSADDH	DW	0
LSADDL	DW	0
LSCNTH	DW	0
LSCNTL	DW	0
LDHOST	DB	0
LDDRIVE DB	0
LDADDH	DW	0
LDADDL	DW	0
LDCNTH	DW	0
LDCNTL	DW	0

SHADOWMSTR	LABEL	NEAR		;
	DB	53H			;Opcode = SHADOW command
	DB	01H			;Sub Op = Become a MASTER drive
SLVADDR DB	0			;Address of the slave drive

SHADOWSLV	LABEL	NEAR		;
	DB	53H			;Opcode = SHADOW command
	DB	02H			;Sub Op = Become a SLAVE drive
MSTADDR DB	0			;Address of the master drive

RESETNORML	LABEL	NEAR		;
	DB	53H			;Opcode = SHADOW command
	DB	00H			;Sub Op = Reset drive to NORMAL server

READ_SEMA4	LABEL	NEAR		;
	DB	1AH			;Command code = Get semaphore status
	DB	41H
	DB	03H
	DB	0,0

LOCK_SEMA4	LABEL	NEAR		;
	DB	0BH			;Command code = Semaphore Lock
	DB	01H
S4NAME: DB	8 DUP (0)

INIT_SEMA4	LABEL	NEAR		;
	DB	1AH			;Command code = Initialize sema4 table
	DB	10H
	DB	0,0,0

S4TBL1: DB	256 DUP(0)		; Semaphore table one
S4TBL2: DB	256 DUP(0)		; Semaphore table two
;
;**************************************************************************
;
; Drive compare and copy command area (Read/Write sector commands)
;
READCMD 	LABEL	NEAR
		DB	  32H
RSECTOR:	DB	  3 DUP (0)

WRITECMD	LABEL	NEAR
		DB	  33H
WSECTOR:	DB	  3 DUP (0)

D1DATA: 	DB	512 DUP (0)		;space for a 512 byte sectors
D2DATA: 	DB	512 DUP (0)		;space for a 512 byte sectors
DRV_SRVR_NAMES: DB	32 DUP (0)		;


;**************************************************************************
;
; Echo Table
;
%ECHOTBL:DB	(TBLSZ) DUP (0FFH)	;fill with FF's
;
; Server table
;
%SRVTBL:DB	(ENTRYSZ*TBLSZ) DUP (0) ;
;
; Drive type table.  The first value for each entry in the table is the
;  approxamate size of the drive as found by taking the number of sectors
;  and dividing it by 2048. (ie. 32474 / 2048 = 15.85 and 15.85 truncated
;  equals 15.)
;
%DRVTBL:DB	 0,  "??MB"             ;Use for unknown OmniDrive
	DB	 5,  " 6MB"             ; 6 megabyte OmniDrive
	DB	10,  "11MB"             ;11 megabyte OmniDrive
	DB	15,  "16MB"             ;16 megabyte OmniDrive
	DB	21,  "21MB"             ;21 megabyte OmniDrive
	DB	43,  "45MB"             ;45 megabyte OmniDrive

;**************************************************************************
;
; SYSTEM ID STRINGS
;
;**************************************************************************

IBMID:	DB	3,'IBM'                 ;

;**************************************************************************
;
; LITERALS
;
;**************************************************************************

BANNER: DB	15,"SHADOW Drive Initialization - ["
	DB	VER+30H,".",REVNBR+30H,SUBREV+30H,REVLTR,"]",CR,LF
	DB	"Copyright (c) 1985, Corvus Systems, Inc.",CR,LF,"$"
LINE:	DB	7,79 DUP (0CDH)
CRLF:	DB	CR,LF,"$"
SRVRST: DB	14,"Current OmniDrive Statuses:",CR,LF,LF,"$"
SRVRST1:DB	14,"Node  Name       Status           Size",CR,LF
	DB	4 DUP(0C4H), 32, 10 DUP(0C4H), 32, 17 DUP(0C4H), 32
	DB	4 DUP(0C4H),CR,LF,"$"
SRVRST2:DB	14,"Node  Name       Status           Size   Node  Name     "
	DB	"  Status           Size",CR,LF
	DB	04 DUP(0C4H), 32, 10 DUP(0C4H), 32, 17 DUP(0C4H), 32
	DB	04 DUP(0C4H), 32, 32, 32, 4 DUP(0C4H), 32, 10 DUP(0C4H), 32
	DB	17 DUP(0C4H), 32, 4 DUP(0C4H),CR,LF,"$"
ODLINE: DB	10,%ODLLEN DUP(" "),"$"
NORML:	DB	"Normal"
MSTR:	DB	"Mster of node #  "
SLV:	DB	"Slave to node #  "
OFFLN:	DB	"Offline"
NOPROM: DB	"No Shadow Prom"
MENU:	DB	7,35 DUP (" "),"MENU",CR,LF
	DB	"S  -  Setup a SHADOW pair                  "
	DB	"             H - HELP",CR,LF
	DB	"N  -  Change a drive back to a NORMAL drive"
	DB	"             E - EXIT",CR,LF
	DB	"V  -  VERIFY (Compare two drives)",CR,LF
	DB	"C  -  COPY one drive onto another",CR,LF
	DB	"P  -  Change the PASSWORD",CR,LF,LF,"$"
PSWRD:	DB	14,CR,LF,LF
	DB	"To gain access to the menu, enter the password: "
	DB	"        ",8,8,8,8,8,8,8,8,"$"
;
;**************************************************************************
;
CMDPRMT:DB	14,"Please select an option: ","$"

CMPPRMT:DB	14,"Compare node number (0-63):   ",CR,LF
	DB	"   with node number (0-63):   ","$"
CPYPRMT:DB	14,"Copy from node number (0-63):   ",CR,LF
	DB	"       to node number (0-63):   ","$"
MSPRMT: DB	14,"Enter the node number for the MASTER (0-63):   ",CR,LF
	DB	"          node number for the SLAVE  (0-63):   ","$"
NMLPRMT:DB	14,"Enter the node number of the drive to "
	DB	"set NORMAL (0-63):   $"
PSWQUES:DB	14,"Enter the new password:         ","$"
PSWQES2:DB	14,"Enter it again to verify accuracy:         ","$"
CONT:	DB	7," <Press any key to continue>","$"

TEMSTR1:DB	7,42 DUP (0CDH),"$"
TEMSTR2:DB	2,0BAH,"   Current Sector   ",0BAH,"   Total Sectors   "
	DB	0BAH,"$"
TEMSTR3:DB	2,0BAH,"$"
TEMSTR4:DB	2,0C8H,20 DUP(0CDH),0CAH,19 DUP(0CDH),0BCH,"$"
TEMSTR5:DB	2,0CBH,20 DUP(0CDH),0CBH,19 DUP(0CDH),0BBH,"$"

CPYMSG	DB	14,"       Copying drive #xx to drive #yy will take between"
	DB	" 1 and nn minutes.",CR,LF
	DB	23 DUP (32),"Do you wish to proceed? [y/n]: N",8,"$"
COPYING DB	15,25 DUP (32),"..... Copy in progress .....","$"

EXITMSG:DB	10,"Exiting SINIT",CR,LF,LF
	DB	"Remember, only your SHADOW knows for sure.",CR,LF,"$"

;**************************************************************************

ERRHDR: DB	4,CR,LF,BELL,"SINIT [",VER+30H,".",REVNBR+30H,SUBREV+30H
	DB	REVLTR,"] - ","$"

WRCORMG:DB	12,"CORDRV version [",CORVER+30H,".",CORREV+30H,"]"
	DB	" or above needed.",CR,LF,"$"

RDWRERR:DB	4,"        Read/Write error on file SINIT.COM  ","$"

OPENERR:DB	4,"          Unable to open file SINIT.COM  ","$"

FLNOTFND:DB	4,"           Cannot find file SINIT.COM  ","$"

MSTRERR:DB	4,"       Unable to talk to the master drive.  ","$"

SLAVERR:DB	4,"       Unable to talk to the slave drive.  ","$"

NRMLERR:DB	4,"          Unable to talk to the drive.  ","$"

NOTNRML:DB	12,6 DUP (" ")
	DB	"The drive status must be NORMAL in order to perform"
	DB	" this operation.",BELL,"$"

MSGPSW: DB	4,15 DUP(" "),"Incorrect password.  ","$"

NOCORMG:DB	"Cannot find CORTAb.",CR,LF,"$"

NOSHDOMG: DB	12,"SHADOW version of CORDRV needed.",CR,LF,"$"

UNKID:	DB	"SINIT only supports the IBM PC."
	DB	CR,LF,"$"

PNOMTCH:DB	12,"    Password does not validate.  Please retry.  ","$"

NODERR: DB	12,16 DUP (" ")
	DB	"SLAVE and MASTER cannot have the same node number.",BELL,"$"

NODERR2:DB	12,22 DUP (" "),"Cannot compare a drive with itself.",BELL,"$"

NODERR3:DB	12,23 DUP (" "),"Cannot copy a drive onto itself.",BELL,"$"

VERERR: DB	12,24 DUP (" "),"Invalid node number, try again.",BELL,"$"

NOTEQL: DB	4,10 DUP (" "),"WARNING: Drives are NOT equal.  ",BELL,"$"

EQL:	DB	2,17 DUP (" "),"Drives are EQUAL.  ",BELL,"$"

CPYOK:	DB	2,15 DUP (" "),"Copy was successful.  ",BELL,"$"

CMPERR: DB	4,"Error during compare.  Compare aborted.  ",BELL,"$"

CPYERR1:DB	4,"Omninet error.  Copy aborted.              ",BELL,"$"
CPYERR2:DB	4,"Drive error.  Copy aborted.                ",BELL,"$"
CPYERR3:DB	4,"Drive error.  Copy aborted.                ",BELL,"$"
CPYERR4:DB	4,"Strobe timeout.  Copy aborted.             ",BELL,"$"
CPYERR5:DB	4,"Who Am I command timeout.  Copy aborted.   ",BELL,"$"
CPYERR6:DB	4,"No response from drive.  Copy aborted.     ",BELL,"$"
CPYERR7:DB	4,"Packet from wrong host.  Copy aborted.     ",BELL,"$"
CPYERR8:DB	4,"Source drive is offline.  Copy aborted.    ",BELL,"$"
CPYERR9:DB	4,"Destination drive offline.  Copy aborted.  ",BELL,"$"
ERR_LENGTH DB	46		;Number of bytes in each error string above

SIZERR: DB	12,"To perform this operation drives must be same size."
	DB	BELL,"$"

PAGE
;**************************************************************************

HELPTXT:DB	10,CR,LF
	DB	" S - This option will allow you to set u"
	DB	"p a SHADOW pair.  You must know which",CR,LF

	DB	"     two OmniDrives you wish to use.  On"
	DB	"e will be designated as the MASTER and",CR,LF

	DB	"     the other as the SLAVE.  Afterwards"
	DB	" the drive that you designate as the",CR,LF

	DB	"     SLAVE will not be directly accessib"
	DB	"le to you,  but will automatically",CR,LF

	DB	"     become the main drive in case of an"
	DB	" error on the MASTER drive, thus",CR,LF

	DB	"     enabling the system to run non-stop"
	DB	", even if a drive fails."
	DB	CR,LF,LF

	DB	" N - This will change the drive back fro"
	DB	"m a SHADOW to a NORMAL status.  The",CR,LF

	DB	"     drive will no longer be MASTER, SLA"
	DB	"VE, or OFFLINE but will now act",CR,LF

	DB	"     independently of any other drive."
	DB	CR,LF,LF


	DB	" V - Compares two drives to verify that "
	DB	"they are the same.  Before two drives",CR,LF

	DB	"     can become a SHADOW pair they must "
	DB	"be identical.  This function allows you",CR,LF

	DB	"     to see if they are."
	DB	CR,LF,LF


	DB	" C - This allows you to make an identica"
	DB	"l copy of a drive onto another drive",CR,LF

	DB	"     prior to setting up the SHADOW pair."
	DB	CR,LF,LF


	DB	" P - Permits you to change the password "
	DB	"that allows access to the menu."
	DB	CR,LF,LF


	DB	" H - Displays this help screen","$"


;**************************************************************************
;
;  Table containing addresses of routines to call depending on which
;   menu item was selected
;
CMDTAB: DB	'S'                     ;set up a shadow pair
	DW	SSETUP			;
	DB	'N'                     ;change shadow pair back to normal
	DW	NORMAL			;
	DB	'V'                     ;compair to drives
	DW	COMPAR			;
	DB	'C'                     ;copy one drive onto another
	DW	DRVCPY			;
	DB	'P'                     ;change the password
	DW	NEWPASWRD		;
	DB	'H'                     ;help
	DW	HELP			;
LCMDTAB EQU	(($-CMDTAB)/3)

;**************************************************************************

PAGE
;**************************************************************************
;
; MAIN -	main program loop
;
;**************************************************************************

MAIN	PROC	NEAR
	INT	3			; Debug entry point
	MOV	AX,CS			;
	MOV	DS,AX			; set up segments for ease of use
	MOV	ES,AX			;

	CALL	FINDVID 		;find video jump
	JC	SHORT IERROR1		;

	CALL	FINDID			;find system ID
	JC	SHORT IERROR1		;

	MOV	AH,15
	INT	10H			;Get the current video mode
	CMP	AL,0			;40x25 BW
	JZ	GTSRVRS
	CMP	AL,2			;80x25 BW
	JZ	GTSRVRS
	CMP	AL,7			;CRT MODE, 80x25 B&W card
	JZ	GTSRVRS
	MOV	SCREEN_TYPE,COLOR	;Set screen type to color
GTSRVRS:
	CALL	FINDSRV 		;find all disk servers

	CALL	DRVSIZ			;get the drive size for all OmniDrives

	CALL	PWSCRN			;display a partial screen asking ...
;					; ... for password
	JC	SHORT EXIT
	CALL	SCRN			;display entire screen
	CALL	CMDLINE 		;display command prompt
;
;Main command loop
;
MAIN0:	MOV	BX,OFFSET CMDTAB	;start of command table
	CALL	GETKYB			;get character from keyboard
	JC	SHORT EXIT		;exit if ESCAPE
	CMP	AL,'E'                  ;exit if 'E'
	JE	SHORT EXIT		;

	MOV	CX,LCMDTAB		;search through command table for
MAIN1:	CMP	BYTE PTR [BX],AL	;.character received from keyboard
	JE	SHORT DOCMD		;
	ADD	BX,3			;
	LOOP	SHORT MAIN1		;
	JMP	SHORT MAIN0		;didn't find it

DOCMD:	CALL	CLRCMD			;clear command window
	INC	BX			;point at command address
	CALL	WORD PTR [BX]		;do it
	CALL	CMDLINE 		;display command prompt
	JMP	SHORT MAIN0		;go set up for next command
;
;End main command loop

RSTERR: CALL	CLRCMD			;
RSTERR1:				;problem reseting driver
	JMP	SHORT IERROR1		;
					;
IERROR1:PUSH	DX			;save error message
	MOV	DX,OFFSET ERRHDR	;print error header
	CALL	PRNTCLR
	POP	DX			;restore error message and print
	CALL	PRNTCLR 		;exit
	JMP	EXIT2

EXIT:	MOV	AH,1			;clear the screen
	CALL	DWORD PTR [VIDEO]	;
EXIT2:	MOV	DX,OFFSET EXITMSG	;
	CALL	PRNTCLR 		;
	MOV	AH,4CH			;exit system call
	XOR	AL,AL			;show no error
	INT	21H			;bye

MAIN	ENDP

PAGE
;************************************************************************
;
; COMMAND ROUTINES
;
;************************************************************************
;
;
;
;************************************************************************
;*									*
;* Subroutine:	SSETUP							*
;*									*
;* Function:	Setup a SHADOW pair.  Specify which drive is the	*
;*		master and which is the slave.				*
;*									*
;* Input:	None							*
;*									*
;* Output:	None							*
;*									*
;* Updates:	Nothing 						*
;*									*
;* Destroys:	AX, BX, DX, SI						*
;*									*
;************************************************************************
;
SSETUP	PROC	NEAR
	CALL	CLRWNDO
	MOV	DX,CMDWND
	CALL	POSCUR
	MOV	DX,OFFSET MSPRMT	;put up the who's master/slave ques
	CALL	PRNTCLR 		;
GETMST: MOV	DX,MSPOS1		;
	CALL	POSCUR			;
	CALL	GETDEC			;
	JNC	SHORT SSCONT		;if carry set the exit
	JMP	SSEND			;if carry set the exit
SSCONT: CALL	VERIFY			;verify that the node is valid
	JC	SHORT GETMST		;get another answer
	XOR	DX,DX
	MOV	DL,AL			;Get the node number
PROM:	MOV	BYTE PTR MNODE,AL	;save the node number for the master
	MOV	DX,ERRLINE		;
	CALL	CLREOL			;clear the error message line
GETSLV: MOV	DX,MSPOS2		;
	CALL	POSCUR			;
	CALL	GETDEC			;
	JNC	SHORT SSCONT2		;if carry set the exit
	JMP	SSEND
SSCONT2:CALL	VERIFY			;verify that the node is valid
	JC	SHORT GETSLV		;get another answer
	CMP	AL,BYTE PTR MNODE	;can't set slave to same node as master
	JNE	SLVOK
	MOV	DX,MSPOS2
	CALL	POSCUR
	CALL	CLREOL			;delete the characters just entered
	MOV	DX,ERRLINE		;get cursor position for the error line
	CALL	CLREOL			;clear the error line before displaying
	CALL	POSCUR
	MOV	DX,OFFSET NODERR	;display node error message
	CALL	PRNTCLR 		;
	JMP	GETSLV
SLVOK:	MOV	DX,ERRLINE
	CALL	CLREOL			;clear any error messages
	MOV	BYTE PTR SNODE,AL	;save the node number for the slave
;
; Make sure the two drives are the same size.  If not, then we connot continue.
;
	CALL	CMPSIZ
	JC	SSETUP
;
;  Now send a ENTER SHADOW MODE command to the master and slave drives.
;
;    Send command to MASTER drive first.
;
	MOV	AL,BYTE PTR MNODE	; Get node number to talk to (master)
	MOV	SI,OFFSET SHADOWMSTR	; Omninet command
	MOV	AH,BYTE PTR SNODE	; Get the address of the slave drive
	MOV	SLVADDR,AH		; Load the slave address
	MOV	CX,3			; Number of bytes to send
	MOV	DX,0			; Number of bytes to receive
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries
	MOV	AH,1			; ROM command
	PUSH	CS			;
	CALL	CRVIO			;
	CMP	AX,0			;
	JZ	SS100			;
	MOV	DX,OFFSET MSTRERR	;
	CALL	ERRCON			;
	JMP	SSEND
;
;    Now change SHADOW_TBL in CORDRV to update the MASTER.
;
SS100:	PUSH	DS
	LDS	BX,DWORD PTR CORPTR	;get pointer to CORTAb
	MOV	SI,WORD PTR [BX+SHDO_OFST] ;point to SHADOW_TBL ptr in CORTAb
	XOR	AH,AH
	MOV	AL,CS:BYTE PTR MNODE	;get the masters node number
	ROL	AX,1			;convert master node nbr to tbl offset
	ADD	SI,AX
	MOV	BYTE PTR [SI],DT_MASTER ;set drive type to master
	MOV	AL,CS:BYTE PTR SNODE	;get the masters mate
	MOV	BYTE PTR [SI+1],AL	;set the mate number for the master
	POP	DS
;
;    Now send the command to the SLAVE drive.
;
	MOV	AL,BYTE PTR SNODE	; Get node number to talk to (slave)
	MOV	SI,OFFSET SHADOWSLV	; Omninet command
	MOV	AH,BYTE PTR MNODE	; Get the address of the master drive
	MOV	MSTADDR,AH		; Load the master address
	MOV	CX,3			; Number of bytes to send
	MOV	DX,0			; Number of bytes to receive
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries
	MOV	AH,1			; ROM command
	PUSH	CS			;
	CALL	CRVIO			;
	CMP	AX,0			;
	JZ	SS200			;
	MOV	DX,OFFSET SLAVERR	;
	CALL	ERRCON			;
	JMP	SSEND
;
;    Now change SHADOW_TBL in CORDRV to update the SLAVE.
;
SS200:	PUSH	DS
	LDS	BX,DWORD PTR CORPTR	;get pointer to CORTAb
	MOV	SI,WORD PTR [BX+SHDO_OFST] ;point to SHADOW_TBL ptr in CORTAb
	XOR	AH,AH
	MOV	AL,CS:BYTE PTR SNODE	;get the slaves node number
	ROL	AX,1			;convert slave node nbr to tbl offset
	ADD	SI,AX
	MOV	BYTE PTR [SI],DT_SLAVE	;set drive type to slave
	MOV	AL,CS:BYTE PTR MNODE	;get the slaves mate
	MOV	BYTE PTR [SI+1],AL	;set the mate number for the slave
	POP	DS
;
SSEND:	CALL	CLRWNDO 		;
	XOR	DX,DX			;ROW=1, COL=1
	CALL	POSCUR
	CALL	SCRN_NO_CLR
	RET
SSETUP	ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	NORMAL							*
;*									*
;* Function:	Change a drive back to a normal drive.			*
;*									*
;* Input:	None							*
;*									*
;* Output:	None							*
;*									*
;* Updates:	Nothing 						*
;*									*
;* Destroys:	AX, BX, DX, SI						*
;*									*
;************************************************************************
;
NORMAL	PROC	NEAR
	MOV	DX,OFFSET NMLPRMT	;which node to set normal ques
	CALL	PRNTCLR 		;
GETNML: MOV	DX,NMLPOS		;
	CALL	POSCUR			;
	CALL	GETDEC			;
	JC	SHORT NMLEND		;if carry set the exit
	CALL	VERIFY			;verify that the node is valid
	JC	SHORT GETNML		;get another answer
	MOV	BYTE PTR MNODE,AL	;Save the node number
;
;  Now send a "RESET DRIVE TO NORMAL SERVER MODE" command to the drive.
;
	MOV	AL,BYTE PTR MNODE	; Get node number to talk to.
	MOV	SI,OFFSET RESETNORML	; Omninet command
	MOV	CX,2			; Number of bytes to send
	MOV	DX,0			; Number of bytes to receive
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries
	MOV	AH,1			; ROM command
	PUSH	CS			;
	CALL	CRVIO			;
	CMP	AX,0			;
	JZ	NML100			;
	MOV	DX,OFFSET NRMLERR	;
	CALL	ERRCON			;
	JMP	NMLEND			;
;
;   Now change SHADOW_TBL in CORDRV to reflect the change.
;
NML100: PUSH	DS
	LDS	BX,DWORD PTR CORPTR	;get pointer to CORTAb
	MOV	SI,WORD PTR [BX+SHDO_OFST] ;point to SHADOW_TBL ptr in CORTAb
	XOR	AH,AH
	MOV	AL,CS:BYTE PTR MNODE	;get the node number
	ROL	AX,1			;convert node nbr to tbl offset
	ADD	SI,AX
	MOV	BYTE PTR [SI],DT_NORMAL ;set drive type to NORMAL
	MOV	BYTE PTR [SI+1],DT_OFFLINE ;set the mate number to OFFLINE
	POP	DS
;
NMLEND: CALL	CLRWNDO 		;
	XOR	DX,DX			;ROW=1, COL=1
	CALL	POSCUR
	CALL	SCRN_NO_CLR
	RET
NORMAL	ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	COMPAR							*
;*									*
;* Function:	Compare two drives to see if they are identical 	*
;*									*
;* Input:	None							*
;*									*
;* Output:	None							*
;*									*
;* Updates:	Nothing 						*
;*									*
;* Destroys:	AX, BX, CX, DX, DI, SI					*
;*									*
;************************************************************************
;
COMPAR	PROC	NEAR
	CALL	CLRWNDO
	MOV	DX,CMDWND
	CALL	POSCUR
	MOV	DX,OFFSET CMPPRMT	;put up the compare question
	CALL	PRNTCLR 		;
CMP020: MOV	DX,CMPPOS1		;
	CALL	POSCUR			;
	CALL	GETDEC			;
	JNC	SHORT CMPCONT		;if carry set then exit
	JMP	CMPEND2
CMPCONT:
	CALL	VERIFY			;verify that the node is valid
	JC	SHORT CMP020		;get another answer
	CALL	CHK_NRML		;Is the drive in normal mode?
	JC	SHORT CMP020		;No, then get another answer
	MOV	BYTE PTR NODE1,AL	;save the value
	MOV	DX,ERRLINE
	CALL	CLREOL			;clear any error messages
CMP040: MOV	DX,CMPPOS2		;
	CALL	POSCUR			;
	CALL	GETDEC			;
	JNC	SHORT CMPCONT2		;if carry set then exit
	JMP	CMPEND2
CMPCONT2:
	CALL	VERIFY			;verify that the node is valid
	JC	SHORT CMP040		;get another answer
	CALL	CHK_NRML		;Is the drive in normal mode?
	JC	SHORT CMP040		;No, then get another answer
	CMP	AL,BYTE PTR NODE1	;can't compare node with itself
	JNE	SHORT CMP060
	MOV	DX,CMPPOS2
	CALL	POSCUR
	CALL	CLREOL			;delete the characters just entered
	MOV	DX,ERRLINE
	CALL	CLREOL			;clear the error line before displaying
	CALL	POSCUR
	MOV	DX,OFFSET NODERR2
	CALL	PRNTCLR 		;
	JMP	CMP040
CMP060: MOV	DX,ERRLINE
	CALL	CLREOL
	MOV	BYTE PTR NODE2,AL	;save the value
;
; Make sure the two drives are the same size.  If not, then we connot continue.
;
	CALL	CMPSIZ
	JC	COMPAR
;
; Put up template for sizes.
;
	CALL	TEMPLT
	MOV	DX,SCTRSZ2		;cursor position to print sector nbr
	CALL	POSCUR
;
; See how many sectors to read.  Read block 8 and then find the highest
; sector used by a volume.
;
	CALL	NBRBLKS 		;d, and msb_lsb are returned
	CALL	SHOSIZ
;
; Disable the Print screen fuction until the copy has completed.
;
	CALL	DSABL_PrtSc
;
; Find out if a PIPE volume exists.  If it does then we sill skip over
; it during the compare.
;
	MOV	PIPEVOL,FALSE
	MOV	PVOLSTRT_HI,0		;Init starting sector number to 0.
	MOV	PVOLSTRT_LO,0
	MOV	PVOLEND_HI,0		;Init ending sector number to 0.
	MOV	PVOLEND_LO,0
	CALL	FND_PIPE_VOL		;Carry flag set if vol not found.
	JC	DO_CMP
	JNS	GT_ADDRES		;Did an error occure? No then jump
	JMP	CMPERR1 		;
GT_ADDRES:
	MOV	PIPEVOL,TRUE
	MOV	PVOLSTRT_HI,BL		;Set the starting sector number.
	MOV	PVOLSTRT_LO,AX
	MOV	PVOLEND_HI,DL		;Set the ending sector number.
	MOV	PVOLEND_LO,CX
;
; Now do the actual comparing of the two drives.
;
;  First compare the Semaphore tables
;
DO_CMP: CALL	CMP_SEMA4		;Carry set if tables are not equal
	JNC	S4_OK
	JMP	NOT_EQUAL
;
;  Initialize the sector number to read, to zero.
;
S4_OK:	MOV	CX,0			;start reading at logical sector 0
	MOV	DX,1			;DL = d, CH = msb, CL = lsb
	MOV	AX,1
	PUSH	AX
;
;  First read a 512 byte sectors from NODE1.
;
;
NXTnSCTS:
	CMP	CX,8			;Do NOT compare block 8 yet, Block 8
	JNZ	NOTBLK8 		;...contains the the Drive name and
	CMP	DX,1			;...password, and the Server name and
	JNZ	NOTBLK8 		;...password along with other info.
	INC	CX
	POP	AX
	DEC	AX
	PUSH	AX
NOTBLK8:
	CMP	PIPEVOL,FALSE		;Is there a PIPE vol to skip over?
	JZ	SHO_SIZ 		;No
	CMP	PVOLSTRT_LO,CX		;Are we at the PIPE vol now?
	JNZ	SHO_SIZ 		;No
	CMP	PVOLSTRT_HI,DL		;Are we really at the PIPE vol?
	JNZ	SHO_SIZ 		;No
	MOV	PIPEVOL,FALSE		;Yes, so skip this section from now on
	MOV	CX,PVOLEND_LO		;Skip past the pipe volume
	MOV	DL,PVOLEND_HI
;
;  See if we are past the last volume after skipping the pipe vbolume.
;
	CMP	DL,d			;
	JC	SHO_SIZ 		;Carry flag set if DL < d
	JZ	TST
	JMP	CHK_BLK8
TST:	CMP	CX,msb_lsb
	JC	SHO_SIZ 		;Carry flag set if CX < msb_lsb
	JMP	CHK_BLK8
;
;  See if it is time to display which sector we are comparing.
;
SHO_SIZ:
	POP	AX
	DEC	AX			;Is it time to display what sector we
	PUSH	AX			; are on yet?
	JNZ	NO_SHOW 		;Jump if no
	POP	AX
	MOV	AX,20			;Reset counter
	PUSH	AX			;Save counter
	PUSH	DX
	MOV	DX,SCTRSZ1		;cursor position to print sector nbr
	CALL	POSCUR
	POP	DX
	CALL	SHOSIZ
NO_SHOW:
	PUSH	DX			;save the sector number to use with
	PUSH	CX			;... NODE2
	MOV	BX,OFFSET RSECTOR	;load the sector number (d, lsb, msb)
	MOV	BYTE PTR [BX],DL	;load d
	MOV	WORD PTR [BX+1],CX	;load lsb, msb
	MOV	DX,512			;number of bytes to receive
	MOV	SI,OFFSET READCMD	;address of data to send to the drive
	MOV	DI,OFFSET D1DATA	;address of buffer for data from drive1
;
NXTSCT1:
	MOV	AH,1			;cmd = Xmit/Recv data to network srvr
	MOV	AL,BYTE PTR NODE1	;get the node number
	MOV	CX,4			;number of bytes to transmit
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries
	CLI				;Disable interrupts
	PUSH	CS			;fake a "FAR" call
	CALL	CRVIO			;execute the command
	STI				;Enable interrupts
	OR	AL,AL			;see if command executed properly
	JZ	READ_OK
	JMP	CMPERR1
READ_OK:
	ADD	DI,512
;
;  Now read a 512 byte sectors from NODE2.
;
READ_NODE2:
	POP	CX
	POP	DX
	PUSH	DX
	PUSH	CX
	CMP	CX,8			;Do NOT compare block 8 which
	JNZ	NTBLK8			;...contains the the server name
	CMP	DX,1
	JNZ	NTBLK8
	INC	CX
NTBLK8:
	MOV	BX,OFFSET RSECTOR	;load the sector number (d, lsb, msb)
	MOV	BYTE PTR [BX],DL	;load d
	MOV	WORD PTR [BX+1],CX	;load lsb, msb
	MOV	DX,512			;number of bytes to receive
	MOV	SI,OFFSET READCMD	;address of data to send to the drive
	MOV	DI,OFFSET D2DATA	;address of buffer for data from drive2
;
NXTSCT2:
	MOV	AH,1			;cmd = Xmit/Recv data to network srvr
	MOV	AL,BYTE PTR NODE2	;get the node number
	MOV	CX,4			;number of bytes to transmit
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries
	CLI				;Disable interrupts
	PUSH	CS			;fake a "FAR" call
	CALL	CRVIO			;execute the command
	STI				;Enable interrupts
	OR	AL,AL			;see if command executed properly
	JZ	READMOR
	JMP	CMPERR1
READMOR:
	ADD	DI,512
;
;  Now compare the data
;
CMP_DATA:
	MOV	SI,OFFSET D1DATA	;stored data from 1st drive
	MOV	DI,OFFSET D2DATA	;stored data from 2nd drive
	MOV	CX,512			;Number of bytes to compare
	CLD				;
	REPE	CMPSB			;see if both strings are equal
	POP	CX
	POP	DX
	JNZ	NOT_EQUAL		;abort compare: drives NOT equal
;
;  See if at the end yet
;
	INC	CX			;increment the sector number by one
	JNZ	NO_CARRY1		;did inc result in CX wrapping to 0?
	ADD	DX,10H			;carry into DX
NO_CARRY1:
	CMP	DL,d			;compare d (the most significant digit)
	JC	SETUP_CMD1		;carry flag set if DL < BYTE PTR [DI]
	JZ	TSTWRD
	JMP	CHK_BLK8		;jump if DL > BYTE PTR [DI]
TSTWRD: CMP	CX,msb_lsb		;
	JC	SETUP_CMD1		;carry flag set if CX < WORD PTR [DI+1]
	JMP	CHK_BLK8		;if CX >= WORD PTR [DI+1] then we have
;					;... successfully compared all of the
;					;... sectors and they are equal.  Now
;					;... do block 8 (the drive info. block)
;
SETUP_CMD1:
	JMP	NXTnSCTS		;Read then compare the next sectors now
;
;  Now compare block 8 ( the drive information block) on the two drives.
;  Except don't compare the first 36 bytes of block 8 because that is where
;  the drive name & password, and server name & password are stored.
;
CHK_BLK8:				;First display the last sector number
	PUSH	DX			;...that was compared.
	MOV	DX,SCTRSZ1		;cursor position to print sector nbr
	CALL	POSCUR
	POP	DX
	CALL	SHOSIZ
	MOV	AL,BYTE PTR NODE1	;Get node number to save block 8 from
	CALL	SAVBLK8 		;Save block 8 which contains
	MOV	CX,512			;Move the block from D1DATA to D2DATA
	MOV	SI,OFFSET D1DATA
	MOV	DI,OFFSET D2DATA
	CLD
	REP	MOVSB
	MOV	AL,BYTE PTR NODE2	;Get node number to save block 8 from
	CALL	SAVBLK8 		;Save block 8 which contains
	MOV	SI,OFFSET D1DATA	;Point to the saved block 8's
	MOV	DI,OFFSET D2DATA
	ADD	SI,36			;Now point past the name junk
	ADD	DI,36
	MOV	CX,476			;Get ready to compare all but the
	CLD				;...1st 36 bytes.
	REPE	CMPSB			;See if both strings are equal
	JNZ	NOT_EQUAL		;Abort compare: drives NOT equal
	JMP	DRVS_EQUAL		;Drive are equal
;
;  Drives are not equal.  Tell the user.
;
NOT_EQUAL:
	CALL	ENABL_PrtSc		;Enable the Print Screen function now
	MOV	DX,ERRLINE		;move the cursor to the error line
	CALL	CLREOL
	MOV	DX,OFFSET NOTEQL
	CALL	PRNTCLR 		;
	MOV	DX,OFFSET CONT
	CALL	PRNTCLR 		;
	CALL	GETKYBW 		;wait for keyboard input to continue
	JMP	CMPEND
;
;  Tell user that the drives are equal.
;
DRVS_EQUAL:
	CALL	ENABL_PrtSc		;Enable the Print Screen function now
	MOV	DX,ERRLINE		;move cursor to the error/status line
	CALL	CLREOL
	MOV	DX,OFFSET EQL
	CALL	PRNTCLR 		;
	MOV	DX,OFFSET CONT
	CALL	PRNTCLR 		;
	CALL	GETKYBW 		;wait for keyboard input to continue
	JMP	CMPEND
CMPERR1:
	CALL	ENABL_PrtSc		;Enable the Print Screen function now
	POP	CX			;clean up the stack
	POP	DX			;clean up the stack
	PUSH	AX			;save the error code
	MOV	DX,ERRLINE		;move cursor to the error/status line
	CALL	POSCUR
	MOV	DX,OFFSET CMPERR
	CALL	PRNTCLR 		;
	MOV	DX,OFFSET CONT
	CALL	PRNTCLR 		;
	POP	CX			;restore AX into CX for display
	MOV	DX,1
	XOR	CH,CH
	CALL	SHOSIZ
	CALL	GETKYBW 		;wait for keyboard input to continue
;
CMPEND:
	POP	AX			;Clean up the stack before returning
CMPEND2:
	CALL	CLRWNDO 		;
	MOV	DX,TEMPOS1		;position the cursor for line 1
	CALL	POSCUR
	MOV	DX,OFFSET TEMSTR1	;draw line 1 of the template
	CALL	PRNTCLR 		;
	CALL	ENABL_PrtSc		;Make sure Print Screen function has
;					; been enabled.
	RET
COMPAR	ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	DRVCPY							*
;*									*
;* Function:	Copy one drive onto another.				*
;*									*
;* Input:	None							*
;*									*
;* Output:	None							*
;*									*
;* Updates:	Nothing 						*
;*									*
;* Destroys:	AX, BX, CX, DX, DI, SI					*
;*									*
;************************************************************************
;
DRVCPY	PROC	NEAR
	CALL	CLRWNDO
	MOV	DX,CMDWND
	CALL	POSCUR
	MOV	DX,OFFSET CPYPRMT	;put up the copy question
	CALL	PRNTCLR 		;
CPY020: MOV	DX,CPYPOS1		;
	CALL	POSCUR			;
	CALL	GETDEC			;
	JNC	SHORT CPYCONT		;if carry set then exit
	JMP	CPYEND
CPYCONT:
	CALL	VERIFY			;verify that the node is valid
	JC	SHORT CPY020		;get another answer
	CALL	CHK_NRML		;Is the drive in normal mode?
	JC	SHORT CPY020		;No, then get another answer
	MOV	BYTE PTR NODE1,AL	;save the value
	MOV	DX,ERRLINE
	CALL	CLREOL			;clear any error messages
CPY040: MOV	DX,CPYPOS2		;
	CALL	POSCUR			;
	CALL	GETDEC			;
	JNC	SHORT CPYCONT2		;if carry set then exit
	JMP	CPYEND
CPYCONT2:
	CALL	VERIFY			;verify that the node is valid
	JC	SHORT CPY040		;get another answer
	CALL	CHK_NRML		;Is the drive in normal mode?
	JC	SHORT CPY040		;No, then get another answer
	CMP	AL,BYTE PTR NODE1	;can't compare node with itself
	JNE	SHORT CPY060
	MOV	DX,CPYPOS2
	CALL	POSCUR
	CALL	CLREOL			;delete the characters just entered
	MOV	DX,ERRLINE
	CALL	CLREOL			;clear the error line before displaying
	CALL	POSCUR
	MOV	DX,OFFSET NODERR3
	CALL	PRNTCLR 		;
	JMP	CPY040
CPY060: MOV	BYTE PTR NODE2,AL	;save the value
	MOV	DX,ERRLINE
	CALL	CLREOL
;
; Make sure the two drives are the same size.  If not, then we connot continue.
;
	CALL	CMPSIZ
	JC	DRVCPY
;
; Tell the user about how long it will take to do the drive copy.
;
	MOV	SI,OFFSET %SRVTBL
	MOV	AL,BYTE PTR NODE1
	MOV	CX,TBLSZ		;Number of entries in the table
CPY070: CMP	AL,BYTE PTR [SI]	;Is this the server we want?
	JZ	CPY080			;Yes -- then jump
	ADD	SI,ENTRYSZ		;Point to next server in the table
	DEC	CX
	JNZ	CPY070
	JMP	CPY140
CPY080: XOR	DX,DX
	MOV	DL,BYTE PTR [SI+SRVRSIZ]     ;get d
	MOV	AX,WORD PTR [SI+SRVRSIZ+1]   ;get lsb and msb
	MOV	CL,4
	SHR	DX,CL			;convert d to normal number
	MOV	BX,TWOK 		;divide it by 2k (2048)
	DIV	BX
	MOV	CX,DT_TBLSZ		;number of entries in the %DRVTBL
	MOV	DI,OFFSET %DRVTBL
CPY100: CMP	AL,BYTE PTR [DI]
	JE	CPY140
	ADD	DI,DT_ENTSIZ		;get the next entry in the table
	LOOP	CPY100
	MOV	DI,OFFSET %DRVTBL
;
CPY140: ADD	DI,DT_OUTPUT		;point to the output string in the tbl
	MOV	BX,OFFSET CPYMSG	;point to the output line
	INC	BX			;Skip over color byte
	MOV	AL,[DI]
	MOV	BYTE PTR [BX+62],AL	;load the number of minutes it could
	MOV	AL,[DI+1]		;... take to do the copy. (maximum)
	MOV	BYTE PTR [BX+63],AL
	XOR	AX,AX
	MOV	AL,BYTE PTR NODE1
	CALL	CNVRT_SRVR		;Convert the node number to ascii
	MOV	BYTE PTR [BX+22],AH
	MOV	BYTE PTR [BX+23],AL
	XOR	AX,AX
	MOV	AL,BYTE PTR NODE2
	CALL	CNVRT_SRVR		;Convert the node number to ascii
	MOV	BYTE PTR [BX+35],AH
	MOV	BYTE PTR [BX+36],AL
;
CPY160: CALL	CLRWNDO
	MOV	DX,CMDWND
	CALL	POSCUR
	MOV	DX,OFFSET CPYMSG	;Output the line
	CALL	PRNTCLR 		;
;
; Set up for input
;
	MOV	BYTE PTR %ECHO,0	;Echo the character
	MOV	BYTE PTR %MAXCHR,1	;Allow one character for input
	MOV	DX,OFFSET %MAXCHR	;
	MOV	BYTE PTR %NUMBER,0	;Allow all ascii characters
	CALL	BUFIN			;Get the response
	JNC	TRY_Y
	JMP	CPYEND
TRY_Y:	CMP	BYTE PTR %INBUFF,"Y"
	JZ	CPY180
	CMP	BYTE PTR %INBUFF,"y"
	JZ	CPY180
	CMP	BYTE PTR %INBUFF,"N"
	JNZ	TRY_n
	JMP	CPYEND
TRY_n:	CMP	BYTE PTR %INBUFF,"n"
	JNZ	CPY160
	JMP	CPYEND
;
; Now do the copy
;
;   First copy the Semaphore table
;
CPY180: CALL	CPY_SEMA4
	MOV	AH,1
	JC	COPY_ERROR		;Did an error occure while copying
					;... the semaphore table?
;
;   Now copy the rest of the drive
;
	MOV	DX,CMDWND
	INC	DH
	CALL	CLREOL
	MOV	DX,OFFSET COPYING	;Output the line
	CALL	PRNTCLR 		;
	MOV	AL,BYTE PTR NODE2	;Get node number to save block 8 from
	CALL	SAVBLK8 		;Save block 8 which contains
	MOV	AH,1
	OR	AL,AL			;... the server name.
	JNZ	COPY_ERROR
	MOV	CX,36			;Save the 1st 36 bytes of block 8
	MOV	SI,OFFSET D1DATA	;...which contain the Drive name &
	MOV	DI,OFFSET DRV_SRVR_NAMES ;..password, and the Server name &
	CLD
	REP	MOVSB			;...password.
;
	CALL	DSABL_PrtSc		;Disable the Print Screen function now
	CALL	MOVEIT			;Move the data from 1 drive to another.
	CALL	ENABL_PrtSc		;Enable the Print Screen function now
	CMP	AX,0			;AX = zero if no errors
	JZ	CPY_SUCCESS
	JMP	COPY_ERROR		;Error occured tell user
;
CPY_SUCCESS:
	MOV	AL,BYTE PTR NODE1	;Get node # to save NEW block 8 from
	CALL	SAVBLK8 		;Save block 8 which contains
	OR	AL,AL			;... the server name.
	JNZ	COPY_ERROR
	MOV	CX,36			;Restore the 1st 36 bytes of the OLD
	MOV	DI,OFFSET D1DATA	;...block 8 which contain the Drive
	MOV	SI,OFFSET DRV_SRVR_NAMES ;..name & password, and the Server
	CLD
	REP	MOVSB			;...name & password.
	CALL	RSTBLK8 		;Restore block 8
;
;  Tell user that the copy was successfull
;
	MOV	DX,ERRLINE		;move cursor to the error/status line
	CALL	CLREOL
	MOV	DX,OFFSET CPYOK
	CALL	PRNTCLR 		;
	MOV	DX,OFFSET CONT
	CALL	PRNTCLR 		;
	CALL	GETKYBW 		;wait for keyboard input to continue
	JMP	CPYEND
;
;  An error occured.  Tell the user
;
COPY_ERROR:
	PUSH	AX			;save the error number to display
	MOV	DX,ERRLINE		;move cursor to the error/status line
	CALL	CLREOL
	POP	AX
	PUSH	AX
	XOR	AL,AL
	XCHG	AH,AL
	DEC	AL
	MUL	ERR_LENGTH		;Get offset from first error message
	MOV	DX,OFFSET CPYERR1	;Point to the first error message
	ADD	DX,AX			;Now point to the correct error message
	CALL	PRNTCLR 		;
	MOV	DX,OFFSET CONT
	CALL	PRNTCLR 		;
	POP	CX			;restore AX into CX for display
	XOR	CH,CH			;Only print the low byte
	MOV	DX,1
	CALL	SHOSIZ
	CALL	GETKYBW 		;wait for keyboard input to continue
;
CPYEND: CALL	CLRWNDO 		;
	RET
DRVCPY	ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	NEWPASWRD						*
;*									*
;* Function:	Allow the user to change the password.			*
;*									*
;* Input:								*
;*									*
;* Output:								*
;*									*
;* Updates:								*
;*									*
;* Destroys:								*
;*									*
;* Note - The password scheme has a "BACKDOOR" that will allow CORVUS   *
;*	  to enter the SINIT menu without knowledge of the users	*
;*	  password.  The key to the backdoor follows:			*
;*									*
;*	     CTRL - PgDn, CTRL - PgUp, CTRL - Home, CTRL - End		*
;*									*
;*	  The preceeding key is CORVUS proprietary and SHOULD NOT	*
;*	  be disclosed. 						*
;*									*
;************************************************************************
;
NEWPASWRD	PROC	NEAR
	CALL	CLRWNDO 		;Clear the command window
	MOV	DX,CMDWND
	CALL	POSCUR			;Position the cursor
	MOV	DX,OFFSET PSWQUES	;
	CALL	PRNTCLR 		;
;
;  Get the new password
;
	CALL	BLANKBUF		;Fill the buffer with blanks
	MOV	DX,PSWPOS1
	CALL	POSCUR
	MOV	BYTE PTR %ECHO,-1	;Do not echo the input characters
	MOV	BYTE PTR %MAXCHR,8	;Allow 8 characters for the password
	MOV	BYTE PTR %NUMBER,0	;Tell BUFIN to allow any ASCII char
	MOV	DX,OFFSET %MAXCHR	;Point to the input buffer
	CALL	BUFIN			;Get the new password
	JNC	NP0050			;Any characters input? Yes then cont.
	JMP	NP9000			;No then exit.
;
;  Save the password
;
NP0050: MOV	CX,8
	MOV	SI,OFFSET %INBUFF	;Point to the password
	MOV	DI,OFFSET SAVPSW	;Point to the saved area
	CLD
	REP	MOVSB			;Move the data
;
;  Now make the user enter the new password in again and check
;  it with the previous one to make sure they entered it properely
;
	MOV	DX,CMDWND
	INC	DH
	CALL	POSCUR			;Position the cursor
	MOV	DX,OFFSET PSWQES2	;
	CALL	PRNTCLR 		;
	CALL	BLANKBUF		;Fill the buffer with blanks
	MOV	DX,PSWPOS2
	CALL	POSCUR
	MOV	BYTE PTR %ECHO,-1	;Do not echo the input characters
	MOV	BYTE PTR %MAXCHR,8	;Allow 8 characters for the password
	MOV	BYTE PTR %NUMBER,0	;Tell BUFIN to allow any ASCII char
	MOV	DX,OFFSET %MAXCHR	;Point to the input buffer
	CALL	BUFIN			;Get the new password again
;
;  Compare the two passwords just entered.  If they are equal then
;  continue else make the user reenter them.
;
	MOV	CX,8
	MOV	SI,OFFSET SAVPSW	;Get the first password
	MOV	DI,OFFSET %INBUFF	;Get the second password
	CLD
	REPZ	CMPSB			;Compare them until they are not equal
	JZ	NP0100			;Jump if they are the same
	MOV	DX,OFFSET PNOMTCH	;Display the error message
	CALL	ERRCON
	JMP	NEWPASWRD		;Get the password again
;
;  Encrypt the new password.
;
NP0100: MOV	SI,OFFSET %INBUFF	;Encrypt the entered password
	MOV	DI,OFFSET %CRYPPSW
	CALL	PSWENCRYPT
;
;  Save the new password back onto disk. (Open file SINIT.COM)
;
	MOV	DX,OFFSET FILENM	;Get the name of the file to open
	MOV	AL,2			;Open the file for Read/Write
	MOV	AH,03DH 		;Function to Open a file handle
	INT	21H			;DOS call
	JNC	NP0180			;Carry set if error
	CMP	AX,2			;File not found error?
	JNZ	NP0160			;No -- then jump
	MOV	DX,OFFSET FLNOTFND
	CALL	ERRCON
	JMP	NP9000
NP0160: MOV	DX,OFFSET OPENERR	;Misc. open error message
	CALL	ERRCON
	JMP	NP9000
;
;  File opened successfully
;
NP0180: MOV	FILEHANDL,AX		;Save the file handle
;
;  Read the files date and time stamp and save it.
;
	MOV	DATTIM,-1		;Default to error on get date & time
	MOV	BX,FILEHANDL		;Get the file's handle
	MOV	AH,057H 		;Funct. to Get/Set a file's date & time
	XOR	AL,AL			;  Get the date & time
	INT	21H			;DOS call
	JC	NP0190			;Carry set if error
	MOV	DATE,DX 		;Save the date
	MOV	TIME,CX 		;Save the time
	MOV	DATTIM,0		;Get date & time success
;
;  Read the encrypted password saved in the file.
;
NP0190: MOV	BX,FILEHANDL		;Get the file handle
	MOV	CX,RDBUF_SIZ		;Number of bytes to read
	MOV	DX,OFFSET RDWRBUF	;Location to put the data
	MOV	AH,03FH 		;Function to read from a file
	INT	21H			;DOS call
	JC	NP0200			;Carry set if error
	CMP	AX,RDBUF_SIZ		;Did I get the number of bytes I wanted
	JZ	NP0220			;Yes -- then jump
NP0200: MOV	DX,OFFSET RDWRERR	;No -- then error message
	CALL	ERRCON
	JMP	NP5000
NP0220:
	MOV	CX,RDBUF_SIZ
	PUSH	DS
	POP	ES			;ES:DI needs to point to the buffer
	MOV	DI,OFFSET RDWRBUF
	MOV	AL,"C"                  ;Look for 1st char in string "Corvus"
	CLD
	REPNE	SCASB			;Find the character in the buffer
	JNZ	NP0200
	MOV	CX,5			;Number of characters left to compare
	MOV	SI,OFFSET CORVUS_STRING
	INC	SI			;Point past first character.
	CLD
	REPE	CMPSB
	JNZ	NP0200			;Jump if not equal
	MOV	SI,OFFSET %CRYPPSW	;
	MOV	CX,8			;Now load the new password into
	CLD
	REP	MOVSB			;...the buffer to write
;
;  Reset the read/write pointer to the beginning of the file again
;
	MOV	BX,FILEHANDL		;Get the file handle
	XOR	CX,CX			;Set offset to 0 (most sig. word)
	MOV	DX,CX			;Set offset to 0 (least sig. word)
	MOV	AX,4200H		;Function to reset read/write pointer
	INT	21H			;DOS call
;
;  Write the new password out.
;
	MOV	BX,FILEHANDL		;Get the file handle
	MOV	CX,RDBUF_SIZ		;number of bytes to write
	MOV	DX,OFFSET RDWRBUF
	MOV	AH,040H 		;Function to write to the file
	INT	21H			;DOS call
	CMP	AX,RDBUF_SIZ
	JNZ	NP0200
;
;  Reset the files date and time stamp.
;
NP5000: CMP	DATTIM,0		;Success getting the date & time stamp?
	JNZ	NP5100			;No -- then jump
	MOV	BX,FILEHANDL		;Get the file's handle
	MOV	AH,057H 		;Funct. to Get/Set a file's date & time
	MOV	AL,1			;  Set the date & time
	MOV	DX,DATE 		;Set the date
	MOV	CX,TIME 		;Set the time
	INT	21H			;DOS call
;
;  Close the file handle now
;
NP5100: MOV	BX,FILEHANDL
	MOV	AH,03EH 		;Function to close a file handle
	INT	21H			;DOS call
;
NP9000: CALL	CLRWNDO 		;Clear the command window
	RET

NEWPASWRD	ENDP
;
;
;
;
;************************************************************************
;*									*
;* Subroutine:	NBRBLKS 						*
;*									*
;* Function:	Find the largest block number actually used on the	*
;*		disk and save it.  COPY and COMPARE will use this	*
;*		value to work with instead of doing the entire disk.	*
;*									*
;* Input:								*
;*									*
;* Output:	DL, CX	--> highest block number used on the drive	*
;*									*
;* Updates:	d, and msb_lsb						*
;*									*
;* Destroys:	AX, BX, CX, DX, DI, SI					*
;*									*
;************************************************************************

NBRBLKS PROC	NEAR
	MOV	d2,1
	MOV	msb_lsb2,0
	MOV	AL,BYTE PTR NODE1	;Get node number to save block 8 from
	CALL	SAVBLK8 		;Save block 8
	MOV	SI,OFFSET D1DATA	;Point to saved block 8
	MOV	CX,WORD PTR [SI+DVblks] ;Size of the VOLUME TABLE
	XCHG	CH,CL			;Switch the bytes
	MOV	DRVVOLTBL_SIZ,CX
	MOV	DX,WORD PTR [SI+DVaddr] ;Point to the VOLUME TABLE
	MOV	CL,4
	ROL	DL,CL
	INC	DL
	MOV	CX,WORD PTR [SI+DVaddr+2] ;Point to the VOLUME TABLE
	XCHG	CH,CL			;Switch the bytes
;					;Load the sector number (d, lsb, msb)
	MOV	d,DL			;Save d
	MOV	msb_lsb,CX		;Save lsb, msb
	MOV	FRSTBLK,1		;Skip the 1st entry in the first block
;
RD_BLK: MOV	BX,OFFSET RSECTOR	;Load the sector number (d, lsb, msb)
	MOV	BYTE PTR [BX],DL	;Load d
	MOV	WORD PTR [BX+1],CX	;Load lsb, msb
;
	MOV	DX,512			;number of bytes to receive
	MOV	SI,OFFSET READCMD	;address of data to send to the drive
	MOV	DI,OFFSET D2DATA	;address of buffer for data from drive1
	MOV	AH,1			;cmd = Xmit/Recv data to network srvr
	MOV	AL,BYTE PTR NODE1	;get the node number
	MOV	CX,4			;number of bytes to transmit
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries
	PUSH	CS			;fake a "FAR" call
	CALL	CRVIO			;execute the command
	OR	AL,AL			;see if command executed properly
	JZ	GOT_VOLTBL
	MOV	d2,1			;Error occured
	MOV	msb_lsb2,0
	JMP	ENDTBL
GOT_VOLTBL:
	XOR	BX,BX
	MOV	SI,OFFSET D2DATA
	CMP	FRSTBLK,0		;Is this the 1st entry of the 1st block
	JZ	NO_SKIP 		;No, so don't skip it
	PUSH	BX
NXT_ENTRY:
	POP	BX
	ADD	BX,32			;1st 32 bytes of 1st block are reserved
NO_SKIP:
	CMP	BX,511			;Have we examined all 16 entries in this
	JLE	CHK_FOR_END		;...block.  If have then get next block
	INC	msb_lsb
	JNZ	NO_CARRY
	INC	d
NO_CARRY:
	MOV	DL,d
	MOV	CX,msb_lsb
	MOV	FRSTBLK,0
	DEC	DRVVOLTBL_SIZ		;See if any blocks left to check
	JZ	ENDTBL
	JMP	RD_BLK
;
;  See if the entry is unused or the end of the table.	If it
;  is the end of the table then stop looking for more.	The end
;  of the table is signified by 32 bytes of 0FFH while an unused
;  entry contains 32 bytes of 00H.
;
CHK_FOR_END:
	MOV	CX,16			;32 byte per entry
	PUSH	BX
CHKWRD: CMP	WORD PTR [SI+BX],0FFFFH
	JNZ	TRY00
	ADD	BX,2			;Point to the next word
	LOOP	CHKWRD
	JMP	ENDTBL_CLN
TRY00:	POP	BX
	PUSH	BX
	MOV	CX,16
LOOK00: CMP	WORD PTR [SI+BX],0
	JNZ	SAVE_ADDR
	ADD	BX,2			;Point to the next word
	LOOP	LOOK00
	JMP	NXT_ENTRY
SAVE_ADDR:
	POP	BX
	PUSH	BX
	MOV	DX,WORD PTR [SI+BX+Endblk]
	MOV	CX,WORD PTR [SI+BX+Endblk+2]
	XCHG	DH,DL			   ;Convert from DWORD format to 2 WORDS
	XCHG	CH,CL
	PUSH	CX
	MOV	CL,4
	ROL	DL,CL
	POP	CX
	INC	DL
;
;  If the sector number is less than one we are already saving
;  then skip it and look for the next volume ending sector number.
;
	CMP	DL,d2				;1st check the high order byte
	JL	NO_SAVEIT			;If less, then skip it.
	JG	SAVEIT				;If greater, then save it.
	CMP	CX,msb_lsb2			;Now compare the low order word
	JL	NO_SAVEIT			;If less, then skip it else save
SAVEIT: MOV	d2,DL
	MOV	msb_lsb2,CX
NO_SAVEIT:
	JMP	NXT_ENTRY			;See if any more volumes
;
;  Set up the return values
;
ENDTBL_CLN:
	POP	BX			;Clean up the stack
ENDTBL: XOR	DX,DX
	MOV	DL,d2
	MOV	CX,msb_lsb2
	MOV	d,DL
	MOV	msb_lsb,CX
	RET
NBRBLKS ENDP
;
;
;
;
;************************************************************************
;*									*
;* Subroutine:	SAVBLK8 						*
;*									*
;* Function:	Save block 8 of the drive.  Block 8 contains the	*
;*		SERVERNAME, SERVERPASSWORD, DRIVENAME, DRIVEPASSWORD	*
;*									*
;* Input:	AL = Server # to read block 8 from			*
;*									*
;* Output:	AL = status of the command				*
;*									*
;* Updates:								*
;*									*
;* Destroys:	AX, BX, CX, DX, SI, DI					*
;*									*
;************************************************************************
;
SAVBLK8 PROC	NEAR
	MOV	BX,OFFSET RSECTOR
	MOV	BYTE PTR [BX],1 	;Drive 1
	MOV	WORD PTR [BX+1],8	;Block 8
	MOV	SI,OFFSET READCMD	;address of data to send to the drive
	MOV	DI,OFFSET D1DATA	;address of buffer for data from drive1
	MOV	AH,1			;cmd = Xmit/Recv data to network srvr
	MOV	CX,4			;number of bytes to transmit
	MOV	BX,WORD PTR XMITDESC	;BL = wait, BH = retries
	MOV	DX,512			;Number of bytes wanted back
	PUSH	CS			;fake a "FAR" call
	CALL	CRVIO			;execute the command
	RET
SAVBLK8 ENDP
;
;
;
;
;************************************************************************
;*									*
;* Subroutine:	RSTBLK8 						*
;*									*
;* Function:	Restore block 8 of the drive.  Block 8 contains the	*
;*		SERVERNAME, SERVERPASSWORD, DRIVENAME, DRIVEPASSWORD	*
;*									*
;* Input:								*
;*									*
;* Output:	AL = status of the command				*
;*									*
;* Updates:								*
;*									*
;* Destroys:	AX, BX, CX, DX, SI, DI					*
;*									*
;************************************************************************
;
RSTBLK8 PROC	NEAR
	MOV	BX,OFFSET WSECTOR
	MOV	BYTE PTR [BX],1 	;Drive 1
	MOV	WORD PTR [BX+1],8	;Block 8
	MOV	SI,OFFSET WRITECMD	;address of data to send to the drive
	MOV	AH,1			;cmd = Xmit/Recv data to network srvr
	MOV	AL,BYTE PTR NODE2	;get the node number
	MOV	CX,516			;number of bytes to transmit
	MOV	BX,WORD PTR XMITDESC	;BL = wait, BH = retries
	MOV	DX,0			;Number of bytes wanted back
	PUSH	CS			;fake a "FAR" call
	CALL	CRVIO			;execute the command
	RET
RSTBLK8 ENDP
;
;
;
;
;************************************************************************
;*									*
;* Subroutine:	CHK_NRML						*
;*									*
;* Function:	Make sure a drive is in the NORMAL mode.		*
;*									*
;* Input:	AL = Drive to check					*
;*									*
;* Output:	CARRY FLAG SET --> Drive type is not set to normal.	*
;*									*
;* Updates:								*
;*									*
;* Destroys:								*
;*									*
;************************************************************************
;
CHK_NRML	PROC	NEAR
	PUSH	AX
	PUSH	DX
	XOR	DX,DX			;Initialize DX to 0
	MOV	DL,AL			;Setup to check the drive
	CALL	GET_STATUS
	CMP	DL,DT_NORMAL		;Drive type = normal?
	JZ	DRV_NRML		;Yes, so clear the carry flag and exit
;
	MOV	DX,ERRLINE
	CALL	CLREOL			;Clear the error line before displaying
	MOV	DX,OFFSET NOTNRML	;Message to display
	CALL	PRNTCLR
	STC				;Indicates an error DID occure
	JMP	CHKEND
DRV_NRML:
	CLC				;Indicates an error DID NOT occure
CHKEND: POP	DX
	POP	AX
	RET
CHK_NRML	ENDP
;
;
;
;
;************************************************************************
;*									*
;* Subroutine:	CMP_SEMA4						*
;*									*
;* Function:	Compare the semaphore tables for two drives.		*
;*									*
;* Input:	NODE1, NODE2 --> The two drives to compare semaphores	*
;*									*
;* Output:	CARRY FLAG SET --> Semaphore tables are NOT the same.	*
;*									*
;* Updates:								*
;*									*
;* Destroys:	AX, BX, CX, DX, SI, DI					*
;*									*
;************************************************************************
;
CMP_SEMA4	PROC	NEAR
;
;  Read the semaphore table for drive NODE1
;
	MOV	SI,OFFSET READ_SEMA4		; Data to send to the drive
	MOV	DI,OFFSET S4TBL1		; Data back from the drive
	MOV	CX,5				; Send 5 bytes to the drive
	MOV	DX,256				; Number of bytes wanted back
	MOV	AL,BYTE PTR NODE1		; Node number to talk to
	MOV	BX,0301H			; Three tries about a sec. wait
	MOV	AH,1				; Rom command
	PUSH	CS				; Fake a FAR call
	CALL	CRVIO
;
;  Read the semaphore table for drive NODE2
;
	MOV	SI,OFFSET READ_SEMA4		; Data to send to the drive
	MOV	DI,OFFSET S4TBL2		; Data back from the drive
	MOV	CX,5				; Send 5 bytes to the drive
	MOV	DX,256				; Number of bytes wanted back
	MOV	AL,BYTE PTR NODE2		; Node number to talk to
	MOV	BX,0301H			; Three tries about a sec. wait
	MOV	AH,1				; Rom command
	PUSH	CS				; Fake a FAR call
	CALL	CRVIO
;
;  Compare the two semaphore tables.  If they are equal then clear the
;  carry flag, if they differ then set the carry flag.
;
	MOV	CX,256				; Number of bytes to compare
	MOV	SI,OFFSET S4TBL1		; Compare table 1 with table 2
	MOV	DI,OFFSET S4TBL2
	CLD
	REPZ	CMPSB				; Repeat as long as tbls are =
	JZ	CS4100				; Jump if tables are equal
	STC					; Tbls not equal set carry flag
	JMP	CS4200				; Now exit this subroutine
CS4100: CLC					; Tbls equal, clear carry flag
;
;  Restore saved registers and exit
;
CS4200: RET
;
CMP_SEMA4	ENDP
;
;
;
;
;************************************************************************
;*									*
;* Subroutine:	CPY_SEMA4						*
;*									*
;* Function:	Copy the semaphore table from NODE1 to NODE2.		*
;*									*
;* Input:	NODE1, NODE2 --> The two drives to copy from and to.	*
;*									*
;* Output:	CARRY FLAG SET --> Error copying the semaphore table.	*
;*									*
;* Updates:								*
;*									*
;* Destroys:	AX, BX, CX, DX, SI, DI					*
;*									*
;************************************************************************
;
CPY_SEMA4	PROC	NEAR
;
;  Read the semaphore table for drive NODE1
;
	MOV	SI,OFFSET READ_SEMA4		; Data to send to the drive
	MOV	DI,OFFSET S4TBL1		; Data back from the drive
	MOV	CX,5				; Send 5 bytes to the drive
	MOV	DX,256				; Number of bytes wanted back
	MOV	AL,BYTE PTR NODE1		; Node number to talk to
	MOV	BX,0301H			; 3 tries about a second wait
	MOV	AH,1				; Rom command
	PUSH	CS				; Fake a FAR call
	CALL	CRVIO
;
;  Initialize the semaphore table for drive NODE2.
;
	MOV	SI,OFFSET INIT_SEMA4		; Data to send to the drive
	MOV	CX,5				; Send 5 bytes to the drive
	MOV	DX,0				; Number of bytes wanted back
	MOV	AL,BYTE PTR NODE2		; Node number to talk to
	MOV	BX,0301H			; 3 tries about a second wait
	MOV	AH,1				; Rom command
	PUSH	CS				; Fake a FAR call
	CALL	CRVIO
;
;  Write the semaphore table to drive NODE2.  If everything goes ok then
;  clear the carry flag, if an error occures then set the carry flag.
;
	MOV	CX,32				; Total # of sema4's in table
	MOV	BX,OFFSET S4TBL1		; Get starting point
CPYS4_10:
	PUSH	CX				; Save # of sema4's left
	MOV	CX,8				; Number of bytes per semaphore
	XOR	SI,SI
	XOR	AX,AX				; Initialize AX to 0
CPYS4_20:
	MOV	AL,[BX] 			; Get next byte of the sema4
	MOV	BYTE PTR S4NAME [SI],AL 	; Save the byte
	CMP	AL,20H				; Make sure the sema4 name is
	JZ	CPYS4_40			; ... not all blanks.
	MOV	AH,1				; AH=1 then not all blanks
CPYS4_40:
	INC	BX				; Point to next position in
	INC	SI				; ... the two buffers
	LOOP	CPYS4_20			; Copy all 8 bytes
	CMP	AH,1				; If AH=1 then lock the sema4
	JZ	CPYS4_60
	POP	CX				; Fix the stack
	JMP	CPYS4_80
;
CPYS4_60:
	PUSH	BX				; Save the pointer to nxt sema4
	MOV	SI,OFFSET LOCK_SEMA4		; Data to send to the drive
	MOV	DI,OFFSET S4TBL2		; Data back from the drive
	MOV	CX,10				; Send 10 bytes to the drive
	MOV	DX,12				; Number of bytes wanted back
	MOV	AL,BYTE PTR NODE2		; Node number to talk to
	MOV	BX,0301H			; 3 tries about a second wait
	MOV	AH,1				; Rom command
	PUSH	CS				; Fake a FAR call
	CALL	CRVIO
	POP	BX
	POP	CX				; How many sema4's are left
	CMP	AL,0				; Did all go OK?
	JNZ	CPYS4_SC			; No, so set carry and exit
	CMP	BYTE PTR S4TBL2,0		; Did we lock the sema4?
	JNZ	CPYS4_SC			; No, so set carry and exit
CPYS4_80:
	LOOP	CPYS4_10			; Do all 32 semaphores
	JMP	CPYS4_CC			; Everything is ok so exit
;
;  Set the carry flag and then exit (error return)
;
CPYS4_SC:
	STC
	JMP	CPYS4_END
;
;  Clear the carry flag and then exit (normal return)
;
CPYS4_CC:
	CLC
;
;  Restore saved registers and exit
;
CPYS4_END:
	RET
;
CPY_SEMA4	ENDP
;
;
;
;
;************************************************************************
;*									*
;* Subroutine:	MOVEIT							*
;*									*
;* Function:	Move data from source to destination.			*
;*									*
;* Input:								*
;*									*
;* Output:								*
;*									*
;* Updates:								*
;*									*
;* Destroys:								*
;*									*
;************************************************************************
;
MOVEIT	PROC	NEAR
;
;  Setup the host and destination data
;
	MOV	AL,BYTE PTR NODE1
	MOV	LSHOST,AL			;Get the host node number
	MOV	LSDRIVE,1			;Set host drive # to 1
;
	MOV	AL,BYTE PTR NODE2
	MOV	LDHOST,AL			;Get the dest node number
	MOV	LDDRIVE,1			;Set dest drive # to 1
;
;  Determine how many sectors to transfer.  Read block 8 and then find
;  the highest sector used by a volume.
;
	CALL	NBRBLKS 			;d, and msb_lsb are returned
;						;...as well as DL, CX
	MOV	AX,CX
	AND	DL,11110000B			;Since the sign bit of the low
	MOV	CL,3				;...low word can be pushed into
	SHR	DL,CL				;...the high word then strip off
;						;...the drive number passed back
;						;...in DL and then shift the
	MOV	CX,AX				;...byte 3 bits to the right.
	AND	CH,10000000B			;Push the sign bit into the
	CMP	CH,10000000B			;...high word
	JNZ	MOV100
	ADD	DL,1
	AND	AH,01111111B
MOV100: MOV	LSCNTH,DX
	MOV	LDCNTH,DX
	MOV	LSCNTL,AX
	MOV	LDCNTL,AX
;
;  Start with sector 0
;
	MOV	LSADDH,0
	MOV	LSADDL,0
	MOV	LDADDH,0
	MOV	LDADDL,0
;
;  Now setup the opcode
;
	MOV	AX,1
;
;  Load the RAM address
;
	MOV	BX,OFFSET D1DATA
;
;  Load the DEBUG address
;
	MOV	DI,OFFSET D2DATA
	MOV	WORD PTR [DI],0 		;Tell CDMOVE to NOT use the
	MOV	CX,DI				;...DEBUG buffer.
;
;  Load the command spec record address
;
	MOV	DX,OFFSET CMDSTR
;
;  Now do the transfer
;
	CALL	CDMOV
	RET
MOVEIT	ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	VERIFY							*
;*									*
;* Function:	Verify that the node passed in AX exists and that	*
;*		it contains the shadow prom.				*
;*									*
;* Input:	AL = node number					*
;*									*
;* Output:	Sets the carry flag if node not found or no shadow prom *
;*									*
;* Updates:	Nothing 						*
;*									*
;* Destroys:	All registers preserved 				*
;*									*
;************************************************************************
;
VERIFY	PROC	NEAR
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
;
	MOV	BX,OFFSET %SRVTBL	;point to table
	MOV	CX,WORD PTR %NUMOD	;get the # of OmniDrives on the network
NXTONE: CMP	AL,BYTE PTR [BX]	;does it match?
	JE	SHORT FOUNDIT		;yes so leave loop
	ADD	BX,ENTRYSZ		;point to next entry
	LOOP	NXTONE			;try to match with the next one
	JMP	NOT_FOUND
FOUNDIT:
	XOR	DX,DX
	MOV	DL,AL			;Get the node number to check
	CALL	GET_STATUS		;Get the status of this drive
	CMP	DL,NO_SHADOW_PROM	;Does drive have the shadow prom?
	JNZ	VEROK			;Yes -- so exit subroutine
;
;  Could not find a match.  Clear answer and put up error message
;
NOT_FOUND:
	POP	DX			;get passed DX
	PUSH	DX
	CALL	CLREOL			;clear the invalid answer
	MOV	DX,ERRLINE
	CALL	CLREOL			;clear the error line before displaying
	MOV	DX,OFFSET VERERR	;display the verify error message
	CALL	PRNTCLR 		;
	STC				;set the carr flag for error return
	JMP	VERRET
;
VEROK:	CLC
VERRET: POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
VERIFY	ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	HELP							*
;*									*
;* Function:	Display the help screen 				*
;*									*
;* Input:	None							*
;*									*
;* Output:	None							*
;*									*
;* Updates:	Nothing 						*
;*									*
;* Destroys:	AH, DX							*
;*									*
;************************************************************************
;
HELP	PROC	NEAR
	MOV	AH,1			;
	CALL	DWORD PTR [VIDEO]	;
	MOV	DX,OFFSET HELPTXT	;give help
	CALL	PRNTCLR 		;
	CALL	CONTINUE		;
	CALL	SCRN			;.and display main screen
	RET				;
HELP	ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	FINDSRVR						*
;*									*
;* Function:	Find all the active servers on the NET.  Then		*
;*		send a "WHO ARE YOU" to them to find all the            *
;*		OmniDrives.						*
;*									*
;* Input:	None							*
;*									*
;* Output:	None							*
;*									*
;* Updates:	%ECHOTBL, %SRVTBL, %NUMOD				*
;*									*
;* Destroys:	BX, CX, DX, SI						*
;*									*
;************************************************************************
;
FINDSRV PROC   NEAR

	MOV	BX,OFFSET %ECHOTBL	;build table of active nodes
	MOV	CX,64			;
	MOV	DX,600H 		;DH = ECHO; DL = NODE
FSRV0:	CALL	ECHONET 		;
	INC	DL			;
	LOOP	SHORT FSRV0		;

	MOV	BX,OFFSET %SRVTBL	;send WHO ARE YOUs to active nodes
	MOV	SI,OFFSET %ECHOTBL	;
	MOV	CX,64			;
	MOV	DX,300H 		;DH = SND/RCV TO SERVER; DL = NODE
FSRV1:	CMP	BYTE PTR [SI],0FFH	;if active node do the WHO ARE YOU
	JE	SHORT FSRV2		;
	MOV	DL,BYTE PTR [SI]	;
	CALL	CHKSRV			;
FSRV2:	INC	SI			;
	LOOP	SHORT FSRV1		;

	RET				;
FINDSRV ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	DRVSIZ							*
;*									*
;* Function:	Get the size of each OmniDrive				*
;*									*
;* Input:	None							*
;*									*
;* Output:	None							*
;*									*
;* Updates:	%SRVTBL 						*
;*									*
;* Destroys:	AX, BX, CX, DI, SI					*
;*									*
;************************************************************************
;
DRVSIZ	PROC	NEAR

	MOV	CX,0			;initialize counter
	MOV	BX,OFFSET %SRVTBL	;get pointer to the server table
NXTDRV: PUSH	CX
	PUSH	BX
	MOV	AH,01			;cmd = Xmit/Recv data to drive
	MOV	CX,2			;number of bytes to transmit
	MOV	DX,128			;number of bytes to receive
	MOV	AL,BYTE PTR [BX]	;get the network address of the server
	MOV	SI,OFFSET GETDRVPARMS	;cmd to get the drive parameters
	MOV	DI,OFFSET DRVPARMS	;this is for the returned data
	MOV	BX,0301H		;three attempts, about a second wait
	PUSH	CS			;fake a "FAR" call
	CALL	CRVIO
	POP	BX
	POP	CX
	ADD	BX,ENTRYSZ		;point to next server in server tbl
;
ITSOK:	MOV	SI,OFFSET CAPACTY	;point to capacity of the drive
	MOV	AX,ENTRYSZ		;
	MUL	CX			;
	MOV	DI,AX			;get index into drive size table
	ADD	DI,OFFSET %SRVTBL	;add the index to the starting address
	MOV	AL,BYTE PTR [SI+2]	;get d
	ADD	AL,10H			;convert d
	PUSH	CX
	MOV	CL,4
	ROL	AL,CL
	POP	CX
	MOV	BYTE PTR [DI+SRVRSIZ],AL   ;store d
	MOV	AX,WORD PTR [SI]	   ;get lsb
	MOV	WORD PTR [DI+SRVRSIZ+1],AX
;
	INC	CX
	CMP	CX,WORD PTR %NUMOD
	JLE	NXTDRV
	RET
DRVSIZ	ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	ECHONET 						*
;*									*
;* Function:	Send a ECHO command to a node on the net.		*
;*									*
;* Input:	DH = ECHO command, DL = Node, BX = pointer to %ECHOTBL	*
;*									*
;* Output:	None							*
;*									*
;* Updates:	%ECHOTBL, BX updated to point to the next entry 	*
;*		in %ECHOTBL						*
;*									*
;* Destroys:	AX, DX							*
;*									*
;************************************************************************
;
ECHONET PROC	NEAR
	MOV	AX,DX			;AX has function code and node number
	PUSH	CX			;Fix Companion bug that destroys CX
	PUSH	CS			;FAKE "FAR" CALL
	CALL	CRVIO			;do echo
	POP	CX			;Fix Companion bug that destroys CX
	CMP	AL,0C0H 		;
	JNE	SHORT ECHO1		;
	MOV	BYTE PTR [BX],DL	;mark node as active
ECHO1:	INC	BX			;
	RET				;
ECHONET ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	CHKSRV							*
;*									*
;* Function:	Send a "WHO ARE YOU" cmd to a server then check         *
;*		to see if it is an OmniDrive.  If it is then call	*
;*		a routine to save the node number and server name	*
;*		in %SRVTBL.						*
;*									*
;* Input:	DH = SND/RCV to server cmd, DL = node number		*
;*		BX = pointer to entry in %SRVTBL			*
;*									*
;* Output:	AL = status of ROM call 				*
;*									*
;* Updates:	BX is updated to point to the next entry in %SRVTBL	*
;*		%NUMOD is incremented if the server is an OmniDrive	*
;*									*
;* Destroys:	AH							*
;*									*
;************************************************************************
;
CHKSRV	PROC	NEAR
	PUSH	SI			;
	PUSH	CX			;
	PUSH	BX			;
	PUSH	DX			;

CSRVR0: MOV	SI,OFFSET WHOAREYOU	;check if we really found a server
	MOV	DI,OFFSET ID		;.and save name and node number if so
	MOV	AL,BYTE PTR XPORTER	;
	MOV	BYTE PTR [SI+5],AL	;
	MOV	AX,DX			;function code and node number
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries
	MOV	CX,8			;
	MOV	DX,18			;
	PUSH	CS			;FAKE "FAR" CALL
	CALL	CRVIO			;
	OR	AL,AL			;
	JZ	SHORT CSRVR2		;
	POP	DX			;
	POP	BX			;
	POP	CX			;
	POP	SI			;
	RET				;

CSRVR2: POP	DX			;
	POP	BX			;
	CMP	BYTE PTR IDDEV,ODRIVE	;check if OmniDrive
	JNE	SHORT CSRVR4		;
CSRVR3: CALL	SAVESRV 		;save server info
CSRVR4: POP	CX			;
	POP	SI			;
	RET				;
CHKSRV	ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	SAVESRV 						*
;*									*
;* Function:	Save a servers node number and name in the		*
;*		server table (%SRVTBL). 				*
;*									*
;* Input:	DH = server number					*
;*		BX = pointer to entry in %SRVTBL			*
;*									*
;* Output:	None							*
;*									*
;* Updates:	BX is updated to point to the next entry in %SRVTBL	*
;*		%NUMOD is incremented if the server is an OmniDrive	*
;*									*
;* Destroys:	CX, DI, SI						*
;*									*
;************************************************************************
;
SAVESRV PROC	NEAR
	MOV	BYTE PTR [BX],DL	;save responding server's
	MOV	CX,10			;.address and name in server table
	MOV	SI,OFFSET IDNM		;
	MOV	DI,BX			;
	ADD	DI,SRVRNAM		;
	CLD
	REP	MOVSB			;
	ADD	BX,ENTRYSZ		;point at next entry in server table
	INC	WORD PTR %NUMOD 	;count server
	RET				;
SAVESRV ENDP

PAGE
;************************************************************************
;									*
; FILE ROUTINES 							*
;									*
;************************************************************************
;
;
;
;
;
;
;************************************************************************
;*									*
;* Subroutine:	OPENUTL 						*
;*									*
;* Function:	Open the character device driver named 'UTILHOOK'       *
;*									*
;* Input:	None							*
;*									*
;* Output:	Carry flag set means error occured			*
;*									*
;* Updates:	HANDLE							*
;*									*
;* Destroys:	AX, DX							*
;*									*
;************************************************************************
;
OPENUTL PROC	NEAR
	MOV	DX,OFFSET UTILSTR	;open 'UTILHOOK' character device
	MOV	AH,3DH			;
	MOV	AL,2			;
	INT	21H			;
	MOV	WORD PTR HANDLE,AX	;save file handle
	RET				;carry set means error
OPENUTL ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	CLSFIL							*
;*									*
;* Function:	Close a file handle					*
;*									*
;* Input:	BX = file handle to close				*
;*									*
;* Output:	Carry flag set means error occured			*
;*									*
;* Updates:	None							*
;*									*
;* Destroys:	AX							*
;*									*
;************************************************************************
;
CLSFIL	PROC	NEAR
	MOV	AH,3EH			;close
	INT	21H			;
	RET				;carry set means error
CLSFIL	ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	FNDCOR							*
;*									*
;* Function:	Get the segment & offset to CORTAb			*
;*									*
;* Input:	None							*
;*									*
;* Output:	Carry flag set means error occured			*
;*									*
;* Updates:	CORPTR to contain the segment & offset of CORTAb	*
;*									*
;* Destroys:	AX, BX, CX, DX						*
;*									*
;************************************************************************
;
FNDCOR	PROC	NEAR
	MOV	BX,WORD PTR HANDLE	;get handle
	MOV	AH,40H			;write 2 characters to 'UTILHOOK'
	MOV	CX,2			;.this will reset pointer to
	MOV	DX,OFFSET UTILSTR	;.CORTAb, get characters from name
	INT	21H			;
	MOV	AH,3FH			;now read 4 bytes from 'UTILHOOK'
	MOV	CX,4			;.the segment & offset of CORTAb
	MOV	DX,OFFSET CORPTR	;
	INT	21H			;
	RET				;carry set means error
FNDCOR	ENDP
;
;
;
;************************************************************************
;*									*
;* Subroutine:	IOCNTRL 						*
;*									*
;* Function:	Read to or write from a device control channel. 	*
;*									*
;* Input:								*
;*									*
;* Output:	Carry flag set means error occured			*
;*									*
;* Updates:	PARMTAB 						*
;*									*
;* Destroys:	AX, BX, CX, DX						*
;*									*
;************************************************************************
;
IOCNTRL PROC	NEAR			;
READ:	MOV	DX,OFFSET PARMTAB	;where to save address
	MOV	CX,4			;read 4 bytes (segment & offset)
	MOV	AL,2			;
	JMP	SHORT IO1		;
WRITE:	MOV	AL,3			;write CX bytes, DX points to data
IO1:	MOV	AH,44H			;I/O control
	MOV	BX,WORD PTR HANDLE	;get handle
	INT	21H			;
	RET				;carry set means error
IOCNTRL ENDP

;**************************************************************************

FINDVID PROC	NEAR
	CALL	OPENUTL 		;open 'UTILHOOK'
	JC	SHORT FVIDERR		;
	CALL	FNDCOR			;get address of CORTAb
	JC	SHORT FVIDERR		;
	CALL	CLSFIL			;
	JC	SHORT FVIDERR		;
	PUSH	DS			;
	LDS	SI,DWORD PTR CORPTR	;get pointer to CORTAb

	MOV	AL,BYTE PTR [SI+6]	;check CORDRV version, if equal then
	CMP	AL,CORVER		;.check revision; if version is not
	JNE	SHORT FINDVD0		;.equal then check if version is
	MOV	AL,BYTE PTR [SI+7]	;.greater
	CMP	AL,CORREV		;
	JL	SHORT WRGCOR		;
;
;  Make sure that this is a shadow version of cordrv.
;
	MOV	AX,WORD PTR [SI+44]
	CMP	AX,TRUE 		; TRUE means it's a shadow version
	JZ	FINDVD1
	MOV	DX,OFFSET NOSHDOMG
	POP	DS
	STC
	RET

WRGCOR: MOV	DX,OFFSET WRCORMG	;wrong CORDRV version message
	POP	DS			;
	STC				;
	RET				;

FVIDERR:MOV	DX,OFFSET NOCORMG	;cannot find CORTAb message
	RET				;

FINDVD0:CMP	AL,CORVER		;if version is less than give error
	JL	SHORT WRGCOR		;

FINDVD1:MOV	AX,WORD PTR [SI+17H]	;the VIDEO routine jump is a FAR
	SUB	AX,5			;.jump right before ROM jumps in
	MOV	CS:WORD PTR VIDEO,AX	;.CORDRV, (see CORDRV for more info)
	MOV	CS:WORD PTR VIDEO+2,DS	;.save address of VIDEO jump
	CLC				;show no error
	POP	DS			;
	RET				;
FINDVID ENDP

;**************************************************************************

CMPID	PROC	NEAR
	MOV	SI,WORD PTR [BX+27H]	;get pointer to ID string in
	MOV	AL,BYTE PTR [SI]	;.CORDRV; first check length, if
	CMP	AL,CS:BYTE PTR [DI]	;.thats OK then compare
	JNE	SHORT NOGOOD		;
	XOR	AH,AH			;
	MOV	CX,AX			;
	INC	SI			;
	INC	DI			;
	CLD
  REPZ	CMPSB				;
	JNZ	SHORT NOGOOD		;
	CLC				;say no error
	RET				;
NOGOOD: STC				;show error
	RET				;
CMPID	ENDP

;**************************************************************************

FINDID	PROC	NEAR
	CALL	OPENUTL 		;open 'UTILHOOK'
	JC	SHORT IDERR		;
	CALL	FNDCOR			;get address of CORTAb
	JC	SHORT IDERR		;
	CALL	CLSFIL			;close 'UTILHOOK'
	JC	SHORT IDERR		;
	PUSH	DS			;
	LDS	BX,DWORD PTR CORPTR	;get pointer to CORTAb
;
;  Copy the CORDRV ROM jump table into local area
;
	MOV	SI,[BX+23]		;get the ROM function table pointer
	MOV	DI,OFFSET LNKTAB	;local area to copy the table to
	MOV	CX,20			;number of bytes in table
	CLD
	REP	MOVSB			;copy the table into this program
;
;  Copy the transporter number out of CORTAb
;
	MOV	AL,[BX+27]		;point to "XPORTER" in CORTAb
	MOV	CS:BYTE PTR XPORTER,AL
;
	MOV	CS:WORD PTR TIMMULT,18	;see if IBM
	MOV	DI,OFFSET IBMID 	;
	CALL	CMPID			;
	JNC	SHORT IDOK		;
;
IDERR:	MOV	DX,OFFSET UNKID 	;say unknown ID and return error
	STC				;
IDOK:	POP	DS			;
	RET				;
FINDID	ENDP

PAGE
;**************************************************************************
;
; VIDEO ROUTINES
;
;**************************************************************************

CLRCMD	PROC	NEAR
	MOV	DX,CMDWND		;
CLREOL	LABEL	NEAR
CLRCMD1:CALL	POSCUR			;
	MOV	AH,2			;
	CALL	CS:DWORD PTR [VIDEO]	;
	RET				;
CLRCMD	ENDP

;**************************************************************************

CLRCONT PROC	NEAR
	MOV	DX,CONTPOS		;
	JMP	SHORT CLRCMD1		;
CLRCONT ENDP

;**************************************************************************

CLRWNDO PROC	NEAR
	MOV	DX,CMDWND		;
CLRAGN: CALL	SHORT CLRCMD1		;
	INC	DH			;
	CMP	DX,CONTPOS		;
	JLE	SHORT CLRAGN		;
	RET
CLRWNDO ENDP

;**************************************************************************

CMDLINE PROC	NEAR
	CALL	CLRCMD			;
	MOV	DX,OFFSET CMDPRMT	;
	CALL	PRNTCLR 		;
	RET				;
CMDLINE ENDP

;**************************************************************************

POSCUR	PROC	NEAR
	MOV	AH,3			;expects position to be in DX in
	CALL	CS:DWORD PTR [VIDEO]	;.the form (DH=ROW,DL=COLUMN)
	RET				;
POSCUR	ENDP

;**************************************************************************

PRNTSTR PROC	NEAR
	MOV	AH,09H			;MSDOS print string function
	INT	21H			;
	RET				;
PRNTSTR ENDP

;**************************************************************************

PRNTCHR PROC	NEAR
	MOV	AH,02H			;MSDOS print character function
	INT	21H			;
	RET				;
PRNTCHR ENDP

;**************************************************************************

PRNTCLR PROC	NEAR			;Similure to DOS INT 21 function 9H
;					;...except that the characters are
;					;...printed in color.  The first byte
;					;...of the string contains the color.
;
	PUSH	AX			;Save the registers used
	PUSH	BX
	PUSH	CX
	PUSH	DI
	PUSH	SI
;
	CMP	SCREEN_TYPE,COLOR	;Is there a color screen
	JZ	DO_COLOR
	INC	DX			;Skip over the color byte
	CALL	PRNTSTR
	JMP	END_OF_STRING
;
DO_COLOR:
	MOV	AH,3			;Find the current cursor position
	XOR	BX,BX			;... for page 0
	PUSH	DX
	INT	10H
	MOV	WORD PTR ROWCOL,DX	;Save it.
	POP	DX
	MOV	SI,DX			;Point to the beginning of the string
	MOV	DI,DX			;...to print on the screen
	INC	DI
NXTCHR_TO_PRINT:
	CMP	BYTE PTR [DI],"$"       ;End of the string?
	JZ	END_OF_STRING		;Yes, then exit
	CMP	BYTE PTR [DI],CR	;Character = carriage return?
	JNZ	TRYLF			;No, then see if it's a line feed
	MOV	COL,-1			;Set the col to left edge of the screen
	INC	DI			;Point to the next character
	JMP	MOVCSR
TRYLF:	CMP	BYTE PTR [DI],LF	;Charcter = line feed?
	JNZ	TRYBS			;No, then see if it's a backspace char
	INC	ROW			;Put in the lf by advancing the row
	DEC	COL			;
	INC	DI			;Point to the next character
	JMP	MOVCSR
TRYBS:	CMP	BYTE PTR [DI],BACKSPC	;Character = backspace?
	JNZ	TRYBEL			;No, then see if it's a bell
	SUB	COL,2			;Put in the backspace
	INC	DI			;Point to the next character
	JMP	MOVCSR
TRYBEL: CMP	BYTE PTR [DI],BELL	;Character = bell?
	JNZ	NRML_CHR		;No, then process normal characters
	MOV	AX,0E07H		;Output the bell (AH=cmd, AL=bell)
	INT	10H
	INC	DI			;Point to the next character
	JMP	NXTCHR_TO_PRINT 	;Don't update the cursor position
NRML_CHR:
	MOV	AH,9
	MOV	BH,0
	MOV	CX,1
	MOV	AL,BYTE PTR [DI]	;Character to display
	MOV	BL,BYTE PTR [SI]	;Color of the character
	INT	10H
	INC	DI			;Point to the next character
;
MOVCSR: INC	COL			;Move the cursor one position to
	CMP	COL,80			;... the right.  If we are going past
	JNZ	MVCSR5			;... the right edge then wrap to col 1
	MOV	COL,0			;... and increment the row.  (if
	CMP	ROW,24			;... already at the bottom of the
	JZ	MVCSR5			;... screen then don't increment the
	INC	ROW			;... row)
MVCSR5: MOV	AH,2			;
	XOR	BX,BX
	MOV	DX,WORD PTR ROWCOL
	INT	10H
	JMP	NXTCHR_TO_PRINT
;
END_OF_STRING:
	POP	SI			;Restore all destroyed registers
	POP	DI
	POP	CX
	POP	BX
	POP	AX
	RET
PRNTCLR ENDP

PAGE
;**************************************************************************
;
; KEYBOARD ROUTINES
;
;**************************************************************************
;
;
;
;
;**************************************************************************
;
; BUFIN -	buffered input
;		requires a data space of the following form
;		BYTE1:	   # of chars wanted
;		BYTE2:	   # of chars typed
;		BYTE3 - N: buffer for chars, as least as big as BYTE 1
;
;		also requires a one byte flag %ECHO, 0 = echo character
;		also requires a one byte flag %NUMBER, 1 = numbers only
;
;		ON ENTRY - DX contains address of data space
;		ON EXIT  - carry set if ESCAPE	was typed or carriage
;			   return was first character typed; BYTE2 set
;			   to number of characters typed
;
;		All registers preserved; Uses routine 'GETKYB'
;
;**************************************************************************

BUFIN	PROC   NEAR
	PUSH	BX			;save regs used
	PUSH	DI			;
	PUSH	CX			;
	PUSH	AX			;
	PUSH	DX			;
	MOV	BX,DX			;address of data space
	MOV	DI,DX			;
	ADD	DI,2			;DI now points at buffer
	XOR	CX,CX			;clear count

BUFIN1: CALL	GETKYB			;get char from keyboard
	XOR	AH,AH
	JC	SHORT ESCEXT		;carry set means ESCAPE
	CMP	AX,CR			;check for a carriage return,
	JE	SHORT GOTCR		;.backspace, control chars., etc.
	CMP	AX,BACKSPC		;
	JE	SHORT GOTBS		;
	CMP	AX,BLANK		;
	JL	SHORT BUFIN1		;
	CMP	CL,BYTE PTR [BX]	;see if we got all the characters
	JE	SHORT GOTALL		;.we want
;
;  Should we only allow numbers to be input?
;
	CMP	BYTE PTR %NUMBER,1	;allow numbers only?
	JNE	SHORT GETANY		;NO -- so continue
	CMP	AL,'0'                  ;is character between 0 and 9 ?
	JL	SHORT NUMERR
	CMP	AL,'9'
	JLE	SHORT GETANY
NUMERR: MOV	AL,BELL
	CALL	PRNT
	JMP	SHORT BUFIN1
GETANY: MOV	BYTE PTR [DI],AL	;save character
	INC	DI			;
	INC	CX			;
	CMP	BYTE PTR %ECHO,0	;check if we should echo the character
	JE	SHORT BUFIN2		;... if not print a dot
	MOV	AL,DOT			;
BUFIN2: CALL	PRNT			;display it
	JMP	SHORT BUFIN1		;get the next

GOTALL: MOV	AL,BELL 		;got all charcters we wanted so
	CALL	PRNT			;.bitch about any more
	JMP	SHORT BUFIN1		;

GOTBS:	JCXZ	SHORT BUFIN1		;if no chars yet ignore BS
	CALL	PRNT			;else back up cursor
	MOV	AL,BLANK		;blank out char
	CALL	PRNT			;
	MOV	AL,BACKSPC		;back up cursor again
	CALL	PRNT			;
	DEC	DI			;dec char count and buffer pointer
	DEC	CX			;
	MOV	AL,BLANK		;blank out char in buffer
	MOV	BYTE PTR [DI],AL	;
	JMP	SHORT BUFIN1		;go for more

ESCEXT: STC				;show ESCAPE
	MOV	BYTE PTR [BX+1],0	;no chars. returned
	JMP	SHORT BUFEXT		;
GOTCR:	JCXZ	SHORT ESCEXT		;if carriage return is first char
	CLC				;.return with carry set
	MOV	BYTE PTR [BX+1],CL	;
BUFEXT: POP	DX			;restore regs and return
	POP	AX			;
	POP	CX			;
	POP	DI			;
	POP	BX			;
	RET				;

;**************************************************************************

PRNT:	MOV	DL,AL			;
	CALL	PRNTCHR 		;
	RET				;
BUFIN	ENDP

;**************************************************************************

GETKYB	PROC	NEAR
	PUSH	BX
	XOR	BX,BX
	MOV	AH,08H			;get character from keyboard
	JMP	GKCONT
GETKYBW LABEL	NEAR			;entry point to clear kybrd buffer 1st
	PUSH	BX
	XOR	BX,BX
	MOV	AX,0C08H		;
GKCONT: INC	BX
	INT	21H			;
	CMP	AL,NULL 		;
	JE	GKCONT			;Get extended ASCII code
	CMP	AL,ESCAPE		;set carry and return if ESCAPE
	JE	SHORT GETK2		;
	CMP	AL,'a'                  ;
	JL	SHORT GETK1		;
	CMP	AL,'z'                  ;
	JG	SHORT GETK1		;
	CMP	BX,1
	JNE	GETK1			;don't convert extended ASCII codes
	SUB	AL,20H			;convert to upper case
GETK1:	CLC				;show that ESCAPE was pressed
	POP	BX
	RET				;
GETK2:	STC				;
	POP	BX
	RET				;
GETKYB	ENDP

;**************************************************************************
;	RETURNS VALUE IN AL

GETDEC	PROC	NEAR
	PUSH	SI			;
	PUSH	BX			;
	PUSH	CX			;
	PUSH	DX			;
	MOV	BYTE PTR %ECHO,0	;echo characters
	MOV	BYTE PTR %MAXCHR,02	;two digits maximum
	MOV	DX,OFFSET %MAXCHR	;
	XOR	AX,AX			;return zero if no characters typed
	MOV	BYTE PTR %NUMBER,1	;tell BUFIN to allow only numbers
	CALL	BUFIN			;
	JC	SHORT GETDEC3		;
	XOR	CH,CH			;
	MOV	CL,BYTE PTR %CHRTYP	;loop for number of characters typed
	MOV	SI,OFFSET %INBUFF	;
GETDEC1:MOV	BL,BYTE PTR [SI]	;
	INC	SI			;
	SUB	BL,"0"                  ;
	JL	SHORT GETDEC4		;
	CMP	BL,9			;
	JG	SHORT GETDEC4		;
	CBW				;
	MOV	DX,10			;
	MUL	DX			;
	ADD	AX,BX			;
	LOOP	GETDEC1 		;

GETDEC3:POP	DX			;
	POP	CX			;
	POP	BX			;
	POP	SI			;
	RET				;

GETDEC4:STC				;show error
	JMP	SHORT GETDEC3		;
GETDEC	ENDP

PAGE
;**************************************************************************
;
; MISCELLANEOUS ROUTINES
;
;**************************************************************************
;
;
;
;
;************************************************************************
;*									*
;* Subroutine:	SHOSIZ							*
;*									*
;* Function:	Show the sector number that is passed in DL,CX		*
;*		on the screen.						*
;*									*
;* Input:	DL = d, CX = lsb, msb					*
;*									*
;* Output:	None							*
;*									*
;* Updates:	Nothing 						*
;*									*
;* Destroys:								*
;*									*
;************************************************************************
;
SHOSIZ	PROC	NEAR

	PUSH	DI
	PUSH	CX
	PUSH	DX
	MOV	AX,CX
	SUB	DL,1
	MOV	CL,4
	ROL	DL,CL
	XOR	DH,DH
	PUSH	AX
	MOV	DI,OFFSET %OUTSTR	;set length of string for value
	INC	DI			;Point past color byte
;
;  First get the hundred thousands and ten thousands digits.
;
	POP	AX
	MOV	BX,TENTHOUSAND
	DIV	BX
	MOV	BH,TEN
	DIV	BH
	ADD	AX,3030H		;convert decimal to ascii
	MOV	WORD PTR [DI],AX
	INC	DI
	INC	DI
	MOV	AX,DX			;get the remainder now
	XOR	DX,DX
;
;  Get the thousands digit now.
;
	MOV	BX,ONETHOUSAND
	DIV	BX
	ADD	AL,30H			;convert decimal to ascii
	MOV	BYTE PTR [DI],AL
	INC	DI
	MOV	AX,DX			;get the remainder now
	XOR	DX,DX
;
;  Get the hundreds digit now.
;
	MOV	BX,ONEHUNDRED
	DIV	BX
	ADD	AL,30H			;convert decimal to ascii
	MOV	BYTE PTR [DI],AL
	INC	DI
	MOV	AX,DX			;get the remainder now
;
;  Get the tens digit and the ones digit (it's in the remainder) now.
;
	MOV	BH,TEN
	DIV	BH
	ADD	AX,3030H		;convert decimal to ascii
	MOV	WORD PTR [DI],AX
;
;  Now display the number on the screen
;
PRNT_IT:
	MOV	DI,OFFSET %OUTSTR
	INC	DI			;Point past the color byte
	MOV	CX,OUTSTR_SIZ - 1
CHK0:	CMP	BYTE PTR [DI],"0"
	JNZ	OUTNOW
	MOV	BYTE PTR [DI],BLANK	;blank out all leading zeros
	INC	DI
	LOOP	CHK0			;check for another 0
OUTNOW: MOV	DX,OFFSET %OUTSTR
	CALL	PRNTCLR 		;
	POP	DX
	POP	CX
	POP	DI
	RET
SHOSIZ	ENDP

;**************************************************************************

CONTINUE PROC	NEAR
	CALL	CLRCONT 		;
	MOV	DX,OFFSET CONT		;continue message
	CALL	PRNTCLR 		;
	CALL	GETKYB			;get a character from the keyboard
	CALL	CLRCONT 		;
	RET				;
CONTINUE ENDP

;**************************************************************************

SCRN	PROC	NEAR
	MOV	AH,1			;
	CALL	CS:DWORD PTR [VIDEO]	;
SCRN_NO_CLR	LABEL	NEAR		;entry point to display screen without
;					;... clearing the screen first
	MOV	DX,OFFSET BANNER	;get screen display
	CALL	PRNTCLR 		;show it
	MOV	DX,OFFSET LINE		;
	CALL	PRNTCLR 		;
	MOV	DX,OFFSET SRVRST	;
	CALL	PRNTCLR 		;
	CMP	WORD PTR %NUMOD,5	;
	JG	SHORT SCRN10		;
	MOV	DX,OFFSET SRVRST1	;show the state of the disk servers
	JMP	SCRN20			;
SCRN10: MOV	DX,OFFSET SRVRST2	;
SCRN20: CALL	PRNTCLR 		;
	CALL	SHOW_OD_STATUS		;
	MOV	DX,LIN2POS
	CALL	POSCUR
	CALL	SCRN1			;print a line
	MOV	DX,OFFSET MENU		;
	CALL	PRNTCLR 		;
SCRN1:	MOV	DX,OFFSET LINE		;print line
	CALL	PRNTCLR 		;
	RET				;
SCRN	ENDP

;**************************************************************************

PWSCRN	PROC	NEAR
	MOV	AH,1			;
	CALL	CS:DWORD PTR [VIDEO]	;
	MOV	DX,OFFSET BANNER	;get screen display
	CALL	PRNTCLR 		;show it
	MOV	DX,OFFSET LINE		;
	CALL	PRNTCLR 		;
	MOV	DX,OFFSET SRVRST	;
	CALL	PRNTCLR 		;
	CMP	WORD PTR %NUMOD,5	;
	JG	SHORT ONEHDR		;
	MOV	DX,OFFSET SRVRST1	;show the state of the disk servers
	JMP	DOHDR			;
ONEHDR: MOV	DX,OFFSET SRVRST2	;
DOHDR:	CALL	PRNTCLR 		;
	CALL	SHOW_OD_STATUS		;
PWS100: MOV	DX,LIN2POS
	CALL	POSCUR
	CALL	SCRN1			;print a line
;
;  Get the password
;
	MOV	DX,OFFSET PSWRD 	;ask for the password
	CALL	PRNTCLR 		;
	CALL	BLANKBUF		;Fill the buffer with blanks
	MOV	BYTE PTR %ECHO,-1	;do not echo the input characters
	MOV	BYTE PTR %MAXCHR,8	;allow 8 character for the password
	MOV	BYTE PTR %NUMBER,0	;tell BUFIN to allow any ASCII char
	MOV	DX,OFFSET %MAXCHR	;point to input buffer
	CALL	BUFIN			;
	JC	PWSEND			;If no password then exit
	MOV	SI,OFFSET %INBUFF	;Encrypt the entered password
	MOV	DI,OFFSET %CRYPPSW
	CALL	PSWENCRYPT
;
;  See if valid password
;
	MOV	SI,OFFSET PASSWORD
	MOV	DI,OFFSET %CRYPPSW
	MOV	CX,8
	CLD
	REPZ	CMPSB
	JZ	PWSEND
;
;  Try to enter through the backdoor.  P.S. - the backdoor password is:
;     CTRL - PgDn, CTRL - PgUp, CTRL - Home, CTRL - End
;
;	THIS PASSWORD IS CORVUS CONFIDENTIAL
;
;
	MOV	SI,OFFSET %CRYPPSW	  ;Point to the encrypted password
	MOV	DI,OFFSET BACKDOOR	  ;Point to encrypted backdoor password
	MOV	CX,8
	CLD
	REPZ	CMPSB
	JZ	PWSEND			  ;Enter through the backdoor
;
;  Invalid password, try again
;
INVPSW: MOV	DX,OFFSET MSGPSW
	CALL	ERRCON
	JMP	PWS100
;
;  Exit
;
PWSEND:
	RET				;
PWSCRN	ENDP
;
;
;
;**************************************************************************
;
; BLANKBUF -	fills %INBUFF with blanks
;
;**************************************************************************

BLANKBUF PROC	NEAR
	MOV	DI,OFFSET %INBUFF	;fill buffer with blanks
	MOV	AL,BLANK		;
	MOV	CX,INBUF_SIZ		;
	CLD
	REP	STOSB			;
	RET				;
BLANKBUF ENDP


;**************************************************************************

ERRCON	PROC	NEAR
	PUSH	DX				;save error message
	MOV	DL,BELL 			;...beep...
	CALL	PRNTCHR 			;
	MOV	DX,ERRLINE			;
	CALL	POSCUR				;
	POP	DX				;print error message
	CALL	PRNTCLR 			;
	MOV	DX,OFFSET CONT			;wait for a key press
	CALL	PRNTCLR 			;
	CALL	GETKYB				;
	MOV	DX,ERRLINE			;
	CALL	POSCUR				;
	CALL	CLREOL				;clear line and continue
	RET					;
ERRCON	ENDP

;
;  Include the rest of the code
;
	INCLUDE SINIT2.INC

PAGE
;**************************************************************************
;
;  Space to load the call table.  This table gets patched to "ROM" calls
;  See CORDRV "ROMJMPS" for more detail
;
LNKTAB	PROC	NEAR
;	JMP	FAR LABEL	;5 BYTES FOR FAR JUMP (DOES A RET)
	DB	5 DUP (?)
;	JMP	FAR LABEL	;5 BYTES FOR FAR JUMP (DOES A RET)
	DB	5 DUP (?)
;
CRVIO	LABEL	NEAR
;	JMP	FAR LABEL	;5 BYTES FOR FAR JUMP (DOES A RET)
	DB	5 DUP (?)
;
;	JMP	FAR LABEL	;5 BYTES FOR FAR JUMP (DOES AN IRET)
	DB	5 DUP (?)
LNKTAB	ENDP

CDMOV	LABEL	NEAR
	INCLUDE XFRIB.INC

CSEG	ENDS
	END	START
