;
	PAGE	58,132
	NAME	CORDRV
	TITLE	MSDOS 2.0 Installable Corvus Disk Driver
;
;
;************************************************************************
;* Description: This is an installable device driver for the Corvus	*
;*		hard disk.						*
;*									*
;*		The MSDOS 2.0 bootstrap procedure reads the ASCII file	*
;*		CONFIG.SYS, if it exists, and installs the specified	*
;*		device drivers. 					*
;*									*
;* Author:	Donna Ono						*
;*									*
;* Revisions:	05-Aug-83	Module created. 			*
;*									*
;*		25-Oct-83	Edited source back to 80 columns (BRK)	*
;*		26-Oct-83	Added in flat cable driver		*
;*		16-Nov-83	Added additional comments (BRK) 	*
;* V5.2 	18-Nov-83	Fixed error reporting bug. (BRK)	*
;* v5.3 	21-Nov-83	Fixed unmount error	(BRK)		*
;*		16-Dec-83	Added timeout unit to flat cable driver *
;*				and made source compatible with v1.26	*
;*				assembler				*
;*		04-Jan-84	fixed bug in timeout routine (BRK)	*
;* v5.4 	20-Jan-84	changed init seq. to unlink block driver*
;*				if # of disk units is 0, added support	*
;*				for PCSHARE driver, and full 24 bit	*
;*				disk address support (BRK)		*
;*		03-Feb-84	added HXINITF flag and HXINIT macro ref *
;*				during init of UTILHOOK driver to	*
;*				support  TI with Corvus-Nci ROM.  Also	*
;*				added BRKVOLS flag to disable test vol. *
;*				configuration.	(BRK)			*
;*		23-Feb-84	fixed bug in PCSHARE attach (BRK)	*
;*  v5.5	09-Jun-84	1.  add drive command semaphore (WEK)	*
;*				2.  added support code for semaphore	*
;*				3.  added page breaks			*
;*  v5.6	13-Jul-84	removed page breaks, re-tabified source,*
;*				added support for mixed internal driver *
;*				and ROM driver, added support for video *
;*				module, and added system type identifier*
;*				string (BRK).				*
;*  v5.7	15-Aug-84	increased version to siginify new driver*
;*				module version for Omninet that supports*
;*				echo command and Cancels for Broadcasts *
;*				(BRK)					*
;*		17-Aug-84	fixed bug in RW_SECTOR concerning error *
;*				reporting of write errors (BRK) 	*
;*  v5.8	14-Oct-84	add include for LOGON module called	*
;*				LOGON.INC (WEK) 			*
;*  v5.9	07-Feb-85	added driver re-direction flag to Cortab*
;*				to indicate driver type being used and	*
;*				added code to support another device	*
;*				like the PCSHARE driver, but called	*
;*				NTBOHOOK. (BRK) 			*
;*  v6.0	29-Jan-85	changed for SHADOW drive use.  (NOD)	*
;*				NOTE that the shadow code is surrounded *
;*				by conditionals so that one source can	*
;*				be used for normal and shadow versions	*
;*				of CORDRV.  The variable is "SHADOW"    *
;*				and is located in SYSTEM.EQU.  Set this *
;*				variable to TRUE to get the shadow	*
;*				version or to false to get the normal	*
;*				version.				*
;*									*
;************************************************************************
;
; N O T E : THE STRUCTURE OF SOME OF THE TABLES USED IN THE CODE IS
;	    DESCRIBED IN TERMS OF OFFSETS FROM THE START OF THE TABLES
;	    BY "EQUATES" DEFINED BELOW.
;
	IF2
	%OUT <Beginning PASS2>
	ENDIF
;
CSEG	SEGMENT PARA PUBLIC 'CODE'
;
;
;*******************
;*   M A C R O S   *
;*******************
;
PUTSTR	MACRO	STROFFREG		;
	MOV	DX,STROFFREG		; DS:DX -> ASCII string
	MOV	AH,9			; AH = print string command code
	INT	21h			; DOS function call
	ENDM				;
;
STATUS	MACRO	state,err,rc
	IFIDN	<state>,<DONE>
		OR	ES:WORD PTR SRH_STA_FLD[BX],0100h
	ENDIF
	IFIDN	<state>,<BUSY>
		OR	ES:WORD PTR SRH_STA_FLD[BX],0200h
	ENDIF
	IFIDN	<err>,<ERROR>
		OR	ES:WORD PTR SRH_STA_FLD[BX],8000h	; V5.2
	ENDIF
	IFNB	<rc>
		OR	ES:WORD PTR SRH_STA_FLD[BX],rc
	ENDIF
	ENDM
;
F_CALL	MACRO	SegVal,OffVal
	DB	   9Ah			; direct intersegment CALL opcode
	DW	OffVal			; offset portion of operand
	DW	SegVal			; segment portion of operand
	ENDM
;
F_JMP	MACRO	SegVal,OffVal
	DB	  0EAh			; direct intersegment JMP opcode
	DW	OffVal			; offset portion of operand
	DW	SegVal			; segment portion of operand
	ENDM
;
PRINTE	MACRO	MSG,N
	IF2
	%OUT	* MSG N *
	ENDIF
	ENDM
;
;*********************************
;*   M S D O S	 E Q U A T E S	 *
;*********************************
;
; Static Request Header (SRH) format
;
SRH		EQU	0		;
SRH_LEN_FLD	EQU	SRH		; SRH length
SRH_UCD_FLD	EQU	SRH_LEN_FLD+1	; SRH unit code (0-?)
SRH_CCD_FLD	EQU	SRH_UCD_FLD+1	; SRH command code
SRH_STA_FLD	EQU	SRH_CCD_FLD+1	; SRH status
SRH_RES_FLD	EQU	SRH_STA_FLD+2	; SRH reserved area
SRH_LEN 	EQU	SRH_RES_FLD+8	;
;
; INPUT/OUTPUT/OUT_VERIFY request format
;
MD		EQU	SRH+SRH_LEN	; media descriptor byte
MD_LEN		EQU	1		;
DTA_OFF 	EQU	MD+MD_LEN	; data transfer area offset
DTA_SEG 	EQU	DTA_OFF+2	; data transfer area segment
DTA_LEN 	EQU	4		;
COUNT		EQU	DTA_OFF+DTA_LEN ; byte/sector count
COUNT_LEN	EQU	2		;
SSN		EQU	COUNT+COUNT_LEN ; starting sector number
SSN_LEN 	EQU	2		;
;
; MEDIA_CHECK request format
;
RET_BYTE	EQU	MD+MD_LEN	; byte returned from driver
RET_BYTE_LEN	EQU	1		;
;
; BUILD_BPB request format
;
BPBTBL_OFF	EQU	DTA_OFF+DTA_LEN ; BPB table offset
BPBTBL_SEG	EQU	BPBTBL_OFF+2	; BPB table segment
BLDBPB_LEN	EQU	BPBTBL_SEG+2	;
;
; INIT request format
;
UNITS		EQU	SRH+SRH_LEN	; number of units (blk devs only)
BRKADR_OFF	EQU	UNITS+1 	; break (ending) address offset
BRKADR_SEG	EQU	BRKADR_OFF+2	; break (ending) address segment
BPB_PTR_OFF	EQU	BRKADR_SEG+2	; BPB ptr array offset
BPB_PTR_SEG	EQU	BPB_PTR_OFF+2	; BPB ptr array segment
INIT_LEN	EQU	BPB_PTR_SEG+2	;
;
; DOS error codes
;
DE_protect	EQU	   00h		; write protect violation
DE_nrdy 	EQU	   02h		; drive not ready   V5.3
DE_write	EQU	   0Ah		; write fault
DE_read 	EQU	   0Bh		; read fault
DE_general	EQU	   0Ch		; general failure
;
;
; BIOS Parameter Block (BPB) format
;
BPB_bps 	EQU	0		; # of bytes per sector
BPB_spc 	EQU	BPB_bps+2	; # of sectors per cluster
BPB_rs		EQU	BPB_spc+1	; # of reserved sectors
BPB_FATs	EQU	BPB_rs+2	; # of FAT copies in volume
BPB_dir 	EQU	BPB_FATs+1	; # of directory entries
BPB_spv 	EQU	BPB_dir+2	; # of sectors per volume
BPB_media	EQU	BPB_spv+2	; media descriptor byte
BPB_spf 	EQU	BPB_media+1	; # of sectors per FAT
BPB_ESIZE	EQU	BPB_spf+2	; BPB entry size
;
;
;***********************************
;*   C O R V U S   E Q U A T E S   *
;***********************************
;
; Mount Table (@ CS:MNTTBL) format
;
MT_TBLMAP	EQU	   1Fh		; CORMAP & BPB_TBL entry # + 1
MT_UNUSED	EQU	   20h		; (currently unused)
MT_CD		EQU	   40h		; 0 => Corvus drive, 1 => floppy drive
MT_RO		EQU	   80h		; 0 => read-only, 1 => read/write
;
; Corvus Drive Map (@ CS:CORMAP) format
;
CM_DA_LO	EQU	    0		; disk addr bite 15-00
CM_DA_HI	EQU	    CM_DA_LO+2	; disk addr bits 19-16
CM_DRVNUM	EQU	    CM_DA_HI+1	; Corvus drive # (1-4)
CM_SRVNUM	EQU	    CM_DRVNUM+1 ; disk server #
CM_ESIZE	EQU	    CM_SRVNUM+1 ; CORMAP entry size
;
; Corvus Shadow table values (v6.0 nod)
; Also return values for Get Drive Status command for DRVTYPE
;
;  NOTE - the values for these variables are important because they
;	  correspond to the values used in the drive firmware.
;
;	  DO NOT CHANGE THE VALUES FOR THESE EQUATES!!!
;
;	Shadow Drive Type values
;
DT_OFFLINE	EQU    -1		;Drive Type set to OFFLINE
DT_NORMAL	EQU	0		;Drive Type set to NORMAL
DT_MASTER	EQU	1		;Drive Type set to MASTER
DT_SLAVE	EQU	2		;Drive Type set to SLAVE
NO_SHADOW_PROM	EQU	3		;Drive does not have the SHADOW PROM.
;
; Return values for Get Drive Status command for DRVMODE
;
;	Shadow Drive Mode values
;
DM_NORMAL	EQU	0		;Mode flag set to NORMAL
DM_OFFLINE	EQU	1		;Mode flag set to OFFLINE
DM_MATEOFF	EQU	2		;Mode flag set to MATE OFFLINE
;
;
; Miscellaneous Corvus equates
;
TRUE		EQU	0FFFFH		; logical true
FALSE		EQU	    0		; logical false
HXINITF 	=	FALSE		; set to disable HXINIT macro ref
BRKVOLS 	=	FALSE		; set to disable BRK test setup
FROMDVR 	=	FALSE		; set to assume PURE driver type (v5.6)
garbage 	EQU	    0		;
BEL		EQU	  007h		; ASCII bell character
LF		EQU	  00Ah		; ASCII linefeed character
CR		EQU	  00Dh		; ASCII carriage return character
VERSION 	EQU	    6		; Corvus driver version number
REVISION	EQU	    0		; Corvus driver revision number
CV_MAX		EQU	   10		; maximum # of Corvus volumes supported
ISTKSIZ 	EQU	  100h		; internal stack size
SECTSIZE	EQU	  200h		; sector size
HC2_SIZE	EQU	02000h		; maximum HELLOC2 size in bytes
FC_XPORT	EQU	  0FFh		; flatcable XPORTER value
FC_BTSRV	EQU	  0FFh		; flatcable BSERVER value
WAIT		EQU	  000h		; # of .86 sec ticks to wait on disk
;					;   server
RETRIES 	EQU	  00Ah		; # of retransmissions before aborting
BCI_READ	EQU	  032h		; BCI cmd: read 512-byte chunk
BCI_WRITE	EQU	  033h		; BCI cmd: write 512-byte chunk
;ROM_COLD	=	    0		; ROM cold start: init xporter i'face
;					;  & ld C2 boot
;ROM_WARM	=	    3		; ROM warm start: init xporter i'face
;ROM_IO 	=	    6		; ROM I/O service dispatcher
;ROM_DUMRET	=	    9		; ROM dummy interrupt return
ROMSEG		=	    0		; set default rom segment
ROM_ID_IF	EQU	    0		; ROM_IO cmd: identify i'face
;					;   (0=OmniNet, 1=flat)
ROM_READ	EQU	    1		; ROM_IO cmd: xmit/recv data from drive
ROM_ID_BS	EQU	    4		; ROM_IO cmd: identify boot server
;					;   (0=OK)
ROM_WRITE	EQU	    5		; ROM_IO cmd: write data to drive
MAX_SRVRS	EQU	   63		; Highest possible disk server number (v6.0)
;
SEMA4CMD	EQU	  0BH		; Semaphore cmd for LOCK/UNLOCK
SEMA4CMD2	EQU	  1AH		; Semaphore cmd for STATUS/INITIALIZE
;
;
;*************************************
;*   S T A R T	 O F   D R I V E R   *
;*************************************
;
	INCLUDE SYSTEM.EQU	; INCLUDE SYSTEM SPECS.
;
	IF1
	  IF (SHADOW)
	  %OUT < SHADOW Drive version of CORDRV >
	  ENDIF
	ENDIF
;
CV_SET	=	0	; set # of volumes already mounted
;
	 IF	BRKVOLS ; special test vols for BRK testing
CV_SET	=	2
	  ENDIF
;
;
;
;
CORDRV	PROC	FAR
;
	ASSUME	CS:CSEG,ES:CSEG,DS:CSEG
BEGIN:
START		EQU	$
;
;*************************************************
;*   D E V I C E   D R I V E R	 H E A D E R S	 *
;*     (must be at the start of the driver)	 *
;*************************************************
;
; This is the device header for a dummy character device driver
; which provides the "hook" into the Corvus tables.
;
DSKPTR		DW	NEXT_DEV	; offset to next device header
		DW	-1		; segment of next device header
		DW	 8000h		; character device
		DW	DUM_STRATEGY	; pointer to device strategy
		DW	DUM_INT 	; pointer to device interrupt hander
		DB	'UTILHOOK'      ; character device name
;
; This is the device driver header for the Corvus hard disk driver.
;
NEXT_DEV	DD	-1		; pointer to next device
		DW	2000h		; block device, non-IBM format
		DW	DEV_STRATEGY	; pointer to device strategy
		DW	DEV_INT 	; pointer to dev. interrupt handler
		DB	?		; # of block devices
;					;  (DOS fills in w/INIT info)
;
;=============== DO NOT MOVE THIS NEXT POINTER ==============
;
		DW	CORTBL		; 7 bytes of filler
		DB	'kitty'         ;
;
;============================================================
;
SYSID		LABEL	NEAR
		IDSTRING		; system type identifier string (v5.6)
;					;  this is pointed to by pointer
;					;  in CORTAb
;
;***********************************************************************
;*   L O C A L	 Q U E U E S   O F   P E N D I N G   R E Q U E S T S   *
;***********************************************************************
;
; DOS CALLs either of the device strategy routines with ES:BX -> SRH.
; The device strategy routines save the contents of ES & BX here.
; The device interrupt handlers restore the contents of ES & BX here.
; Currently, only one device request is pending at any time.
; When multitasking device requests are supported by MSDOS, these will
;   be queues.
;
DD_OFF		DW	?		; save dummy device SRH offset
DD_SEG		DW	?		; save dummy device SRH segment
;
RH_OFF: 	DW	?		; save request header offset
RH_SEG: 	DW	?		; save request header segment
;
;
;***************************
;*   M S D O S	 D A T A   *
;*   also used by Corvus   *
;***************************
;
; BIOS Parameter Block (BPB) Pointer Array
; The address of this array of BPB pointers is returned in the INIT request.
;
;   Index in by MNTTBL entry MT_TBLMAP field - 1; entry size is 2;
;   Each entry is a 2-byte offset (in the CS segment) to a BPBTBL entry.
;
BPB_PTR 	DW	BPBTBL			;
		DW	BPBTBL+   BPB_ESIZE	;
		DW	BPBTBL+(2*BPB_ESIZE)	;
		DW	BPBTBL+(3*BPB_ESIZE)	;
		DW	BPBTBL+(4*BPB_ESIZE)	;
		DW	BPBTBL+(5*BPB_ESIZE)	;
		DW	BPBTBL+(6*BPB_ESIZE)	;
		DW	BPBTBL+(7*BPB_ESIZE)	;
		DW	BPBTBL+(8*BPB_ESIZE)	;
		DW	BPBTBL+(9*BPB_ESIZE)	;
;
; BIOS Parameter Block (BPB) Table
; The address of this table is returned in the BUILD_BPB request.
;
;   Offset is the BPB_PTR entry; entry size is BPB_ESIZE.
;   Index into each entry w/ BPB_* equates.
;   Each entry defines the "volume configuration" of the volume mounted
;     on the unit used to index into MNTTBL.
;
BPBTBL		LABEL	WORD
		 IF	BRKVOLS ; special test vols for BRK testing
		DW	512	; SIZE OF SECTOR (IN BYTES)
		DB	16	; # OF SECTORS/BLOCK
		DW	1	; # OF RESERVED SECTORS
		DB	2	; # OF FILE ALLOCATION TABLES
		DW	256	; # OF DIRECTORY ENTRYS
		DW	4095	; # OF SECTORS/DISK
		DB	?	; MEDIA DESCRIPTOR BYTE ( NON-IBM )
		DW	1	; # OF SECTORS/FAT
;
		DW	512	; SIZE OF SECTOR (IN BYTES)
		DB	16	; # OF SECTORS/BLOCK
		DW	1	; # OF RESERVED SECTORS
		DB	2	; # OF FILE ALLOCATION TABLES
		DW	256	; # OF DIRECTORY ENTRYS
		DW	4095	; # OF SECTORS/DISK
		DB	?	; MEDIA DESCRIPTOR BYTE ( NON-IBM )
		DW	1	; # OF SECTORS/FAT
		 ENDIF
;
		DB	(BPB_ESIZE*(CV_MAX)) DUP (0)	; space for remaining
;							;  entries
;
;
;*****************************
;*   C O R V U S   D A T A   *
;*****************************
;
; Constellation II MSDOS User Name
;
USER		DB	10 DUP (?)	; encrypted logon name,
		DB	0		;   terminated by a zero
		DB	0		;   plus an extra byte for BK
;
; Corvus Volume Mount Table
;
;   Index in by logical unit number (0-?); entry size is 1.
;   Mask off various fields w/ MT_* equates.
;

MNTTBL		LABEL	BYTE
		 IF	BRKVOLS ; special test vols for BRK testing
		DB	01,02
		 ENDIF
		DB	(CV_MAX) DUP (0) ; space for other Corvus volumes
;
; Corvus Volume Offset Table
;
;   Index in by MNTTBL entry MT_TBLMAP field - 1; entry size is CM_ESIZE.
;   Index into each entry w/ CM_* equates.
;   Each entry defines the location of the Corvus volume mounted on the
;     unit used to index into MNTTBL.
;
;
CORMAP		LABEL	WORD
		 IF	BRKVOLS ; special test vols for BRK testing
		DW	50	; disk addr bits 15-0
		DB	0	; disk addr bits 19-16
		DB	1	; CORVUS DRIVE # (1-4)
		DB	0	; DISK SERVER #
;
		DW	4150	; disk addr bits 15-0
		DB	0	; disk addr bits 19-16
		DB	1	; CORVUS DRIVE # (1-4)
		DB	0	; DISK SERVER #
		 ENDIF
;
		DB  (CM_ESIZE*(CV_MAX)) DUP (?) ; space for remaining entries
;
;
;*************************************************************************
;*   S P E C I A L   D A T A   F O R   C O R V U S   U T I L I T I E S	 *
;*************************************************************************
;
; Boot time number of sectors per FAT.
;
;   Index in by MNTTBL entry MT_TBLMAP field - 1; entry size is 2.
;   Each entry is the number of sectors per FAT for the volume mounted
;     on the unit used to index into MNTTBL.
;
BOOTSPF 	DW	CV_MAX DUP (?)	; filled in by INIT
;
; ==== Boot ROM jump table for use by Corvus utility drivers. ====
;		SEGMENT # GETS PATCHED ON STARTUP
;
; This table once directed calls directly to the service
; routines.  NOW it goes indirectly to the service routines by
; way of an internal semaphore test ( used to avoid re-entrance
; problems with "external" programs that use the driver hooks
; on an interrupt basis ).
; NOTE: the segment # of these jumps gets patched to the driver's
;	segment on startup ( initialization ) of the driver.
;
; ---> note: this jump to the video module was added in v5.6 and must
;	     be just before the ROMJUMPS
;
	F_JMP	0,VIDEO 		; video driver ( v5.6 )
ROMJMPS EQU	$
;
	F_JMP	0,XROMJMPS		; ROM cold start
WARMINIT LABEL	NEAR
	F_JMP	0,TSTWARM		; ROM warm start
CRVIO	LABEL	NEAR
	F_JMP	0,TSTCRVIO		; ROM I/O service dispatcher
	F_JMP	0,XDUMRET		; ROM dummy interrupt return
;
;The following table is directed at the ROM I/O service routines
;( either within the driver or externally supported by ROM routines
; or the PCSHARE driver ).  It may be patched on startup.
;
XROMJMPS LABEL	NEAR
	F_JMP	ROMSEG,ROM_COLD 	; ROM cold start
XWARMINIT LABEL NEAR
	F_JMP	ROMSEG,ROM_WARM 	; ROM warm start
XCRVIO	LABEL	NEAR
	F_JMP	ROMSEG,ROM_IO		; ROM I/O service dispatcher
XDUMRET LABEL	NEAR
	F_JMP	ROMSEG,ROM_DUMRET	; ROM dummy interrupt return
;
;***********************************************************
;*   H O O K S	 F O R	 C O R V U S   U T I L I T I E S   *
;***********************************************************
;
; The following data is provided mainly for the Corvus utility drivers.
; Some of the data is hardcoded, some is patched in by the boot code,
;   and the rest is filled in by the INIT procedure of the Corvus driver.
; The location of this table is available via the "dummy" character device
;   driver UTILHOOK.
;
CORTBL		DB	'CORTAb' ; driver identifier string (hardcoded)
		DB	VERSION  ; driver version # (hardcoded)
		DB	REVISION ; driver revision # (hardcoded)
		DB	garbage  ; < formerly 2nd byte of config date >
		DW	BPB_PTR  ; offset to BPB_PTR (hardcoded)
		DW	garbage  ; < formerly ptr to floppy param tbls >
		DW	BPBTBL	 ; < unnecessary, but analogous to DPBASE >
		DW	CORMAP	 ; offset to CORMAP (tbl filled in by HELLOC2)
		DW	MNTTBL	 ; offset to MNTTBL (tbl filled in by HELLOC2)
		DB	CV_MAX	 ; max # of Corvus vols supported (hardcoded)
CV_SUP		DB	CV_SET	 ; # of Corvus vols supported
;				 ;   (filled in by HELLOC2)
FLOPPIES	DB	?	 ; # of floppies and fixed disks
;				 ;   (filled in by INIT)
		DB	CV_MAX	 ; < formerly # of "drivers" there is
;				 ;   table space for >
		DW	offset ROMJMPS	; offset to ROM jump table (hardcoded)
		DW	garbage  ; < formerly DVTDVR >
XPORTER 	DB	FC_XPORT ; transporter # (patched by INIT if OmniNet)
		DW	USER	 ; offset to USER (string filled in by HELLOC2)
CD_SEG		DW	?	 ; driver segment # (filled in by INIT)
CD_LEN		DB	CD_LNG	 ; driver ld len in 512-byte sectors (INIT)
		DW	garbage  ; < formerly ptr to buf w/ DOS-BIOS
;				 ;   boot file name >
BSERVER 	DB	FC_BTSRV ; boot server # (patched by INIT if OmniNet)
		DW	BOOTSPF  ; offset to BOOTSPF (table filled in by INIT)
DRVBUSY 	DB	0	 ; semaphore (FF = driver busy, 0 = not )
		DW	offset SYSID ; pointer to system ID string (v5.6)
DVRTYP		DB	0	 ; flag indicating driver type that is
				 ; supporting the "rom jumps"
;				 ;  0 = builtin driver
;				 ;  1 = PCSHARE ( OMNISHARE ) driver
;				 ;  2 = NET BOSS driver
		DW	offset SHADOW_TBL  ;pointer to the Shadow table (v6.0)
		DW	SHADOW	 ; Shadow drive version ?   True = yes
;
;
;*******************************************************************
;*   M I S C E L L A N E O U S	 U T I L H O O K   B U F F E R S   *
;*******************************************************************
;
CTA_OFF 	DW	?	; offset of CORTBL location
CTA_SEG 	DW	?	; segment of CORTBL location
CTAindex	DW	?	; current index into data at CTA
;
;
;***************************************************************
;*   M I S C E L L A N E O U S	 C O R V U S   B U F F E R S   *
;***************************************************************
;
; The following 4-byte sequence is a BCI command.
; The RW_SECTOR procedure passes this to the ROM_IO procedures @ DS:SI.
;
DSKCMD		DB	?	; BCI cmd (BCI_READ or BCI_WRITE)
DA_DRV		DB	?	; disk addr bits 19-16 & drv # (from CORMAP)
DSKADR		DW	?	; disk addr bits 15-0
;
; Data Transfer Area (DTA) information.
;
; The RW_DATA procedure converts the 4-byte address in the DTA field of the
;   INPUT/OUTPUT/OUT_VERIFY request to the equivalent address w/ the offset
;   value less than 16 (to ensure that segment wraparound cannot occur).
;
; This address is stored at DTAOFF and DTASEG.	The RW_SECTOR command reads
;   this address and passes it to the ROM_IO procedures ROM_READ or ROM_WRITE
;   at ES:DI.  The segment number is incremented by the RW_DATA procedure.
;
; The RW_DATA procedure stores the 2-byte sector-count in the COUNT field of
;   the INPUT/OUTPUT/OUT_VERIFY request at DTALEN and decrements it as each
;   sector is transferred successfully.  It returns the final value at DTALEN
;   to the INPUT/OUTPUT/OUT_VERIFY procedure in CX so that it can be returned
;   in the COUNT field of the request.
;
DTALOC	LABEL	DWORD
DTAOFF		DW	?	; data transfer area offset
DTASEG		DW	?	; data transfer area segment
DTALEN		DW	?	; data transfer area length
;
; Number of bytes for the ROM read/write routine to transfer.
; Set by RW_DATA procedure to SECTSIZE or less.
; Value sent to boot ROM code at ROM_IO entry for ROM_READ or ROM_WRITE cmd..
;
XFERSIZE	DW	?	; # of bytes to transfer, SECTSIZE or less
;
; The following information is meaningful only for OmniNet.
; The RW_SECTOR procedure passes this to the ROM_IO procedures
; in AL, BL, and BH.
;
SERVER		DB	?	; disk server station #
XMITDESC	LABEL	WORD	;
		DB	WAIT	; # of .86 sec ticks to wait on disk server
		DB	RETRIES ; # of retransmissions before aborting
;
; OUT_VERIFY flag used by procedure RW_SECTOR.
;
VFYFLG		DB	?	; 0 => clear, FFh => set
;
; Storage for the original stack location.
;
OSTKOFF 	DW	?	; save original stack offset
OSTKSEG 	DW	?	; save original stack segment


  IF (SHADOW)
;
; Storage for # of sectors to transfer (v6.0 nod)
;
SAVCNT		DW	?	; a saved copy of COUNT[BX]
;
; Saved area for server number	  (v6.0 nod)
;
SAVSRV		DW	?	; a saved copy of CORMAP(CM_SRVNUM)
SAVSRV2 	DW	?	; a saved copy of CORMAP(CM_SRVNUM)
;				; this copy saves the server # of the master
;
; Saved area for mates server number  (v6.0 nod)
;
MATE_NBR	DW	?	; a saved copy of SHADOW_TBL(SERVER,MATE #)
;
; Type of drive (v6.0 nod)
;  Value comes from SHADOW_TBL(server#,1)
;	0 = Either the drive does not exist or it is a SLAVE in a SHADOW pair
;	1 = Drive is in NORMAL mode
;	2 = Drive is a MASTER in a SHADOW pair
;
DRV_TYPE	DB	?	; Type of drive (normal, master, slave)
;
; Offset to a specific volumn in CORMAP. (v6.0 nod)
;
CRM_OFFSET	DW	?	;
;
; Used to when an error occures to determine if the command needs to be
; re-issued.  Command are re-issued when the error occured on the master.
; (v6.0 nod)
;
RE_ISSUE	DB	?	; TRUE or FALSE
;
; Used to store the active video display page. (v6.0 nod)
;
PAGNBR		DB	?	; active video display page number
;
;
; Holds the error code from a drive error.  Used to set the Mate Status flag
;
ERR_TYPE	DB	?	;
;
; Various storage locations for use with semaphores.
;
SAVAX		DW	0	; Save the AX register
SAVBX		DW	0	; Save the BX register
SAVCX		DW	0	; Save the CX register
SAVDX		DW	0	; Save the DX register
SAVDI		DW	0	; Save the DI register
SAVSI		DW	0	; Save the SI register
LOCALDI 	DB    530 DUP(?) ; Local buffer
COMMAND1	DB	0	; Saved sema4 command byte #1
COMMAND2	DB	0	; Saved sema4 command byte #2
;
;***************************************************************
;*   O M N I N E T   C O M M A N D S			       *
;***************************************************************
;
READSTATUS	LABEL	NEAR		;(v6.0 nod)
	DB	53H			;Opcode = SHADOW command
	DB	05H			;Sub Op = Get SHADOW status

SHADOW_STATUS	LABEL	NEAR		;(v6.0 nod)
DRVMODE DB	0			;Drive mode flag
DRVTYPE DB	0			;Drive type flag
MATEADR DB	0			;Mate address
MATESTS DB	0			;Mate status flag

GOOFFLINE	LABEL	NEAR		;(v6.0 nod)
	DB	53H			;Opcode = SHADOW command
	DB	04H			;Sub Op = Set drive offline

GOOUTSHDO	LABEL	NEAR		;(v6.0 nod)
	DB	53H			;Opcode = SHADOW command
	DB	03H			;Sub Op = Go out of SHADOW mode

SETSTATUS	LABEL	NEAR		;(v6.0 nod)
	DB	53H			;Opcode = SHADOW command
	DB	06H			;Sub Op = Set the Mate Status flag
MTSTATS DB	0			;Place to store mate status value

  ENDIF


;
;***************************************************
;*   D E V I C E   F U N C T I O N   T A B L E S   *
;***************************************************
;
;   The device interrupt handler (@ CS:DEV_INT) uses this table.
;   Index in by command code number to get offset of corresponding procedure.
;
DUMTBL		DW	DUMINIT ; cmd code  0: initialization
		DW	NO_OP	; cmd code  1: media check	(blk devs only)
		DW	NO_OP	; cmd code  2: build BPB	(blk devs only)
		DW	NO_OP	; cmd code  3: IOctl input
		DW	DUM_IN	; cmd code  4: input (read)
		DW	DUM_IN	; cmd code  5: non-destr input(char devs only)
		DW	DUM_STAT ; cmd code  6: input status (char devs only)
		DW	DUM_FLUSH ; cmd code  7: input flush (char devs only)
		DW	DUM_OUT ; cmd code  8: output (write)
		DW	DUM_OUT ; cmd code  9: output (write) with verify
		DW	DUM_STAT ; cmd code 10: output status (char devs only)
		DW	DUM_FLUSH ; cmd code 11: output flush (char devs only)
		DW	NO_OP	 ; cmd code 12: IOctl output

  IF (NOT SHADOW)
;
;   The device interrupt handler (@ CS:DEV_INT) uses this table.
;   Index in by command code number to get offset of corresponding procedure.
;
FUNTBL		DW	INIT	 ; cmd code  0: initialization
		DW	MEDIA_CHECK ; cmd code	1: media check (blk devs only)
		DW	BUILD_BPB ; cmd code  2: build BPB	(blk devs only)
		DW	NO_OP	; cmd code  3: IOctl input
		DW	INPUT	; cmd code  4: input (read)
		DW	NO_OP	; cmd code  5: non-destr input (char devs only)
		DW	NO_OP	; cmd code  6: input status (char devs only)
		DW	NO_OP	; cmd code  7: input flush (char devs only)
		DW	OUTPUT	; cmd code  8: output (write)
		DW	OUT_VERIFY ;cmd code  9: output (write) with verify
		DW	NO_OP	; cmd code 10: output status (char devs only)
		DW	NO_OP	; cmd code 11: output flush (char devs only)
		DW	NO_OP	; cmd code 12: IOctl output

  ELSE
;
;
;   The device interrupt handler (@ CS:DEV_INT) uses this table.
;   Index in by command code number to get offset of corresponding procedure.
;
FUNTBL		DW	INIT	 ; cmd code  0: initialization
		DW	MEDIA_CHECK ; cmd code	1: media check (blk devs only)
		DW	BUILD_BPB ; cmd code  2: build BPB	(blk devs only)
		DW	NO_OP	; cmd code  3: IOctl input
		DW	IO	; cmd code  4: input (read)
		DW	NO_OP	; cmd code  5: non-destr input (char devs only)
		DW	NO_OP	; cmd code  6: input status (char devs only)
		DW	NO_OP	; cmd code  7: input flush (char devs only)
		DW	IO	; cmd code  8: output (write)
		DW	IO	; cmd code  9: output (write) with verify
		DW	NO_OP	; cmd code 10: output status (char devs only)
		DW	NO_OP	; cmd code 11: output flush (char devs only)
		DW	NO_OP	; cmd code 12: IOctl output
;
;   The device interrupt handler (@ CS:DEV_INT) uses this table.
;   Index in by command code number to get offset of corresponding procedure.
;   At this point only reads and writes should be valid.  Commands 4, 8, & 9
;   in FUNTBL point us to this table.  (v6.0 nod)
;
IOTBL		DW	NO_OP	; cmd code  0: initialization
		DW	NO_OP	; cmd code  1: media check (blk devs only)
		DW	NO_OP	; cmd code  2: build BPB      (blk devs only)
		DW	NO_OP	; cmd code  3: IOctl input
		DW	INPUT	; cmd code  4: input (read)
		DW	NO_OP	; cmd code  5: non-destr input (char devs only)
		DW	NO_OP	; cmd code  6: input status (char devs only)
		DW	NO_OP	; cmd code  7: input flush (char devs only)
		DW	OUTPUT	; cmd code  8: output (write)
		DW	OUT_VERIFY ; cmd code  9: output (write) with verify
		DW	NO_OP	; cmd code 10: output status (char devs only)
		DW	NO_OP	; cmd code 11: output flush (char devs only)
		DW	NO_OP	; cmd code 12: IOctl output

  ENDIF

;
;   This table is used to keep track of a shadow drive pair.  There
;   are two entries in the table for each drive server on the network.
;   1st is a value specifing the drive type.
;    -1 = either the server does not exist or it is in a 'OFFLINE' state
;     0 = it is a NORMAL Omnidrive and not in shadow mode
;     1 = it is a MASTER
;     2 = it is a SLAVE in a shadow pair
;   The 2nd entry for each server is the server number of its mate for a drive
;   in SHADOW mode.  This table is populated during user logon.  (v6.0 nod)
;
SHADOW_TBL	DB	DT_OFFLINE		       ; drive type
		DB	DT_OFFLINE		       ; server number of mate
;						       ; .. (shadow mode only)
		DB	(2*MAX_SRVRS) DUP (DT_OFFLINE) ; space for the rest of
;						       ; ... the table.
;
;
;*******************************************
;*   L O C A L	 P R O C E D U R E ( S )   *
;*******************************************
;
;************************************************************************
;* procedure:	RW_SECTOR						*
;*									*
;* input:	db CS:DSKCMD = BCI cmd					*
;*		db CS:DA_DRV = disk addr bits 19-16 & drive #		*
;*		dw CS:DSKADR = disk addr bits 15-0			*
;*		dw CS:DTAOFF = data transfer area offset		*
;*		dw CS:DTASEG = data transfer area segment		*
;*		dw CS:DTALEN = data transfer area length		*
;*		dw CS:XFERSIZE = # of bytes to transfer 		*
;*									*
;*		dw CS:SERVER = disk server station # if OmniNet 	*
;*		db CS:WAIT   = # of .86 seconds to wait on server	*
;*				if OmniNet				*
;*		db CS:RETRIES= # of xmit retries			*
;*									*
;* updates:	data at DTA if BCI cmd is BCI_READ			*
;*		data on Corvus drive if BCI cmd is BCI_WRITE		*
;*									*
;* output:	NC => no error						*
;*		 C => error, code in AL 				*
;*									*
;* destroys:	AX,CX,DX,status 					*
;************************************************************************
;
OV_FAIL 	DB	CR,LF,BEL
		DB	"Output verification failure"
		DB	CR,LF,"$"
;
RW_SECTOR	PROC	NEAR
;
; Save some registers.
;
	PUSH	DS			;
	PUSH	SI			;
	PUSH	ES			;
	PUSH	DI			;
	PUSH	BX			;
;
; Set up ROM command code in AH.
; Set up ES:DI -> DTA.
;
	MOV	AH,ROM_WRITE		;
	CMP	BYTE PTR DSKCMD,BCI_WRITE	;
	JZ	RWS_0			;
	MOV	AH,ROM_READ		;
RWS_0:	LES	DI,DTALOC		;
;
; Set up remaining parameters to pass to ROM_IO procedure.
;
	LEA	SI,DSKCMD		; DS:SI -> BCI cmd
	MOV	CX,4			; CX = BCI cmd len
	MOV	DX,WORD PTR XFERSIZE	; DX = number of bytes to transfer
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries (if OmniNet)
	MOV	AL,BYTE PTR SERVER	; AL = server # 	  (if OmniNet)
;
; Dispatch to the ROM I/O service routine.
;
	PUSH	CS			; FAKE "FAR" CALL (V5.4)
	CALL	CRVIO

  IF (SHADOW)
;
; Strip off the Mode flag from the "number of bytes received" count (v6.0)
;
	MOV	BX,CX			;Save the count
	AND	CH,10011111B		;Strip out the Mode flag
	PUSH	CX
	MOV	CL,13
	SHR	BX,CL			;Shift the Mode flag to the right
	POP	CX			;... 2 bits  (bits 0 & 1)
	AND	BL,00000011B		;Mask off everything but the Mode flag
	MOV	DRVMODE,BL		;Save the Mode flag
  ENDIF
;
	TEST	AL,80h			; if no error,
	JZ	RWS_VFY 		;   continue

  IF (SHADOW)
	MOV	ERR_TYPE,AL		; Save the error code (v6.0)
  ENDIF
;
; Set the error code in AL according to the device request.
; The previous TEST set the zero flags and the carry flag, but
;   the following CMP affects the carry flag, so set it again.
;
	MOV	AL,DE_write		; DOS "write fault" error
	CMP	BYTE PTR DSKCMD,BCI_WRITE	; v5.7 bug fix
	JZ	RWS_1			;
	MOV	AL,DE_read		; DOS "read fault" error
RWS_1:	STC				;   and set carry
	JMP	RWS_3			; go to exit
;
; If the request was OUT_VERIFY, the byte at CS:VFYFLG is set.
;
RWS_VFY:CMP	BYTE PTR VFYFLG,0	; if flag is clear,
	JZ	RWS_3			;   there's nothing to verify
;
; Read the sector back into a safe buffer.
;
	MOV	AH,ROM_READ		; AH = ROM xmit/recv from drv cmd code
	MOV	CX,4			; CX = # of BCI cmd bytes to send
	MOV	BYTE PTR DSKCMD,BCI_READ; DS:SI -> 4-byte BCI cmd to send
	LEA	SI,DSKCMD		;
	MOV	DX,WORD PTR XFERSIZE	; DX = # of bytes to recv
	PUSH	CS			; ES:DI -> DTA SCRATCH
	POP	ES			;
	LEA	DI,SCRATCH		;
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries (if OmniNet)
	MOV	AL,BYTE PTR SERVER	; AL = server # 	  (if OmniNet)
;
	PUSH	CS			; FAKE "FAR" CALL (V5.4)
	CALL	CRVIO			; xmit & recv
;
	MOV	BYTE PTR DSKCMD,BCI_WRITE	; restore BCI cmd byte
;
; Strip off the Mode flag from the "number of bytes received" count (v6.0)
;
  IF (SHADOW)
	MOV	BX,CX			;Save the count
	AND	CH,10011111B		;Strip out the Mode flag
	PUSH	CX
	MOV	CL,13
	SHR	BX,CL			;Shift the Mode flag to the right
	POP	CX			;... 2 bits  (bits 0 & 1)
	AND	BL,00000011B		;Mask off everything but the Mode flag
	MOV	CS:DRVMODE,BL		;Save the Mode flag
  ENDIF
	TEST	AL,80h			; if error occurred in the ROM routine,
	JNZ	RWS_2			;   print verify failure msg
;					;   & exit w/carry set
  IF (SHADOW)
	MOV	ERR_TYPE,AL		; Save the error code
  ENDIF
;
; If the data just read back from the drive
;   compares equal to the source, everything's okay.
;
	MOV	CX,WORD PTR XFERSIZE	; CX = maximum # of bytes to compare
	PUSH	CS			; ES:DI -> DTA scratch
	POP	ES			;
	LEA	DI,SCRATCH		;
	PUSH	DS			; save DS
	LDS	SI,DTALOC		; DS:SI -> DTA spec'd by OUT_VERIFY
	REPZ	CMPSB			; compare a string of bytes until NZ
;					;  or CX = 0
	POP	DS			; restore DS
	JZ	RWS_3			; if compare is okay, exit w/NC
;
; Output verification failed.
;
RWS_2:	LEA	AX,OV_FAIL		; print a Corvus msg at the console
	PUTSTR	AX			;
	MOV	AL,DE_general		; return a DOS error code in AL
	STC				; set carry then fall thru to exit code
;
; Restore saved registers (but preserve AL and carry flag).
;
RWS_3:	POP	BX			;
	POP	DI			;
	POP	ES			;
	POP	SI			;
	POP	DS			;
	RET				; return to RW_DATA procedure
;
RW_SECTOR	ENDP			;
;
;
;************************************************************************
;* procedure:	RW_DATA 						*
;*									*
;* input:	ES:BX -> INPUT, OUTPUT, or OUT_VERIFY SRH		*
;*		AH = BCI cmd (BCI_READ or BCI_WRITE)			*
;*									*
;* updates	data at DTA if BCI cmd is BCI_READ			*
;*		data on Corvus drive if BCI cmd is BCI_WRITE		*
;*		# of sectors left to xfer in COUNT fld of		*
;*		 INPUT/OUTPUT/OUT_VERIFY req				*
;*		STATUS fld of INPUT/OUTPUT/OUT_VERIFY SRH		*
;*									*
;* destroys:	AX,CX,DX,status,SI,DI					*
;************************************************************************
;
RW_DATA PROC	NEAR
;
; Check that the count of sectors to transfer is not zero.
;
	MOV	CX,ES:WORD PTR COUNT[BX]; CX = # of sectors to transfer
	OR	CX,CX			; if zero,
	JNZ	RWD_0			;
	JMP	RWD_4			;   this procedure is a no-op
;
; Prepare for RW_SECTOR loop.
;
RWD_0:	MOV	ES:WORD PTR COUNT[BX],0 ; zero # of sectors to transfer
	MOV	BYTE PTR DSKCMD,AH	; store BCI cmd
	MOV	WORD PTR DTALEN,CX	; store # of sectors left to transfer
	MOV	AX,ES:WORD PTR DTA_OFF[BX] ; make sure no wraparound in DTA
	PUSH	AX			;
	AND	AX,0Fh			;
	MOV	WORD PTR DTAOFF,AX	;
	POP	AX			;
	MOV	CL,4			;
	SHR	AX,CL			;
	MOV	CX,ES:WORD PTR DTA_SEG[BX]	;
	ADD	AX,CX			;
	MOV	WORD PTR DTASEG,AX	;
;
; Get the MNTTBL entry based on the unit code passed in the SRH.
; If the volume is readonly and the command is BCI_WRITE, abort.
;
	MOV	AL,ES:BYTE PTR SRH_UCD_FLD[BX]	; AX = unit code
	XOR	AH,AH			;
	LEA	SI,MNTTBL		; SI -> MNTTBL
	ADD	SI,AX			; SI -> MNTTBL entry
	MOV	AL,[SI] 		; AL = MNTTBL entry
	TEST	AL,MT_RO		; if readonly
	JZ	RWD_1			;
	CMP	BYTE PTR DSKCMD,BCI_WRITE ; if cmd is BCI_WRITE
	JZ	PRO_RWD 		;   "write protect violation"
;
; Get the CORMAP entry using the index masked from the MNTTBL entry.
; Add the Corvus volume offset value to the starting sector # in the request.
;
RWD_1:	AND	AL,MT_TBLMAP		; AL = index into CORMAP & BPB_PTR
	JNZ	RWD_15			; if mounted, proceed	 v5.3
;
	MOV	AL,DE_nrdy		; if unmounted, set "drive not ready"
	JMP	ERR_RWD 		;  and exit with error	v5.3
;
RWD_15: DEC	AL			;
	MOV	CL,CM_ESIZE		; AL = offset into CORMAP
	MUL	CL			;
	LEA	DI,CORMAP		; DI -> CORMAP
	ADD	DI,AX			; DI -> CORMAP entry
	MOV	CX,ES:WORD PTR SSN[BX]	; CX = starting sector #
	MOV	AX,WORD PTR CM_DA_LO[DI]; AX = Corvus disk addr bits 15-0
	ADD	AX,CX			; compute effective disk addr bits 15-0
	MOV	WORD PTR DSKADR,AX	;
	MOV	AL,BYTE PTR CM_DA_HI[DI]; compute effective dsk addr bits 19-16

	MOV	WORD PTR XFERSIZE,SECTSIZE ; *********************************

	JNC	RWD_2			;
	INC	AL			;
RWD_2:	MOV	CL,4			;   and shift it into the upper nibble
;					;    of AL
	ROL	AL,CL			; v5.4
	MOV	AH,BYTE PTR CM_DRVNUM[DI] ; get Corvus drive number
	ADD	AL,AH			; and ADD it with the high 4 bits of
;					;   the disk address  (V5.4)
	MOV	BYTE PTR DA_DRV,AL	;
	MOV	AL,BYTE PTR CM_SRVNUM[DI] ; set server # in case OmniNet
	MOV	BYTE PTR SERVER,AL	;
;
; Transfer data one sector at a time.
;
RW_LOOP:CALL	RW_SECTOR		; transfer one sector
	JC	ERR_RWD 		; if error, exit w/carry set,code in AL
	INC	WORD PTR DSKADR 	; incr disk addr bits 15-0
	JNZ	RWD_3			; if rollover,
	ADD	BYTE PTR DA_DRV,10h	;   incr bits 19-16
	JNC	RWD_3			; if no overflow  (v5.4)
	INC	BYTE PTR DA_DRV 	; if overflow, inc bits 23-20
RWD_3:	ADD	WORD PTR DTASEG,32	; bump DTA addr by 1 sector
	INC	ES:WORD PTR COUNT[BX]	; incr # of sectors transferred
	DEC	WORD PTR DTALEN 	; decr # of sectors left to transfer
	JNZ	RW_LOOP 		; loop until all sectors transferred
;
; Successful exit from RW_DATA procedure.
;
RWD_4:	STATUS	DONE,NOERROR,0		; set status word DONE,NOERROR
	RET				; return to INPUT, OUTPUT,
;					;  or OUT_VERIFY
;
; Attempted to write to a protected volume.
; Fall through to the error exit code below.
;
PRO_RWD:MOV	AL,DE_protect		; DOS "write protect violation" error
;
; Error exit from RW_DATA procedure, error code in AL.
;
ERR_RWD:MOV	AH,0			; set status word DONE,ERROR,r/w fault
	STATUS	DONE,ERROR,AX		;
	STC				; set carry flag
	RET				; return to INPUT, OUTPUT,
;					;  or OUT_VERIFY
;
RW_DATA ENDP				; end of procedure
;
  IF (SHADOW)
;
;************************************************************************
;*									*
;* procedure:	SHADOW_ERROR		v6.0 nod			*
;*									*
;* input:	DRV_TYPE						*
;*									*
;* output:								*
;*									*
;* updates:	Nothing if drive is not a SHADOW drive.  Flags in	*
;*		the drive RAM area and on the drive firmware disk	*
;*		surface.  SHADOW_TBL and CORMAP are also updated.	*
;*									*
;* destroys:	AX, DI, SI						*
;*									*
;************************************************************************
;
SHADOW_ERROR	PROC	NEAR
;
	PUSH	DI				; Save the DI register
	PUSH	DS				; Save the Data Segment
	PUSH	CS				; Set DS equal to CS
	POP	DS
;
	PUSH	BX
;
;  Set the default to not re-issue the command.
;
	MOV	RE_ISSUE,FALSE			; do not re-issue the command
;
;  If the drive is not a master or slave in a SHADOW pair then return
;
	MOV	SI,SAVSRV			; Use the server # as a tbl ...
	ROL	SI,1				; ... offset into SHADOW_TBL
	CMP	SHADOW_TBL[SI],DT_NORMAL	; Is it a NORMAL drive ?
	JNZ	ERR020				; No  -- see if SHADOW PROM
	JMP	ERROR_EXIT			; Yes -- so get out of here
ERR020: CMP	SHADOW_TBL[SI],NO_SHADOW_PROM	; Does it have the SHADOW PROM?
	JNZ	ERR040				; Yes -- see if it's OFFLINE
	JMP	ERROR_EXIT			; No  -- so get out of here
ERR040: CMP	SHADOW_TBL[SI],DT_OFFLINE	; Is the drive OFFLINE ?
	JNZ	ERR060				; No  -- send GO OFFLINE cmd
	JMP	ERROR_EXIT			; Yes -- so get out of here
;
;  Send a "GO OFFLINE" command to the drive with the error.
;  This cmd will set the drive type flag and the RAM mode flag to "OFFLINE".
;
ERR060: MOV	SI,OFFSET GOOFFLINE	; Omninet command
	MOV	AX,SAVSRV		; Node number to talk to
	MOV	CX,2			; Number of bytes to send
	MOV	DX,0			; Number of bytes to receive
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries
	MOV	AH,1			; ROM command
	PUSH	CS			;
	CALL	CRVIO			;
;
;  Send a "GO OUT OF SHADOW MODE" command to the other drive in the SHADOW pair
;  This cmd will set the drive type flag to "NORMAL" and the RAM mode flag
;  to "MATE OFFLINE".
;
	MOV	BX,SAVSRV		; NODE WERE ERROR OCCURED
	SHL	BX,1			; CONVERT NODE NBR TO TBL POINTER
	XOR	AX,AX			; INITIALIZE THE AX REGISTER TO 0
	MOV	AL,SHADOW_TBL[BX+1]	; GET THE NODE NUMBER TO TALK TO (MATE)
	MOV	SI,OFFSET GOOUTSHDO	; OMNINET COMMAND
	MOV	CX,2			; NUMBER OF BYTES TO SEND
	MOV	DX,0			; NUMBER OF BYTES TO RECEIVE
	MOV	BX,WORD PTR XMITDESC	; BL = WAIT, BH = RETRIES
	MOV	AH,1			; ROM COMMAND
	PUSH	CS			;
	CALL	CRVIO			;
;
;  If the error was because the drive was in the OFFLINE mode (or should
;  have been in the OFFLINE mode) then do not set the mate status flag.
;
	CMP	DRVMODE,DM_OFFLINE
	JZ	ERR100
	CMP	DRVMODE,DM_MATEOFF
	JZ	ERR100
;
;  Set the MATE STATUS FLAG on the good drive to indicate the error
;  that occured.
;
	MOV	BX,SAVSRV		; Node were error occured
	SHL	BX,1			; Convert node nbr to tbl pointer
	XOR	AX,AX			; Initialize the AX register to 0
	MOV	AL,SHADOW_TBL[BX+1]	; Get the node number to talk to (mate)
	MOV	SI,OFFSET SETSTATUS	; Omninet command
	MOV	CL,ERR_TYPE		;
	MOV	MTSTATS,CL		; Load the error number to store
	MOV	CX,3			; Number of bytes to send
	MOV	DX,0			; Number of bytes to receive
	MOV	BX,WORD PTR XMITDESC	; BL = wait, BH = retries
	MOV	AH,1			; ROM command
	PUSH	CS			;
	CALL	CRVIO			;
;
;  Change SHADOW_TBL to indicate the new status of the two drives.  If the
;  error occured on the master drive then also perform a switch of server
;  numbers, that is change the server number entry in CORMAP to the slave
;  server number.
;
ERR100: MOV	SI,SAVSRV			; Get this server number
	MOV	AX,SI				; Copy the server number
	ROL	SI,1				; Mult by 2 to get tbl offset
	MOV	BL,SHADOW_TBL[SI+1]		; Get the mates server number
	XOR	BH,BH
	MOV	MATE_NBR,BX			; Save the mates server number
	CMP	AL,BSERVER			; Is bad drive the boot server
	JNZ	ERR110				; No -- then jump
	MOV	BSERVER,BL			; Yes -- set new boot server #
ERR110: MOV	SHADOW_TBL[SI],DT_OFFLINE	; Set this drive to OFFLINE
	MOV	SI,BX				; Use the mates server # now
	ROL	SI,1				; Mult by 2 to get tbl offset
	MOV	SHADOW_TBL[SI],DT_NORMAL	; Set the mate to NORMAL
	CMP	DRV_TYPE,DT_MASTER		; Did the error occur on master
	JNE	ERR200				; No -- only change SHADOW_TBL
;
	MOV	SI,4				; index to Server # in CORMAP
ERR120: CMP	BYTE PTR CORMAP[SI],AL		; Is this vol on the bad srvr ?
	JNE	ERR140				; No -- so don't switch srvrs
	MOV	BYTE PTR CORMAP[SI],BL		; Switch to slaves server #
ERR140: ADD	SI,5				; Pnt to next volumn in CORMAP
	CMP	SI,CM_ESIZE*CV_MAX		; Make sure not pnting past tbl
	JLE	ERR120				; Still within CORMAP so cont.
	MOV	SAVSRV2,BX			; Don't restore the server nbr
;						; ... to the srvr with the error
;						; ... so set it to the mate nbr
;
;
;  If the error was on the master then we need to re-issue the cmd.
;
	MOV	RE_ISSUE,TRUE			; need to re-issue the command
;
;  Inform the user of the error and that he is no longer in shadow mode.
;
ERR200: CALL	TELL_USER
;
;  Exit the shadow error routine
;
ERROR_EXIT:
	POP	BX				; Restore the saved registers
	POP	DS				; ... off of the stack.
	POP	DI				;
	RET
;
SHADOW_ERROR	ENDP
;
;
;************************************************************************
;*									*
;* procedure:	TELL_USER		v6.0 nod			*
;*									*
;* input:	SAVSRV, DRV_TYPE, MATE_NBR				*
;*									*
;* output:								*
;*									*
;* updates:								*
;*									*
;* destroys:								*
;*									*
;************************************************************************
;
; Local DATA
;
LINE		DW	120 DUP(?)		; area for saved lines 23-25
SAVCSR		DW	?			; saved cursor position
MSG1		DB	"WARNING: Error on MASTER drive."
MSG2		DB	"SRVR #00 shut down, using SRVR #00 only."
MSG3		DB	"   <Press any key to continue>"
MSG4		DB	"MASTER"
MSG5		DB	"SLAVE "
MSG1LEN 	EQU	31			; number of bytes in MSG1
MSG2LEN 	EQU	40			; number of bytes in MSG2
MSG3LEN 	EQU	30			; number of bytes in MSG3
MSG4LEN 	EQU	 6			; number of bytes in MSG4/5
MSG4STRT	EQU	18			; loc in MSG1 to insert MSG4/5
FRSTSRVR	EQU	 6			; loc in MSG2 to insert srvr #
SCNDSRVR	EQU	32			; loc in MSG2 to insert srvr #
;
;
TELL_USER	PROC	NEAR
;
;  Save the cursor position.
;
	MOV	AH,3				; read cursor position function
	INT	10H				; BIOS - video_io call
	MOV	SAVCSR,DX			; save the cursor position
	MOV	PAGNBR,BH			; save the page number
;
; Make a saved copy of columns 1-40 on lines 23, 24, and 25
;
	XOR	DI,DI
	XOR	SI,SI
	MOV	CX,1				; Count of characters to write
	MOV	DX,1600H			; position the cursor @ 23,1
READ_LINE:
	MOV	AH,2				; set cursor position function
	MOV	BH,PAGNBR			; restore the page number
	INT	10H				; BIOS - video_io call
	MOV	AH,8				; read attr/char @ cursor pos
	INT	10H				; BIOS - video_io call
	MOV	LINE[DI],AX			; AL=character, AH=attribute
	MOV	AH,9				; write attr/char @ crsr pos
	MOV	AL,' '                          ; output a blank
	MOV	BL,112				; attribute for reverse video
	INT	10H				; BIOS - video_io call
	ADD	DI,2				; update LINE index
	INC	DL				; update column position
	INC	SI				; increment nbr of chars read
	CMP	SI,40				; have we read 40 chars yet ?
	JL	READ_LINE			; no -- so loop again
	JE	SETROW				; yes -- so reset the row & col
	CMP	SI,80				; have we read 80 chars yet ?
	JL	READ_LINE			; no -- so loop again
	JE	SETROW				; yes -- so reset the row & col
	CMP	SI,120				; have we read 120 chars yet ?
	JE	MSGOUT				; yes -- then go write the msg
	JMP	READ_LINE			; no -- continue to save line
SETROW: MOV	DL,00				; now set col to 1
	INC	DH				; increment the column
	JMP	READ_LINE
;
;  If the drive is a master then load "MASTER." into MSG1, otherwise load
;  "SLAVE. " into MSG1.
;
MSGOUT:
	CMP	DRV_TYPE,DT_MASTER		; is the drive a master ?
	JNE	SLV				; no -- then use MSG4
	MOV	SI,OFFSET MSG4
	JMP	M0
SLV:	MOV	SI,OFFSET MSG5
M0:	MOV	DI,MSG4STRT
	MOV	CX,MSG4LEN			; get number of bytes to move
LOADMSG0:
	MOV	AL,[SI] 			; get the character in MSG3/4
	MOV	MSG1[DI],AL			; and put it into MSG1
	INC	SI				; point to next char to get
	INC	DI				; point to nxt loc to put char
	LOOP	LOADMSG0
;
;  Load the correct server numbers into the output string.
;
	MOV	AX,SAVSRV			; get srvr # where err occured
	CALL	CNVRT_SRVR			; convert srvr # to ASCII
	MOV	DI,FRSTSRVR			; location to insert server #
	MOV	MSG2[DI],AH			; put in first character
	MOV	MSG2[DI+1],AL			; put in second character
;
	MOV	AX,MATE_NBR			; get srvr # of mate
	CALL	CNVRT_SRVR			; convert srvr # to ASCII
	MOV	DI,SCNDSRVR			; location to insert server #
	MOV	MSG2[DI],AH			; put in first character
	MOV	MSG2[DI+1],AL			; put in second character
;
;  Output MSG1 on line 23 of the screen
;
	MOV	BH,PAGNBR			; restore the page number
	MOV	CX,1				; reset CX for INT 10H calls
	XOR	SI,SI
	MOV	DX,1600H			; position the cursor @ 23,1
M1:	MOV	AH,2				; set cursor position function
	INT	10H				; BIOS - video_io call
	MOV	AH,10				; write char only @ crsr pos
	MOV	AL,MSG1[SI]
	INT	10H				; BIOS - video_io call
	INC	SI
	CMP	SI,MSG1LEN - 1
	JG	M2
	INC	DL				; increment the column
	JMP	M1
;
;  Output MSG2 on line 24 of the screen
;
M2:	XOR	SI,SI
	MOV	DX,1700H			; now set row to 24 & col to 1
M3:	MOV	AH,2				; set cursor position function
	INT	10H				; BIOS - video_io call
	MOV	AH,10				; write char only @ crsr pos
	MOV	AL,MSG2[SI]
	INT	10H				; BIOS - video_io call
	INC	SI
	CMP	SI,MSG2LEN - 1
	JG	M4
	INC	DL				; increment the column
	JMP	M3
;
;  Output MSG3 on line 25 of the screen
;
M4:	XOR	SI,SI
	MOV	DX,1800H			; now set row to 24 & col to 1
M5:	MOV	AH,2				; set cursor position function
	INT	10H				; BIOS - video_io call
	MOV	AH,10				; write char only @ crsr pos
	MOV	AL,MSG3[SI]
	INT	10H				; BIOS - video_io call
	INC	SI
	CMP	SI,MSG3LEN - 1
	JG	WAKE_UP
	INC	DL				; increment the column
	JMP	M5
;
; Beep the bell at the user (wake'em up)
;
WAKE_UP:
	MOV	CX,5				; Nbr of times to beep the bell
BEEP_BELL:
	MOV	AH,14				; write teletype function
	MOV	AL,BELL 			; output the bell character
	INT	10H				; BIOS - video_io call
	LOOP	BEEP_BELL
;
;  Wait for a character to be pressed, then continue
;
	MOV	AX,0C08H			; get any character from the
	INT	21H				; ... keybrd before continueing
;
;  Restore the screen to its original content
;
	XOR	DI,DI
	XOR	SI,SI
	MOV	CX,1
	MOV	DX,1600H			; position the cursor @ 23,1
RSTR_LINE:
	MOV	AH,2				; set cursor position function
	MOV	BH,PAGNBR			; restore the page number
	INT	10H				; BIOS - video_io call
	MOV	AH,9				; write attr/char @ cursor pos
	MOV	AL,BYTE PTR LINE[DI]		; AL = character
	MOV	BL,BYTE PTR LINE[DI+1]		; BL = attribute
	INT	10H				; BIOS - video_io call
	ADD	DI,2				; update LINE index
	INC	DL				; update column position
	INC	SI				; increment nbr of chars read
	CMP	SI,40				; have we restored 40 chars yet?
	JL	RSTR_LINE			; no -- so loop again
	JE	STROW				; yes -- so reset the row & col
	CMP	SI,80				; have we restored 80 chars yet?
	JL	RSTR_LINE			; no -- so loop again
	JE	STROW				; yes -- so reset the row & col
	CMP	SI,120				; have we restored 120 chars yet?
	JE	RSTCSR				; yes -- then restore the cursor
	JMP	RSTR_LINE			; no -- continue to save line
STROW:	MOV	DL,0				; now set col to 1
	INC	DH				; increment the row
	JMP	RSTR_LINE
;
;  Restore the cursor position to its original position.
;
RSTCSR:
	MOV	AH,2				; set cursor position function
	MOV	BH,PAGNBR			; restore the page number
	MOV	DX,SAVCSR			; restore the cursor position
	INT	10H				; BIOS - video_io call
	RET
;
TELL_USER	ENDP
;
;
;************************************************************************
;*									*
;* procedure:	CNVRT_SRVR		v6.0 nod			*
;*									*
;* input:	AX = Server number to convert to ASCII			*
;*									*
;* output:	AX = ASCII representation of server number.		*
;*		     AH = tens digit, AL = ones digit			*
;*									*
;* updates:								*
;*									*
;* destroys:	AX, BX, CL						*
;*									*
;************************************************************************
;
CNVRT_SRVR	PROC	NEAR
;
;
;  Convert the server number in AX to ASCII with AH holding the tens
;  digit and AL holding the ones digit.
;
	MOV	BX,3030H			; set up default to "00"
	CMP	AX,0				; do range testing on the srvr
	JLE	CS_END				; ... number to make sure it
	CMP	AX,63				; ... falls between 0-63.
	JG	CS_END
;
	MOV	CL,10				; divide the number by 10
	DIV	CL				; AL = quotient, AH = remainder
	XCHG	AH,AL				; put tens in AH, ones in AL
	XCHG	BX,AX				; put value in BX to work with
	ADD	BH,30H				; convert tens to ASCII
	ADD	BL,30H				; convert ones to ASCII
;
CS_END: MOV	AX,BX				; set up return value
	RET
;
CNVRT_SRVR	ENDP
;
;
;************************************************************************
;*									*
;* procedure:	READ_STS		v6.0 nod			*
;*									*
;* input:	SAVSRV contains the server number to read		*
;*		the status from 					*
;*									*
;* output:	AL = Return code					*
;*		CX = number of bytes returned (should be 5)		*
;*									*
;* updates:	DRVMODE, DRVTYPE, MATEADR, MATESTS			*
;*									*
;* destroys:	AX, BX, CX, DX, SI, DI					*
;*									*
;************************************************************************
;
READ_STS	PROC	NEAR
;
	PUSH	BX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	ES			; Save the Extra Segment register
	PUSH	DS			; Save the Data Segment register
	PUSH	CS			; Load the ES and DS registers
	PUSH	CS			; ... with the Code Segment register
	POP	ES			;
	POP	DS			;
	MOV	SI,OFFSET READSTATUS	; Omninet command
	MOV	DI,OFFSET SHADOW_STATUS ; Location for returned data
	MOV	AX,CS:SAVSRV		; Node number to talk to
	MOV	CX,2			; Number of bytes to send
	MOV	DX,4			; Number of bytes to receive
	MOV	BX,CS:WORD PTR XMITDESC ; BH=# of retries, BL=timer units
	MOV	AH,1			; ROM command
	PUSH	CS			;
	CALL	CRVIO			;
	MOV	CS:ERR_TYPE,AL		; Save the return code
	AND	CH,10011111B		; Strip off the mode flag
	POP	DS			; Restore the Data Segment register
	POP	ES			; Restore the Extra Segment register
	POP	DI
	POP	SI
	POP	DX
	POP	BX
	RET
;
READ_STS	ENDP
;
  ENDIF
;
;*******************************************************
;*   D E V I C E   S T R A T E G Y   R O U T I N E S   *
;*******************************************************
;
DUM_STRATEGY:
	MOV	CS:WORD PTR DD_OFF,BX	; save offset of SRH pointer
	MOV	CS:WORD PTR DD_SEG,ES	; save segment of SRH pointer
	RET				; return to DOS
;
DEV_STRATEGY:
;
	MOV	CS:WORD PTR RH_OFF,BX	; save offset of SRH pointer
	MOV	CS:WORD PTR RH_SEG,ES	; save segment of SRH pointer
	RET				; return of DOS
;
;
;*********************************************************
;*   D E V I C E   I N T E R R U P T   H A N D L E R S	 *
;*********************************************************
;
; Save CX and DX on the original stack, because we will clobber them shortly.
; Be sure not to change CX after this.
;
DUM_INT:PUSH	CX			; dummy device driver entry
	PUSH	DX			;
	MOV	CX,1			;
	JMP	ISR_0			;
;
DEV_INT:PUSH	CX			;
	PUSH	DX			;
	XOR	CX,CX			; Corvus driver entry
;
; Move the stack so ROM calls won't overflow it.
;
ISR_0:	CLI				; <critical section begins>
	MOV	CS:WORD PTR OSTKOFF,SP	; save original stack
	MOV	CS:WORD PTR OSTKSEG,SS	;
	MOV	SP,OFFSET ISTKOFF	; redefine internal stack
	MOV	DX,CS			;
	MOV	SS,DX			;
	STI				; <critical section ends>
;
; Preserve the rest of the universe on our internal stack.
;
	PUSHF				;
	PUSH	DS			;
	PUSH	ES			;
	PUSH	AX			;
	PUSH	BX			;
	PUSH	DI			;
	PUSH	SI			;
	PUSH	BP			;
;
; Clear the direction flag so that string operations will increment.
;
	CLD				;
;
; Most of the driver code refernces data in the code segment.
; Since DUM/DEV_INT and EXIT preserve DS (and everything else) for DOS,
;   we'll define the data segment to be the same as the code segment
;   so that any driver code executed after this point doesn't need to
;   override the defualt to an undefined data segment.
;
	PUSH	CS			;
	POP	DS			;
;
; Deque the appropriate request.
; WE'LL NEED A MORE ELABORATE SCHEME WHEN MSDOS IMPLEMENTS MULTITASKING
; DEVICE REQUESTS !
;
	LES	BX,DWORD PTR RH_OFF	;
	JCXZ	ISR_1			;
	LES	BX,DWORD PTR DD_OFF	;
;
; Branch according to the function passed.
;
ISR_1:	XOR	AH,AH			; get cmd code byte in AX
	MOV	AL,ES:BYTE PTR SRH_CCD_FLD[BX]	;
	ROL	AL,1			; mult by 2 to get tbl offset
	LEA	DI,FUNTBL		; get function tbl addr
	JCXZ	ISR_2			;
	LEA	DI,DUMTBL		;
ISR_2:	ADD	DI,AX			; index into function tbl
	JMP	WORD PTR[DI]		; branch
;
;
DUM_IN: LEA	BP,CTA_OFF		; BP -> 4-byte CORTBL address
	MOV	SI,WORD PTR CTAindex	; SI = index into 4-byte buffer
	MOV	AL,CS:BYTE PTR[BP+SI]	; AL = 1 of 4 bytes in buffer
	PUSH	DS			; save DS
	LDS	DI,ES:DWORD PTR DTA_OFF[BX]	; DS:DI -> DTA
	MOV	BYTE PTR[DI],AL 	; rtn appropriate CORTBL address byte
	POP	DS			; restore DS
	INC	WORD PTR CTAindex	; incr index into CORTBL address buffer
;
; Set number of bytes transferred, assume no error occurred, and return to DOS.
;
	MOV	ES:WORD PTR COUNT[BX],1 ;
	STATUS	DONE,NOERROR,0		;
	JMP	EXIT			;
;
	PAGE
;
DUM_OUT:MOV	WORD PTR CTAindex,0	; reset index into CORTBL addr buffer
;
; Set number of bytes transferred, assume no error occurred, and return to DOS.
;
	MOV	ES:WORD PTR COUNT[BX],1 ;
	STATUS	DONE,NOERROR,0		;
	JMP	EXIT			;
;
;
DUM_STAT:
;
	STATUS	DONE,NOERROR,0		;
	JMP	EXIT			;
;
;
DUM_FLUSH:
;
; SHOULD FLUSH DD_OFF & DD_SEG.
;
	STATUS	DONE,NOERROR,0		;
	JMP	EXIT			;
;
;
MEDIA_CHECK:
;
	MOV	ES:BYTE PTR RET_BYTE[BX],0 ; can MntMgr help this ????????
	STATUS	DONE,NOERROR,0		;
	JMP	EXIT			;
;
;
BUILD_BPB:
;
; Fill in address of 1-sector scratch area in BUILD_BPB request.
;
	LEA	DX,SCRATCH		;
	MOV	ES:DTA_OFF[BX],DX	;
	MOV	ES:DTA_SEG[BX],CS	;
;
; Fill in address of the BPB in BUILD_BPB request.
;
	MOV	AL,ES:BYTE PTR SRH_UCD_FLD[BX]	; AX = unit code
	XOR	AH,AH			;
	LEA	SI,MNTTBL		; SI -> MNTTBL
	ADD	SI,AX			; SI -> MNTTBL entry
	MOV	AL,[SI] 		; AL = MNTTBL entry
	AND	AL,MT_TBLMAP		; AL = index into CORMAP & BPB_PTR
	JZ	BB_ERROR		; IF NOT MOUNTED, ERROR   V5.3
;
	DEC	AL			; AL = offset into BPB_PTR
	SHL	AL,1			;
	LEA	SI,BPB_PTR		; SI -> BPB_PTR
	ADD	SI,AX			; SI -> BPB_PTR entry
	MOV	AX,[SI] 		; AX = BPB_PTR entry -> BPBTBL entry
	MOV	ES:WORD PTR BPBTBL_OFF[BX],AX	;
	MOV	ES:WORD PTR BPBTBL_SEG[BX],CS	;
;
; Set the status word in the SRH.
;
	STATUS	DONE,NOERROR,0		; set status word (DONE,NOERROR)
	JMP	EXIT			;
;
BB_ERROR:				;   V5.3
	STATUS	DONE,ERROR,DE_nrdy	; set mount error status
	JMP	EXIT


  IF (SHADOW)
;
; Get the server # of the server to work on.  Use that as an index
;  into SHADOW_TBL to find out if it is a MASTER drive in a Shadow pair.
;
IO:
;
; Get the MNTTBL entry based on the unit code passed in the SRH.
; If the volume is readonly and the command is BCI_WRITE, abort.
;
	MOV	AL,ES:BYTE PTR SRH_UCD_FLD[BX]	; AX = unit code
	XOR	AH,AH			;
	LEA	SI,MNTTBL		; SI -> MNTTBL
	ADD	SI,AX			; SI -> MNTTBL entry
	MOV	AL,[SI] 		; AL = MNTTBL entry
;
; Get the CORMAP entry using the index masked from the MNTTBL entry.
; Add the Corvus volume offset value to the starting sector # in the request.
;
	AND	AL,MT_TBLMAP		; AL = index into CORMAP & BPB_PTR
	JNZ	IO_15			; if mounted, proceed	 v5.3
;
	MOV	AL,DE_nrdy		; if unmounted, set "drive not ready"
	MOV	AH,0			; set status word DONE,ERROR,r/w fault
	STATUS	DONE,ERROR,AX
	JMP	EXIT			;  and exit with error	v5.3
;
IO_15:	DEC	AL			;
	MOV	CL,CM_ESIZE		; AL = offset into CORMAP
	MUL	CL			;
	LEA	DI,CORMAP		; DI -> CORMAP
	ADD	DI,AX			; DI -> CORMAP entry
	MOV	CRM_OFFSET,DI		; Save this CORMAP entry
	MOV	AL,BYTE PTR CM_SRVNUM[DI]	; Get the server # to use
	MOV	RE_ISSUE,FALSE		; Default to "don't reissue the cmd"
	XOR	AH,AH
	MOV	SAVSRV,AX		; Save the server number for later use
	MOV	SAVSRV2,AX		; Save the server number for later use
	MOV	SI,AX			; Use as index into SHADOW_TBL
	ROL	SI,1			; Mult by 2 to get tbl offset
	MOV	AL,SHADOW_TBL[SI]	; Get the type of drive we're
	MOV	DRV_TYPE,AL		;  workin with
	XOR	AH,AH			; Get CMD code byte into AX
	MOV	AL,ES:BYTE PTR SRH_CCD_FLD[BX]
	ROL	AL,1			; Mult by 2 to get tbl offset
	LEA	SI,IOTBL		; Get I/O tbl addr
	ADD	SI,AX			; Index into I/O tbl
	JMP	WORD PTR [SI]		; Branch to INPUT, OUTPUT, or OUT_VERIFY
;
;
;  Read the drive status flags (v6.0)
;  Make sure that this drives mate is really ok and not in some
;  funky condition.
;
READ_STATUS:
;
	CALL	READ_STS		; Return code will be in AL
	CMP	AL,0
	JZ	RS040
	JMP	IN20
RS040:	CMP	CX,5			;number of bytes received + return code
	JZ	RS060
	JMP	IN20
RS060:	CMP	CS:DRVTYPE,DT_OFFLINE	;Is the slave drive OFFLINE?
	JZ	IN20			;If it is then report the err and swtch
	CMP	CS:DRVMODE,DM_NORMAL	;Is everything OK?
	JNZ	RS100			;No, check for mate offline
	JMP	INAGN			;Yes, then go on.
RS100:	CMP	CS:DRVMODE,DM_OFFLINE	;This is another check for drv OFFLINE
	JZ	IN20
;
;  Master drive must have gone bad on us.  Tell the user.
;
	XOR	AX,AX
	MOV	AL,CS:MATEADR		;Set the server number to the mate
	MOV	CS:SAVSRV,AX
	MOV	CS:DRV_TYPE,DT_MASTER	;Reset the drive type to master
	CALL	SHADOW_ERROR		;Process the shadow error on the master
	JMP	RESTR_SRVNUM		;
  ENDIF

;
INPUT:		; disk read
;
	MOV	AH,BCI_READ		; read from a Corvus drive
IN10:	MOV	BYTE PTR VFYFLG,0	; (verification doesn't make sense)
	MOV	CX,ES:WORD PTR COUNT[BX]; Save the # of sectors to transfer(v6.0 nod)
  IF (SHADOW)
	MOV	CS:SAVCNT,CX		;   (v6.0 nod)
  ENDIF
	CALL	RW_DATA 		;

  IF (SHADOW)
	JC	IN20			; If error then goto error processor
	CMP	CS:RE_ISSUE,TRUE	; Was this a reissuing of a command
	JZ	INAGN			; Yes -- then don't check mode flag
	CMP	CS:DRVMODE,DM_OFFLINE	; Is this drive OFFLINE? (v6.0)
	JZ	IN20			; Yes -- go and report the error (v6.0)
	CMP	CS:DRVMODE,DM_MATEOFF	; Is the mate offline? (v6.0)
	JNZ	INAGN			; No -- then proceede (v6.0)
	MOV	CS:DRV_TYPE,DT_SLAVE	; Mate offline in this case means that
;					; ... the slave drive is offline
	XOR	AX,AX
	MOV	SI,CS:SAVSRV		; Get the saved server number (v6.0)
	ROL	SI,1			; Mult by 2 to get tbl offset (v6.0)
	CMP	CS:SHADOW_TBL[SI],DT_NORMAL ; Did we already detect mate offline?
	JZ	INAGN			; Yes -- then get out of here
	MOV	AL,CS:SHADOW_TBL[SI+1]	; Get the slaves server number (v6.0)
	MOV	CS:SAVSRV,AX		; Save the new server number (v6.0)
	JMP	IN20			; Go and report the error now (v6.0)
;
;  An error has occured while trying to do a read command.  If drive is in
;  SHADOW mode then special processing is needed to handle the error. (v6.0 nod)
;
IN20:	CALL	SHADOW_ERROR		; Process the errors
	CMP	CS:RE_ISSUE,TRUE	; If error on master re-issue the cmd
	JE	SL_INPUT
	JMP	RESTR_SRVNUM
SL_INPUT:
	MOV	CS:DRV_TYPE,DT_SLAVE	; Change drive type frm master to slave
	MOV	CX,CS:SAVCNT		; Restore the # of sectors to transfer
	MOV	ES:WORD PTR COUNT[BX],CX;
	MOV	AX,CS:MATE_NBR		; Get the mates server number
	MOV	CS:SAVSRV,AX		; Save the new server number
	JMP	INPUT
;
;  If the read was done on a master drive in a SHADOW pair then execute a read
;  status cmd on the slave drive to verify the status of the master. (v6.0 nod)
;
INAGN:
	CMP	CS:DRV_TYPE,DT_MASTER	; Is the drive a master ?
	JE	IN_OK			; Yes -- so continue
	JMP	RESTR_SRVNUM		; No -- then no need to look for slave
IN_OK:	MOV	SI,CS:SAVSRV		; Get the saved server number
	ROL	SI,1			; Mult by 2 to get tbl offset
	MOV	AL,CS:SHADOW_TBL[SI+1]	; Get the slaves server number
	MOV	CS:BYTE PTR CM_SRVNUM[DI],AL	; Read from the SHADOW slave
	XOR	AH,AH
	MOV	CS:SAVSRV,AX		; Save the new server number
	MOV	SI,AX			; Get the server number of the mate
	ROL	SI,1			; Use it as a TBL index
	MOV	AL,CS:SHADOW_TBL[SI]	; Get the drive type for the slave
	CMP	AL,DT_SLAVE		; Make sure it really is a slave
	JE	SLV_OK			; It is so continue
	JMP	RESTR_SRVNUM		; It's not so get out
SLV_OK: MOV	CS:DRV_TYPE,AL		; It is so get ready to write to it
	MOV	CX,CS:SAVCNT		; Restore the # of sectors to transfer
	MOV	ES:WORD PTR COUNT[BX],CX;
	JMP	READ_STATUS		; Do a read status on the slave drive
  ELSE
	JMP	EXIT
  ENDIF

;
OUTPUT: 	; disk write
;
	MOV	CS:BYTE PTR VFYFLG,0	; Write but don't verify the data
	JMP	OUT10
;
OUT_VERIFY:	; disk write w/verify
;
	MOV	CS:BYTE PTR VFYFLG,0FFH ; Write and verify the data
;
;
OUT10:	MOV	CX,ES:WORD PTR COUNT[BX]; Save the # of sectors to transfer(v6.0 nod)
  IF (SHADOW)
	MOV	CS:SAVCNT,CX		;   (v6.0 nod)
  ENDIF
	MOV	AH,BCI_WRITE		; write to a Corvus drive
	CALL	RW_DATA 		;

  IF (SHADOW)
	JC	OUT20			; If error then goto error processor
	CMP	CS:RE_ISSUE,TRUE	; Was this a reissuing of a command
	JZ	OUTAGN			; Yes -- then don't check mode flag
	CMP	CS:DRVMODE,DM_OFFLINE	; Is this drive OFFLINE? (v6.0)
	JZ	OUT20			; Yes -- go and report the error (v6.0)
	CMP	CS:DRVMODE,DM_MATEOFF	; Is the mate offline? (v6.0)
	JNZ	OUTAGN			; No -- then proceede (v6.0)
	XOR	AX,AX			;
	MOV	SI,CS:SAVSRV		; Get the saved server number (v6.0)
	ROL	SI,1			; Mult by 2 to get tbl offset (v6.0)
	CMP	CS:SHADOW_TBL[SI],DT_NORMAL ; Did we already detect mate offline?
	JZ	OUTAGN			; Yes -- then get out of here
	MOV	AL,CS:SHADOW_TBL[SI+1]	; Get the slaves server number (v6.0)
	MOV	CS:SAVSRV,AX		; Save the new server number (v6.0)
	JMP	OUT20			; Go and report the error now (v6.0)
;
;  An error has occured while trying to do a write command.  If drive is in
;  SHADOW mode then special processing is needed to handle the error. (v6.0 nod)
;
OUT20:	CALL	SHADOW_ERROR		; Process the errors
	CMP	CS:RE_ISSUE,TRUE	; If error on master re-issue the cmd
	JE	REISSU
	JMP	RESTR_SRVNUM
REISSU: MOV	AX,CS:MATE_NBR		; Get the mates server number
	MOV	CS:SAVSRV,AX		; Save the new server number
	MOV	AL,DT_SLAVE		; Change drive type frm master to slave
	JMP	OA20
;
;  See if the write needs to be done to a slave drive in a SHADOW pair (v6.0 nod)
;
OUTAGN:
	CMP	CS:DRV_TYPE,DT_MASTER	; Is the drive a master?
	JNE	RESTR_SRVNUM		; No -- then no need to look for slave
	MOV	SI,CS:SAVSRV		; Get the saved server number
	ROL	SI,1			; Mult by 2 to get tbl offset
	MOV	AL,CS:SHADOW_TBL[SI+1]	; Get the slaves server number
	MOV	CS:BYTE PTR CM_SRVNUM[DI],AL	   ; Write to the SHADOW slave
	XOR	AH,AH
	MOV	CS:SAVSRV,AX		; Save the new server number
	MOV	SI,AX			; Get the server number of the mate
	ROL	SI,1			; Use it as a TBL index
	MOV	AL,CS:SHADOW_TBL[SI]	; Get the drive type for the slave
	CMP	AL,DT_SLAVE		; Make sure it really is a slave
	JNE	RESTR_SRVNUM		; It's not so get out
OA20:	MOV	CS:DRV_TYPE,AL		; It is so get ready to write to it
	MOV	CX,CS:SAVCNT		; Restore the # of sectors to transfer
	MOV	ES:WORD PTR COUNT[BX],CX;
	CMP	VFYFLG,0		; Determine which kind of output to do
	JE	OA30			;
	JMP	OUT_VERIFY		;   Output and verify or
OA30:	JMP	OUTPUT			;   output only
  ELSE
	JMP	EXIT
  ENDIF
;
;
; The following is a no-op for device requests not supported by this
;  device driver.
;
NO_OP:	STATUS	DONE,NOERROR,0		;
	JMP	EXIT			;

  IF (SHADOW)
;
;
; Restore the server number in CORMAP to its original value
;
RESTR_SRVNUM:
	MOV	DI,CRM_OFFSET		      ; Get the offset into CORMAP
	MOV	AX,CS:SAVSRV2		      ; Get the saved master server number
	MOV	CS:BYTE PTR CM_SRVNUM[DI],AL  ; Restore it to CORMAP
	CMP	CS:DRV_TYPE,DT_NORMAL	      ; If drive type is NORMAL exit
	JE	EXIT
	CMP	CS:DRV_TYPE,NO_SHADOW_PROM    ; If no SHADOW PROM then exit
	JE	EXIT
	CMP	CS:DRV_TYPE,DT_OFFLINE	      ; If drive type is OFFLINE exit
	JE	EXIT
	MOV	ES:WORD PTR SRH_STA_FLD[BX],0100H ; set the error status to no
;						  ; ... errors for the master
;						  ; ... & slave drives
;
  ENDIF
;
;
EXIT:					; common exit
;
; Restore most of the universe from our internal stack.
;
	POP	BP			;
	POP	SI			;
	POP	DI			;
	POP	BX			;
	POP	AX			;
	POP	ES			;
	POP	DS			;
	POPF				;
;
; Restore the stack to its original location.
; Note that DS is now undefined, so we need to use the segment override.
;
	CLI				; <critical section begins>
	MOV	SP,CS:WORD PTR OSTKOFF	; restore stack to original location
	MOV	SS,CS:WORD PTR OSTKSEG	;
	STI				; <critical section ends>
;
; Restore CX and DX from the original stack.
;
	POP	DX			;
	POP	CX			;
;
; Return to DOS.
;
	RET				;
;
;************************************************************************
;*									*
;*	DRIVE SEMAPHORE ROUTINES - since the spool driver (SPLDRV) uses *
;*	timer interrupts and our drive protocol is not reentrant, a	*
;*	way is needed to prevent SPLDRV from sending a command to a	*
;*	drive that is in the middle of a drive command.  The method for *
;*	now is to return an FF in the AL reg. if in the middle of a	*
;*	drive command.							*
;*									*
;************************************************************************
;
TSTWARM PROC	FAR
	CLI				;check if drive is busy
	CMP	CS:byte ptr DRVBUSY,0FFH ; .and return error if so
	JE	short LOCKED		; . else set semaphore and
;
	MOV	CS:byte ptr DRVBUSY,0FFH ; .do the drive operation
	STI
;
	PUSH	CS			; fake 'FAR' call (ala BRK)
	CALL	XWARMINIT
;
	JMP	short CLEAR		; clear the sema4 and return
TSTWARM ENDP
;
TSTCRVIO PROC	FAR
	CLI				;check if drive is busy
	CMP	CS:byte ptr DRVBUSY,0FFH ; .and return error if so
	JE	short LOCKED		; . else set semaphore and
;
	MOV	CS:byte ptr DRVBUSY,0FFH ; .do the drive operation
	STI

  IF (SHADOW)
;
;  If command is a SEMAPHORE command then call SEMA4 to process it.
;
	CMP	AH,1			; Is ROM command Xmit/Recv data
	JNZ	DOCALL			; ... to drive.
	CMP	BYTE PTR [SI],SEMA4CMD	; Is the cmd a LOCK or UNLOCK?
	JZ	S4CMD			; Yes -- then jump
	CMP	BYTE PTR [SI],SEMA4CMD2 ; Is the cmd a STATUS or INITIALIZE?
	JNZ	DOCALL			; No -- then jump
S4CMD:	CALL	SEMA4
	JMP	CLEAR
  ENDIF
;
DOCALL: PUSH	CS			; fake 'FAR' call (ala BRK)
	CALL	XCRVIO
;
CLEAR:	CLI				; clear the sema4 and return
	MOV	CS:byte ptr DRVBUSY,0
	STI
	RET				; FAR return
;
LOCKED: MOV	AL,0FFH 		; show error
	STI
	RET				; FAR return
TSTCRVIO ENDP
;
;
  IF (SHADOW)
;
;**************************************************************************
;*									  *
;* Procedure:	SEMA4	(v6.0 nod)					  *
;*									  *
;* Input:	DS:SI -> Semaphore command				  *
;*		DS:DI -> Address of data from drive			  *
;*		AL    -> Network address of disk server 		  *
;*		BX    -> BH = # of retries, BL = # of timer units to wait *
;*		CX    -> Number of bytes of data to send to the drive	  *
;*		DX    -> Number of bytes of data to receive from drive	  *
;*									  *
;* Output:								  *
;*									  *
;**************************************************************************
;
SEMA4	PROC	NEAR
;
	MOV	CS:SAVAX,AX		; Save all of the registers passed
	MOV	CS:SAVBX,BX
	MOV	CS:SAVCX,CX
	MOV	CS:SAVDX,DX
	MOV	CS:SAVDI,DI
	MOV	CS:SAVSI,SI
;
;  Save the command
;
	MOV	BH,BYTE PTR [SI]	; First byte of the command
	MOV	BL,BYTE PTR [SI+1]	; Second byte of the command
	MOV	CS:COMMAND1,BH
	MOV	CS:COMMAND2,BL
	XOR	BX,BX			; Init BX to 0
	MOV	BL,AL			; Get the server number to talk to
	SHL	BX,1			; Convert server # to tbl offset
	CMP	CS:SHADOW_TBL[BX],DT_NORMAL ; Is the drive a NORMAL drive?
	JNZ	S4_100			; No -- then continue on
	JMP	S4_END			; Yes -- then process the sema4 cmd
S4_100: CMP	CS:SHADOW_TBL[BX],NO_SHADOW_PROM ; Does drive have SHADOW PROM?
	JNZ	S4_120			; Yes -- then continue on
	JMP	S4_END			; No  -- then process the sema4 cmd
S4_120: CMP	CS:SHADOW_TBL[BX],DT_OFFLINE ; Is this drive offline?
	JNZ	S4_150			; No -- then jump
	MOV	AL,CS:SHADOW_TBL[BX+1]	; Drive is offline so get the mates #
	MOV	CS:BSERVER,AL		; Set new home server to the mate #
	MOV	CS:SAVAX,AX
	JMP	S4_END			; Process the sema4 command
;
;  Determine what the semaphore command is
;
S4_150: MOV	AL,CS:BSERVER		; Make sure we're talking to the users
;					; ... home server.
	MOV	CS:SAVAX,AX		; Resave the AX register
	CMP	CS:COMMAND1,SEMA4CMD	; Is the command a LOCK or UNLOCK?
	JNZ	S4_200			; Jump if not
	CMP	CS:COMMAND2,1		; Is the command a LOCK command?
	JZ	S4_200			; Yes -- then jump
	CALL	DO_UNLOCK		; Process the unlock command
	JMP	S4_RET
;
;  Execute the LOCK, INITIALIZE, and STATUS Semaphore commands.  These
;  commands are sent to the master drive first and the slave drive second.
;
S4_200: MOV	DI,OFFSET CS:LOCALDI
	MOV	AX,DT_MASTER
	PUSH	ES			; Save the ES register
	PUSH	CS			; Set the ES reg equal to the CS reg
	POP	ES
	CALL	SND_CMD 		; Send the command to the drive
	POP	ES			; Restore the ES register
	CMP	AL,0			; Was there an error?
	JZ	S4_220			; No -- then continue
	JMP	S4_400			; Yes -- then process the error
S4_220: CMP	CS:DRVMODE,DM_NORMAL	; Is the drive OK?
	JZ	S4_250
	CMP	CS:DRVMODE,DM_OFFLINE	; Is the drive offline
	JNZ	S4_230			; No -- then continue
	JMP	S4_400			; Yes -- then process the error
;
;  See if we have already detected the mate offline error.
;
S4_230: MOV	BX,CS:SAVAX		 ; Get the server number again
	XOR	BH,BH
	SHL	BX,1			 ; Convert it into a table offset
	CMP	CS:SHADOW_TBL[BX],DT_NORMAL ; Did we already detect MATE OFFLINE?
	JNZ	S4_240			 ; No -- then continue
	JMP	S4_RESTR		 ; Restore the sema4 data and then exit
;
;  Mate must be offline
;
S4_240: MOV	AX,CS:SAVAX
	MOV	AL,CS:SHADOW_TBL[BX+1]	; Get the mate's server number
	MOV	CS:SAVAX,AX
	XOR	AH,AH
	MOV	CS:SAVSRV,AX		; Save server number for SHADOW_ERROR
	MOV	CS:DRV_TYPE,DT_SLAVE	; The mate in this case is the SLAVE
	CALL	SHAD_ERR
	JMP	S4_RESTR		; Restore the sema4 data and then exit
;
S4_250: CMP	CS:COMMAND2,10H 	; Is the command an INITIALIZE command?
	JZ	S4_260			; Yes, then no sema4 results returned
	CMP	CS:BYTE PTR [DI],0FEH	; Error on Sema4 tbl read/write?
	JZ	S4_400			; Yes -- then process the error
;
;  Now execute the command (lock, initialize, or status) on the slave drive.
;
S4_260: MOV	DI,CS:SAVDI
	MOV	AX,DT_SLAVE
	CALL	SND_CMD 		; Send the command to the mate
	MOV	DI,OFFSET CS:LOCALDI
	CMP	AL,0			; Was there an error?
	JNZ	S4_300			; Yes -- process the error
	MOV	BX,CS:SAVDI
	CMP	BYTE PTR [BX],0FEH	; Error on Sema4 tbl read/write?
	JZ	S4_300
	CMP	CS:DRVMODE,DM_NORMAL	; Is the drive OK?
	JNZ	S4_280			; Check for drive offline
	JMP	S4_RESTR		; Restore the sema4 data and then exit
S4_280: CMP	CS:DRVMODE,DM_OFFLINE	; Is the drive offline
	JZ	S4_300			; Yes -- then process the error
;
;  See if we have already detected the mate offline error.
;
	MOV	DI,CS:SAVDI
	MOV	BX,CS:SAVAX		 ; Get the server number again
	XOR	BH,BH
	SHL	BX,1			 ; Convert it into a table offset
	CMP	CS:SHADOW_TBL[BX],DT_NORMAL ; Already detect MATE OFFLINE?
	JZ	S4_RESTR		 ; Yes -- then jump
;
;  Mate must be offline
;
	MOV	CS:DRV_TYPE,DT_MASTER	; The mate in this case is the MASTER
	MOV	AX,CS:SAVAX
	MOV	AL,CS:SHADOW_TBL[BX+1]	; Get the mate's server number
	MOV	CS:SAVAX,AX
S4_300: MOV	AX,CS:SAVAX
	XOR	AH,AH
	MOV	CS:SAVSRV,AX		; Save server # for SHADOW_ERROR
	CALL	SHAD_ERR		; Process the error
	MOV	AL,0			; Restore the first disk result
	JMP	S4_RESTR
;
S4_400: MOV	AX,CS:SAVAX
	XOR	AH,AH
	MOV	CS:SAVSRV,AX		; Save server # for SHADOW_ERROR
	CALL	SHAD_ERR		; Process the error
	MOV	AX,CS:SAVAX
	MOV	BX,CS:MATE_NBR		; Get the server # of the good drive
	MOV	AL,BL			; Save it
	MOV	CS:SAVAX,AX		;
;
S4_END: MOV	SI,CS:SAVSI
	MOV	DI,CS:SAVDI
	MOV	DX,CS:SAVDX
	MOV	CX,CS:SAVCX
	MOV	BX,CS:SAVBX
	MOV	AX,CS:SAVAX
	PUSH	CS			; Fake a FAR call
	CALL	XCRVIO			; Process the command
	AND	CH,10011111B		; Strip off the Mode flag from CX
	JMP	S4_RET
;
;  Make sure we return the proper data to the user
;
S4_RESTR:
	CALL	CPY_RSLTS		; Return the proper data
;
S4_RET: RET
SEMA4	ENDP
;
DO_UNLOCK	PROC	NEAR
;
;  Execute the UNLOCK Semaphore command.  The UNLOCK command goes to the
;  slave drive first and the master drive second.
;
	MOV	DI,OFFSET CS:LOCALDI
	MOV	AX,DT_SLAVE
	PUSH	ES			; Save the ES register
	PUSH	CS			; Set ES equal to CS
	POP	ES
	CALL	SND_CMD 		; Send the command to the drive
	POP	ES			; Restore the ES register
	CMP	AL,0			; Was there an error?
	JZ	UN_100			; No -- then continue
	JMP	UN_400			; Yes -- then process the error
UN_100: CMP	CS:DRVMODE,DM_NORMAL	; Is the drive OK?
	JZ	UN_250
	CMP	CS:DRVMODE,DM_OFFLINE	; Is the drive offline
	JNZ	UN_150			; No -- then continue
	JMP	UN_400			; Yes -- then process the error
;
;  See if we have already detected the mate offline error.
;
UN_150: MOV	BX,CS:SAVAX		 ; Get the server number again
	XOR	BH,BH
	SHL	BX,1			 ; Convert it into a table offset
	CMP	CS:SHADOW_TBL[BX],DT_NORMAL ; Did we already detect MATE OFFLINE?
	JNZ	UN_200			 ; No -- then continue
	JMP	UN_RESTR		 ; Yes -- then jump
;
;  Mate must be offline
;
UN_200: MOV	AX,CS:SAVAX
	MOV	AL,CS:SHADOW_TBL[BX+1]	; Get the mate's server number
	MOV	CS:SAVAX,AX
	XOR	AH,AH
	MOV	CS:SAVSRV,AX		; Save server # for SHADOW_ERROR
	MOV	CS:DRV_TYPE,DT_MASTER	; The mate in this case is the MASTER
	CALL	SHAD_ERR
	JMP	UN_RESTR
;
UN_250: CMP	CS:BYTE PTR [DI],0FEH	; Where we succesfull in unlocking
;					; ... the semaphore?
	JNZ	UN_260			; Yes -- so now do it on the slave
	JMP	UN_400
;
;  Now unlock the semaphore on the master drive
;
UN_260: MOV	DI,CS:SAVDI
	MOV	AX,DT_MASTER
	CALL	SND_CMD 		; Send the command to the mate
	MOV	DI,OFFSET CS:LOCALDI
	CMP	AL,0			; Was there an error?
	JNZ	UN_300			; Yes -- process the error
	MOV	SI,CS:SAVDI
	CMP	BYTE PTR [SI],0FEH	; Error on Sema4 tbl read/write?
	JZ	UN_300
	CMP	CS:DRVMODE,DM_NORMAL	; Is the drive OK?
	JNZ	UN_280			; Don't know yet so try offline
	MOV	DI,CS:SAVDI
	JMP	UN_RESTR		; Yes -- so exit
UN_280: CMP	CS:DRVMODE,DM_OFFLINE	; Is the drive offline
	JZ	UN_300			; Yes -- then process the error
;
;  See if we have already detected the mate offline error.
;
	MOV	BX,CS:SAVAX		 ; Get the server number again
	XOR	BH,BH
	SHL	BX,1			 ; Convert it into a table offset
	CMP	CS:SHADOW_TBL[BX],DT_NORMAL ; Already detect MATE OFFLINE?
	JZ	UN_RET			 ; Yes -- then jump
;
;  Mate must be offline
;
	MOV	DI,CS:SAVDI
	MOV	CS:DRV_TYPE,DT_SLAVE	; The mate in this case is the SLAVE
	MOV	AX,CS:SAVAX
	MOV	AL,CS:SHADOW_TBL[BX+1]	; Get the mate's server number
	MOV	CS:SAVAX,AX
UN_300: MOV	AX,CS:SAVAX
	XOR	AH,AH
	MOV	CS:SAVSRV,AX		; Save server # for SHADOW_ERROR
	CALL	SHAD_ERR		; Process the error
	MOV	AL,0			; Restore the first disk result
	JMP	UN_RESTR
;
UN_400: MOV	AX,CS:SAVAX
	XOR	AH,AH
	MOV	CS:SAVSRV,AX		; Save server # for SHADOW_ERROR
	CALL	SHAD_ERR		; Process the error
	MOV	AX,CS:SAVAX
	MOV	BX,CS:MATE_NBR		; Get the server # of the good drive
	MOV	AL,BL			; Save it
	MOV	CS:SAVAX,AX		;
;
UN_END: MOV	SI,CS:SAVSI
	MOV	DI,CS:SAVDI
	MOV	DX,CS:SAVDX
	MOV	CX,CS:SAVCX
	MOV	BX,CS:SAVBX
	MOV	AX,CS:SAVAX
	PUSH	CS			; Fake a FAR call
	CALL	XCRVIO			; Process the command
	AND	CH,10011111B		; Strip off the Mode flag from CX
	JMP	UN_RET
;
;  Make sure we return the proper data to the user
;
UN_RESTR:
	CALL	CPY_RSLTS
;
UN_RET: RET
DO_UNLOCK	ENDP
;
;
;
;
CPY_RSLTS	PROC	NEAR
	PUSH	ES			; Save the ES register
	PUSH	DS			; Save the DS register
	PUSH	DS			; Set ES equal to DS
	POP	ES
	PUSH	CS			; Set DS equal to CS
	POP	DS
	PUSH	CX			;
	CMP	DI,CS:SAVDI		; If the results are already in the
	JZ	CPY200			; ... users buffer then just exit.
	MOV	CX,11			; Set default length to 11
	CMP	CS:COMMAND1,SEMA4CMD	; Is the command a lock or unlock cmd
	JZ	CPY100
	CMP	CS:COMMAND2,10H 	; Is the command an initialize cmd?
	JZ	CPY200
	MOV	CX,256			; Length of the status buffer
CPY100: MOV	BX,DI			; Get the location of the results
	MOV	SI,BX			; ... and put it into SI
	MOV	DI,CS:SAVDI		; Now get the location of the users bfr
	CLD				; Clear the direction flag to do
	REP	MOVSB			; ... a forward transfer.
CPY200: POP	CX
	POP	DS			; Restore the DS register
	POP	ES			; Restore the ES register
	RET
CPY_RSLTS	ENDP
;
;
SHAD_ERR	PROC	NEAR
	CLI				; Dissable interrupts
	MOV	CS:BYTE PTR DRVBUSY,0	; Clear the drive busy semaphore
	STI				; Enable interrupts
	CALL	SHADOW_ERROR		; Now process the error
	CLI				; Turn off interrupts again
	MOV	CS:BYTE PTR DRVBUSY,0FFH ;Set the drive busy semaphore again
	STI				; Turn those interrupts back on again
	RET
SHAD_ERR	ENDP
;
;
;**************************************************************************
;
;  Procedure:	SND_CMD  (v6.0 nod)
;
;    Send a semaphore command to a master or slave drive
;
;    INPUT:   AX = DT_MASTER or DT_SLAVE  (which drive to talk to)
;	      DI = Buffer for returned data from drive
;
;    OUTPUT:  AL = Return code from the drive
;	      CX = Number of bytes returned from the drive
;		   plus 1 byte for the return code.
;	      MODE = The drive mode flag returned from the drive
;
;**************************************************************************
;
SND_CMD PROC	NEAR
	MOV	CS:DRV_TYPE,AL		; Save the drive type
	MOV	BX,CS:SAVAX		; Get the server number to use
	XOR	BH,BH			; We only want the byte in BL
	SHL	BX,1			; Convert it to a table offset
	CMP	CS:SHADOW_TBL[BX],AL	; Is this the drive we want?
	JZ	SND100			; Yes -- then proceed
	MOV	AX,CS:SAVAX		; Get the server number
	MOV	AL,CS:SHADOW_TBL[BX+1]	; Get the mates server #
	MOV	CS:SAVAX,AX
SND100: MOV	SI,CS:SAVSI
	MOV	DX,CS:SAVDX
	MOV	CX,CS:SAVCX
	MOV	BX,CS:SAVBX
	MOV	AX,CS:SAVAX
	PUSH	CS			; Fake a FAR call
	CALL	XCRVIO			; Process the command
	PUSH	CX
	MOV	BX,CX			;
	MOV	CL,13
	SHR	BX,CL			; Get the returned MODE flag
	AND	BL,00000011B		; Mask off everything but the Mode flag
	MOV	CS:DRVMODE,BL		; Save the drive mode
	POP	CX
	AND	CH,10011111B		; Strip off the Mode flag from CH
	MOV	CS:ERR_TYPE,AL		; Save the error number
	RET
SND_CMD ENDP
;
  ENDIF
;
;
	INCLUDE VIDDVR.LIB		; bring in video driver (v5.6)
;
; --- MAKE BUILTIN "ROM" ROUTINE ON SEGMENT BOUNDARY ---
;
	 IF ($-START) MOD 16
	ORG	($-START)+16-(($-START) MOD 16)
	 ENDIF
;
	 IF	(NOT ROMDVR) AND FLAT	; IF BUILT IN FLAT CABLE DRIVER
	INCLUDE ROMDVRF.LIB		;  LOAD DRIVER IN
	 ENDIF
;
	 IF	(NOT ROMDVR) AND (NOT FLAT) ; IF BUILT IN OMNINET DRIVER
	INCLUDE ROMDVRT.LIB		;  LOAD DRIVER IN
	 ENDIF
;
;
;*************************************************
;* Reserve space for the internal stack.	 *
;* Align the stack on a word boundary for speed. *
;* Stack will grow down from CS:ISTKOFF.	 *
;*************************************************
;
	EVEN				;
	DB	ISTKSIZ DUP (?) 	;
ISTKOFF EQU	$			;
;
;**********************************************************
;* Reserve 80 hex bytes of patch space for fooling around *
;**********************************************************
;
PATCH	DB	80h DUP (0)		;
;
;****************************************************
;* Reserve a one-sector scratch area for BUILD_BPB. *
;* DOS seems to use this area.			    *
;****************************************************
;
SCRATCH DB	200h DUP (?)		;
;
;*********************************************************
;* End of permanently-resident Corvus driver code.	 *
;* Align ECODOFF on a segment boundary, just to be safe. *
;*********************************************************
;
	 IF ($-START) MOD 16
	ORG	($-START)+16-(($-START) MOD 16)
	 ENDIF
ECODOFF EQU	$			;
;
;
;************************************************************************
;* procedure:	DUMINIT ( modified in version 5.4 )			*
;*									*
;* input:	ES:BX -> INIT SRH					*
;*									*
;* updates:	XPORTER entry of the Corvus CORTBL info 		*
;*		BSERVER entry of the Corvus CORTBL info 		*
;*		BOOTSPF entries pointed to in the CORTBL info		*
;*		 ( these were moved from disk INIT in v5.4 )		*
;*									*
;* output:	BRKADR_OFF and BRKADR_SEG fields of the INIT request	*
;*		BPB_PTR_OFF and BPB_PTR_SEG field of the INIT request	*
;*		ROM interface driver is initialized ( v5.4 )		*
;*		HELLOC2 ( LOGON ) is called to setup tables ( v5.4 )	*
;*									*
;*		STATUS field of the INIT SRH:				*
;*		  DONE,NOERROR,0 => successful initialization		*
;*		  DONE,ER:ROR,DE_general => DOS "general failure" error,*
;*		   one of:						*
;*			   - boot ROM code not found in expected seg	*
;*			   - duplicate transporter # already on network *
;*			   - OmniNet server I.D. request trans aborted	*
;*									*
;*		if CV_SUP=0, the block driver is unlinked and the the	*
;*		BRKADR address is set to free up the initialization area*
;*									*
;* note:	This code is executed only once, when this driver is	*
;*		installed, and	never again.				*
;************************************************************************
;
DUMINIT:
;
; Fill in the "ending address" field of the INIT request.
; Allow room for the internal stack and the 1-sector scratch area.
;
	MOV	ES:WORD PTR BRKADR_OFF[BX],OFFSET ENDADDR	;
	MOV	ES:WORD PTR BRKADR_SEG[BX],CS	;
;
; Fill in the CTA_OFF and CTA_SEG data to be used by DUM_IN and DUM_OUT.
;
	MOV	WORD PTR CTA_OFF,OFFSET CORTBL	;
	MOV	WORD PTR CTA_SEG,CS		;
;
; Fill in segment # of JMPS to fake rom routines in far jump table.
;	( updated for video driver  v5.6 )
;
	MOV	AX,CS			; get CORDRV load segment
	MOV	CX,5			; jump table has 5 jumps
	MOV	SI,offset ROMJMPS+3-5	; get pointer to jump table
;
XFIXJMP: MOV	CS:[SI],AX		; insert current code segment
	ADD	SI,5			; point to next similar jump entry
	LOOP	XFIXJMP 		; loop until CX = 0
;
; special support for hardware specific initialization
;
	 IF	HXINITF 		; if special initialization
	HXINIT				; insert code specified
	 ENDIF
;
; Fill in the number of floppies and fixed disks on line.
;
	MOV	AH,019h 		; get AL = current default drive
;					;  (0=A,etc.)
	INT	21h			;
	MOV	AH,00Eh 		; get AL = # of floppies and fixed dsks
	MOV	DL,AL			;
	INT	21h			;
	MOV	BYTE PTR FLOPPIES,AL	; fill in FLOPPIES field of CORTBL info
;
	 IF	ROMDVR	or FROMDVR	; IF DRIVERS ARE IN ROM
;
; Check if the boot ROM segment contains the boot ROM code.
; A check for 4 JMP instructions is sufficient.
; If the 4 JMPs are not found, set the status word and exit.
;
	PUSH	DS			; save data segment register
	MOV	AX,ROMSEG		; DS = boot ROM segment #
	PUSH	AX			;
	POP	DS			;
	MOV	CX,4			; we will LOOP 4 times
	XOR	AX,AX			; clr AX (AH will remain 0 within loop)
	MOV	DX,AX			; clr DX = sum of 4 (expected)
;					;  JMP instructions
	MOV	SI,AX			; clr SI = offset to (expected)
;					;  JMP instructions
CHKJMP: MOV	AL,[SI] 		; AL expected to be E9h
	ADD	DX,AX			; update the sum of the opcodes
	ADD	SI,3			; DS:SI -> next (expected)
;					;  JMP instruction
	LOOP	CHKJMP			; loop until CX = 0
;
	POP	DS			; restore data segment register
	CMP	DX,003A4h		; sum of 4 opcodes = 4*E9h ?
	JZ	INIT_1			; yes, so continue with initialization
;
  IF (SHADOW)
	CMP	DX,002E2H		; Are we on a Companion?
	JZ	SETJMP			; Yes, so go on
  ENDIF
;
	LEA	AX,NO_ROM		; no, so print a Corvus error message
	JMP	ERR_I			;   and return a DOS error code
;
	 ENDIF
;
; Check if PC SHARE driver is installed    v5.4
;  or  NET-BOS driver is installed   v5.9
;
INIT_1: LEA	DX,SHARE_HDL		; point to PC SHARE driver name
	CALL	FIND_HDL_PTR		; is driver there?
	MOV	AL,1			; setup driver type # in case
	JNC	INIT_1D 		; driver found, so continue
;
	LEA	DX,NETBOSS_HDL		; try looking for NETBOSS driver
	CALL	FIND_HDL_PTR
	MOV	AL,2			; setup driver type # in case
	JC	INIT_11 		; no redirecting driver found, so...
;
INIT_1D: MOV	DVRTYP,AL		; indicate driver type
	JMP	INIT_12 		; skip over jump table fix for dvr
;
INIT_11:

  IF (FROMDVR)				; IF DRIVER IS IN ROM FOR FLAT CABLE
;					; v5.6
	F_CALL	ROMSEG,3		; init ROM routines
	MOV	AH,ROM_ID_IF		; command to ID ROM
	F_CALL	ROMSEG,6
	CMP	AL,1			; is interface for flat cable?
	JNZ	INIT_1X 		; no, so proceed
;
SETJMP:
	MOV	AX,0			; offset to start of ROM jumps
	MOV	CX,4			; jump table has 4 jumps
	MOV	SI,offset XROMJMPS+1	; get pointer to jump table
;
SETRMJ: MOV	CS:[SI],AX		; insert current code segment
	ADD	SI,5			; point to next similar jump entry
	ADD	AX,3			; Jmps in ROM use 3 bytes
	LOOP	SETRMJ			; loop until CX = 0
;
	MOV	AX,ROMSEG		; get segment of flat cable ROM
	JMP	SETJSEG 		; set segment values in table
;
INIT_1X LABEL	NEAR

  ELSE
   IF (SHADOW)

SETJMP:
	MOV	AX,0			; offset to start of ROM jumps
	MOV	CX,4			; jump table has 4 jumps
	MOV	SI,offset XROMJMPS+1	; get pointer to jump table
;
SETRMJ: MOV	CS:[SI],AX		; insert current code segment
	ADD	SI,5			; point to next similar jump entry
	ADD	AX,3			; Jmps in ROM use 3 bytes
	LOOP	SETRMJ			; loop until CX = 0
;
	MOV	AX,ROMSEG		; get segment of flat cable ROM
	JMP	SETJSEG 		; set segment values in table
   ENDIF
  ENDIF
;
	 IF (NOT ROMDVR) or FROMDVR	; IF BUILT IN DRIVER
;
; Fill in segment # of JMPS to fake rom routines in far jump table.
;
	MOV	AX,CS			; get CORDRV load segment
SETJSEG: MOV	CX,4			; jump table has 4 jumps
	MOV	SI,offset XROMJMPS+3	; get pointer to jump table
;
FIXJMP: MOV	CS:[SI],AX		; insert current code segment
	ADD	SI,5			; point to next similar jump entry
	LOOP	FIXJMP			; loop until CX = 0
	 ENDIF
;
; ROM warm start: initialize transporter interface.
;
INIT_12 LABEL	NEAR
	PUSH	CS			; FAKE "FAR" CALL (V5.4)
	CALL	WARMINIT		; WARM START ENTRY
;
; Identify interface.
; AL = 0/1 => OmniNet/Flatcable
; AL = 0 and AH = 255 => transporter w/same number is on the network.
;
	MOV	AH,ROM_ID_IF		; identify interface
;
	PUSH	CS			; FAKE "FAR" CALL (V5.4)
	CALL	CRVIO
;
	CMP	AL,1			; if flatcable, skip OmniNet init.
	JZ	INIT_4			;
;
; OmniNet init: patch in transporter number in CORTBL info.
;
	CMP	AH,255			; duplicate xporter # on network ?
	JNZ	INIT_2			; no, so continue with initialization
	LEA	AX,DUP_XPORT		; yes, so print a Corvus error message
	JMP	ERR_I			;   and return a DOS error code
;
INIT_2: MOV	BYTE PTR XPORTER,AH	; patch in xporter #
;
; OmniNet init: patch in boot disk server station number in CORTBL info.
;
	PUSH	BX			;
	MOV	AH,ROM_ID_BS		; identify boot server
	MOV	BX,WORD PTR XMITDESC	; BL=wait, BH=retries (if OmniNet)
;
	PUSH	CS			; FAKE "FAR" CALL (V5.4)
	CALL	CRVIO
;
	POP	BX			;
	CMP	AL,255			; OmniNet transmission aborted ?
	JNZ	INIT_3			; no, so continue with initialization
	LEA	AX,ON_ABORT		; yes, so print a Corvus error message
	JMP	ERR_I			;   and return a DOS error code
;
INIT_3: MOV	BYTE PTR BSERVER,AH	; patch in network addr of server
	MOV	byte ptr CORMAP+4,AH	; set into two debugging mount entrys
	MOV	byte ptr CORMAP+9,AH
;
; Mount initial volumes.
;
INIT_4: PUSH	DS			; save important registers
	PUSH	ES			;
	PUSH	BX			;
	CALL	HELLOC2 		; do initial volume mounts
	POP	BX			; restore important registers
	POP	ES			;
	POP	DS			;
;
; Fill in the BOOTSPF entries pointed to in the CORTBL info.
;
	PUSH	BX			; save offset to INIT SRH
	MOV	CX,CV_MAX		; CX = loop counter
	LEA	BX,BPB_PTR		; BX = offset to BPB_PTR entry
	LEA	DI,BOOTSPF		; DI = offset to BOOTSPF entry
GETFAT: MOV	SI,[BX] 		; SI = BPB_PTR entry -> BPBTBL entry
	MOV	AX,WORD PTR BPB_spf[SI] ; AX = BPBTBL entry BPB_spf field
	MOV	[DI],AX 		; copy # of FAT sectors into FAT_TBL
	ADD	BX,2			; BX -> next BPB_PTR entry
	ADD	DI,2			; DI -> next FAT_TBL entry
	LOOP	GETFAT			; loop thru all possible Corvus vols
;
	POP	BX			; restore offset to INIT SRH
;
	MOV	AL,BYTE PTR CV_SUP	; get # of Corvus volumes to support
	OR	AL,AL			; is it zero?
	JNZ	EXOK			; NO, so exit with ok status
;
	MOV	ES:WORD PTR BRKADR_OFF[BX],OFFSET ECODOFF ; recover init area
	MOV	ES:WORD PTR BRKADR_SEG[BX],CS	;
;
	MOV	DSKPTR,-1		; unlink block driver
;
	LEA	AX,NO_VOLS		; point to error message
	PUTSTR	AX			; print it out
;					; return ok status to let driver
;					; attach anyway ( to run utils )
; Set status word (DONE,NOERROR).
;
EXOK:	STATUS	DONE,NOERROR,0			;
	JMP	EXIT				;
;
; Set status word (DONE,ERROR,DE_general).
; Print the installation message.
; if error during driver setup, set end of driver to release
; memory used by initialization, unlink block driver, print error
; message and return error condition.
;
ERR_I:
	MOV	ES:WORD PTR BRKADR_OFF[BX],OFFSET ECODOFF	;
	MOV	ES:WORD PTR BRKADR_SEG[BX],CS	;
;
	MOV	DSKPTR,-1		; unlink block driver
;
	STATUS	DONE,ERROR,DE_general	; DOS "general failure" error
	PUTSTR	AX			;
	JMP	EXIT			;
;
; --- ROUTINE TO FIND DRIVER HANDLE AND CROSS LINK JUMPS ---
;	ENTER: DX = pointer to 8 character handle
;	EXIT:  Carry set if handle not found
;
FIND_HDL_PTR PROC NEAR
	MOV	AH,3Dh			; msdos V2.x open handle command
	MOV	AL,0			; open for read
	INT	21H			; do it
	JC	FND_RET 		; if not found ( or error )
;
	MOV	BX,AX			; save handle for other cmds
	MOV	AH,3Fh			; msdos v2.x read device command
	MOV	CX,4			; set to read a double word address
	MOV	DX,offset SHARE_JMP	; point to place to save dword address
	INT	21H			; do read
;
	MOV	AH,3Eh			; set close command
	INT	21H			; close the "handle"
;
	MOV	CX,4			; set to "fix" 4 jumps
	MOV	SI,offset XROMJMPS+1	; point to address part of "far" jump
	MOV	AX,SHARE_OFF		; get offset # of jumptable
	MOV	DX,SHARE_SEG		; get segment # of jumptable
;
SHLP:	MOV	[SI],AX 		; correct offset # in "far" jump
	MOV	2 [SI],DX		; correct segment # in "far" jump
	ADD	SI,5			; point to next instruction
	ADD	AX,5
	LOOP	SHLP			; loop to fix the instructions
	CLC				; clear carry to show handle found
FND_RET: RET
FIND_HDL_PTR ENDP
;
;
NO_ROM	DB	CR,LF,BEL
	DB	"Boot ROM code not found in expected segment"
	DB	CR,LF,"$"
;
DUP_XPORT DB	CR,LF,BEL
	DB	"Duplicate OmniNet transporter numbers on the network"
	DB	CR,LF,"$"
;
ON_ABORT DB	CR,LF,BEL
	DB	"OmniNet transmission aborted during interface identification"
	DB	CR,LF,"$"
;
NO_VOLS DB	CR,LF,BEL
	DB	"No Corvus volumes have been mounted"
	DB	CR,LF,"$"
;
SHARE_HDL DB	'PCSMHOOK',0    ; identifier for PC-Share "hook"  (v5.4)
NETBOSS_HDL DB	'NTBOHOOK',0    ; identifier for NET-BOSS "hook"  (v5.9)
;
SHARE_JMP EQU	$
SHARE_OFF DW	?		; place to save offset of PC-Share jump table
SHARE_SEG DW	?		; place to save segment of PC-Share jump table
;
;
;************************************************************************
;* procedure:	INIT	( changed in v5.4 driver )			*
;*									*
;* input:	ES:BX -> INIT SRH					*
;*									*
;*									*
;* output:	UNITS field of the INIT request 			*
;*		BRKADR_OFF and BRKADR_SEG fields of the INIT request	*
;*		BPB_PTR_OFF and BPB_PTR_SEG field of the INIT request	*
;*		STATUS field of the INIT SRH:				*
;*		  DONE,NOERROR,0 => successful initialization		*
;*									*
;* note:	This code is executed only once, when this driver is	*
;*		installed, and never again.  Since this code lies above *
;*		the "ending address" it returns to the DOS, it actually *
;*		begins at the first free byte of memory following this	*
;*		device driver.						*
;************************************************************************
;
INST_MSG EQU	$
	INSTMG			; GET PART OF MESSAGE FROM INCLUDE FILE
	DB	" driver CORDRV ["
	DB	Version+30h
	DB	"."
	DB	Revision+30h
	DB	"] installed."
	DB	CR,LF,CR,LF,"$"
;
INIT:
;
; Fill in the driver segment number
;
	MOV	WORD PTR CD_SEG,CS	; CORDRV load segment number
;
; Fill in the "number of units" field of the INIT request.
;
	MOV	AL,BYTE PTR CV_SUP	; current # of Corvus volumes supported
	MOV	ES:BYTE PTR UNITS[BX],AL;
;
; Fill in the "ending address" field of the INIT request.
; Allow room for the internal stack and the 1-sector scratch area.
;
	MOV	ES:WORD PTR BRKADR_OFF[BX],OFFSET ECODOFF	;
	MOV	ES:WORD PTR BRKADR_SEG[BX],CS	;
;
; Fill in the "BPB array address" field of the INIT request.
;
	LEA	DX,BPB_PTR		; get address of BPB ptr array
	MOV	ES:BPB_PTR_OFF[BX],DX	;
	MOV	ES:BPB_PTR_SEG[BX],CS	;
;
; Set status word (DONE,NOERROR).
; Print the installation message.
;
	MOV	AX,offset INST_MSG	;
EXMG:	STATUS	DONE,NOERROR,0		;
	PUTSTR	AX			;
	JMP	EXIT			;
;
;
;*********************************************************
;* End of driver module.				 *
;* This is used to calculate the load length of CORDRV.  *
;* Align EMODOFF on a segment boundary, just to be safe. *
;*********************************************************
;
	 IF ($-START) MOD 16
	ORG	($-START)+16-(($-START) MOD 16)
	 ENDIF
EMODOFF EQU	$			;
;
CD_LNG	EQU	( EMODOFF - START + 511 )/512 ; LENGTH OF CODE IN BLKS
;
;*********************************************************
;* End of driver module.				 *
;* Reserve space for the HELLOC2 code which will be here *
;*   for the INIT code to jump to.			 *
;* HC2_SIZE should be a multiple of 16, just to be safe. *
;*********************************************************
;
ENDADDR EQU	$+HC2_SIZE		;
;
	 IF ($-START) MOD 100H
	ORG	256 + 256*(($-START)/256)
	 ENDIF
;
HC2	EQU	($-START)		; MAKE "CONSTANT" OF ADDRESS
;
HELLOC2 LABEL	NEAR			;
	INCLUDE LOGON.INC		;
;
;***********************************************************************
	PRINTE < LOGON MODULE STARTS AT >,%HC2
;
CORDRV	ENDP				; end of main proc
CSEG	ENDS				; end of code seg defn
	END	BEGIN

