;---------------------------------------------------------------------------
;
; %FILE     uart.inc
; %VSS-REV  $Revision: 1 $
; %VERSION  1.1
; %CREATED  1995.08.01
; %REVISED  $Date: 10/30/96 5:26p $
; %AUTHOR   Michael C. Draeger 
; %PROJECT  NS486SXF evaluation board software
; %PART     NS486SXF 
; %SUMMARY  very simple UART output macros for tests 
;     
; %VSS      $Author: Miked $ $Date: 10/30/96 5:26p $ $Revision: 1 $
;
; DESCRIPTION
;
;   A few very basic macros to initialize the external debug UART and 
;   print characters to it.
;
; RELEASE HISTORY
;
;   1.0   1995.08.01  mcd  genesis
;   1.1   1996.10.30  mcd  updated header for VSS SCCS
;
; COPYRIGHT
;
;      (c) 1995, 1996 National Semiconductor Corporation
;
; NOTES
;
;   this needs to be included after io.inc
;
;   does not use ns486reg.inc definitions, this is for external
;   debugging uart
;
;---------------------------------------------------------------------------

; debugging UART locations

uCOM1    equ     03F8h
uCOM2    equ     02F8h
uCOM3    equ     03E8h
uCOM4    equ     02F8h

;;; define uPORT to one of the above in program calling these routines
;;; example, set COM 2:
;;;     uPORT    equ     COM2           ; debugging UART is COM2            

; UART registers

uTHR    equ     uPORT + 0
uRBR    equ     uPORT + 0
uDLL    equ     uPORT + 0
uDLM    equ     uPORT + 1
uIER    equ     uPORT + 1
uFCR    equ     uPORT + 2
uLCR    equ     uPORT + 3
uMCR    equ     uPORT + 4
uLSR    equ     uPORT + 5

; UART baud rates

ulsb192  equ     6               ; 19200 baud     
umsb192  equ     0
ulsb96   equ     12               ; 9600 baud
umsb96   equ     0

;;;set these in program using these routines
;;;example, baud rate 19,200:
;;;     uDLLv   equ     ulsb192     ; baud rate divisor LSB
;;;     uDLMv   equ     umsb192     ; baud rate divisor MSB

uart_init MACRO
        outpb   uLCR, 03h       ; clear DLAB, no parity, 1 stop, 8 bit word 
        outpb   uIER, 00h       ; disable all interrupts (use polling)
        outpb   uFCR, 00h       ; disable FIFOs (if 16550)
        outpb   uMCR, 03h       ; set DTR and RTS
        outpb   uLCR, 83h       ; set DLAB, no parity, 1 stop, 8 bit word
        outpb   uDLL, uDLLv     ; set baud rate LSB
        outpb   uDLM, uDLMv     ; set baud rate MSB
        outpb   uLCR, 03h       ; clear DLAB, no parity, 1 stop, 8 bit word
ENDM

uart_outc MACRO char
        inpb    uLSR            ; read line status to see if uart is busy
        and     al, 020h        ; THRE bit
        db      074h, 0F7h      ; jz start of macro
        outpb   uTHR, char      ; write byte
ENDM

;---------------------------------------------------------------------------
; END       uart.inc 
;---------------------------------------------------------------------------
