/*This include file goes at start of each sample file.
  This portion defines default memory definition for HPC shared memory*/

#ifdef NOTHPC
#undef NOTHPC
#endif

/*define full memory for MOLE shared memory*/
MEMORY BPAGE  RAM16 0x0/0xbf;
MEMORY INTRAM RAM16 0x1c0/0x1ff;
MEMORY EXTRAM RAM16 0xc400/0xcfff;
MEMORY STKRAM RAM16 0xd000/0xefff;
MEMORY INTROM ROM16 0xf000/0xffbf;
BSECT BPAGE;
DSECT INTRAM,EXTRAM;
STACK STKRAM,0x2000;
CSECT INTROM;
ICSECT INTROM;
RSECT INTROM;

#define MSGSTART    0xc000
#define MSGEND      0xc3ff

/*char out to memory on HPC*/
putchar(c)
char c;
{
    BASEPAGE static
    char * p = (char *) MSGSTART; /* message area */

    if (c && (p < (char *) MSGEND))
        *(p++)=c;
    else
        *p = 0x1a; /*end of file*/
}

/*simple printf,
  processes %d and %s only,
  translates \n and \t in string only,
  calls putchar(c) to handle HPC interface
 */ 
printf(s)
char * s;   /* will also represent array of values on stack frame */
{
    char c;
    char * argp = (char *)(&s);   /*to access arguments in stack frame*/

    do
    {
        if( (c = *s++) == '\n')
        {
            putchar(0xd);           /*cr,lf*/
            putchar(0xa);
        }
        else if( c == '\t')
            putchar(0x9);           /*tab*/
        else if( c == '%' && *s == 's')
        {
            s++;                    /*%s - skip 's'*/
            s_printf(--((char **)argp));
            /*current argument, and advance*/
        }
        else if( c == '%' && *s == 'd')
        {
            s++;                    /*%d - skip 'd'*/
            d_printf(--((int *)argp));
            /*current argument, and advance*/
        }
        else
            putchar(c);             /*simple character or null terminator*/
    }
    while( c );                     /* includes terminating null */
}

/* printf %s sub-procedure */
s_printf(argp)
char ** argp;       /*address of argument, which is (char *) */
{
    char * s = *argp;               /*get char * argument*/
    
    while( *s )                     /*output except null*/
        putchar(*s++);
}

/* printf %d sub-procedure */
d_printf(argp)
int * argp;         /*address of argument, which is (char *) */
{
    int i = *argp;                  /*get int argument*/
    
    if( i < 0 )                     /*handle negatives*/
    {
        putchar('-');
        i = -i;
    }
    dc_printf(i);                   /*process digits*/
}

/* printf %d sub-sub-procedure to recusively process digits */
dc_printf(i)
unsigned int i;
{
    if( i )                         /*special case of simple zero*/
    {
        if( i > 9)                  /*first recurse for each digit*/
            dc_printf(i / 10);      /*to get higher left-more digits*/
        i %= 10;                    /*now process each digit by modulo*/
    }
    putchar('0' + (char) i);        /*output as character*/
}

/*string compare is used by tests*/
strcmp(s,t) /*return <0 is s<t, 0 if s==t, >0 if s>t */
char *s, *t;
{
    for ( ; *s == *t; s++, t++)
        if (*s == '\0')
            return(0);
    return(*s - *t);
}

/*string copy is used by tests*/
strcpy(s,t) /* copy t to s */
char *s,*t;
{
    while (*s++ = *t++);
}

