/*test INTERRUPT1 thru INTERRUPT7
  test that function address is placed properly in vector table
  do a timer interrupt several times to verify interrupt routine works*/

/*use standard defined memory*/
#include "samples.h"
#define M *(char *)
#define W *(unsigned *)

#define WAIT 10000
#ifndef NOTHPC
/*define registers*/
#define REGR4 W(0x142)
#define TMRT4 W(0x140)
#define TMMD W(0x190)
#define PWMD W(0x150)
#define ENIR M(0xd0)
/*define control values*/
#define STOPTIMERS 0xcccc
#define STARTT4 0x4441
#define ACKT4 0x4449
#define T4COUNT 0x3ff
#define DISABLE 0
#define ENABLE 0x21
#endif

/*number of interrupts to detect*/
#define INTRCT 3
int ct; /*interrupt ct*/

/*define interrupt routines*/
INTERRUPT1 void i1() { return; }
INTERRUPT3 INTERRUPT2 void i23() { return; }
INTERRUPT4 void i4() { return; }

INTERRUPT5 i5()
{
    PWMD = ACKT4; /*acknowledge t4*/
    if (ct == INTRCT)
    {
        ct--;
        return;     /*test RETI in middle of function*/
    }
    if (ct) ct--;
}               /*test default RETI at end*/

INTERRUPT6 i6() { return; }
INTERRUPT7 i7() { return; }



main()
{
    printf("file c03.c, INTERRUPT1 thru INTERRUPT7 test\n");

    /*verify interrupt function address in vector table*/
    /*define macro to compare function address to particular word in vector table*/
    #define INTERRUPT(f,i) ((int)f == W(0xfffe - i - i))

    if (!INTERRUPT(i1,1) ||
        !INTERRUPT(i23,2) ||
        !INTERRUPT(i23,3) ||
        !INTERRUPT(i4,4) ||
        !INTERRUPT(i5,5) ||
        !INTERRUPT(i6,6) ||
        !INTERRUPT(i7,7))
         printf("FAIL test\ninterrupt function address not in vector table\n");
    else
    {
        /*do a t4 timer interrupt several times to verify function is
          interrupt routine (contains RETI at end to reenable interrupt)*/
        /*use a timeout in case of failure*/

        ct = INTRCT; /*no. of interrupts to detect*/ 

        #ifndef NOTHPC
        ENIR = DISABLE; /*disable interrupts*/
        TMMD = PWMD = STOPTIMERS; /*stop timers*/
        REGR4 = TMRT4 = T4COUNT; /*initial t4 count*/
        PWMD = STARTT4; /*start t4*/
        ENIR = ENABLE; /*enable interrupt*/
        #endif

        /*delay at least long enough to complete INTRCT interrupts*/
        {
            int i; /*loop ct*/
            for(i=0;i<WAIT;++i) if (ct == 0) break;/*quit if done*/
        }
        #ifndef NOTHPC
        ENIR = DISABLE; /*disable interrupts*/
        #endif

        if (ct == INTRCT) printf("FAIL test\nno interrupts detected\n");
        else if (ct) printf("FAIL test\nnot all interrupts detected\n");
    }
}

