;
; THIS FILE DECLARES I/O AND CONTROL REGISTERS
; FREQUENTLY USED BY THE COP888 PROGRAMMER.
;
	PORTLD	=   0D0 	; PORT L DATA
	PORTLC	=   0D1 	; PORT L CONFIGURATION
	PORTLP	=   0D2 	; PORT L PIN
;
	PORTCD	=   0D8 	; PORT C DATA
	PORTCC	=   0D9 	; PORT C CONFIGURATION
	PORTCP	=   0DA 	; PORT C PIN

	PORTGD	=   0D4 	; PORT G DATA
	PORTGC	=   0D5 	; PORT G CONFIGURATION
	PORTGP	=   0D6 	; PORT G PIN

	PORTD	=   0DC 	; PORT D
	PORTI	=   0D7 	; PORT I
;
	SIOR	=   0E9 	; SIO SHIFT REGISTER
	S	=   0FF 	; SEGMENT REGISTER

	TMR1LO	=   0EA 	; TIMER 1 LOW BYTE
	TMR1HI	=   0EB 	; TIMER 1 HIGH BYTE
	T1RALO	=   0EC 	; TIMER 1 RA REGISTER LOW BYTE
	T1RAHI	=   0ED 	; TIMER 1 RA REGISTER HIGH BYTE
	T1RBLO	=   0E6 	; TIMER 1 RB REGISTER LOW BYTE
	T1RBHI	=   0E7 	; TIMER 1 RB REGISTER HIGH BYTE
;
	TMR2LO	=   0C0 	; TIMER 2 LOW BYTE
	TMR2HI	=   0C1 	; TIMER 2 HIGH BYTE
	T2RALO	=   0C2 	; TIMER 2 RA REGISTER LOW BYTE
	T2RAHI	=   0C3 	; TIMER 2 RA REGISTER HIGH BYTE
	T2RBLO	=   0C4 	; TIMER 2 RB REGISTER LOW BYTE
	T2RBHI	=   0C5 	; TIMER 2 RB REGISTER HIGH BYTE
	T2CNTRL =   0C6 	; TIMER 2 CONTROL REGISTER
;
	TMR3LO	=   0B0 	; TIMER 3 LOW BYTE
	TMR3HI	=   0B1 	; TIMER 3 HIGH BYTE
	T3RALO	=   0B2 	; TIMER 3 RA REGISTER LOW BYTE
	T3RAHI	=   0B3 	; TIMER 3 RA REGISTER HIGH BYTE
	T3RBLO	=   0B4 	; TIMER 3 RB REGISTER LOW BYTE
	T3RBHI	=   0B5 	; TIMER 3 RB REGISTER HIGH BYTE
	T3CNTRL =   0B6 	; TIMER 3 CONTROL REGISTER
;
	CNTRL	=   0EE 	; CONTROL REGISTER
	PSW	=   0EF 	; PSW REGISTER
	WDSVR	=   0C7 	; WATCH DOG SERVICE REGISTER
	WKEDG	=   0C8 	; MIWU EDGE SELECT REGISTER
	WKEN	=   0C9 	; MIWU ENABLE REGISTER
	WKPND	=   0CA 	; MIWU PENDING REGISTER
	ENAD	=   0CB 	; A/D ENABLE REGISTER
	ADRSLT	=   0CC 	; A/D RESULT REGISTER
	ICNTRL	=   0E8 	; ICNTRL REGISTER
;
	CMPSL	=   0B7 	; COMPARATOR SELECT REGISTER
	TBUF	=   0B8 	; UART TRANSMIT BUFFER
	RBUF	=   0B9 	; UART RECEIVE BUFFER
	ENU	=   0BA 	; UART CONTROL AND STATUS REGISTER
	ENUR	=   0BB 	; UART RECEIVE CONTROL AND STATUS REG
	ENUI	=   0BC 	; UART INTERRUPT AND CLOCK SOURCE REG
	BAUD	=   0BD 	; BAUD REGISTER
	PSR	=   0BE 	; UART PRESCALER SELECT REGISTER
; CONSTANT DECLARE
;
	INTR	=   0
	TIO	=   3
	SO	=   4
	SK	=   5
	SI	=   6
	CKO	=   7
;
	LPEN	=   6
;
	TSEL	=   7
	CSEL	=   6
	TEDG	=   5
	TRUN	=   4
	MSEL	=   3
	IEDG	=   2
	S1	=   1
	S0	=   0
;
	HCARRY	=   7
	CARRY	=   6
	TPND	=   5
	ENTI	=   4
	IPND	=   3
	BUSY	=   2
	ENI	=   1
	GIE	=   0
	TMRINP	=   3
;
	T2PNDA	=	3
	T2ENA	=	2
	T2PNDB	=	1
	T2ENB	=	0
	T3PNDA	=	3
	T3ENA	=	2
	T3PNDB	=	1
	T3ENB	=	0		
	T1PNDA	=	5
	T1ENA	=	4
	T1PNDB	=	1
	T1ENB	=	0
;
	TBMT	=	0
	RBFL	=	1
	PE	=	5
	FE	=	6
;
	CMP1RD	=	2
	CMP2RD	=	5
;
	.CHIP 888
