
;
;This program provides in the form of subroutines, the ability to erase,
;enable, disable, read and write to the COP494/NMC9306 EEPROM.

; EDITTED MAY 11, 1994 - REVISED FOR NEW ASSEMBLER (ASMCOP v4.2) 


	.TITLE  EEPROM


	.INCLD COP820.INC
        .SECT   MAIN,ROM,INPAGE

SNDBUF  = 0 ;CONTAINS THE COMMAND BYTE TO BE WRITTEN TO COP494
RDATL   = 1 ;LOWER BYTE OF THE COP494 REGISTER DATA READ
RDATH   = 2 ;UPPER BYTE OF THE COP494 REGISTER DATA READ
WDATL   = 3 ;LOWER BYTE OF THE DATA TO BE WRITTEN TO COP494 REGISTER
WDATH   = 4 ;UPPER BYTE OF THE DATA TO BE WRITTEN TO COP494 REGISTER
ADRESS  = 5 ;THE LOWER 4-BITS OF THIS LOCATION CONTAIN THE ADDRESS
            ;OF THE COP494 REGISTER TO BE READ/WRITTEN
FLAGS   = 6 ;USED FOR SETTING UP FLAGS
            ;
            ; FLAG VALUE        ACTION
            ; ----------        ------
            ;    00             ERASE,ENABLE,DISABLE,ERASE ALL
            ;    01             READ CONTENTS OF COP494 REGISTER
            ;    03             WRITE TO COP494 REGISTER
            ;    OTHERS         ILLEGAL COMBINATION
DLYH    = 0F0
DLYL    = 0F1
;
; THE INTERFACE BETWEEN THE COP820C/840C AND THE COP494 (256-BIT EEPROM)
; CONSISTS OF FOUR LINES. THE G0 (CHIP SELECT LINE), G4 (SERIAL OUT SO),
; G5 (SERIAL CLOCK SK) AND G6 (SERIAL IN SI).
;
;       INITIALIZATION
;
         LD PORTGC,#031     ;Setup G0,G4,G5 as outputs
         LD PORTGD,#00      ;Initialize G data reg to zero
         LD CNTRL,#08      ;Enable MSEL, select MW rate of 2tc
         LD B,#PSW
         LD X,#SIOR
;
; THIS ROUTINE ERASES THE MEMORY LOCATION POINTED TO BY THE
; ADDRESS CONTAINED IN THE LOCATION "ADRESS". THE LOWER NIBBLE
; OF "ADRESS" CONTAINS THE COP494 REGISTER ADDRESS AND THE UPPER
; NIBBLE SHOULD BE SET TO ZERO.
;
ERASE:  LD  A,ADRESS
        OR  A,#0C0
        X   A,SNDBUF       
        LD  FLAGS,#0
        JSR INIT
        RET
;
; THIS ROUTINE ENABLES PROGRAMMING OF THE COP494. PROGRAMMING MUST
; BE PRECEDED ONCE BY A PROGRAMMING ENABLE (EWEN).
;
EWEN:
        LD  SNDBUF,#030
        LD  FLAGS,#0
        JSR INIT
        RET
;
; THIS ROUTINE DISABLES PROGRAMMING OF THE COP494.
;
EWDS:
        LD  SNDBUF,#0
        LD  FLAGS,#0
        JSR  INIT
        RET
;
; THIS ROUTINE ERASES ALL REGISTERS OF THE COP494.
;
ERAL:
        LD  SNDBUF,#020
        LD  FLAGS,#0
        JSR  INIT
        RET
;
; THIS ROUTINE READS THE CONTENTS OF THE COP494 REGISTER.
; THE COP494 ADDRESS IS SPECIFIED IN THE LOWER NIBBLE OF
; LOCATION "ADRESS". THE UPPER NIBBLE SHOULD BE SET TO ZERO.
; THE 16-BIT CONTENTS OF THE COP494 REGISTER ARE STORED IN
; RDATL AND RDATH.
READ:   LD  A,ADRESS
        OR  A,#080
        X   A,SNDBUF  
        LD  FLAGS,#1
        JSR INIT
        RET
;
; THIS ROUTINE WRITES A 16-BIT VALUE STORED IN WDATL AND WDATH
; TO THE COP494 REGISTER WHOSE ADDRESS IS CONTAINED IN THE
; LOWER NIBBLE OF THE LOCATION "ADRESS". THE UPPER NIBBLE OF
; ADRESS LOCATION SHOULD BE SET TO ZERO.
;
WRITE:  LD  A,ADRESS
        OR  A,#040
        X   A,SNDBUF
        LD  FLAGS,#3
        JSR INIT
        RET
;
; THIS ROUTINE SENDS OUT THE START BIT AND THE COMMAND BYTE.
; IT ALSO DECIPHERS THE CONTENTS OF THE FLAG LOCATION AND TAKES
; A DECISION REGARDING WRITE, READ OR RETURN TO THE CALLING ROUTINE.
;
INIT:   SBIT 0,PORTGD   ;SET CHIP SELECT HIGH
        LD SIOR,#001    ;LOAD SIOR WITH START BIT
        SBIT BUSY,[B]   ;SEND OUT THE START BIT
PUNT1:  IFBIT BUSY,[B]
        JP PUNT1
        LD A,SNDBUF
        X  A,[X]        ;LOAD SIOR WITH COMMAND BYTE
        SBIT BUSY,[B]   ;SEND OUT COMMAND BYTE
PUNT2:  IFBIT BUSY,[B]
        JP PUNT2
        IFBIT 0,FLAGS   ;ANY FURTHER PROCESSING ?
        JP NOTDON       ;YES
        RBIT 0,PORTGD   ;NO, RESET CS AND RETURN
        RET
;
NOTDON:
        IFBIT 1,FLAGS   ;READ OR WRITE?
        JP  WR494       ;JUMP TO WRITE ROUTINE
        LD SIOR,#000    ;NO, READ COP494
        SBIT BUSY,PSW   ;DUMMY CLOCK TO READ ZERO
        RBIT BUSY,[B]
        SBIT BUSY,[B]
PUNT3:  IFBIT BUSY,[B]
        JP  PUNT3
        X   A,[X]
        SBIT BUSY,[B]
        X   A,RDATH
PUNT4:  IFBIT BUSY,[B]
        JP  PUNT4
        LD A,[X]
        X  A,RDATL
        RBIT 0,PORTGD
        RET
;
WR494:
        LD  A,WDATH
        X   A,[X]
        SBIT BUSY,[B]
PUNT5:  IFBIT BUSY,[B]
        JP  PUNT5
        LD  A,WDATL
        X   A,[X]
        SBIT BUSY,[B]
PUNT6:  IFBIT BUSY,[B]
        JP  PUNT6
        RBIT 0,PORTGD
        JSR TOUT
        RET
;
;ROUTINE TO GENERATE DELAY FOR WRITE
;
TOUT:   LD  DLYH,#00A
WAIT:   LD  DLYL,#0FF
WAIT1:  DRSZ DLYL
        JP  WAIT1
        DRSZ DLYH
        JP  WAIT
        RET
        .END   
