TITLE 'APEEL FILE: PEEL22CV10Z CHANGE-OF-STATE INPUT PORT WITH INTERRUPT
DESIGNER: Robin Jigour, ICT
DATE: 5/1/87'

PEEL22CV10Z     "The key word 'ZERO_POWER' is omitted for non zero-power mode.
                "If zero-power is needed, this key word must be specified after
                "the part number declaration but prior to pin list definition

"DESCRIPTION"
"                      PEEL22CV10Z

"       Change-of-State Input Port with Interrupt
"                     ____  ____
"                    |    \/    |
"               CLK  { 1     24 }  Vcc
"                I0  { 2     23 }- D0
"                I1  { 3     22 }- D1
"                I2  { 4     21 }- D2       ( - = output )
"                I3  { 5     20 }- D3
"               /CS  { 6     19 }- NEQ
"               /RD  { 7     18 }- INTR
"                I4  { 8     17 }- D4
"                I5  { 9     16 }- D5
"                I6  {10     15 }- D6
"                I7  {11     14 }- D7
"               GND  {12     13 }  A0
"                    |__________|

" This application uses the PEEL22CV10Z as an 8-bit input port for
" a microprocessor that can detect a change-of-state on its I(0-7)
" input pins. When detected, the INTR output is set for interrupting
" the uP. The INTR output is also used to clock the PEEL device for
" latching the state change into the eight pseudo-buried registers. The
" registers can be read by the CPU on D0-D7 as listed in the table below.
" Once read, unless another change has occurred, the INTR will be reset.
" The NEQ output provides a non-latched (not equal) output signal which
" can be used for the clock instead of the INTR pin. Doing this allows the
" last change to be saved instead of the first. The I(0-7) pins can also
" be directly read as a standard input port when addressed by A0.

" Address        Data Outputs
" -----------    ---------------------------
" A0  CS  RD     D0-7
"  X   1   X     Hi-Z
"  X   X   1     Hi-Z
"  0   0   0     Read D0-D7 Buried Registers
"  1   0   0     Read I0-I7 Inputs pins


"PIN DEFINITIONS"

"Inputs"

CLK      pin 1   "Must be connected to pin 18, INTR.
I0       pin 2   "I0-I7 inputs can detect change-of-state.
I1       pin 3
I2       pin 4
I3       pin 5
!RD      pin 6
!CS      pin 7
I4       pin 8
I5       pin 9
I6       pin 10
I7       pin 11
A0       pin 13

"Outputs"

D7       pin 14 = pos com feed_reg   "Pseudo buried registers.
D6       pin 15 = pos com feed_reg
D5       pin 16 = pos com feed_reg
D4       pin 17 = pos com feed_reg
INTR     pin 18 = pos com feed_or
NEQ      pin 19 = pos com feed_or
D3       pin 20 = pos com feed_reg
D2       pin 21 = pos com feed_reg
D1       pin 22 = pos com feed_reg
D0       pin 23 = pos com feed_reg


EQUATIONS

D0 = I0 & !CS #               "I0 to D0 register.
     I0 &  CS & !RD #         "I0 to D0 register.
     D0 &  CS & RD & !A0 #    "Read D0 register.
     I0 &  CS & RD & A0       "Read I0.
     Enable D0 = CS & RD      "Enable onto data bus.

D1 = I1 & !CS #               "I1 to D1 register.
     I1 &  CS & !RD #         "I1 to D1 register.
     D1 &  CS & RD & !A0 #    "Read D1 register.
     I1 &  CS & RD &  A0      "Read I1.
     Enable D1 = CS & RD      "Enable onto data-bus.

D2 = I2 & !CS #               "I2 to D2 register.
     I2 &  CS & !RD #         "I2 to D2 register.
     D2 &  CS & RD & !A0 #    "Read D2 register.
     I2 &  CS & RD &  A0      "Read I2.
     Enable D2 = CS & RD      "Enable onto data-bus.

D3 = I3 & !CS #               "I3 to D3 register.
     I3 &  CS & !RD #         "I3 to D3 register.
     D3 &  CS &  RD & !A0 #   "Read D3 register.
     I3 &  CS &  RD &  A0     "Read I3.
     Enable D3 = CS & RD      "Enable onto data-bus.

D4 = I4 & !CS #               "I4 to D4 register.
     I4 &  CS & !RD #         "I4 to D4 register.
     D4 &  CS & RD & !A0 #    "Read D4 register.
     I4 &  CS & RD & A0       "Read I4.
     Enable D4 = CS & RD      "Enable onto data bus.

D5 = I5 & !CS #               "I1 to D5 register.
     I5 &  CS & !RD #         "I1 to D5 register.
     D5 &  CS & RD & !A0 #    "Read D5 register.
     I5 &  CS & RD &  A0      "Read I5.
     Enable D5 = CS & RD      "Enable onto data-bus.

D6 = I6 & !CS #               "I6 to D6 register.
     I6 &  CS & !RD #         "I6 to D6 register.
     D6 &  CS & RD & !A0 #    "Read D6 register.
     I6 &  CS & RD &  A0      "Read I6.
     Enable D6 = CS & RD      "Enable onto data-bus.

D7 = I7 & !CS #               "I7 to D7 register.
     I7 &  CS & !RD #         "I7 to D7 register.
     D7 &  CS &  RD & !A0 #   "Read D7 register.
     I7 &  CS &  RD &  A0     "Read I7.
     Enable D7 = CS & RD      "Enable onto data-bus.

NEQ = I0 & !D0 # !I0 & D0 #    "Compare I0-7 with D0-7 registers.
      I1 & !D1 # !I1 & D1 #    "NEQ=1 if I0-7 and D0-7 are not equal.
      I2 & !D2 # !I2 & D2 #
      I3 & !D3 # !I3 & D3 #
      I4 & !D4 # !I4 & D4 #
      I5 & !D5 # !I5 & D5 #
      I6 & !D6 # !I6 & D6 #
      I7 & !D7 # !I7 & D7

INTR = NEQ  & !CS #    "Latch not-equal status for uP interrupt and
       NEQ  & !RD #    "PEEL clock. Clear interrupt when registers
       NEQ  &  A0 #    "are read and there are no more input state
       INTR & !CS #    "changes, that is, when NEQ, CS, RD and A0
       INTR & !RD #    "are all 0.
       INTR &  A0


TEST_VECTORS "Test change-of-state input port I0-7 operation"

( CLK  I0 I1 I2 I3 I4 I5 I6 I7 A0  CS RD  -> D0 D1 D2 D3 D4 D5 D6 D7 NEQ INTR )

    0   0  0  0  0  0  0  0  0  X   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   X  0
    0   0  0  0  0  0  0  0  0  0   1  1  ->  X  X  X  X  X  X  X  X   L  0
    0   1  0  0  0  0  0  0  0  X   0  0  ->  Z  Z  Z  Z  Z  Z  Z  Z   H  H
    1   1  0  0  0  0  0  0  0  X   0  0  ->  Z  Z  Z  Z  Z  Z  Z  Z   L  H
    1   1  0  0  0  0  0  0  0  0   1  0  ->  Z  Z  Z  Z  Z  Z  Z  Z   L  H
    1   1  0  0  0  0  0  0  0  0   1  1  ->  H  L  L  L  L  L  L  L   L  L
    0   1  0  0  0  0  0  0  0  0   1  1  ->  H  L  L  L  L  L  L  L   L  L
    0   1  0  0  0  0  0  0  0  X   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   L  L
    0   0  0  0  0  0  0  0  0  X   0  0  ->  Z  Z  Z  Z  Z  Z  Z  Z   H  H
    1   0  0  0  0  0  0  0  0  X   0  0  ->  Z  Z  Z  Z  Z  Z  Z  Z   L  H
    1   0  0  0  0  0  0  0  0  0   1  0  ->  Z  Z  Z  Z  Z  Z  Z  Z   L  H
    1   0  0  0  0  0  0  0  0  0   1  1  ->  L  L  L  L  L  L  L  L   L  L
    0   0  0  0  0  0  0  0  0  X   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   L  L
    0   1  0  0  0  0  0  0  0  X   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   H  H
    1   1  0  0  0  0  0  0  0  X   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   L  H
    1   1  1  1  1  1  1  1  1  X   0  0  ->  Z  Z  Z  Z  Z  Z  Z  Z   H  H
    1   1  1  1  1  1  1  1  1  0   1  0  ->  Z  Z  Z  Z  Z  Z  Z  Z   H  H
    1   1  1  1  1  1  1  1  1  0   1  1  ->  H  L  L  L  L  L  L  L   H  L
    0   1  1  1  1  1  1  1  1  X   0  0  ->  Z  Z  Z  Z  Z  Z  Z  Z   H  H
    1   1  1  1  1  1  1  1  1  0   1  0  ->  Z  Z  Z  Z  Z  Z  Z  Z   L  H
    1   1  1  1  1  1  1  1  1  0   1  1  ->  H  H  H  H  H  H  H  H   L  L
    0   1  1  1  1  1  1  1  1  X   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   L  L
    0   0  0  0  0  0  0  0  0  X   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   H  H
    1   0  0  0  0  0  0  0  0  X   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   L  H
    1   0  0  0  0  0  0  0  0  0   1  1  ->  L  L  L  L  L  L  L  L   L  L
    0   0  0  0  0  0  0  0  0  X   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   L  L

"Test direct read of inputs during a change-of-state"

    0   1  0  1  0  1  0  1  0  X   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   H  H
    1   1  0  1  0  1  0  1  0  1   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   L  H
    1   1  0  1  0  1  0  1  0  1   1  1  ->  H  L  H  L  H  L  H  L   L  H
    1   0  1  0  1  0  1  0  1  1   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   H  H
    1   0  1  0  1  0  1  0  1  1   1  1  ->  L  H  L  H  L  H  L  H   H  H
    1   0  1  0  1  0  1  0  1  X   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   H  H
    1   0  1  0  1  0  1  0  1  0   1  1  ->  H  L  H  L  H  L  H  L   H  L
    0   0  1  0  1  0  1  0  1  X   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   H  H
    1   0  1  0  1  0  1  0  1  X   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   L  H
    1   0  1  0  1  0  1  0  1  0   1  1  ->  L  H  L  H  L  H  L  H   L  L
    0   0  1  0  1  0  1  0  1  0   0  X  ->  Z  Z  Z  Z  Z  Z  Z  Z   L  L

