TITLE 'APEEL FILE:  PEEL273 10-Bit Expandable Comparator
DESIGNER:  Robin Jigour
DATE:  10/15/87'

PEEL273

"DESCRIPTION"

"                       PEEL273

"         10-Bit Expandable Equality Comparator
"                     ____  ____
"                    |    \/    |
"                A0  { 1     24 }  Vcc
"                A1  { 2     23 }- EQU      (- = output)
"                A2  { 3     22 }  EXP
"                A3  { 4     21 }  B0
"                A4  { 5     20 }  B1
"                A5  { 6     19 }  B2
"                A6  { 7     18 }  B3
"                A7  { 8     17 }  B4
"                A8  { 9     16 }  B5
"                A9  {10     15 }  B6
"                B9  {11     14 }  B7
"               Gnd  {12     13 }  B8
"                    |__________|

"
" This application uses the PEEL273 as an equality comparator for two
" 10-bit values (A0-9 and B0-9). When EXP (expand) is low, the PEEL273
" works in a single mode, directly driving the EQU (equal) output high
" when A=B and low when A/=B.  When EXP is high the EQU output simulates
" an open-drain output allowing expansion to multiple PEEL273 comparators
" with EQU outputs tied in parallel with a pull-up resistor (not to
" exceed 625 ohms).  Thus, using two PEEL273s, a 20-bit equivalency
" comparator could be achieved.  When using multiple comparators the
" EQU line will pull high only when all A and B inputs of each comparator
" are equal.

"The truth table is listed below:
"
"        Inputs          Output
"  A0-9   B0-9   EXP      EQU
"   A   =  B      0        1
"   A  /=  B      0        0
"   A   =  B      1        Z
"   A  /=  B      1        0


"PIN DEFINITIONS"

"Inputs"

A0       pin  1
A1       pin  2
A2       pin  3
A3       pin  4
A4       pin  5
A5       pin  6
A6       pin  7
A7       pin  8
A8       pin  9
A9       pin 10
B9       pin 11
B8       pin 13
B7       pin 14        "Pins 14-22, default polarity = pos.
B6       pin 15
B5       pin 16
B4       pin 17
B3       pin 18
B2       pin 19
B1       pin 20
B0       pin 21
EXP      pin 22


"Outputs

EQU      pin 23 = neg


EQUATIONS

EQU      = !(A0 & !B0 # !A0 & B0 #    "Compare A to B.
             A1 & !B1 # !A1 & B1 #    "If A /= B, EQU=0.
             A3 & !B3 # !A3 & B3 #    "If A  = B, EQU=1.
             A4 & !B4 # !A4 & B4 #
             A5 & !B5 # !A5 & B5 #
             A6 & !B6 # !A6 & B6 #
             A7 & !B7 # !A7 & B7 #
             A8 & !B8 # !A8 & B8 #
             A9 & !B9 # !A9 & B9)

Enable EQU = !EXP #                   "If EXP=0 enable EQU, if=1 then
             A0 & !B0 # !A0 & B0 #    "compare A to B.
             A1 & !B1 # !A1 & B1 #    "If A /= B, EQU is enabled and = 0.
             A3 & !B3 # !A3 & B3 #    "If A  = B, EQU is disabled so
             A4 & !B4 # !A4 & B4 #    "that EQU=1 via pull-up resistor.
             A5 & !B5 # !A5 & B5 #
             A6 & !B6 # !A6 & B6 #
             A7 & !B7 # !A7 & B7 #
             A8 & !B8 # !A8 & B8 #
             A9 & !B9 # !A9 & B9


TEST_VECTORS

(A9 A8 A7 A6 A5 A4 A3 A2 A1 A0  B9 B8 B7 B6 B5 B4 B3 B2 B1 B0  EXP -> EQU)
  0  0  0  0  0  0  0  0  0  0   0  0  0  0  0  0  0  0  0  0   0  ->  H
  0  0  0  0  0  0  0  0  0  1   0  0  0  0  0  0  0  0  0  0   0  ->  L
  1  0  1  0  1  0  1  0  1  0   1  0  1  0  1  0  1  0  1  0   0  ->  H
  1  0  1  0  1  0  1  0  1  0   0  1  0  1  0  1  0  1  0  1   0  ->  L
  1  1  1  1  1  1  1  1  1  1   1  1  1  1  1  1  1  1  1  1   0  ->  H
  1  1  1  1  1  1  1  1  1  1   1  1  1  1  1  1  1  1  1  0   0  ->  L
  0  0  0  0  0  0  0  0  0  0   0  0  0  0  0  0  0  0  0  0   1  ->  Z
  0  0  0  0  0  0  0  0  0  1   0  0  0  0  0  0  0  0  0  0   1  ->  L
  1  0  1  0  1  0  1  0  1  0   1  0  1  0  1  0  1  0  1  0   1  ->  Z
  1  0  1  0  1  0  1  0  1  0   0  1  0  1  0  1  0  1  0  1   1  ->  L
  1  1  1  1  1  1  1  1  1  1   1  1  1  1  1  1  1  1  1  1   1  ->  Z
  1  1  1  1  1  1  1  1  1  1   1  1  1  1  1  1  1  1  1  0   1  ->  L
                                                                                                         