/*---------------------------------------------------------*/
/*                                                         */
/*              MODES.CPP - controls the Video Modes Menu  */
/*              Copyright (c) 1992 by Cirrus Logic Inc.    */
/*                                                         */
/*   MV:1/2/92 - file created                              */
/*                                                         */
/*   Modifications:                                        */
/*                                                         */
/*   MOD2:  CENTERING                STEVE C. 9-08-93      */
/*                                                         */
/*---------------------------------------------------------*/

#define USE_RAW_KEYS				// For accelarator key definitions.
#define USE_HELP_CONTEXTS
#include <ui_win.hpp>
#include <string.h>
#include "clview.hpp"
#include "clmode.hpp"


void getExtdMode(int);
void getStdmode(int);
void preview(byte, boolean);

extern USHORT clmode;				// mode to be set
extern modeRec *modeList;			// list of modes available
extern boolean isVesaProduct;
#ifdef DESKTOP
extern int getBIOSVersionNum ();
extern int Is_RAMTableLoaded ();
#endif

static EVENT_TYPE Exit_Display(UI_WINDOW_OBJECT *data, UI_EVENT &, 
		EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return 0;

	// Exit the application by sending a message.
	UIW_BUTTON *item = (UIW_BUTTON *)data;

	switch (item->value) {
		case S_CLOSE:
			item->eventManager->DevicePosition(E_MOUSE, 0, 0); /* 2.30 beta 2 */
			preview(clmode, FALSE);

			// reset the mouse cursor to (0,0) 
			// otherwise we'll go into preview mode again
			item->eventManager->DevicePosition(E_MOUSE, 0, 0);
			item->eventManager->Put(UI_EVENT(S_REDISPLAY));
			break;
		case S_CANCEL:
			item->eventManager->Put(UI_EVENT(S_CLOSE));
			break;
		case L_HELP:
			item->eventManager->Put(UI_EVENT(L_HELP));
			break;
	}
	return(ccode);
}

UI_WINDOW_OBJECT *CONTROL_WINDOW::Window_Modes(void)
{
	int top=0, left=12, lwidth=54, wwidth=60;
	char *string=new char[65];
#ifdef DESKTOP   // MOD2, CENTERING
	char *centeringstring=new char[74];
	int cwidth;

	if (getBIOSVersionNum () < 0x130){
	  strcpy (centeringstring,"Centering Adjust is not available...  BIOS must be v.1.30 or greater.");
	  cwidth = 2;
	}
	else {
	  if(Is_RAMTableLoaded () == TRUE){
	    strcpy (centeringstring,"Centering Adjust is not available...  CENTER.COM TSR is loaded.");
	    cwidth = 4;
	  }
	  else {
	    strcpy (centeringstring,"Centering Adjust is available while in PREVIEW for mode 58h or higher.");
	    cwidth = 1;
	  }
	}
#endif

	if (isVesaProduct)
	{	
		lwidth+=10; wwidth+=10;	left+=5;
		strcpy(string, "Resolution    Colors     Type      Char Cell   Mode   VESA mode");
	}
	else strcpy(string,"Resolution    Colors     Type      Char Cell   Mode");

	delete modeList;				// free the pointer to be safe
	modeList = NULL;				// initialize it
	// Get the list of modes available
    for(int mode=0x7f; mode >= 0x14; mode--)
       getExtdMode(mode);
    for(mode=(MAXSTD-1); mode >= 0; mode--)
	    getStdmode(mode);

	UIW_VT_LIST *list = new UIW_VT_LIST(2, 1, lwidth, 12);
	modeRec *tmodes = new modeRec;
	for(tmodes = modeList; tmodes != NULL; tmodes=tmodes->next,top++)
    {
	 *list
	   + new VT_LIST_ITEM(lwidth, tmodes->info, (USHORT)(tmodes->modenum), tmodes->scanline);
     }

	delete tmodes;
	 *list
		+ new UIW_SCROLL_BAR(0, 0, 0, 0, SBF_VERTICAL);

	// Create a window with the matrix in it and add it to Window Manager.
	UIW_WINDOW *window = new UIW_WINDOW(13, 1, wwidth, 18, WOF_NO_FLAGS,
 				WOAF_MODAL | WOAF_NO_SIZE, HELP_DISPLAY );

	*window
		+ new UIW_BORDER
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE("Video Modes Preview")
		+ new UIW_PROMPT(2, 0, string)
		+ list
#ifdef DESKTOP    // MOD2, String prompts for centering adjust
		+ new UIW_TEXT(cwidth, 13, 74, 1,
		   centeringstring,74, WNF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE)
#endif
		+ new UIW_BUTTON(left-8, 15, 10, "&Preview", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
			WOF_BORDER | WOF_JUSTIFY_CENTER, Exit_Display, S_CLOSE )
		+ new UIW_BUTTON(left+11, 15, 10, "C&ancel", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
			WOF_BORDER | WOF_JUSTIFY_CENTER, Exit_Display, S_CANCEL )
		+ new UIW_BUTTON(left+30, 15, 10, "&Help", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
			WOF_BORDER | WOF_JUSTIFY_CENTER, Exit_Display, L_HELP);

	//   Return the window pointer.
		return(window);
}

VT_LIST_ITEM::VT_LIST_ITEM(int width, char *text, USHORT num1, USHORT num2) :
	UIW_STRING(0, 0, width, text, -1, STF_NO_FLAGS, WOF_BORDER | WOF_VIEW_ONLY, NULL)
{
	mode = num1;
	scanlines = num2;
}

EVENT_TYPE VT_LIST_ITEM::Event(const UI_EVENT &event)
{
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case E_KEY:
		switch (event.rawCode) {
			case KEY_A:
				eventManager->Put(UI_EVENT(S_CLOSE));
				break;
			case KEY_H:
			case ALT_H:
				eventManager->Put(UI_EVENT(L_HELP));
				break;
			case KEY_P:
				eventManager->DevicePosition(E_MOUSE, 0, 0);  /* 2.30 beta 2 */
				preview(clmode, FALSE);
				eventManager->DevicePosition(E_MOUSE, 0, 0);
				eventManager->Put(UI_EVENT(S_REDISPLAY));
				break;
		}
	case L_PGUP:
	case L_PGDN:
	case S_CURRENT:
	case S_NON_CURRENT:
		if (ccode == S_CURRENT)
			woStatus |= WOS_SELECTED;
		else
			woStatus &= ~WOS_SELECTED;
	case S_DISPLAY_ACTIVE:
	case S_DISPLAY_INACTIVE:
		if (FlagSet(woStatus, WOS_SELECTED))
			::clmode = mode;
		break;
	}
	ccode = UIW_STRING::Event(event);
	// Return the control code.
	return (ccode);
}
