/***********************************************************************
 *
 *	File name:  	util.c
 *
 *	Description:	This files contains the functions for
 *                      getting messages from the receive buffers,
 *                      polling the ports, sending messages and
 *                      task start-up messaging.
 *
 *	Functions:	get_event()
 *                      get_NW_event()
 *                      sendDSP_REQ()
 *                      sendTERM_REQ()
 *                      sendTERM()
 *                      sendMsg()
 *                      sendStart()
 *                      getConf()
 *                      startUp()
 *
 *
 *      Version		Date		ID	        Comment
 *	----------------------------------------------------------------
 *	0.1		120188		TEKELEC/IA	first created
 *	1.0		120888		TEKELEC/IA	Demo package
 *
 ***********************************************************************/



#include	"mainSym.h"
#include        "tos.h"






/*
 *	Function:	get_event()
 *	Description:	Get message from specified message buffer.
 *                      The retrieval from the message buffer is
 *                      waited, the function will not return until
 *                      ther is an event. 
 *
 *	Inparameters:   message buffer identification
 *                      receive space
 *
 *	Outparameters:  event type
 *
 */

int get_event(id,rec)
long int id;
byte *rec;
    {
    long int r;
    RECEIVE  *p;
    int result;

    result = getmsw(id,&r);

    p = (RECEIVE *) r;

    strcpy( rec,p);
    strcpy( rec+4,p->info );  

    free( (byte *) r);

    return(p->event);

    } /* end get_event() */






/*
 *	Function:	get_NW_event()
 *	Description:	Get message from specified message buffer,
 *                      serial port, basic rate port or keyboard.
 *                      The waiting for an event is non waited, ie
 *                      if there is no event the function will not
 *                      wait until there is one. 
 *
 *	Inparameters:   message buffer identification
 *                      receive space
 *
 *	Outparameters:  event type
 *                      -1 when there is no event
 *
 */


int get_NW_event(id,rec)
long int id;
byte *rec;
    {
    long int r;
    RECEIVE  *p;
    int result,val;

    rxlen = 0;
    pause(SEC+1);
    if ( recpa(rec,1L)  > 0   )   return(AUX_SIG) ; 
    if ( getch(_stdvt) == F10 )   return(TERM_REQ);
    if ( getmsn(id,&r) == MBEOF ) 
       {
       setport(PORTA);
       if ( receive(rec) != 0 )  return(TERM_REQ); 
       if ( rxlen != 0  )  return(PA_SIG);
       setport(PORTB);
       if ( receive(rec) != 0 )  return(TERM_REQ);
       if ( rxlen != 0  )  return(PB_SIG);
       return(-1);
       }
    else
      {
      p = (RECEIVE *) r;

      strcpy(rec,p);
      strcpy(rec+4,p->info);

      free( (byte *) r);
      return(p->event);
      }
    } /* end get_event() */






/*
 *	Function:	sendDSP_REQ()
 *	Description:	This function send a display request to
 *                      the destination task.
 * 
 *
 *	Inparameters:   destination
 *                      event
 *                      information buffer
 *
 *	Outparameters:  none
 *
 */



sendDSP_REQ(dest,id,str)
long int dest;
int  id;
byte *str;
    {

    DSPREQ *s;
    int result;
    
    s = (DSPREQ *) malloc( sizeof(DSPREQ) );

    s->event = DSP_REQ;
    s->taskId = id;

    strcpy(s->text,str);

    result = putmse( dest, (long int) s);


    } /* end sendDSP_REQ */



/*
 *	Function:	sendTERM_REQ()
 *	Description:	This function send a termination request to
 *                      the destination task.
 * 
 *
 *	Inparameters:   destination
 *                      sender identification
 *                      information buffer
 *
 *	Outparameters:  none
 *                      
 */


sendTERM_REQ(dest,id,str)
long int dest;
int  id;
byte *str;
    {
    TERMREQ *s;
    int result;
    
    s = (TERMREQ *) malloc( sizeof(TERMREQ) );

    s->event  = TERM_REQ;
    s->taskId = id;

    strcpy(s->text,str);

    result = putmse( dest, (long int) s);

    } /* sendTERM_REQ */





/*
 *	Function:	sendTERM()
 *	Description:	This function send an ABORT command to
 *                      the destination task.
 * 
 *
 *	Inparameters:   destination
 *
 *	Outparameters:  none
 *
 */


sendTERM(dest)
long int dest;
    {

    RECEIVE *s;
    int result;
    
    s = (RECEIVE *) malloc( sizeof(RECEIVE) );

    s->event  = ABORT;

    result = putmse( dest, (long int) s);

    } /* end sendTERM */


/*
 *	Function:	sendTERM()
 *	Description:	This function send a message to
 *                      the destination task.
 * 
 *
 *	Inparameters:   destination
 *                      event
 *                      information string
 *
 *	Outparameters:  none
 *
 */




sendMsg(dest,event,str)
long int dest;
int event;
byte *str;
    {

    RECEIVE *s;
    int result;
    
    s = (RECEIVE *) malloc( sizeof(RECEIVE) );

    s->event  = event;
    strcpy(s->info,str);

    result = putmse( dest, (long int) s);

    } /* end sendTERM */


/*
 *	Function:	sendStart()
 *	Description:	This function send a start up message to
 *                      the destination task.
 *
 *	Inparameters:   destination
 *
 *	Outparameters:  none
 *
 */



sendStart(dest)
long int dest;
    {

    RECEIVE *s;
    int result;
    
    s = (RECEIVE *) malloc( sizeof(RECEIVE) );

    s->event  = START_REQ;

    result = putmse( dest, (long int) s);

    } /* end sendStart */




/*
 *	Function:	getConf()
 *	Description:	This function waits for a START_CONF message.
 *
 *	Inparameters:   receive buffer identification
 *
 *	Outparameters:  none
 *
 */



int  getConf(recKey)
long int recKey;
    {
    long int r;
    RECEIVE  *p;
    int event,id;

    do
       {
       getmsw(recKey,&r);
       p = (RECEIVE *) r;
       event = p->event;
       id    = p->taskId;
       free( (byte *) r);
       }
    while( event != START_CONF );

    return(id);

    } /* end getConf() */




/*
 *	Function:	startUp()
 *	Description:	This function exchanges START_REQ and
 *                      START_CONF messages.
 *
 *	Inparameters:   coordinator task identification
 *                      own identification
 *                      own receive buffer identification
 *
 *	Outparameters:  none
 *
 */


startUp(co,id,rKey)
long int co, rKey;
int id;
    {
    long int r;
    RECEIVE *p;
    do
        {
        getmsw( rKey, &r);
        p = (RECEIVE *) r;
        }
    while ( p->event != START_REQ);

    p->event  = START_CONF;
    p->taskId = id;

    putmse( co, r);

    } /* end startUp */


/*-------------------      end util.c        ----------------*/
