/***********************************************************************
 *
 *	File name:      port.c
 *
 *	Description:	
 *
 *	Functions:	portPoll()
 *                      initPort()
 *
 *
 *      Version		Date		ID		Comment
 *	----------------------------------------------------------------
 *	0.1		120188		TEKELEC/IA	first created
 *	1.0		120888		TEKELEC/IA	Demo package
 *
 ***********************************************************************/



#include	"mainSym.h"
#include        "tos.h"



/*
 *	Function:	portPoll()
 *	Description:	This function (task) polls all the i/o devices
 *                      and depending on the event sends it to
 *                      the appropriate task.
 *
 *	Inparameters:   initiation structure
 *
 *	Outparameters:  none
 *
 */

portPoll(t)
PORTINIT *t;
    {

    byte rec[256];
    int  event;


    initPort(t);


    for(;;)
        {
        while( (event = get_NW_event(t->recKey,rec)) == -1 );

        switch(event)
            {
            case TERM_REQ: sendTERM(t->coKey);
                           break; 

            case ABORT:    reset_port(PORTA); 
                           reset_port(PORTB);
                           return;
             
            case PA_SIG:   sendMsg(t->portAKey,event,rec);
                           break;

            case PB_SIG:   sendMsg(t->portBKey,event,rec);
                           break;
 
            case AUX_SIG:  sendMsg(t->coKey,AUX_SIG,rec);
                           break;

            default:     sendDSP_REQ(t->coKey,t->taskId,"Unknown event PORT");
                         break;
            }
        }
    } /* end portPoll() */


/*
 *	Function:	initPort()
 *	Description:	This function opens the PORT tasks communication
 *                      buffers and exchanges start up messages with
 *                      the coordinator task.
 *
 *	Inparameters:   initiation structure
 *
 *	Outparameters:  none
 *
 */

initPort(t)
PORTINIT *t;
    {

    t->coKey    = crmsb( t->coKey,  MSBGBL+50L );
    t->recKey   = crmsb( t->recKey, MSBGBL+50L );
    t->portAKey = crmsb( t->portAKey, MSBGBL+50L );
    t->portBKey = crmsb( t->portBKey, MSBGBL+50L );

    startUp(t->coKey,t->taskId,t->recKey);

    } /*  end initPort */


/*-------------------      end port.c        ----------------*/