
V.120 LAPD COMMANDS AND VARIABLES

BREAK     Disassemble I-field into strings and mnemonics (udm)
          BREAK udm,$A,$B,udm,$C...  

BUFFER   Defines a message for the transmission buffer in hex.  
          BUFFER = xxx

BUILD     Assembles a message in the transmission buffer.
          BUILD udm,$A,$B,udm,$C...   

DEFINE    Defines a frame control mnemonic.
          DEFINE"name" = x
          name is a mnemonic name 
          x is the field width in bits (maximum width = 16)

FRELNK     Read-only variable that returns the number of the 
           lowest disabled link (0 - 63).  If FRELNK returns 
           -1, there are no disabled links.
           PRINT FRELNK
           IF FRELNK....
           SET LINK = FRELNK

FRSTAT     Read-only variable that returns a 2-byte value.  
           The first byte contains the link number.
           The second byte is interpreted as shown below.

           Bit 0,1      00 = UI frame
                        01 = XID frame
                        10 = I-frame
                        11 = CMDR (Diagnostic field)
           Bit 2,3,4,5  Reserved
           Bit 6        0 = Command frame
                        1 = Response frame
           Bit 7        0 = Poll/Final bit clear
                        1 = Poll/Final bit set


LENGTH    Returns the length of the received frame.

LNKSTAT   Returns the status of the link.
          Returns:
          0   Link Disconnected Mode 
          1   Link Connection Requested
          2   Frame Rejected
          3   Disconnect Requested State
          4   Information Transfer State
          5   Local Station Busy
          6   Remote Station Busy
          7   Local & Remote Stations Busy
          8*   Remote Station Not Responding

LRDISPF   Outputs the last data field received to a printer
          or remote device. 
          LRDISPF

LTDISPF   Outputs the last data field built to a printer
          or remote device.  
          LTDISPF

RDISPF    Displays the last data field received.
          RDISPF

REC       Transfers the next message from the reception 
          buffer to the trace buffer. 
          REC

RECLNK     Read-only variable that returns the number of the 
           link from which the last data was received.
           PRINT RECLNK
           IF RECLNK....
           SET LINK = RECLNK

RTRAN      Transmits an I-Frame response.  It sets the C/R 
           bit to the response value and transmits the frame. 
           RTRAN

SET       Sets the values of the SIMP/L LAPD variables.
          SET N200 = x     Cannot = 0
          SET N201 = x     Range: 2 - 512
          SET T200 = x     No range
          SET T203 = x     No range
          SET Window = x   Range: 1 - 7

*SET CONFIG   Sets bit-mapped control configuration byte.
              SET CONFIG = xx
              xx is a hex value, as follows: 

               Bit 0   Reserved
               Bit 1   Interframe Fill      0 = 7E
                                            1 = FF
               Bit 2   Address Restricted   0 = Unrestricted 
                                            1 = Restricted 
               Bit 3   Status Changing Frames 
                         0 = Poll normal 
                         1 = Poll set 
               Bit 4   SABM(E) Response   0 = UA only.  
                                          1 = UA and SABM(E). 
               Bit 5,6   XID Poll Bit   
                         00 = No XIDs polled.  
                         01 = Poll XIDs without I-fields.
                         10 = Poll XIDs with I-fields.
                         11 = Poll all XIDs 
               Bit 7   XID Exchange   0 = Stop transmitting 
                                          XIDs on T203 timeout
                                      1 = Transmit XID command
                                          on T203 timeout.

SET LINK   Places one of the 64 available links under 
           user control. 
           SET LINK = 7
           SET LINK = A
           SET LINK = RECLNK

SET LLI    Sets the Logical Link Identifier value for 
           the selected link. 
           SET LLI = X   (X is in the range 0 - 8191)

SLOF      Disconnects the link by sending DISC frame. 
          SLOF

SLON      Attempts to set the frame level link.
          SLON

STATE      STATE displays the state of all 64 links in a 
           4 x 16 matrix corresponding to the link number.
           STATE

STATUS   STATUS displays link status information (SAPI, TEI, 
         (link number, T200, T203, N201, N200, Modulo, Window,
         Network/subscriber, state) about the selected link.
         STATUS

TDISPF    Displays the last data field built. 
          TDISPF

TRAN      Transmits a message. 
          TRAN

TRUI      Transmits a UI frame
          TRUI

*TRXIDC   Transmits an XID command frame.
          TRXIDC

*TRXIDR   Transmits an XID response frame.
          TRXIDR


