#include "stdio.h"
#include "com.h"
#include "video.h"
#include "x25.h"

extern long	_stdvt ;

/*********************************************************************
File : x25_tsk.c
Date : December 28th 1989
Author : Gilles Lejeune

Decription : main control task for test control
             This program will initialize 2 pipes of communication

**********************************************************************/

main()
{
char	testname[100] ;		/* buffer for file name */
long	lida,lidb ;		/* Protocol tasks loader ID to save */
MB_MESS	mess_st ;		/* Communication structure */
MB_MESS	*pmess = &mess_st ;	/* pointer on communication structure */

puts(CLEARS) ;
puts("Initalizing Mail boxes") ;

/*----------- Pipes initialization -----*/

if ( com_crctlmb(2) < 0 )
	puts("cannot create mb") ; 

/*---------- Start HDLC task -----------*/

puts("Starting HDLC task") ;
if ( ( lida = com_startl("HL_TASK","",0L) ) < 0 )
	{
	puts("Cannot start HDLC task") ;
	exit(0) ;
	}
if ( com_wrdy(PORT_A,1+MIN) == -1 )	/* wait to be ready */
	puts("Init timed out") ;
puts("HDLC task ready") ;

/*---------- Start Asynchronous task ---*/

puts("Now starting ASYNC task") ;
if ( ( lidb = com_startl("ASY_TSK","",0L) ) < 0 )
	{
	puts("Cannot start Async task") ;
	com_exit(PORT_A,lida) ;
	exit(0) ;
	} 
if ( com_wrdy(PORT_B,1+MIN) == -1 )	/* wait to be ready */
	puts("Init timed out") ;
puts("ASYNC task ready") ;

/*--------- Initialization ready, wait for a key and start ---*/

puts("Init succesfull, Press a key to set the link on") ;
getchar() ;

/*-------- Send a Set Link On order to HDLC task -----*/

pmess->port = PORT_A ;
pmess->type = CT_CMD ;
pmess->info = HL_SLON ;
com_snd(pmess) ;

/*------- Main loop, prompt the user for a test name and execute it ------*/

while(1)
	{
	puts(CLEARS) ;			/* clear screen */
	puts("\n\n") ;
	printf("Enter test name ( 0 Return to exit ) > ") ;
	gets(testname) ;		/* get file name */
	if ( testname[0] == '0' )	/* if 0 , stop */
		break ;
	else
		execl(testname,"",0L) ;	/* execute test */
	}

/*------ The user wants to exit, kill the protocol task ---*/
com_exit(PORT_A,lida) ;
com_exit(PORT_B,lidb) ;

com_dlctlmb() ;		/* delete MTOS-UX ressources */
} 
