#include "com.h"
#include "x25.h"

extern int	rxlen ;

#define	HL_WAIT	200	/* waiting time for reception */
#define HL_SIZE	600	/* maximum size of data buffer */

/****************************************************************
File : hl_task.c
Date : Dec 28th 1989
Author : Gilles Lejeune
Desc : Protocol task. Controls the HDLC link on port A

Modification : June 19th 1990
               Modified to use the standard HDLC library
*****************************************************************/

main()
{
int		ret ;			/* return value */
int		messtype ;		/* message type */
char		*pdata ;		/* pointer for data */
MB_MESS		mess_st ;		/* communication structure */
MB_MESS		*pmess = &mess_st ;	/* pointer on communication structure */

pmess->port = PORT_A ;

/*------- create Communication pipes ( 1 pipes )  */

if ( com_crpmb(pmess->port,1) != 0 )
	{
	puts("Cannot open reception mail box") ;
	exit(0) ;
	}

/*------- init hdlc level 2 task ----- 

	DTE,Subscriber,NRZ,9600 bits/s

	( see HDLC library manual for details )

--------------------------------------*/

if ( ( ret = initp1(1,1,0,9600L) ) != 0 )
	com_error(pmess->port,ret) ;

/*------- init hdlc parameters  -----

	size of HDLC frame : 2000
	number of retransmissions : 10
	retransmission timer : 250 ms
	acknowledgement timer : 5 ms
	window size : 2
	modulus of operation : Modulo 8

	( see HDLC library manual for details )

---------------------------------	

if ( ret == 0 )
	{
	if ( (ret = hdlc_setup(2000,10,250,5,2,1)) != 0 )
		com_error(pmess->port,ret) ;
	}
---------------------------------------*/

set_n1(512) ;	/* N1 = 512 bytes */
set_n2(10) ;	/* N2 = 10 retransmissions */
set_t1(250) ;	/* T1 = 250 ms */
set_window(2) ;	/* K = 2 */

pdata = NULL ; 

/*-------- set protocol task ready */ 

com_setrdy(pmess->port) ;

/*------- main loop */

while(1)
	{

	/*--- check message reception */

	if ( (messtype = com_chkmb(pmess) ) >= 0 )
		{
		/*--- message received, decode it */

		switch ( messtype )
			{
			case CT_CMD :	/* command message */
				if ( pmess->info == HL_SLON )
					{
					if ( status() != 4 )
						slon() ;
					}
				else if ( pmess->info == HL_SLOF )
					slof() ;
				break;
			case CT_DATA :	/* data message */
				transmit(pmess->pdata,pmess->len) ;
				com_rel(pmess->pdata) ;
				break ;
			case CT_FLUSH :	/* flush message */
				flush() ;
				break ;
			case CT_EXIT :	/* exit message */
				p1reset(1) ;
				exit(0) ;
				break ;
			default :
				break ;
			}	 
		}

/*----- get a pointer for the data */

	if ( pdata == NULL )
		{
		if ((pdata = com_gptr(HL_SIZE)) == NULL )
			puts("HDLC alloc error") ;
		} 

/*----- check line reception */

	receive_wait(pdata,HL_WAIT) ;
	if ( rxlen != 0 )
		{
		/* if restart send restart conf */

		if ( (unsigned char)*(pdata+2) == PT_RST )
			{
			*(pdata+2) = PT_RSTC ;
			transmit(pdata,3) ;
			com_rel(pdata) ;
			pdata = NULL ;
			}

		/* else, send data to control task */

		else
			{
			pmess->len = rxlen ;
			pmess->pdata = pdata ;
			pmess->type = CT_DATA ;
			com_snd(pmess) ;	/* send data message */
			pdata = NULL  ;
			}
		}
	}
}

/*---- receive wait function for HDLC library */

receive_wait(pdata,time) 
char	*pdata ;
int	time ;
{
int	rep ;	/* number of loop */

rep = time/50 ;

do 
	{
	receive(pdata) ;
	if ( rxlen != 0 )
		break ;
	pause(50+MS) ;
	}
while ( rep-- ) ;
}
