	title	'Boot loader module for CP/M 3.0'

;
; Updated to Version 1.2	03-02-84	LEL
; Updated to Version 1.3        03-29-84        LEL
; Updated to Version 1.4  	07-03-84	LEL
;
	
	maclib ports
	maclib	z80


	public	?init,?ldccp,?rlccp,?time
	public  nint, ivect ,empty$ptr    

	extrn	?pmsg,?conin
	extrn	@civec,@covec,@aivec,@aovec,@lovec
	extrn 	@cbnk,?bnksl
	extrn	aux$in$ptr, aux$out$ptr, kb$buf$in
	extrn	rsint, kint, firq, dspint
	extrn	@date,@hour,@min,@sec
	extrn	kmodei,motor$counter

bdos 	equ	5

	if banked
tpa$bank	equ 1
	else
tpa$bank	equ 0
	endif

	dseg	; init done from banked memory
?init:
	di					; disable interrupts
	lxi h,08000h 				; hl <= device 0
	shld @covec 				; DISPLY = console output

	lxi h,04000h 				; hl <= device 1
	shld @aivec 				; AUX = auxiliary input 
	shld @aovec				; AUX = auxiliary output

	lxi h,2000h				; hl <= device 2
	shld @civec				; KB = console input

	lxi h,1000h				; hl <= device 3
	shld @lovec				; LPT = Centronics parallel ptr

; Set up interrupt vectors.  Begin by pointing them all at a null
; interrupt routine so that every interrupt is satisfied in some way.
;

	lxi d,nint				; get address of null vector
 	lxi h,ivect				; point to ivect table
ini$vec:
	mov m,e           			; store low byte of NINT
	inr l					; increment hl
	mov m,d       				; store hi byte of NINT
	inr l					; increment hl
	jrnz ini$vec				; do for all

;
; Set up interrupt mode 2 and select page
;
	IF	REAL$1050
	mvi	a,ivect/256			; get address of ivect
	dw	47EDH				; "LD I,A"
	dw	05eedh				; "IM2"
	ENDIF
;
; Set up the interrupts that are implemented
;

intset	lxi h,firq				; Floppy completion
	IF	REAL$1050
	shld	ivect+08
	ELSE
	shld ivect+2				; Point to vector
	ENDIF

	lxi h,kint				; Keyboard interrupt
	IF	REAL$1050
	shld	ivect+10
	ELSE
	shld ivect+4				; Point to vector
	ENDIF

	lxi h,rsint				; RS232 interrupt
	IF	REAL$1050
	shld	ivect+14
	ELSE
	shld ivect+16				; Point to vector
	ENDIF

	IF	REAL$1050			; display interrupt
	lxi	h,dspint			; (from 6502 side)
	shld	ivect+04			;

	lxi     h,vert$int			; Vertical retrace int
	shld	ivect+06

	ENDIF

;
; Initialize interrupt buffers
;

	lxix aux$in$ptr				; Point to aux input buff
	call empty$ptr				; fix pointers to empty

	lxix aux$out$ptr			; Point to aux output buff
	call empty$ptr				; fix pointers to empty

	lxix kb$buf$in				; Point to kbd buffer
	call empty$ptr				; fix pointers to empty

	IF	REAL$1050

	mvi	a,all$ints			; Get interrupt mask
	out	p$clk$portb			; Send  out

	mvi	a,int$initial			; Initial value
	out	int$port			; to int port
	ENDIF
	ei					; reenable interrupts

;
; Put up sign on message
;

	lxi h,signon$msg			; point to sign on msg
	call ?pmsg				; print it out
	ret	


;
; Routine Empty$ptr
;
; "Empties" buffer by pointing empty and fill pointers to same 
; location in buffer.
;
empty$ptr:
	xra a					; Clear A
	stx a,buf$empty			; store in empty ptr
	stx a,buf$fill				; and fill ptr
	ret



	page

	cseg

	; boot loading most be done from resident memory
	; This version of the boot loader loads the CCP from a file
	; called CCP.COM on the system drive (A:).
?ldccp:
;
; In order to allow booting from the winchester OR the floppy disk,
; the boot program puts the drive code (01 for floppy A: drive or
; 07 for winchester C: drive) at location C000.  We pick it up from      
; there and use it to locate CCP.COM.
;

	lxi	h,0c000h	; Point to C000			(LEL0284)
	mov	a,m   		; Get what is at C000		(LEL0284)
	cpi	07h		; Is it the winch?		(LEL0284)
	jrz	ld$0		; Jump if yes			(LEL0284)
	mvi	a,01		; Else, force to A:		(LEL0284)
	jr	ld$4		;				(LEL0384)
ld0:				;				(LEL0284)
	mvi	a,3		; Force to C:			(LEL0384)
ld4:				;				(LEL0384)
    	mov	m,a		; Store in C000			(LEL0384)
	sta	ccp$fcb		; Store in FCB			(LEL0284)
	adi	40h		; Make alphabetic		(LEL0284)
	sta	ccp$drv		; Store for error msg 		(LEL0284)

;
; Set up the FCB                                  
;
	xra a 
	sta ccp$fcb+15		; zero extent
	sta ccp$fcb+12		; Zero ex field
	sta ccp$fcb+32		; Zero cr field
	lxi	d,ccp$fcb	; Point to FCB

	call open		; open file 

	inr	a
	jrz no$ccp  		; If not found, check again
;
; File found.  Load into 100h.
;

	lxi d,0100h 
	call setdma		;start of TPA
	lxi d,128		;
	call setmulti		;Read 128 rec  at a time
	lxi d,ccp$fcb 
	call read		;load the thing
	IF     BANKED
;
; Now, Copy CCP to bank to bank 2 for reloading 
;
	lxi h,0100h 
	lxi b,1000h		; move 4K
	lda @cbnk 
	push psw		; save current bank
ld$1:
	mvi a,tpa$bank 
	call ?bnksl		; select TPA
	mov a,m 
	push psw		; get a byte
	mvi a,2 
	call ?bnksl		; select extra bank
	pop psw 
	mov m,a			; save the byte

	inx h 
	dcx b			; bump pointer, drop count
	mov a,b 
	ora c			; test for done
	jrnz ld$1
	pop psw 
	call ?bnksl		; restore original bank
	ENDIF
;
; Set up default drive as C: or A:
;

	lda	0c000h		; Get value at C000H		(LEL0284)
	dcr	a		; A=0,etc			(LEL0284)
	mov	e,a		; Move to E			(LEL0284)
	push	d		; save				(LEL0284)
	sta	scbpb+2		; Store 			(LEL0284)
	lxi	d,scbpb		; Point to parameter block	(LEL0284)
	call	scbcall		; Set it			(LEL0284)
	pop	d		; Restore drive			(LEL0284)
	mvi	c,14		; Select disk			(LEL0284)
	call	bdos		;				(LEL0284)

ldccp$exit:
	ret
;

no$CCP:				; here if we couldn't find the file
	lxi h,ccp$msg 
	call ?pmsg		; report this...
	call ?conin		; get a response
	jr     ?ldccp		; and try again
?rlccp:
	IF    	BANKED
	lxi h,0100h 
	lxi b,1000h		; Moving in 4k from bank 2
rl$1:
	mvi a,2 
	call ?bnksl		; select extra bank
	mov a,m 
	push psw		; get a byte
	mvi a,tpa$bank 
	call ?bnksl	; select TPA
	pop psw 
	mov m,a		; save the byte

	inx h 
	dcx b			; bump pointer, drop count
	mov a,b 
	ora c			; test for done
	jrnz rl$1
	ret
	ELSE
	jmp	?ldccp
	ENDIF


	IF REAL$1050

	dseg

;
; This routine is called whenever the BDOS wants to either read
; or change the date and time.  On entry, if C=0, a read is
; requested.  If C=0FFH, a write is requested.  DE and HL must
; be preserved.
;
?time:
	push	h		; Save h
	push	d		; and d

	mov	a,c		; Get entry switch
	ora	a		; Is it 0?
	jnz	time$set	; No.  Check if setting time
;
; Requesting read of time and date
; First read in the clock data.
;

time$20:

	mvi	b,12		; Load # regs to read
	lxi	d,regorder	; Register order
	lxi	h,clkvals	; Temp storage area
	lxix	masks		; Mask for extra bits

time$25:

	ldax	d		; Get reg to read
	call	getdata		; Get data
	ldx	a,0		; Get mask
	ana	c		; AND with data
	mov	m,a		; Store result
	
	inx	d		; Increment reg
	inx	h		; and storage area
	inxix			; and mask

	djnz	time$25		; Loop till done
;
; Get date data and translate to hex. 
;

	lxi	d,year		; Point to storage for result
	lxi	h,clkvals	; Point to input values
	mvi	b,3

time$27:
	push	b		; Save count
	mov	c,m		; Get 1's digit
	inx	h		; Point to next digit
	mov	b,m		; Get 10's digit
	inx	h		; increment
	call	bcd$to$hex	; Convert to hex
	stax	d		; Store result
	inx	d		; Increment
	pop	b		; get count back
	djnz	time$27		; Loop 3 times

;
; Get hours  
;

	mov	b,m		; Get H1            
	inx	h		;
	mov	c,m		; Get H10         
	inx	h		;
	call	pack$word	; Pack into word
	sta	@hour		; Store hour

;
; Get minutes
;

	mov	b,m		; Get M1
	inx	h		;
	mov	c,m		; Get M10
	inx	h		;
	call	pack$word	; Put it in
	sta 	@min		; store minutes

;
; Get seconds
;

	mov	b,m		; Get S1
	inx	h		;
	mov	c,m		; Get S10
	call	pack$word	; pack into word
	sta	@sec		; store minutes

;
; Now, compute the number of days since 1 Jan 78.
;
	mvi	a,2		; 1978 is not leap year
	sta	leap		; so start leap count at 2

	lxi	h,0		; Initialize hl for # days
	lda	year		; Get year
	sui	78		; minus 78
	jm	time$exit 	; if less, error
	jrz	time$50		; Jump if zero
	push	psw		; save year count


time$30:
	lxi	d,365		; # days in normal year
	lda	leap		; Get leap count
	cpi	4		; Leap year?
	jrnz	time$40		; Jump if not

	inx	d    		; 366 days in a leap year
	xra	a  		; reinit leap count

time$40:
	dad	d		; add # days in year
	inr	a		; Inc leap count
	sta	leap		; store new leap count

	pop	psw		; Get year count
	dcr	a		; decrement
	jrz	time$50		; jump if zero
	push	psw		; else, save year count
	jr	time$30		; and loop again

time$50:
	lda	month		; Get month
	dcr	a		; minus 1
	jrz	time$70		; Jump if January

	dcr	a		; Else, decrement
	push h			; save # days so far
	lxi	h,month$table	; Point to month table
	mov	e,a		; move month to E
	xra	a		;
	mov	d,a		; Move 0 to D
	dad	d		; Add to beginning of table
	dad	d		; (Twice for word entries)
	mov     e,m		; Load DE with entry
	inx	h		;
	mov	d,m		;
	pop	h		; Restore days so far
	dad	d		; Add days in preceding months

;
; If year is a leap year and month is March or later, add 1 to
; number of days.
;

	lda	leap		; Get leap count
	cpi	4		; Leap year?
	jrnz	time$70		; Jump if not  

	lda	month		; Get month
	sui	3		; March or >?
	jm	time$70		; Jump if no
	inx	h		; Else, add 1 day

;
; Add in day of month
;

time$70:
	lda	day		; Get day of month
	mov	e,a		; Move to E 
	mvi	d,0		; Clear D
	dad	d		; add to date so far

;
; Update field in SCB
;

	shld	@date 		; Store SPB value
	jmp	time$exit	; and exit
;
; Pack 2 bytes into BCD word
;
pack$word:
	mov	a,c		; Get into A
	ral			; Rotate into high byte
	ral			;
	ral			;
	ral			;
	ora	b		; OR in w/H1
	ret			;

;
; Set clock using values in SPB.
;

time$set:

;
; Get hour from spb.
;

	lda	@hour		; Get hour
	push	psw		; save it
	ani	0fh		; Clear hi bits
	mov	c,a		; move to C-reg
	mvi	a,4		; Send H1
	call    put$data	;

	pop	psw		; Get hour again
	rar			; rotate into low byte
	rar			;
	rar			;
	rar			;
	ani	0fh		; Clear hi bits
	ori	08h		; Set 24 hour clock
	mov	c,a		; move to C-reg
	mvi	a,5		; Send H10
	call	put$data	;

;
; Set minutes.
;

	lda	@min		; Get minutes
	push	psw		; save it
	ani	0fh		; Clear hi bits
	mov	c,a		; move to C-reg
	mvi	a,2		; Send M1
	call    put$data	;
	pop	psw		; Get mins again

	rar			; rotate into low byte
	rar			;
	rar			;
	rar			;
	ani	0fh		; Clear hi bits
	mov	c,a		; move to C-reg
	mvi	a,3		; Send M10
	call	put$data	;

;
; Set seconds.
;

	lda	@sec		; Get seconds
	push	psw		; save it
	ani	0fh		; Clear hi bits
	mov	c,a		; move to C-reg
	mvi	a,0		; Send S1
	call    put$data	;
	pop	psw		; Get secs again
	rar			; rotate into low byte
	rar			;
	rar			;
	rar			;
	ani	0fh		; Clear hi bits
	mov	c,a		; move to C-reg
	mvi	a,1		; Send S10
	call	put$data	;

;
; Convert date in days since 1 Jan 78 to calendar date.
;

	lhld	@date		; Get date
	mvi	a,2		; Start leap count at 2
	sta	leap		;

	mvi	a,78		; Year starts at 78
	sta	year		;

time$80:
	push	h		; Save # days
	lda	leap		; Get leap count
	cpi	4		; Leap year?
	jrz	time$85		; Jump if yes

	inr	a		; Else, inc leap count
	lxi	d,365		; # days in normal year
	jr	time$87		;

time$85:
	mvi	a,1		; Reinit leap count
	lxi	d,366		; # days in leap year

time$87:
	ora	a		; Clear carry
	db	0edh,052h	; SBC HL,DE
	jm	time$90		; until negative
	jrz	time$90		; (or zero)

	sta	leap		; Store new LEAP value
	pop	d		; pop
	lda	year		; Get year count
	inr	a		; Increment it
	sta	year		; Store it again
	jr	time$80		; Loop

time$90:
	pop	h		; Restore day count
	shld	temp		; save it

;
; If this is a leap year, special considerations for Feb 29.
;

	lda	leap		; Get leap count 
	cpi	4		; Leap year?
	jrnz	time$91		; jump if not 

	xra	a		; Clear carry
	lxi	d,60		; Feb 29?
	db	0edh,052h	; Check against date
	jrz	time$98		; jump if zero
	jm	time$91		; No offset if date is <
	
	lhld	temp		; Else, offset by 1
	dcx	h		;
	shld	temp		;

time$91:
	mvi	b,001h		; Start month at 1
	lhld	temp		; Get # days
	mov	c,l		; Start # days
	lxi	h,month$table	;

Time$92:
	mov	e,m		; Get # days in month
	inx	h		; Increment
	mov	d,m		;
	inx	h		;

	push	h		; Save table pointer
	lhld	temp		; Get # days
	xra	a		; Clear carry
	db 	0edh,052h	; subtract
	jm	time$95		; Jump if negative
	jrz	time$95		; (or zero)

	mov	c,l		; Save # days in C-reg
	inr	b		; Increment month
	pop	h		; restore table ptr
	jr	time$92		; loop

time$95:
	mov	a,b		; Get month
	sta	month		; store

	mov	a,c		; Get day
	sta day			;

	pop	h		; Restore stack
	jr	time$125	;

time$98:
	mvi	a,2		; Month = Feb
	sta	month		;

	mvi	a,29		; Day = 29
	sta	day		;
	
time$125:

;
; Send year to RTC
;

	lda	year		; Get year
	call	hex$to$bcd	; Convert to BCD

	lda	ones		; Send Y1
	mov	c,a		;
	mvi	a,11		; 
	call	putdata		;

	lda	tens		; Send Y10
	mov	c,a		;
	mvi	a,12		;
	call	putdata		;

;
; Send month.
;

	lda	month		; Get month
	call	hex$to$bcd	; Convert to BCD

	lda	ones		; Send M1
	mov	c,a		;
	mvi	a,09		; 
	call	putdata		;

	lda	tens		; Send M10
	mov	c,a		;
	mvi	a,10		;
	call	putdata		;

;
; Send day.
;

	lda	day 		; Get day 
	call	hex$to$bcd	; Convert to BCD

	lda	ones		; Send D1
	mov	c,a		;
	mvi	a,07		; 
	call	putdata		;

	lda	tens		; Send D10
	mov	c,a		;
	mvi	a,08		;
	call	putdata		;


time$exit:
	di			; disable interrupts
	mvi	a,rtc$read	; Leave in READ state
	out	p$clk$control	;
	mvi	a,all$ints	; Set up int mask again
	out	p$clk$portb	;
	ei			;

	pop	d
	pop	h
	ret

; 
; This subroutine is called with bits 0-3 set up as address
; input.  Return w/C register = data.  Carry will be set if
; data changed on 2 successive reads.
;

get$data:
	push	d		; Save D
	push	psw		; Save Read address
get$3:
	in	p$clk$portc	;Read busy bit port
	ani	08h		; Mask busy bit
	jrz	get$3		; Loop till not busy

	mvi	e,rtc$write	; To RTC
	call	tofrom		; Set port A direction

	mvi	a,rtc$select	; Select bit command
	out	p$clk$control	; Select RTC

	pop	psw		; Get saved register address
	out	p$clk$porta	; Send address to RTC

	mvi	a,add$write$hi	; Set address write high
	out	p$clk$control	;

	mvi	a,add$write$lo	; Set address write low
	out	p$clk$control	;

	mvi	e,rtc$read	; From RTC
	call	tofrom		; Set port A direction

	mvi	a,rtc$select	; Select bit command
	out	p$clk$control	; Select RTC

	mvi	a,read$hi	; Set read high
	out	p$clk$control	;

	push	b		; save BC
	mvi	b,5		; Set delay count
get$33:
	djnz	get$33		; loop for delay
	pop	b		; Restore BC

	in	p$clk$porta	; Read RTC data
	ani	0fh		; Zero out upper nibble
	mov	c,a		; Move data to C

	mvi	a,read$lo	; Set read low
	out	p$clk$control	;

	mvi	a,0eh		; Deselect RTC
	out	p$clk$control	;

	pop	d		; Restore D
	ret			; Done!!


;
; Write to RTC
;

put$data:
	push	d		; save regs
	push	b		;
	push	psw		; Save address for write

put$3:
	in	p$clk$portc	; Read port busy bit
	ani	08h		; Mask busy bit
	jrz	put$3		; Loop till not busy

	mvi	e,rtc$write	; Writing
	call	tofrom		; Set port direction

	mvi	a,rtc$select	; chip select
	out	p$clk$control	;

	pop	psw		; Restore write address
	out	p$clk$porta	; Send out address

	mvi	a,add$write$hi	; Set up address write
	out	p$clk$control	;

	mvi	a,add$write$lo	; Clear address write
	out	p$clk$control	;

	pop	b		; restore saved data
	mov	a,c		; xfer data to A
	out	p$clk$porta	; write it

	mvi	a,write$hi	; Set data write high
	out	p$clk$control	;

	push	b		; save B
	mvi	b,2		; delay parameter
put$33:
	djnz	put$33		; Loop for delay
	pop	b		; Restore B

	mvi	a,write$lo	; 
	out	p$clk$control	;

	mvi	a,0eh		; Deselect RTC
	out	p$clk$control	; 

	pop	d		;
	ret			;

;

tofrom:
	di			; Disable interrupts
	push	psw		; Save PSW
	mvi	a,0eh		; Deselect RTC
	out	p$clk$control	;

	mov	a,e		; Get direction byte
	out	p$clk$control	;

	mvi	a,all$ints	; Interrupt mask
	out	p$clk$portb	;

	mvi	a,int$initial	; Interrupt setup byte
	out	int$port	; Re-init interrupt cont
	pop	psw		; restore
	ei			;

	ret			;

;
; Enter with 10's digit in B, 1's digit in C.  
; Exit with hex number in A.
;

bcd$to$hex:
	push	d		; Save D
	mov	a,b		; Get 10's digit
	ral			; *2
	mov	d,a		; (save)
	ral			; *4
	ral			; *8
	add	d		; *10
	add	c		; + 1's digit
	pop	d		; restore D
	ret			; it's that easy!

;
; Enter with # to be converted in A.
; Result in ONES and TENS.
;

hex$to$bcd:
	push	psw		; Save A
	xra	a		; Clear A
	lxi	h,tens		; Point to tens
	mov	m,a		; Clear TENS
	pop 	psw		; Restore A

hex$10:
	sui	10		; Subtract 10
	jm	hex$20		;

	inr	m		; Increment tens count
	jr	hex$10		;

hex$20:
	adi	10		; Add 10 back
	sta	ones		; Store result in ONES

	ret

masks		db	0ffh,0ffh,0ffh,0ffh,0ffh,0ffh,0ffh,003h
		db	0ffh,0ffh,0ffh,0ffh
regorder	db	0bh,0ch,09h,0ah,07h,08h,04h,05h,02h,03h
		db	00h,01h
clkvals	ds	12
year	ds	1
month	ds	1
day	ds	1
leap	ds	1
tens	ds	1
ones	ds	1
temp	ds	2

month$table:
	dw	31		; January
	dw	59		; February (non-leap)
	dw	90		; March
	dw	120		; April
	dw	151		; May
	dw	181		; June
	dw	212		; July
	dw	243		; August
	dw	273		; September
	dw	304		; October
	dw	334		; November

	ELSE
    ; No external clock.
?time:
	ret
	ENDIF
	CSEG
;
; Vertical retrace interrupt.
; Counts down until MOTOR$COUNTER=0, at which point it
; turns off the motor.
;
VERT$INT:
	push	psw			; Save A
	push	h			; and H

	out	vert$clear		; Clear interrupt
	lxi	h,motor$counter		; Point to counter
	inr	m			; Inc counter		(LEL0384)
	dcr	m			; Decrement		
	jrz	vert$50			; Jump if already 0	(LEL0384)
	dcr	m			; Else, decrement	(LEL0384)
	jrnz	vert$50  		; Do nothing till it hits 0

	in p$disk$bits			; Get 8255 bits
	ori	0100$0000b		; Turn off motor
	out	p$disk$bits		; Send it back out

VERT$50:				;			(LEL0384)
vert$exit:
	pop	h			; Restore H		(LEL0684)
	jr	int$exit		; Exit interrupt	(LEL0684)

;
; Null interrupt handler
;
NINT:
	push psw
INT$EXIT:
	mvi	a,int$initial
	out	int$port
	pop psw
	ei
	ret

	CSEG
	; CP/M BDOS Function Interfaces

scbcall:
	mvi c,49		;Set/Get SCB 
	jmp bdos
open:
	mvi c,15 
	jmp bdos		; open file control block

setdma:
	mvi c,26 
	jmp bdos		; set data transfer address

setmulti:
	mvi c,44 
	jmp bdos		; set record count

read:
	mvi c,20 
	jmp bdos		; read records


	DSEG

signon$msg	db	13,10,10,'CP/M Version 3.0, BIOS version 1.4  '
		db	13,10,'***BANKED VERSION***'
		db	27,';C'
		db	13,10,0

	CSEG

ccp$msg
		db	13,10,'BIOS Err on '
ccp$drv		db	'A'
		db	': No '
		db	'CCP'
		db	'.COM file'
		db	0
ccp$fcb		db	01
destin		db     'CCP     ','COM',0,0,0,0
		ds	16
      		db	0,0,0

scbpb:					;			(LEL0284)
		db	013h		; Offset into SCB	(LEL0284)
		db	0ffh		; Setting a byte	(LEL0284)
		db	0		; Value to set to	(LEL0284)

;
;  The locations starting at    
;  0FFF0h are reserved for interrupt vectors
;

	ASEG
	org	0fff0h

IVECT:   
	ds	2			; Expansion interface A
	ds	2			; Expansion interface B
	ds	2			; Display processor interface
	ds	2			; Vertical Clock
	ds	2			; Floppy disk interface
	ds	2			; Keyboard interface
	ds	2			; Winchester interface
	ds	2			; Async Interface

	end
