/*  *********************************************************************
    *  PATHWORKS Socket Library						*
    *  									*
    *	error text				File: DNETERR.H		*
    *									*
    *********************************************************************
    *  Copyright (c) 1985-1995, All Rights Reserved			*
    *  Digital Equipment Corporation, Littleton, MA.			*
    *  									*
    *  This software is furnished under a license and may be used and	*
    *  copied only in accordance with the terms of such license and	*
    *  with the inclusion of the above copyright notice.  This 		*
    *  software or any other copies thereof may not be provided or 	*
    *  otherwise made available to any other person.  No title to	*
    *  or ownership of the software is hereby transferred.		*
    *  									*
    *  The information in this software is subject to change without	*
    *  notice and should not be constured as a commitment by 		*
    *  Digital Equipment Corporation.					*
    *  									*
    *  Digital assumes no responsiblity for the use or reliability	*
    *  of its software on equipment which is not supplied by Digital.	*
    ********************************************************************* */

#ifndef DNETERR_H
     #define DNETERR_H

/*
 *  Error message text for connect errors.
 */
static char connect_error[] = "Connect failed, ";

static char *dnet_errlist[] = {
	"Connection rejected by object",        /* 0 - EREJBYOBJ */
        "Insufficient network resources",   /* 1 - EINSNETRES */
	"Unrecognized node name",	            /* 2 - EUNRNODNAM */
	"Remote node shutting down",	        /* 3 - EREMNODESHUT */
	"Unrecognized object",		            /* 4 - EUNROBJ */
	"Invalid object name format",	        /* 5 - EINVOBJNAM */
	"Object too busy",		                /* 6 - EOBJBUSY */
	"",                                     
	"Connection aborted by third party",    /* 8 - EABTBYMGMT */
	"Connection aborted by peer",		    /* 9 - EUSERABORT */
	"Invalid node name format",	            /* 10 - EINVNODNAM */
	"Local node shutting down",	            /* 11 - ELOCNODESHUT */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"No node resources for new logical link",   /* 32 - ENODERESOURCES */
	"No user resources for new logical link",   /* 33 - EUSERESOURCES */
	"Access control rejected",	                /* 34 - EACCCONREJ */
	"",		
	"Bad account information",                  /* 36 - EBADACCOUNT */
	"",	
	"No response from object",	                /* 38 - ENORESPOBJ */
	"Node unreachable",		                    /* 39 - ENODUNREACH */
	"",	
	"No link at remote",	                    /* 41 - ENOLINK */
	"",	
	"Connect image data field too long"         /* 43 - ECONNTOOBIG */
};

/*
 *  Error message text for other errors
 */

char	*nsys_errlist[] = {
	"Error 0",
	"Not owner",				    /* 1 - EPERM */
	"No such file or directory",	/* 2 - ENOENT */
	"No such process",			    /* 3 - ESRCH */
	"Interrupted system call",		/* 4 - EINTR */
	"I/O error",				    /* 5 - EIO */
	"No such device or address",	/* 6 - ENXIO */
	"Arg list too long",			/* 7 - E2BIG */
	"Exec format error",			/* 8 - ENOEXEC */
	"Bad file number",			    /* 9 - EBADF */
	"No children",				    /* 10 - ECHILD */
	"No more processes",			/* 11 - EAGAIN */
	"Not enough core",			    /* 12 - ENOMEM */
	"Permission denied",			/* 13 - EACCES */
	"Bad address",				    /* 14 - EFAULT */
	"Block device required",		/* 15 - ENOTBLK */
	"Mount device busy",			/* 16 - EBUSY */
	"File exists",				    /* 17 - EEXIST */
	"Cross-device link",			/* 18 - EXDEV */
	"No such device",			    /* 19 - ENODEV */
	"Not a directory",			    /* 20 - ENOTDIR */
	"Is a directory",			    /* 21 - EISDIR */
	"Invalid argument",			    /* 22 - EINVAL */
	"File table overflow",			/* 23 - ENFILE */
	"Too many open files",			/* 24 - EMFILE */
	"Not a typewriter",			    /* 25 - ENOTTY */
	"Text file busy",			    /* 26 - ETXTBSY */
	"File too large",			    /* 27 - EFBIG */
	"No space left on device",		/* 28 - ENOSPC */
	"Illegal seek",				    /* 29 - ESPIPE */
	"Read-only file system",		/* 30 - EROFS */
	"Too many links",			    /* 31 - EMLINK */
	"Broken pipe",				    /* 32 - EPIPE */

/* math software */
	"Argument too large",			/* 33 - EDOM */
	"Result too large",			    /* 34 - ERANGE */

/* non-blocking and interrupt i/o */
	"Operation would block",		    /* 35 - EWOULDBLOCK */
	"Operation now in progress",	    /* 36 - EINPROGRESS */
	"Operation already in progress",    /* 37 - EALREADY */

/* ipc/network software */

	/* argument errors */
	"Socket operation on non-socket",	/* 38 - ENOTSOCK */
	"Destination address required",		/* 39 - EDESTADDRREQ */
	"Message too long",			        /* 40 - EMSGSIZE */
	"Protocol wrong type for socket",	/* 41 - EPROTOTYPE */
	"Protocol not available",		    /* 42 - ENOPROTOOPT */
	"Protocol not supported",		    /* 43 - EPROTONOSUPPORT */
	"Socket type not supported",		/* 44 - ESOCKTNOSUPPORT */
	"Operation not supported on socket",	/* 45 - EOPNOTSUPP */
	"Protocol family not supported",	/* 46 - EPFNOSUPPORT */
	"Address family not supported by protocol family",
						                /* 47 - EAFNOSUPPORT */
	"Address already in use",		    /* 48 - EADDRINUSE */
	"Can't assign requested address",	/* 49 - EADDRNOTAVAIL */

	/* operational errors */
	"Network is down",			        /* 50 - ENETDOWN */
	"Network is unreachable",		    /* 51 - ENETUNREACH */
	"Network dropped connection on reset",	/* 52 - ENETRESET */
	"Software caused connection abort",	/* 53 - ECONNABORTED */
	"Connection reset by peer",		    /* 54 - ECONNRESET */
	"No buffer space available",		/* 55 - ENOBUFS */
	"Socket is already connected",		/* 56 - EISCONN */
	"Socket is not connected",		    /* 57 - ENOTCONN */
	"Can't send after socket shutdown",	/* 58 - ESHUTDOWN */
	"Too many references: can't splice",	/* 59 - ETOOMANYREFS */
	"Connection timed out",			    /* 60 - ETIMEDOUT */
	"Connection refused",			    /* 61 - EREFUSED */
	"Too many levels of symbolic links",	/* 62 - ELOOP */
	"File name too long",			    /* 63 - ENAMETOOLONG */
	"Host is down",				        /* 64 - EHOSTDOWN */
	"Host is unreachable",			    /* 65 - EHOSTUNREACH */
	"Directory not empty",			    /* 66 - ENOTEMPTY */
	"Too many processes",			    /* 67 - EPROCLIM */
	"Too many users",			        /* 68 - EUSERS */
	"Disc quota exceeded"			    /* 69 - EDQUOT */
};

#define SYS_NERR (sizeof(nsys_errlist)/sizeof(nsys_errlist[0]))

#endif  // DNETERR_H
