/*  *********************************************************************
    *  PATHWORKS Socket Library						*
    *  									*
    *  Generic data types			File: SKTYPES.H		*
    *									*
    *********************************************************************
    *  Copyright (c) 1985-1995, All Rights Reserved			*
    *  Digital Equipment Corporation, Littleton, MA.			*
    *  									*
    *  This software is furnished under a license and may be used and	*
    *  copied only in accordance with the terms of such license and	*
    *  with the inclusion of the above copyright notice.  This 		*
    *  software or any other copies thereof may not be provided or 	*
    *  otherwise made available to any other person.  No title to	*
    *  or ownership of the software is hereby transferred.		*
    *  									*
    *  The information in this software is subject to change without	*
    *  notice and should not be constured as a commitment by 		*
    *  Digital Equipment Corporation.					*
    *  									*
    *  Digital assumes no responsiblity for the use or reliability	*
    *  of its software on equipment which is not supplied by Digital.	*
    ********************************************************************* */


#ifndef PWTYPES_H
#define PWTYPES_H

/*
 * Define types for general use.
 */

typedef	unsigned char	u_char;
typedef	unsigned short	u_short;
typedef	unsigned int	u_int;		/* ## 32 or 16 bits? */
typedef	unsigned long	u_long;

typedef unsigned char	uchar;
typedef unsigned short  ushort;         /* sys III compat */
typedef unsigned long	ulong;

typedef unsigned char  field8;		/* 8-bit message field */
typedef unsigned short field16;		/* 16-bit message field */
typedef unsigned long  field32; 	/* 32-bit message field */

#ifdef	__HIGHC__
	/*
	 * For now, we ASSUME that if it's High C, it's PROT386.
	 * We do this here to avoid having the 'user' have to define
	 * this unknown symbol.  All other parts of the .H files use
	 * __HIGHC__ as the conditional expression.
	 */
	#ifndef	PROT386
		#define	PROT386
	#endif
#endif
#if	defined(PROT386)
	/*
	 * We just want 32 bits we can play with.  The assumption is that
	 * any compiler that is used to build the PROT386 version of the
	 * library has 32-bit ints.
	 */
	typedef	unsigned int exptr;
#else
	typedef unsigned long exptr;		/* FAR Pointer */
#endif

/*
	The following are from the old TYPES.H.  Should we require old apps
	to change? Or include them here?
 */
#ifndef	NOBYTE
typedef unsigned char	byte;		/* MSDOS version of byte */
typedef unsigned short	word;		/* MSDOS version of word */
#endif
typedef unsigned long	dword;		/* MSDOS version of double word */
/*
 */

#endif	/* PWTYPES_H */










