/*  *********************************************************************
    *  PATHWORKS Socket Library						*
    *  									*
    *  OSI socket definitions			File: OSI.H		*
    *									*
    *  Compile using Microsoft C, version 6.00				*
    *********************************************************************
    *  Copyright (c) 1985-1992, All Rights Reserved			*
    *  Digital Equipment Corporation, Littleton, MA.			*
    *  									*
    *  This software is furnished under a license and may be used and	*
    *  copied only in accordance with the terms of such license and	*
    *  with the inclusion of the above copyright notice.  This 		*
    *  software or any other copies thereof may not be provided or 	*
    *  otherwise made available to any other person.  No title to	*
    *  or ownership of the software is hereby transferred.		*
    *  									*
    *  The information in this software is subject to change without	*
    *  notice and should not be constured as a commitment by 		*
    *  Digital Equipment Corporation.					*
    *  									*
    *  Digital assumes no responsiblity for the use or reliability	*
    *  of its software on equipment which is not supplied by Digital.	*
    ********************************************************************* */


#ifndef OSI_H
#define OSI_H

#define OSIPROTO_COTS		   1	/* OSI Connection Oriented Transport */
#define OSIPROTO_CLNS		   2	/* OSI Network Services */
#define	OSIPROTO_NS	OSIPROTO_CLNS	/* ... */
#define	OSIPROTO_CONS	OSIPROTO_CLNS	/* ... */
#define OSIPROTO_NSDBG		   4	/* Network service debug protocol */
#define OSIPROTO_DNASESSION	   9	/* DNA Session Control */
#define OSIPROTO_NSP		  10	/* DNA NSP */
#define OSIPROTO_CLTS		8602	/* OSI Connection-Less Transport */


/* Socket Levels - use protocol number for level (for get/setsockopt) */

/* 
 * Transport level options (setsockopt/getsockopt)
 */
#define TOPT_OPTCONDATA	1	/* optional connect data */
#define TOPT_OPTDISDATA	2	/* optional disconnect data */
#define TOPT_ACCEPTMODE	3	/* when to accept connect (see modes below) */
#define TOPT_ACCEPT	4	/* accept connect (for defered accept mode */
#define TOPT_REJECT	5	/* reject connect (for defered accept mode */
#define TOPT_LINKINFO	6	/* link status information */
#define TOPT_SECURITY	7	/* security option octet string  */
#define TOPT_CONOPTS	8	/* negotiated option in connect (see below) */
#define TOPT_TEMPLATE	9	/* ascii name of transport template to use */
#define TOPT_AUTODISCONNECT 10	/* boolean, request autodisconnect */
#define	TOPT_DISREASON	16	/* disconnect reason code */
#define TOPT_XTICONOPTS	11	/* negotiated option in connect (see below) */
#define TOPT_XTINEGQOS	12	/* xti negotiate QOS state */
#define TOPT_XTIDFLTQOS	13	/* xti default QOS state */
#define TOPT_XTICHKQOS	14	/* xti check QOS state */
#define TOPT_XTISYNC	15	/* sync state */

/*
 * Flags for OSI Transport negotiated options (TOPT_CONNOPT)
 */
#define OSINEG_CLASS0	0x001	/* TC operates on class 0 */
#define OSINEG_CLASS1	0x002	/* TC operates on class 1 */
#define OSINEG_CLASS2	0x004	/* TC operates on class 2 */
#define OSINEG_CLASS3	0x008	/* TC operates on class 3 */
#define OSINEG_CLASS4	0x010	/* TC operates on class 4 */
#define OSINEG_TP2NFC	0x020	/* non-use flow control on class 2 */
#define OSINEG_EXP	0x040	/* use transport expedited data */
#define OSINEG_CHECK	0x080	/* use checksums */
#define OSINEG_EXTEND	0x100	/* extended format in use (getsockopt only) */
#define OSINEG_DNA	0x200	/* peer is DNA implementor (getsockopt only) */

/* Accept modes for OSIPROTO_COTS and OSIPROTO_DNASESSION */
#define ACCEPTMODE_IMMEDIATE    0       /* accept connect when dequeued */
#define ACCEPTMODE_DEFERED      1       /* only dequeue, don't accept connect */
#define ACCEPTMODE_ARRIVAL      2       /* accept connect when queued */

/*
 * Definitions relating to the OSI socket interface
 */
#define OSI_NLEN        20      /* Max length of an NSAP */
#define OSI_TLEN        32      /* Max length of a TSAP-ID (T-Selector) */
#define OSI_SLEN	64	/* Max length of SSAP */

#define PLEN		10		/* Max length of NS-provider address */
#define NLEN		OSI_NLEN	/* Max length of NSAP */
#define TLEN		OSI_TLEN	/* Max length of TSAP */
#define SLEN		OSI_SLEN	/* Max length of SSAP */

/*
 * Network services access point (nsap) format
 * Note that this field is only valid for Internet addressing.
 */
struct nsap {
    unsigned char nsap_length;		/* length of nsap address */
    unsigned char nsap_addr[OSI_NLEN];	/* nsap address */
};

/*
 * Transport service access point (tsap) format
 */
struct tsap {
    unsigned char tsap_length;		/* length of tsap address */
    unsigned char tsap_addr[OSI_TLEN];	/* tsap address */
};

struct tsapid {
    unsigned char tsapid_length;	/* length of tsap-id address */
    unsigned char tsapid_id[OSI_TLEN];	/* tsap-id */
};

/*
 * OSI transport socket address format
 */
struct sockaddr_osi {
    unsigned short osi_family;     /* Address Family (AF_OSI) */
    unsigned short osi_length;     /* Length of variable portion of address */
    short	   osi_proto;	   /* Readonly protocol type of socket */
    unsigned short osi_nlayers;	   /* Number of encoded protocol layers */
    unsigned long  reserved[8];
};

/* Architected Protocol Identifier octet strings */
#define PROTOID_DNASESSIONV2	0x02
#define PROTOID_DNASESSIONV3	0x03
#define PROTOID_NSP		0x04
#define PROTOID_COTS		0x05
#define PROTOID_OSINETWORK	0x06
#define PROTOID_CLNS		PROTOID_OSINETWORK
#define PROTOID_CONS		PROTOID_OSINETWORK
#define PROTOID_CLTS		0xee	/*XXX Temp until assigned real value */
#define PROTOID_CMIPMICE	01, 19


#endif
