/*
 * Library NMAPI, Module NM_ERR.H
 *
 * Copyright (C) 1993 All Rights Reserved, by
 * Digital Equipment Corporation, Maynard, Mass.
 *
 * IDENT HISTORY:
 *
 *  19-Aug-1992 CLB     Create templates for local management files.
 *  11-jun-1993 CLB     NME_NOMSG
 */

#ifndef NM_ERR_H
#define NM_ERR_H

/******************************/
/* NMAPI specific error codes */
/******************************/

#define NME_NOFILE      1000        /* Unable to open file */
#define NME_NOMATCH     1001        /* No match on search */
#define NME_NOWRITE     1002        /* Unable to write to file */
#define NME_NONAME      1003        /* Must supply name */
#define NME_UNSXPORT    1004        /* Unsupported network transport */
#define NME_UNSENT      1005        /* Unsupported entity */
#define NME_DNPFAIL     1006        /* Call to DNP failed */
#define NME_BADVER      1007        /* Incorrect version */
#define NME_NOREAD      1008        /* Unable to read file */
#define NME_NOATTR      1009        /* No such attribute */
#define NME_READONLY    1010        /* Item is read-only */
#define NME_TOOLONG     1011        /* Item is too long */
#define NME_BOOTONLY    1012        /* Item is boot only */
#define NME_NOADDR      1013        /* Must supply address */
#define NME_NOID        1014        /* Must supply node name or address */
#define NME_NOEVENT     1015        /* No more DECnet events */
#define NME_FILEOPEN    1016        /* File already open, cannot use for RW */
#define NME_SMALLBUF    1017        /* User buffer too small */
#define NME_UNSXENT     1018        /* Entity unsupported by transport */
#define NME_NOMSG       1019        /* Unable to access NM_MSG.BIN */
#define NME_INVNADDR    1020        // Invalid node address 
#define NME_NOINPUT     1021        // Missing input parameters
#define NME_INVNNAME    1022        // Invalid node name

#endif  /* NM_ERR_H */
