/*  *********************************************************************
    *  PATHWORKS Socket Library						*
    *  									*
    *  TCP/IP specific IOCB definitions		File: IOCB_IN.H		*
    *									*
    *********************************************************************
    *  Copyright (c) 1985-1995, All Rights Reserved			*
    *  Digital Equipment Corporation, Littleton, MA.			*
    *  									*
    *  This software is furnished under a license and may be used and	*
    *  copied only in accordance with the terms of such license and	*
    *  with the inclusion of the above copyright notice.  This 		*
    *  software or any other copies thereof may not be provided or 	*
    *  otherwise made available to any other person.  No title to	*
    *  or ownership of the software is hereby transferred.		*
    *  									*
    *  The information in this software is subject to change without	*
    *  notice and should not be constured as a commitment by 		*
    *  Digital Equipment Corporation.					*
    *  									*
    *  Digital assumes no responsiblity for the use or reliability	*
    *  of its software on equipment which is not supplied by Digital.	*
    ********************************************************************* */

#ifndef IOCB_IN_H
    #define IOCB_IN_H

typedef struct localinfo_in {
	unsigned char  lin_version[3];
	unsigned char  lin_ipaddr[4];
	unsigned char  lin_str_sockets;
	unsigned char  lin_dg_sockets;
	unsigned char  lin_raw_sockets;
	unsigned short lin_max_segsize;
	unsigned char  lin_subnet_mask[4];
	unsigned short lin_buflen;
	exptr          lin_buf;			/* hostname/netfiles/username */
	unsigned char  lin_reserved[2];
} LOCALINFO_IN;

#define pin_family	plist.io_tfbufd.io_si.sin_family
#define pin_port	plist.io_tfbufd.io_si.sin_port
#define pin_addr	plist.io_tfbufd.io_si.sin_addr.s_addr
#define pin_socklen	plist.io_tfbufd.sockaddr_len

typedef struct tfbuffer_in {
	exptr		io_buffer;	/* pointer to user buffer */
	unsigned short  io_buflen;	/* length of user buffer */
	struct sockaddr_in io_si;	/* address info fields */
	unsigned short sockaddr_len;	/* length of the sockaddr structure */
} TFBUFFER_IN;

#endif	/* IOCB_IN_H */
