/*  *********************************************************************
    *  PATHWORKS Socket Library						*
    *  									*
    *  DNR IOCB structure               File: DNRIOCB.H                 *
    *									*
    *********************************************************************
    *  Copyright (c) 1985-1995, All Rights Reserved			*
    *  Digital Equipment Corporation, Littleton, MA.			*
    *  									*
    *  This software is furnished under a license and may be used and	*
    *  copied only in accordance with the terms of such license and	*
    *  with the inclusion of the above copyright notice.  This 		*
    *  software or any other copies thereof may not be provided or 	*
    *  otherwise made available to any other person.  No title to	*
    *  or ownership of the software is hereby transferred.		*
    *  									*
    *  The information in this software is subject to change without	*
    *  notice and should not be constured as a commitment by 		*
    *  Digital Equipment Corporation.					*
    *  									*
    *  Digital assumes no responsiblity for the use or reliability	*
    *  of its software on equipment which is not supplied by Digital.	*
    ********************************************************************* */

#ifndef DNRIOCB_H
    #define DNRIOCB_H

typedef struct dnriocb {
	unsigned short command;		// command code
	unsigned short struclen;	// length of this structure
	unsigned short status;		// return status code
	unsigned short flags;		// reserved, must be 0
	char FAR *inputbuf;		// input buffer pointer
	unsigned short inputlen;	// input buffer length
	char FAR *outputbuf;		// output buffer
	unsigned short outputlen;	// output buffer length
	unsigned short nservers;	// number of name servers (get/set)
	unsigned short type;		// type of query
	unsigned short class;		// class of query
	unsigned long  ipaddr;		// an IP Address of name (for search/query)
	unsigned short h_errno;		// FUTURE: value of h_errno
	unsigned short ncalls;		// DEBUG: number of calls
	} DNRIOCB;

typedef DNRIOCB FAR *FPDNRIOCB;

#endif /* DNRIOCB_H */

