pragma Off(List);

#if ! _stdio_defs_included	/* Needed due to typedef defn's here. */
#define BUFSIZ	  (512)
#define BUFSIZE   (BUFSIZ)
#define EOF	  (-1)
#define NULL	  ((void *)0)
#define size_t	  unsigned int
#define OPEN_MAX  (25)	  /* Maximum number of open files */

/* Elements of the File_flags set:	*/
#define _BUFFERED	(0x01)
#define _READING	(0x02)
#define _WRITING	(0x04)
#define _APPENDING	(0x08)
#define _END_OF_FILE	(0x10)
#define _ERROR		(0x20)
#define _FORMATTED_TEXT (0x40)
#define _UNINITIALIZED	(0x80)
#define _SETBUF_BUFFER	(0x100)
#define _TEMP_FILE	(0x200)
#define _CTRL_Z 	(0x400)
#define _WROTE_LAST	(0x800)
typedef short int File_flags;
/* type  File_flags = set of
   (Buffered, Reading, Writing, Appending, End_of_file,
    Error, Formatted_text, Uninitialized, Setbuf_buffer, Temp_file);
*/
typedef unsigned char File_handle;
typedef char Buffer[BUFSIZ];

typedef struct {
      char * _ptr;		 /* Pointer to current byte in buffer */
      int _cnt; 		 /* Bytes remaining in buffer */
      Buffer *_base;		 /* Address of buffer */
      File_flags _flag;
      File_handle _fd;		 /* Associated file handle */
      char Padding;		 /* Round out to even # bytes. */
      int _nextline;
      } _iobuf;

typedef _iobuf FILE;

extern _iobuf _iob[OPEN_MAX];

#define stdin	(&_iob[0])
#define stdout	(&_iob[1])
#define stderr	(&_iob[2])

#define L_tmpnam (10)	 /* length of file name string generated by tmpnam */
#define TMP_MAX  (1000)  /* min number of unique names generated by tmpnam */

#define SEEK_SET (0)	 /*From_beginning*/
#define SEEK_CUR (1)	 /*From_current*/
#define SEEK_END (2)	 /*From_end*/

extern int remove(const char *pathname);
extern int rename(const char *old, char *new);
extern FILE *tmpfile(void);
extern char *tmpnam(char *s);
extern int fclose(FILE *stream);
extern int fflush(FILE *stream);
extern FILE *fopen(const char *pathname, const char *type);
extern FILE *freopen(const char *pathname, const char *type, FILE *stream);
extern void setbuf(FILE *stream, char *buf);
extern int fread(void *ptr, size_t size, int nelem, FILE *stream);
extern int fwrite(const void *ptr, size_t size, int nelem, FILE *stream);
extern int fgetc(FILE *stream);

#undef getc
extern int getc(FILE *stream);

#define getc(F) ( ((F)->_cnt > 0) &&		 \
		 ( *(F)->_ptr != '\r' || !((F)->_flag & _FORMATTED_TEXT) ) \
		 ?    (F)->_cnt--, *(F)->_ptr++  \
		 :    fgetc(F)			 \
		)
#undef getchar
extern int getchar(void);
#define getchar() (getc(stdin))
extern char *gets(char *s);
extern char *fgets(char *s, int N, FILE *stream);
extern int fputs(const char *s, FILE *stream);
extern int fputc(int c, FILE *stream);

#undef putc
extern int putc(int c, FILE *stream);

#define putc(c,F) ( ((F)->_cnt > 0)  \
		   ?	(F)->_cnt--, *(F)->_ptr++ = (c) 		       \
		   :	fputc(c,F) \
		  )

#undef putchar
extern int putchar(int c);
#define putchar(c) (putc(c, stdout))
extern int puts(const char *s);
extern int ungetc(int c, FILE *stream);
extern int fseek(FILE *stream, long offset, int ptrname);
extern long ftell(FILE *stream);
extern void rewind(FILE *stream);

#undef clearerr
extern void clearerr(FILE *stream);
/* clear _ERROR and _END_OF_FILE */
#define clearerr(stream) ((stream)->_flag &= ~(_ERROR | _END_OF_FILE))

#undef feof
extern int feof(FILE *stream);
#define feof(stream) ((stream)->_flag & _END_OF_FILE)

#undef ferror
extern int ferror(FILE *stream);
#define ferror(stream) ((stream)->_flag & _ERROR)

extern char *perror(const char *s);

#include <stdarg.h>
extern int vprintf(const char *format, va_list arg);
extern int vfprintf(FILE *stream, const char *format, va_list arg);
extern int vsprintf(char *s, const char *format, va_list arg);
extern int printf(const char *format, ...);
extern int fprintf(FILE *stream, const char *format, ...);
extern int sprintf(char *s, const char *format, ...);
extern int fscanf(FILE *stream, const char *format, ...);
extern int scanf(const char *format, ...);
extern int sscanf(char *s, const char *format, ...);

extern void _setmode(FILE *stream, int mode);
/* values for _setmode's mode argument */
#define _TEXT	  (0)	  /* _setmode(F,_TEXT) makes F a text file */
#define _BINARY   (1)	  /* _setmode(F,_BINARY) makes F a binary file */
/* used to set _fmode */
#define _USER_FILES_BINARY	 (1)
#define _STDIN_AND_STDOUT_BINARY (2)
#define _STDERR_BINARY		 (4)
#define _ALL_FILES_BINARY	 \
	     (_USER_FILES_BINARY | _STDIN_AND_STDOUT_BINARY | _STDERR_BINARY)
#define _ALL_FILES_TEXT 	 (~_ALL_FILES_BINARY)
#define _USER_FILES_TEXT	 (_fmode & ~_USER_FILES_BINARY)
#define _STDIN_AND_STDOUT_TEXT	 (_fmode & ~_STDIN_AND_STDOUT_BINARY)
#define _STDERR_TEXT		 (_fmode & ~_STDERR_BINARY)
#define _stdio_defs_included 1
#endif

pragma Pop(List);
