;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: WpTab.asm                                                           *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:  Editor tab formats                                          *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 11/21/89 120E/01 T. Ball      / Modified idParDirDates                    *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT TECHNOLOGIES INC. ALL RIGHTS RESERVED *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;

; WpTab.asm -- configures the tab arrays used for different paragraph formats.
;
; Log:
;    -- 12.0 --
;        01/25/88  TAB  Created.
;

$include(WpMsg.mdf)
$include(WpTab.mdf)


DGroup group Const
assume ds: DGroup

public rgTabs

Const segment byte public 'Const'
rgTabs label word
Const ends


; DefineTabs(id, <tabs>) using the paragraph id as defined WpMsg.mdf, and a
; variable list of tab settings, defined as (x position, tab type),
; with tab type being either tabLeft or tabRight.
;
; Notes:
;   tabRight values of maxScreen are replaced with the current screen width,
;   idParDefault is included but initialized separately
;   the id order must match the order in WpMsg.asm, starting with idParDefault
;

%DefineTabs(idParDefault,<MaxScreen,tabRight>)

%DefineTabs(idParTitle,<MaxScreen,tabRight>)

%DefineTabs(idParBlank,<MaxScreen,tabRight>)

%DefineTabs(idParChoice,<MaxScreen,tabRight>)

%DefineTabs(idParNoise,<MaxScreen,tabRight>)

%DefineTabs(idParPswd,<MaxScreen,tabRight>)

%DefineTabs(idParHelp,<19,tabLeft, 34,tabLeft>)

%DefineTabs(idParMsg,<MaxScreen,tabRight>)

%DefineTabs(idParDspBlank,<48,tabLeft, MaxScreen,tabRight>)

%DefineTabs(idParDirNames,<2,tabLeft, 28,tabLeft, 54,tabLeft>)

%DefineTabs(idParDirDates,<39,tabRight, 48,tabRight, 58,tabRight, 68,tabRight, 79,tabRight>)

%DefineTabs(idParDirOpens,<68,tabRight, 80,tabRight>)

%DefineTabs(idParPlace,<MaxScreen,tabRight>)

%DefineTabs(idParMenuHelp,<4,tabLeft>)

%DefineTabs(idParKbdHelp,<12,tabLeft, 29,tabLeft, 46,tabLeft, 63,tabLeft>)

end