/****************************** INCLUDE HEADER (.H)***************************/
/*                                                                           */
/* INCLUDE FILE: Async.h                                                     */
/*                                                                           */
/* MACHINE: B20        LANGUAGE: METAWARE C V1.0  OS: BTOS                   */
/*                                                                           */
/* DESCRIPTION: Header file for Async.Lib procedures.                        */
/*                                                                           */
/*                                                                           */
/* HISTORY:                                                                  */
/*                                                                           */
/* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) */
/*                                                                           */
/* 12/03/89 120E/02 S. Emmons    / Removed headers for example functions.    */
/* 12/02/89 120E/01 S. Emmons    / Changed C typing to CTOS Typing.          */
/*                                                                           */
/* TITLE:  BTOS SYSTEM SOFTWARE                                              */
/*                                                                           */
/*            PROPRIETARY PROGRAM MATERIAL                                   */
/*                                                                           */
/* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       */
/* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   */
/* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            */
/* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                */
/*                                                                           */
/*                                                                           */
/* COPYRIGHT (C) 1980, 1989 CONVERGENT INCORPROATED. ALL RIGHTS RESERVED     */
/* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          */
/* ************************************************************************* */
/*                                                                           */
/* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      */
/* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      */
/* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        */
/* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   */
/* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         */
/* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 */
/*                                                                           */
/* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      */
/* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        */
/* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           */
/*                                                                           */
/*                                                                           */
/*************************** END OF MODULE HEADER ****************************/
pragma Off(List);
#c_include <ctosTypes.h>
pragma Calling_convention(CTOS_CALLING_CONVENTIONS);

#if defined(AllocMemoryInit) || defined(All)
#undef AllocMemoryInit
extern ErcType AllocMemoryInit (Word cb, Pointer ppMemoryRet, FlagType fInit);
#endif

#if defined(AsyncRequest) || defined(All)
#undef AsyncRequest
extern ErcType AsyncRequest (Pointer pRq);
#endif

#if defined(AsyncRequestDirect) || defined(All)
#undef AsyncRequestDirect
extern ErcType AsyncRequestDirect (Pointer pRq);
#endif

#if defined(BuildAsyncRequest) || defined(All)
#undef BuildAsyncRequest
extern ErcType BuildAsyncRequest ();
#endif

#if defined(BuildAsyncRequestDirect) || defined(All)
#undef BuildAsyncRequestDirect
extern ErcType BuildAsyncRequestDirect ();
#endif

#if defined(CheckContextStack) || defined(All)
#undef CheckContextStack
extern ErcType CheckContextStack (void);
#endif

#if defined(CreateContext) || defined(All)
#undef CreateContext
extern ErcType CreateContext (Word sStack, Word userNum);
#endif

#if defined(DebugTrap) || defined(All)
#undef DebugTrap
extern void DebugTrap (void);
#endif

#if defined(HeapAlloc) || defined(All)
#undef HeapAlloc
extern ErcType HeapAlloc (Word cBytes, Pointer ppMemoryRet);
#endif

#if defined(HeapFree) || defined(All)
#undef HeapFree
extern ErcType HeapFree (Pointer pbFree);
#endif

#if defined(HeapInit) || defined(All)
#undef HeapInit
extern ErcType HeapInit (Word cb, Pointer pbHeap);
#endif

#if defined(LogMsgIn) || defined(All)
#undef LogMsgIn
extern ErcType LogMsgIn (void);
#endif

#if defined(LogRequest) || defined(All)
#undef LogRequest
extern ErcType LogRequest (Pointer pRq);
#endif

#if defined(LogRespond) || defined(All)
#undef LogRespond
extern ErcType LogRespond (RqHeaderType *pRq);
#endif

#if defined(ResumeContext) || defined(All)
#undef ResumeContext
extern ErcType ResumeContext (void);
#endif

#if defined(SwapContextUser) || defined(All)
#undef SwapContextUser
extern ErcType SwapContextUser (Word userNum);
#endif

#if defined(TerminateAllOtherContexts) || defined(All)
#undef TerminateAllOtherContexts
extern ErcType TerminateAllOtherContexts (Word erc);
#endif

#if defined(TerminateContext) || defined(All)
#undef TerminateContext
extern ErcType TerminateContext (void);
#endif

#if defined(TerminateContextUser) || defined(All)
#undef TerminateContextUser
extern ErcType TerminateContextUser (Word userNum, Word erc);
#endif

#undef All
pragma Calling_convention();
pragma Pop(List);
