/*
 * Convergent Technologies
 *
 * FILE: stub.h
 *
 * Mar 12, 1986  MEC  Created
 *
 * This file defines stubs for certain C/CTOS runtime functions.
 * The presence of the stubs satisfies external references to these
 * procedures, avoiding the overhead of linking in the real ones.
 *
 * Instead of stubbing out the entire run time, you can stub out
 * only part of it; there are two independent pieces here.
 * For instance, if you wish to use Standard I/O but don't need
 * argc and argv, leave the getargc()/getargv() stubs and delete
 * the dx_exit stub.
 */

#ifndef __stub
#define	__stub

/* Argc, argv support */
int	getargc() { return(0); }
char *	getargv() { return((char *) 0); }

/* Stdio cleanup */
int	dx_exit() { }

#endif
