/* #include "xvt3.h" */
#include "xvt.h"
#include "xvtmenu.h"				/* standard XVT menu tags */
 
#undef M_FILE_OPEN
#undef M_FILE_ABOUT
#undef M_FILE_QUIT
#define M_FILE_NEW_TEXT	MAKE_MENU_TAG(MENU1, 2)
#define M_FILE_OPEN		MAKE_MENU_TAG(MENU1, 3)
#define M_FILE_OPEN_TST	MAKE_MENU_TAG(MENU1, 4)
#define M_FILE_ABOUT	MAKE_MENU_TAG(MENU1, 6)
#define M_FILE_QUIT		MAKE_MENU_TAG(MENU1, 8)
#define M_EDIT_ATTRIB	MAKE_MENU_TAG(MENU2, 8)
#define M_EDIT_DESTROY	MAKE_MENU_TAG(MENU2, 9)

#undef STATICFCN
#define STATICFCN
 
/*
	Following two menus do not necessarily follow style guidelines.
*/
STATICFCN MENU_ITEM file_menu[] = {
	{M_FILE_NEW,			"New Window",		'n', TRUE},
	{M_FILE_NEW_TEXT,		"New Text Window",	't', TRUE},
	{M_FILE_OPEN, 			"Open...",			'o'},
	{M_FILE_OPEN_TST, 		"Open Test...",		'p'},
#if (XVTOS != CTOOS)
	{MAKE_MENU_TAG(MENU1, 5),NULL,				0,	 FALSE, FALSE, FALSE, TRUE},
	{M_FILE_ABOUT,			"About...",			'b', TRUE},
#endif
	{MAKE_MENU_TAG(MENU1, 7),NULL,				0,	 FALSE, FALSE, FALSE, TRUE},
	{M_FILE_QUIT,			"Quit",				'q', TRUE},
	{0}
};
 
STATICFCN MENU_ITEM edit_menu[] = {
	{M_EDIT_UNDO,			"Undo",				'u', FALSE},
	{MAKE_MENU_TAG(MENU2, 2),NULL,				0,	 FALSE, FALSE, FALSE, TRUE},
	{M_EDIT_CUT,			"Cut",				't', FALSE, FALSE, FALSE, FALSE, NULL
#ifdef MAC /* support Mac accelerators only */
		, 'X'
#endif
	},
	{M_EDIT_COPY,			"Copy",				'c', FALSE, FALSE, FALSE, FALSE, NULL
#ifdef MAC
		, 'C'
#endif
	},
	{M_EDIT_PASTE,			"Paste",			'p', FALSE, FALSE, FALSE, FALSE, NULL
#ifdef MAC
		, 'V'
#endif
	},
	{M_EDIT_CLEAR,			"Clear",			'l'},
	{MAKE_MENU_TAG(MENU2, 7),NULL,				0,	 FALSE, FALSE, FALSE, TRUE},
	{M_EDIT_ATTRIB,			"Attributes...",	'a', TRUE},
	{M_EDIT_DESTROY,		"Destroy",	'd'},
	{0}
};
 
#define RID_ATTRIB		100
#define CID_READONLY	4
#define CID_WRAP		5
#define CID_AUTOVSCROLL	6
#define CID_AUTOHSCROLL	7
#define CID_BORDER		8
#define CID_VSCROLLBAR	9
#define CID_HSCROLLBAR	10
#define CID_ONEPAR		11
#define CID_COPY		12
#define CID_CUT			13
#define CID_PASTE		14
#define CID_MARGIN		16
#define CID_LIMIT		18
 
typedef struct {
	BOOLEAN full_text;
	PNT origin, 					/* window upper left corner */
	    range;						/* window width, height */
	TXEDIT txedit;					/* TXEDIT if full_text */
} WINDOW_INFO;
 
#define MAX_TX 25					/* max number of TXEDIT objects */
struct {
	TXEDIT txedit;					/* descriptor from tx_create */
									/* room for more members if needed */
} near tx[MAX_TX];
int active_txi = BAD_TXEDIT;	/* index in tx of active TXEDIT */
RCT active_move_rect;		/* rect area for moving active TXEDIT */
RCT active_size_rect;		/* rect area for resizing active TXEDIT */
WINDOW active_win;			/* window containing active_txi */
int window_num = 1;			/* window number */

int fFoo = 0;
 
#define PAGE_WIDTH	2000			/* width of page in pixels */
#define PAGE_HEIGHT	4000			/* height of page in pixels */
#define PAGE_INCR	25				/* "line" increment for scrolling */
#define FULL_OFFSET	4				/* view offset for full-text window */
#if XVTWS == WMWS
#define AREA_SIZE 8
#else
#define AREA_SIZE	6				/* size of move and size areas */
#endif
 
APPL_SETUP appl_setup = {
	0,								/* menu bar resource ID (use default) */
	0,								/* about box resource ID (use default) */
	"XVTtx",						/* application's name */
	W_DOC,							/* type of initial window */
	TRUE,							/* size box on initial window? */
	TRUE,							/* vert. scroll bar on initial window? */
	TRUE,							/* horz. scroll bar on initial window? */
	TRUE,							/* close box on initial window? */
	TRUE,							/* want std. font menu? (includes sizes) */
	TRUE							/* want std. style menu? */
};
 
unsigned default_attrib = TX_BORDER | TX_WRAP | TX_AUTOHSCROLL | TX_AUTOVSCROLL;
int default_margin = 0;
int default_limit = 0;
FONT near default_font;
 
#define MIN_SIZE	20				/* min. size for TXEDIT */
#if XVTWS == WMWS
#define MIN_MOVE	8				/* min. distance for moves */
#else
#define MIN_MOVE	4				/* min. distance for moves */
#endif
 
#ifdef PROTO
STATICFCN void build_menus(void);
STATICFCN void normalized_rect(RCT *, PNT, PNT);
STATICFCN void show_selection(void);
STATICFCN void activat(int, WINDOW);
STATICFCN void deactivate(void);
STATICFCN void set_controls(unsigned, int, int);
STATICFCN void flip_attrib(unsigned *, unsigned);
STATICFCN BOOLEAN XVTENTRY cb_attrib(int, CONTROL_INFO *);
STATICFCN void attrib_dialog(void);
STATICFCN void create_txedit(WINDOW, PNT, PNT, BOOLEAN);
STATICFCN void move_txedit(WINDOW, int, PNT, PNT);
STATICFCN void rubber_rect(WINDOW, PNT, PNT);
STATICFCN void shift_views(WINDOW, int, int);
STATICFCN void autoscroll(WINDOW, EVENT *, PNT *);
STATICFCN BOOLEAN do_drag(WINDOW, EVENT *);
STATICFCN void do_update(WINDOW);
STATICFCN void do_file_open(TXEDIT tx);
STATICFCN void do_file_open_test(TXEDIT tx);
STATICFCN void XVTENTRY do_menu(MENU_TAG);
STATICFCN int lines_in_view(TXEDIT tx);
STATICFCN void scroll(WINDOW, EVENT *);
STATICFCN void set_scroll_range_and_pos(TXEDIT tx, BOOLEAN set_range,
  BOOLEAN set_pos);
STATICFCN void XVTENTRY scroll_callback(TXEDIT tx, T_LNUM org_lines, T_LNUM nlines,
  T_CPOS org_offset);
STATICFCN void do_vscroll(WINDOW win, SCROLL_CONTROL what, short pos);
STATICFCN void do_hscroll(WINDOW win, SCROLL_CONTROL what, short pos);
STATICFCN void scroll_sync(WINDOW win);
STATICFCN void inflate_rect(RCT *rctp, int n);
#else
STATICFCN void build_menus();
STATICFCN void normalized_rect();
STATICFCN void show_selection();
STATICFCN void activat();
STATICFCN void deactivate();
STATICFCN void set_controls();
STATICFCN void flip_attrib();
STATICFCN BOOLEAN XVTENTRY cb_attrib();
STATICFCN void attrib_dialog();
STATICFCN void create_txedit();
STATICFCN void move_txedit();
STATICFCN void rubber_rect();
STATICFCN void shift_views();
STATICFCN void autoscroll();
STATICFCN BOOLEAN do_drag();
STATICFCN void do_update();
STATICFCN void do_file_open();
STATICFCN void do_file_open_test();
STATICFCN void XVTENTRY do_menu();
STATICFCN int lines_in_view();
STATICFCN void scroll();
STATICFCN void set_scroll_range_and_pos();
STATICFCN void XVTENTRY scroll_callback();
STATICFCN void do_vscroll();
STATICFCN void do_hscroll();
STATICFCN void scroll_sync();
#endif
STATICFCN void 
#ifdef FPROTO
inflate_rect(RCT *rctp, int n)
#else
inflate_rect(rctp, n)
RCT *rctp;
int n;
#endif
{
	rctp->top -= n;
	rctp->bottom += n;
	rctp->left -= n;
	rctp->right += n;
}
 
STATICFCN void 
build_menus()
{
	MENU_ITEM *bar;
 
	if ((bar = menu_fetch((WINDOW)NULL)) == NULL)
		fatal("Can't fetch menu bar");
	if (bar[0].tag != 0) {
		menu_free(bar[0].child);
		bar[0].child = file_menu;
		if (bar[1].tag != 0) {
			menu_free(bar[1].child);
			bar[1].child = edit_menu;
		}
	}
	menu_show((WINDOW)NULL, bar);
	if (bar[0].tag != 0) {
		bar[0].child = NULL; /* so menu_free won't free it */
		if (bar[1].tag != 0)
			bar[1].child = NULL;
	}
	menu_free(bar);
}
 
STATICFCN void 
scroll_sync(win)
WINDOW win;
{
	WINDOW_INFO *window_info;
	RCT rct;
 
	get_client_rect(win, &rct);
	window_info = (WINDOW_INFO *)get_app_data(win);
	set_scroll_range(win, HSCROLL, 0, 
		window_info->range.h = PAGE_WIDTH - rct.right);
	set_scroll_range(win, VSCROLL, 0, 
		window_info->range.v = PAGE_HEIGHT - rct.bottom);
	set_scroll_pos(win, HSCROLL, window_info->origin.h);
	set_scroll_pos(win, VSCROLL, window_info->origin.v);
}
 
BOOLEAN XVTENTRY
appl_init()
{
	WINDOW_INFO *window_info;
	int i;
 
	build_menus();
	if (sizeof(PNT) != sizeof(long))
		fatal("Can't store origin as window's app data.");
	for (i = 0; i < MAX_TX; i++)
		tx[i].txedit = BAD_TXEDIT;
	default_font = small_font;
	set_font_menu(&default_font);
	menu_enable(M_FILE_NEW, TRUE);
	set_title(std_win, "Window 1");
	window_info = (WINDOW_INFO *)xvt_malloc(sizeof(WINDOW_INFO));
	window_info->full_text = FALSE;
	window_info->origin.h = window_info->origin.v = 0;
	set_app_data(std_win, PTR_LONG(window_info));
	scroll_sync(std_win); /* calls set_appl_data() */
	note("To begin, drag out a rectangular Text Edit area with the mouse.");
	return(TRUE);
}
 
STATICFCN void 
#ifdef FPROTO
normalized_rect(RCT *rctp, PNT p1, PNT p2)
#else
normalized_rect(rctp, p1, p2)
RCT *rctp;
PNT p1, p2;
#endif
{
	set_rect(rctp, min(p1.h, p2.h), min(p1.v, p2.v),
	  max(p1.h, p2.h), max(p1.v, p2.v));
}
 
STATICFCN void 
#ifdef FPROTO
show_selection(void)
#else
show_selection()
#endif
{
	DRAW_CTOOLS save_tools, tools;
	WINDOW win;
 
	if (active_txi != BAD_TXEDIT && (win = get_cur_window()) != NULL_WIN &&
	  !((WINDOW_INFO *)get_app_data(win))->full_text) {
		get_draw_ctools(&save_tools);
		tools = save_tools;
		tools.brush.color = COLOR_BLACK;
		tools.pen = hollow_cpen;
		set_draw_ctools(&tools);
		draw_rect(&active_move_rect);
		draw_rect(&active_size_rect);
		set_draw_ctools(&save_tools);
	}
}
 
STATICFCN void 
#ifdef FPROTO
activat(int txi, WINDOW win)
#else
activat(txi, win)
int txi;
WINDOW win;
#endif
{
	RCT rct;
	FONT font;
 
	active_txi = BAD_TXEDIT;
	if (active_win != NULL_WIN)
		update_window(active_win);
	rct = tx_get_border(tx[txi].txedit);
	active_txi = txi;
	active_win = win;
	set_cur_window(win);
	set_rect(&active_move_rect, rct.left, rct.top - AREA_SIZE,
	  rct.right, rct.top);
	set_rect(&active_size_rect, rct.right - AREA_SIZE / 2,
	  rct.bottom - AREA_SIZE / 2, rct.right + AREA_SIZE / 2,
	  rct.bottom + AREA_SIZE / 2);
	show_selection();
	font = tx_get_font(tx[active_txi].txedit);
	set_font_menu(&font);
	menu_enable(M_EDIT_DESTROY, TRUE);
	menu_enable(M_FILE_OPEN, TRUE);
	menu_enable(M_FILE_OPEN_TST, TRUE);
}
 
STATICFCN void 
#ifdef FPROTO
deactivate(void)
#else
deactivate()
#endif
{
	RCT rect;
	if (active_txi != BAD_TXEDIT) {
		active_txi = BAD_TXEDIT;
		rect = active_move_rect;
		inflate_rect(&rect, 1);
		invalidate_rect(active_win, &rect);
		rect = active_size_rect;
		inflate_rect(&rect, 1);
		invalidate_rect(active_win, &rect);
		active_win = NULL_WIN;
		menu_enable(M_EDIT_DESTROY, FALSE);
		menu_enable(M_FILE_OPEN, FALSE);
		menu_enable(M_FILE_OPEN_TST, FALSE);
	}
}
 
STATICFCN void 
#ifdef FPROTO
set_controls(unsigned attrib, int margin, int limit)
#else
set_controls(attrib, margin, limit)
unsigned attrib;
int margin, limit;
#endif
{
#ifdef applec
#pragma unused(margin, limit)
#endif
	NOREF(margin);
	NOREF(limit);
	check_box(CID_READONLY, attrib & TX_READONLY);
	check_box(CID_WRAP, attrib & TX_WRAP);
	check_box(CID_AUTOVSCROLL, attrib & TX_AUTOVSCROLL);
	check_box(CID_AUTOHSCROLL, attrib & TX_AUTOHSCROLL);
	check_box(CID_BORDER, attrib & TX_BORDER);
	check_box(CID_VSCROLLBAR, attrib & TX_VSCROLLBAR);
	check_box(CID_HSCROLLBAR, attrib & TX_HSCROLLBAR);
	check_box(CID_ONEPAR, attrib & TX_ONEPAR);
	check_box(CID_COPY, !(attrib & TX_NOCOPY));
	check_box(CID_CUT, !(attrib & TX_NOCUT));
	check_box(CID_PASTE, !(attrib & TX_NOPASTE));
}
 
STATICFCN void 
#ifdef FPROTO
flip_attrib(unsigned *attribp, unsigned a)
#else
flip_attrib(attribp, a)
unsigned *attribp;
unsigned a;
#endif
{
	if (*attribp & a)
		*attribp &= ~a;
	else
		*attribp |= a;
}
 
STATICFCN BOOLEAN XVTENTRY
#ifdef FPROTO
cb_attrib(int cid, CONTROL_INFO *cip)
#else
cb_attrib(cid, cip)
int cid;
CONTROL_INFO *cip;
#endif
{
	static unsigned attrib;
	static int margin, limit;
	char buf[50];
	TXEDIT txi;
	WINDOW win;
 
	NOREF(cip);
	switch (cid) {
	case DLG_INIT:
		enable_item(CID_VSCROLLBAR, FALSE);
		enable_item(CID_HSCROLLBAR, FALSE);
		if (active_txi == BAD_TXEDIT) {
			attrib = default_attrib;
			margin = default_margin;
			limit = default_limit;
		}
		else {
			attrib = tx_get_attrib(tx[active_txi].txedit);
			margin = tx_get_margin(tx[active_txi].txedit);
			limit = tx_get_limit(tx[active_txi].txedit);
		}
		sprintf(buf, "%d", margin);
		set_item_text(CID_MARGIN, buf);
		sprintf(buf, "%d", limit);
		set_item_text(CID_LIMIT, buf);
		break;
	case DLG_OK:
		margin = atoi(get_item_text(CID_MARGIN, buf));
		if (margin != 0 && margin < 10) {
			error("Margin must be 10 or more (or 0).");
			select_item_text(CID_MARGIN, 0, INT_MAX);
			return(TRUE);
		}
		limit = atoi(get_item_text(CID_LIMIT, buf));
		if (limit != 0 && limit < 10) {
			error("Limit must be 10 or more (or zero).");
			select_item_text(CID_LIMIT, 0, INT_MAX);
			return(TRUE);
		}
		if (active_txi == BAD_TXEDIT) {
			default_attrib = attrib;
			default_margin = margin;
			default_limit = limit;
		}
		else {
			win = active_win;
			txi = active_txi;
			deactivate();
			if (attrib != tx_get_attrib(tx[txi].txedit))
				tx_set_attrib(tx[txi].txedit, attrib);
			if (margin != tx_get_margin(tx[txi].txedit))
				tx_set_margin(tx[txi].txedit, margin);
			if (limit != tx_get_limit(tx[txi].txedit))
				tx_set_limit(tx[txi].txedit, limit);
			activat(txi, win);
		}
		return(FALSE);
	case DLG_CANCEL:
		return(FALSE);
	case CID_READONLY:
		flip_attrib(&attrib, TX_READONLY);
		break;
	case CID_WRAP:
		flip_attrib(&attrib, TX_WRAP);
		break;
	case CID_AUTOVSCROLL:
		flip_attrib(&attrib, TX_AUTOVSCROLL);
		break;
	case CID_AUTOHSCROLL:
		flip_attrib(&attrib, TX_AUTOHSCROLL);
		break;
	case CID_BORDER:
		flip_attrib(&attrib, TX_BORDER);
		break;
	case CID_VSCROLLBAR:
		flip_attrib(&attrib, TX_VSCROLLBAR);
		break;
	case CID_HSCROLLBAR:
		flip_attrib(&attrib, TX_HSCROLLBAR);
		break;
	case CID_ONEPAR:
		flip_attrib(&attrib, TX_ONEPAR);
		break;
	case CID_COPY:
		flip_attrib(&attrib, TX_NOCOPY);
		break;
	case CID_CUT:
		flip_attrib(&attrib, TX_NOCUT);
		break;
	case CID_PASTE:
		flip_attrib(&attrib, TX_NOPASTE);
		break;
	case CID_MARGIN:
	case CID_LIMIT:
		return(TRUE);
	}
	set_controls(attrib, margin, limit);
	if (cid == DLG_INIT)
		select_item_text(CID_MARGIN, 0, INT_MAX);
	return(TRUE);
}
 
STATICFCN void 
#ifdef FPROTO
attrib_dialog(void)
#else
attrib_dialog()
#endif
{
	if (!new_dialog(DLG_MODAL, RID_ATTRIB, cb_attrib, 0L))
		error("Can't show attribute dialog.");
}
 
STATICFCN void 
#ifdef FPROTO
create_txedit(WINDOW win, PNT p1,  PNT p2, BOOLEAN full)
#else
create_txedit(win, p1, p2, full)
WINDOW win;
PNT p1, p2;
BOOLEAN full;
#endif
{
	RCT client_rect, view;
	int i;
 
	get_client_rect(win, &client_rect);
	normalized_rect(&view, p1, p2);
	/* make sure there's enough space for the active move rectangle */
	if (!full && view.top < client_rect.top + AREA_SIZE)
		view.top = client_rect.top + AREA_SIZE;
	if (view.right - view.left < MIN_SIZE || view.bottom - view.top < MIN_SIZE) {
		deactivate();
		set_font_menu(&default_font);
		return; /* too small  */
	}
	for (i = 0; i < MAX_TX; i++)
		if (tx[i].txedit == BAD_TXEDIT) {
			if ((tx[i].txedit = tx_create(win, &view, default_attrib,
			  &default_font, default_margin, default_limit)) == BAD_TXEDIT)
				error("Error creating Text Edit object.");
			else {
				if (full) {
					((WINDOW_INFO *)get_app_data(win))->txedit = tx[i].txedit;
					tx_set_scroll_callback(tx[i].txedit, scroll_callback);
				}
/*				else
					switch (i % 4) {
					case 0:
						tx_set_colors(tx[i].txedit, COLOR_BLACK, COLOR_BLACK,
						  COLOR_WHITE);
						break;
					case 1:
						tx_set_colors(tx[i].txedit, COLOR_WHITE, COLOR_GREEN,
						  COLOR_BLUE);
						break;
					case 2:
						tx_set_colors(tx[i].txedit, COLOR_GREEN, COLOR_YELLOW,
						  COLOR_MAGENTA);
						break;
					case 3:
						tx_set_colors(tx[i].txedit, COLOR_WHITE, COLOR_BLACK,
						  COLOR_BLACK);
					}
*/				deactivate();
				activat(i, win);
			}
			return;
		}
	error("Maximum number of Text Edit objects already created.");
}
 
STATICFCN void 
#ifdef FPROTO
move_txedit(WINDOW win, int txi, PNT p1, PNT p2)
#else
move_txedit(win, txi, p1, p2)
WINDOW win;
int txi;
PNT p1, p2;
#endif
{
	RCT border, old_border;
	int old_margin, margin;
 
	normalized_rect(&border, p1, p2);
	old_border = tx_get_border(tx[txi].txedit);
	if (border.right - border.left < MIN_SIZE ||
	  border.bottom - border.top < MIN_SIZE ||
	  (abs(border.right - old_border.right) < MIN_MOVE &&
	  abs(border.bottom - old_border.bottom) < MIN_MOVE))
		return; /* too small */
	deactivate();
	old_margin = tx_get_margin(tx[txi].txedit);
	margin = old_margin + (border.right - border.left) -
	  (old_border.right - old_border.left);
	tx_set_border(tx[txi].txedit, &border);
	if (margin != old_margin)
		tx_set_margin(tx[txi].txedit, margin);
	else
		tx_reset(tx[txi].txedit); 
	/*
		NOTE by den ducoff: should NOT reset because this causes the
		current selected text and offset postion to be lost.
    */
	inflate_rect(&old_border, 1);
	invalidate_rect(win, &old_border);
	activat(txi, win); /* to calculate new selection area sizes */
}
 
STATICFCN void 
#ifdef FPROTO
rubber_rect(WINDOW win, PNT p1, PNT p2)
#else
rubber_rect(win, p1, p2)
WINDOW win;
PNT p1, p2;
#endif
{
	RCT rct;
	DRAW_CTOOLS save_tools, tools;
 
	set_cur_window(win);
	get_draw_ctools(&save_tools);
	tools = save_tools;
	tools.pen = rubber_cpen;
	tools.brush.pat = PAT_HOLLOW;
	tools.mode = M_XOR;
	set_draw_ctools(&tools);
	normalized_rect(&rct, p1, p2);
	draw_rect(&rct);
	set_draw_ctools(&save_tools);
}
 
STATICFCN void 
#ifdef FPROTO
shift_views(WINDOW win, int dx, int dy)
#else
shift_views(win, dx, dy)
WINDOW win;
int dx, dy;
#endif
{
	int i;
	RCT rct;
	WINDOW_INFO *window_info;
 
	window_info = (WINDOW_INFO *)get_app_data(win);
	update_window(win);
	for (i = 0; i < MAX_TX; i++)
		if (tx[i].txedit != BAD_TXEDIT && tx_get_window(tx[i].txedit) == win) {
			rct = tx_get_border(tx[i].txedit);
			offset_rect(&rct, dx, dy);
			tx_set_border(tx[i].txedit, &rct);
		}
	offset_rect(&active_move_rect, dx, dy);
	offset_rect(&active_size_rect, dx, dy);
	if (dx != 0) {
		window_info->origin.h -= dx;
		set_scroll_pos(win, HSCROLL, window_info->origin.h);
	}
	if (dy != 0) {
		window_info->origin.v -= dy;
		set_scroll_pos(win, VSCROLL, window_info->origin.v);
	}
	get_client_rect(win, &rct);
	scroll_rect(&rct, dx, dy);
}
 
STATICFCN void 
#ifdef FPROTO
autoscroll(WINDOW win, EVENT *ep, PNT *pntp)
#else
autoscroll(win, ep, pntp)
WINDOW win;
EVENT *ep;
PNT *pntp;
#endif
{
	RCT rct;
	int dx = 0, dy = 0;
	WINDOW_INFO *window_info;
 
	window_info = (WINDOW_INFO *)get_app_data(win);
	get_client_rect(win, &rct);
	if (ep->v.mouse.where.h > rct.right) {
		dx = rct.right - ep->v.mouse.where.h; /* dx negative */
	}
	else if (ep->v.mouse.where.h < rct.left) {
		dx = rct.left - ep->v.mouse.where.h; /* dx positive */
		if (window_info->origin.h - dx < 0)
			dx = 0; /* cant move left anymore */
	}
	if (ep->v.mouse.where.v > rct.bottom) {
		dy = rct.bottom - ep->v.mouse.where.v; /* dy negative */
	}
	else if (ep->v.mouse.where.v < rct.top) {
		dy = rct.top - ep->v.mouse.where.v; /* dy positive */
		if (window_info->origin.v - dy < 0)
			dy = 0; /* cant move up anymore */
	}
	if (dx != 0 || dy != 0) {
		if(fFoo)
			dbg("autoscroll.  dx: %d  dy: %d", dx, dy);
		shift_views(win, dx, dy);
		ep->v.mouse.where.h += dx;
		ep->v.mouse.where.v += dy;
		if (pntp != NULL) {
			pntp->h += dx;
			pntp->v += dy;
		}
	}
}
 
/*
	Function to handle mouse events. Takes care of moving a Text Edit object to a new
	location, and dragging out the view rectangle for a new one.
*/
STATICFCN BOOLEAN 
#ifdef FPROTO
do_drag(WINDOW win, EVENT *ep)
#else
do_drag(win, ep)
WINDOW win;
EVENT *ep;
#endif
{
	RCT rct;
	static PNT start_pnt, end_pnt, last_pnt, p;
	static TXEDIT cur = BAD_TXEDIT;
	static enum {DR_MOVE, DR_SIZE, DR_CREATE, DR_OTHER, DR_NONE} drag_type = DR_NONE;
	int i;
 
	switch (ep->type) {
	case E_MOUSE_DBL:
		if (active_txi != BAD_TXEDIT &&
		  pt_in_rect(&active_move_rect, ep->v.mouse.where)) {
			attrib_dialog();
			return(TRUE);
		}
	case E_MOUSE_DOWN:
		if (active_txi != BAD_TXEDIT) {
			if (pt_in_rect(&active_move_rect, ep->v.mouse.where))
				drag_type = DR_MOVE;
			else if (pt_in_rect(&active_size_rect, ep->v.mouse.where))
				drag_type = DR_SIZE;
		}
		if (drag_type == DR_NONE) {
			for (i = 0; i < MAX_TX; i++)
				if (tx[i].txedit != BAD_TXEDIT &&
				  win == tx_get_window(tx[i].txedit)) {
					rct = tx_get_border(tx[i].txedit);
					if (pt_in_rect(&rct, ep->v.mouse.where)) {
						if (i != active_txi) {
							deactivate();
							activat(i, win);
						}
						drag_type = DR_OTHER;
						trap_mouse(win);
						return(FALSE); /* TXEDIT module will handle it */
					}
				}
			drag_type = DR_CREATE;
			start_pnt = end_pnt = ep->v.mouse.where;
		}
		else {
			rct = tx_get_border(active_txi);
			start_pnt.h = rct.left;
			start_pnt.v = rct.top;
			end_pnt.h = rct.right;
			end_pnt.v = rct.bottom;
		}
		rubber_rect(win, start_pnt, end_pnt);
		last_pnt = ep->v.mouse.where;
		trap_mouse(win);
		break;
	case E_MOUSE_UP:
		release_mouse();
		if (drag_type == DR_NONE || drag_type == DR_OTHER) {
			drag_type = DR_NONE;
			return(FALSE);
		}
		rubber_rect(win, start_pnt, end_pnt);
		if (drag_type == DR_CREATE)
			create_txedit(win, start_pnt, end_pnt, FALSE);
		else
			move_txedit(win, active_txi, start_pnt, end_pnt);
		drag_type = DR_NONE;
		break;
	case E_MOUSE_MOVE:
		if (drag_type == DR_NONE)
			return(FALSE);
		else if (drag_type == DR_OTHER) {
			autoscroll(win, ep, NULL);
			return(FALSE);
		}
		else if( (last_pnt.h != ep->v.mouse.where.h) || 
					(last_pnt.v != ep->v.mouse.where.v)) {
			rubber_rect(win, start_pnt, end_pnt);
			p = start_pnt;
			autoscroll(win, ep, &p);
			if (drag_type == DR_MOVE) {
				if(fFoo)
					dbg("mouse x: %d, mouse y: %d", ep->v.mouse.where.h, 
						ep->v.mouse.where.v);
				start_pnt.h += ep->v.mouse.where.h - last_pnt.h;
				start_pnt.v += ep->v.mouse.where.v - last_pnt.v;
				end_pnt.h += ep->v.mouse.where.h - last_pnt.h;
				end_pnt.v += ep->v.mouse.where.v - last_pnt.v;
				if(fFoo)
					dbg("start_pnt.h:  %d   end_pnt.h: %d", start_pnt.h, end_pnt.h);
			}
			else {
				start_pnt = p; /* in case we scrolled */
				end_pnt = ep->v.mouse.where;
			}
			last_pnt = ep->v.mouse.where;
			rubber_rect(win, start_pnt, end_pnt);
			}
	}
	return(TRUE);
}
 
STATICFCN void 
#ifdef FPROTO
do_update(WINDOW win)
#else
do_update(win)
WINDOW win;								/* window to be updated */
#endif
{
	RCT rct;
	DRAW_CTOOLS tools;
 
	get_client_rect(win, &rct);
	/*if (needs_update(win, &rct))*/ {
		get_normal_ctools(&tools);
		tools.pen = hollow_cpen;
		tools.brush.color = COLOR_WHITE;
		set_draw_ctools(&tools);
		draw_rect(&rct);
	}
}
 
#ifdef FPROTO
STATICFCN void do_file_open(TXEDIT tx)
#else
STATICFCN void do_file_open(tx)
TXEDIT tx;
#endif
{
	FILE_SPEC fs;
	FILE *in;
	char s[500];
	int n;
 
	if (tx == BAD_TXEDIT)
		error("No TX object selected.");
	memset((char *)&fs, 0, sizeof(fs));
	if (open_file_dlg(&fs, "Choose file:") == FL_OK) {
		if ((in = fopen(fs.name, "r")) == NULL) {
			error("Can't open \"%s\".", fs.name);
			return;
		}
		tx_suspend(tx);
		while (fgets(s, sizeof(s), in) != NULL) {
			n = strlen(s) - 1;
			if (s[n] == '\n')
				s[n] = '\0';
			if (!tx_add_par(tx, USHRT_MAX, s)) {
				error("Error adding line.");
				break;
			}
		}
		tx_resume(tx);
		fclose(in);
	}
}
 
#ifdef FPROTO
STATICFCN void do_file_open_test(TXEDIT tx)
#else
STATICFCN void do_file_open_test(tx)
TXEDIT tx;
#endif
{
	NOREF(tx);
	note("No test yet.");
}
 
/*
	Function to handle menu commands.
*/
STATICFCN void XVTENTRY
#ifdef FPROTO
do_menu(MENU_TAG cmd)
#else
do_menu(cmd)
MENU_TAG cmd;							/* tag identifying menu item */
#endif
{
	TXEDIT txi;
	char buf[25];
	unsigned save_attrib;
	RCT rct;
	PNT p1, p2;
	WINDOW win;
	WINDOW_INFO *window_info;
 
	switch (cmd) {
	case M_FILE_OPEN:
		if ((win = get_front_window()) != NULL_WIN &&
		  (window_info = (WINDOW_INFO *)get_app_data(win)) != NULL)
			if (window_info->full_text)
				do_file_open(window_info->txedit);
			else
				do_file_open(tx[active_txi].txedit);
		break;
	case M_FILE_OPEN_TST:
		do_file_open_test(tx[active_txi].txedit);
		break;
	case M_FILE_NEW:
	case M_FILE_NEW_TEXT:
		sprintf(buf, "Window %d", ++window_num);
		/* NEW
		 */
		window_info = (WINDOW_INFO *)xvt_malloc(sizeof(WINDOW_INFO));
		if ((win = new_child_window(NULL, buf, W_DOC, TRUE, TRUE, TRUE, TRUE,
		  NULL_WIN, 0L, 0, 0L, TRUE, TRUE)) == NULL_WIN)
			error("Can't create new window.");
		if (cmd == M_FILE_NEW) {
			/* NEW
			 */
			window_info->full_text = FALSE;
			window_info->origin.h = window_info->origin.v = 0;
			set_app_data(win, PTR_LONG(window_info));
			scroll_sync(win);
			break;
		}
		window_info->full_text = TRUE;
		set_app_data(win, PTR_LONG(window_info));
		get_client_rect(win, &rct);
		p1.h = rct.left + FULL_OFFSET;
		p1.v = rct.top;
		p2.h = rct.right;
		p2.v = rct.bottom;
		save_attrib = default_attrib;
		default_attrib &= ~TX_BORDER;
		create_txedit(win, p1, p2, TRUE);
		default_attrib = save_attrib;
		break;
	case M_EDIT_ATTRIB:
		attrib_dialog();
		break;
	case M_EDIT_DESTROY:
		txi = active_txi;
		deactivate();
		tx_destroy(txi);
		tx[txi].txedit = BAD_TXEDIT;
		break;
	case M_FILE_ABOUT:
		about_box();
		break;
	case M_FILE_QUIT:
		terminate();
	}
}
 
STATICFCN int
#ifdef FPROTO
lines_in_view(TXEDIT tx)
#else
lines_in_view(tx)
TXEDIT tx;
#endif
{
	int leading, ascent, descent;
	RCT rct;
	FONT font;
 
	rct = tx_get_view(tx);
	set_cur_window(tx_get_window(tx));
	font = tx_get_font(tx);
	set_font(&font, FALSE);
	get_font_metrics(&leading, &ascent, &descent);
	return((rct.bottom - rct.top) / (leading + ascent + descent));
}
 
STATICFCN void 
#ifdef FPROTO
scroll(WINDOW win, EVENT *ep)
#else
scroll(win, ep)
WINDOW win;
EVENT *ep;
#endif
{
	int n;
	RCT rct;
	WINDOW_INFO *window_info;
 
	window_info = (WINDOW_INFO *)get_app_data(win);
	get_client_rect(win, &rct);
	switch (ep->type) {
	case E_HSCROLL:
		switch (ep->v.scroll.what) {
		case SC_LINE_UP:
			/*
			n = max(0, origin.h - PAGE_INCR);
			 */
			n = max(0, window_info->origin.h - PAGE_INCR);
			shift_views(win, window_info->origin.h - n, 0);
			break;
		case SC_LINE_DOWN:
			/*
			n = min(PAGE_WIDTH, origin.h + PAGE_INCR);
			 */
			/* avoid rightward jump */
			if (window_info->origin.h < window_info->range.h) { 
				n = min(window_info->range.h,window_info->origin.h + PAGE_INCR);
				shift_views(win, window_info->origin.h - n, 0);
			}
			break;
		case SC_PAGE_UP:
			n = max(0, window_info->origin.h - (rct.right - rct.left));
			shift_views(win, window_info->origin.h - n, 0);
			break;
		case SC_PAGE_DOWN:
			/*
			n = min(PAGE_WIDTH, origin.h + (rct.right - rct.left));
			 */
			n = min(window_info->range.h, 
				window_info->origin.h + (rct.right - rct.left));
			shift_views(win, window_info->origin.h - n, 0);
			break;
		case SC_THUMB:
			shift_views(win, window_info->origin.h - ep->v.scroll.pos, 0);
		}
		break;
	case E_VSCROLL:
		switch (ep->v.scroll.what) {
		case SC_LINE_UP:
			n = max(0, window_info->origin.v - PAGE_INCR);
			shift_views(win, 0, window_info->origin.v - n);
			break;
		case SC_LINE_DOWN:
			/*
			n = min(PAGE_HEIGHT, origin.v + PAGE_INCR);
			 */
			/* avoid downward jump */
			if (window_info->origin.v < window_info->range.v) {
				n = min(window_info->range.v, 
					window_info->origin.v + PAGE_INCR);
				shift_views(win, 0, window_info->origin.v - n);
			}
			break;
		case SC_PAGE_UP:
			n = max(0, window_info->origin.v - (rct.bottom - rct.top));
			shift_views(win, 0, window_info->origin.v - n);
			break;
		case SC_PAGE_DOWN:
			/*
			n = min(PAGE_HEIGHT, origin.v + (rct.bottom - rct.top));
			 */
			n = min(window_info->range.v, 
				window_info->origin.v + (rct.bottom - rct.top));
			shift_views(win, 0, window_info->origin.v - n);
			break;
		case SC_THUMB:
			shift_views(win, 0, window_info->origin.v - ep->v.scroll.pos);
			break;
		}
	}
}
 
STATICFCN void
#ifdef FPROTO
set_scroll_range_and_pos(TXEDIT tx, BOOLEAN set_range, BOOLEAN set_pos)
#else
set_scroll_range_and_pos(tx, set_range, set_pos)
TXEDIT tx;
BOOLEAN set_range;
BOOLEAN set_pos;
#endif
{
	int view_lines, actual_nlines, max_org_line;
	T_LNUM org_line;
	WINDOW win = tx_get_window(tx);
 
	if (set_range || set_pos) {
		view_lines = lines_in_view(tx);
		actual_nlines = (int)tx_get_num_lines(tx);
		max_org_line = max(0, actual_nlines - view_lines);
		tx_get_origin(tx, NULL, NULL, &org_line, NULL);
		if (set_range) {
			set_scroll_range(win, VSCROLL, 0, max_org_line);
			if (max_org_line == 0)
				tx_vscroll(tx, org_line);
		}
		if (set_pos || set_range) {
			set_scroll_pos(win, VSCROLL, min(org_line, max_org_line));
		}
	}
}
 
/*
	To allow vertical thumb to hit bottom of scroll bar, nlines should be
	reduced by number of lines that will fit in view.
*/
STATICFCN void XVTENTRY
#ifdef FPROTO
scroll_callback(TXEDIT tx, T_LNUM org_line, T_LNUM nlines, T_CPOS org_offset)
#else
scroll_callback(tx, org_line, nlines, org_offset)
TXEDIT tx;
T_LNUM org_line;
T_LNUM nlines;
T_CPOS org_offset;
#endif
{
  	static BOOLEAN first_setting = TRUE;
	int max_org_offset;
	RCT rct;
	WINDOW win = tx_get_window(tx);
 
	set_scroll_range_and_pos(tx, nlines != USHRT_MAX, org_line != USHRT_MAX);
	if (org_offset != USHRT_MAX) {
		get_client_rect(win, &rct);
		max_org_offset = max(0, PAGE_WIDTH - (rct.right - rct.left));
		if (first_setting) {
			first_setting = FALSE;
			set_scroll_range(win, HSCROLL, 0, max_org_offset);
		}
		set_scroll_pos(win, HSCROLL, min(org_offset, max_org_offset));
	}
}
 
#if 0
/*
	Interesting function, but not used here.
*/
STATICFCN void
#ifdef FPROTO
line_to_par(TXEDIT tx, T_LNUM abs_line, T_PNUM *parnump, T_LNUM *rel_linep)
#else
line_to_par(tx, abs_line, parnump, rel_linep)
TXEDIT tx;
T_LNUM abs_line;
T_PNUM *parnump;
T_LNUM *rel_linep;
#endif
{
	T_PNUM npars, pn;
	T_LNUM accum_lines, par_lines;
 
	npars = tx_get_num_pars(tx);
	for (pn = 0, accum_lines = 0; pn < npars; pn++) {
		par_lines = tx_get_num_par_lines(tx, pn);
		if (accum_lines + par_lines > abs_line) {
			if (parnump != NULL)
				*parnump = pn;
			if (rel_linep != NULL)
				*rel_linep = abs_line - accum_lines;
			return;
		}
		accum_lines += par_lines;
	}
	fatal("line_to_par got lost");
}
#endif
 
STATICFCN void 
#ifdef FPROTO
do_vscroll(WINDOW win, SCROLL_CONTROL what, short pos)
#else
do_vscroll(win, what, pos)
WINDOW win;
SCROLL_CONTROL what;
short pos;
#endif
{
	WINDOW_INFO *wi;
	T_LNUM org_line;
 
	if (win == NULL_WIN || (wi = (WINDOW_INFO *)get_app_data(win)) == NULL ||
	  wi->txedit == BAD_TXEDIT)
		return;
	switch (what) {
	case SC_LINE_UP:
		tx_vscroll(wi->txedit, 1);
		break;
	case SC_LINE_DOWN:
		tx_vscroll(wi->txedit, -1);
		break;
	case SC_PAGE_UP:
		tx_vscroll(wi->txedit, lines_in_view(wi->txedit));
		break;
	case SC_PAGE_DOWN:
		tx_vscroll(wi->txedit, -lines_in_view(wi->txedit));
		break;
	case SC_THUMB:
		tx_get_origin(wi->txedit, NULL, NULL, &org_line, NULL);
		tx_vscroll(wi->txedit, (int)org_line - pos);
	}
}
 
STATICFCN void 
#ifdef FPROTO
do_hscroll(WINDOW win, SCROLL_CONTROL what, short pos)
#else
do_hscroll(win, what, pos)
WINDOW win;
SCROLL_CONTROL what;
short pos;
#endif
{
	WINDOW_INFO *wi;
	T_CPOS org_offset;
 
	if (win == NULL_WIN || (wi = (WINDOW_INFO *)get_app_data(win)) == NULL ||
	  wi->txedit == BAD_TXEDIT)
		return;
	switch (what) {
	case SC_LINE_UP:
		tx_hscroll(wi->txedit, 10);
		break;
	case SC_LINE_DOWN:
		tx_hscroll(wi->txedit, -10);
		break;
	case SC_PAGE_UP:
		tx_hscroll(wi->txedit, 100);
		break;
	case SC_PAGE_DOWN:
		tx_hscroll(wi->txedit, -100);
		break;
	case SC_THUMB:
		tx_get_origin(wi->txedit, NULL, NULL, NULL, &org_offset);
		tx_hscroll(wi->txedit, (int)org_offset - pos);
	}
}
 
void XVTENTRY
main_event(win, ep)
WINDOW win;								/* window receiving event, if any */
EVENT *ep;								/* pointer to event structure */
{
	RCT old_border, rct, view, view2;
	int txi, start_txi;
	BOOLEAN full_text = FALSE;
	WINDOW w;
	TXEDIT txedit;
	WINDOW_INFO *wi;
 
	if (win == NULL_WIN)
		win = get_front_window();
	if (win != NULL_WIN && (wi = (WINDOW_INFO *)get_app_data(win)) != NULL)
		full_text = wi->full_text;
	set_cur_window(win);
	switch (ep->type) {
	case E_MOUSE_DBL:
	case E_MOUSE_DOWN:
	case E_MOUSE_UP:
	case E_MOUSE_MOVE:
		if (!full_text && do_drag(win, ep))
			return;
		break;
	case E_VSCROLL:
		if (full_text)
			do_vscroll(win, ep->v.scroll.what, ep->v.scroll.pos);
		else
			scroll(win, ep);
		break;
	case E_HSCROLL:
		if (full_text)
			do_hscroll(win, ep->v.scroll.what, ep->v.scroll.pos);
		else
			scroll(win, ep);
		break;
	case E_CHAR:
		if (ep->v.chr.ch == '\t') {
			if ((txedit = tx_get_active()) == BAD_TXEDIT)
				start_txi = 0;
			else {
				for (txi = 0; txi < MAX_TX; txi++)
					if (tx[txi].txedit == txedit)
						break;
				if (txi >= MAX_TX)
					break;
				start_txi = txi + 1;
			}
			for (txi = start_txi; txi < MAX_TX; txi++)
				if (tx[txi].txedit != BAD_TXEDIT)
					break;
			if (txi >= MAX_TX)
				for (txi = 0; txi < MAX_TX; txi++)
					if (tx[txi].txedit != BAD_TXEDIT)
						break;
			if (txi >= MAX_TX)
				break;
			w = tx_get_window(txi);
			if (w == get_front_window()) { /* otherwise E_ACTIVATE will do it */
				deactivate();
				activat(txi, w);
			}
			tx_set_active(txi);
			return; /* Text Edit doesn't get tab */
		}
		break;
	case E_ACTIVATE:
		if (ep->v.active) {
			if (full_text) {
				menu_enable(M_FILE_OPEN, TRUE);
				menu_enable(M_FILE_OPEN_TST, TRUE);
			}
			else if ((txedit = tx_get_active()) != BAD_TXEDIT &&
			  tx_get_window(txedit) == win)
				for (txi = 0; txi < MAX_TX; txi++)
					if (tx[txi].txedit == txedit) {
						activat(txi, win);
						break;
					}
		}
		else
			deactivate();
		break;
	case E_COMMAND:
		do_menu(ep->v.cmd.tag);
		break;
	case E_FONT:
		if (active_txi == BAD_TXEDIT && !full_text)
			default_font = ep->v.font.font;
		else {
			if (full_text) {
				invalidate_rect(win, NULL);
				tx_set_font(wi->txedit, &ep->v.font.font);
			} else {
				txi = active_txi;
				deactivate(); /* view rect might change */
				old_border = tx_get_border(tx[txi].txedit);
				inflate_rect(&old_border, 1);
				invalidate_rect(win, &old_border);
				tx_set_font(tx[txi].txedit, &ep->v.font.font);
				activat(txi, win);
			}
		}
		set_font_menu(&ep->v.font.font);
		break;
	case E_UPDATE:
/*		if (!tx_scroll_update()) */
			do_update(win);
		break;
	case E_CLOSE:
		deactivate();
		close_window(win);
		break;
	case E_SIZE:
		if (full_text) {
			get_client_rect(win, &rct);
			rct.left += FULL_OFFSET;
			view = tx_get_view(wi->txedit);
			tx_set_border(wi->txedit, &rct);
			view2 = tx_get_view(wi->txedit);
			rct.top = min(view.bottom, view2.bottom);
			if (rct.top < rct.bottom)
				invalidate_rect(win, &rct);
			set_scroll_range_and_pos(wi->txedit, TRUE, TRUE);
		}
		break;
	case E_KILL_WINDOW:
		for (txi = 0; txi < MAX_TX; txi++)
			if (tx[txi].txedit != BAD_TXEDIT && tx_get_window(tx[txi].txedit) == win)
				tx[txi].txedit = BAD_TXEDIT;
		break;
	case E_QUIT:
		if (ep->v.query)
			quit_OK();
		else
			terminate();
	}
	(void)tx_event(win, ep);
	if (ep->type == E_UPDATE && win == active_win &&
	  (needs_update(win, &active_move_rect) ||
	  needs_update(win, &active_size_rect)))
		show_selection();
}
 
/*
	Function called by XVT just before terminating application.
*/
void XVTENTRY
appl_cleanup()
{
}
