/*
	This is a merged header that should work on XVT/Mac, XVT/Win, XVT/PM,
	XVT/CH, and XVT/XM. It hasn't been tested with XVT/XOL or XVT/X.

	Don't make any changes to this file. Instead, request changes from Marc.

	Change History
	3-25-91		First merge.
	3-28-91		Added "|| (XVTCC == ZORCC)" to #if preceding typedef for
				CALLBACK, as required by TN-102.
*/
#ifndef INCL_XVTH
#define INCL_XVTH

#ifdef __cplusplus					
#define NO_INCLUDES				
#endif								

/* $Revision:   1.3  $ $Date:   28 xxx 1991 11:44:00  $ */
#define XVT_VER "2.0" /* Release 2.0 */
/*---------------------------------------------------------------------------
	Interface file for XVT applications

	WARNING: Do not use anything here that isn't documented in the XVT
	Programmer's Manual.

	Copyright 1987-1991 Advanced Programming Institute Ltd. All rights reserved.
---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
	Three constants must be defined on the command line to the compiler to 
	indicate which Operating System, Window System and Compiler you are 
	building the application for (except for THINK C where there is 
	no way to set them, so they are defaulted here). The constnts are derived
	automatically for three other environments; see below.
	
	From these constants we derive other macros (including MAC, WIN, MPW and
	LSC for compatibility with XVT 1.2 code). Supported OSs, window systems 
	and compilers (and the associated macro values) are listed below. The list
	will be extended as XVT moves to other environments. 
	
	Exactly one of the following OS variables must be defined (preferably
	by -DOSxxx on the compiler command line):
		  
		OSMAC - Macintosh (default for THINK C)
		OSOS2 - OS/2
		OSDOS - MS-DOS
		OSSV0 - UNIX System V
		OSBSD - Berkeley UNIX
		OSXNX - XENIX
		OSCTO - CTOS
		OSVMS - VMS
		
	Exactly one of the following window-system variables must be defined 
	(preferably by -DWSxxx on the compiler command line):
		  
		WSMAC - Macintosh (default for THINK C)
		WSWIN - Microsoft Windows
		WSPM  - Presentation Manager
		WSWM  - XVT's Character based Window Manager
		WSX11 - X Windows version 11
		WSXOL - X Windows with AT&T's Open Look Toolkit
		WSDWT - X Windows with DecWindows Toolkit
		WSMTF - X Windows with OSF's Motif Toolkit
		
	Exactly one of the following compiler variables must be defined 
	(preferably by -DCCxxx on the compiler command line):
		   
		CCMPW3 - Apple's MPW 3.0 on Macintosh (MPW 2 is not supported)
		CCLSC  - THINK C on the Macintosh (default for THINK C)
		CCMSC  - Microsoft C (under either PM, Windows or character based DOS)
		CCUNIX - Common (non-ANSI) UNIX compilers
		CCGNU  - GNU's UNIX C Compiler
		CCUANSI- Newer UNIX (ANSI compatible) compiler
		CCZOR  - Zortech C compiler
		CCMWC  - Metaware C compiler
		CCTCC  - Turbo C compiler
		CCBTC  - Btos C compiler (a Borland product)
		CCAIXV3 - RS6000 C compiler
		CCSABER - Saber C compiler
		
	Inside of application code you should test the constants XVTOS, XVTWS, 
	or XVTCC if you need to handle operating system, window system or
	compiler dependencies.
	
	XVTOS can be tested for:
		MACOS
		OS2OS
		DOSOS
		SV0OS
		BSDOS
		XENOS
		CTOOS
		VMSOS

	XVTWS can be tested for:
		MACWS
		WINWS
		PMWS
		WMWS
		X11WS
		XOLWS
		DWTWS
		MTFWS

	XVTCC can be tested for:
		MPW3CC
		LSCCC
		MSCCC
		UNIXCC
		GNUCC
		UANSICC
		ZORCC
		MWCCC
		TCCCC
		BTCCC

As a convenience, for these environments the three required constants are
set automatically:

	Environment			OSxxx		WSxxx		CCxxx
	-----------			-----		-----		-----
	THINKC				OSMAC		WSMAC		CCLSC
	MPW C 3.0			OSMAC		WSMAC		CCMPW3
	DOS & Windows		OSDOS		WSWIN		CCMSC
	OS/2 & PM			OSOS2		WSPM		CCMSC

For Microsoft C under DOS or OS/2, it is assumed that the target environment
is OS/2 & PM when the -G2 (use 80286 instructions) compiler option is in
effect, and DOS & Windows when -G0 (the default) is in effect.
---------------------------------------------------------------------------*/

#ifndef OSMAC
#ifndef OSOS2
#ifndef OSDOS
#ifndef OSSV0
#ifndef OSBSD
#ifndef OSXNX
#ifdef applec		/* set automatically by MPW C 3.0 */
#define OSMAC
#define WSMAC
#define CCMPW3
#endif
#ifdef RC_INVOKED	/* set by RC resource script compiler */
#ifndef M_I286		/* must be set on RC command line under OS/2 */
#define M_I8086		/* assumed--no RC command line definitions under DOS */
#endif
#endif
#if defined(M_I286) && !defined(OSCTO)		/* set automatically by Microsoft C when -G2 is specified */
#define OSOS2
#define WSPM
#define CCMSC
#endif
#if defined(M_I8086) && !defined(OSCTO)		/* set automatically by Microsoft C when -G0 is specified */
#define OSDOS
#define WSWIN
#define CCMSC
#endif
/* if none of the preceding cases apply, THINKC will be assumed */
#endif
#endif
#endif
#endif
#endif
#endif
		
#define MACOS	1
#define OS2OS	2
#define DOSOS	3
#define SV0OS	4
#define BSDOS	5
#define XENOS	6
#define CTOOS	7
#define VMSOS	8

#define MACWS	30
#define WINWS	31
#define PMWS	32
#define WMWS	33
#define X11WS	34
#define XOLWS	35
#define DWTWS	36
#define MTFWS	37

#define MPW3CC	60
#define LSCCC	61
#define MSCCC	62
#define UNIXCC	63
#define GNUCC	64
#define UANSICC	65
#define ZORCC   66
#define MWCCC	67
#define TCCCC	68
#define BTCCC	69
#define AIXV3CC 70
#define SABERCC 71

/*
	When THINK C learns to understand "#if defined" and "#error" then we can 
	clean this up. (THINK C 4.0 does indeed understand "#if defined".)
*/
#ifdef OSMAC
#define XVTOS MACOS
#else
#ifdef OSOS2
#define XVTOS OS2OS
#else
#ifdef OSDOS
#define XVTOS DOSOS
#else
#ifdef OSSV0
#define XVTOS SV0OS
#else
#ifdef OSBSD
#define XVTOS BSDOS
#else
#ifdef OSXNX
#define XVTOS XENOS
#else
#ifdef OSCTO
#define XVTOS CTOOS
#else
#ifdef OSVMS
#define XVTOS VMSOS
#else
#define XVTOS MACOS
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif

#ifdef WSMAC
#define XVTWS MACWS
#else
#ifdef WSWIN
#define XVTWS WINWS
#else
#ifdef WSPM
#define XVTWS PMWS
#else
#ifdef WSWM
#define XVTWS WMWS
#else
#ifdef WSX11
#define XVTWS X11WS
#else
#ifdef WSXOL
#define XVTWS XOLWS
#else
#ifdef WSDWT
#define XVTWS DWTWS
#else
#ifdef WSMTF
#define XVTWS MTFWS
#else
#define XVTWS MACWS
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif

#ifdef CCLSC
#define XVTCC LSCCC
#else
#ifdef CCMPW3
#define XVTCC MPW3CC
#else
#ifdef CCMSC
#define XVTCC MSCCC
#else
#ifdef CCUNIX
#define XVTCC UNIXCC
#else
#ifdef CCAIXV3
#define XVTCC AIXV3CC
#else
#ifdef CCSABER
#define XVTCC SABERCC
#else
#ifdef CCGNU
#define XVTCC GNUCC
#else
#ifdef CCUANSI
#define XVTCC UANSICC
#else
#ifdef CCZOR
#define XVTCC ZORCC
#else
#ifdef CCMWC
#define XVTCC MWCCC
#else
#ifdef CCTCC
#define XVTCC TCCCC
#else
#ifdef CCBTC
#define XVTCC BTCCC
#else
#define XVTCC LSCCC
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif
#endif

/* At this point XVTOS, XVTWS and XVTCC should all be set. */

#undef MAC
#undef MPW
#undef LSC
#undef WIN
#undef UNIX
#undef DVX
#undef VMS

/* Derive MAC, WIN, LSC, MPW, UNIX, VMS */

#if XVTOS == MACOS
#if XVTWS == MACWS
#if XVTCC == MPW3CC
#define MPW
#else /* XVTCC == MPW3CC */
#if XVTCC == LSCCC
#define LSC
#else /* XVTCC == LSCCC */
#include "Unsupported_MAC_Compiler"
#endif /* XVTCC == LSCCC */
#endif /* XVTCC == MPW3CC */
#else /* not Mac WS */
#include "Mac_OS_requires_Mac_WS"
#endif
#define MAC
#endif

#if XVTOS == DOSOS
#if XVTWS == WINWS
#define WIN
#else /* XVTWS == WINWS */
#if XVTWS == X11WS
#define DVX
#else
#if XVTWS != WMWS
#include "Unknown_DOS_Window_System"
#endif /* XVTWS != WMWS */
#endif /* XVTWS == WINWS */
#endif /* XVTWS == X11WS */
#if XVTCC != MSCCC && XVTCC != ZORCC && XVTCC != TCCCC
#include "Unknown_DOS_Compiler"
#endif
#endif

#if XVTOS == OS2OS
#if XVTWS == PMWS
#if XVTCC != MSCCC
#include "OS2/PM_Requires_Microsoft_C"
#endif
#else
#if XVTWS != WMWS
#include "OS2_Requires_PM_or_Character_WM"
#endif
#endif
#endif

#if XVTOS == VMSOS
#define VMS
#endif

#if XVTOS == CTOOS
#define SHELP
#if (XVTCC != MWCCC) && (XVTCC != BTCCC) && (XVTCC != MSCCC)
#include "CTOS_Requires_MetaWareC_or_BtosC_or_MicroSoftC"
#endif
#if (XVTWS != PMWS) && (XVTWS != WMWS)
#include "CTOS_Requires_PM_or_Character_WM"
#endif
#endif

#if (XVTOS == SV0OS) || (XVTOS == BSDOS) || (XVTOS == XENOS)
#define UNIX
#endif

#ifdef RC_INVOKED
#define WIN
#endif

/*
	THINK C 4.0 defines NULL as (void *)0, which disallows assignment to scalar
	variables (e.g., WINDOW). We therefore define it as 0L ourselves, which is
	what it was with THINK C 3.0.
*/
#ifdef THINK_C
#undef NULL
#define NULL 0L
#endif

/* Include common headers here. */

#ifndef NO_INCLUDES
#include <ctype.h>
#endif

/* Include compiler-specific headers here. */

/* Define PROTO, ELLIPSIS, NC_ELLIPSIS, STD_ARGS, STATICFCN, NOREF
   if appropriate.
*/

#ifdef THINK_C
#ifndef NO_INCLUDES
#include <MacTypes.h>		/* here because FALSE and TRUE redefined by stdio.h */
#include <unix.h>			/* because gread and gwrite need read and write protos */
#endif
#endif

#if (XVTCC == MPW3CC) || defined(THINK_C)
#ifndef NO_INCLUDES
#include <stdio.h>			/* try to be equivalent to what proto.h does */
#include <string.h>			/* " */
#include <stdlib.h>
#include <fcntl.h>
#include <stdarg.h>
#endif
#define PROTO 1
#define ELLIPSIS 1
#define STD_ARGS 1
#define STATICFCN
#define NOREF(a) a
#endif

/* C++ users using other names for external linkage may need to
 * change some of these defines:
 */												
#ifdef __cplusplus								
#define CXX_C_ITEM			extern "C"			
#define CXX_C_BEGIN			extern "C" {		
#define CXX_C_END			}					
#define CXX_PASCAL_ITEM		extern "PASCAL"		
#define CXX_PASCAL_BEGIN	extern "PASCAL" {	
#define CXX_PASCAL_END		}					
#else
#define CXX_C_ITEM								
#define CXX_C_BEGIN							
#define CXX_C_END								
#define CXX_PASCAL_ITEM						
#define CXX_PASCAL_BEGIN						
#define CXX_PASCAL_END							
#endif

#if (XVTCC == MSCCC) && (XVTOS == CTOOS)
#define FPROTO	1
#ifndef __cplusplus
#define CDECL cdecl
#define XVTENTRY pascal far
#else
#define CDECL
#define XVTENTRY
#endif
#else
#define CDECL
#define XVTENTRY
#endif

#if (XVTCC == BTCCC) && (XVTOS == CTOOS)
#define BTCENTRY plm far
#else
#define BTCENTRY
#endif

#if (XVTCC == MPW3CC)
#define FPROTO				/* ANSI-style function definitions */
#endif

#if (XVTCC == LSCCC) && !defined(THINK_C)
#ifndef _proto_
#define min LSC_min			/* use our macros (defined below) instead */
#define max LSC_max
#define _proto_
#ifndef NO_INCLUDES
#include <proto.h>
#include <io.h>
#endif
#undef min
#undef max
#define PROTO 1
#define ELLIPSIS 1
#define STD_ARGS 1
#define STATICFCN
#define NOREF(a)
#endif
#endif

#if XVTCC == MSCCC
#ifndef NOSTDINCL
#ifndef NO_INCLUDES
#include <stdio.h>
#include <malloc.h>
#include <memory.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <process.h>
#include <io.h>
#include <search.h>
#include <fcntl.h>
#include <stdarg.h>
#endif
#define PROTO 1
#define ELLIPSIS 1
#define STD_ARGS 1
#define STATICFCN static
#define NOREF(a) a
#endif
#endif

#if (XVTCC == AIXV3CC)
#ifndef NO_INCLUDES
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <varargs.h>
#endif
#define STATICFCN static
#define NOREF(a) a
#endif

#if (XVTCC == UNIXCC) && (XVTOS != BSDOS) && (XVTOS != VMSOS)
#ifndef NO_INCLUDES
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <varargs.h>
#endif
#define STATICFCN static
#define NOREF(a) a
#endif

#if (XVTCC == UNIXCC) && (XVTOS == BSDOS)
#ifndef NO_INCLUDES
#include <stdio.h>
#include <malloc.h>
#include <varargs.h>
#endif
#define STATICFCN static
#define NOREF(a) a
#endif

#if XVTOS == VMSOS
#ifndef NO_INCLUDES
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <varargs.h>
#endif
#define STATICFCN static
#define NOREF(a) a
#endif

#if (XVTCC == ZORCC) || (XVTCC == TCCCC)
#ifndef NO_INCLUDES
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <io.h>
#endif
#define PROTO 1
#define FPROTO 1
#define ELLIPSIS 1
#define STD_ARGS 1
#define STATICFCN static
#define NOREF(a) a = a
#endif

#if (XVTCC == MWCCC)
#define MWC_CALLING_CONVENTIONS _REVERSE_PARMS
#define CTOS_CALLING_CONVENTIONS (_FAR_CALL|_CALLEE_POPS_STACK|_DGROUP_MODEL/*|_RETURN_POINTERS_IN_ES_BX*/)
pragma Calling_convention(MWC_CALLING_CONVENTIONS);
#ifndef NO_INCLUDES
#define MWC_CALLING_CONVENTIONS _REVERSE_PARMS
#define CTOS_CALLING_CONVENTIONS (_FAR_CALL|_CALLEE_POPS_STACK|_DGROUP_MODEL/*|_RETURN_POINTERS_IN_ES_BX*/)
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#endif
#ifdef NOPLMCC
#undef CTOS_CALLING_CONVENTIONS
#define CTOS_CALLING_CONVENTIONS
#endif
pragma Calling_convention(CTOS_CALLING_CONVENTIONS);
#define PROTO 1
#define FPROTO 1
#define ELLIPSIS 1
#define STD_ARGS 1
#define STATICFCN
#define NOREF(a) (a)=(a)
#endif

#if (XVTCC == BTCCC)
#ifndef NO_INCLUDES
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#endif
#define PROTO 1
#define FPROTO 1
#define ELLIPSIS 1
#define STD_ARGS 1
#define STATICFCN static
#define NOREF(a) a = a
#endif

#if (XVTCC == SABERCC)
#if __STDC__
#define PROTO 1
#define FPROTO 1
#define ELLIPSIS 1
#endif
#define STATICFCN static
#define NOREF(a)
#ifndef assert2
#define assert2(tag, exp)	(!(exp) ? \
  fatal("Assertion failed: file %s, line %d, %s", __FILE__, __LINE__, tag) : 0)
#endif
#include <stddef.h>   /* for size_t */
#include <stdio.h>   /* for FILE */
#if __STDC__
#define STD_ARGS 1
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#endif

#if (XVTCC == GNUCC)
#define PROTO 1
#define FPROTO 1
#define ELLIPSIS 1
#define STATICFCN static
#define NOREF(a) a
#ifndef assert2
#define assert2(tag, exp)	(!(exp) ? \
  fatal("Assertion failed: file %s, line %d, %s", __FILE__, __LINE__, tag) : 0)
#endif
#include <stddef.h>   /* for size_t */
#include <stdarg.h>   /* for va_start... */
#endif

#if (XVTCC == UANSICC)
#define PROTO 1
#define FPROTO 1
#define ELLIPSIS 1
#define STATICFCN static
#define NOREF(a) a
#ifndef assert2
#define assert2(tag, exp)	(!(exp) ? \
  fatal("Assertion failed: file %s, line %d, %s", __FILE__, __LINE__, tag) : 0)
#endif
#include <stddef.h>   /* for size_t */
#include <stdarg.h>   /* for va_start... */
#endif

#ifdef __STDC__
#if __STDC__

#ifdef PROTO
#undef PROTO
#endif
#define PROTO 1

#ifdef FPROTO
#undef FPROTO
#endif
#define FPROTO 1

#ifdef ELLIPSIS
#undef ELLIPSIS
#endif
#define ELLIPSIS 1

#if (XVTCC != MWCCC)

#ifdef STATICFCN
#undef STATICFCN
#endif
#define STATICFCN static

#endif

#endif
#endif

#ifdef _lint
#undef NOREF
#define NOREF(a) a = a
#define STD_ARGS 1
#undef va_start
#define va_start(arg1, arg2) arg1 = (char *)NULL; arg1 = arg1; arg2 = arg2;
#endif

/*---------------------------------------------------------------------------
	Types internal to this header
---------------------------------------------------------------------------*/
typedef int *INTPTR, *INT_PTR;

#ifndef NULL
#define NULL 0L
#endif

/*---------------------------------------------------------------------------
	Constants for Windows resource scripts
---------------------------------------------------------------------------*/
#define MENU_BAR			9001	/* ID for MENU_BAR resource */
#define M_HELP				5376
#if (XVTWS == WINWS) || (XVTWS == PMWS)	/* only *.rc files use these */
#define FONT_BASE			5120
#define M_FONT_NORMAL		5121
#define M_FONT_BOLD			5122
#define M_FONT_ITALIC		5123
#define M_FONT_UNDER		5124
#define M_FONT_STRIKEOUT	5125
#define M_FONT_MODERN		5126
#define M_FONT_ROMAN		5127
#define M_FONT_SCRIPT		5128
#define M_FONT_COURIER		5129
#define M_FONT_HELV			5130
#define M_FONT_TIMESROMAN	5131
#define M_FONT_PROOF		5132
#define M_FONT_DRAFT		5133
#define M_FONT_6			5134
#define M_FONT_8			5135
#define M_FONT_9			5136
#define M_FONT_10			5137
#define M_FONT_12			5138
#define M_FONT_14			5139
#define M_FONT_16			5140
#define M_FONT_18			5141
#define M_FONT_20			5142
#define M_FONT_24			5143
#define M_FONT_36			5144
#define M_FONT_48			5145
#define M_FONT_54			5146
#define M_FONT_60			5147
#define M_FONT_72			5148
#define M_FONT_FIX			5149
#define M_FONT_VAR			5150
#endif

#define DB_ABOUT			9050
#define DB_ASK				9051
#define DB_ERROR			9052
#define DB_NOTE				9053
#define DB_OPEN				9054
#define DB_ABORT			9055
#define DB_SAVE				9056
#define DB_HELPTOPICS		9057
#define DB_HELPTEXT			9058
#define DB_RESPONSE			9059
#define DB_CHOICE			9060
#ifdef SHELP
#define DB_HELPMAIN			9061
#define DB_HELPHIST			9062
#define DB_HELPHYPER		9063
#define HLP_APPTOPIC		0
#define HLP_SYSTOPIC		1
#define HLP_WILDCARD		2
#define HLP_CONFIRM			4
#endif

/*
** additional dialogs for CTOS/PM
*/
#if (XVTOS == CTOOS)  
#define DB_ABOUTPM			9070
#define DB_ASKPM			9071
#define DB_ERRORPM			9072
#define DB_NOTEPM   		9073
#define DB_OPENPM			9074
#define DB_ABORTPM			9075
#define DB_SAVEPM			9076
#define DB_HELPTOPICSPM		9077
#define DB_HELPTEXTPM		9078
#define DB_RESPONSEPM		9079
#define DB_CHOICEPM			9080
#define DB_HELPMAINPM		9081
#define DB_HELPHISTPM		9082
#define DB_HELPHYPERPM		9083
#define DB_PAGESETUPPM		9084
#endif


#define STR_HELPTYPE		9101		/* string resource for help file-type */

#if (XVTWS == WINWS) || (XVTWS == PMWS)
#define STR_APPNAME			9011		/* string table constant */
#define ICON_RSRC			9012		/* icon resource */
#define ID_PATH				9081		/* control IDs */
#define ID_EDIT				9082
#define ID_LISTBOX			9083
#define ID_TITLE			9084
#endif
/*---------------------------------------------------------------------------
	Rest of header is generated mechanically from XVT Interface database.
---------------------------------------------------------------------------*/
#define COLOR_RED       0x01FF0000L
#define COLOR_GREEN     0x0200FF00L
#define COLOR_BLUE      0x030000FFL
#define COLOR_CYAN      0x0400FFFFL
#define COLOR_MAGENTA   0x05FF00FFL
#define COLOR_YELLOW    0x06FFFF00L
#define COLOR_BLACK     0x07000000L
#define COLOR_DKGRAY    0x08404040L
#define COLOR_GRAY      0x09808080L
#define COLOR_LTGRAY    0x0AC0C0C0L
#define COLOR_WHITE     0x0BFFFFFFL
#if XVTOS == CTOOS
#define NODE_TYPE "/NOD"         /* used with list_files */
#define VOL_TYPE "/VOL"          /* used with list_files */
#define OPEN_NODE_LBOX  5
#define OPEN_VOL_LBOX   6
#define OPEN_DIR_LBOX   7
#define OPEN_FILE_LBOX  8
#define OPEN_WORK_TXT   9
#define OPEN_SPEC_VAL  10
#define OPEN_NOD_TXT   11
#define OPEN_VOL_TXT   12
#define OPEN_DIR_TXT   13
#define OPEN_FIL_TXT   14
#define OPEN_SPEC_TXT  15
#define OPEN_PASS_TXT  16
#define OPEN_PASS_VAL  17
#define OPEN_PATH_TXT  18
#define OPEN_PATH_VAL  19
#define OPEN_HELP      20

/* Page Setup Dialog constants */
#define _psd_SETUP_DLG		9065
#define _psd_Pr_NAME		5
#define _psd_Pa_NAME		7
#define _psd_Pa_SIZE		8
#define _psd_COPIES			10
#define _psd_PO_PORTRAIT		12
#define _psd_PO_LANDSCAPE	13
#define _psd_PF_CONT		15
#define _psd_PF_MANUAL		16
#define _psd_Se_NO			18
#define _psd_Se_YES			19
#define _psd_PRIORITY		21
#define _psd_Md_NORMAL		23
#define _psd_Md_IMAGE		24
#define _psd_Md_BINARY		25
#define _psd_Qu_LETTER		27
#define _psd_Qu_MEMO		28
#define _psd_Qu_DRAFT		29
#define _psd_Pr_CHANGE		30
#define _psd_Pa_CHANGE		31

#define _psd_PrCHOICE_DLG	9066
#define _psd_LBOX			4

#define _psd_PaCHOICE_DLG	9067
#define _psd_Pa_PRESET1		4
#define _psd_Pa_PRESET2		5
#define _psd_Pa_PRESET3		6
#define _psd_Pa_PRESET4		7
#define _psd_Pa_OTHER		8
#define _psd_WIDTH			9
#define _psd_LENGTH			11
#define _psd_INCHES			13
#define _psd_MILLIMETERS		14
/* CTOS PM page_setup_dialog */
#define DLG_DEFAULT 		4
#define DLG_PROPERTIES 		5
#define DLG_PTRLIST	 		6
#define DLG_PTRSET	 		7
#endif
#define DIR_TYPE "/\1\2\3"      /* used with list_files */
#define DLG_INIT     0          /* dialog box initialization */
#define DLG_OK       1          /* default button was clicked */
#define DLG_YES      DLG_OK     /* synonym */
#define DLG_CANCEL   2          /* cancel button was clicked */
#define DLG_OUTLINE  3          /* ID of userItem on Mac (internal use) */
#define DLG_NO       4          /* other button was clicked */
#define DLG_PROMPT   4          /* for get_str_response dialog (internal use) */
#define DLG_RESPONSE 5          /* for get_str_response dialog (internal use) */
#ifdef SHELP
#define DLG_HIST     255        /* pushbutton for help history */
#define DLG_NEW      254        /* pushbutton for new file in help */
#endif
#define DLG_ICON     9001       /* icon in alerts (internal use) */
#define DLG_ACTIVATE 9002       /* dlg activated */
#define DLG_CLOSE    9003       /* dlg close box hit */
#define DLG_CHAR     9004       /* char typed */
#define DLG_MOVE     9005       /* moving to different control */

/* TODO Internationalization Starting String Value */
#define NLS_START   9200
#define ICON_START  9800

/* codepage constant for PM on CTOS */
#if (XVTOS == CTOOS) && (XVTWS == PMWS)
#define CODEPAGE 850
#endif

#define MAC_EOL  "\015"
#define DOS_EOL  "\015\012"
#define UNX_EOL  "\012"
#define VMS_EOL  "\012"

#if XVTOS == MACOS
#define EOL_SEQ  MAC_EOL
#endif
#if (XVTOS == DOSOS) || (XVTOS == OS2OS)
#define EOL_SEQ  DOS_EOL
#endif
#ifdef UNIX
#define EOL_SEQ  UNX_EOL
#endif
#if XVTOS == CTOOS
#define EOL_SEQ  UNX_EOL        /* same as UNIX */
#endif
#if XVTOS == VMSOS
#define EOL_SEQ VMS_EOL
#endif
#define FNUM_SYSTEM     1       /* default font for applications */
#define FNUM_FIXED      4       /* fixed-width optimized for screen */
#define FNUM_TIMES     20       /* Times Roman optimized for printer */
#define FNUM_HELVETICA 21       /* Helvetica optimized for printer */
#define FNUM_COURIER   22       /* Courier optimized for printer */
#ifndef UINT_MAX
#define UINT_MAX  (unsigned)(~0)
#define UCHAR_MAX (unsigned char)(~0)
#define USHRT_MAX (unsigned short)(~0)
#define ULONG_MAX (unsigned long)(~0)
#define INT_MAX   ((int)(UINT_MAX >> 1))
#define CHAR_MAX  ((char)(UCHAR_MAX >> 1))
#define SHRT_MAX  ((short)(USHRT_MAX >> 1))
#define LONG_MAX  ((long)(ULONG_MAX >> 1))
#endif
#define K_F1     331            /* function key 1 */
#define K_F2     332
#define K_F3     333
#define K_F4     334
#define K_F5     335
#define K_F6     336
#define K_F7     337
#define K_F8     338
#define K_F9     339
#define K_F10    340
#define K_F11    341
#define K_F12    342
#define K_F13    343
#define K_F14    344
#define K_F15    345            /* function key 15 */
#define K_UP     301            /* up arrow */
#define K_DOWN   302            /* down arrow */
#define K_RIGHT  303            /* right arrow */
#define K_LEFT   304            /* left arrow */
#define K_PREV   305            /* previous screen */
#define K_NEXT   306            /* next screen */
#define K_LHOME  307            /* line home */
#define K_LEND   308            /* line end */
#define K_HOME   309            /* home */
#define K_END    310            /* end */
#define K_INS    312            /* insert */
#define K_WLEFT  313            /* word left */
#define K_WRIGHT 314            /* word right */
#define K_BTAB   315            /* back tab */
#define K_HELP   316            /* help */
#define K_CLEAR  317            /* clear */
#define K_BOD    319            /* begin of data (internal use) */
#define K_EOD    320            /* end of data (internal use) */
#define K_BOF    321            /* begin of field (internal use) */
#define K_EOF    322            /* end of field (internal use) */
#define K_SCL_RIGHT   323            /* scroll window right (internal use) */
#define K_SCL_LEFT    324            /* scroll window left (internal use) */
#define K_DEL    127            /* delete (same as ASCII) */
#define MAX_MENUS   10
#define MENU1 256 +             /* Menu 1 */
#define MENU2 512 +
#define MENU3 768 +
#define MENU4 1024 +
#define MENU5 1280 +
#define MENU6 1536 +
#define MENU7 1792 +
#define MENU8 2048 +
#define MENU9 2304 +            /* Menu 9 */
#define NULL_WIN ((WINDOW)NULL)


#if (XVTOS == MACOS) || (XVTOS == OS2OS) || (XVTOS == DOSOS)
#define SZ_FNAME  63
#endif
#if (XVTOS == CTOOS)
#define SZ_FNAME 108
#endif
#ifdef UNIX
#define SZ_FNAME  256
#endif
#ifdef VMS
#define SZ_FNAME  256
#endif
#define TX_READONLY		0x0001		/* text is not editable */
#define TX_WRAP			0x0002		/* wrap text to margin */
#define TX_AUTOVSCROLL	0x0004		/* autoscroll vertically */
#define TX_AUTOHSCROLL	0x0008		/* autoscroll horizontally */
#define TX_BORDER		0x0010		/* rectangular border */
#define TX_VSCROLLBAR	0x0020		/* vertical scroll bar */
#define TX_HSCROLLBAR	0x0040		/* horizontal scroll bar */
#define TX_ONEPAR		0x0080		/* one paragraph only (no \r) */
#define TX_NOCOPY		0x0100		/* no copy allowed */
#define TX_NOCUT		0x0200		/* no cut allowed */
#define TX_NOPASTE		0x0400		/* no paste allowed */
#define BAD_TXEDIT -1
#if (XVTCC != MSCCC) && (XVTCC != TCCCC) && (XVTCC != ZORCC) && (XVTCC != BTCCC)
#define far
#define near
#endif
#if (XVTCC == BTCCC)
#define near
#endif

#if (XVTOS == CTOOS) && defined(__cplusplus)
#define far
#define near
#endif

#if XVTCC == BTCCC
#define FAR_PTR * far
#else
#define FAR_PTR far * 
#endif
 
#if XVTCC == LSCCC && !defined(THINK_C)
#define assert2(w, x) (!(x) ? fatal("Assertion failed: tag %s", w) : 0)
#endif
#if (XVTCC == MSCCC) || (XVTCC == UNIXCC) || (XVTCC == MPW3CC) || (XVTCC == ZORCC) || defined(THINK_C) || (XVTCC == MWCCC) || (XVTCC == TCCCC) || (XVTCC == BTCCC) || (XVTCC == AIXV3CC)
#undef assert
#define assert(exp)	(!(exp) ? \
  fatal("Assertion failed: file %s, line %d", __FILE__, __LINE__) : 0)
#define assert2(tag, exp)	(!(exp) ? \
  fatal("Assertion failed: file %s, line %d, %s", __FILE__, __LINE__, tag) : 0)
#endif

#if XVTCC == TCCCC
#define ASSERT_CAST (void)
#ifndef _EXPORT
#define _EXPORT _export
#endif

#if defined(__MEDIUM__)
#define M_I86MM 21
#else
#if defined(__LARGE__)
#define M_I86LM 21
#else
#if defined(__BORLANDC__)
#include "Unsupported_memory_model"
#endif
#endif
#endif
#else /* NOT BORLAND compiler */
#define ASSERT_CAST 
#ifndef _EXPORT
#define _EXPORT 
#endif
#endif
#define assert4(c, f, t, d) ASSERT_CAST(!(c) ? xvt_interr((unsigned int)t) : 0)

#if (XVTOS == CTOOS) && (XVTCC == MSCCC)
extern int near dbgset; /* 0 => OFF, 1 => ON, 2 => UNKNOWN */
#else
extern int near dbgset; /* 0 => OFF, 1 => ON, 2 => UNKNOWN */
#endif
#ifdef DEBUG
#define dbg2(args)  (dbgset ? dbg args : 0) /* "args" must be in parens */
#else
#define dbg2(args)
#endif

#ifdef INTERNAL
#ifdef MAC
#define GET_GRAFPTR(win) (((NPM_WIN_PTR)win)->graf_ptr)
#endif
#endif

#ifdef INTERNAL
#if (XVTWS == WINWS) || (XVTWS == PMWS)
#define GET_HDC(win) (((NPW_WIN_PTR)win)->hDC)
#endif
#endif

#ifdef INTERNAL
#if (XVTWS == WINWS) || (XVTWS == PMWS)
#define GET_HWND(win) (((NPW_WIN_PTR)win)->hWnd)
#endif
#endif

#define GET_ITEM_NUMBER(t) ((t) & 0377)

#define GET_MENU_NUMBER(t) ((t) >> 8)

#ifdef INTERNAL
#ifdef MAC
#define GET_WINDOWPTR(win) (((NPM_WIN_PTR)win)->window_ptr)
#endif
#endif

#if XVTCC == UNIXCC
#define labs(x) ((x) & LONG_MAX)
#endif

#define MAKE_COLOR(r, g, b) (((long)(r)) << 16 | (g) << 8 | (b))

#define MAKE_MENU_TAG(m, i)        (m i)

#if (XVTCC != MSCCC) && (XVTCC != TCCCC) && (XVTCC != MWCCC)
#define max(x, y) ((x) > (y) ? (x) : (y))
#endif

#if (XVTCC == MWCCC)
#define max(x, y) _max((x), (y))
#endif

#if (XVTCC != MSCCC) && (XVTCC != TCCCC) && (XVTCC != MWCCC)
#define min(x, y) ((x) < (y) ? (x) : (y))
#endif

#if (XVTCC == MWCCC)
#define min(x, y) _min((x), (y))
#endif

#define modal_dialog(cid, fcn) new_dialog(WD_MODAL, cid, (CALLBACK)fcn, 0L)


#if (XVTOS == DOSOS) || (XVTOS == OS2OS) || (XVTOS == CTOOS)
#define PTR_LONG(p) ((long)(STR_FAR)p) /* avoids compiler warning */
#else
#define PTR_LONG(p) ((long)p)
#endif

#ifndef _BOOLEAN_DEFINED
typedef short BOOLEAN;          /* Boolean type */
#define FALSE 0
#if !defined(TRUE) || (TRUE != 1)
#define TRUE  1
#endif
#define _BOOLEAN_DEFINED
#endif
typedef BOOLEAN *BOOLEAN_PTR;
typedef enum e_mode {           /* drawing (transfer) mode */
    M_COPY,                     /*   patCopy (Mac),    R2_COPYPEN (Win) */
    M_OR,                       /*   patOr,            R2_MASKPEN */
    M_XOR,                      /*   patXor,           R2_NOTXORPEN */
    M_CLEAR,                    /*   patBic,           R2_MERGENOTPEN */
    M_NOT_COPY,                 /*   notPatCopy,       R2_NOTCOPYPEN */
    M_NOT_OR,                   /*   notPatOr,         R2_MASKNOTPEN */
    M_NOT_XOR,                  /*   notPatXor,        R2_XORPEN */
    M_NOT_CLEAR                 /*   notPatBic,        R2_MERGEPEN */
} DRAW_MODE;
typedef enum e_eol {            /* terminator found by find_eol fcn */
    EOL_NORMAL,                 /* normal (or first) line terminator */
    EOL_DIFF,                   /* terminator different from previous */
    EOL_NONE                    /* end of buf before any terminator */
} EOL_FORMAT, *EOL_FORMAT_PTR;

#ifdef INTERNAL
#if XVTWS == MACWS
typedef struct s_npmdlg {       /* NewDialog args; Mac only */
    char *dStorage;             /* DialogPeek, really */
    Rect bounds;
    char *title;
    Boolean vis;
    short procID;
    WindowPtr behind;
    Boolean goAway;
    long refCon;
    Handle items;
    void (*destroy)();          /* called by XVT to free memory */
} NPM_DLG;
#endif
#endif
#ifdef INTERNAL
#if XVTWS == MACWS
typedef struct s_npmwin {       /* structure for part of WINDOW data */
    GrafPtr graf_ptr;           /* GrafPort pointer */
    WindowPtr window_ptr;       /* Window pointer (not handle!) */
    char more_stuff[1];         /* lots of secret stuff follows... */
} NPM_WIN, *NPM_WIN_PTR;
#endif
#endif

typedef enum e_access {A_LOCK, A_GET, A_UNLOCK} ACCESS_CMD;
typedef enum e_ask_resp {       /* response from ask fcn */
    RESP_DEFAULT,               /* default button */
    RESP_2,                     /* second button */
    RESP_3                      /* third button */
} ASK_RESPONSE;
/* Mac symbol and MacPaint number (see Inside Mac, I-474) are in brackets */
/* On Mac, B_DIAGCROSS and B_BDIAG are PAT# resource 301, numbers 1 and 2) */
typedef enum e_brush {          /* brush (Mac name and # in brackets) (obsolete) */
    B_HOLLOW,                   /* hollow (transparent) */
    B_WHITE,                    /* pure white [white, 20] */
    B_LTGRAY,                   /* light gray [ltGray, 23] */
    B_GRAY,                     /* gray [gray, 4] */
    B_DKGRAY,                   /* dark gray [dkGray, 3] */
    B_BLACK,                    /* pure black [black, 1] */
    B_HORZ,                     /* horizontal lines [27] */
    B_VERT,                     /* vertical lines [8] */
    B_FDIAG,                    /* SW-NE diagonal lines [28] */
    B_BDIAG,                    /* NW-SE diagonal lines */
    B_CROSS,                    /* B_HORZ and B_VERT combination [11] */
    B_DIAGCROSS,                /* B_FDIAG and B_BDIAG combination */
    B_SPECIAL                   /* start of app-defined patterns */
} BRUSH;
typedef enum e_cb {             /* standard clipboard format */
    CB_TEXT,                    /* ASCII text */
    CB_PICT,                    /* encapsulated picture */
    CB_APPL                     /* app's own type (must have name) */
} CB_FORMAT;
typedef long COLOR;
typedef short CURSOR;           /* cursor shape */
#define CURSOR_ARROW    0       /* arrow */
#define CURSOR_IBEAM    1       /* I-beam */
#define CURSOR_CROSS    2       /* cross hair */
#define CURSOR_PLUS     3       /* plus sign (fatter than cross hair) */
#define CURSOR_WAIT     4       /* waiting symbol (e.g., hourglass) */
#define CURSOR_USER     11      /* user defined shape (>= 11) */
typedef struct s_dir {         /* DIRECTORY - directory descriptor */
#if XVTOS == MACOS
    short vol;
#endif
#if (XVTOS == DOSOS) || (XVTOS == OS2OS)
    char path[SZ_FNAME + 5]; /* some slop */
#endif
#if XVTOS == CTOOS
    char path[SZ_FNAME + 1]; /* less slop */
#endif
#ifdef UNIX
    char path[SZ_FNAME + 1]; /* less slop */
#endif
#ifdef VMS
    char path[SZ_FNAME + 1]; /* less slop */
#endif
} DIRECTORY, *DIRECTORY_PTR;

typedef struct s_dspmet {       /* info about display */
    short width;                /* width in pixels */
    short height;               /* height in pixels */
    short h_res;                /* horizontal pixels per inch */
    short v_res;                /* vertical pixels per inch */
} DISPLAY_METRICS, *DISPLAY_METRICS_PTR;
#ifndef NO_EVENTS
typedef enum e_event {          /* type of event */
    E_MOUSE_DOWN,               /* mouse down */
    E_MOUSE_UP,                 /* mouse up */
    E_MOUSE_MOVE,               /* mouse movement */
    E_MOUSE_DBL,                /* mouse double click */
    E_CHAR,                     /* keyboard character */
    E_UPDATE,                   /* window update */
    E_ACTIVATE,                 /* window activation/deactivation */
    E_KILL_WINDOW,              /* window destruction (last event) */
    E_VSCROLL,                  /* vertical scroll bar activity */
    E_HSCROLL,                  /* horizontal scroll bar activity */
    E_COMMAND,                  /* menu command */
    E_CLOSE,                    /* close window */
    E_SIZE,                     /* resize window */
    E_FONT,                     /* selection from font or style menu */
    E_QUIT,                     /* request to quit application */
    E_CONTROL,                  /* control activity */
    E_USER,                     /* user-defined event */
	E_TIMER						/* timer event - not supported in XVT/CH 2.0 */
} EVENT_TYPE;
#endif
typedef enum e_file {           /* result from file open & save dialogs */
    FL_BAD,                     /* error occurred */
    FL_CANCEL,                  /* cancel button clicked */
    FL_OK                       /* OK button clicked */
} FL_STATUS;
#if (XVTWS == WINWS) || (XVTWS == PMWS)
typedef struct s_fontfam {
        unsigned int fixed: 1;
        unsigned int proof: 1;
        unsigned char chset;
        int family;
} FONT_FAMILY;
#else
#if (XVTOS == CTOOS) 
typedef union CT_FONT_FAMILY {
	struct {
        unsigned int fixed: 1;
        unsigned int proof: 1;
#if (XVTCC == MWCCC)
        unsigned int junk: 7;  /* pad to force to word size */
#endif
        unsigned char chset;
        int family;
		} pmfont;
	short chfont;            /* font number */
	} CT_FONT_FAMILY;
#define   FONT_FAMILY CT_FONT_FAMILY.chfont 
#else
typedef short FONT_FAMILY;            /* font number */
#endif
#endif

typedef enum e_font {           /* symbol for part of font desc. */
    F_STYLE,                    /* style part (bold, italic, etc.) */
    F_FAMILY,                   /* family part (Times, Helvetica, etc.) */
    F_SIZE                      /* point size part */
} FONT_PART;
#if (XVTCC == MSCCC) || (XVTCC == AIXV3CC)
#define BITFIELD_TYPE int      /* anything else generates a warning */
#else
#define BITFIELD_TYPE short    /* int would be 32 bits for MPW */
#endif

typedef struct s_fontsty {     /* font style (bold, italic, etc.) */
        unsigned BITFIELD_TYPE s_bold: 1;
        unsigned BITFIELD_TYPE s_italic: 1;
        unsigned BITFIELD_TYPE s_under: 1;
        unsigned BITFIELD_TYPE s_strikeout: 1; /* Win only */
        unsigned BITFIELD_TYPE s_outline: 1;   /* Mac only */
        unsigned BITFIELD_TYPE s_shadow: 1;    /* Mac only */
        unsigned BITFIELD_TYPE s_inverse: 1; /* WM only */
        unsigned BITFIELD_TYPE s_blink: 1;   /* WM only */
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
        unsigned BITFIELD_TYPE unused: 1;	 /* padding */
#endif
} FONT_STYLE;
typedef unsigned long GHANDLE;  /* handle to global memory block */
typedef unsigned MENU_TAG;      /* menu item tag */
/* Mac: high byte = menu ID        low byte  = item number (org. 1)
                                   Win: menu ID in resource file */
typedef enum e_pat {
    PAT_NONE,
    PAT_HOLLOW,
    PAT_SOLID,
    PAT_HORZ,
    PAT_VERT,
    PAT_FDIAG,
    PAT_BDIAG,
    PAT_CROSS,
    PAT_DIAGCROSS,
    PAT_RUBBER,
    PAT_SPECIAL
} PAT_STYLE;
typedef enum e_pen_color {      /* pen color (obsolete) */
    P_HOLLOW,                   /* hollow (transparent) */
    P_WHITE,                    /* white */
    P_BLACK,                    /* black */
    P_RUBBER                    /* rubber-band color */
} PEN_COLOR;
typedef enum e_pen_style {      /* pen style (must be P_SOLID) */
    P_SOLID,                    /* solid */
    P_DOT,                      /* dotted line (unimplemented) */
    P_DASH                      /* dashed line (unimplemented) */
} PEN_STYLE;

#ifdef MOTIF_TMP
typedef void *PICTURE;
#else
typedef long PICTURE;           /* encapsulated picture descriptor */
#endif
typedef struct s_pnt {          /* mathematical point */
    short v;                    /* vertical (y) coordinate */
    short h;                    /* horizontal (x) coordinate */
} PNT;
typedef struct s_printrcd {     /* print record (holds setup) */
    char data;
} PRINT_RCD, *PRINT_RCD_PTR;    /* structure to make type unique */

typedef struct s_rct {          /* mathematical rectangle */
    short top;                  /* top coordinate */
    short left;                 /* left coordinate */
    short bottom;               /* bottom coordinate */
    short right;                /* right coordinate */
} RCT;
typedef enum e_scroll_ctl {     /* site of scroll bar activity */
    SC_NONE,                    /* nowhere (event should be ignored) */
    SC_LINE_UP,                 /* one line up */
    SC_LINE_DOWN,               /* one line down */
    SC_PAGE_UP,                 /* previous page */
    SC_PAGE_DOWN,               /* next page */
    SC_THUMB,                   /* thumb repositioning */
    SC_THUMBTRACK               /* dynamic thumb tracking */
} SCROLL_CONTROL;
typedef enum e_scroll_type {    /* type of scroll bar */
    HSCROLL,                    /* horizontal */
    VSCROLL,                    /* vertical */
    HVSCROLL                    /* either (used for dlg box ctls) */
} SCROLL_TYPE;
typedef struct s_slist {        /* string list */
    short dummy;
} *SLIST;
typedef struct s_slistelt {     /* element of string list */
    short dummy;
} *SLIST_ELT;


#if (XVTOS == MACOS) || (XVTOS == CTOOS && XVTCC != MSCCC) /* For DOS, OS2 and UNIX, app must include types.h and stat.h */
typedef struct stat {           /* UNIX-compatible file status struct */
    /*dev_t*/  short st_dev;
    /*ino_t*/  unsigned short st_ino;
               unsigned short st_mode;
               short st_nlink;
               short st_uid;
               short st_gid;
    /*dev_t*/  short st_rdev;
    /*off_t*/  long st_size;
#if XVTOS == CTOOS
    /*time_t*/ double st_atime;
    /*time_t*/ double st_mtime;
    /*time_t*/ double st_ctime;
#else
    /*time_t*/ long st_atime;
    /*time_t*/ long st_mtime;
    /*time_t*/ long st_ctime;
#endif
} STAT, *STAT_PTR;
#if (XVTOS == CTOOS) && !defined(__cplusplus)
#ifdef PROTO
extern int XVTENTRY stat BTCENTRY(char *str, struct stat *buf);
#if (XVTCC == MWCCC)
extern int _close(int fildes);
extern int creat (char *path, int mode);
extern long lseek(int fildes, long offset, int whence);
extern int _open(char *path, int oflag);
extern int _read(int fildes, char *buf, unsigned nbyte);
extern int unlink(char* s);
extern int _write(int fildes, char *buf, unsigned nbyte);
#endif
#else /* no proto */
extern int XVTENTRY stat BTCENTRY();
#if (XVTCC == MWCCC)
extern int _close();
extern int creat ();
extern long lseek();
extern int _open();
extern int _read();
extern int unlink();
extern int _write();
#endif
#endif
#if (XVTCC == MWCCC)
#define close(a) _close(a)
#define open(a, b) _open(a, b)
#define read(a, b, c) _read(a, b, c)
#define write(a, b, c) _write(a, b, c)
#endif
#undef O_RDONLY
#undef O_WRONLY
#undef O_RDWR
#undef O_APPEND
#undef O_TRUNC
#undef O_CREAT
#undef O_EXCL
#undef O_BINARY
#define O_RDONLY	   0
#define O_WRONLY	   1
#define O_RDWR		   2
#define O_APPEND   	   4
#define O_TRUNC		   8
#define O_CREAT		0x10
#define O_EXCL		0x20
#define O_BINARY	0x40
#endif /* CTOOS */
#define S_IFDIR  0040000
#define S_IFREG  0100000
#define S_IREAD  0000400
#define S_IWRITE 0000200
#define S_IEXEC  0000100
#endif

typedef short TXEDIT; 		/* Identifies a text-edit object */
typedef unsigned short T_CNUM;
typedef unsigned short T_CPOS;
typedef unsigned short T_LNUM;
typedef unsigned short T_PNUM;
typedef long WINDOW;            /* window descriptor */
typedef enum e_win_type {	       /* type of window */
    W_DOC,                      /* document window */
    W_PLAIN,                    /* window with plain border */
    W_DBL,                      /* window with double border */
    W_PRINT,                    /* XVT internal use only */
    W_NONE,                     /* app doesn't want std_win ever */
    W_NO_BORDER,                /* no border */
    WD_MODAL,                   /* modal dialog */
    WD_MODELESS,                /* modeless dialog */
    WC_PUSHBUTTON,					         /* button control */
    WC_RADIOBUTTON,				         /* radio button control */
    WC_CHECKBOX,					           /* check box control */
    WC_HSCROLL,						           /* horizontal scroll bar control */
    WC_VSCROLL,						           /* vertical scroll bar control */
    WC_EDIT,							             /* edit control */
    WC_TEXT,						              /* static text control */
    WC_LBOX,						 	            /* list box control */
    WC_TE,								              /* text-edit control */
    WC_ICON                     /* icon control */
} WIN_TYPE;
typedef WIN_TYPE DIALOG_TYPE;
#define DLG_MODAL    WD_MODAL
#define DLG_MODELESS WD_MODELESS
#define DLG_NONE     W_NONE
typedef enum e_errno {          /* XVT error codes */
    ERR_NONE,                   /* no error or unknown error */
    ERR_NOMEM,                  /* out of memory */
    ERR_NORSRC,                 /* can't load resource */
    ERR_INVOP,                  /* invalid operation */
    ERR_BADARG,                 /* bad argument */
    ERR_IO,                     /* I/O error */
    ERR_NOTFOUND                /* file name, etc. not found */
} XVTERRNO;
typedef struct s_cbrush {
    PAT_STYLE pat;
    COLOR color;
} CBRUSH;
typedef struct s_mitem {
    MENU_TAG tag;               /* menu tag */
    char *text;                 /* text to appear in menu */
    short mkey;                 /* keyboard-operation mnemonic */
    unsigned BITFIELD_TYPE enabled: 1;   /* is item enabled? */
    unsigned BITFIELD_TYPE checked: 1;   /* is item checked? */
    unsigned BITFIELD_TYPE checkable: 1; /* can item be checked? */
    unsigned BITFIELD_TYPE separator: 1; /* is this a separator line? */
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
    unsigned BITFIELD_TYPE unused: 5;	 /* padding -- MWC Bug */
#endif
    struct s_mitem *child;      /* pointer to submenu or NULL */

#if XVTWS == WINWS
    unsigned state;
#endif
#if XVTWS == PMWS
    unsigned style;
    unsigned attribute;
#endif
#if (XVTWS == WMWS) || (XVTWS == MACWS)
    short accel;
#if (XVTOS == CTOOS)
	unsigned pad;			/* pad for compatability with PM */
#endif
#endif
#if XVTWS == MTFWS
    char *accel;      /* accelerator */
    char *acceltext;		/* accelerator text added to menu text */
#endif
} MENU_ITEM;
typedef struct s_sysmet {       /* system metrics */
    DISPLAY_METRICS dsp;        /* display metrics */
    short max_doc_width;        /* max allowed width of doc window */
    short max_doc_height;       /* max allowed height of doc window */
    RCT max_doc_client;         /* screen coordinates of max doc window */
    PNT doc_stagger;            /* offset for staggered windows */
} SYS_METRICS;
typedef char *STR;             /* NUL-terminated char string */
typedef char *DATA_PTR;        /* ptr to arbitrary data */
typedef char FAR_PTR STR_FAR;
typedef RCT *RCT_PTR;
typedef PNT *PNT_PTR;
typedef long *LONG_PTR;
typedef unsigned long *ULONG_PTR;
typedef unsigned int UINT;
typedef unsigned long ULONG;
typedef unsigned char UCHAR;

typedef struct s_applset {      /* application's setup */
    short menu_bar_ID;          /* menu bar resource ID */
    short about_box_ID;         /* about box resource ID */
    STR appl_name;            /* application's name */
    WIN_TYPE win_type;          /* type of initial window */
    BOOLEAN ctl_size;           /* size box on initial window? */
    BOOLEAN ctl_vscroll;        /* vert. scroll bar on initial window? */
    BOOLEAN ctl_hscroll;        /* horz. scroll bar on initial window? */
    BOOLEAN ctl_close;          /* close box on initial window? */
    BOOLEAN font_menu;          /* want std. font menu (incl. sizes)? */
    BOOLEAN style_menu;         /* want std. style menu? */
} APPL_SETUP;
typedef struct s_cpen {
    short width;
    PAT_STYLE pat;
    PEN_STYLE style;
    COLOR color;
} CPEN;
typedef struct s_filespec {     /* file specification */
    DIRECTORY dir;              /* directory */
    char type[6];               /* file type or extension */
    char name[SZ_FNAME + 1];    /* file name (may be partial path) */
} FILE_SPEC, *FILE_SPEC_PTR;
typedef struct s_font {         /* abstract font descriptor */
    FONT_STYLE style;           /* bold, italic, etc. */
#if (XVTOS == CTOOS) && (XVTWS == WMWS)
    CT_FONT_FAMILY family;         /* Times, Helvetica, etc. */
#else
    FONT_FAMILY family;         /* Times, Helvetica, etc. */
#endif
    short size;                 /* point size */
} FONT, *FONT_PTR;
typedef struct s_pen {          /* pen tool */
    short width;                /* width in pixels */
    PEN_COLOR color;            /* color */
    PEN_STYLE style;            /* style */
} PEN, *PEN_PTR;
#ifndef NO_CONTROL_INFO
typedef struct s_ctlinfo {      /* info passed to dialog callback fcn */
    WIN_TYPE type;              /* type (WD_MODAL or WD_MODELESS) */
    WINDOW win;                 /* WINDOW for dialog window */
    union {
        struct s_lbox {         /* list box action */
            BOOLEAN dbl_click;  /* double click (vs. single)? */
        } lbox;
        struct s_scroll {       /* scroll bar action */
            SCROLL_CONTROL what;/* site of activity */
            short pos;          /* thumb position */
        } scroll;
        struct s_chr {          /* function key action */
            short ch;           /* char or virtual key code */
            BOOLEAN shift;      /* shift key down? */
            BOOLEAN control;    /* control or option key down? */
#if (XVTOS == CTOOS)
			UINT wStatus;
			UINT wStatus1;
			UCHAR kbdCode;
			UCHAR sChar;
			UINT chordState;
			ULONG chCode;
#endif
        } chr;
		struct s_edit {
			BOOLEAN focus_change;	/* is event a focus change? */
			BOOLEAN active;			/* if so: gaining focus? (vs. losing) */
		} edit;
    } v;
} CONTROL_INFO, *CONTROL_INFO_PTR;
#endif
typedef struct s_drawct {       /* set of drawing tools */
    CPEN pen;                   /* color pen */
    CBRUSH brush;               /* color brush */
    DRAW_MODE mode;             /* drawing mode */
    FONT font;                  /* font */
    COLOR fore_color;           /* foreground color */
    COLOR back_color;           /* background color */
    BOOLEAN opaque_text;        /* is text drawn opaquely? */
} DRAW_CTOOLS;
typedef struct s_drawt {        /* set of drawing tools (obsolete) */
    PEN pen;                    /* pen */
    BRUSH brush;                /* brush */
    DRAW_MODE mode;             /* drawing mode */
    FONT font;                  /* font */
} DRAW_TOOLS, *DRAW_TOOLS_PTR;
#ifdef PROTO
typedef void (XVTENTRY * SCROLL_CALLBACK) BTCENTRY(TXEDIT tx, T_LNUM org_line, T_LNUM nlines, T_CPOS org_offset);
#else
typedef void (*SCROLL_CALLBACK) BTCENTRY();
#endif
#undef CALLBACK /* because OS2DEF.H defines it */
#ifndef NO_CONTROL_INFO
#if (XVTCC == MSCCC) || (XVTCC == MPW3CC) || (XVTCC == MWCCC) || (XVTCC == ZORCC)
typedef BOOLEAN (XVTENTRY * CALLBACK) BTCENTRY(int cid, CONTROL_INFO_PTR cip);
#else
typedef BOOLEAN (*CALLBACK) BTCENTRY ();
#endif
#endif
typedef struct s_event {
    EVENT_TYPE type;
    union {
        struct s_mouse {            /* E_MOUSE_DOWN, E_MOUSE_UP, E_MOUSE_MOVE,
                                       E_MOUSE_DBL */
            PNT where;              /* location of event (window relative) */
            BOOLEAN shift;          /* shift key down? */
            BOOLEAN control;        /* control or option key down? */
            short button;           /* button number */
        } mouse;
        struct s_char {             /* E_CHAR */
            short ch;               /* character */
            BOOLEAN shift;          /* shift key down? */
            BOOLEAN control;        /* control or option key down? */
#if (XVTOS == CTOOS)
			UINT wStatus;
			UINT wStatus1;
			UCHAR kbdCode;
			UCHAR sChar;
			UINT chordState;
			ULONG chCode; 
#endif			
        } chr;
        BOOLEAN active;             /* E_ACTIVATE: activation? (vs. deactivation) */
        BOOLEAN query;              /* E_QUIT: query only? (app calls quit_OK) */
        struct s_scroll_info {      /* E_VSCROLL, E_HSCROLL */
            SCROLL_CONTROL what;    /* site of activity */
            short pos;              /* thumb position, if SC_THUMB */
        } scroll;
        struct s_cmd {              /* E_COMMAND */
            MENU_TAG tag;           /* menu item tag */
            BOOLEAN shift;          /* shift key? */
            BOOLEAN control;        /* control or option key? */
        } cmd;
        struct s_size {             /* E_SIZE */
            short height;           /* new height */
            short width;            /* new width */    
        } size;
        struct s_efont {            /* E_FONT */
            FONT font;              /* selected font */
            FONT_PART part;         /* part that changed */
        } font;
        struct s_ctl {              /* E_CONTROL */
            short id;               /* control's ID */
            CONTROL_INFO ci;        /* control info */
        } ctl; 
#if (XVTOS == CTOOS)
        struct s_user {             /* E_USER */
        	long info;              /* user info */
        } user;
		struct s_timer {			/* E_TIMER */
			short id;				/* not supported in XVT/CH 2.0 */
		} timer;
#endif
    } v;
} EVENT, *EVENT_PTR;


#ifdef INTERNAL
#if (XVTWS == WINWS) || (XVTWS == PMWS)
typedef struct s_npwwin {       /* structure for part of WINDOW data */
    HDC hDC;                    /* handle to display context */
    HWND hWnd;                  /* handle to window */
    char more_stuff[1];         /* lots of secret stuff follows... */
} NPW_WIN, *NPW_WIN_PTR;
#endif
#endif

#if (XVTOS == CTOOS) 
CXX_C_BEGIN		/* non-mangled name, with _ in front */
extern APPL_SETUP appl_setup;     /* variable for app to initialize */
CXX_C_END
#else 
#if (XVTOS == CTOOS) && (XVTCC == MSCCC)
extern APPL_SETUP near appl_setup;      /* variable for app to initialize */
extern FONT near big_font;              /* bigger-than-normal proportional FONT */
extern CPEN near black_cpen;              /* black pen, 1 pixel wide */
extern PEN near black_pen;              /* black pen, 1 pixel wide */
extern DIRECTORY near default_dir;      /* default directory */
extern FONT near fixed_font;             /* fixed_width font */
extern MENU_TAG near font_menu_tag;     /* special tag for Font/Style menu(s) */
extern CPEN near hollow_cpen;             /* hollow pen */
extern PEN near hollow_pen;             /* hollow pen */
extern FONT near normal_font;           /* normal proportional FONT */

extern MENU_TAG near npx_style_menu_tag;    /* style menu tag; Motif only */
extern BOOLEAN near npx_no_menu_bar;    /* no menu on window; Motif only */
extern CPEN near rubber_cpen;             /* rubber-banding pen */
extern PEN near rubber_pen;             /* rubber-banding pen */
extern FONT near small_font;            /* smaller-than-norm. proportional FONT */
extern WINDOW near std_win;             /* app's initial window */
extern SYS_METRICS near sys_metrics;    /* system metrics */
extern CBRUSH near white_cbrush;          /* white brush */
extern CPEN near white_cpen;              /* white pen, 1 pixel wide */
extern PEN near white_pen;              /* white pen, 1 pixel wide */
extern XVTERRNO near xvterrno;          /* error code (partially implemented) */

#else
extern APPL_SETUP appl_setup;      /* variable for app to initialize */
extern FONT big_font;              /* bigger-than-normal proportional FONT */
extern CPEN black_cpen;              /* black pen, 1 pixel wide */
extern PEN black_pen;              /* black pen, 1 pixel wide */
extern DIRECTORY default_dir;      /* default directory */
extern FONT fixed_font;             /* fixed_width font */
extern MENU_TAG font_menu_tag;     /* special tag for Font/Style menu(s) */
extern CPEN hollow_cpen;             /* hollow pen */
extern PEN hollow_pen;             /* hollow pen */
extern FONT normal_font;           /* normal proportional FONT */
extern MENU_TAG npx_style_menu_tag;    /* style menu tag; Motif only */
extern BOOLEAN npx_no_menu_bar;    /* no menu on window; Motif only */
extern CPEN rubber_cpen;             /* rubber-banding pen */
extern PEN rubber_pen;             /* rubber-banding pen */
extern FONT small_font;            /* smaller-than-norm. proportional FONT */
extern WINDOW std_win;             /* app's initial window */
extern SYS_METRICS sys_metrics;    /* system metrics */
extern CBRUSH white_cbrush;          /* white brush */
extern CPEN white_cpen;              /* white pen, 1 pixel wide */
extern PEN white_pen;              /* white pen, 1 pixel wide */
extern XVTERRNO xvterrno;          /* error code (partially implemented) */
#endif
#endif

#if XVTOS == CTOOS
#ifdef PROTO
CXX_PASCAL_BEGIN
extern int XVTENTRY CTOS_GetExchange BTCENTRY(unsigned short * pexchRet);
extern int XVTENTRY CTOS_Request BTCENTRY (char *pRq);
extern int XVTENTRY set_timer BTCENTRY (WINDOW win, long interval);
extern void XVTENTRY kill_timer BTCENTRY (int id);
extern void XVTENTRY keyboard_enable BTCENTRY (BOOLEAN enable);
extern void XVTENTRY mouse_enable BTCENTRY(BOOLEAN enable);
CXX_PASCAL_END
#else
extern int XVTENTRY CTOS_GetExchange BTCENTRY();
extern int XVTENTRY CTOS_Request BTCENTRY();
extern int XVTENTRY set_timer BTCENTRY ();
extern void XVTENTRY kill_timer BTCENTRY ();
extern void XVTENTRY keyboard_enable BTCENTRY();
extern void XVTENTRY mouse_enable BTCENTRY();
#endif
#endif

#if (XVTWS == MTFWS)
#define menu_check(tag, check) win_menu_check(NULL_WIN, (tag), (check))
#define menu_enable(tag, enable) win_menu_enable(NULL_WIN, (tag), (enable))
#define set_font_menu(fontp) win_set_font_menu(NULL_WIN, (fontp))
#define set_menu_text(tag, text) win_set_menu_text(NULL_WIN, (tag), (text))
#define update_menu_bar() win_update_menu_bar(NULL_WIN)
#endif

#ifdef PROTO /* Added by proto stripper */
CXX_PASCAL_BEGIN
void XVTENTRY about_box BTCENTRY (void);
#if defined(LSC) || ((XVTOS == CTOOS) && (XVTCC != MSCCC))
int access (STR path, int perms);
#endif
void XVTENTRY appl_cleanup BTCENTRY (void);
BOOLEAN XVTENTRY appl_init BTCENTRY (void);
void XVTENTRY appl_setup_init BTCENTRY (void);
CXX_PASCAL_END
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention(MWC_CALLING_CONVENTIONS);
#endif
#ifdef ELLIPSIS
CXX_C_ITEM
ASK_RESPONSE ask(STR lbl_dflt, STR lbl2, STR lbl3, STR fmt, ...);
#else
CXX_C_ITEM			
ASK_RESPONSE ask(STR lbl_dflt, STR lbl2, STR lbl3, STR fmt ...);
#endif
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention();
#endif
#if XVTOS == CTOOS
#if XVTCC == MWCCC
pragma Calling_convention(CTOS_CALLING_CONVENTIONS);
void beep(void);
pragma Calling_convention();
#endif

#if XVTCC == BTCCC
#undef far
CXX_C_ITEM extern unsigned XVTENTRY beep BTCENTRY(void);
#define far
#endif

#if XVTCC == MSCCC
CXX_C_ITEM void XVTENTRY beep BTCENTRY (void);
#endif
#else
void XVTENTRY beep BTCENTRY (void);
#endif
CXX_PASCAL_BEGIN
void XVTENTRY caret_off BTCENTRY (WINDOW w);
void XVTENTRY caret_on BTCENTRY (WINDOW w, int x, int y);
BOOLEAN XVTENTRY cb_close BTCENTRY (void);
BOOLEAN XVTENTRY cb_format_avail BTCENTRY (CB_FORMAT cbfmt, STR name);
void XVTENTRY cb_free BTCENTRY (void);
STR_FAR XVTENTRY cb_get BTCENTRY (CB_FORMAT cbfmt, STR name, LONG_PTR sizep);
STR_FAR XVTENTRY cb_malloc BTCENTRY (long size);
BOOLEAN XVTENTRY cb_open BTCENTRY (BOOLEAN writing);
BOOLEAN XVTENTRY cb_put BTCENTRY (CB_FORMAT cbfmt, STR name, long size, PICTURE pic);
void XVTENTRY check_box BTCENTRY (int cid, BOOLEAN check);
void XVTENTRY check_radio_button BTCENTRY (int cid, int start_cid, int stop_cid);
BOOLEAN XVTENTRY chg_dir BTCENTRY (DIRECTORY_PTR dirp);
BOOLEAN XVTENTRY close_print_window BTCENTRY (WINDOW w, PRINT_RCD_PTR precp);
void XVTENTRY close_window BTCENTRY (WINDOW w);
void XVTENTRY count_files BTCENTRY (BOOLEAN_PTR printp, INT_PTR countp);
#ifdef MPW2
STR XVTENTRY ctime BTCENTRY (ULONG_PTR tp);
#endif
CXX_PASCAL_END
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention(MWC_CALLING_CONVENTIONS);
#endif
#ifdef ELLIPSIS
CXX_C_ITEM int dbg(STR fmt, ...);
#else
CXX_C_ITEM int dbg(STR fmt ...);
#endif
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention();
#endif
CXX_PASCAL_BEGIN
BOOLEAN XVTENTRY dir_to_str BTCENTRY (DIRECTORY_PTR dirp, STR path, int sz_path);
void XVTENTRY dlg_callback BTCENTRY (WINDOW w, int cid);
void XVTENTRY draw_aline BTCENTRY (PNT lpnt, BOOLEAN start_arrow, BOOLEAN end_arrow);
void XVTENTRY draw_arc BTCENTRY (RCT_PTR lrctp, int start_x, int start_y, int stop_x, int stop_y);
void XVTENTRY draw_icon BTCENTRY (int x, int y, int rid);
void XVTENTRY draw_line BTCENTRY (PNT lpnt);
void XVTENTRY draw_oval BTCENTRY (RCT_PTR lrctp);
void XVTENTRY draw_pie BTCENTRY (RCT_PTR lrctp, int start_x, int start_y, int stop_x, int stop_y);
void XVTENTRY draw_polygon BTCENTRY (PNT_PTR lpntp, int npnts);
void XVTENTRY draw_polyline BTCENTRY (PNT_PTR lpntp, int npnts);
void XVTENTRY draw_rect BTCENTRY (RCT_PTR lrctp);
void XVTENTRY draw_roundrect BTCENTRY (RCT_PTR lrctp, int oval_width, int oval_height);
void XVTENTRY draw_text BTCENTRY (int x, int y, STR_FAR s, int len);
void XVTENTRY enable_item BTCENTRY (int cid, BOOLEAN enable);
void XVTENTRY enable_window BTCENTRY (WINDOW w, BOOLEAN enable);
CXX_PASCAL_END
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention(MWC_CALLING_CONVENTIONS);
#endif
#ifdef ELLIPSIS
CXX_C_ITEM void error(STR fmt, ...);
#else
CXX_C_ITEM void error(STR fmt ...);
#endif
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention();
#endif

#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention(MWC_CALLING_CONVENTIONS);
#endif
#ifdef ELLIPSIS
CXX_C_ITEM int fatal(STR fmt, ...);
#else
CXX_C_ITEM int fatal(STR fmt ...);
#endif
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention();
#endif
CXX_PASCAL_BEGIN
STR_FAR XVTENTRY find_eol BTCENTRY (STR_FAR buf, long nbytes, LONG_PTR lenp, EOL_FORMAT_PTR fp);
void XVTENTRY finished_file BTCENTRY (void);
BOOLEAN XVTENTRY finish_page BTCENTRY (PRINT_RCD_PTR precp);
void XVTENTRY free_print_rcd BTCENTRY (PRINT_RCD_PTR precp);
#ifdef MAC
int fsprintf(char *s, char *fmt, ...);
#endif
#ifdef WIN
#define fsprintf sprintf
#endif
#if XVTWS == WMWS
#if ((XVTOS == CTOOS) && (XVTCC == MWCCC))
pragma Calling_convention(MWC_CALLING_CONVENTIONS);
#endif
#if (XVTOS == DOSOS) || (XVTOS == OS2OS) || (XVTCC == MSCCC)
#define fsprintf sprintf
#else
int fsprintf(char *s, char *fmt, ...);
#endif
#if ((XVTOS == CTOOS) && (XVTCC == MWCCC))
pragma Calling_convention();
#endif
#endif
GHANDLE XVTENTRY galloc BTCENTRY (long size);
long XVTENTRY get_app_data BTCENTRY (WINDOW w);
RCT_PTR XVTENTRY get_client_rect BTCENTRY (WINDOW w, RCT_PTR lrctp);
RCT * XVTENTRY get_clip BTCENTRY (WINDOW w, RCT_PTR lrctp);
CURSOR XVTENTRY get_cursor BTCENTRY (WINDOW w);
WINDOW XVTENTRY get_cur_window BTCENTRY (void);
BOOLEAN XVTENTRY get_dir BTCENTRY (DIRECTORY_PTR dirp);
WIN_TYPE XVTENTRY get_dlg_type BTCENTRY (WINDOW w);
DRAW_CTOOLS * XVTENTRY get_draw_ctools BTCENTRY (DRAW_CTOOLS *ctoolsp);
DRAW_TOOLS_PTR XVTENTRY get_draw_tools BTCENTRY (DRAW_TOOLS_PTR toolsp);
void XVTENTRY get_font_metrics BTCENTRY (INT_PTR leadingp, INT_PTR ascentp, INT_PTR descentp);
WINDOW XVTENTRY get_front_window BTCENTRY (void);
STR XVTENTRY get_item_text BTCENTRY (int cid, STR text);
char * XVTENTRY get_nls_str BTCENTRY (unsigned short, char *, size_t);
DRAW_CTOOLS * XVTENTRY get_normal_ctools BTCENTRY (DRAW_CTOOLS *ctoolsp);
DRAW_TOOLS_PTR XVTENTRY get_normal_tools BTCENTRY (DRAW_TOOLS_PTR toolsp);
WINDOW XVTENTRY get_parent BTCENTRY (WINDOW w);
DISPLAY_METRICS_PTR XVTENTRY get_printer_metrics BTCENTRY (PRINT_RCD_PTR precp, DISPLAY_METRICS_PTR dmp);
PRINT_RCD_PTR XVTENTRY get_print_rcd BTCENTRY (INT_PTR sizep);
STR XVTENTRY get_res_str BTCENTRY (int rid, STR s, int sz_s);
STR XVTENTRY get_str_response BTCENTRY (STR msg, STR resp, int sz_resp);
int XVTENTRY get_text_width BTCENTRY (STR_FAR s, int len);
STR XVTENTRY get_title BTCENTRY (WINDOW w, STR title, int sz_title);
WIN_TYPE XVTENTRY get_window_type BTCENTRY (WINDOW w);
#if XVTWS == WMWS
int XVTENTRY get_wmwin BTCENTRY (WINDOW win);
#endif
BOOLEAN XVTENTRY gfree BTCENTRY (GHANDLE h);
STR_FAR XVTENTRY glock BTCENTRY (GHANDLE h);
int XVTENTRY gmemcmp BTCENTRY (STR_FAR s1, STR_FAR s2, long n);
#ifndef UNIX
STR_FAR XVTENTRY gmemcpy BTCENTRY (STR_FAR dst, STR_FAR src, long n);
#else
#define gmemcpy(d, s, n) memcpy(d, s, n)
#endif
STR_FAR XVTENTRY gmemrep BTCENTRY (STR_FAR dst, STR_FAR src, UINT srclen, long reps);
STR_FAR XVTENTRY gmemset BTCENTRY (STR_FAR dst, char ch, long n);
#if XVTWS == WINWS
int XVTENTRY gread BTCENTRY (int fildes, STR_FAR buf, UINT nbytes);
#else
#define gread(fildes, buf, nbytes) read(fildes, buf, nbytes)
#endif
GHANDLE XVTENTRY grealloc BTCENTRY (GHANDLE h, long size);
long XVTENTRY gsize BTCENTRY (GHANDLE h);
#if XVTWS == WINWS
STR_FAR XVTENTRY gstrcat BTCENTRY (STR_FAR dst, STR_FAR src);
#else
#define gstrcat(dst, src) strcat(dst, src)
#endif
#if XVTWS == WINWS
int XVTENTRY gstrcmp BTCENTRY (STR_FAR s1, STR_FAR s2);
#else
#if (XVTWS == WMWS) && (XVTOS == CTOOS) && (!defined XVT_SOURCE)
int XVTENTRY nls_strcmp BTCENTRY(STR_FAR s1, STR_FAR s2);
#define gstrcmp(s1, s2) nls_strcmp(s1, s2)
#else
#define gstrcmp(s1, s2) strcmp(s1, s2)
#endif
#endif
#if XVTWS == WINWS
STR_FAR XVTENTRY gstrcpy BTCENTRY (STR_FAR dst, STR_FAR src);
#else
#define gstrcpy(dst, src) strcpy(dst, src)
#endif
#if XVTWS == WINWS
UINT XVTENTRY gstrlen BTCENTRY (STR_FAR src);
#else
#define gstrlen(src) strlen(src)
#endif
BOOLEAN XVTENTRY gunlock BTCENTRY (GHANDLE h);
#if XVTWS == WINWS
int XVTENTRY gwrite BTCENTRY (int fildes, STR_FAR buf, UINT nbytes);
#else
#define gwrite(fildes, buf, nbytes) write(fildes, buf, nbytes)
#endif
void XVTENTRY help BTCENTRY (void);
#ifdef SHELP
BOOLEAN XVTENTRY help_context_string BTCENTRY(char *s, unsigned f);
BOOLEAN XVTENTRY help_context_rid BTCENTRY(int rid, unsigned f);
#ifndef WSPM
BOOLEAN XVTENTRY help_event BTCENTRY(WINDOW win, EVENT *ep);
#endif
BOOLEAN XVTENTRY help_set_filename BTCENTRY(char *pname);
#endif
void XVTENTRY invalidate_rect BTCENTRY (WINDOW w, RCT_PTR lrctp);
BOOLEAN XVTENTRY is_rect_empty BTCENTRY (RCT_PTR rctp);


BOOLEAN XVTENTRY lbox_add BTCENTRY (int cid, int index, STR sx);
BOOLEAN XVTENTRY lbox_clear BTCENTRY (int cid);
int XVTENTRY lbox_count_all BTCENTRY (int cid);
int XVTENTRY lbox_count_sel BTCENTRY (int cid);
BOOLEAN XVTENTRY lbox_delete BTCENTRY (int cid, int index);
SLIST XVTENTRY lbox_get_all BTCENTRY (int cid);
BOOLEAN XVTENTRY lbox_get_elt BTCENTRY (int cid, int index, STR s, int sz_s);
BOOLEAN XVTENTRY lbox_get_first_sel BTCENTRY (int cid, STR s, int sz_s);
SLIST XVTENTRY lbox_get_sel BTCENTRY (int cid);
int XVTENTRY lbox_get_sel_index BTCENTRY (int cid);
BOOLEAN XVTENTRY lbox_is_sel BTCENTRY (int cid, int index);
void XVTENTRY lbox_resume BTCENTRY (int cid);
BOOLEAN XVTENTRY lbox_set_sel BTCENTRY (int cid, int index, BOOLEAN select);
void XVTENTRY lbox_suspend BTCENTRY (int cid);
SLIST XVTENTRY list_faces BTCENTRY (void);
SLIST XVTENTRY list_files BTCENTRY (STR type, STR pat, BOOLEAN dirs);
SLIST XVTENTRY list_res_str BTCENTRY (int rid_first, int rid_last);
SLIST XVTENTRY list_windows BTCENTRY (void);
void XVTENTRY local_global BTCENTRY (WINDOW w, PNT_PTR pntp, int npnts);
#ifndef NO_EVENTS
void XVTENTRY main_event BTCENTRY (WINDOW w, EVENT_PTR ep);
#endif
BOOLEAN XVTENTRY match BTCENTRY (STR src, STR pat, BOOLEAN case_sensitive);
#if (XVTCC == LSCCC) && !defined(THINK_C)
#define memcpy(d, s, n) movmem(s, d, n)
#endif

#if (XVTCC == LSCCC) && !defined(THINK_C)
#define memset(d, c, n) setmem(d, n, c)
#endif

#if (XVTWS != MTFWS)
void XVTENTRY menu_check BTCENTRY (MENU_TAG tag, BOOLEAN check);
void XVTENTRY menu_enable BTCENTRY (MENU_TAG tag, BOOLEAN enable);
#endif
MENU_ITEM * XVTENTRY menu_fetch BTCENTRY (WINDOW w);
void XVTENTRY menu_free BTCENTRY (MENU_ITEM *mip);
BOOLEAN XVTENTRY menu_show BTCENTRY (WINDOW w, MENU_ITEM *mip);
void XVTENTRY move_to BTCENTRY (PNT lpnt);
void XVTENTRY move_window BTCENTRY (WINDOW w, RCT_PTR grctp);
CXX_PASCAL_END
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention(MWC_CALLING_CONVENTIONS);
#endif
#ifdef ELLIPSIS
CXX_C_ITEM void msg(STR fmt, ...);
#else
CXX_C_ITEM void msg(STR fmt, ...);
#endif
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention();
#endif
CXX_PASCAL_BEGIN
BOOLEAN XVTENTRY needs_update BTCENTRY (WINDOW w, RCT_PTR lrctp);
WINDOW XVTENTRY new_child_window BTCENTRY (RCT_PTR rctp, char *title, WIN_TYPE t, BOOLEAN ctl_size, BOOLEAN ctl_vscroll, BOOLEAN ctl_hscroll, BOOLEAN ctl_close, WINDOW parent, long app_data, short reserve1, long reserve2, BOOLEAN visible, BOOLEAN enabled);
WINDOW XVTENTRY new_control BTCENTRY (RCT *lrctp, char *title, WIN_TYPE t, WINDOW parent, BOOLEAN visible, int id, char *templat);
#ifndef NO_CONTROL_INFO
BOOLEAN XVTENTRY new_dialog BTCENTRY (WIN_TYPE t, int rid, CALLBACK fcn, long data);
#endif
WINDOW XVTENTRY new_print_window BTCENTRY (PRINT_RCD_PTR precp, STR title);
WINDOW XVTENTRY new_window BTCENTRY (RCT_PTR grctp, STR title, WIN_TYPE t, BOOLEAN ctl_size, BOOLEAN ctl_vscroll, BOOLEAN ctl_hscroll, BOOLEAN ctl_close);
RCT_PTR XVTENTRY next_band BTCENTRY (void);
FILE_SPEC_PTR XVTENTRY next_file BTCENTRY (void);
CXX_PASCAL_END
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention(MWC_CALLING_CONVENTIONS);
#endif
#ifdef ELLIPSIS
CXX_C_ITEM void note(STR fmt, ...);
#else
CXX_C_ITEM void note(STR fmt ...);
#endif
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention();
#endif
CXX_PASCAL_BEGIN
#ifdef INTERNAL
#if (XVTWS == MTFWS) || (XVTWS == DWTWS)
GC npx_get_gc(WINDOW w); /* Motif only */
#endif
#endif
#ifdef INTERNAL
#if (XVTWS == MTFWS) || (XVTWS == DWTWS)
Widget npx_get_widget(WINDOW w); /* Motif only */
#endif
#endif
#ifdef INTERNAL
#if (XVTWS == MTFWS) || (XVTWS == DWTWS)
Window npx_get_xwindow(WINDOW w); /* Motif only */
#endif
#endif
void XVTENTRY obscure_cursor BTCENTRY (void);
void XVTENTRY offset_rect BTCENTRY (RCT_PTR rctp, int dh, int dv);
FL_STATUS XVTENTRY open_file_dlg BTCENTRY (FILE_SPEC_PTR fsp, STR msg);
BOOLEAN XVTENTRY page_setup_dlg BTCENTRY (PRINT_RCD_PTR precp);
PICTURE XVTENTRY picture_close BTCENTRY (void);
void XVTENTRY picture_draw BTCENTRY (PICTURE pic, RCT_PTR lrctp);
void XVTENTRY picture_free BTCENTRY (PICTURE pic);
STR_FAR XVTENTRY picture_lock BTCENTRY (PICTURE pic, LONG_PTR sizep);
PICTURE XVTENTRY picture_make BTCENTRY (STR_FAR buf, long nbytes, RCT_PTR lrctp);
BOOLEAN XVTENTRY picture_open BTCENTRY (RCT_PTR lrctp);
void XVTENTRY picture_unlock BTCENTRY (PICTURE pic);
BOOLEAN XVTENTRY print_begin BTCENTRY (void);
void XVTENTRY print_end BTCENTRY (void);
void XVTENTRY process_events BTCENTRY (void);
BOOLEAN XVTENTRY pt_in_rect BTCENTRY (RCT_PTR rctp, PNT pntp);
#if (XVTCC == LSCCC) && !defined(THINK_C)
typedef int (*COMPAR_FCN)();
int XVTENTRY qsort BTCENTRY (DATA_PTR base, int nel, int size, COMPAR_FCN compar); /* missing from proto.h */
#endif

void XVTENTRY quit_OK BTCENTRY (void);
BOOLEAN XVTENTRY rect_intersect BTCENTRY (RCT *rctp, RCT *rctp1, RCT *rctp2);
void XVTENTRY release_mouse BTCENTRY (void);
void XVTENTRY restore_dir BTCENTRY (void);
void XVTENTRY save_dir BTCENTRY (void);
FL_STATUS XVTENTRY save_file_dlg BTCENTRY (FILE_SPEC_PTR fsp, STR msg);
void XVTENTRY scroll_rect BTCENTRY (RCT_PTR lrctp, int dh, int dv);
void XVTENTRY select_item_text BTCENTRY (int cid, int first, int last);
void XVTENTRY set_app_data BTCENTRY (WINDOW w, long data);
void XVTENTRY set_back_color BTCENTRY (COLOR color);
void XVTENTRY set_brush BTCENTRY (BRUSH brush);
void XVTENTRY set_cbrush BTCENTRY (CBRUSH *cbrushp);
void XVTENTRY set_clip BTCENTRY (WINDOW w, RCT_PTR lrctp);
void XVTENTRY set_cpen BTCENTRY (CPEN *cpenp);
void XVTENTRY set_cursor BTCENTRY (WINDOW w, CURSOR c);
void XVTENTRY set_cur_window BTCENTRY (WINDOW w);
void XVTENTRY set_doc_title BTCENTRY (WINDOW w, STR title);
void XVTENTRY set_draw_ctools BTCENTRY (DRAW_CTOOLS *ctoolsp);
void XVTENTRY set_draw_mode BTCENTRY (DRAW_MODE mode);
void XVTENTRY set_draw_tools BTCENTRY (DRAW_TOOLS_PTR toolsp);
void XVTENTRY set_file_type BTCENTRY (FILE_SPEC_PTR fsp, STR creator);
void XVTENTRY set_font BTCENTRY (FONT_PTR fontp, BOOLEAN scale);
#if (XVTWS != MTFWS)
void XVTENTRY set_font_menu BTCENTRY (FONT_PTR fontp);
#endif
void XVTENTRY set_fore_color BTCENTRY (COLOR color);
void XVTENTRY set_front_window BTCENTRY (WINDOW w);
void XVTENTRY set_item_text BTCENTRY (int cid, STR text);
#if (XVTWS != MTFWS)
void XVTENTRY set_menu_text BTCENTRY (MENU_TAG tag, STR text);
#endif
void XVTENTRY set_pen BTCENTRY (PEN_PTR penp);
void XVTENTRY set_rect BTCENTRY (RCT_PTR rctp, int left, int top, int right, int bottom);
void XVTENTRY set_rect_empty BTCENTRY (RCT_PTR rctp);
void XVTENTRY set_scroll_pos BTCENTRY (WINDOW w, SCROLL_TYPE t, int pos);
void XVTENTRY set_scroll_range BTCENTRY (WINDOW w, SCROLL_TYPE t, int mn, int mx);
void XVTENTRY set_title BTCENTRY (WINDOW w, STR title);
void XVTENTRY show_window BTCENTRY (WINDOW w, BOOLEAN show);
BOOLEAN XVTENTRY slist_add BTCENTRY (SLIST x, SLIST_ELT e, STR sx, long data);
BOOLEAN XVTENTRY slist_add_sorted BTCENTRY (SLIST x, STR s, long data, BOOLEAN unique, BOOLEAN case_sensitive);
int XVTENTRY slist_count BTCENTRY (SLIST x);
long * XVTENTRY slist_data BTCENTRY (SLIST_ELT e);
void XVTENTRY slist_dbg BTCENTRY (SLIST x);
void XVTENTRY slist_dispose BTCENTRY (SLIST x);
STR XVTENTRY slist_elt BTCENTRY (SLIST x, int index, LONG_PTR datap);
SLIST_ELT XVTENTRY slist_first BTCENTRY (SLIST x);
STR XVTENTRY slist_get BTCENTRY (SLIST x, SLIST_ELT e, LONG_PTR datap);
SLIST XVTENTRY slist_new BTCENTRY (void);
SLIST_ELT XVTENTRY slist_next BTCENTRY (SLIST x, SLIST_ELT e);
BOOLEAN XVTENTRY slist_rem BTCENTRY (SLIST x, SLIST_ELT e);
BOOLEAN XVTENTRY slist_valid BTCENTRY (SLIST x);
void XVTENTRY startup_dir BTCENTRY (void);
BOOLEAN XVTENTRY start_page BTCENTRY (PRINT_RCD_PTR precp);
BOOLEAN XVTENTRY start_print_thread BTCENTRY (BOOLEAN (XVTENTRY *print_fcn)(long data), long data);
#ifdef MAC
int stat(STR path, STAT_PTR statp);
#endif
#if (XVTCC != MSCCC) && (XVTCC != TCCCC)
int strcmpi(STR s1, STR s2);
#endif
BOOLEAN XVTENTRY str_to_dir BTCENTRY (STR path, DIRECTORY_PTR dirp);
void XVTENTRY terminate BTCENTRY (void);
int XVTENTRY text_width BTCENTRY (STR_FAR s);
void XVTENTRY trap_mouse BTCENTRY (WINDOW w);
BOOLEAN XVTENTRY tx_add_par BTCENTRY (TXEDIT tx, T_PNUM pnum, char far *s);
BOOLEAN XVTENTRY tx_append BTCENTRY (TXEDIT tx, T_PNUM pnum, char far *s);
BOOLEAN XVTENTRY tx_clear BTCENTRY (TXEDIT tx);
TXEDIT XVTENTRY tx_create BTCENTRY (WINDOW win, RCT *lrctp, unsigned attrib, FONT *font, int margin, int limit);
BOOLEAN XVTENTRY tx_del_par BTCENTRY (TXEDIT tx, T_PNUM pnum);
BOOLEAN XVTENTRY tx_destroy BTCENTRY (TXEDIT tx);
BOOLEAN XVTENTRY tx_event BTCENTRY (WINDOW win, EVENT *ep);
TXEDIT XVTENTRY tx_get_active BTCENTRY (void);
unsigned XVTENTRY tx_get_attrib BTCENTRY (TXEDIT tx);
#if XVTOS == CTOOS
void XVTENTRY tx_get_border_ctos BTCENTRY(TXEDIT tx, RCT *rct);
void XVTENTRY tx_get_view_ctos BTCENTRY(TXEDIT tx, RCT *view);
void XVTENTRY tx_get_font_ctos BTCENTRY(TXEDIT tx, FONT *font);
#endif
RCT XVTENTRY tx_get_border BTCENTRY (TXEDIT tx);
FONT XVTENTRY tx_get_font BTCENTRY (TXEDIT tx);
int XVTENTRY tx_get_limit BTCENTRY (TXEDIT tx);
STR_FAR XVTENTRY tx_get_line BTCENTRY (TXEDIT tx, T_PNUM pnum, ACCESS_CMD cmd, T_LNUM lnum, unsigned *lenp);
int XVTENTRY tx_get_margin BTCENTRY (TXEDIT tx);
T_CNUM XVTENTRY tx_get_num_chars BTCENTRY (TXEDIT tx, T_PNUM pnum, T_LNUM lnum);
T_LNUM XVTENTRY tx_get_num_lines BTCENTRY (TXEDIT tx);
T_PNUM XVTENTRY tx_get_num_pars BTCENTRY (TXEDIT tx);
T_LNUM XVTENTRY tx_get_num_par_lines BTCENTRY (TXEDIT tx, T_PNUM pnum);
void XVTENTRY tx_get_origin BTCENTRY (TXEDIT tx, T_PNUM far *pnump, T_LNUM far *lnump, T_LNUM far *org_linep, T_CPOS far *org_offsetp);
void XVTENTRY tx_get_sel BTCENTRY (TXEDIT tx, T_PNUM far *p1, T_LNUM far *l1, T_CNUM far *c1, T_PNUM far *p2, T_LNUM far *l2, T_CNUM far *c2);
RCT XVTENTRY tx_get_view BTCENTRY (TXEDIT tx);
WINDOW XVTENTRY tx_get_window BTCENTRY (TXEDIT tx);
void XVTENTRY tx_hscroll BTCENTRY (TXEDIT tx, int pixel_amt);
void XVTENTRY tx_reset BTCENTRY (TXEDIT tx);
void XVTENTRY tx_resume BTCENTRY (TXEDIT tx);
void XVTENTRY tx_set_active BTCENTRY (TXEDIT tx);
void XVTENTRY tx_set_attrib BTCENTRY (TXEDIT tx, unsigned attrib);
void XVTENTRY tx_set_border BTCENTRY (TXEDIT tx, RCT *lrctp);
void XVTENTRY tx_set_font BTCENTRY (TXEDIT tx, FONT *fontp);
void XVTENTRY tx_set_limit BTCENTRY (TXEDIT tx, int limit);
void XVTENTRY tx_set_margin BTCENTRY (TXEDIT tx, int margin);
BOOLEAN XVTENTRY tx_set_par BTCENTRY (TXEDIT tx, T_PNUM pnum, char far *s);
void XVTENTRY tx_set_scroll_callback BTCENTRY (TXEDIT tx, SCROLL_CALLBACK scroll_callback);
void XVTENTRY tx_set_sel BTCENTRY (TXEDIT tx, T_PNUM p1, T_LNUM l1, T_CNUM c1, T_PNUM p2, T_LNUM l2, T_CNUM c2);
void XVTENTRY tx_suspend BTCENTRY (TXEDIT tx);
void XVTENTRY tx_vscroll BTCENTRY (TXEDIT tx, int line_amt);
#if (XVTWS != MTFWS)
void XVTENTRY update_menu_bar BTCENTRY (void);
#endif
void XVTENTRY update_window BTCENTRY (WINDOW w);
BOOLEAN XVTENTRY validate_print_rcd BTCENTRY (PRINT_RCD_PTR precp);
void XVTENTRY wait_cursor BTCENTRY (void);
void XVTENTRY win_check_box BTCENTRY (WINDOW win, BOOLEAN check);
void XVTENTRY win_check_radio_button BTCENTRY (WINDOW win, WINDOW *ctls, int nctls);
void XVTENTRY win_select_item_text BTCENTRY (WINDOW win, int first, int last);
void XVTENTRY xvt_ffree BTCENTRY (char far *p);
STR_FAR XVTENTRY xvt_fmalloc BTCENTRY (size_t size);
STR_FAR XVTENTRY xvt_frealloc BTCENTRY (char far *p, size_t size);
void XVTENTRY xvt_free BTCENTRY (char *p);
int XVTENTRY xvt_interr BTCENTRY (unsigned errcode);
char * XVTENTRY xvt_malloc BTCENTRY (size_t size);
char * XVTENTRY xvt_realloc BTCENTRY (char *p, size_t size);
CXX_PASCAL_END

#else /* Rest of file produced mechanically by proto stripper */
void XVTENTRY about_box BTCENTRY ();
#if defined(LSC) || (XVTOS == CTOOS)
int access ();
#endif
void XVTENTRY appl_cleanup BTCENTRY ();
BOOLEAN XVTENTRY appl_init BTCENTRY ();
void XVTENTRY appl_setup_init BTCENTRY ();
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention(MWC_CALLING_CONVENTIONS);
#endif
#ifdef ELLIPSIS
ASK_RESPONSE ask();
#else
ASK_RESPONSE ask();
#endif
#if XVTOS == CTOOS
#if XVTCC == MWCCC
pragma Calling_convention();
void XVTENTRY beep BTCENTRY ();
#else
#if XVTCC == BTCCC
#undef far
extern unsigned XVTENTRY beep BTCENTRY  plm far();
#define far
#endif
#endif
#else
void XVTENTRY beep BTCENTRY ();
#endif
void XVTENTRY caret_off BTCENTRY ();
void XVTENTRY caret_on BTCENTRY ();
BOOLEAN XVTENTRY cb_close BTCENTRY ();
BOOLEAN XVTENTRY cb_format_avail BTCENTRY ();
void XVTENTRY cb_free BTCENTRY ();
STR_FAR XVTENTRY cb_get BTCENTRY ();
STR_FAR XVTENTRY cb_malloc BTCENTRY ();
BOOLEAN XVTENTRY cb_open BTCENTRY ();
BOOLEAN XVTENTRY cb_put BTCENTRY ();
void XVTENTRY check_box BTCENTRY ();
void XVTENTRY check_radio_button BTCENTRY ();
BOOLEAN XVTENTRY chg_dir BTCENTRY ();
BOOLEAN XVTENTRY close_print_window BTCENTRY ();
void XVTENTRY close_window BTCENTRY ();
void XVTENTRY count_files BTCENTRY ();
#ifdef MPW2
STR XVTENTRY ctime BTCENTRY ();
#endif
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention(MWC_CALLING_CONVENTIONS);
#endif
#ifdef ELLIPSIS
int dbg();
#else
int dbg();
#endif
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention();
#endif
BOOLEAN XVTENTRY dir_to_str BTCENTRY ();
void XVTENTRY dlg_callback BTCENTRY ();
void XVTENTRY draw_aline BTCENTRY ();
void XVTENTRY draw_arc BTCENTRY ();
void XVTENTRY draw_icon BTCENTRY ();
void XVTENTRY draw_line BTCENTRY ();
void XVTENTRY draw_oval BTCENTRY ();
void XVTENTRY draw_pie BTCENTRY ();
void XVTENTRY draw_polygon BTCENTRY ();
void XVTENTRY draw_polyline BTCENTRY ();
void XVTENTRY draw_rect BTCENTRY ();
void XVTENTRY draw_roundrect BTCENTRY ();
void XVTENTRY draw_text BTCENTRY ();
void XVTENTRY enable_item BTCENTRY ();
void XVTENTRY enable_window BTCENTRY ();
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention(MWC_CALLING_CONVENTIONS);
#endif
#ifdef ELLIPSIS
void error();
#else
void error();
#endif

#ifdef ELLIPSIS
int fatal();
#else
int fatal();
#endif
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention();
#endif
STR_FAR XVTENTRY find_eol BTCENTRY ();
void XVTENTRY finished_file BTCENTRY ();
BOOLEAN XVTENTRY finish_page BTCENTRY ();
void XVTENTRY free_print_rcd BTCENTRY ();
#ifdef MAC
int fsprintf();
#endif
#ifdef WIN
#define fsprintf sprintf
#endif
#if XVTWS == WMWS
#if (XVTOS == DOSOS) || (XVTOS == OS2OS)
#define fsprintf sprintf
#else
int fsprintf();
#endif
#endif
#if ((XVTOS == CTOOS) && (XVTWS == PMWS))
#define fsprintf sprintf
#endif
GHANDLE XVTENTRY galloc BTCENTRY ();
long XVTENTRY get_app_data BTCENTRY ();
RCT_PTR XVTENTRY get_client_rect BTCENTRY ();
RCT * XVTENTRY get_clip BTCENTRY ();
CURSOR XVTENTRY get_cursor BTCENTRY ();
WINDOW XVTENTRY get_cur_window BTCENTRY ();
BOOLEAN XVTENTRY get_dir BTCENTRY ();
WIN_TYPE XVTENTRY get_dlg_type BTCENTRY ();
DRAW_CTOOLS * XVTENTRY get_draw_ctools BTCENTRY ();
DRAW_TOOLS_PTR XVTENTRY get_draw_tools BTCENTRY ();
void XVTENTRY get_font_metrics BTCENTRY ();
WINDOW XVTENTRY get_front_window BTCENTRY ();
STR XVTENTRY get_item_text BTCENTRY ();
char * XVTENTRY get_nls_str BTCENTRY ();
DRAW_CTOOLS * XVTENTRY get_normal_ctools BTCENTRY ();
DRAW_TOOLS_PTR XVTENTRY get_normal_tools BTCENTRY ();
WINDOW XVTENTRY get_parent BTCENTRY ();
DISPLAY_METRICS_PTR XVTENTRY get_printer_metrics BTCENTRY ();
PRINT_RCD_PTR XVTENTRY get_print_rcd BTCENTRY ();
STR XVTENTRY get_res_str BTCENTRY ();
STR XVTENTRY get_str_response BTCENTRY ();
int XVTENTRY get_text_width BTCENTRY ();
STR XVTENTRY get_title BTCENTRY ();
WIN_TYPE XVTENTRY get_window_type BTCENTRY ();
#if XVTWS == WMWS
int XVTENTRY get_wmwin BTCENTRY ();
#endif
BOOLEAN XVTENTRY gfree BTCENTRY ();
STR_FAR XVTENTRY glock BTCENTRY ();
int XVTENTRY gmemcmp BTCENTRY ();
#ifndef UNIX
STR_FAR XVTENTRY gmemcpy BTCENTRY ();
#else
#define gmemcpy(d, s, n) memcpy(d, s, n)
#endif
STR_FAR XVTENTRY gmemrep BTCENTRY ();
STR_FAR XVTENTRY gmemset BTCENTRY ();
#if XVTWS == WINWS
int XVTENTRY gread BTCENTRY ();
#else
#define gread(fildes, buf, nbytes) read(fildes, buf, nbytes)
#endif
GHANDLE XVTENTRY grealloc BTCENTRY ();
long XVTENTRY gsize BTCENTRY ();
#if XVTWS == WINWS
STR_FAR XVTENTRY gstrcat BTCENTRY ();
#else
#define gstrcat(dst, src) strcat(dst, src)
#endif
#if XVTWS == WINWS
int XVTENTRY gstrcmp BTCENTRY ();
#else
#if XVTWS == WMWS
#define gstrcmp(s1, s2) nls_strcmp(s1, s2)
#else
#define gstrcmp(s1, s2) strcmp(s1, s2)
#endif
#endif
#if XVTWS == WINWS
STR_FAR XVTENTRY gstrcpy BTCENTRY ();
#else
#define gstrcpy(dst, src) strcpy(dst, src)
#endif
#if XVTWS == WINWS
UINT XVTENTRY gstrlen BTCENTRY ();
#else
#define gstrlen(src) strlen(src)
#endif
BOOLEAN XVTENTRY gunlock BTCENTRY ();
#if XVTWS == WINWS
int XVTENTRY gwrite BTCENTRY ();
#else
#define gwrite(fildes, buf, nbytes) write(fildes, buf, nbytes)
#endif
void XVTENTRY help BTCENTRY ();
#ifdef SHELP
BOOLEAN XVTENTRY help_context_string ();
BOOLEAN XVTENTRY help_context_rid ();
BOOLEAN XVTENTRY help_event ();
BOOLEAN XVTENTRY help_set_filename ();
#endif
void XVTENTRY invalidate_rect BTCENTRY ();
BOOLEAN XVTENTRY is_rect_empty BTCENTRY ();


BOOLEAN XVTENTRY lbox_add BTCENTRY ();
BOOLEAN XVTENTRY lbox_clear BTCENTRY ();
int XVTENTRY lbox_count_all BTCENTRY ();
int XVTENTRY lbox_count_sel BTCENTRY ();
BOOLEAN XVTENTRY lbox_delete BTCENTRY ();
SLIST XVTENTRY lbox_get_all BTCENTRY ();
BOOLEAN XVTENTRY lbox_get_elt BTCENTRY ();
BOOLEAN XVTENTRY lbox_get_first_sel BTCENTRY ();
SLIST XVTENTRY lbox_get_sel BTCENTRY ();
int XVTENTRY lbox_get_sel BTCENTRY _index();
BOOLEAN XVTENTRY lbox_is_sel BTCENTRY ();
void XVTENTRY lbox_resume BTCENTRY ();
BOOLEAN XVTENTRY lbox_set_sel BTCENTRY ();
void XVTENTRY lbox_suspend BTCENTRY ();
SLIST XVTENTRY list_faces BTCENTRY ();
SLIST XVTENTRY list_files BTCENTRY ();
SLIST XVTENTRY list_res_str BTCENTRY ();
SLIST XVTENTRY list_windows BTCENTRY ();
void XVTENTRY local_global BTCENTRY ();
#ifndef NO_EVENTS
void XVTENTRY main_event BTCENTRY ();
#endif
BOOLEAN XVTENTRY match BTCENTRY ();
#if (XVTCC == LSCCC) && !defined(THINK_C)
#define memcpy(d, s, n) movmem(s, d, n)
#endif

#if (XVTCC == LSCCC) && !defined(THINK_C)
#define memset(d, c, n) setmem(d, n, c)
#endif

#if (XVTWS != MTFWS)
void XVTENTRY menu_check BTCENTRY ();
void XVTENTRY menu_enable BTCENTRY ();
#endif
MENU_ITEM * XVTENTRY menu_fetch BTCENTRY ();
void XVTENTRY menu_free BTCENTRY ();
BOOLEAN XVTENTRY menu_show BTCENTRY ();
void XVTENTRY move_to BTCENTRY ();
void XVTENTRY move_window BTCENTRY ();
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention(MWC_CALLING_CONVENTIONS);
#endif
#ifdef ELLIPSIS
void msg();
#else
void msg();
#endif
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention();
#endif
BOOLEAN XVTENTRY needs_update BTCENTRY ();
WINDOW XVTENTRY new_child_window BTCENTRY ();
WINDOW XVTENTRY new_control BTCENTRY ();
#ifndef NO_CONTROL_INFO
BOOLEAN XVTENTRY new_dialog BTCENTRY ();
#endif
WINDOW XVTENTRY new_print_window BTCENTRY ();
WINDOW XVTENTRY new_window BTCENTRY ();
RCT_PTR XVTENTRY next_band BTCENTRY ();
FILE_SPEC_PTR XVTENTRY next_file BTCENTRY ();
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention(MWC_CALLING_CONVENTIONS);
#endif
#ifdef ELLIPSIS
void note();
#else
void note();
#endif
#if (XVTOS == CTOOS) && (XVTCC == MWCCC)
pragma Calling_convention();
#endif
#ifdef INTERNAL
#if (XVTWS == MTFWS) || (XVTWS == DWTWS)
GC npx_get_gc();
#endif
#endif
#ifdef INTERNAL
#if (XVTWS == MTFWS) || (XVTWS == DWTWS)
Widget npx_get_widget();
#endif
#endif
#ifdef INTERNAL
#if (XVTWS == MTFWS) || (XVTWS == DWTWS)
Window npx_get_xwindow();
#endif
#endif
void XVTENTRY obscure_cursor BTCENTRY ();
void XVTENTRY offset_rect BTCENTRY ();
FL_STATUS XVTENTRY open_file_dlg BTCENTRY ();
BOOLEAN XVTENTRY page_setup_dlg BTCENTRY ();
PICTURE XVTENTRY picture_close BTCENTRY ();
void XVTENTRY picture_draw BTCENTRY ();
void XVTENTRY picture_free BTCENTRY ();
STR_FAR XVTENTRY picture_lock BTCENTRY ();
PICTURE XVTENTRY picture_make BTCENTRY ();
BOOLEAN XVTENTRY picture_open BTCENTRY ();
void XVTENTRY picture_unlock BTCENTRY ();
BOOLEAN XVTENTRY print_begin BTCENTRY ();
void XVTENTRY print_end BTCENTRY ();
void XVTENTRY process_events BTCENTRY ();
BOOLEAN XVTENTRY pt_in_rect BTCENTRY ();
#if (XVTCC == LSCCC) && !defined(THINK_C)
typedef int (*COMPAR_FCN)();
int XVTENTRY qsort BTCENTRY ();
#endif

void XVTENTRY quit_OK BTCENTRY ();
BOOLEAN XVTENTRY rect_intersect BTCENTRY ();
void XVTENTRY release_mouse BTCENTRY ();
void XVTENTRY restore_dir BTCENTRY ();
void XVTENTRY save_dir BTCENTRY ();
FL_STATUS XVTENTRY save_file_dlg BTCENTRY ();
void XVTENTRY scroll_rect BTCENTRY ();
void XVTENTRY select_item_text BTCENTRY ();
void XVTENTRY set_app_data BTCENTRY ();
void XVTENTRY set_back_color BTCENTRY ();
void XVTENTRY set_brush BTCENTRY ();
void XVTENTRY set_cbrush BTCENTRY ();
void XVTENTRY set_clip BTCENTRY ();
void XVTENTRY set_cpen BTCENTRY ();
void XVTENTRY set_cursor BTCENTRY ();
void XVTENTRY set_cur_window BTCENTRY ();
void XVTENTRY set_doc_title BTCENTRY ();
void XVTENTRY set_draw_ctools BTCENTRY ();
void XVTENTRY set_draw_mode BTCENTRY ();
void XVTENTRY set_draw_tools BTCENTRY ();
void XVTENTRY set_file_type BTCENTRY ();
void XVTENTRY set_font BTCENTRY ();
#if (XVTWS != MTFWS)
void XVTENTRY set_font BTCENTRY _menu();
#endif
void XVTENTRY set_fore_color BTCENTRY ();
void XVTENTRY set_front_window BTCENTRY ();
void XVTENTRY set_item_text BTCENTRY ();
#if (XVTWS != MTFWS)
void XVTENTRY set_menu_text BTCENTRY ();
#endif
void XVTENTRY set_pen BTCENTRY ();
void XVTENTRY set_rect BTCENTRY ();
void XVTENTRY set_rect BTCENTRY _empty();
void XVTENTRY set_scroll_pos BTCENTRY ();
void XVTENTRY set_scroll_range BTCENTRY ();
void XVTENTRY set_title BTCENTRY ();
void XVTENTRY show_window BTCENTRY ();
BOOLEAN XVTENTRY slist_add BTCENTRY ();
BOOLEAN XVTENTRY slist_add BTCENTRY _sorted();
int XVTENTRY slist_count BTCENTRY ();
long * XVTENTRY slist_data BTCENTRY ();
void XVTENTRY slist_dbg BTCENTRY ();
void XVTENTRY slist_dispose BTCENTRY ();
STR XVTENTRY slist_elt BTCENTRY ();
SLIST_ELT XVTENTRY slist_first BTCENTRY ();
STR XVTENTRY slist_get BTCENTRY ();
SLIST XVTENTRY slist_new BTCENTRY ();
SLIST_ELT XVTENTRY slist_next BTCENTRY ();
BOOLEAN XVTENTRY slist_rem BTCENTRY ();
BOOLEAN XVTENTRY slist_valid BTCENTRY ();
void XVTENTRY startup_dir BTCENTRY ();
BOOLEAN XVTENTRY start_page BTCENTRY ();
BOOLEAN XVTENTRY start_print_thread BTCENTRY ();
#ifdef MAC
int stat();
#endif
#if XVTCC != MSCCC
int strcmpi();
#endif
BOOLEAN XVTENTRY str_to_dir BTCENTRY ();
void XVTENTRY terminate BTCENTRY ();
int XVTENTRY text_width BTCENTRY ();
void XVTENTRY trap_mouse BTCENTRY ();
BOOLEAN XVTENTRY tx_add_par BTCENTRY ();
BOOLEAN XVTENTRY tx_append BTCENTRY ();
BOOLEAN XVTENTRY tx_clear BTCENTRY ();
TXEDIT XVTENTRY tx_create BTCENTRY ();
BOOLEAN XVTENTRY tx_del_par BTCENTRY ();
BOOLEAN XVTENTRY tx_destroy BTCENTRY ();
BOOLEAN XVTENTRY tx_event BTCENTRY ();
TXEDIT XVTENTRY tx_get_active BTCENTRY ();
unsigned XVTENTRY tx_get_attrib BTCENTRY ();
RCT XVTENTRY tx_get_border BTCENTRY ();
FONT XVTENTRY tx_get_font BTCENTRY ();
int XVTENTRY tx_get_limit BTCENTRY ();
STR_FAR XVTENTRY tx_get_line BTCENTRY ();
int XVTENTRY tx_get_margin BTCENTRY ();
T_CNUM XVTENTRY tx_get_num_chars BTCENTRY ();
T_LNUM XVTENTRY tx_get_num_lines BTCENTRY ();
T_PNUM XVTENTRY tx_get_num_pars BTCENTRY ();
T_LNUM XVTENTRY tx_get_num_par_lines BTCENTRY ();
void XVTENTRY tx_get_origin BTCENTRY ();
void XVTENTRY tx_get_sel BTCENTRY ();
RCT XVTENTRY tx_get_view BTCENTRY ();
WINDOW XVTENTRY tx_get_window BTCENTRY ();
void XVTENTRY tx_hscroll BTCENTRY ();
void XVTENTRY tx_reset BTCENTRY ();
void XVTENTRY tx_resume BTCENTRY ();
void XVTENTRY tx_set_active BTCENTRY ();
void XVTENTRY tx_set_attrib BTCENTRY ();
void XVTENTRY tx_set_border BTCENTRY ();
void XVTENTRY tx_set_font BTCENTRY ();
void XVTENTRY tx_set_limit BTCENTRY ();
void XVTENTRY tx_set_margin BTCENTRY ();
BOOLEAN XVTENTRY tx_set_par BTCENTRY ();
void XVTENTRY tx_set_scroll_callback BTCENTRY ();
void XVTENTRY tx_set_sel BTCENTRY ();
void XVTENTRY tx_suspend BTCENTRY ();
void XVTENTRY tx_vscroll BTCENTRY ();
void XVTENTRY update_menu_bar BTCENTRY ();
void XVTENTRY update_window BTCENTRY ();
BOOLEAN XVTENTRY validate_print_rcd BTCENTRY ();
void XVTENTRY wait_cursor BTCENTRY ();
void XVTENTRY win_check_box BTCENTRY ();
void XVTENTRY win_check_box BTCENTRY ();
void XVTENTRY win_check_radio_button BTCENTRY ();
void XVTENTRY win_select_item_text BTCENTRY ();
void XVTENTRY xvt_ffree BTCENTRY ();
STR_FAR XVTENTRY xvt_fmalloc BTCENTRY ();
STR_FAR XVTENTRY xvt_frealloc BTCENTRY ();
void XVTENTRY xvt_free BTCENTRY ();
int XVTENTRY xvt_interr BTCENTRY ();
char * XVTENTRY xvt_malloc BTCENTRY ();
char * XVTENTRY xvt_realloc BTCENTRY ();
#endif /* PROTO */
#endif /* INCL_XVTH */
/* End of proto stripping; end of XVT.H */
#ifndef XVT_SOURCE
#if (XVTCC == MWCCC) && (XVTOS == CTOOS)
pragma Calling_convention(CTOS_CALLING_CONVENTIONS);
#endif
#endif

#if (XVTOS == CTOOS)
#include "xvt_ctos.h"
#endif
