/****************************** MODULE HEADER ********************************/
/*                                                                           */
/* FILE: khook.c                                                             */
/*                                                                           */
/* MACHINE: B20         LANGUAGE: MSC  OS: CTOS                              */
/*                                                                           */
/* DESCRIPTION:  CTOS version of key_hook                                    */
/*                                                                           */
/*                                                                           */
/* TITLE:  BTOS SYSTEM SOFTWARE                                              */
/*                                                                           */
/*            PROPRIETARY PROGRAM MATERIAL                                   */
/*                                                                           */
/* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       */
/* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   */
/* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            */
/* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                */
/*                                                                           */
/*                                                                           */
/* COPYRIGHT (C) 1980, 1989 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED     */
/* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          */
/* ************************************************************************* */
/*                                                                           */
/* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      */
/* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      */
/* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        */
/* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   */
/* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         */
/* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 */
/*                                                                           */
/* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      */
/* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        */
/* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           */
/*                                                                           */
/*************************** END OF MODULE HEADER ****************************/

/*
	Copyright 1987-1990 XVT Software Inc. All rights reserved.
	May be used freely by licensed and registered users of XVT.
	May be distributed in source form only when embedded in XVT 
	user's application.
*/
/*
	This file contains the Windows and PM versions of key_hook.
*/

#ifdef WSPM
#define  INCL_DOS
#define  INCL_WIN
#define  INCL_GPI
#define COLOR pm_COLOR
#define UINT pm_UINT
#define ULONG pm_ULONG
#include <os2.h>
#undef COLOR
#undef UINT
#undef ULONG
#define VK_CONTROL VK_CTRL
#define VK_PRIOR VK_PAGEUP
#define VK_NEXT VK_PAGEDOWN
#define VK_HELP VK_F1
#define MSG QMSG
#else
#define VK_CONTROL VK_CTRL
#define VK_PRIOR VK_PAGEUP
#define VK_NEXT VK_PAGEDOWN
#define VK_HELP VK_F1
#endif

#ifndef USHORT
#define USHORT unsigned short
#endif

#ifndef WSPM
#define LOUSHORT(l)	((USHORT)(ULONG)(l))
#define HIUSHORT(l)	((USHORT)(((ULONG)(l) >> 16) & 0xffff))
#endif

#undef NULL
#include "xvt.h"

extern USHORT XVTENTRY GetKeyState (USHORT);

#include "keycode.h"

BOOLEAN XVTENTRY key_hook (int type, KHOOK_STRUCT *k_hook);
BOOLEAN pm_key_hook(int rid, BOOLEAN modal, long far *wParamp, long far *lParamp);
BOOLEAN ch_key_hook (int wm_key, INT_PTR vkeyp, BOOLEAN_PTR shiftp,
  BOOLEAN_PTR controlp);

#define SHIFT_KEY    1000
#define CONTROL_KEY  2000

#ifdef FPROTO
BOOLEAN XVTENTRY key_hook(int type, KHOOK_STRUCT *k_hook)
#else
BOOLEAN XVTENTRY key_hook(type, k_hook)
int type;							/* PMHOOK or CHHOOK */
KHOOK_STRUCT *k_hook;				/* bundled key_hook params */
#endif
{
	if (type == PMHOOK)
		return(pm_key_hook (k_hook->rid, k_hook->modal, 
			k_hook->wParamp, k_hook->lParamp));
	else
		return(ch_key_hook (k_hook->wm_key, k_hook->vkeyp, 
			k_hook->shift, k_hook->control));
}


/*
	Function called when a keyboard character is typed.

	For PM:
	There is no WM_KEYDOWN, only a WM_CHAR, and *wParamp (a long) and
	*lParamp have a completely different coding from what they have in
	Windows. However, this function still must return the ASCII char or
	virtual key code in *wParamp, as it does naturally for Windows. The
	high-order word of *wParamp must be zero on return.

	This function is not called for modal or modeless dialogs, because there
	already is a mechanism for handling accelerators in dialogs.
	
	In PM, shifted arrows on the numeric keypad show up as numbers instead of
	shifted arrows.  The text edit module of XVT expects to get shifted arrow
	keys, so this key_hook is set up to produce those instead of keypad
	numbers.  If the NUMLOCK key is on, numbers will still be produced.
	You may alter this behaviour if you do not need the shift-arrow text
	selection feature of the text edit module.
*/
#ifdef FPROTO
BOOLEAN pm_key_hook(int rid, BOOLEAN modal, long far *wParamp, long far *lParamp)
#else
BOOLEAN pm_key_hook(rid, modal, wParamp, lParamp)
int rid;							/* dialog box ID or 0 if none active */
BOOLEAN modal;					  /* TRUE if modal dialog active */
long far *wParamp;			   /* long parameter passed to window proc */
long far *lParamp;				      /* LONG parameter */
#endif
{
#ifdef WSPM
	register int i;
	register int key, sc_key;
	static struct {
		int xk;					 /* XVT virtual key */
		int wk;					 /* Windows virtual key */
	} map[] = {
		{K_F1, VK_F1},
		{K_F2, VK_F2},
		{K_F3, VK_F3},
		{K_F4, VK_F4},
		{K_F5, VK_F5},
		{K_F6, VK_F6},
		{K_F7, VK_F7},
		{K_F8, VK_F8},
		{K_F9, VK_F9},
		{K_F10, VK_F10},
		{K_F11, VK_F11},
		{K_F12, VK_F12},
		{K_F13, VK_F13},
		{K_F14, VK_F14},
		{K_F15, VK_F15},
		{K_UP, VK_UP},
		{K_DOWN, VK_DOWN},
		{K_RIGHT, VK_RIGHT},
		{K_LEFT, VK_LEFT},
		{K_PREV, VK_PRIOR},
		{K_NEXT, VK_NEXT},
#if (XVTOS == CTOOS)
		{K_HOME, VK_HOME},
		{K_END, VK_END},
#else
		{K_LHOME, VK_HOME},
		{K_LEND, VK_END},
#endif
		{K_HOME, VK_HOME + CONTROL_KEY},
		{K_END, VK_END + CONTROL_KEY},
		{K_INS, VK_INSERT},
		{K_WLEFT, VK_LEFT + CONTROL_KEY},
		{K_WRIGHT, VK_RIGHT + CONTROL_KEY},
#ifdef WSWIN
		{K_BTAB, VK_TAB + SHIFT_KEY},
#else
		{K_BTAB, VK_BACKTAB},
#endif
		{K_HELP, VK_HELP},
		{K_CLEAR, VK_DELETE},
		{K_DEL, VK_DELETE + SHIFT_KEY}, /* forward delete */
#ifdef WSWIN
		{ '\033', VK_ESCAPE },
#else
		{ '\033', VK_ESC },
#endif
		{0, 0}
	};
#ifdef WSPM
	static struct {			 /* structure to translate shifted keys */
		int xk;				 /* XVT virtual key */
		int sch;				/* shifted char code */
	} shift_map[] = {
		{K_UP, '8'},
		{K_DOWN, '2'},
		{K_RIGHT, '6'},
		{K_LEFT, '4'},
		{K_PREV, '9'},
		{K_NEXT, '3'},
#if (XVTOS == CTOOS)
		{K_HOME, '7'},
		{K_END, '1'},
#else
		{K_LHOME, '7'},
		{K_LEND, '1'},
#endif
		{K_INS, '0'},
		{K_DEL, '.'},
		{0,0}
	};
#endif

	NOREF(modal);
	NOREF(lParamp);
#ifdef WSWIN
	key = *wParamp;
	if (key < 256) {
		if ( key == VK_ESCAPE || 
			(key == VK_TAB && (GetKeyState(VK_SHIFT) < 0))
		   )
		   return(FALSE);
		else
			return(TRUE); /* WM_CHAR message -- already translated by Windows */
	}
	key = (int)*wParamp - 256;
#else
	if ((*wParamp & KC_KEYUP) || (*wParamp & KC_ALT)) {
		return(FALSE);
	}
	if ((*wParamp & KC_CHAR) && (HIUSHORT(*lParamp) != VK_BACKTAB)) {
		if (GetKeyState(VK_SHIFT) < 0) {
			/* may be a shifted arrow key */
			for (i=0; shift_map[i].sch != 0; i++) {
				if (shift_map[i].sch == LOUSHORT(*lParamp)) {
					*wParamp = shift_map[i].xk;
					return(TRUE);
				}
			}
		}
		*wParamp = LOUSHORT(*lParamp);
		return(TRUE); /* not a virtual key code */
	} else if (!(*wParamp & KC_VIRTUALKEY)) {
		/* the following allows for Ctrl-letter key combinations */
		if ((*wParamp & KC_CTRL) && (LOUSHORT(*lParamp) != 0)) {
#if (XVTOS != CTOOS)
			*wParamp = (LOUSHORT(*lParamp) & 0x1F);
#else
			*wParamp = LOUSHORT(*lParamp);
#endif
			return(TRUE);
		}
		return(FALSE); /* something weird */
	}
	key = HIUSHORT(*lParamp); /* virtual key */
#endif
	if (rid != 0) {
		return(FALSE); /* don't pass any dialog box keys to app */
	}
	sc_key = key;
	if (GetKeyState(VK_SHIFT) < 0)
		sc_key += SHIFT_KEY;
	if (GetKeyState(VK_CONTROL) < 0)
		sc_key += CONTROL_KEY;
	if (key != sc_key)
		for (i = 0; map[i].wk != 0; i++)
			if (map[i].wk == sc_key) {
				*wParamp = map[i].xk;
				return(TRUE);
			}
	for (i = 0; map[i].wk != 0; i++)
		if (map[i].wk == key) {
			*wParamp = map[i].xk;
			return(TRUE);
		}
#endif  /* defined WSPM */
	return(FALSE);
}

/*	ch_key_hook - translate a Window Manager virtual key into a
 *		XVT virtual key/shift/control combination */
#ifdef FPROTO
BOOLEAN ch_key_hook (int wm_key, INT_PTR vkeyp, BOOLEAN_PTR shiftp,
  BOOLEAN_PTR controlp)
#else
BOOLEAN ch_key_hook (wm_key, vkeyp, shiftp, controlp)
int wm_key;
INT_PTR vkeyp;
BOOLEAN_PTR shiftp, controlp;
#endif
{
	if (wm_key == 0) {
		return(FALSE);
	}
	*(int *)vkeyp = wm_key;

	switch (wm_key) {
#if (XVTOS != CTOOS)
	case K_S_F1:
	case K_S_F2:
	case K_S_F3:
	case K_S_F4:
	case K_S_F5:
	case K_S_F6:
	case K_S_F7:
	case K_S_F8:
	case K_S_F9:
	case K_S_F10:
		*(int *)vkeyp -= 10;
		*shiftp = TRUE;
		break;
	case K_C_F1:
	case K_C_F2:
	case K_C_F3:
	case K_C_F4:
	case K_C_F5:
	case K_C_F6:
	case K_C_F7:
	case K_C_F8:
	case K_C_F9:
	case K_C_F10:
		*(int *)vkeyp -= 20;
		*controlp = TRUE;
		break;
#endif
#if (XVTOS == CTOOS)
/* turns these into XVT K_F11 thru K_F15 */
	case (K_F1 | ALT_OFFSET):
	case (K_F2 | ALT_OFFSET):
	case (K_F3 | ALT_OFFSET):
	case (K_F4 | ALT_OFFSET):
	case (K_F5 | ALT_OFFSET):
		*(int *)vkeyp = (*(int *)vkeyp & ~ALT_OFFSET) + 10; 
#else
	case K_A_F1:
	case K_A_F2:
	case K_A_F3:
	case K_A_F4:
	case K_A_F5:
		*(int *)vkeyp -= 20; /* turns these into XVT K_F11 through K_F15 */
#endif
	}
	return(TRUE);
}