/****************************** MODULE HEADER ********************************/
/*                                                                           */
/* FILE: ehook.c    		                                                 */
/*                                                                           */
/* MACHINE: B20         LANGUAGE: MSC  OS: CTOS                              */
/*                                                                           */
/* DESCRIPTION:  CTOS version of event_hook                                  */
/*                                                                           */
/*                                                                           */
/* TITLE:  BTOS SYSTEM SOFTWARE                                              */
/*                                                                           */
/*            PROPRIETARY PROGRAM MATERIAL                                   */
/*                                                                           */
/* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       */
/* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   */
/* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            */
/* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                */
/*                                                                           */
/*                                                                           */
/* COPYRIGHT (C) 1980, 1989 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED     */
/* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          */
/* ************************************************************************* */
/*                                                                           */
/* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      */
/* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      */
/* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        */
/* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   */
/* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         */
/* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 */
/*                                                                           */
/* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      */
/* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        */
/* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           */
/*                                                                           */
/*************************** END OF MODULE HEADER ****************************/

/*
	Copyright 1987-1990 XVT Software Inc. All rights reserved.
	May be used freely by licensed and registered users of XVT.
	May be distributed in source form only when embedded in XVT 
	user's application.
*/

#ifdef WSPM
#define  INCL_DOS
#define  INCL_WIN
#define  INCL_GPI
#define COLOR pm_COLOR
#define UINT pm_UINT
#define ULONG pm_ULONG
#include <os2.h>
#undef COLOR
#undef UINT
#undef ULONG
#define WINWORD long
#define MSG QMSG
#else
typedef int MSG;
#endif

#undef NULL
#include "xvt.h"

#define E_R_MOUSE_DOWN 1001



BOOLEAN XVTENTRY event_hook BTCENTRY (int type, EHOOK_STRUCT *ev_hook);
BOOLEAN pm_event_hook(int rid, BOOLEAN modal, MSG far *mp);
BOOLEAN ch_event_hook(int dlg_rid, BOOLEAN modal, int ctrl_rid, WINDOW win,
  EVENT *event);


/*
   Since XVT/CH and XVT/PM have different parameters to event_hook, we
   must provide a common interface.  EHOOK_STRUCT contains
   the parameters that are normally passed to event hook.  This function
   determines which event_hook to call based on the environment

*/


#ifdef FPROTO
BOOLEAN XVTENTRY event_hook BTCENTRY (int type, EHOOK_STRUCT *ev_hook)
#else
BOOLEAN XVTENTRY event_hook BTCENTRY (type, ev_hook)
int type;
					/* PMHOOK or CHHOOK */
EHOOK_STRUCT *ev_hook;
		/* bundled event_hook params */
#endif
{

	if (type == PMHOOK)
		return(pm_event_hook (ev_hook->dlg_rid, ev_hook->modal, 
			(MSG far *)ev_hook->event));
	else
		return(ch_event_hook (ev_hook->dlg_rid, ev_hook->modal, 
			ev_hook->ctrl_rid, ev_hook->win, ev_hook->event));
}

/*
	Function called on every event, whether in main event loop (rid == 0), modal
	dialog (rid != 0, modal == DLG_MODAL), or modeless dialog (rid != 0,
	modal == DLG_MODELESS). Return FALSE if event is to be thrown out; TRUE if
	to be processed normally. In the latter case the MSG pointed to by the mp
	argument can be modified by this function. Note that the time and pt
	members of the MSG structure are neither passed in to this function nor
	used by XVT upon return.

	For the main event loop, this function is called immediately when the
	window proc for an XVT non-dialog window is called. For dialogs, it is
	called when the dialog's (modal or modeless) window proc is called.

	This function is also called from the window proc for the modeless dialog
	that XVT puts up during printing.

	The disabled sample code here shows how to implement a right-button
	event. See the file DLG.C (distributed with XVT as an example) to see
	how this event is handled in an application.
*/
#ifdef FPROTO
BOOLEAN pm_event_hook(int rid, BOOLEAN modal, register MSG far *mp)
#else
BOOLEAN pm_event_hook(rid, modal, mp)
int rid;
BOOLEAN modal;
register MSG far *mp;
#endif
{
	NOREF(rid);
	NOREF(modal);
	NOREF(mp);
	return(TRUE);
}

#ifdef FPROTO
BOOLEAN ch_event_hook (int dlg_rid, BOOLEAN modal, int ctrl_rid, WINDOW win,
  EVENT *event)
#else
BOOLEAN ch_event_hook (dlg_rid, modal, ctrl_rid, win, event)
int dlg_rid;
BOOLEAN modal;
int ctrl_rid;
WINDOW win;
EVENT *event;
#endif
{
	NOREF(dlg_rid);
	NOREF(modal);
	NOREF(ctrl_rid);
	NOREF(win);
	NOREF(event);
	return(TRUE);
}
