# FindFile.awk -- reads two lists of files and reports common files
#
# Find File
#   First list file
#   Second list file
#   [Output file]

BEGIN {
	if (ARGV[1] == "") {
		print "First list file not specified."
		exit
	}
	file1 = ARGV[1]
	if (ARGV[2] == "") {
		print "Second list file not specified."
		exit
	}
	file2 = ARGV[2]
	if (ARGV[3] == "")
		outfile = "[vid]"
	else
		outfile = ARGV[3]
	ARGV[1] = ARGV[2] = ARGV[3] = ""

	while ((err = getline <file1) > 0)
		line[++nlines] = $0
	if (err == -1) {
		print "Can't access first list file."
		exit
	}
	if (nlines == 0) {
		print "First list file is empty."
		exit
	}
	close(file1)

	while ((err = getline <file2) > 0) {
		for (i in line) {
			if (found = match(line[i], $0))
				break
			if (found = match($0, line[i]))
				break
		}
		if (found)
			printf("%s:  %s\n", line[i], $0)
	}
}
