;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: CopyIo.asm                                                          *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:                                                              *;
;*                                                                           *;
;*        This module handles read/write requests                            *;
;*        from remote sources.                                               *;
;*                                                                           *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 08/28/89 120C/01 P. Campbell  / Master -> Server, Server -> Service       *;
;* 08/01/89 120C/00 Kevin Keeney / Removed bogus Xchg instructions in        *;
;*                                 CopyFromRemote and CopyToRemote.          *;
;*                                                                           *;
;* ---  ---                                                                  *;
;* 03/15/88  IK  Eliminated CdtEqu.edf - not used.                           *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED     *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;

$Include(:f0:ServerHwEqu.edf)

Public	CopyFromRemote, CopyToRemote

CopyIOCode	Segment Public 'code'

DATA SEGMENT PUBLIC 'DATA'
EXTRN  OsVersionNumber: WORD
DATA ENDS
DGroup GROUP DATA


Assume CS : CopyIOCode, DS : Nothing, Es: Nothing

bSlot	Equ	Byte Ptr  [Bp+10h]
ipSource	Equ	Dword Ptr [Bp+0Ch]
ipTarget	Equ	Dword Ptr [bp+08h]
wCount	Equ	Word Ptr  [Bp+06h]


;  CopyFromRemote: Procedure ( bSlot, pSource, pTarget, wCount );
;    Declare bSlot Byte,	/* slot # of remote processor */
;	     pSource Pointer,	/* a linear address */
;	     pTarget Pointer,	/* the local address */
;	     wCount Word;	/* # words to transfer */
;
;   Copy wCount words (16 bit) of data from the linear remote address pSource in
;   the remote processor in slot bSlot to pTarget in local space.

CopyFromRemote	Proc	Far
	Push	Bp
	Mov	Bp, Sp
	Mov	Al, bSlot
	Out	RemoteSlotPort, Al

;  source address is already byteswapped and is linearized.

	Les	Si, ipSource
	Mov	Ax, Es
	Mov	Bx, DS:Word Ptr[OsVersionNumber]
	Cmp	Bx, 0C00h
	Jge	OutputFR
	Xchg	Ax, Si
OutputFR:
	Out	Br0Port, Ax
	Inc	Ax
	Out	Br1Port, Ax		; so much for highas

;  high 12 bits of low 16 bits of address go into segment so
;  that we can address as much of remote memory as possible.
;  Note that the maximum transfer size is may be reduced to
;  64kb - 0Eh bytes if alignment is unfavorable

	Mov	Bx, Si
	And	Si, 0Fh			; remote offset
	Shr	Bx, 1			; right 4 == left 12
	Shr	Bx, 1
	Shr	Bx, 1
	Shr	Bx, 1
	Add	Bx, RemoteAddrBias	; remote segment
	Mov	Cx, wCount		; count is in words

;  Bx : Si is the remote source address in lowest terms
;  Cx is the count of words to move

	Les	Di, ipTarget
	Mov	Ax, Es

	Mov	Dx, Di			; working copy
	And	Di, 0Fh			; lowest terms of offset

	Shr	Dx, 1
	Shr	Dx, 1
	Shr	Dx, 1
	Shr	Dx, 1			; make into segment #
	Add	Ax, Dx
	Mov	Es, Ax

;  Target address now in lowest terms (segment + offset in 0..F)
;  and in Es : Di as required

	Push	Ds
	Mov	Ds, Bx
	Cld

Rep	Movsw

	Pop	Ds
	In	Al, MySlotPort
	Out	RemoteSlotPort, Al
	Pop	Bp
	Ret	12
CopyFromRemote	Endp


;bSlot	Equ	Byte Ptr  [Bp+10h]	; see above, commented out here
opSource  Equ	Dword Ptr [Bp+0Ch]
opTarget  Equ	Dword Ptr [bp+08h]
;wCount	Equ	Word Ptr  [Bp+06h]	; as in CopyFromRemote


;  CopyToRemote: Procedure ( bSlot, pSource, pTarget, wCount );
;    Declare bSlot Byte,	/* slot # of remote processor */
;	     pSource Pointer,	/* the local address */
;	     pTarget Pointer,	/* a linear address */
;	     wCount Word;	/* # words to transfer */
;
;   Copy wCount words (16 bit) of data from the pTarget in local space to
;   the remote processor in slot bSlot at the remote address pSource


CopyToRemote	Proc	Far
	Push	Bp
	Mov	Bp, Sp
	Mov	Al, bSlot
	Out	RemoteSlotPort, Al

;  target address is already byteswapped and is linearized.

	Les	Di, opTarget
	Mov	Ax, Es
	Mov	Bx, DS:Word Ptr[OsVersionNumber]
	Cmp	Bx, 0C00h
	Jge	OutputTR
	Xchg	Ax, Di
OutputTR:
	Out	Br0Port, Ax
	Inc	Ax
	Out	Br1Port, Ax		; so much for highas

;  high 12 bits of low 16 bits of address go into segment so
;  that we can address as much of remote memory as possible.
;  Note that the maximum transfer size is may be reduced to
;  64kb - 0Eh bytes if alignment is unfavorable

	Mov	Bx, Di
	And	Di, 0Fh			; remote offset
	Shr	Bx, 1			; right 4 == left 12
	Shr	Bx, 1
	Shr	Bx, 1
	Shr	Bx, 1
	Add	Bx, RemoteAddrBias	; remote segment
	Mov	Cx, wCount		; count is in words

;  Bx : Di is the remote target address in lowest terms
;  Cx is the word count to transfer

	Les	Si, opSource
	Mov	Ax, Es
	Mov	Es, Bx			; now set up target segment

	Mov	Dx, Si			; working copy
	And	Si, 0Fh			; lowest terms of offset

	Shr	Dx, 1
	Shr	Dx, 1
	Shr	Dx, 1
	Shr	Dx, 1			; make into segment #
	Add	Ax, Dx

;  Source address now in lowest terms (segment + offset in 0..F)
;  in Ax : Si

	Push	Ds
	Mov	Ds, Ax			; source addr now in DS : SI as hoped
	Cld

Rep	Movsw

	Pop	Ds
	In	Al, MySlotPort
	Out	RemoteSlotPort, Al
	Pop	Bp
	Ret	12
CopyToRemote	Endp

CopyIOCode	Ends

End
