; ICC_all.asm

$Include(:f1:Cdt.Mdf) 
$Include(:f1:SrpHw.mdf)
%SET(fDebugDma,0FFh)
%SET(Paranoid,1)
$Include(:f1:ICC.mdf)
%SET(ctosv,1)
$Include(:f1:Kernel.mdf)
$Include(:f1:fadstypesasm.edf)
$Include(:f1:descriptors.mdf)

%SET(fDebug,0)
%SET(fDebugRead,0)
%SET(fDebugRequest,0)
%SET(RequestStats,0)

%SET(IccDma,0FFh)
%SET(export,0ffh)

nullCpuId EQU 0F0h	; only valid in line table
%IF(%BMIC) THEN (
iSlotMax EQU 10
) ELSE (
iSlotMax EQU 37
)FI
oPbCbNul EQU 0

FALSE		EQU	0
TRUE		EQU	1
pRq			EQU	10			;stack argument
raRq		equ 10
saRq		equ 12

argbSlot	EQU 14
mask3ArgWords EQU 4
pcbUserNum	EQU 14
maskExchSlotBits EQU 0FC00h
maskSlot    EQU 03FFH       ;1024 usernums max
maskUserNum EQU 0FC00H

; request block
sCntlInfo	EQU 0
sCntInfo	EQU 0
rtInfo		EQU 1
nReqPbCb	EQU 2
nRespPbCb	EQU 3
rqUserNum	EQU	4
respExch	EQU	6
ercRet		EQU 8
rqCode		EQU	10
fh			EQU	12
fidFP		EQU 12
iLine		EQU 12
userId		EQU 12
sRqHeader	EQU 12

; net info
maskFh EQU 8h
maskOpenFh EQU 40h
maskCloseFh EQU 6h
maskSpecType	EQU	7
fileSpecP2S2	EQU	5

; routing info structure
rtiExch EQU 0
rtRtInfo EQU 2
rtSrpInfo EQU 2
rtNetInfo EQU 3

; controlInterrupt
bOpEnable      EQU 0
bOpDisable     EQU 1
tyDoorbell     EQU 14


ercOk					EQU 0
ercBadPointer			EQU	11
ercServiceNotAvail		EQU	33
ercNoYblks				EQU 104
ercWatchDog 			EQU 107
ercBadSequence 			EQU 112
ercNoFixupAvail			EQU 156
ercNoGhAvail			EQU 157
ercBadRouting			EQU 159
ercWait					EQU 162
ercCorruptIcc			EQU 163
ercOddCntlInfo			EQU 164
ercBadFh				EQU 210
ercLineNotConfigured	Equ	8602

PUBLIC	GRequestRemote	; for Kernel
PUBLIC	GSendRemote		; for Kernel
PUBLIC	RespondAlias	; for Kernel

EXTRN BmicInt: FAR
EXTRN Crash: FAR
EXTRN Check: FAR
EXTRN ControlInterrupt: FAR
EXTRN ForwardRequest: FAR
EXTRN ERequest: FAR
EXTRN ERequestDirect: FAR
EXTRN GRespond: FAR
EXTRN KernelExitDI: FAR
KernelExit EQU KernelExitDI
EXTRN KRespond: FAR
EXTRN KSendRequest: FAR
EXTRN Log: FAR
EXTRN RespondCommon: FAR
EXTRN InitSlotAddressTables: FAR
EXTRN MapBusAddress: FAR, UnmapBusAddress: FAR
%IF (%IccDma) THEN (
EXTRN DmaMoveComplete: FAR
EXTRN DmaAddrFromP: FAR
)FI
EXTRN PMyIcc: FAR
EXTRN ReleaseSg: FAR

DGroup	GROUP	Const, Data, Stack
Const	SEGMENT PUBLIC 'Const'
Const	ENDS

Stack SEGMENT WORD STACK 'STACK'
Stack ENDS

Data	SEGMENT	PUBLIC	'Data'

raLog DW 0
rgLogIcc DD 40h DUP(?)
PUBLIC raLog, rgLogIcc

%IF (%IccDma) THEN (
EXTRN	cphFileCache: DWORD
)FI
EXTRN	bMySlot: BYTE
EXTRN	iMySlot: BYTE
EXTRN	wMySlotBits: WORD
EXTRN	exchNet: WORD
EXTRN	prgcRq: DWORD
EXTRN	nUcb: WORD

EXTRN	rgPrgLocalServiceCode: DWORD
EXTRN	rgPrgRouting: DWORD
EXTRN	rgRcMax: WORD
EXTRN	rgIoDoorbell: WORD
EXTRN	rgIoDoornail: WORD
%if(%kernelhooks)then(
EXTRN	rgbkernelhookinfo:	DWORD
)fi

EXTRN	oPcbrun: WORD
EXTRN	oRgExchg: WORD
EXTRN	userNumPrimary: WORD
EXTRN	userNumLast: WORD
EXTRN	sgTssIntLast: WORD

EXTRN	nMinY: WORD, nMinZ: WORD, nMinW: WORD	;DHG
EXTRN	nAvailY: WORD, nAvailZ: WORD, nAvailW: WORD
EXTRN	nYblk: WORD, nZblk: WORD, nWblk: WORD
EXTRN	nMinYLocal: WORD, nMinZLocal: WORD, nMinWLocal: WORD	;DHG
EXTRN	nAvailYLocal: WORD, nAvailZLocal: WORD, nAvailWLocal: WORD
EXTRN	nYblkLocal: WORD, nZblkLocal: WORD, nWblkLocal: WORD

EXTRN	mpiLinebSlot:BYTE
EXTRN	cbLineTable:WORD
EXTRN	addr0: WORD
EXTRN	pCdt: DWORD
EXTRN	mpiSlotpCdt: DWORD
EXTRN	FilterProcessExch: WORD
EXTRN	oFixupFree: WORD
EXTRN	oFixupHead: WORD
EXTRN	qCdtCollision: DWORD
Extrn	bMasterFPcpuID : byte
Extrn	bMasterCPcpuID : byte
EXTRN	wMasterFPCdtBase: WORD
EXTRN	pMasterFPCdt: DWORD
%IF(%BMIC) THEN (
%*DEFINE(LESpCdt(ra))(
; Address Master PC Cdt
	LES	%ra, pMasterFPCdt
)
) ELSE (
%*DEFINE(LESpCdt(ra))(
; Address Master FP Cdt
	MOV	AL, bMasterFPCpuId
	MOV	DX, RemoteSlotPort
	OUT	DX, AL
	MOV	AX, wMasterFPCdtBase
	%OUTBaseRegsDX
	LES	%ra, pMasterFPCdt
)
)FI
EXTRN	vf: BYTE
$Include(:f1:vfEqu.idf)


;  Dispatch on Icc Routing type

	Even
PUBLIC	routeCase
RouteCase	Label	Word
	Dw	SrpLocal		; f0
	Dw	RequestToSlot	; f1 rRemote
	Dw	RequestToSlot	; f2 rMasterFp
	Dw	SrpHandle	    ; f3
	Dw	SrpFileId		; f4
	Dw	RequestToSlot	; f5 rMasterCp
	Dw	SrpLine			; f6
	Dw	SrpDevice		; f7
	Dw	SrpBroadcast	; f8
	Dw	SrpUserId		; f9 rUserId
	Dw	SrpBadRouting	; fa undefined
	Dw	SrpBadRouting	; fb undefined
	Dw	SrpBadRouting	; fc undefined
	Dw	SrpBadRouting	; fd undefined
	Dw	SrpBadRouting	; fe undefined
	Dw	SrpBadRouting	; ff undefined
iRemote EQU 1
rRemote EQU 0F1h
iDevice EQU 7
rDevice EQU 0F7h
maskSrpSlot EQU 7Fh
maskRouteCase EQU 0Fh	; also in kernel_all.asm

;	Stuff for ICC segment, buffer and rcb management
PUBLIC rgSyncOut, rgSyncIn, mpiSlotcOutstanding, mpiSlotUsernumMac
PUBLIC pRqWait, exchRqWait, cRqWait
PUBLIC rgSgIcc, rgBR0Icc, mpiSlotSg
PUBLIC mpbSlotiSlot, mpiSlotbSlot
PUBLIC mpiSlotbStatus, fAfterSync
PUBLIC mpiFPbSlot
PUBLIC nIccBuffers
PUBLIC psgMyIcc, psgRcbSeg, pfPcIcc, ppXferAreaRcv
PUBLIC sgIccFirst, sgIccLast

nIccBuffers DW ?

%IF(%Bmic) THEN (
rgSyncOut DW 10 DUP(0)			; rgSyncOut(iSlot) = number of last rq sent

rgSyncIn  DW 10 DUP(0)			; rgSyncIn(iSlot) = number of last rq received

mpiSlotcOutstanding DW 10 DUP(0); mpiSlotcOutstanding(iSlot)=number rq out

mpiSlotUsernumMac DW 10 DUP(0)	; mpiSlotUsernumMac(iSlot)=largest usernum seen

pRqWait		DD 0				; pRqWait is first rq blocked no free yBlk
exchRqWait	DW 0				; exchRqWait is rqs queued after pRqWait
cRqWait DW 0					; <> 0 triggers retry in Periodic.

rgSgIcc DW 10 DUP(0)			; sg of ICC seg on each board, 0=dead board
mpiSlotSg DW 10 DUP(0)			; sg preallocated
rgBR0Icc LABEL WORD				; unused

%' Pc is iSlot 1, bSlot 9
%' Comarch cards are iSlot 2-9, bSlot 1-8

mpbSlotiSlot DB 0
	 DB 02, 03, 04, 05, 06, 07, 08, 09, 01

mpiSlotbSlot DB 0
	 DB 9h, 1h, 2h, 3h, 4h, 5h, 6h, 7h, 8h
)ELSE(%'Mf

rgSyncOut DW 37 DUP(0)			; rgSyncOut(iSlot) = number of last rq sent

rgSyncIn  DW 37 DUP(0)			; rgSyncIn(iSlot) = number of last rq received

mpiSlotcOutstanding DW 37 DUP(0); mpiSlotcOutstanding(iSlot)=number rq out

mpiSlotpRqWait		DD 37 DUP(0); pRqWait is first rq blocked no free yBlk
mpiSlotExchRqWait	DW 37 DUP(0); exchRqWait is rqs queued after pRqWait
cRqWait DW 0					; <> 0 triggers retry in Periodic.

rgSgIcc DW 37 DUP(0)			; sg of ICC seg on each board, 0=dead board
rgBR0Icc DW 37 DUP(0)			; BR0 of ICC seg on each board

mpbSlotiSlot LABEL BYTE
	 DB 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00 ;0h
	 DB 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00 ;10h
	 DB 00, 31, 32, 33, 34, 35, 36, 00, 00, 00, 00, 00, 00, 00, 00, 00 ;20h
	 DB 00, 25, 26, 27, 28, 29, 30, 00, 00, 00, 00, 00, 00, 00, 00, 00 ;30h
	 DB 00, 19, 20, 21, 22, 23, 24, 00, 00, 00, 00, 00, 00, 00, 00, 00 ;40h
	 DB 00, 13, 14, 15, 16, 17, 18, 00, 00, 00, 00, 00, 00, 00, 00, 00 ;50h
	 DB 00, 07, 08, 09, 10, 11, 12, 00, 00, 00, 00, 00, 00, 00, 00, 00 ;60h
	 DB 00, 01, 02, 03, 04, 05, 06, 00, 00, 00, 00, 00, 00, 00, 00, 00 ;70h


mpiSlotbSlot DB 0
			 DB 71h, 72h, 73h, 74h, 75h, 76h		; 1 -6
			 DB 61h, 62h, 63h, 64h, 65h, 66h		; 7 -12
			 DB 51h, 52h, 53h, 54h, 55h, 56h		; 13-18
			 DB 41h, 42h, 43h, 44h, 45h, 46h		; 19-24
			 DB 31h, 32h, 33h, 34h, 35h, 36h		; 25-30
			 DB 21h, 22h, 23h, 24h, 25h, 26h		; 31-36
)FI

fAfterSync DB 0
mpiSlotbStatus DB 37 DUP(0)
EVEN

mpiFPbSlot   DB 8 DUP(?)

;	PLM needs DGroup pointers to variables not in DGroup.
psgRcbSeg DD sgRcbSeg
psgMyIcc DD sgMyIcc
pfPcIcc DD fPc
ppXferAreaRcv DD pXferAreaRcv

; Set in InitMf, constants after init.
sgIccFirst DW ?
sgIccLast DW ?

; sgTermTable is created in InitKernel
PUBLIC sgTermTable
sgTermTable DW 0
	
; debugging variables
%IF(%fDebug) THEN (
PUBLIC wTrapRqCode, wTrapUserNum
wTrapRqCode DW 0
wTrapUserNum DW 0FFFFh
)FI
%IF(%RequestStats) THEN (%'
cQuadMax EQU 700
PUBLIC mpcQuadcPbCb
mpcQuadcPbCb DD cQuadMax DUP(0)
)FI%'

cbRetIgnore DW ?		; For MapBusAddress

fWaitSatisfied DB 0

PUBLIC mpiHeapcBlk, paXferAreaRcv, oRcbDmaRcvHead, dmaIob, iPa, rgPa
			DB lAlloc			; Prevent combine with "previous" node
mpiHeapcBlk DB 80, 79 DUP (0)
			DB lAlloc+48		; Prevent combine with "next" node (rcv area)

EVEN
oRcbDmaRcvHead DW ?
dmaIob DB 34 DUP(?)
iPa DW ?
rgPa DD 17 DUP(?)

EVEN
PUBLIC paXferAreaXmit
paXferAreaXmit DD ?

fXmitBufAllocFails DW FALSE

%IF(%fDebugDma) THEN (
PUBLIC iLogDma
iLogDma		DW 0
rgLogDma	DB 10h DUP(0)
)FI

PUBLIC exchObit
exchObit DW ?

tyLogOsMisc 			EQU 0FFF1h
tyLogOsErc 				EQU 0FFF2h
tyOsErcKilledBoard		EQU 77
liMsgKilledBoard		EQU 60009
logDoornail LABEL BYTE
	DW	tyLogOsMisc
	DW	liMsgKilledBoard
	DW	ercCorruptIcc
logDoornailbSlot LABEL BYTE
	DW	?,?,?
logDoornailRgSb LABEL BYTE
	DB	0
sLogDoornail EQU 13

Data	ENDS


Kernel	SEGMENT	PUBLIC	'Code'
KGroup GROUP Kernel
ASSUME	CS: KGroup, DS: DGroup

EXTRN CreateIPCAlias:Near
EXTRN ServiceNotAvail:Near
EXTRN RouteRequestLocal:Near
EXTRN RespondCheckSwap:Near
EXTRN RequestDirectEntry:Near
EXTRN ForwardRequestEntry:Near


;	Some variables are in the code segment so they are available
;	even when screwing around with DS.  InitMF sets them.

;cbDmaMax EQU 4096
cbDmaMax EQU 5120
cbDmaRcvMax EQU 6144	; 6K

dZero DD .+4, 0

PUBLIC pXferAreaRcv
pXferAreaRcv  DW 2800h
sgXferArea DW ?
paXferAreaRcv DD ?

PUBLIC sgRcbSeg, sgMyIcc, pRgpBuffer, pRgPaBuffer, sgMyShadow
sgRcbSeg DW ?
sgMyIcc DW ?
paMyIcc DD ?
pRgpBuffer DD ?
pRgPaBuffer DD ?
sgMyShadow DW ?
fPc DB ?

;	Code to route by the srp routing code
;	DH is net info
;	CX is exchange with slot bits
;	We must not disturb CX if routing becomes local

Public SrpLocal
SrpLocal:
; If spec routed send to filter process else to service exchange.
	TEST	DH, maskSpecType
	JZ		RequestToSlot		; exchNotInstalled,rLocal -> rRemote exchAgent
SrpFilterProcess:
Public SrpBroadcast
SrpBroadcast:
	MOV		CX, FilterProcessExch
SrpRRLocal:
	JMP		RouteRequestLocal


SrpHandle:
	MOV		AX, ES: [BX+fh]
	CMP		AX, 0FFFFh			; Some old AWS210 hack.
	JE		BadFh

	MOV		AL, AH				; bits 10,11,12 of handle are FP index
	SHR		AL, 1
	SHR		AL, 1
	AND		AL, 7
	CBW
	XCHG	AX, SI
	MOV		AL, mpiFPbSlot[SI]
RtsAL:
	CMP		AL, bMySlot
	JE		SrpRRLocal			; routes by CX
; AL(bSlot) -> CX(0+slot bits)
	CBW
	XCHG	AX, SI
	MOV		CH, mpbSlotiSlot[SI]
	SHL		CH, 1
	SHL		CH, 1
	XOR		CL, CL
	JMP		RequestToSlot

BadFh:
	MOV		AX, ercBadFh
	JMP		KernelExit


SrpFileID:
	MOV		AL, ES: [BX+fidFP]
	JMP		Short RtsAL


SrpLine:
	MOV		SI, ES: [BX+iLine]
	AND		SI, 7Fh		; take off wsid and bit 8 for new cluster status info.
	SHL		SI, 1
	CMP		SI, cbLineTable
	JAE		NoSuchLine
	MOV		AL, mpiLinebSlot[SI]
	CMP		AL, nullCpuId
	JNE		Short RtsAL

NoSuchLine:
	MOV		AX, ercLineNotConfigured
	JMP		KernelExit


SrpUserID:
	MOV		SI, ES: [BX+userId]
	SHR		SI, 10
; If userNum out of bounds must be net user, send to board where net installed.
	CMP		SI, iSlotMax
	JBE		SUIbSlot
	MOV		SI, exchNet
	SHR		SI, 10
SUIbSlot:
	MOV		AL, mpiSlotbSlot[SI]
	JMP		Short RtsAL


SrpDevice:
	OR		DH, DH				; net info = noRouting?
	JZ		SrpFilterProcess	; Filter process broadcasts noRouting.
	TEST	DH, maskFh
	JNZ		SrpDeviceHandle		; rFh
;	rSpec
	AND		DH, maskSpecType
	JZ		SrpRRLocal
	CMP		DH, fileSpecP2S2
	JBE		SrpFilterProcess	; Filter process handles rSpec
	JMP		SrpRRLocal

SrpDeviceHandle:; Route by global handle, or substitute local handle.
	CALL	MapGlobalHandle
	JC		RtsAL	; handle routes remotely, al has slot
; handle routes locally, AX contains erc from MapGlobalHandle

	OR		AX, AX
	JNZ		SrpError
	JMP		RouteRequestLocal


SrpBadRouting:
	MOV		AX, ercBadRouting
SrpError:
	JMP		KernelExit

RespondCheckSwap2:
	POP		BX
	POP		ES				;ES:BX points to request block

RespondCheckSwap1:
	JMP		RespondCheckSwap

RespondAlias:
;	Calculate level, request code from request #
	MOV		AX, ES: [BX+rqCode]		;i = rq.rqCode;
	MOV		SI, AX
	SHR		AH, 4
	MOV		AL, AH
	CBW						;AX is request level

	XCHG		AX, SI			;SI=level, AX=req #
	CMP		AX, 0FFE0h		;>= -32 ?
	JB		NotUsrRespond
	MOV		SI, 16			;Usr is "level 16"
	NOT		AX			; ,indexes in reverse order.

NotUsrRespond:
	AND		AH, 0Fh			;Strip away level bits

	SHL		SI, 1			;index word array
	CMP		AX, rgRcMax[SI]		;IF rcode > rgRcMax(level)
	JAE		RespondCheckSwap1

	SHL		SI, 1			;index ptr array
	push		es
	push		bx

	LES		BX, rgPrgLocalServiceCode[SI]	;prgLocalServiceCode(level)
	ADD		BX, AX							;add rcode twice -> word index
	ADD		BX, AX							;@rgLocalServiceCode(rcode)
	CMP		WORD PTR ES:[BX], 0A3D1h
	JE		RespondCheckSwap2				;if localServiceCode = lDummyLSC

	LES		BX, rgPrgRouting[SI];@rgPrgRouting(level)
	XCHG		AX, SI			;AX=level*4, SI=rcode
	SHL		SI, 1
	SHL		SI, 1
;	MOV		CX, ES: [BX][SI+rtiExch]
	MOV     CX, DX		; save slot which responded
	MOV		DX, ES: [BX][SI+rtRtInfo]	; DL = srp info  DH = net info

	pop		bx					;ES:BX points to request block
	pop		es

	MOV		AL, DL
	AND		AL, notMaskRtDma
	CMP		AL, iDevice
	JNE		RespondCheckSwap1

	PUSH	DI
	TEST	DH, maskOpenFh
	JNZ		OpenGh
	JMP		DeAliasGh

PUBLIC OpenGh
OpenGh:
; This is respond to openFh request.  Record handle in Cdt routing table,
; substitute global handle.
	CMP	WORD PTR ES:[BX+ercRet], 0	;rq.ercRet = ercOk
	JE	RqErcOk
	JMP	DoRespond
NoGhAvail:
	JMP	DoNoGhAvail
RqErcOk:
	MOV	DX, ES:[BX+rqUserNum]
	MOV	AL, ES:[BX+nReqPbCb]
	MOV	AH, 6
	MUL	AH		; AH becomes 0
	ADD	AL, ES:[BX+sCntlInfo]
;	ADC	AH, 0		; rq size always < 256 (<64).
	ADD	BX, AX
;	ADD	BX, sRqHeader	; ES:BX -> rq.pbcbResp
	LES	BX, DWORD PTR ES:sRqHeader[BX]	; pFhRet
	TEST	BYTE PTR ES:[BX+1], 80h		; Net handle?  Then don't touch fhRet.
	JNZ	DoRespond						; So rDevice fh across net gets to net.
	PUSH	ES		; save pFhRet
	PUSH	BX
	PUSH	CX		; save Respond slot
	PUSH	WORD PTR ES:[BX]	; save fhRet
	PUSH	DX		; save rq.userNum

	%LESpCdt(DI)	; address master fp cdt
	CLI
	CALL	OkToSend	; Lock master fp cdt
	MOV	DX, DI		; save cdt base
	%Peekw	ECX, ES:oHandleFree[DI]
	OR	CX, CX
	JZ	NoGhAvail
	ADD	DI, CX		; DI -> route record
	%Peekw	EAX, ES:ghLink[DI]
	XCHG	DI, DX	; DI -> cdt
	%Pokew	ES:oHandleFree[DI], AX

	%Peekb	ECX, ES:verifyCode[DI]	;for cluster-to-master routing
	MOV	CH, CL
	XOR	CL, CL
; Unlock cdt
	%Pokeb	ES:fLockByte[DI], CL	; 0
	XCHG	DI, DX	; DI -> route record
; Build Global Handle routing record
	ROR	CH, 3		; SHL(verifyCode,13) == MOV CH, verifyCode; ROR CH,3
	%Peekw	EBX, ES:ghGh[DI]
	OR	CX, BX		; free records contain own index as gh
	POP	BX
	%Pokew	ES:ghUserNum[DI], BX
	POP	BX
	%Pokew	ES:ghHandle[DI], BX
	POP	BX
	%Pokeb	ES:ghSlot[DI], BL
	POP	DI
	POP	ES		; pFhRet
	MOV	ES:[DI], CX		; substitute Gh

DoRespond:
	POP	DI	; restore exit code
; Now, respond
	LES	BX, DWORD PTR [BP+pRq]	;ES:BX points to request block
	PUSH		[BP+4]
	POPF					;Set user flags (enable)
	JMP	RespondCheckSwap

DoNoGhAvail:
	ADD	SP, 10		; Gh record
	XCHG	DI, DX	; DI -> cdt
; Unlock cdt
	%Pokeb	ES:fLockByte[DI], CL	; 0
; Erc to client, not caller of Respond.
	LES	BX, DWORD PTR [BP+pRq]	;ES:BX points to request block
	MOV	ES:WORD PTR [BX+ercRet], ercNoGhAvail
	JMP	DoRespond


PUBLIC DeAliasGh
DeAliasGh:
	TEST	DH, maskFh
	JZ	DoRespond	; If not rtFh no more gh work.
	TEST	BYTE PTR ES:[BX+Fh+1], 80h	; Net handle?
	JNZ	DoRespond						; Then no Fixup was done.

	CLI
	MOV	DI, OFFSET DGroup:oFixupHead
FixupLoop:
	MOV AX, DI		; save oLastFixup
	MOV	DI, DS:fixupLink[DI]
	OR	DI, DI
	JZ	TestClose	; If no fixup block available, punt.
	CMP	DS:fixupRa[DI], BX
	JNE	FixupLoop
	MOV	CX, ES
	CMP	DS:fixupSa[DI], CX
	JNE	FixupLoop

	MOV	CX, DS:fixupGh[DI]	; Apply fixup
	MOV	ES:[BX+Fh], CX
	MOV	CX, oFixupFree		; Free fixup block
	XCHG	CX, DS:fixupLink[DI]
	MOV	oFixupFree, DI
	XCHG	AX, DI			; DI -> prev in-use block
	MOV	DS:fixupLink[DI], CX	; repair in-use list

TestClose:
	AND	DH, maskSpecType
	CMP	DH, maskCloseFh
	JNE	DoRespond
	CMP	WORD PTR ES:[BX+ercRet], 0	;rq.ercRet = ercOk
	JNE	DoRespond
	PUSH	ES:[BX+Fh]
	%LESpCdt(DI)
	CALL	OkToSend	; Lock master fp cdt
	POP	AX
	MOV	DX, AX
	AND	AH, maskGlobalHandleHigh
%IF(0) THEN (
;	MUL immediate not in instruction set. Shift and add to get *5.
%IF(sHandleRecord EQ 5) THEN (
	MOV	CX, AX	; gh
	SHL	AX, 1
	SHL	AX, 1	; gh*4
	ADD	AX, CX	;+gh
) ELSE (%' sHandleRecord EQ 6
	SHL	AX, 1	; gh*2
	MOV	CX, AX
	SHL	AX, 1	; gh*4
	ADD	AX, CX	;+gh*2
)FI
)FI%'
	IMUL	AX, sHandleRecord

	%Peekw	ECX, ES:oHandleTable[DI]
	MOV	BX, DI			; ES:BX -> master fp cdt
	ADD	DI, CX			; ES:DI -> routing table
	ADD	DI, AX			; ES:DI -> routing record
	ADD	CX, AX			; CX is oRecord
	%Pokew	ES:ghGh[DI], DX
	%Pokeb	ES:ghSlot[DI], 0	; Mark as free for termination scanning.
	%PXchgw	CX, ES:oHandleFree[BX]
	%Pokew	ES:ghLink[DI], CX
	%Pokeb	ES:fLockByte[BX], 0
	JMP	DoRespond

; Lock the remote CDT, using exponential backoff if collision
; ES:DI		cdt

OkToSend:
	Mov	Bx,1			; Initial collision wait flag
TryAgain:
	Cli
	Mov	Al, 0FFh		; .7 Set => Lock it
	%PXchgb	AL, Es : fLockByte[Di]
	Or	Al,Al
	Jns	LockedIt		; If result is signed, try again
           
	Sti
	INC	WORD PTR qCdtCollision
	ADC	WORD PTR qCdtCollision+2, 0
	Mov	Cx, Bx
	Rol	Bx, 1
Here:	Loop	Here
	Jmp	TryAgain

LockedIt:
	RET


PUBLIC MapGlobalHandle
MapGlobalHandle PROC NEAR
; on entry: es:bx is pRq, DI is kernel exit code, ds is ours.
; on return: carry is set if gh routes to remote slot, AL has slot
;			 carry is clear if gh routes local, AX has erc
; ruins AX, SI
; 
	MOV		AX, ES:[BX+Fh]
	AND		AH, maskGlobalHandleHigh
	PUSH	AX
	%LESpCdt(BX)
	POP		AX
	%Peekw	ESI, ES:sHandleTable[BX]
	CMP		AX, SI
	JAE		Mgh_BadFh
	%Peekw	ESI, ES:oHandleTable[BX]
	ADD		BX, SI
	IMUL	AX, sHandleRecord
	ADD		BX, AX	; Now addressing handle record
	%Peekw	EAX, ES:ghSlot[BX]
	CMP		AL, bMySlot
	JNE		Mgh_RequestRemote
; Destination is this cpu

	%Peekw	EAX, ES:ghHandle[BX]		; AX = handle known to server.
	LES		BX, DWORD PTR [BP+pRq]
	XCHG	AX, ES:[BX+Fh]		; AX = gh, request block has server handle.
;	Create de-alias record if necessary (rq not copy in ICC Y/ZBlk).
	MOV		DL, BYTE PTR ES:[BX+respExch+1]	; derive source slot from exchResp
	SHR		DL, 2
	JZ		Mgh_CreateFhFixup
	CMP		DL, iMySlot
	JNE		Mgh_RouteLocal; Note - DH contains netInfo, never mind what DL has.
							; respExch is remote, no fixup needed for request 
							; block in icc buffer

Mgh_CreateFhFixup:
; create a fixup for Request or RequestDirect. ForwardRequest should get
; a fixup - we'd have to mark the fixup record to know to delias
; twice on Respond.
;
	TEST	DI, lcRqInc		; Request or RequestDirect	
	JZ		Mgh_RouteLocal

	CLI

	MOV		SI, oFixupFree		; Remove fixup block from free list.
	OR		SI, SI
	JZ		Mgh_NoFixupAvail
	PUSH	DS:fixupLink[SI]
	POP		oFixupFree
	MOV		DS:fixupRa[SI], BX	; Fill out fixup block.
	MOV		DS:fixupSa[SI], ES
	MOV		DS:fixupGh[SI], AX
	PUSH	oFixupHead		; Link fixup block to active list
	POP		DS:fixupLink[SI]
	MOV		oFixupHead, SI

	PUSH		[BP+4]
	POPF					;Set user flags (enable)

Mgh_RouteLocal:
	XOR		AX, AX	; cf = 0
	RET 			;ES:BX points to request block, CX=exchange

Mgh_RequestRemote:
	LES		BX, DWORD PTR [BP+pRq]	;ES:BX points to request block
	STC
	RET

Mgh_NoFixupAvail:
	XCHG	AX, ES:[BX+Fh]		; AX = server handle, request block has gh.
	mov	AX, ercNoFixupAvail
	CLC
	RET

Mgh_BadFh: 
	MOV		AX, ercBadFh
	CLC	
	RET

MapGlobalHandle ENDP

; ****************  Kernel Entry Points  *****************


;*****************************************************************************
;
;	RequestRemote: PROCEDURE(exch, pRq) ErcType REENTRANT;
;
;*****************************************************************************
%EnterKernel(RequestRemote, l3Argw + lExchArg + lcRqInc, fStackSwitch + fKCall, lRequestDirectHook) 

; Make argument exchDirect (0+slot bits) instead of bSlot.
; RequestDirectEntry code is in common with RequestDirect.
	MOV		SI, [BP+argbSlot]
	AND		SI, maskSrpSlot
; Make AX 0+slot bits for RequestToSlot.
	MOV		AH, mpbSlotiSlot[SI]
	SHL		AH, 1
	SHL		AH, 1
	XOR		AL, AL
	MOV		[BP+argbSlot], AX
	JMP		RequestDirectEntry; In Request in Kernel_all.

;*****************************************************************************
;
;	SendRemote: PROCEDURE(exch, pRq) ErcType REENTRANT;
;
;*****************************************************************************
%EnterKernel(SendRemote, l3Argw + lExchArg + lNoRqLookup + lMsgRqUsernum, fStackSwitch + fKCall, lForwardRequestHook)

; Make argument exchDirect (0+slot bits) instead of bSlot.
; ForwardRequestEntry code is in common with ForwardRequest.
	MOV		SI, [BP+argbSlot]
	AND		SI, maskSrpSlot
; Make AX 0+slot bits for RequestToSlot.
	MOV		AH, mpbSlotiSlot[SI]
	SHL		AH, 1
	SHL		AH, 1
	XOR		AL, AL
	MOV		[BP+argbSlot], AX
	JMP	ForwardRequestEntry

;*****************************************************************************
;
;	KRespondFromRemote: PROCEDURE(pRq) REENTRANT;
;
;*****************************************************************************
;	DL = remote slot 
%EnterKernel(RespondFromRemote, l2Argw + lcRqDec + lMsgRqUsernum, fStackSwitch + fKCall, lRespondHook) 
	JMP		RespondCommon

; ****************  Buffer Management  *****************

RespondpRqError:
	PUSH	ercBadpRq
	CALL	Crash


RespondBadExch:
	%POPMF_AX			; restore remote reg's 
	POP	DI
	MOV	AX, ercExchOutOfRange
	JMP	KernelExit
	
OrphanError:
	%POPMF_AX			; restore remote reg's 
	POP	DI
	MOV AX, ercOrphanRq
	JMP	KernelExit

NoFreeRcb:
	%POPMF_AX			; restore remote reg's 
	POP	DI
	MOV	AX, ercNoFreeRcb
	JMP	KernelExit

RBDError:
	SHL	SI, 1
	JMP	RemoteBoardDead

MultiHopToSlot:
;	Multi-hop request i.e. rq already in icc buffer.
;	Send buffer on to new destination by Respond, Request
	OR	WORD PTR [BP-2], lMultiHop
	MOV	rcb_fFree, TRUE
	MOV	EAX, ES:buf_pa-buf_rq[BX]
	MOV	rcb_baRemote, EAX
	TEST	fPc, 0FFh
	JZ	MultiHopEntry
; PC must fill buffer header before sg lost
	MOV	AL, bMySlot
	MOV	ES:BYTE PTR buf_bSlotSync-buf_rq[BX], AL
	MOV	ES:WORD PTR buf_exchDirect-buf_rq[BX], CX
	MOV	DI, CX
	SHR	DI, 10
	SHL	DI, 1
	CLI						; SyncOut is atomic with Put below.
	MOV	AX, rgSyncOut[DI]
	INC	AX
	MOV	rgSyncOut[DI], AX
	MOV	ES:buf_sync-buf_rq[BX], AX
	JMP	Short MultiHopEntry


PUBLIC RespondToSlot
RespondToSlot:
;	DI		Kernel exit
;	ES:BX	pRq

	PUSH	DI		; RingDoorbell uses wDI for kernel exit.
	%PUSHMF_AX

;;	Check Cdt.fDead, Crash(ercWatchdogTooSlow)

MultiHopEntry:
;	If pRq not in an Icc segment, the exchange was fooled with and the kernel
;	thought it had an off-board rq.  Return ercBadExch.
	TEST	fPc, 0FFh
	JNZ	FindBufHeader
	MOV	AX, ES
	CMP	AX, sgIccFirst
	JB	RespondBadExch
	CMP	AX, sgIccLast
	JA	RespondBadExch
FindBufHeader:
	
;	Count back from rq to buf header
	SUB	BX, OFFSET buf_rq
	JB	RespondpRqError
;	ES:BX		pBuf

	MOV	CX, ES:buf_wRcb[BX]			; wRcb for Put Respond below
	MOV	SI, ES:WORD PTR buf_rq[BX+respExch]
	AND	SI, 7FFFh					; remove icc force bit
	SHR	SI, 10						; iSlot

%IF(%BMIC) THEN (
	TEST fPc, 1
	JZ	RespondBmic

	PUSH	CX
	PUSH	SI
userNumOs EQU 0FFFFh
liNull EQU 0FFFFh
	PUSH	ES
	PUSH	userNumOs
	PUSH	liNull
	CALL	ReleaseSg
	POP	SI
	POP	CX
	JMP	RespondBuf

RespondBmic:
; Dma pbcbResp data to buf_baRemote
; ES:buf_ is local shadow buffer
;  buf_cbReq rounded to quad is offset of resp data.
	MOV	AX, ES:WORD PTR buf_rq[BX+ercRet]
	CMP	AX, ercOk
	JE	RTSNoErc
	MOV	EDI, ES:WORD PTR buf_pa[BX]
	%PokewPa	buf_rq[EDI+ercRet], AX
RTSNoErc:

	ROL	ECX, 16
	MOV	CX, SI			; save iSlot, wRcb
	ROL	ECX, 16

	MOVZX	EAX, ES:buf_cbReq[BX]
	ADD	AX, 3			; Data on
	AND	AL, 0FCh		;  dword boundaries.
	MOV	DI, ES:buf_cb[BX]
	SUB	DI, AX			; cbRespData
	JBE	FreeShadow
	TEST	WORD PTR [BP-2], lMultiHop
	JNZ	FreeShadow

	%RcbNew
;	RcbNew copied [BP+pRq] to rcb_pRq
	MOV	rcb_fFree, TRUE				; not a keeper
	MOV	WORD PTR rcb_pRq, BX		; use rcb_pRq for pBufShadow

	PUSH	ECX						; iSlot, wRcb

	MOVZX	EBX, BX
	LEA	ESI, DS:buf_rq[EBX][EAX]	; oRespData
	MOV	rcb_oData, SI
	MOV	rcb_cbResp, DI

	MOVZX	ECX, DI
	CMP	CX, cbDmaMax
	JB	RTSDoXa
	MOV	CX, cbDmaMax
RTSDoXa:
	%XferAlloc						; EAX -> ECX bytes of Xfer area
	MOV	rcb_raXfer, AX

	%ClaimXmitDma

	MOVZX	ECX, rcb_cbResp
RTSIterate:
;	ECX		cb
	CMP	CX, cbDmaMax
	JB	RTSDoMovs
	MOV	CX, cbDmaMax
RTSDoMovs:
	MOV	DX, CX					; Save DX=cb for dma after movs

	MOV	FS, WORD PTR rcb_pRq+2
ASSUME FS:iccBufferType
	MOV	SI, rcb_oData
	MOV	ES, sgXferArea
ASSUME ES:Nothing
	MOV	DI, rcb_raXfer

; Move FS:buf_rq[EBX][EAX] to Xfer area
	%RepMOVS FS
	MOV	rcb_oData, SI

;	XOR	CX, CX
	MOV	FS, CX	; 0 for luck
ASSUME FS:Nothing

	LES	BX, rcb_pRq				; pBuf
;	ES:BX		pBuf
;	DX			cb

; Dma Xfer area to remote buf
	MOV	EDI, ES:WORD PTR buf_pa[BX]
	MOV	CX, ES:buf_cbReq[BX]
	ADD	ES:buf_cbReq[BX], DX	; DX bytes this iteration
	LEA	EDI, DS:buf_rq[EDI+3][ECX]		; +cbReq, +3 for data on
	AND	DI, 0FFFCh		;  dword boundaries.
	MOV	AX, rcb_raXfer

;	AX			raXferArea
;	EDI		paBuf
;	DX			cb

	SUB	rcb_cbResp, DX
	%PerformXmitDma DX
	MOVZX	ECX, rcb_cbResp
	OR	CX, CX
	JNZ	RTSIterate

;	Free xfer area
	MOVZX	EBX, rcb_raXfer
	%XferFree		; BX = raXfer

	POP	ECX			; iSlot, wRcb
	LES	BX, DWORD PTR rcb_pRq	; pBuf really
FreeShadow:
;	ECX		iSlot, wRcb
;	ES:BX	pBuf
;	Free local buffer
	XCHG	EAX, ECX
	MOV	CX, ES
	SHL	ECX, 16
	MOV	CX, BX
	MOV	BX, ES:buf_cb[BX]
	MOV	ES, sgMyShadow
ASSUME ES:iccBufferListFreeType
	MOV	DI, OFFSET listFreeZ
	CMP	BX, ES:cbEach[DI]
	JBE	FreeLocalBuffer
	MOV	DI, OFFSET listFreeY
	CMP	BX, ES:cbEach[DI]
	JBE	FreeLocalBuffer
	MOV	DI, OFFSET listFreeW
FreeLocalBuffer:
ASSUME ES:iccSegType
;	ES			sgMyIcc
;	ECX			pBuf
;	DI			oFreeList
	%Free ECX into ES list DI using BX,SI leave sti
	JNZ CorruptLocalBufferQueue

	XCHG	EAX, ECX
	MOV	ESI, ECX
	SHR	ESI, 16	; iSlotBufOwner

RespondBuf:
)FI%' BMIC

	MOV	ES, sgMyIcc
ASSUME ES:iccSegType

;	ES			sgMyIcc
;	SI			iSlotBufOwner
;	CX			wRcb

	SHL	SI, 1
	CLI		; atomically check obit & cOutstanding so cleanup only once
	DEC	mpiSlotcOutstanding[SI]
	SHR	SI, 1
	MOVZX	EAX, ES:BYTE PTR rgObit[SI]
	CMP	AL, lObitAlive
	JNE	RBDError
;	Pc multihop all cli atomic, test before POPF
	TEST	WORD PTR [BP-2], lMultiHop
	JNZ	MultiHopRequest
	PUSH	[BP+4]
	POPF

;	Put buf.wRcb on remote board Respond list
	SHL	SI, 1
	MOV	AX, rgSgIcc[SI]
	OR	AX, AX
	JZ	FirstRespond
ResumeFirstRespond:
	MOV	ES, AX

	%Peekw	EAX, ES:wSignature
	CMP	AX, lSigIcc
	JNE	RemoteBoardDead

%Log(Rs,CX)
	%Put CX into ES list listRespond using BX,DI leave userFlags
	JNZ CorruptRemoteQueue

;	Ring doorbell
	SHR	SI, 1
	JMP	RingDoorbell

MultiHopRequest:
ASSUME DS:DGroup
;	SI		iSlotFrom
	MOV	DI, exchDirect
	SHR	DI, 10
	SHL	DI, 1
	MOV	ECX, rcb_baRemote
	TEST	fPc, 0FFh
	JNZ	MHRCont

;	Comarchs must fill out buffer header
	MOV	AL, bMySlot
	%PokebPa	buf_bSlotSync[ECX], AL
	MOV	AX, exchDirect
	%PokewPa	buf_exchDirect[ECX], AX

	CLI						; SyncOut is atomic with Put below.
	MOV	AX, rgSyncOut[DI]
	INC	AX
	MOV	rgSyncOut[DI], AX
	%PokewPa	buf_sync[ECX], AX

MHRCont:
	MOV	DS, rgSgIcc[DI]
ASSUME DS:iccSegType

	%Put ECX into DS list listRequest using BX,SI leave cli
; left cli so rcb safe until we FreeXmitDma below
	XCHG	SI, DI
	JNZ CorruptRemoteRequestQueue	; Remember to UnmapBusAddress!
	SHR		SI, 1
	JMP	RingDoorbell

CorruptLocalBufferQueue:
	JMP	DoCrashCorruptQueues

ASSUME DS:DGroup
FirstRespond:
;	CX	wRcb
;	SI	iSlot*2
	PUSH	CX
	PUSH	SI
	PUSH	BX
	PUSH	DI

	SHR	SI, 1
	MOV	AL, mpiSlotbSlot[SI]
	PUSH	AX
	CALL	InitSlotAddressTables
;	Ignore erc, use rgSgIcc=0 for error check

	POP	DI
	POP	BX
	POP	SI
	POP	CX

	MOV	AX, rgSgIcc[SI]
	OR	AX, AX
	JNZ	ResumeFirstRespond

CorruptRemoteQueue:
; Queue on remote board has iPut -> Non-zero.  Cannot talk to him.
; Pretend board is dead.

CorruptRemoteRequestQueue:
; Remote board queue iPut -> Non-zero.
; Pretend board dead.

PUBLIC RemoteBoardDead
RemoteBoardDead:
;	SI		iSlotDead*2
	CMP	SI, liSlotPc*2
	JNE	RemoteBoardDoornail
	PUSH	ercWatchdog
	CALL	Crash

RemoteBoardDoornail:
	MOV	AX, DGroup
	MOV	DS, AX
ASSUME DS:DGroup
	SHR	SI, 1
	%Doornail

	MOV	ES, rgSgIcc[SI]
ASSUME ES:iccSegType
	%Pokew	ES:wSignature, 0
	MOV	rgSgIcc[SI], 0

	SHR	SI, 1
	MOV	AL, mpiSlotbSlot[SI]
	MOV	logDoornailbSlot, AL
	PUSH	DS
	PUSH	OFFSET logDoornail
	PUSH	sLogDoornail
	CALL	Log

	PUSH	[BP+4]
	POPF
	JMP	RcbKernelExitOk


RtsRRLocal:
	JMP		RouteRequestLocal

BadExch:
	MOV		AX, ercExchOutOfRange
	JMP		IccErrorExit

OddCntlInfo:
	MOV		AX, ercOddCntlInfo
	JMP		IccErrorExit
PUBLIC RequestToSlot
RequestToSlot:
;	DI		Kernel exit
;	ES:BX	pRq
;	CX		exchDirect (maybe 0) and slot bits
ASSUME DS:DGroup, ES:Nothing
oPb EQU 0
oCb EQU 4
sPbCb EQU 6
sPbCbReserve EQU 10
oSa EQU 2

;	Local variables
;  ***** NOTE *****
;  These locals are built with PUSHs.
;  If more PUSHs are done, these [BP-n] must be fixed.
wRemoteRegs EQU [BP-(2+%sPUSHMF)]	; this EQU common with RespondToSlot
; These BP-n are for Rcb stack
wRtInfoSave EQU [BP-2]
exchDirect EQU [BP-4]

oPbCb EQU WORD PTR [BP-6]
fRemoteDma EQU BYTE PTR [BP-8]	; Low byte
;fMultiHop EQU BYTE PTR [BP-7]	; High byte

nPbCbReq EQU [BP-10]	; Low byte of word
nPbCbResp EQU [BP-9]	; High byte of word

nPbCb EQU [BP-12]
sPbCbsActual EQU [BP-14]
sPbCbs EQU [BP-16]

cbRqReq EQU [BP-18]
cbRq EQU [BP-20]
cbXfer EQU [BP-22]

pSource EQU DWORD PTR [BP-26]
 saSource EQU WORD PTR [BP-24]
 raSource EQU WORD PTR [BP-26]
cbSource EQU WORD PTR [BP-28]

; 	CX = exch, iSlot in high 6 bits.
;	Remote if iSlot <> iMySlot.
	MOV 	AL, CH
	SHR		AL, 1
	SHR		AL, 1		; AL = iSlot
	JZ		RtsRRLocal	; If no slot then local
	CMP		AL, iMySlot	; If my slot then local
	JE		RtsRRLocal

	CMP		sgRcbSeg, 0
	JE		ServiceNotAvail

; Go to another board.

	PUSH	DI
	%PUSHMF_AX
	%RcbNew
	PUSH ES:[BX]	; save rq.rtInfo - the remote copy gets our slot 
					; for remote dma requests and we fixup the source rq later.
	PUSH	CX		; exchDirect with slot bits set.

;	ES:BX	pRq

%IF(0) THEN (%'
; Update rgcRq for userNum.
;	Keep count of rqs outstanding
	TEST	DI, lcRqInc + lcRqDec		; call affects rgcRq
	JZ		SendIccRemoteUserNum
	MOV		SI, ES:[BX+rqUserNum]
	XOR		SI, wMySlotBits
	TEST	SI, maskUserNum
	JNZ		SendIccRemoteUserNum

	CMP		SI, nUcb
	JAE		SendIccRemoteUserNum

	ADD		SI,prgcRq
	PUSH	ES					;Save ES (saMsg)
	MOV		ES,pRgcRq+2
	TEST	DI, lcRqInc
	JNZ		InccRq
	DEC		BYTE PTR ES:[SI]	;DEC rgcRq
	POP		ES					;Restore ES
	JMP		SHORT SendIccRemoteUserNum
InccRq:
	INC		BYTE PTR ES:[SI]	;INC rgcRq
	POP		ES					;Restore ES
SendIccRemoteUserNum:
)FI%'

	CMP		CH, iSlotMax*4; After PUSH ES:[BX], rgcRq++ as BadExch calls IccErrorExit.
	JAE		BadExch
	TEST	BYTE PTR ES:[BX+sCntInfo], 1
	JNZ		OddCntlInfo

; Set rgTermTable bit for (userNum,slot).
; This is for filterPros_MF to know what slots to send termination
; to for each user.
; Only for userNums from this board.
	MOV	SI, ES:[BX+rqUserNum]
	SUB	SI, wMySlotBits
	CMP	SI, userNumLast
	JA	RTS5
	MOV AX, sgTermTable
	MOV GS, AX
; iTable=iUser*2 %'+SHR(iSlot,3)  use BTS'
	SHL	SI, 1
	MOVZX	AX, CH	; slot bits from exchDirect
	SHR	AL,2
	BTS	GS:WORD PTR [SI], AX	; WORD PTR to make assembler happy
RTS5:

;	If multi-hop process as Respond, Request
	MOV		SI, WORD PTR ES:respExch[BX]
	AND		SI, maskExchSlotBits
	JZ		MySlotBits
	CMP		SI, wMySlotBits
	JNE		MultiHopToSlot

MySlotBits:

;	Determine if rqCode is "RemoteDma" style of pb.
	MOV	AX, ES:[BX+rqCode]
	%RtInfo CL, rtSrpInfo using SI default 0
	AND		CX, maskRtDma
;	IF CX = 0 THEN no remote dma pb.

;	Calculate cbRq
	MOV	AL, ES:[BX+sCntInfo]
	ADD	AL, sRqHeader
	CBW
	PUSH	AX				; oPbCb
	XCHG	AX, SI						; SI=sHeader

;	ES:BX		pRq
;	SI			sHeader
;	CX			fRemoteDma

;	Remote Dma can't work with the Net Agent.
	MOV		DX, exchNet
	CMP		DX, exchDirect
	JE		NoRemoteDma

	JCXZ	NoRemoteDma

%IF(%IccDma) THEN (
	MOV	AL, BYTE PTR exchDirect+1
	SHR	AL, 2
	CMP	AL, liSlotPc
	JNE	NoRemoteDma				; Only Comarch -> PC
)FI

;	If remote dma pb.sa bad, catch it now.
	verw	ES:oSa[BX][SI]
	JZ		SaOk
;	pbcb.sa may be NIL if cb=0.
	TEST	WORD PTR ES:oSa[BX][SI], 0FFFCh
	JNZ		BadSa
	CMP		WORD PTR ES:oCb[BX][SI], 0
	JE		SaOk
BadSa:
	MOV		AX, ercBadPointer
	JMP		IccErrorExit
SaOk:


	MOV		AX,0FFh						; fRemoteDma=TRUE
	TEST	CL, maskRtDmaLocal
	JNZ		SetMultiHop
	MOV		DH, bMySlot
	MOV		ES:rtInfo[BX], DH			; rq.rtInfo=bMySlot for remote dma rqs.
SetMultiHop:
	PUSH	AX
	MOV		DL, sPbCb					; sPbCbSkip
	MOV		DH, 1						; nPbCbSkip
	MOV		CX, ES:[BX+nReqPbCb]		; CL=nReqPbCb CH=nRespPbCb
	CMP 	CL, 0
	JNE 	RequestDma
	DEC 	CH							; skip 1st resp pbcb
	JMP 	SHORT CalcTotalPbCb
RequestDma:
	DEC		CL							; skip 1st req pbcb
	JMP 	SHORT CalcTotalPbCb

PUBLIC NoRemoteDma
NoRemoteDma:
	PUSH	FALSE						; NOT fRemoteDma
SetupCalc:
	MOV		CX, ES:[BX+nReqPbCb]		; CL=nReqPbCb CH=nRespPbCb
	XOR		DX, DX						; sPbCbSkip, nPbCbSkip

CalcTotalPbCb:
	PUSH	CX					; nPbCbReq, nPbCbResp
	ADD		CL, CH
	XOR		CH, CH
	PUSH	CX					; nPbCb
;	ES:BX		pRq
;	CX			nPbCb
;	SI			sHeader
;	DX			sPbCbSkip
; Reserve space after (rq header+cntl info) for largest pbcbs imaginable.
	ADD		CL, DH	; Correct nPbCb for sRqBlock calculation.
	MOV		AL, sPbCb
	MUL		CL
	PUSH	AX						; sPbCbsActual
	MOV		AL, sPbCbReserve
	MUL		CL
	PUSH	AX						; sPbCbs

	SUB		CL, DH		; nPbCb except dma pbcb for loop
	ADD		AX, SI		; sPbCbs+sHeader -> sRqBlock
	XOR		DH, DH
	ADD		SI, DX		; skip 1st pbcb if fRemoteDma

StartCbRqLoop:
;	ES:BX		pRq

;	CX			nPbCb
;	ES:[BX][SI]	pPbCb
;	AX			sRqBlock

;	Remember stuff for later copy.
	PUSH	AX				; cbRqReq
	PUSH	AX				; cbRq
	JCXZ	DoneCbRq

CbRqLoop:
	MOV	DX, ES:[BX][SI+oCb]
;	If ReqPbCb then If biggest so far then remember it.
	CMP	CL, nPbCbResp
	JNE	CbNot1stResp
; 1st Resp pbcb
	MOV	cbRqReq, AX
CbNot1stResp:

CalcTotal:
; Reserve space for buffer of at least 4 bytes.
	CMP	DX, 1					; carry set iff DX=0
	ADC	DL, 0					; If DX=0 THEN DX=1;
; Rounding (AND	DI, 0FFFCh, above) reserves in quad multiples so there's room
;  for a word or dword.

	ADD	AX, 3			; Data on
	AND	AL, 0FCh		;  dword boundaries.
	ADD	AX, DX
%IF(%RequestStats) THEN (%'
	AND	DL, 0FCh
	MOV	DI, DX
	CMP	DI, cQuadMax
	JB	RSInc
	MOV	DI, cQuadMax
RSInc:
	INC	DWORD PTR mpcQuadcPbCb[DI]
)FI%'
	ADD	SI, sPbCb
	LOOP	CbRqLoop

	CMP	CL, nPbCbResp	; 0 Resp pbcb?
	JNE	DoneCbRq
; No Resp pbcb
	MOV	cbRqReq, AX
DoneCbRq:
	MOV	cbRq, AX

;	Take iBuf from our free list
;	ES:BX		pRq
;	AX			cbRq

;	Find bSlot for destination board
	XCHG	AX, DI			; AX free, DI=cbRq
	MOV	AL, exchDirect+1	; AL=iSlot << 2
	SHR	AL, 2
	CBW
	XCHG	AX, SI
	MOV	AL, mpiSlotbSlot[SI]
	MOV	rcb_bSlot, AL
	MOV	AH, AL
	MOV	AL, bMySlot		; Remember this before changing DS.
	SHL SI, 1; SI=iSlot << 1, index word

ResumeNoSuchBoard:
;	AL		bMySlot
;	AH		bSlot
;	SI		iSlot < 1
;	ES:BX	pRq
;	DI		cbRq
	MOV	CX, rgSgIcc[SI]
;	JCXZ	NoSuchBoard
	OR	CX, CX
	JZ	NoSuchBoard

; If waiting for a buffer for some previous rq, queue this rq too.
; Must avoid re-ordering requests, even if this request would have found
; a free buffer.
	CMP		WORD PTR pRqWait+2, 0; pRqWait.sa <> 0 -> request waiting
	JNE		QueueRqBlockWait
ResumeQueue:

%IF(0) THEN (%'
	MOV	DS, CX
ASSUME DS:iccSegType

	XCHG	AX, DX		; DX has slots
;	DL		bMySlot
;	DH		bSlot
;	DS		sgIcc
;	ES:BX	pRq
;	DI		cbRq

	%Peekw	EAX,DS:wSignature
	CMP	AX, lSigIcc
	JNE	TPDExit

) ELSE (
	XCHG	AX, DX		; DX has slots
)FI%'

	MOV	DS, sgMyIcc
ASSUME DS:iccSegType
;	Keep mpcbcRq statistics
	MOV	SI, DI
	SHR	SI, 2		; index quad counters, bucket size 16.  (cb >> 4) << 2
	TEST	SI, 0FC00h
	JZ	StatReady
	MOV		SI, 3FCh
StatReady:
	AND	SI, 3FCh	; only 256 quad counters
	INC	DS:mpcbcRq[SI]

;	Find a queue with buffers big enough.
	MOV	SI, OFFSET listFreeZ
	CMP	DS:cbEach[SI], DI
	JAE	TakeRequestBuffer
	MOV	SI, OFFSET listFreeY
	CMP	DS:cbEach[SI], DI
	JAE	TakeRequestBuffer
	MOV	SI, OFFSET listFreeW
	CMP	DS:cbEach[SI], DI
	JAE	TakeRequestBuffer

	MOV	AX, ercYBlkTooSmall
	JMP		IccErrorExit

QueueRqBlockWait:
	JMP		DoQueueRqBlockWait

NoSuchBoard:
ASSUME DS:DGroup, ES:Nothing
;	ES:BX	pRq
;	AL		bMySlot
;	AH		bSlot
;	SI		iSlot*2
;	DI		cbRq
; Find cdtRemote.paIccSeg
	PUSH	ES
	PUSH	BX
	PUSH	SI
	PUSH	DI
	PUSH	AX

	MOV	AL, AH
	PUSH	AX	; bSlot
	CALL	InitSlotAddressTables
;	Ignore erc, use rgSgIcc=0 for error check

	POP	AX
	POP	DI
	POP	SI
	POP	BX
	POP	ES

	MOV	CX, rgSgIcc[SI]
	JCXZ	TPDExit
	JMP	ResumeNoSuchBoard

TPDExit:
	MOV	AX, ercTargetProcessorDead

IccErrorExit:
	MOV	CX, DGroup
	MOV	DS, CX
ASSUME DS:DGroup
; Repair rq block to user original state.
	LEA	SP, wRtInfoSave
	POP	CX
	MOV	rcb_fFree,0FFh
	%RcbFree
	LES	BX, DWORD PTR [BP+pRq]
	MOV	ES:[BX+sCntlInfo], CX; wRtInfoSave

	XCHG	AX, CX		; temp erc
	%POPMF_AX			; restore remote reg's 
	XCHG	AX, CX		; restore erc
	POP	DI

%IF(0) THEN (
; Update rgcRq for userNum.
;	Keep count of rqs outstanding
	MOV		SI, ES:[BX+rqUserNum]
	XOR		SI, wMySlotBits
	TEST	SI, maskUserNum
	JNZ		IccErrorRemoteUserNum

	CMP		SI, nUcb
	JAE		IccErrorRemoteUserNum

	ADD		SI,prgcRq
	PUSH	ES					;Save ES (saMsg)
	MOV		ES,pRgcRq+2
	TEST	DI, lcRqInc
	JNZ		DecCount
	INC		BYTE PTR ES:[SI]	;INC rgcRq
	POP		ES					;Restore ES
	JMP		SHORT IccErrorRemoteUserNum
DecCount:
	DEC		BYTE PTR ES:[SI]	;DEC rgcRq
	POP		ES					;Restore ES

IccErrorRemoteUserNum:
)FI%'
	JMP		KernelExit

BlockWait:
	JMP		DoBlockWait

PUBLIC TakeRequestBuffer
TakeRequestBuffer:
ASSUME DS:iccSegType, ES:Nothing
;	ES:BX	pRq
;	DL		bMySlot
;	DH		bSlot
;	DS		sgMyIcc
;	SI		oList

	%Take CX from DS list SI using BX,DI leave cli
; ..leave cli so we mark buffer owner as soon as possible.

;	CX			iBuf
;	ES:[BP+raRq] pRq
;	DL			bMySlot
;	DH			bSlot
;	DS			sgICC
;	SI			oList

;	If fail (CX=0) mark remote wait, put pRq on queue.
	JZ		BlockWait
	MOV	rcb_iBuf, CX
	MOV	DI, SI

;	Mark buffer owner.
	MOV	ESI, DS:orgOwnBuffer
	SHL	CX, 1				; orgOwnBuffer is WORD array
	ADD	SI, CX
	MOV	AL, DH				; get bSlotOwner
	CBW
	MOV	DS:[SI], AX			; Set bSlotOwner, clear bOrphan

	PUSH	[BP+4]			; Resume interrupt state of user
	POPF

;	DS			sgMyIcc
;	DL			bMySlot
;	DH			bSlot
;	CX			iBuf*2
;	ES:[BP+raRq] pRq

;	Done with sgMyIcc
ASSUME DS:Nothing

	MOV	AL, nPbCbReq
; rcb_iPbCb is the pbcb to start on when the response comes in. If dma read
; the 1st pbcb shouldn't be moved.
	TEST BYTE PTR fRemoteDma, 1	
	JZ  SetiPbCb
	CMP AL, 0		;nPbCbReq = 0 on Read
	JNE SetiPbCb
	INC AL			;ignore 1st pbcb

SetiPbCb:
	MOV			 rcb_iPbCb, AL

;	Find pBuf, paBuf
	SHL	CX, 1		; dword ptr
	LES	DI, pRgPaBuffer
	ADD	DI, CX
	MOV	EAX, ES:DWORD PTR [DI]
	MOV	WORD PTR rcb_baRemote, EAX
	LES	DI, pRgpBuffer
	ADD	DI, CX
	LES	DI, ES:DWORD PTR [DI]
	MOV	WORD PTR rcb_pBuf, DI	; store ra
	MOV	WORD PTR rcb_pBuf+2, ES	; store sa

;	ES:DI		pBuf

%IF(%BMIC) THEN (
	MOV	AX, DGroup
	MOV	DS, AX
ASSUME DS:DGroup

	MOVZX	ECX, WORD PTR cbRqReq
	ADD	CX, OFFSET buf_rq
	TEST fPc, 1
	JNZ	FillBufferHeader

; Alloc a piece of Xfer buffer of size 
;		Min(cbDmaMax, cbRqReq+sbufHdr(buf_rq)).
	CMP	CX, cbDmaMax
	JB	XferBuf2
	MOV	CX, cbDmaMax
XferBuf2:
	%XferAlloc					; EAX -> ECX bytes of Xfer area
	MOV	ES, sgXferArea
ASSUME ES:iccBufferType
	MOV	rcb_raXfer, AX
	XCHG	EAX, EDI
	SUB	EDI, 4					; buf_pa not present
	SUB	WORD PTR sPbCbs, 4		; ditto
	%cbFromcBlk CX
FillBufferHeader:
	PUSH	CX					; cbXfer
)FI%'

;	Fill buffer header
	LEA	AX, rcb_
	MOV	ES:buf_wRcb[DI], AX
	MOV	AX, exchDirect
	MOV	ES:buf_exchDirect[DI], AX
	MOV	AL, fRemoteDma
	MOV	AH, bMySlot
	MOV	ES:WORD PTR buf_fRemoteDma[DI], AX	; fRemoteDma, bSlotSync
	MOV	AX, cbRqReq
	MOV	ES:buf_cbReq[DI], AX
	MOV	AX, cbRq
	MOV	ES:buf_cb[DI], AX

PUBLIC CopyRqHeader
CopyRqHeader:
;	Copy rq header, cbs.
;	ES:DI		pXfer

;; PC may one day do a MapBusAddress, so FEPs can dma to virtual memory.
;;
	LDS	SI, rcb_pRq
ASSUME DS:Nothing
	XOR	ECX, ECX		; Prepare ECX for MOVSD
	MOVZX	EDX, WORD PTR oPbCb	; offset of pbcbs from prq is sHeader
	MOV	CX, DX
	ADD	CX, sPbCbsActual
	XOR	AX, AX
	XCHG	AX, DS:[SI+ercRet]	; Copy 0 erc; save rq erc
	LEA	DI, DS:buf_rq[DI]

	%RepMOVSW			; Rq header copied

	MOV	SI, WORD PTR rcb_pRq ; replace user rtInfo in source rq
	XCHG	AX, DS:[SI+ercRet]	; Restore rq erc
	MOV	CX, wRtInfoSave		
	MOV	DS:[SI], CX
	
;	EDX			oPbCb

;	Scan pbcbs
;	Copy Request pbcb data, unless remote dma.
;	Copy uses ES:DI, DS:SI, CX   leaves AX,BX,DX
	XOR	EAX, EAX
	PUSH	EAX		; pSource
	PUSH	AX		; cbSource
	MOV	rcb_oData, 4; after buf_pa
	ADD	DX, OFFSET buf_rq
	ADD	sPbCbs, DX	; cbInXfer
%IF(%IccDma) THEN (
; Skip 1st pbcb if remote dma
; No mapping needed on Comarch.  Pass ba=sg:ra, use cpu move and page tables.
	TEST	fRemoteDma, 0FFh
	JZ	StartCopyLoop
	ADD	oPbCb, sPbCb
)FI
PUBLIC StartCopyLoop
StartCopyLoop:
	MOV	AL, nPbCbReq
	CMP	AL, 0
	JLE	CopyComplete
	ADD	WORD PTR sPbCbs, 3
	AND	BYTE PTR sPbCbs, 0FCh

; Set up next pbcb for copying
	LDS	SI, rcb_pRq
ASSUME DS:Nothing
	ADD	SI, oPbCb
	LODSD
	XCHG	EAX, ECX
	LODSW
	OR	AX, AX
	JNZ	CopySet
	MOV	AX, 4				; If nothing to copy, reserve 4 bytes anyway
	MOV	ECX, dZero			; .. and zero
CopySet:
	MOV	pSource, ECX
	MOV	cbSource, AX

	TEST fPc, 1
	JZ	CopyPbCbLoop
	XCHG	AX, CX
	LES	DI, rcb_pBuf
	ADD	DI, sPbCbs
	JMP	CopyReady

CopyPbCbLoop:
	MOV	ES, sgXferArea
ASSUME ES:Nothing
	MOV	DI, sPbCbs
	MOV	CX, cbSource
	ADD	CX, DI
	CMP	CX, cbXfer
	JB	CbCalculated
	MOV	CX, cbXfer
CbCalculated:
	SUB	CX, DI
	ADD	DI, rcb_raXfer

CopyReady:
	MOV	DX, CX
	verr	saSource
	JNZ	CopyDone
	LDS SI, pSource
ASSUME DS:Nothing

	%RepMOVSW			; PbCb data copied

CopyDone:
	ADD	raSource, DX
	ADD	sPbCbs, DX
	SUB	cbSource, DX
CopyComplete:

	MOV	DX, sPbCbs
	CMP	DX, cbXfer
	JB	CopyPbCbNext

	TEST fPc, 1
	JZ	CopyPbCbDma
	MOV	rcb_oData, DX
	JMP	CopyPbCbDone

CopyPbCbDma:
	MOV	AX, DGroup
	MOV	DS, AX
ASSUME DS:DGroup
	%ClaimXmitDma
;	Find pRemote and dma xfer
	MOV	DX, sPbCbs
	MOV	EDI, rcb_baRemote
	MOVZX	EAX, rcb_oData
	ADD	EDI, EAX
	ADD	rcb_oData, DX
	MOV	AX, rcb_raXfer
;	AX			raXferArea
;	EDI			paBuf
;	DX			cbDma
	%PerformXmitDma DX
	MOV	WORD PTR sPbCbs, 0

CopyPbCbNext:
; Finish this pbcb
	CMP	cbSource, 0
	JNE	CopyPbCbLoop
; Next pbcb
	ADD	oPbCb, sPbCb
	DEC	BYTE PTR nPbCbReq
	JG	StartCopyLoop
; Flush partial block
	CMP	WORD PTR sPbCbs, 0
	JNE	CopyPbCbDma

	MOV	AX, DGroup
	MOV	DS, AX
ASSUME DS:DGroup

;	Free xfer
;   Free: AX, DX
	MOV	BX, rcb_raXfer
	%XferFree		; BX = raXfer

CopyPbCbDone:
	MOVZX ECX, rcb_iBuf
	LDS	SI, rcb_pBuf
ASSUME DS:iccBufferType

DoSyncOut:
	MOV	AX, DGroup
	MOV	ES, AX
ASSUME	ES:DGroup
;	DS:SI		@RemoteBuf
;	Put paBuf in other board Request list

; rgSyncOut(iSlot)
	MOVZX	DI, rcb_bSlot
	MOVZX	DI, mpbSlotiSlot[DI]
	SHL	DI, 1
	CLI						; SyncOut is atomic with Put below.
	MOV	AX, rgSyncOut[DI]
	INC	AX
	MOV	rgSyncOut[DI], AX
	%Pokew	DS:buf_sync[SI], AX

	MOV	ECX, rcb_baRemote
	MOV	DS, rgSgIcc[DI]
ASSUME DS:iccSegType

	%Put ECX into DS list listRequest using BX,SI leave cli
; left cli so rcb safe until we FreeXmitDma below
	XCHG	SI, DI
	JNZ CorruptRemoteRequestQueue	; Remember to UnmapBusAddress!
	SHR		SI, 1
;	Ring doorbell
PUBLIC RingDoorbell
RingDoorbell:
; SI		iSlotRing
%IF(%fDebug) THEN (
	PUSH DS
	MOV AX, Dgroup
	MOV DS, AX
ASSUME DS: DGroup
	LES BX, DWORD PTR [BP+raRq]
	MOV AX, wTrapRqCode
	CMP ES:rqCode[BX], AX
	JNE NoDbgTrap
	MOV AX, wTrapUserNum	;wTrapUserNum starts out 0FFFFh
	CMP ES:rqUserNum[BX], AX
	JNE NoDbgTrap
	CMP ES:WORD PTR ercRet[BX], 0
	JE NoDbgTrap
	PUSH 3
	CALL Crash
NoDbgTrap:	
	POP DS
ASSUME DS: iccSegType
)FI

	MOV	AX, DGroup
	MOV	DS, AX
ASSUME DS:DGroup

	%DoorBell(lBmicDoorbellInt)

RcbKernelExitOk:
	%FreeXmitDma
	LEA	SP, wRemoteRegs

IccKernelExitOk:
	%POPMF_AX			; restore remote reg's 
	POP	DI
	XOR	AX, AX
	JMP	KernelExit

DoQueueRqBlockWait:
; pRqWait might <> NIL.  If retrying continue, else queue pRq on exchRqWait.
;	ES:BX	pRq
;	AL		bMySlot
;	AH		bSlot
;	CX		sgIcc
;	SI		iSlot*4
;	DI		cbRq
; If ES:BX = mpiSlotpRqWait then re-trying, continue.
; Now use KSendRequest to avoid CLI through kernel call (ctosv won't)
ASSUME	DS:DGroup, ES:Nothing
	CLI						; Atomic test and Send so queue consistent.
	CMP		WORD PTR pRqWait+2, 0
	JE		QRBWResume		; pRqWait.sa = 0 -> no request waiting

	MOV	DX, ES
	CMP	DX, WORD PTR pRqWait+2
	JNE	QRBWQueue
	CMP	BX, WORD PTR pRqWait
	JNE	QRBWQueue
QRBWResume:
	PUSH	[BP+4]
	POPF
	JMP	ResumeQueue

QRBWQueue:
;	ES:BX	pRq
;	SI		iSlot*4
	LEA	SP, exchDirect
	POP	ES:[BX+ercRet]		; exchDirect
	POP	ES:[BX+sCntlInfo]	; wRtInfoSave
	SHR	SI, 1
QRBWForward:

;Must use KSendRequest because ForwardRequest will re-net-route (due to QMgr).
	MOV	rcb_fFree, 0FFh
	%RcbFree
	PUSH	CX
	PUSH	ES
	PUSH	BX
	CALL	KSendRequest

	PUSH	[BP+4]
	POPF					; End atomic transaction.
	INC		cRqWait
	JMP	IccKernelExitOk

QRBWCrash:
	PUSH	AX
	CALL	Crash

DoBlockWait:
; No block available.
;  Return to caller ercWait or ercOk with pRq in pRqWait or on exchRqWait.
;	DL			bMySlot
;	DH			bSlot
;	DS			sgICC
;	SI			oList
;	FL			ints disabled
ASSUME DS:iccSegType, ES:Nothing
	MOV	AX, DS
	MOV	ES, AX
	MOV	AX, DGroup
	MOV	DS, AX
ASSUME DS:DGroup, ES:iccSegType
;	bSlot(DH) -> ipRq(DI)
	MOV	AL, DH
	CBW
	XCHG	AX, DI
	MOV	AL, mpbSlotiSlot[DI]
	CBW
	XCHG	AX, DI
	SHL	DI,2
	
BWRegister:
;	pRqWait.sa <> 0 might mean retrying, return erc.
	CMP	WORD PTR pRqWait+2, 0
	JE	BWStore
;	IF pRqWait <> pRq then race, just queue on exchRqWait.
	LES	BX, rcb_pRq
	MOV	AX, ES
	CMP	AX, pRqWait+2	; pRq.sa = pRqWait.sa?
	JNE	BWQueue
	CMP	BX, pRqWait		; pRq.ra = pRqWait.rq?
	JNE	BWQueue
;	pRqWait = pRq, this is wait retry.
	MOV	AX, ercWait
	JMP	IccErrorExit

BWQueue:
; This was a race - two paths through the kernel.  Put on exchRqWait.
;	ES:BX	pRq
;	DI		iSlot*4
	MOV	SI, DI
	JMP	QRBWQueue

BWStore:
;	Bump waits for stats.
	INC	ES:cWaits[SI]

	LES	BX, rcb_pRq
ASSUME ES:Nothing
	LEA	SP, exchDirect
	POP	ES:[BX+ercRet]		; Hide exchDirect in erc field of rq block.
	MOV	WORD PTR pRqWait, BX
	MOV	WORD PTR pRqWait+2, ES
	PUSH	[BP+4]
	POPF
	INC	cRqWait
	XOR	AX, AX
	JMP	IccErrorExit

; *****  C H I M E  *****
;
;	Inter Cpu Communications (ICC) doorbell interrupt entry point.
;
PUBLIC Chime
Chime PROC FAR
	%RcbEntry

; Ints in ctosp don't automatically save slot, br0.
	%PUSHMF_AX

	%ClearChime

LoopMoreWork:
	MOV	AX, DGroup
	MOV	DS, AX
ASSUME DS:DGroup

	MOV	ES, sgMyIcc
ASSUME ES:iccSegType

	TEST	oRcbDmaRcvHead, 0FFFFh
	JZ	TestMoreWork
	JMP	ChimeRet
TestMoreWork:

%IF (%IccDma) THEN (
;	Cache part
	%IfTake ES list listCache using EAX,EBX then ProcessCache else RespondLoop

ProcessCache:
;	Take paDmaIob from Cache list (Comarch) or pDmaIob (PC)

	%Lift ECX from ES list listCache using BX,SI leave sti
	JZ	DoCrashCorruptQueues

	TEST	fPc, 0FFh
	JZ		CacheBmic
	PUSH	ECX
	CALL	DmaMoveComplete
	JMP	LoopMoreWork

CacheBmic:
	%RcbRcv SI
; Suck up whole iob using 24-byte rcv dma, busy-wait-loop on completion.
	%SuckIob	dmaIob, ECX
; Do Bmic DMA (using 'rcv' channel), Requester is client, Target is cache.
; Requester and Target should be mapped.
; baRequestor is actually an sg:ra of ours.  Mapping is accomplished free
; through the page tables, since we do a CPU move of data.
; Mapping table on master file processor (EP00/PC) is an array of DWORDs
; which are addressed by baTarget>>12 to yield a pa: mpBaPa[]
; We just know everything is 4k aligned, 4k pages.

	MOV	iPa, 0
	MOV ECX, dmaIob.baTarget
	AND	ECX, 0FFFFF000h
	JS	IobPaSuck
	MOV	rgPa, ECX
	JMP	IobLoop

IobPaSuck:
	SHL	ECX, 2		; DWORD PTR, also drop sign bit
	SHR ECX, 12
	%SuckIob	rgPa, ECX

; Loop over xferLength, doing partial transfers until exhausted.
IobLoop:
; First xfer may be short, cb=1000h-(baTarget AND 0FFFh); begins at offset.
	MOVZX EBX, WORD PTR dmaIob.baTarget
	AND	BX, 0FFFh		; offset in 4k page
	MOV AX, 1000h		; 4k
	SUB AX, BX			; - offset within 4k
	CMP AX, dmaIob.xferLength
	JB  IobXfer
	MOV	AX, dmaIob.xferLength
IobXfer:
; AX	cbPiece
	MOV SI, iPa
	MOV	ECX, rgPa[SI]
	ADD ECX, EBX
	MOVZX	EAX, AX
	XCHG	EAX, ECX
	LES	DI, dmaIob.baRequester
; EAX	paCache
; ECX	cbPiece
; ES:DI	pClient
; Subsequent xfers begin on page boundaries.
	ADD	dmaIob.baTarget, ECX
	ADD	dmaIob.baRequester, CX
	SUB	dmaIob.xferLength, CX
	ADD	iPa, 4

%SET(DebugRemote,1)
%IF(%DebugRemote) THEN (
Data SEGMENT
Public iLog
iLog	DW 0
rgLog	DB 80h DUP(?)
Data ENDS
	MOV	BX, iLog
	AND	BX, 7Fh
	MOV	DWORD PTR rgLog[BX], EAX
	MOV	 WORD PTR rgLog[BX+4], CX
	MOV	 WORD PTR rgLog[BX+6], SI
	ADD	BX, 8
	MOV	iLog, BX
)FI
	TEST	dmaIob.flags, mTargetWrite
	JZ		IobRead
	%EisaDmaOut
	JMP	IobNext
IobRead:
	%EisaDma
IobNext:
	CMP	dmaIob.xferLength, 0
	JNZ	IobLoop
	%RcbRcvLeave

; Return pIob to EP00 so the service can complete its operation (e.g. MassIo).
	MOV	ECX, dmaIob.pIob
	MOV	ES, rgSgIcc[liSlotPc*2]
ASSUME ES:iccSegType
	%Put ECX into ES list listCache using BX,SI leave userFlags
	MOV	SI, liSlotPc
	%DoorBell(lBmicDoorbellInt)
	JMP	LoopMoreWork


RespondLoop:

)FI%' IccDma

;	Respond part
	%IfTake ES list listRespond using EAX,EBX then ProcessRespond else RequestLoop

DoCrashCorruptQueues:
	PUSH	ercCorruptIcc
	CALL	Crash

ProcessRespond:
;	Take oRcb from Respond list

	%Lift ECX from ES list listRespond using BX,SI leave sti
	JZ	DoCrashCorruptQueues

	MOV	ES, sgRcbSeg
ASSUME ES:iccRcbSeg
	MOV	BX, CX
	MOV	oRcbDmaRcvHead, BX
	%RcbDispatch ES:BX, rcbAssume

PUBLIC RespondContinueAfterDma
RespondContinueAfterDma:
;	Each rq.pbcbResp may be copied back using dma.
;	Re-load from the RCB after each call.
ASSUME DS:Nothing, ES:Nothing

;	Find slot, pBuf, pRq, oData and iPbCb from rcb.
	MOV	CX, WORD PTR rcb_bSlot	; CL, CH = bSlot, iPbCb
	MOV	DX, rcb_oData
	ADD	DX, 3					; Round to dword boundary
	AND	DL, 0FCh				;  see CopyPbCbLoop in RequestToSlot
	MOV	rcb_oData, DX
	LES	DI, rcb_pRq
ASSUME ES:Nothing
;	ES:DI		pRq
;	CL,CH		bSlot, iPbCb
;	DX			oData
;	Detect respond moves complete, don't fault trying to touch rq.pbcbs
	MOV	AX, ES:nReqPbCb[DI]
	ADD	AL, AH
	CMP	CH, AL
	JAE	CopyErc

;	Update move-state fields of rcb
;	Find cb of next response pbcb
	MOV	AL, sPbCb
	MUL	CH
	ADD	AL, ES:sCntInfo[DI]
	ADD	AX, sRqHeader

ASSUME DS:Nothing
	ADD	AX, DI
;	AX		oPbCbNext

	XCHG	AX, DI
;	ES:DI		pPbCb
;	AX			raRq
;	CX, DX		Stuff
	MOV	SI, ES:[DI+oCb]			; cb of next response pbcb
; Reserve space for response buffer of at least 4 bytes.
	CMP	SI, 1					; carry set iff SI=0
	ADC	SI, 0					; If SI=0 THEN SI=1;
; Rounding (AND	SI, 0FFFCh, below) reserves in quad multiples.
;	Update rcb state of dma move
	ADD	rcb_oData, SI
	INC	rcb_iPbCb
	XCHG	AX, DI

CopyErc:
;	Find the remote buffer in DS:SI
	XCHG	AX, BX
	LDS	SI, rcb_pBuf
ASSUME DS:iccBufferType

	
;	DS:SI		pBuf
;	ES:DI		pRq
;	BX			oPbCb
;	CL,CH		bSlot, iPbCbNext
;	DX			oData

;	If last time then rcb_iPbCb will be rq.nReqPbCb+rq.nRespPbCb
	MOV	AX, ES:nReqPbCb[DI]
	ADD	AL, AH
	CMP	CH, AL
	JAE	RespondCopyDone

CopyNextPbCb:
	XCHG	AX, BX
	XCHG	AX, DI
;	Copy Response pbcbs
	ADD	SI, DX
	MOVZX		ECX, ES:WORD PTR [DI+oCb]		; get byte count for MoveOrDma
;	ES:DI		@rq.pbcb
;	DS:SI		@buf.dataNext
	verw	ES:oSa[DI]
	JNZ		RespondMoveDone
	LES	DI, DWORD PTR ES:oPb[DI]
ASSUME ES:Nothing

	%MoveOrDma

RespondMoveDone:
;	Cycle to the next pbcb pair.
	JMP	RespondContinueAfterDma

RespondCopyDone:
;	copy erc
	%Peekw	EAX, DS:buf_rq[SI+ercRet]
	MOV	ES:ercRet[DI], AX
	MOV	AX, DGroup
	MOV	DS, AX
ASSUME DS:DGroup

	TEST	fPc, 0FFh
	JZ	RespondShipOut
;	PC can keep Iop so busy its watchdog never runs.
;	Protect Iop from watchdog if we just heard from him.
	MOVZX	EAX, CL		; bSlot
	MOV	AL, mpbSlotiSlot[EAX]
	LFS	SI, mpiSlotpCdt[EAX*4]
ASSUME FS:CdtStruc
	MOV	FS:BYTE PTR fWatchdog[SI], AH
	XOR	AL, AL
	MOV	FS, AX
ASSUME FS:Nothing

RespondShipOut:
;	ES:DI		pRq
;	CL			bSlot
	XCHG	AX, DI
	MOV	BX, rcb_iBuf
	MOV	rcb_fFree, 0FFh
	%RcbFree
	MOV	oRcbDmaRcvHead, 0			; Release rcv dma channel

	CALL	DoneRespondMove
	JMP	LoopMoreWork

PUBLIC DoneRespondMove
DoneRespondMove PROC NEAR
;	ES:AX		pRq
;	BX			iBuf
;	CL			bSlot
;	Push pRq, bSlot for Respond to free ES:DI
	PUSH	ES
	PUSH	AX
	PUSH	CX

%IF(%Paranoid) THEN (
	MOV	CX, SS
	CMP	CX, sgRcbSeg
	JNE	POk
	INT	2
POk:
)FI

;	BX			iBuf
;	Put iBuf on free list
	MOV	CX, BX
	MOV	DI, OFFSET listFreeZ
	SUB	BX, nZblk
	JBE	FreeRequestBuffer
	MOV	DI, OFFSET listFreeY
	SUB	BX, nYblk
	JBE	FreeRequestBuffer
	MOV	DI, OFFSET listFreeW

FreeRequestBuffer:
	MOV	ES, sgMyIcc
ASSUME ES:iccSegType

;	ES			sgMyIcc
;	CX			iBuf
;	DI			oFreeList

;	Give up ownership of buffer
	MOV	SI, ES:orgOwnBuffer
	ADD	SI, CX
	ADD	SI, CX
	MOV	ES:WORD PTR [SI], lOrphan

;	ES			sgMyIcc
;	DI			oFreeList
;	CX			iBuf
	%Free CX into ES list DI using BX,SI leave sti
	JNZ CorruptLocalBufferQueue

;	Respond(pRq)
	POP		DX		; bSlot for Respond calling RespondAlias
	CALL	KRespondFromRemote

	CMP		WORD PTR pRqWait+2, 0; pRqWait.sa <> 0 -> request waiting
	JE	WakeDone	; Some rq blocked waiting for one of those buffers.

WakeWaiter:
ASSUME DS:DGroup
	LES	DI, pRqWait
	MOV	CX, ES
	JCXZ	WakeDone
;	Retry first blocked request on queue.
	PUSH	ES:[DI+ercRet]	; Save exchDirect if ERequestDirect fails ercWait.
	PUSH	ES:[DI+ercRet]
	PUSH	ES
	PUSH	DI
	CALL	ERequestDirect
	POP		CX				; exchDirect
	CMP	AX, ercWait
	JE	RetryFailed
; ercOK or new erc.  Either way no longer waiting.
	DEC	cRqWait				; Keep count to trigger retry in Periodic.
	CMP	AX, ercOk
	JE	NextRqWait

;	Request failed for some new reason, perhaps ercProcessorDead.
;	Just respond and try the next.
	LES	DI, pRqWait
	MOV	ES:[DI+ercRet], AX
	PUSH	ES
	PUSH	DI
	CALL	KRespond

NextRqWait:
	CLI					; NIL mustn't be noticed unless exch empty(after Check).
						;  Only nested int issuing rq would notice.
	XOR	EAX, EAX
	MOV	DWORD PTR pRqWait, EAX	; pRqWait <- NIL
;	Prepare for Check(exchRqWait, @pRqWait)
	PUSH	exchRqWait
	LEA	BX, pRqWait
	PUSH	DS
	PUSH	BX
	CALL	Check
	STI					; End of NIL protection.  (yes, sti)
	JMP	WakeWaiter	; Don't bother with erc, just check pRqRet.

RetryFailed:
	LES	DI, pRqWait
	MOV	ES:[DI+ercRet], CX	; Re-assert exchDirect for next retry.

WakeDone:
	RET

DoneRespondMove ENDP
PUBLIC RequestLoop
RequestLoop:
;	Request part
ASSUME DS:DGroup, ES:iccSegType

	%IfTake ES list listRequest using EAX,EBX then ProcessRequest else ChimeRet

CorruptQueues:
	JMP	DoCrashCorruptQueues

ProcessRequest:

;	Take paBuf from Request list

	%Lift ECX from ES list listRequest using BX,SI leave sti
	JZ	CorruptQueues

;	ES		sgMyIcc
;	ECX		paBuf

;;	If (bSlotSource) then ignore

	TEST	fPc, 0FFh
	JZ	PRBmic
; Make pointer to pa in ECX
	PUSH	ECX
	CALL	PMyIcc
	XCHG	BX, SI		; ES:SI pBuf
	JMP		PRLocal

PRBmic:
	%PeekwPa	AX, buf_cb[ECX]
	PUSH	ECX			; paBufSave
	XCHG	EAX, ECX	; CX cb
	MOV	ES, sgMyShadow
ASSUME ES:iccSegLocalType
;	Keep mpcbcRq statistics
	MOV	SI, CX
	SHR	SI, 2		; index quad counters, bucket size 16.  (cb >> 4) << 2
	TEST	SI, 0FC00h
	JZ	StatReadyLocal
	MOV		SI, 3FCh
StatReadyLocal:
	AND	SI, 3FCh	; only 256 quad counters
	INC	ES:mpcbcRqLocal[SI]

;	Find a queue with buffers big enough.
	MOV	SI, OFFSET listFreeZLocal
	CMP	ES:cbEach[SI], CX
	JAE	TakeLocalBuffer
	MOV	SI, OFFSET listFreeYLocal
	CMP	ES:cbEach[SI], CX
	JAE	TakeLocalBuffer
	MOV	SI, OFFSET listFreeWLocal
	CMP	ES:cbEach[SI], CX
	JAE	TakeLocalBuffer
	MOV	AX, ercYBlkTooSmall

ShadowError:
	POP	ECX				; paBuf
	%PokewPa	buf_rq[ECX+ercRet], AX
;	buf_bSlotSync in same word as fRemoteDma.
	%PeekwPa	SI, buf_fRemoteDma[ECX]
	SHR	SI, 8	; byte after fRemoteDma is bSlotSync
	MOVZX	SI, mpbSlotiSlot[SI]
	SHL	SI, 1
	INC	rgSyncIn[SI]	; no test for sync error, oh well, probably all right.
	%PeekwPa	SI, buf_rq[ECX+respExch]
	AND	SI, 7FFFh
	SHR	SI, 10
	SHL	SI, 1
	%PeekwPa	AX, buf_wRcb[ECX]
	XCHG	AX, CX
	MOV	ES, rgSgIcc[SI]
ASSUME ES:iccSegType
	%Put CX into ES list listRespond using BX,DI leave userFlags
;	Ring doorbell
	SHR	SI, 1
	%DoorBell(lBmicDoorbellInt)
	JMP	ChimeLoop

TakeLocalBuffer:
	%Take ECX from ES list SI using BX,DI leave cli
	MOV	AX, ercNoYblks
	JZ	ShadowError
;	ECX			pBuf
	MOV	SI, CX
	SHR	ECX, 16
	MOV	ES, CX
ASSUME ES:iccBufferType
	POP	ECX			; paBuf

; Get an icc stack so can block in dma
; Use one we keep for just us
	MOV	FS, sgRcbSeg
ASSUME FS:iccRcbSeg
	MOVZX	EAX, oRcbRcv
	MOV	oRcbDmaRcvHead, AX
	%RcbDispatch FS:EAX, rcbInit

	XCHG	EAX, ECX
	%DmaIn	EAX, ES:SI
	%RcbRcvLeave

PRLocal:
;	ES:SI	pBuf
	MOV	BX, ES:WORD PTR buf_rq[SI+respExch]
	MOV	AX, BX
	OR	AX, 8000h		; Force icc on respond
	MOV	ES:WORD PTR buf_rq[SI+respExch], AX
	SHR	BX, 10
;	Count bufs inside local servers for Abort cleanup.
	SHL	BX, 1
	INC	mpiSlotcOutstanding[BX]
;	If rgSyncIn(iSlotOwner) not match buf_sync
	MOVZX	BX, ES:buf_bSlotSync[SI]
	MOV	BL, mpbSlotiSlot[BX]
	SHL	BX, 1
	MOV	AX, ES:buf_sync[SI]
	DEC	AX
	CMP	AX, rgSyncIn[BX]
	JNE	OutOfSequence
	INC	AX
	MOV	rgSyncIn[BX], AX

;	ES:SI		pBuf
;	BX			iSlotOwner*2

%IF(%fDebugRequest) THEN (
; trap by rqCode and userNum for debugging
	MOV AX, wTrapRqCode
	CMP ES:WORD PTR buf_rq+rqCode[si], AX
	JNE NoTrap
	MOV AX, wTrapUserNum	;wTrapUserNum starts out 0FFFFh
	CMP ES:WORD PTR buf_rq+rqUSerNum[si], AX
	JNE NoTrap
	PUSH 3
	CALL Crash
NoTrap:
)FI
	
; Keep usernum high-water mark optimization in case of processor abort
	MOV	AX, ES:WORD PTR buf_rq[SI+rqUserNum]
	MOV	BX, AX
	SHR	BX, 10
	CMP	BX, 9			; iSlotMax
	JA	AddressRqPbCb
	SHL	BX, 1
	CMP	AX, mpiSlotUsernumMac[BX]
	JB	AddressRqPbCb
	MOV	mpiSlotUsernumMac[BX], AX

PUBLIC AddressRqPbCb
AddressRqPbCb:
;	Alias all pbcbs (sg same for all except remote dma)
	LEA	AX, DS:buf_rq+sRqHeader
	ADD	AL, ES:buf_rq+sCntInfo[SI]
	CBW
	XCHG	AX, BX
	MOV	AX, WORD PTR ES:buf_rq+nReqPbCb[SI]	; AL=nReqPbCb AH=nRespPbCb
	ADD	AL, AH
	CBW
	XCHG	AX, CX

;	ES:SI		pBuf
;	ES:[BX][SI]	pPbCb
;	CX			nPbCb
;	BX			sRqCntl

;	JCXZ IssueIcc
	OR	CX, CX
	JZ	IssueIcc

	LEA	DI, [BX][SI]
	MOV	AL, sPbCbReserve
	MUL	CL
	ADD	DI, AX
;	DI			oData
	XOR	EDX, EDX		; convenient 0 in loop.

	TEST	BYTE PTR ES:buf_fRemoteDma[SI], 0FFh
	JZ	AliasPbCbLoop
;	The first pbcb has got a ba in it.  This is a remote dma request
;	which means the first pbcb data uses NO space in the Y/Z block.
;	Just skip it for looping purposes.
	DEC	CX
	ADD	BX, sPbCb
	JCXZ IssueIcc

AliasPbCbLoop:
;	ES:SI		pBuf
;	ES:[BX][SI]	pPbCb
;	CX			nPbCb
;	DI			oData
;	EDX		0
;;	Do BMIC-style remote-dma here.
;;	If buf_oRemoteDma=BX?
;;		then oPb is paRemote instead.  Do DMA to end of buffer?
;;	What about non-contiguous pages?

	MOV	ES:oPb+2[BX][SI], ES
	ADD	DI, 3
	AND	DI, 0FFFCh
	MOV	ES:oPb  [BX][SI], DI

%IF(%fDebugRead) THEN (%' For disk data miscompare diagnosis.
	CMP	CL, BYTE PTR ES:buf_rq+nReqPbCb+1[SI]	; AL=nReqPbCb AH=nRespPbCb
	JA		NoBeefFill
	PUSHA
	MOV		CX, ES:oCb[BX][SI]
	MOV		AX, 0BEEFh
	SHR		CX, 1
	JCXZ	REPDone
	CLD
REP	STOSW
REPDone:
	POPA
NoBeefFill:
)FI%' fDebug

; Clear start of each resp data, might be fhRet or cbRet, might return erc.
; Fixes programs that trust ret data even when have erc.
	CMP	CL, ES:buf_rq+nRespPbCb[SI]
	JA	AliasNext
	MOV	DWORD PTR ES:[DI], EDX	; clear 32 bits.
AliasNext:

	MOV	AX, ES:oCb[BX][SI]
	CMP	AX, 1
	ADC	AX, 0
	ADD	DI, AX
	ADD	BX, sPbCb
	LOOP AliasPbCbLoop

IssueIcc:
;	ES:SI		pBuf
	LEA	DI, ES:buf_rq[SI]
;	Save pRq for error Respond.
	PUSH	ES
	PUSH	DI

	MOV		AX, ES:buf_exchDirect[SI]
	TEST	AX, 3FFh
	JZ		IssueIccRequest

;	erc=ERequestDirect(exchDirect, pRq)
	PUSH	AX
	PUSH	ES
	PUSH	DI
	CALL	FAR PTR ERequestDirect
	JMP		Short IssueIccDone

IssueIccRequest:
;	erc=ERequest(pRq)
	PUSH	ES
	PUSH	DI
	CALL	FAR PTR ERequest

IssueIccDone:
;	Registers blown
	OR	AX, AX
	JNZ	RequestFailed
	ADD	SP, 4		; No error, pop pRq.

ChimeLoop:
	JMP	LoopMoreWork


PUBLIC OutOfSequence
OutOfSequence:
	PUSH	ES
	LEA	SI, DS:buf_rq[SI]
	PUSH	SI
	MOV	AX, ercBadSequence
;	JMP	RequestFailed

PUBLIC RequestFailed
RequestFailed:
;	pRq is already on the stack.
	LES BX, DWORD PTR [BP-(%sPUSHMF+4)]
	MOV ES:WORD PTR [BX+ercRet], AX
	CALL	FAR PTR GRespond ; GRespond returns on error
	JMP	ChimeLoop


;; Abort
;;	obit=2
;;	erc rcbs.
;;	If mpiSlotcOutstanding = 0 then do fCleanUpBlock stuff

PUBLIC ChimeRet
ChimeRet:
ASSUME	DS:DGroup, ES:iccSegType

;	Update nMinY, nMinZ, nMinW ;DHG
	MOV	AX, ES:iPut[listFreeZ]
	SUB	AX, ES:iTake[listFreeZ]
	AND	AX, ES:wiMask[listFreeZ]
	SHR	AX, 2
	Mov	nAvailZ, Ax					; 01/21/93 SRE Maintain available Z blocks
	CMP	AX, nMinZ
	JB	CRUpdateZ
CRCheckMinY:
	MOV	AX, ES:iPut[listFreeY]
	SUB	AX, ES:iTake[listFreeY]
	AND	AX, ES:wiMask[listFreeY]
	SHR	AX, 2
	Mov	nAvailY, Ax					; 01/21/93 SRE Maintain available Y blocks
	CMP	AX, nMinY
	JB	CRUpdateY
CRCheckMinW:						;DHG...
	MOV	AX, ES:iPut[listFreeW]
	SUB	AX, ES:iTake[listFreeW]
	AND	AX, ES:wiMask[listFreeW]
	SHR	AX, 2
	Mov	nAvailW, Ax					; 01/21/93 SRE Maintain available W blocks
	CMP	AX, nMinW
	JB	CRUpdateW					;...DHG

CRCheckMinZLocal:					;JA...
	MOV	AX, sgMyShadow
	OR	AX, AX
	JZ	CRUpdateDone
	MOV	ES, AX
ASSUME ES:iccSegType
	MOV	AX, ES:iPut[listFreeZ]
	SUB	AX, ES:iTake[listFreeZ]
	AND	AX, ES:wiMask[listFreeZ]
	SHR	AX, 2
	Mov	nAvailZLocal, AX
	CMP	AX, nMinZLocal
	JB	CRUpdateZLocal
CRCheckMinYLocal:
	MOV	AX, ES:iPut[listFreeY]
	SUB	AX, ES:iTake[listFreeY]
	AND	AX, ES:wiMask[listFreeY]
	SHR	AX, 2
	Mov	nAvailYLocal, AX
	CMP	AX, nMinYLocal
	JB	CRUpdateYLocal
CRCheckMinWLocal:
	MOV	AX, ES:iPut[listFreeW]
	SUB	AX, ES:iTake[listFreeW]
	AND	AX, ES:wiMask[listFreeW]
	SHR	AX, 2
	Mov	nAvailWLocal, AX
	CMP	AX, nMinWLocal
	JB	CRUpdateWLocal				;...JA
CRUpdateDone:

;;	Check rgObit, Abort if obit=1
CRRet:

	%POPMF_AX
	POP DS
	POP BP
	POPF
	RET		2	; bIntSlot is argued to Doorbell handlers

CRUpdateZ:
	MOV	nMinZ, AX
	JMP	CRCheckMinY

CRUpdateY:
	MOV	nMinY, AX
	JMP	CRCheckMinW

CRUpdateW:
	MOV	nMinW, AX
	JMP	Short CRCheckMinZLocal

CRUpdateZLocal:
	MOV	nMinZLocal, AX
	JMP	Short CRCheckMinYLocal

CRUpdateYLocal:
	MOV	nMinYLocal, AX
	JMP	Short CRCheckMinWLocal

CRUpdateWLocal:
	MOV	nMinWLocal, AX
	JMP	Short CRUpdateDone


Chime ENDP

; ****** BmicXmitDmaInterrupt ******
PUBLIC BmicXmitDmaInterrupt
BmicXmitDmaInterrupt PROC FAR
ASSUME DS:DGroup, ES:Nothing
	%BmicDmaComplete Xmit
	%RcbEntry
	PUSH	lIntRet		; 'DI'
	%PUSHMF_AX
	%DispatchXmitDma
	JMP	IccKernelExitOk
BmicXmitDmaInterrupt ENDP

; ****** BmicRcvDmaInterrupt ******
PUBLIC BmicRcvDmaInterrupt
BmicRcvDmaInterrupt PROC FAR
ASSUME DS:DGroup, ES:Nothing
	%BmicDmaComplete Rcv
	%RcbEntry
	%PUSHMF_AX
	%DispatchRcvDma
	JMP	IccKernelExitOk
BmicRcvDmaInterrupt ENDP

; ****** ScheduleRemoteDma ******
PUBLIC ScheduleRemoteDma
ScheduleRemoteDma PROC FAR
ASSUME DS:DGroup, ES:Nothing
	ENTER	0,0
	TEST	fPc, 0FFh
	JZ	ScheduleBmic
	PUSH	DWORD PTR [BP+6]	; pDmaIob
	CALL	DmaAddrFromP
	SHL		EDX, 16
	MOV		ECX, EDX
	XCHG	AX, CX
; Put paDmaIob into proper board dma queue
	LES	BX, DWORD PTR [BP+6]
	MOVZX	BX, ES:[BX].slotId
	MOV	AL, mpbSlotiSlot[BX]
	CBW
	SHL	AX, 1
	XCHG	AX, DI
	MOV	ES, rgSgIcc[DI]
	%Put ECX into ES list listCache using BX,SI leave userFlags

	XCHG	DI, SI		; SI is iSlot*2
	SHR	SI, 1
	%DoorBell(lBmicDoorbellInt)

	LEAVE
	RET 4

ScheduleBmic:
	PUSH	3
	CALL	Crash
	RET 4
ScheduleRemoteDma ENDP


;
; DoorbellRing (iSlot, wInt) ercType PUBLIC REENTRANT
;
; system common, called by the Debugger
;
PUBLIC DoorbellRing
DoorbellRing PROC FAR
ASSUME DS:Nothing, ES:Nothing
	ENTER	0,0
	PUSH 	DS
	MOV		AX, Dgroup
	MOV		DS, AX
ASSUME DS:DGroup
	MOV		AX, 152	;ercNoSuchProcessor
	TEST	vf_fSrp, 1
	JZ		DoorbellRingRet
	MOV		SI, WORD PTR [BP+8]
	CMP		SI, 9	; > maxSlots?
	JA		DoorbellRingRet

; Doorbell macro expects iSlot in SI and bInt argument.
	%Doorbell([BP+6])

	XOR		AX, AX
DoorbellRingRet:
	POP		DS
	LEAVE
	RET		4
DoorbellRing ENDP

;
; DoornailAll PUBLIC REENTRANT
;
; Called by FinishCrash
;
PUBLIC DoornailAll
DoornailAll PROC FAR
ASSUME DS:DGroup, ES:Nothing
	ENTER	0,0
	MOV	SI, 8
DoornailLoop:
	PUSH	SI
	MOVZX	AX, mpiSlotbSlot[SI]
	LES	BX, pMasterFPCdt
	ADD	BX, AX
	TEST	ES:rgbBusConfigTable[BX], 80h
	JNZ		DoornailNext
	TEST	BYTE PTR [BP+6], 0FFh
	JZ	DNReset
	%Doornail
	JMP	DoornailNext
DNReset:
	MOV	CX, SI
	%Doormat CL
DoornailNext:
	POP	SI
	DEC	SI
	JNZ	DoornailLoop
	LEAVE
	RET 2
DoornailAll ENDP

;
; AbortBoard (bSlot) PUBLIC REENTRANT
;
PUBLIC AbortBoard
AbortBoard PROC FAR
ASSUME DS:DGroup, ES:Nothing
	ENTER	0,0
; Mark board dead.
	LES	BX, pCdt
	MOV	SI, [BP+6]
	OR	ES:rgbBusConfigTable[BX][SI], 80h
	MOVZX	SI, mpbSlotiSlot[SI]
	SHL	SI, 1
	MOV	rgSgIcc[SI], 0
; Return all rqs outstanding to bSlot ercTargetProcessorDead.
	MOVZX	ECX, nIccBuffers
AbortContinue:
	MOV	ES, sgMyIcc
ASSUME ES:iccSegType
	MOV	ESI, ES:orgOwnBuffer
AbortLoop:
	MOVZX EAX, BYTE PTR [BP+6]		; bSlot
	CMP	ES:BYTE PTR [ESI][ECX*2], AL
	JE	AbortBuf
	LOOP	AbortLoop
	MOV	AL, mpbSlotiSlot[EAX]
	MOV	ES:BYTE PTR rgObit[EAX], lObitDone
	LEAVE
	RET 2

AbortBuf:
; Buffer ECX is owned by dead guy.  Return erc.
	PUSH	ECX
	XOR	EBX, EBX
	TEST	fPc, 0FFh
	JZ	AbortBmic
	LES	BX, pRgpBuffer
	LES	BX, ES:DWORD PTR [EBX][ECX*4]
	MOV	CX, ES:buf_wRcb[BX]
	JMP	AbortRespond
AbortBmic:
	LES	BX, pRgPaBuffer
	MOV	ESI, ES:[EBX][ECX*4]
	%PeekwPa	ECX, buf_wRcb[ESI]

AbortRespond:
	MOV	ES, sgRcbSeg
ASSUME ES:iccRcbSeg
	MOV	BX, CX
	%RcbDispatch ES:BX, rcbAssume
	LES	DI, rcb_pRq
ASSUME ES:Nothing
	MOV	ES:WORD PTR ercRet[DI], ercTargetProcessorDead
	MOV	CL, rcb_bSlot
	MOV	AX, DGroup
	MOV	DS, AX
ASSUME DS:DGroup
;	ES:DI		pRq
;	CL			bSlot

	XCHG	AX, DI
	MOV	BX, rcb_iBuf
	MOV	rcb_fFree, 0FFh
	%RcbFree

	CALL DoneRespondMove
	POP	ECX
	JMP	AbortContinue
AbortBoard ENDP


; Suspend the DMA on both channels if active
;	-  we are doing this to work around a BMIC problem where peeks and/or pokes
;		done during the end of the DMA xfer have corrupted data

PUBLIC SuspendDma
SuspendDma PROC NEAR
ASSUME DS:Nothing, ES:Nothing
	PUSH  AX
	PUSH  DX
	XOR   AH, AH						; flag
	%BmicPort iBmicXmitDmaStatus
	IN    AL, DX
	TEST  AL, 8							;dma in progress?
	JZ    susp0							;  no, try chan1
	MOV   AH, 1							;  chan0 suspended flag
	%BmicPort iBmicXmitDmaMode			;  yes, suspend
	MOV   AL, lBmicDmaModeInt  OR 01h	; suspend channel 0
	OUT   DX, AL
susp0:
	%BmicPort iBmicRcvDmaStatus
	IN    AL, DX
	TEST  AL, 8							;dma in progress?
	JZ    susp2							;  no, do not suspend
	OR    AH, 2							;  chan1 suspended flag
	%BmicPort iBmicRcvDmaMode
	MOV   AL, lBmicDmaModeInt  OR 01h	; suspend channel 1
	OUT   DX, AL
susp2:
	TEST  AH, 3H
	JZ    susp8							; no channels suspended, leave
	TEST  AH, 1H						; chan0 suspended?
	JZ    susp5							;  no, so check chan1
	%BmicPort iBmicXmitDmaStatus		;  yes, so...
susp3:									
	IN    AL, DX						; chan0: wait for xfer
	TEST  AL, 8							;tsten = 1?  (xfer enabled)
	JNZ   susp3							;  yes, so reread chan0 status
susp5:
	TEST  AH, 2H						; chan1 suspended?
	JZ    susp8							;  no, so leave

susp4:
	%BmicPort iBmicRcvDmaStatus
susp6:
	IN    AL, DX						; chan1: wait for xfer
	TEST  AL, 8							;tsten = 1?
	JNZ   susp6							;  yes, so reread chan1 status

Susp8:
	POP  DX
	POP  AX
	RET
SuspendDma endp 


; Unsuspend the DMA after peek/poke completed  (if active)

PUBLIC UnsuspendDma
UnsuspendDma PROC Near
	PUSH  AX
	PUSH  DX
	%BmicPort iBmicXmitDmaMode2
	IN    AL, DX
	TEST  AL, 1							; chan0 suspended?
	JZ    UnSusp0						; no, so go test chan1
	MOV   AL, lBmicDmaModeInt			; unsuspend channel0
	OUT   DX, AL
UnSusp0:
	%BmicPort iBmicRcvDmaMode2
	IN    AL, DX
	TEST  AL, 1							; chan1 suspended?
	JZ    UnSusp1						; no, so leave
	MOV   AL, lBmicDmaModeInt			; unsuspend channel
	OUT   DX, AL

UnSusp1:
	POP   DX
	POP   AX
	RET
UnSuspendDma ENDP 

PUBLIC FMasterRqSentTestAndClear
FMasterRqSentTestAndClear PROC FAR
userNum		EQU		WORD PTR SS:[BX+6]
	PUSH	DS
	MOV		AX, DGroup
	MOV		DS, AX
ASSUME DS:DGroup
	MOV		BX, SP
	MOV		BX, userNum

	SUB		BX, wMySlotBits
	CMP		BX, userNumLast
	JA		FMRSRetOk
	MOV		AX, sgTermTable
	MOV		GS, AX
; iTable=iUser*2
	SHL		BX, 1
	MOVZX	EAX, bMasterCpCpuId
	MOV		AL, mpbSlotiSlot[EAX]
	BT		GS:WORD PTR [BX], AX	; WORD PTR to make assembler happy
	MOV		AX, 0		; NOT XOR!!  ruins Z flag
	MOV		GS, AX
	JZ		FMRSRet
	DEC		AL
FMRSRet:
	POP		DS
ASSUME DS:Nothing
	RET	2
FMRSRetOk:
	XOR		AX, AX
	JMP		FMRSRet
FMasterRqSentTestAndClear ENDP

Kernel ENDS

END
; LOG
; 3/15/88 JA Created.
; 5/05/88 by RLM is DL = bmyslot then route local in RequestToSlot.
; 6/6/88 by JM/RLM fix remoteDma SCASW; setup SI and AL in SendRemote so
;		ok for CheckRqConsistency.
; 6/13/88 by RLM POPMF_AX was done early in respondtoslot, reg's still need
;			 to be set up in RingDoorBell, then restore reg's.
; 6/20/88 by JM/RLM encode islot in rq.respExch and rq.userNum of off board
;			requests. Fix real mode MapPbToPa.
;7/11/88 by JA/PGJ put slot bits in rq.userNum even for 0.
;7/20/88 by JA call InitSlotAddressTables 1st time addressing a slot.
;8/25/88 by JA, userNum 1 -> userNumPrimary.  Round to word boundaries.
;9/6/88 by JA, SendRemote mask SI to make rqNum.
;9/20/88 by JM, fix SrpDevice routing.
;				check for orphaned requests.
;9/26/88 by JM/RLM/JA commitee bug fix for remote dma requests.
;9/27/88 by JA ResumeNoSuchBoard re-assert br0.  NoSuchBoard save DI.
;10/4/88 by JM/RLM don't make global handle if non-zero rq.ercRet on open.
;10/7/88 by JM fix DeAliasGh to preserve route info over fixup loop.
;10/19/88 by JA desc286_ -> desc_
;10/22/88 by JA Chime PUSHMF,POPMF, set/clear mask in ctosp.
;10/25/88 by JA/SAR Fix FillInRemoteDmaPa in ctosp.
;11/10/88 by JA separate assembly for icc.
;12/2/88 by JA expunge Kernel_icc because of v4 linker bug.
;12/12/88 by JM rRemote, rMasterFp and rMasterCp are now routed by
;		the slot bits of the service exchange.
;12/20/88 by JA/RLM RequestToSlot do PUSHMF, RingDoorBell do LEA SP,wRemoteRegs
;1/5/89 by JA/RLM AllocExch first time Request queues to a slot.
;	  Short rets in WaitiSlot.  ES=sgMyIcc before Jmp ChimeRet.
;1/9/89 by JA added DoCrashCorruptQueues, ercCorruptIcc.
;1/11/89 by JA make buffer,request,respond queues have DWORD elements (GP fast).
;			Remove ControlInterrupt, fChimeEnabled.
;			Update nMinY,nMinZ.  Inc cWaits.  Set ECX for MOVSD.
;			Fix WakeWaiter bit bugs.  RequestRemote set CX slot bits.
;1/16/89 by JA RequestToSlot CX always has correct slot bits,  DL not needed.
;		RequestRemote must do all code in Request so spec expansion works.
;1/19/89 by JA IccErrorExit routine restores wRtInfoSave.
;1/20/89 by JA QueueBlockWait use KSend.
;1/23/89 by JA req/resp data on dword boundaries.
;			Rq header leave room for 3-byte pointers, 2-byte cbs.
;1/25/89 by JA Chime call RespondCommon with DL=bSlot.
;1/28/89 by JA Buffer, icc segment may have different br0.  OutBaseRegsDX again.
;				Also put br0 in rcb.
;1/31/89 by JA/AT load DX in PokeAddressBoard.
;2/14/89 by JA ProcessRequest/Respond JS so won't look before queue filled.
;4/10/89 by JA/RLM fDebug code in MapPbToBa.
;04/19/89 by AT, Removed NumberOfBlockInit, SizeOfBlockInit.
;04/24/89 by JA, BEEF fill response buffers.
;05/11/89 by JA, initialize RemoteSlotPort to nullCpuId.
;05/12/89 by JA/PC, fSyncCheck.
;05/25/89 by JA, rgcRq.  Set buf_sync atomically with Put.
;05/26/89 by JA, added RequestStats.
;06/02/89 by JA, add CLD.
;07/18/89 by JA/MTR, JCXZ after remote dma skipped (i.e. only 1 pbcb).
;		Also test nPbCb after StartCopyLoop in case remote dma pb is only pb.
;07/19/89 by JA, added fMapper calls to (Un)MapBusAddress.
;08/19/89 by JA, sHandleRecord 6 until GP word-span-dword buss bug fixed.
;10/5/89 by JA, rDevice Respond TestClose skip if erc.
;10/05/89 by DHG, included stats for w blocks.
;10/10/89 by JA, WakeWaiter fix arithmetic - solve YBlock wait hangs.
;10/10/89 by JA QueueBlockWait use KForwardRequest.
;10/12/89 by JA Save, restore ercRet=exchDirect around KForwardRequest.
;10/12/89 by JA check for icc.wSignature = lSigIcc.
;10/13/89 by JA IccErrorExit set DS=DGroup.
;10/13/89 by JA RequestToSlot erc odd sCntInfo on GP.
;10/13/89 by JA add cRqWait, PollWaitSatisfied to trigger retry in Periodic.
;10/16/89 by JA use rtSrpInfo flags fDma,fDmaLocal.
;10/25/89 by JA keep mpcbcRq statistics.
;11/02/89 by AT add fAfterSync, mpiSlotbStatus.
;12/12/89 by JA remove fSyncCheck; AliasPbCbLoop clear resp word.
;		Also WaitSatisfied can't do 32-bit push - stack is 16-bit.
;		Also BlockWait compare pRq<>pRqWait, JMP QRBWQueue to fix Request race.
;12/13/89 by MTR/AT mask dmaRt from srpRtInfo before CMP with iDevice.
;12/14/89 by MTR Treat dummy (padded) request codes like no such request codes.
;12/14/89 by JA CLD before STOSW.  No 32-bit immediates. NoFixupAvail repair rq.
;12/16/89 by AT/MTR opEnable for PollWaitSatisfied in ChimeRet and with CLI
;			 (prevent interrupt from nesting).
;12/20/89 by JA OpenGh, DealiasGh check net bit, don't map those handles.
;12/21/89 by JA when response cb = 0 round to 1 (reserves a quad) so there's
;		room to clear at least a word.
;12/21/89 by JA ver sa's before loading.  BusAddress pb tolerate NIL if cb=0.
;		All other pb tolerate bad ptr.
;12/29/89 by JA CopyPbCbLoop don't copy 1 byte when cb=0.
;1/9/90 by JA NoFreeRcb clear rgOwnBuffer(iBuf) when freeing buffer.
;02/15/90 by JLA respond to slot check the rq.
;02/23/90 by AT/MTR Use KSend instead of KForwardRequest
;	BMIC/PC "COMARCH" Icc
;01/28/92 by JA expunge non-ctosp; use peek/poke.
;01/29/92 by JA use KSendRequest instead of KSend.
;02/04/92 by JA Chime use dma.
;03/12/92 by JA Put, Take destroy EAX.
;03/26/92 by JA PC version.
;04/24/92 by JA expunge rgcRqDelta, KernelErrorExit.
;11/06/92 by sg/ja  fix ringdoorbell, ChimeRet.
;11/09/92 by JA IccDma
;12/09/92 by JA DmaPbBig iterate if too large for Xfer buffer
;12/11/92 by JA BmicXmitDmaInterrupt, BmicRcvDmaInterrupt
;12/18/92 by JA Use rcbs for process state (so can block/resume over dma)
;02/09/93 by JA ScheduleRemoteDma
;02/17/93 by JA Lift macro.  RetryiSlot check iSlotMax.
;02/24/93 by JA WakeWaiter bSlot=[BP+4] not +2].
;03/29/93 by JA DmaPbBig wrong by buf_rq; also DoReserveCb so resp placed ok.
;				No dmaPbBig if no dma (if PC).
;03/31/93 by JA EXTRN mpiLinebSlot,cbLineTable.
;04/06/93 by JA RequestToSlot limit xmit dma to 10k.
;04/13/93 by JA NoGhAvail erc to client, not caller of Respond.
;04/13/93 by JA RequestToSlot enter RingDoorbell cli so rcb protected.
;04/15/93 by JA Merged:
 ;05/18/90 by MTR add rUserId
 ;09/17/92 by JM create procedure MapGlobalHandle, so 
 ;				RequestDirect/ForwardRequest can map handles
 ;01/21/93 by SRE Maintain available W, Y, and Z block counts.
;04/27/93 by JM Chime now called from BmicInterrupt with bIntSlot arg.
;				Doorbell macro takes bInt arg.
;				Add DoorbellRing system common call for the Debugger.
;05/03/93 by JA expunge dmaPbBig.  RequestToSlot stage-dma arbitrary size rq.
;05/04/93 by JA RespondToSlot copy ercRet.
;05/11/93 by JA Mgh_CreateFhFixup test lcRqInc, not 2.
;05/14/93 by JM rgTermTable is based sgTermTable.
;05/20/93 by JA rewrite: use own buffers for outbound.
;05/25/93 by JA use ERequest/Direct.
;06/01/93 by JA mpiSlotUsernumMac, exchObit PUBLIC.
;06/03/93 by JA survive RemoteBoardDead, CorruptRemoteQueues, OutOfSequence.
;				Speedy nAvailZYW.  Keep icc.mpCbCRq locally.
;06/04/93 by JA BTS AX must have AH zero.
;06/04/93 by JA RequestToSlot don't Peek buf_pa, rather skip on dma.
;06/07/93 by JA ServiceNotAvail if icc not up yet.
;06/08/93 by JA RespondToSlot always update ercRet; RequestToSlot zero ercRet.
;06/09/93 by sg add SuspendDma and unSuspendDma.
;06/09/93 by JA add DoornailAll.  Fix ShadowError SHL SI,1
;06/11/93 by JA PUBLIC SuspendDma, UnsuspendDma.  Also LogDoornail tyLogOsMisc.
;06/14/93 by JA DoornailAll CX spoiled by Doormat macro.  AbortBoard mark 
;				board dead; don't use oRcbDmaRcvHead.
;				mpiSlotUsernumMax index by usernum.iSlot, not respExch.iSlot.
;06/16/93 by JA mpcbcRqLocal, nMinZ/Y/WLocal.
;06/18/93 by JA WakeWaiter had bogus PUSH/POP SI, expunged.
;06/25/93 by JA rLocal RequestToSlot so exchAgent works.
;06/29/93 by JA MultiHopRequest so EP01->EP00->EP02 works.  respExch OR 8000h.
;7/29/93  by JA AbortBoard set rgObit(iSlot) not (bSlot).
;8/5/93   by JM move lMultiHop to kernel.mdf
;8/9/93   by JA SrpUserId send out-of-bounds userNums to bSlot(exchNet).
;				ShadowError inc rgSyncIn.  RespondCopyDone help Iop watchdog.
