;SET(Debug,0FFh)	;Replace percent with semicolon to disable debug.
$MOD286

; Communications Interrupt Nub - InitCommLine Version
;
; This module contains conditional assembly for several versions:
;
;	CommNub_p
;
; THIS ASSEMBLY IS THE %nub VERSION
;
; This module is new for 10.0 CTOS.  The versions parallel earlier modules
;  called CommInt_i.asm, CommInt_a34.asm, and CommInt_t1.asm which contained
;  duplicated code rather than conditional assembly directives.  It supports
;  XC-002 and supports the InitCommLine interface rather than SetCommIsr.
;  Because the old SetCommIsr interface must still be supported,
;  the new module names are different so both can be used in an OS build.
;
; CommNub_all.asm is an INCLUDE file.
;
; Written 12/84 by DC.
;
; Change log:
;
; Aug 10 1985 MEC  Changed ICode segment to Code;
;			 added swapper compatibility (pre_10 version only)
; Aug 14 1985 JM   add nops after channel reset for 286
; Mar 17 1986 JA/RLM fCp, StatVect to port ioVector
; Jun 13 1986 JA/GW Remove above "fix"
; Jun 27 1986 RLM add JMP $+2 between consecutive IOs for 286.
; Sep 29 1986 DR  CTOS II 2.0 merge
; Oct 10 1986 FW/DR Zin/Zout use Jmp $+2 always
; Mar 26 1987 DR Support protected MedCommNub
; Mar 31 1987 JA invent oLocals for multi-8274 machines (SrpTp)
; Jan 11 1988 JA/RLM merge Srp 1.4 and VM.
; Aug 31 1988 JA remote interrupt controller EOI code - RET so Kernel does it.
; Nov 21 1988 JM merge:
; Apr 21 1988 TAB Reset channel again in ResetCommPort for 386i.
; Sep 29 1988 FW After all channel resets, we MUST wait 4uS.
; Feb 27 1989 JA add CI version.
; Jun 06 1989 JMR added read before write for 8530 to be sure we talk to WW9.
;	1/12/90	JMR moved fi to allow protected mode medints to get rgcommline.
; Mar 23 1990 DR for v series, put usernum in AX before CallRealCommISR
; 07/7/90	JMR Rewrote to support multiple different COMM CNT.
; 07/11/90	JMR fixed SpuriousRawCommIsr
; 06/07/92  RA Fixed sense logic to determine interrupt source for 2681.
;              Reset channel for 2681 ports.
; 08/18/92  RA On SG3000 we could loose interrupts ('cause they are edge 
;			   triggered?), so check if interrupt pending on the comm. chip
;			   at the end of processing of current interrupt.
; 11/04/92  RA 2681 Commnub is not giving thr right port address (in DX) to
;			   the client ISR, fixed this. Some rework of the 2681 code.
; 03/10/93  RA Extend meaning of PCType.
; 03/22/93  RA Support for Sg4k/6k.
; 06/16/93  RA Support for ComArch ISDN.
; 06/24/93  RA Sg4k/6k ECOM, SCC locks out due to lost interrupts. Loop back in
;			   nub to check for new interrupt. *AA*
; 07/01/93  JM set ES in RawCommNubISDNAD.
; 07/05/93  RA Sg4k/6k, re-poll the SCC after eoi'ng it. *AA*
; 07/20/93  RA Code for the difference between 8530 and 85C30. *AA*
; 07/30/93  JM ISDN case: write tss.ldt when loading LDT.
; 08/02/93  RA ISDN Ch-D return to commNub convention different. *AA*

$Include(:f1:descriptors.mdf)

b8274Type		EQU 0
b8530Type		EQU 1
b2681Type		EQU 3
b16450Type		EQU 4
b16551Type		EQU 5

commWr1			EQU 1
commWr3			EQU 3
commWr5			EQU 5
commWr9			EQU 9
commRr2			EQU 2
commRr3			EQU 3 ;*AA*
commResCh		EQU 018h
commReti		EQU 038h
commErrRes		EQU 030h
commRxInt		EQU 010h
commResTxInt	EQU 028h
comm0TxRdy		EQU 4
comm0IntPending EQU 2
comm0RxRdy		EQU 1
comm1StatVect	EQU 4
comm9ResCh		EQU 80h
comm9IntNV		EQU 0Ah
commr2Int		EQU 7
b2681RxRdy		EQU 1h
b2681TxRdy		EQU 2h

;AA
;oSR             EQU 36
oSR             EQU 54
rxMask			EQU 02
txMask			EQU 01
oCR             EQU 40
fcommIpBits		EQU 3Fh

; Masks used for the 2681 interrupt status register

mBrk        EQU 04H
mBrkA       EQU 04H
mBrkB       EQU 40H
mCtlChanA   EQU 07H

mCtlChanB   EQU 70H
mCntRdy     EQU 08H
mIPCS       EQU 80H

; Masks used for the 2681 communication status register

mRcvdBrk	EQU 80H
mError		EQU 70H
mRcvRdyOrFFull	EQU 03H
mTxRdyOrEmpty	EQU 0CH

; Literals used for the 2681 command register

RcvDisable		EQU 02h
TxDisable		EQU 08h
ResetErrStatus		EQU 40h
ResetChannelBrkChgInt	EQU 50h
ResetTransmitter	EQU 30h
ResetReceiver		EQU 20h

;RA

mCtlUnused		EQU 0F8h
mCtlChan		EQU 04h
mCtlIsrType		EQU 03h

sMediatedArgs	EQU 4

;*AA*
;ISDN
; Register offsets in the Z16C30 chip
DCCR            EQU 34h           ; daisy chain reg.
CommISDN		EQU 10h
CommIsdnChD		EQU 20h


; PUBLICS
; Procedures in segment CommNub (CODE) - not called from overlays
	PUBLIC  RawCommNub, MedCommNub, MedCommNubReturn, SpuriousRawCommIsr
	PUBLIC  RawCommNubAB, RawCommNubB, RawCommNubCD, RawCommNubEF, RawCommNubGH
	PUBLIC  pRawCommNub, pMedCommNub, pMedCommNubReturn, pSpuriousRawCommIsr
;ISDN
	PUBLIC RawCommNubIsdnAD, RawCommNubIsdnB1, RawCommnubIsdnb2
	PUBLIC pRawCommNubIsdnAD, pRawCommNubIsdnB1, pRawCommnubIsdnb2
; Procedures in segment CommAsm (CODE) - may be called from overlays
	PUBLIC  ResetCommPort


; EXTERNALS
	EXTRN	MediateIntHandler:FAR, KPSend:FAR, Crash:FAR
	EXTRN	CallRealCommIsr:FAR
	EXTRN	SetLdtrDs:FAR
DGroup	  GROUP DATA

Data		SEGMENT PUBLIC 'DATA'

; PUBLIC'ed DWORD POINTERs necessary to avoid linker errors when
; refering to these entry points in overlaid modules.
; If this module itself is overlaid, we get Ill Seg Ref Type 1
pRawCommNub		 DD RawCommNub
pMedCommNub		 DD MedCommNub
pMedCommNubReturn   DD MedCommNubReturn
pSpuriousRawCommIsr DD SpuriousRawCommIsr
pRawCommNubIsdnAD DD RawCommnubIsdnAD
pRawCommNubIsdnB1 DD RawCommnubIsdnB1
pRawCommNubIsdnB2 DD RawCommnubIsdnB2

	EXTRN	rgCommLine:WORD		; declared PUBLIC in CommStatus_all.plm
								;  (for pre10 case) and Sysgen.mdf (for
								;  all OS cases).

;
; DECLARE rgCommLine(nCommLines) CommLineType EXTERNAL;
;
; DECLARE CommLineType LITERALLY 'STRUCTURE (
;
;	pProcRaw(4) POINTER		/* raw interrupt ISR entry points */
;	pProc2nd(4) POINTER		/* mediated interrupt ISR entry points, or secon-
;							dary raw ISR entry points (SetCommIsrRaw) */
;	pDsBx		POINTER		/* user's preferred DS and BX upon entry */
;	oIoCtl		WORD		/* control port - placed in DX on entry */
;	oIoData		WORD		/* data port */
;	oIoIntRet	WORD		/* channel A control port on same 8274 */
;	oIoVector	WORD		/* channel B control port on same 8274 */
;	oUserNum	WORD		/* current owner ( none = 0FFFFh) */
;	oHandle		WORD		/* commLineHandle:
;							high byte = 0 for processor ports
;										1 for leftmost XC-002
;										2 for next XC-002
;							low byte = line number (0 = channel A)
;						*/
;	ldtr		word		/*  ctosp only */
;	fDma		BYTE		/*  ctosp only */
;	fDmaAvail	BYTE
;	NRZIType	BYTE
;	ChipType	BYTE		/*  as chip type for InitCommLine */
; )';

; offsets in rgCommLine entry
orgpProcRaw	EQU 0
orgpProc2nd	EQU 16
opDsBx		EQU 32
oIoCtl		EQU 36
oIoData		EQU 38
oIoIntRet	EQU 40
oIoVector	EQU 42
oUserNum	EQU 44
oHandle		EQU 46

oLdtr		EQU 48
ofDma		EQU 50
ofDmaAvail	EQU 51
oNRZIType	EQU 52
oChipType	EQU 53
oBaudRateIO	EQU 54
oBRGModeIO	EQU 56
oBaudRateIOType	EQU 58
oExtCtlRegImg	EQU 59
opExtCntRegImg	EQU 60
oExtCtlReg		EQU 64
oExtStatReg		EQU 66
oExtClkCntReg	EQU 68
oLineStatReg	EQU 68
oTRxDirMask		EQU 70
oDTRSourceMask	EQU 71
oioExtra1		EQU 72
oioExtra2		EQU 74
oioExtra3		EQU 76
oIntOpMask		EQU 78
;*AA*
oPCType			EQU 82
sCommLine		EQU	86
maskRealMode	EQU 1
s8274			EQU sCommLine*2		; two entries (two channels on one 8274)

; Static vars used to preserve stuff through MediateIntHandler call.
wSI		EQU 0				; orgCommLine
wDI		EQU 2				; opProcRaw
idExch	EQU 4				; raw interrupt user's exchange to PSend
pMsg	EQU 6				; raw interrupt user's message to PSend

%if(%*Isdef(%ISDNTest)) then(
PUBLIC nTempRxDataISR
PUBLIC nTempTxDataISR
PUBLIC nTempNotValidISR
PUBLIC nTempTxISR
PUBLIC nTempExtISR
PUBLIC nTempRxISR 
PUBLIC nTempSpRxISR
PUBLIC nTempB1Isr
PUBLIC nTempB2Isr
PUBLIC bSaveDCCR
PUBLIC nTempB1Send
nTempTxDataISR DB 0
nTempRxDataISR DB 0
nTempNotValidISR  DB 0
nTempTxISR  DB 0
nTempExtISR  DB 0
nTempRxISR  DB 0
nTempSpRxISR  DB 0
nTempB1Isr  DB  0
bSaveDCCR   DB  0
nTempB1Send DB  0
nTempB2Isr  DB  0
)fi

EXTRN sgLdtOS: WORD
Data		ENDS

; MACROS

; ZIN and ZOUT are IN and OUT for Z80-SIO to ensure separation from DMA

%*DEFINE (ZIN(a,b))(%'
	JMP $+2
	IN  %a, %b
)

%*DEFINE (ZOUT(a,b))(
	JMP $+2
	OUT %a, %b
)

%IF(%*Isdef(%Debug))  THEN (
rgTables SEGMENT PUBLIC 'Coed'
rgTables ENDS
LogSeg SEGMENT PUBLIC 'Coed'
PUBLIC LogSegIndex
LogSegIndex LABEL BYTE
	DD 16370 DUP (0)
LogSeg ENDS
FooSeg SEGMENT PUBLIC 'Coed'
	DD 14 DUP (0)
FooSeg ENDS

%*Define(Log(w))(
	PUSH	DS
	PUSH	BX
	MOV		BX,LogSeg
	MOV		DS,BX
	PUSHF
	CLI
	MOV		BX,DS: WORD PTR [0]
	ADD		BX,2
	JZ		.-3
	MOV		DS: WORD PTR [0],BX
	POPF
	MOV		DS: WORD PTR [BX],%w
	POP		BX
	POP		DS
)
)ELSE(%'No debug
%Define(Log(w))()
)FI

; PROCFAR, PROCNEAR, and ENDPROC define procedures with stuff
; around them to satisfy the CALL/RET convention.  Nobody looks
; at the "push bp" or the "ret" except the linker.

%*DEFINE (PROCFAR(name))(
%name	PROC	FAR
)

%*DEFINE (PROCNEAR(name))(
%name	PROC	NEAR
)

%*DEFINE (ENDPROC(name))(
%name	ENDP
)

%*define(LoadLdt(regLDT)) (
; LLDT plus write tss.ldt so tss can survive task switch (e.g. breakpoint)
		LLDT	%regLDT	
		STR		AX		;ax=sgTss
		SUB		AX, 8	;ax=data alias for sgTss
$MOD386
		MOV		FS, AX
		MOV     FS:[rTss386LDT], %regLDT	; tss.ldt=ldt
$MOD286
)



CommNub	 SEGMENT PUBLIC 'CODE'
			ASSUME  CS:CommNub


%PROCFAR(RawCommNub)

		CLI


; SI will become our oCommLine for this channel.

RawCommNubAB:
		MOV	 SI,OFFSET DGroup:rgCommLine
		JMP	 Short RawCommon
RawCommNubB:
		MOV	 SI,OFFSET DGroup:rgCommLine+sCommLine
		JMP	 Short RawCommon
RawCommNubCD:
		MOV	 SI,OFFSET DGroup:rgCommLine+s8274
		JMP	 Short RawCommon
RawCommNubEF:
		MOV	 SI,OFFSET DGroup:rgCommLine+s8274+s8274
		JMP	 Short RawCommon
RawCommNubGH:
		MOV	 SI,OFFSET DGroup:rgCommLine+s8274+s8274+s8274

RawCommon:

; Find our DGroup, where our table lives.
		MOV	 CX, DGroup
		MOV	 ES, CX
		ASSUME  ES: DGroup

; Acknowledge the interrupt and read the vector to find channel number
; and interrupt type.
		MOV	 AH,ES:[SI+oChipType]
		CMP	 AH,b8530Type
		JA	  Try2681Type
InterruptPending:
		MOV	 DX,ES:[SI+oIoVector]
		MOV	 AL,CommRr2
		OUT	 DX,AL
		JMP	 $+2				; flush pipe
		IN	  AL,DX

		CMP	 AH,b8530Type
		JNZ	 NoShift
		SHR	 AL, 1			   ; 8530 sets bits 123, not 012 as in 8274.
NoShift:
; Now determine which of the channels it was.
		test	AL,mCtlChan		 ; test vector
		JNZ	 IndexpProc		  ; if channel A
;*AA...*
%if(0) then (
		if rgCommline.PCType = CommEisa then /*on the sg4k/6k only Ch-A of the
			GOTO Spurious;					   8530 is used.
											 */
)fi
		MOV	CL, ES:[SI+oPCType]
		ROL	CL, 1
		JC	Spurious
;*...AA*
		ADD	 SI,sCommLine		; increment to next rgCommLine entry
		%LOG('LB')

; Index the appropriate ISR's pProc.
IndexpProc:
		AND	 AX,mCtlIsrType	  ; interrupt type (in low order 2 bits)
		SHL	 AX,2				; convert to dword offset
		MOV	 DI,SI			   ; preserve SI (oCommLine)
		ADD	 DI,AX			   ; DI is opProcRaw
		JMP	 GotVector
;*AA*
Try2681Type:
		CMP		AH,b2681Type
		JA		Try16450Type
		MOV		DX,ES:[SI+oIoVector]	; read ISR
		IN		AL,DX
		AND		AL,07H
		JZ		Spurious
TestChannel:
		MOV		DI,SI			; preserve SI (oCommLine)
        TEST    AL, mBrkA           ;
        JNZ     FromBrkA            ; if break A
        MOV     DX,ES:[SI+oSR]   ; read status register A
        IN      AL,DX
        TEST    AL,mRcvRdyORFFull
        JNZ     FromRcvRdy
        TEST    AL,mTxRdyOrEmpty
		JNZ		GotVector
        TEST    AL,mError
        JNZ     FromErrorCnd
Spurious:
		JMP		DoEoi

FromBrkA:
		ADD		DI,4				; second entry in rgCommLine
		JMP		GotVector

FromRcvRdy:
        TEST    AL,mError
        JNZ     FromErrorCnd
        ADD		DI,8         		; third entry in rgCommLine
        JMP     GotVector

FromErrorCnd:
        ADD		DI,12				; fourth entry in rgCommLine
        JMP     GotVector

Try16450Type:
		CMP		AH,b16551Type			;same as b16450Type except has FIFO
		JA		TryNextType
		MOV		DX,ES:[SI+oIoVector]	; read ISR		
		MOV		DI,SI			; preserve SI (oCommLine)
		%ZIN	(AL,DX)
;*AA*
NewInterrupt:					; jump back here if interrupt pending
		AND		AL,06h			;Make special FIFO RCV int.
		JNZ		Not450Ext
		ADD		DI,4			; DI is opProcRaw
		JMP		GotVector
Not450Ext: CMP	AL,6
		JNE		Not450SpRx
		ADD		DI,12			; DI is opProcRaw
		JMP		GotVector
Not450SpRx: CMP	AL,4
		JNE		is450Tx
		ADD		DI,8			; DI is opProcRaw
is450Tx: JMP		GotVector



TryNextType:
; Add more chip types here

GotVector:
; Load the user's DX
		MOV	 DX,ES:[SI+oIoCtl]

; for CTOSp, switch to user' ldt
		mov	 bx, word ptr ES:[SI+oLdtr]
		cmp		bx, maskRealMode
		je		DispatchRealCommIsr
		lldt	bx
; Load the user's DS:BX
		LDS	 BX,DWORD PTR ES:[SI+opDsBx]
		%LOG(BX)

; Call the appropriate raw ISR.
		PUSH	DI
		PUSH	SI
		CALL	DWORD PTR ES:[DI]
		POP		SI
		POP		DI
		%LOG('RT')
		mov		cx, ds				; users ds, for Sig

		jmp		short ISRDone

DispatchRealCommIsr:

; Load the user's DS:BX
		MOV	 BX,WORD PTR ES:[SI+opDsBx]
		MOV	 CX,WORD PTR ES:[SI+opDsBx+2]
		MOV	 AX,WORD PTR ES:[SI+oUserNum] ; needed by v series only

; Call the appropriate raw ISR.
; Prior to call,
;	DX = i/o port
;	BX = user's BX
;	CX = user's DS
;	DI = opProc
;	ES = DGroup
;   AX = usernum (needed by vseries)
		PUSH	DI
		PUSH	SI
		CALL	CallRealCommIsr
		POP		SI
		POP		DI
; On return,
;	AX,BX,CX valid data (CX is really user's DS)
ISRDone:
		MOV	 DX,DGroup		   ; restore DGroup to ES
		MOV	 ES,DX			   ;
		mov		ds, dx				; clobber user ds so we will not
									; fault on next interrupt
		OR	  AX,AX			   ; did user want to PSend?
		JZ	  SendEoi

; User's raw interrupt routine returned non-zero AX, so
;  do a PSend for it.
Sig:
		%LOG('SG')
		PUSH 	ES
		PUSH	SI
		PUSH	AX
		PUSH	CX
		PUSH	BX
		MOV	 AX,DGroup
		MOV	 DS,AX
		ASSUME  DS:Dgroup
		CALL	KPSend
		POP		SI
		POP		ES


; User's raw interrupt routine returned zero AX, so exit interrupt
;  without awakening any process.
SendEoi:
;*AA*
		ASSUME  ES: DGroup
		MOV	AL, ES:[SI+oPCType]
		ROR	AL, 1					;check pending interrupts only for SG3000
		JC	NextCheck
		JMP	DoEoi
NextCheck:
		MOV	 AH,ES:[SI+oChipType]
;		CMP	 AH,b16450Type			;if new SG3000 (?) with different UART
;		JAE	 CheckPending			;then include these three instructions
;		JMP	 DoEoi					;to conditionally check comm status
CheckPending:
		MOV		DX,ES:[SI+oIoVector]	; read ISR		
		%ZIN	(AL, DX)
		MOV		CL, AL
		ROR		CL, 1
		JNC		IntPending
		JMP		DoEoi
; No return from jump. Do EOI will return to kernel
IntPending:
		MOV		DI, SI
		JMP		NewInterrupt
%ENDPROC(RawCommNub)
%PROCFAR(RawCommNubIsdnB1)

		CLI

        MOV     SI,OFFSET DGroup:rgCommLine + (sCommLine)
		JMP		IsdnCommon
%if(%*Isdef(%ISDNTest)) then(
		INC	nTempB1Isr
)fi

RawCommNubIsdnB2:
        MOV     SI,OFFSET DGroup:rgCommLine + (sCommLine*2)
		JMP		IsdnCommon
%if(%*Isdef(%ISDNTest)) then(
		INC	nTempB2Isr
)fi

RawCommNubISDNAD:
		mov si, offset DGroup:rgcommline+(sCommline*3)
		mov di, si			;points to pProcRaw(0)
        mov cx, dgroup
        mov es, cx
		jmp DoCallIsr		;isdn 79C30, all descisions are handled by
							;the user isr

IsdnCommon:
        MOV     CX, DGroup
        MOV     ES, CX
        ASSUME  ES:DGroup

        MOV     DI,SI               ; preserve SI (oCommLine)
                                    ; DI is opProcRaw(0)

CheckNext:
        MOV     DX,ES:[SI+oIoCtl]

; Here we have to read the Z16C30 chip to found out the right interrupt
; The Z16C30 chip will prioritize the interrupt sources as follow:
;  Highest: Rx Status, Rx Data, Tx Status, Tx Data, I/O Status and
;  Lowest:  Device Status.
        ADD     DX, DCCR
        IN      AL, DX

%if(%*Isdef(%ISDNTest)) then(
		MOV	bSaveDCCR, AL
)fi
	
        TEST    AL, 20h
        MOV     CX, 20h		   ; IPClear Used when we clear the IP bit later
        JNZ     SpRxISR        ; Rx Status IP
        TEST    AL, 10h
        MOV     CX, 10h		   ; IPClear
        JNZ     RxISR          ; Rx Data IP
        TEST    AL, 08h
        MOV     CX, 08h		   ; IPClear
        JNZ     ExtISR         ; Tx Status IP
        TEST    AL, 04h
        MOV     CX, 04h		   ; IPClear
        JNZ     TxISR          ; Tx Data IP
        TEST    AL, 02h
        MOV     CX, 02h		   ; IPClear
        JNZ     SpRxISR        ; I/O Status IP
        TEST    AL, 01h
        MOV     CX, 01h		   ; IPClear
        JNZ     ExtISR         ; Device Status IP

%if(%*Isdef(%ISDNTest)) then(
		INC	nTempNotValidISR
)fi
        JMP     NoValidInt

TxISR:
;This is the Tx data interrupt

%if(%*Isdef(%ISDNTest)) then(
		INC	nTempTxISR
)fi
        JMP     CallUserISR

ExtISR:
;This is the Tx status or device status interrupt

%if(%*Isdef(%ISDNTest)) then(
		INC	nTempExtISR
)fi
		ADD     DI, 4
        IN      AL, DX               ; Read in DCCR again
        TEST    AL, 04h
        JZ      CallUserISR          ; No Tx Data IP

%if(%*Isdef(%ISDNTest)) then(
		INC	nTempTxDataISR
)fi
        OR      CX, 04h
        JMP     CallUserISR

RxISR:
;This is the Rx Data interrupt

%if(%*Isdef(%ISDNTest)) then(
		INC	nTempRxISR
)fi
		ADD     DI, 8
        JMP     CallUserISR

SpRxISR:
; This is the I/O Status or Rx Status Interrupt

%if(%*Isdef(%ISDNTest)) then(
	INC	nTempSpRxISR
)fi
		ADD     DI, 12
        IN      AL, DX               ; Read in DCCR again
        TEST    AL, 10h
        JZ      CallUserISR          ; No Rx Data IP
%if(%*Isdef(%ISDNTest)) then(
		INC	nTempRxDataISR
)fi
        OR      CX, 10h		   ; IPClear

CallUserISR:
; Clear the IP bit in the Z16C30 chip
        MOV     DX, ES:[SI+oIoCtl]
        ADD     DX, DCCR
        MOV     AX, CX		   ; IPClear
        OR      AL, 40h         ;Reset both IUS and IP bits
        OUT     DX, AL
; Before calling the user ISR, make sure the user has set it up
        MOV     AX, WORD PTR ES:[DI]
        OR      AX, AX
        JNZ     DoCallIsr
        MOV     AX, WORD PTR ES:[DI+2]
        OR      AX, AX
        JNZ     DoCallIsr
        JMP     CheckNext             ; No user ISR to call, check next one
DoCallIsr:
; Load the user's DX.

        MOV     DX,ES:[SI+oIoCtl]
; for CTOSp, switch to user' ldt
		mov	 bx, word ptr ES:[SI+oLdtr]
		cmp		bx, maskRealMode
		je		DispatchRealCommIsrISDN

; load user LDT
		%LoadLdt(BX)

; Load the user's DS:BX
        LDS     BX,DWORD PTR ES:[SI+opDsBx]
; Call the appropriate raw ISR.
		PUSH	DI
		PUSH	SI
        CALL    DWORD PTR ES:[DI]   ; run Users ISR
		POP		SI
		POP		DI

		mov		cx, ds				; users ds, for Sig

 		jmp		short ISRDoneISDN

DispatchRealCommIsrISDN:

; Load the user's DS:BX
		MOV	 BX,WORD PTR ES:[SI+opDsBx]
		MOV	 CX,WORD PTR ES:[SI+opDsBx+2]
		MOV	 AX,WORD PTR ES:[SI+oUserNum] ; needed by v series only

; Call the appropriate raw ISR.
; Prior to call,
;	DX = i/o port
;	BX = user's BX
;	CX = user's DS
;	DI = opProc
;	ES = DGroup
;   AX = usernum (needed by vseries)
		PUSH	DI
		PUSH	SI
		CALL	CallRealCommIsr
		POP		SI
		POP		DI
; On return,
;	AX,BX,CX valid data (CX is really user's DS)
ISRDoneISDN:

        MOV     dx, DGroup           ; restore DGroup to ES
        MOV     ES, dx
		mov		ds, dx				;clobber user ds so we will not
									;fault on next interrupt
	
        OR      AX,AX               ; did user want to PSend?
        JZ      SendEoiISDN
		JMP		SigB1
; User's raw interrupt routine returned zero AX, so exit interrupt
;  without awakening any process.

NoValidInt:
; Send EOI to the interrupt controller(s).
		JMP SendEoiISDN
SigB1:
%if(%*Isdef(%ISDNTest)) then(
		INC	nTempB1Send
)fi
;*AA...*
%if(0) then (
	if rgCommline.PCType = CommISDNChD then
		GOTO ChDConvention;
	/* for ISDN channel-D the return convetion is different.
	   AX will contain the number of Send() to be done, the DS:BX will point to
	   an array of structures of type:
		CommWakeUp (nn) Structure(
									 Exch Word
									,pMsg Pointer
								 )
	*/
)fi
		assume  es: dgroup
		push cx
		mov cl, es:[si+oPCType]
		test cl, CommIsdnChD
		pop cx
		jz NotISDNChD
		jmp IsdnChD
NotISDNChD:
		PUSH 	ES
		PUSH	SI
		PUSH	AX
		PUSH	CX
		PUSH	BX
		MOV	 AX,DGroup
		MOV	 DS,AX
		ASSUME  DS:Dgroup
		CALL	KPSend
		POP		SI
		POP		ES
		jmp		SendEoiISDN
IsdnChD:
		push 	es
		push	si
NextMsg:
		push	ax				;the number of messages to be sent
		push	cx				;the users ds
		push	bx				;ds:[bx]->bx
		mov		es, cx 
		mov		si, bx
		push	es:[si]			;exchange
		push	es:[si+4]		;p.Sa msg
		push	es:[si+2]		;p.Ra msg
		call	KPSend
		pop		bx				;ds:[bx]->bx
		pop		cx				;the users ds
		pop		ax				;the number of messages to be sent
		dec		ax
		jz		AllMsgSent
		add		bx, 6			;point to the next element
		jmp		NextMsg
AllMsgSent:
		pop		si
		pop		es

; User's raw interrupt routine returned zero AX, so exit interrupt
;  without awakening any process.
SendEoiISDN:

; restore OS LDT 
		MOV  	BX, sgLdtOS
		%LoadLdt(BX)

		JMP		DoEoi
; No return from jump. Do EOI will return to kernel

%ENDPROC(RawCommNubIsdnB1)

; Comm Mediated Interrupt Handler
%PROCFAR(MedCommNub)
		ASSUME  ES:DGroup,DS:NOTHING

		%LOG('MN')
; Before we can legally do a MediateIntHandler call, we must pop off
;  the return address to the raw interrupt handler, which we won't be
;  returning to.
		ADD	 SP,8				; discard return address
		sldt	ax
		push	ax
		push	ds
		call	SetLdtrDs ; set ldt in tss so will not lose on task swith
		STI
		MOV	 AX, DGroup
		MOV	 ES, AX

; Reload the user's DS:BX, and DX.
		LDS	 BX,DWORD PTR ES:[SI+opDsBx]
		MOV	 DX,ES:[SI+oIoCtl]
		PUSH	SI
; Push argument to mediated comm interrupt routine:
;
; MedCommIsr: PROCEDURE (pDsBx) REENTRANT PUBLIC;
; DECLARE pDsBx POINTER;
;
		PUSH	DS
		PUSH	BX
		CALL	DWORD PTR ES:[DI+orgpProc2nd-orgpProcRaw]

MedCommNubReturn LABEL FAR
;
; "CommMediate", the "old" style mediated interrupt handler in
; CommInt.asm, also causes user's ISR to return here.
;
		POP		SI
		push	0
		push	DGroup
		call	SetLdtrDs	; rewrite TSS to get rid of LDT
assume DS:DGroup
		PUSH DS
		POP  ES
		JMP	 DoEoi
; No return from jump. Do EOI will return to kernel

%ENDPROC(MedCommNub)
; Raw interrupt routine for spurious interrupts.
; Used for not-in-use comm lines.
;
; Resets the comm line to prevent further spurious interrupts.
; Init code and the ResetCommLine request set the comm line's pProcRaw to
;  @SpuriousRawCommIsr and its pDsBx to the address of its rgCommLine entry.
;
; Also called by ResetCommPort.
;
; Depends on the rgCommLine entry having been set up already for this
;  channel.  This works because unlike the old SetCommIsr, InitCommLine
;  also initializes all the "unused" channels before enabling interrupts,
;  the first time it is called.
; 

%PROCFAR(SpuriousRawCommIsr)

		ASSUME  DS:DGroup

		%LOG('SP')
		MOV	 DX,[BX+oIoCtl]		  ; control port address via pDsBx
		%LOG(DX)

%if(0) then(
		if rgCommline.PCType = CommISDN then 
			GOTO ISDNType;
)fi
		MOV	CL, [BX+oPCType]
		test cl, CommISDN
		jz NotISDNType
		jmp ISDNType

NotISDNType:
		MOV	 AH,[BX+oChipType]
		CMP	 AH,b8274Type
		JA	 Not8274Type

; Reset the channel (half the 8274 chip).
		MOV	 AL,commRxInt
		%ZOUT   (DX,AL)
		MOV	 AL,commErrRes
		%ZOUT   (DX,AL)
		MOV	 AL,commResTxInt
		%ZOUT   (DX,AL)
		MOV	 AL,commResCh
		%ZOUT   (DX,AL)
		MOV	 CX, 10
SDelay:
		SHL	 AL, 8		 ;delay due to cache on 386i
		LOOP	SDelay

		MOV	 AL,commWr1
		%ZOUT   (DX,AL)
		MOV	 AL,comm1StatVect
		%ZOUT   (DX,AL)
		JMP	SpuriousDone
;JMR this should align the controler if an other register is selected.
Not8274Type:
		CMP	 AH,b8530Type
		JA	 Not8530Type

		%ZIN   (AL,DX)
		MOV	 AL,commWr9
		OUT	 DX,AL
		MOV	 AL,comm9ResCh
;*AA...*
%if(0) then (
		if rgCommline.PCType = CommEisa then /*on the sg4k/6k only Ch-A of the
			GOTO Spurious;					   8530 is used.
											 */
)fi
		MOV	CL, [BX+oPCType]
		ROL	CL, 1
		JC	isMpe				;on mpe only ch-a of this chip is used
;*...AA*
		MOV	 CX,[BX+oHandle]
		AND	 CL,1
		SHR	 AL,CL
isMpe:
		OR	 AL,comm9IntNV
;*AA...*
%if(0) then (
		if rgCommline.PCType = CommFep then  /*on the ServerComm we use the 
			GOTO SetSWIntAck;				   85C30, which is wee bit
											   different from the 8530./
											 */
)fi
		MOV	CL, [BX+oPCType]
		ROR	CL, 2				;CommFep = 02h
		JNC	SWIntAckIsSet		;on 8530 no need to set wr9-bit5
		or al, 20h
SWIntAckIsSet:
		OUT	 DX,AL
		JMP	SpuriousDone

Not8530Type:
		CMP	AH,b2681Type
		JA	Not2681Type
        MOV     DX,[BX+oCR]             ; get the command register address
        MOV     AL, ResetErrStatus
        OUT     DX,AL
        MOV     AL, ResetChannelBrkChgInt
        OUT     DX,AL
        MOV     AL, ResetTransmitter
        OUT     DX,AL
        MOV     AL, ResetReceiver
        OUT     DX,AL
        MOV     AL, RcvDisable
        OUT     DX,AL
        MOV     AL, TxDisable
        OUT     DX,AL

		MOV	DX,[BX+oIoVector]		; Write IMR
		MOV	AL,0					; All disabled
		%ZOUT	(DX,AL)
		JMP	SpuriousDone

Not2681Type:
		CMP	AH,b16551Type
		JA	Not16551Type
		MOV	DX,[BX+oExtStatReg]	;Clear modem status int
		IN	AL,DX
		MOV	DX,[BX+oLineStatReg]	;Clear Receiver line status int
		IN	AL,DX
		MOV	DX,[BX+oIoData]	;Clear Receiver int
		IN	AL,DX

		JMP	SpuriousDone

;ISDN
ISDNType:
	MOV	AX, [BX+oHandle]
	AND	AX, 0FFh
	CMP	AX, 0			;D channel, audio
	JE	ReadIsdnIR
	CMP	AX, 3			;D channel, data
	JE	ReadIsdnIR
	CMP	AX, 1			;B1 channel
	JE	ReadB1IR
	CMP	AX, 2			;B2 channel
	JNE	SpuriousDone
	JMP	ResetIP
ReadB1IR:
	OR	DX, 80h			;Base register address to B1 ch.
ResetIP:
	ADD	DX, DCCR
	MOV	AL, 7Fh			;Reset both IP and IUS
	OUT	DX, AL			;Low byte
	NOP
	NOP
	XOR	AL, AL
	INC	DX
	INC	DX
	OUT	DX, AL
	JMP	SpuriousDone

ReadIsdnIR:
	IN	AL, DX			;Clears the INT and IR
	JMP	SpuriousDone

Not16551Type:

SpuriousDone:
		XOR	 AX,AX				   ; do not instigate a PSend
		RET

%ENDPROC(SpuriousRawCommIsr)


%PROCFAR(DoEoiCommCnt)
DoEoi:
; Send EOI to the 8274-type serial controller.
; An interrupt task will fault if entered recursively, hence, explicitly
; disable interrupts prior to EOI.  The users raw handler may
; have enabled interrupts.
		MOV	 AH,ES:[SI+oChipType]
		CMP	 AH,b8530Type
		JA	  Try2681EoiType
		cli 
		MOV	 DX,ES:[SI+oIoIntRet]
		MOV	 AL,commReti
		%ZOUT   (DX,AL) 
		%LOG(DX)
;*AA*
%if(0) then (
		if rgCommline.PCType = CommEisa then
			GOTO CheckForNewInterrupt;
)fi
		MOV	CL, ES:[SI+oPCType]
		ROL	CL, 1
		JC CheckForNewInterrupt
		JMP	 DoneEoi
CheckForNewInterrupt:
		
		MOV		DX,ES:[SI+oIoIntRet]
		MOV		AL,CommRr3
		OUT		DX,AL
		JMP		$+2
		NOP
		IN		AL,DX
		TEST	AL,fcommIpBits
		JZ DoneEoi
		JMP InterruptPending

Try2681EoiType:
;2681 requires no EOI
;16450 and 16551 require no EOI

; Raw interrupt handlers may RET to get EOI done in ctosp.
DoneEoi:

; Re-enter interrupted process.
		STI
		RET
%ENDPROC(DoEoiCommCnt)

CommNub ENDS
CommAsm SEGMENT PUBLIC 'CODE'
		ASSUME  CS:CommAsm

; ResetCommPort is called only by InitCommLine itself, not by clients.
; Called during processing of the InitCommLine request,
;  to quiet the chip so the caller will have time to initialize it
;  properly after the response, before any interrupts can occur
; The rgCommLine entry must have been initialized first.
; It has the same effect as a spurious interrupt, i.e. it resets
;  the channel so subsequent interrupts will not occur.
;
; Interface:
;
; ResetCommPort: PROCEDURE (pCommLine) REENTRANT PUBLIC;
; DECLARE
;   pCommLine  POINTER  /* @rgCommLine(lineNo) */
;  ;
; END ResetCommPort;
;

ResetCommPort   PROC	FAR

		PUSH	BP
		MOV	 BP,SP

		PUSH	DS
		LDS	 BX,DWORD PTR [BP+6]

		PUSHF						   ; disable just in case
		CLI							 ;

		CALL	SpuriousRawCommIsr

		POPF							; restore interrupt flag

		POP	 DS

		POP	 BP
		RET

ResetCommPort   ENDP

CommAsm ENDS
		END

