;
;	CmCommon_all.asm		
;		This module contains system common subroutines
;		for use by an installed context manager.
;
; WARNING!
; The CtosP version of GetpStructure checks only that the structure is
; not swapped. If GetpStructure cases are added which return pointers to
; other hypersegs this test must be expanded.
;
;	Modification log:
;
;	-- CTOS II --
;	11/14/85 JM	folded in pKernelJumpTable (case 18) from 9.5,
;				folded in loadable request ptrs (case 19 - 24) from 9.6,
;				added pNLSTables (case 25),
;				moved pScreenStuff to case 26
;	12/05/85 JM	pretend usernum 1 is userNumPrimary, make a VP version for
;			    this case
;   3/14/86 DR extrn LockVideoForModify, etc.				
;	3/18/86 JA FetchLocalUsernum for SRP
;	3/21/86 MS add userCmSuspend for GetPStructure (code 27)
;	3/24/86 JA add cdt for GetPStructure (code 28); remove Quiet calls for Vp.
;   3/26/86 DR use ReadScat
;	3/29/86 JA obsolete userCmSuspend. cdt is 27.
;	4/07/86  MS add pContextState for GetPStructure (code 28)
;	5/28/86 JM GetpStructure for pNlsTable (case 25) returns ercNotImplemented
;				if the tables are not loaded
;   7/07/86 DR ctosp real mode support
;	9/23/86 JA psbEncryptionKey
;	9/24/86 JA pDiskStat, pStat for MassioPros_MF.
;	9/27/86 DR CTOS II 2.0 merge
;	10/22/86 by JA merge Hfs
;	10/29/86 by JA use WriteScat in SetpStructure.
;	11/11/86 by JA use ErcWriteScat in SetpStructure.
;	12/10/86 by DR NotifyRgVidMemLineUser
;	01/15/87 by DR user asib.sgUser rather than parDesc.saLowBound
;	 1/20/87 by JA ercPartitionNotPrimary if no U-segment.
;	 1/20/87 by JM real mode aliasing for imbedded pointer in rgpDebug
;	 2/11/87 by JA GetpScratch case 36
;	 3/9/87 by JA GetpStructure check Asib.bRealMode via FRealUser.
;	 3/18/87 by JM check u structure present in TestPartitionFlags.
;	 3/18/87 by FW SetpStructure to handle case 129 for CtNet.
;	 3/24/87 by MDE,JM Add case 37 (OEM Common Area) to GetpStructure
;	 4/1/87 by JM, return ercSwapped if u structure frozen.
;---2.1------------
;	 5/7/87 by JM, SetSwapDisable works for non context managed partitions.
;---2.2------------
;	 7/20/87 by JA, SetpStructure load ES, ASSUME so Ecb case works.
;---2.3------------
;	10/6/87 by JA, Asib,Arib now selector-based.
;	11/9/87 by JA, merge 9.9 -
;	06/10/85 JM: fix SetSwapDisable, add GetpIBusIDTable
;	10/29/85 GVW: GetPstruc's for loadable request tables
;	09/9/87 JM merge NLS stuff from VM.
;	10/29/87 JM merge NCR changes for encryption.
;	11/20/87 JM SetpStructure check userNum.
;	01/29/88 JA rgpDebugReal in ctosp only.
;	02/4/88 JA remove pRgLineMap.
;	02/15/88 JA use sc_
;	02/26/88 JA Fix GetpStructure Mp push/pop mismatch.
;	02/19/88 JM add Useg stuff
;	03/1/88 JA SetpStructure in Mp case.
;   03/14/88 PGJ add GetpVf
;   03/21/88 JA/RLM add GetpRgpRgRouting
;	03/21/88 JM case 39 - pVideoConfig
;	07/25/88 JM case 26 (pScreenStuff) works in MP.
;	08/26/88 JA pIntSwTbl erc7 in ctosp.
;   09/09/88 AT 10-bit userNums, remove FetchLocalUserNum, add FValidLocalUN.
;	09/09/88 JM use dgroup segment for static pointer initialization.
;	09/14/88 MTR ExUcbs out of Dgroup
;	10/14/88 JM in MP, userNum 1 means userNumPrimary.
;				AssignVidOwner is nop on Srp.
;	10/25/88 MTR [Un]LockInContext.
;	11/07/88 MTR purge pcbSuspend.
;	04/10/89 MTR Add pCphFilecache case to GetpStructure.
;	06/1/89 JA/RLM remove erc7 because it busts porgoVhb callers etc.
;	09/21/89 JA  erc7 rmos callers of GetprgprgRouting.
;	10/10/89 MTR purge rgPcb, nPcb
;	11/14/89 JM  use FadsTypesAsm.edf
;	02/22/90 JA Case 24 works if vfGetpRgPRgNetRouting.
;	03/12/90 DR  use SaFromSn in GetPRgPDebug so V86 RMOS will work
;	03/15/90 DR  vseries videoConfig.saCharMap is initially zero
;	03/26/90 JM  add GetpStructure case 42, pGInfoSeg.
;	03/28/90 JC  Added Bsac support
;	06/15/90 JM  getpstructure case 43, swapFileNameInfo.
;	07/05/90 JC	 Added Statistics support
;	08/15/90 JM  move declaration of ginfoseg to sysgen.
;	10/24/90 JMR add getp for sbUserName
;	01/02/91 JM  merge JC's support for GetpStructure case 30, pSpecialKeys.
;   01/23/91 DR  wRealVideoEar checks in GetPStructure (rgpvidMemLine)
;   03/12/91 JF  wRealVideoEar check removed -- video supported by
;				ShadowCharMap
;	05/03/91 KH  GetpStructure for 270 supports AltNlsStyle
;	09/13/91 KH  AssignKbd sends message to keyboard process to clean up 
;				 typeahead buffer before context is switched away. Fixes stuck 
;				 keys problems whether swapping occurs or not.
; 	10/07/91 JM  SetSwapDisable doesn't lock pages.
;	10/09/91 JM  LockInContext doesn't lock pages.
;	12/11/91 JM  ctosv SetSwapDisable, LockInContext call ISetPagingParameters
;	04/12/92 RA  GetpStructure used to gp fault for 400h.
;	07/08/92 JM  GetpStructure, case Useg, works for batch partitions.
;	11/16/92 JF  Make ContextState, ContextStatus, rgUserReadCount BASED
; 	04/02/93 JM	 AssignKbd: enforce our slot bits on userNumKbd.
;	05/20/93 JF  cUserNumCritical


%IF (not(%*Isdef(%CTOSp))) THEN (%Define(CTOSp)(0))FI
%IF (not(%*Isdef(%CTOSv))) THEN (%Define(CTOSv)(0))FI
%IF (not(%*Isdef(%Vp))) THEN (%Define(Vp)(0))FI
%IF (not(%*Isdef(%bsac))) THEN (%Define(bsac)(0))FI

%IF (%CTOSp) THEN (
	%SET(Statistics,0FFh)
)ELSE(
	%SET(Statistics,0)
)FI

%IF(%Mp)THEN(

;	ExUcb
oParDesc	EQU	0
cMassIoRq	EQU	2

;	Asib
%if(%ctosp)then(
$INCLUDE(:f1:fadsTypesAsm.edf)
)else(
saLowBound	EQU	4
)fi

bitNlsStyle			EQU 80h
;	ParDesc
fPartitionVacant	EQU	29
fPartitionLocked	EQU	30
fBatchPartition		EQU	33
fCCB				EQU	34

;	ParCnfgBlock
oExParDesc	EQU	0
oBcb		EQU	2
oTcb		EQU 4

;	ExParDesc
opRgbBufOut	EQU	172+0
opCharMap	EQU	172+49
opVcb		EQU	172+55
opRgpVid	EQU	172+63

;	Tcb (ASCB)
ofExecScreen	EQU	6
ofExecFont	EQU	24
opVLPB		EQU	2

;	ContextStatus
bitSwapped	EQU	01h
maskNotSwapped	EQU	0FEh

;	ContextState
bitClean	EQU	01h

;	GetpStructure
caseRgpDebug	EQU	11
casepVlpb equ 4
casepVcb  equ 2
caseRgpVidMemLine	EQU	7
caseRgpVidMemLineReal equ 32
casepParKbdInfo equ 45
ipParKbdInfo equ 8
srgpVidLine equ 38*4

;	Pcb
pcbSize		EQU	18
pcbUserNum	EQU	14
pcbPriority	EQU	3
pcbRespExch	EQU	12
pcbOExPcb	EQU	16
exPcbdeltaPrio	EQU	2

;	Vcb
rapMap		EQU	 4
sapMap		EQU	 6

;	Mask bit values for TestPartitionFlags
bitVacantTrue	EQU	20h
bitLockedTrue	EQU	10h
bitCCBFalse		EQU	0400h
bitBatchFalse	EQU	0800h

)ELSE(
opVLPB		EQU	2
caseRgpDebug	EQU	11
)FI

;	Ercs
ercOk					EQU	0
ercInconsistency		EQU	3
ercNotImplemented		EQU	7
ercBadPointer			EQU	11
ercServiceNotAvail		EQU	33

%if (%bsac) then (
ercAccessDenied			EQU 33
) fi

ercBadPartitionHandle	EQU	803
ercPartitionPrimary		EQU	814	;New May 83
ercPartitionLocked		EQU	806
ercPartitionVacant		EQU	805
ercPartitionNotPrimary	EQU	810	;New
ercPartitionNotLocked	EQU	807
ercPartitionNotVacant	EQU	800
ercPartitionSwapped		EQU	811	;New
ercRequestsOutstanding	EQU	813	;ercCantSwap
ercSetpStructureCbTooLargeForSb equ 14264 ; PMos compatability
ercBadSetpStructureFieldOffset equ 14262; PMos compatability
PUBLIC pNlsTables

EXTRN 		KSend:FAR
EXTRN		ErcWriteScat:FAR
%IF(%Vp)THEN(
EXTRN		ReadScat:FAR, sc_NotifyRgVidMemLineUser:FAR
) FI
%IF(%CTOSp)THEN(
EXTRN		QReadScat:FAR, SaFromSn:Far
extrn FRealUser:far
) FI

%if(%ctosv)then(
EXTRN		ILockUser:FAR
EXTRN		ISetPagingParameters:FAR
eventDisableSwap EQU 9
eventEnableSwap  EQU 10
)fi

%IF(%Mp)THEN(
EXTRN		FetchUserNum:FAR, Crash:FAR, RequestKWait:FAR, KRequestKWait:FAR
EXTRN		FValidLocalUN:FAR
; LockVideoForModify, UnlockVideoForModify, and GetPrgLineMap are
; system common subroutines that are part of the installable video system service.
EXTRN sc_LockVideoForModify:far
EXTRN sc_UnLockVideoForModify:far
%IF(%Vp OR %Mp)THEN(
EXTRN sc_GetpRgLineMap:far
EXTRN SwapInContext:far
)FI
)FI
EXTRN		cphFileCache:DWORD
;EXTRN		rgPrgrqExchg:DWORD
EXTRN		rgPrcLookup:DWORD
EXTRN		rgPrcLookupBase:DWORD
EXTRN		rgrcMax:WORD
EXTRN		rgPrgLocalServiceCode:DWORD
;EXTRN		rgPrgNetRouting:DWORD
EXTRN		rgPrgRouting:DWORD
EXTRN		sBufout:WORD
EXTRN		cUserNumCritical:WORD

;	OEMSeg is defined in Sysgen.mdf
;		A pointer to this segment (the 32 byte OEM space) is returned
;		by GetpStructure (case 37).
OEMSeg SEGMENT PUBLIC 'OEMSeg'
EXTRN rgbOemSeg:BYTE
%if (%Statistics) then (
PUBLIC prgpStatistics
EXTRN rgpStatistics:DWORD
)fi
OEMSeg ENDS

%IF (%ctosv) THEN (
; GInfoSeg is an OS/2 structure used by PM. The Timer process maintains it.
GInfoSeg SEGMENT PUBLIC 'OEMSeg'
GInfoSeg ENDS
)FI


%CmCommon	SEGMENT PUBLIC  'CODE'

%if (%bsac) then (
PUBLIC	ChangeTrustLevel, CheckTrustLevel
)fi

%IF(%Mp)THEN(
PUBLIC		AssignKbd, AssignVidOwner, SetSwapDisable, TestPartitionFlags
PUBLIC		GetpPartitionStructure
%if (%ctosp) then(
PUBLIC		LockInContext, UnLockInContext
)fi
%IF(NOT %Vp) THEN (
PUBLIC		QuietForSwap, QuietContext
)FI
)FI
PUBLIC		GetpStructure
PUBLIC		SetpStructure

DGroup		GROUP	Data

Data		SEGMENT PUBLIC 'DATA'

%IF(%Mp)THEN(
EXTRN		nUcb: WORD
EXTRN		nParDesc:WORD, pRgOExUcb:DWORD, UserNumKbd:WORD
EXTRN		wMySlotBits:WORD
EXTRN		serviceExchKbd:WORD, userNumSwap:WORD, rqReset:WORD
EXTRN		oPcbRun:WORD
EXTRN		orgUserReadCount:WORD
EXTRN		prgInfoIkey0:DWORD
EXTRN		prgInfoIkey1:DWORD
EXTRN		pParKbdProfiles:DWORD		
%IF(NOT %Vp)THEN(
;EXTRN		pRgLineMap:WORD
)FI
EXTRN		pRgSwappingRq:DWORD, nSwappingRq:BYTE
EXTRN		prgcRq:DWORD
EXTRN		pCdt:DWORD
%if(NOT %ctosp)then(
EXTRN		intSwtbl:word
)fi
)ELSE(
EXTRN		rgpVidMemLine:DWORD, CharacterMap:BYTE
)FI
EXTRN		GraphicsInfo:WORD, EventControlBlock:WORD, NGenPortsStructure:WORD
EXTRN		cpOsSubTable:WORD, UserNumVid:WORD, pIBusIDTable:DWORD
EXTRN		cwKernelJumpTable: WORD
EXTRN		pScreenMap:DWORD
EXTRN		EncryptionKey:BYTE
EXTRN		NetServerData: WORD
EXTRN		pDiskStat:DWORD
EXTRN		pStat:DWORD
EXTRN		vf:BYTE
%SET(fs, 0)
$INCLUDE(:f1:vfEqu.idf)
EXTRN		userNumPrimary:WORD
EXTRN		rgpDebug:DWORD
EXTRN		sbScratchVolumeSpec:BYTE
%if(%ctosp)then(
EXTRN		rgpDebugReal:DWORD
)fi
EXTRN		pSpecialKeys:DWord                   ; KBD Action List


%if(%ctosp)then(
extrn exchNetServer:word
extrn cbNodeName:byte
extrn nodeName:byte
public sgRealInterface, ipRealDispatcher
sgRealInterface dw 0
ipRealDispatcher dw 0
prgpDebugReal DD Dgroup:rgpDebugReal
EXTRN cUSeg: WORD
EXTRN swapFileNameInfo: BYTE
)fi
extrn rgsgAsib:word

%if (%bsac) then (
EXTRN fBsacResident:BYTE, UserNumACS:BYTE, RgTrustLevel:WORD
AcsCS dw 0
AcsIP dw 0
fFirstCallFromAcs db 1  ;reset to 0 after the first call from ACS
)fi

iTableFirst	EQU	caseRgpDebug

; videoConfig is a 32 byte structure defined by the video; the first word,
; saCharMapReal, is used to fixup rgpVidMemLine
PUBLIC videoConfig
%if(%ctosv)then(
videoConfig DW 0 ; let vam initialize it.
)else(
extrn wRealVideoEar: WORD
videoConfig DW 0F800h
)fi
	DB 7 DUP(0)
videoConfig_fDbgUseInstalledVideo DB 0ffh
	DW 11 DUP(0)



PUBLIC prgPrgNetRouting, vfGetpRgPRgNetRouting
prgPrgNetRouting DD ?	; Only defined if vfGetpRgPRgNetRouting.
vfGetpRgPRgNetRouting DB 0
	DB ?,?,?			; DWORD align next table

pTable label DWORD	;***	Table of pointers to return upon demand	***

prgpDebug			DD	Dgroup:rgpDebug
pGraphicsInfo		DD	Dgroup:GraphicsInfo
pECB				DD	Dgroup:EventControlBlock
pNGenPortsStructure	DD	Dgroup:NGenPortsStructure
pUserNum			DD	Dgroup:userNumVid
pOsSubTable			DD	Dgroup:cpOsSubTable
					DD	?
pKernelJumpTable    DD  Dgroup:cwKernelJumpTable	;18
 DD ?												;19
 DD Dgroup:rgPrcLookup								;20
 DD Dgroup:rgPrcLookupBase							;21
 DD Dgroup:rgRcMax									;22
 DD Dgroup:rgPrgLocalServiceCode					;23
 DD ?										;24
pNlsTables			DD 0					;25
pScreenStuff DD	Dgroup:pScreenMap			;26
 DD ?										;27
%IF(%Vp)THEN(
PUBLIC prgContextState		
prgContextState DD ?		;Initialized by KernalSetUp
) ELSE (
 DD ?										;28
)FI
 DD	Dgroup:EncryptionKey-1					;29
 DD ?										;30
 DD ?										;31
 DD ?										;32
 DD ?										;33
 DD ?										;34
 DD ?										;35
 DD ?										;36
 DD rgbOemSeg								;37
 DD Dgroup:vf								;38
 DD Dgroup:videoConfig						;39
 DD Dgroup:rgprgRouting						;40
 DD Dgroup:cphFileCache						;41
%IF (%ctosv) THEN (
PUBLIC pGInfoSeg
pGInfoSeg DW 0, GInfoSeg					;42
)ELSE(
 DD 0										;42
)FI
%IF (%ctosp) THEN (
 DD Dgroup:swapFileNameInfo					;43
)ELSE(
 DD 0										;43
)FI
 DD 0										;44 reserved for sbUserName
 DD ?										;45 use for pParKbdInfo
 DD 0										;46
 DD 0										;47
 DD 0										;48
 DD 0										;49
%IF (%Statistics) THEN (
 prgpStatistics DD rgpStatistics			;50
)FI
 DD Dgroup:cUserNumCritical					;51


;*************** RESERVE CASE 50 FOR UNISYS *************************

;		FALSE ercs
rgBitErc	DW	ercInconsistency, 0FF01h, 0FF02h, ercPartitionNotPrimary
			DW	0FF04h, ercPartitionNotLocked, ercPartitionNotVacant, 0,0
;		TRUE ercs
			DW	0FF01h, 0FF02h, ercPartitionPrimary, 0FF04h
			DW	ercPartitionLocked, ercPartitionVacant, 0,0

;Tables			ExParDesc, CharMap, Vcb, Ascb, Vlpb, Bcb, BufOut, rgpVidMemLine
;				pParKbdInfo
rgBitMask	DW	0, bitCCBFalse, bitCCBFalse, 0, 0, bitBatchFalse, bitCCBFalse
			DW	bitCCBFalse, bitCCBFalse
rgoTable	DB	oExParDesc,oExParDesc,oExParDesc, oTcb,oTcb, oBcb, oExParDesc
			DB	oExParDesc, oExParDesc
rgoPtr		DB	0, opCharMap, opVcb, 0, opVLPB, 0, oprgbBufOut
			DB	opRgpVid, oprgbBufOut

PUBLIC prgContextStatus
prgContextStatus DD ?		;Initialized by KernalSetUp
oUserNum	DW	?	; For use in AssignKbd/VidOwner.
psbScratchVolumeSpec DD Dgroup:sbScratchVolumeSpec

ASSUME	CS: %CmCommon
;		GetpStructure wCase jump table.
rgpProc		DW	OFFSET GetpPartitionStructureInternal ;0
			DW	OFFSET GetpPartitionStructureInternal ;1
			DW	OFFSET GetpPartitionStructureInternal	;2
			DW	OFFSET GetpPartitionStructureInternal	;3
			DW	OFFSET GetpPartitionStructureInternal	;4
			DW	OFFSET GetpPartitionStructureInternal	;5
			DW	OFFSET GetpPartitionStructureInternal	;6
			DW	OFFSET GetpPartitionStructureInternal	;7
			DW	OFFSET GetpRgLineMapInternal	;8
			DW	OFFSET GetpContextStatus	;9
			DW	OFFSET GetpRgUserReadCount	;10
%if(%ctosp)then(
			DW	OFFSET GetprgpDebug	;11
)else(
			DW	OFFSET GetpFromTable	;11 
)fi
			DW	OFFSET GetpFromTable	;12
			DW	OFFSET GetpFromTable	;13
			DW	OFFSET GetpFromTable	;14
			DW	OFFSET GetpFromTable	;15
			DW	OFFSET GetpFromTable	;16
			DW	OFFSET GetpIBusIDTable	;17
			DW	OFFSET GetpFromTable	;18 pKernelJumpTable
			DW  OFFSET GetpUnsupportedCase ;19 rgPrgrqExchg
			DW  OFFSET GetpFromTable 	;20 rgPrcLookup
			DW  OFFSET GetpFromTable 	;21 rgPrcLookupBase
			DW  OFFSET GetpFromTable 	;22 rgRcMax
			DW  OFFSET GetpFromTable 	;23 rgPrgLclSvcCode
			DW  OFFSET GetprgPrgNetRouting ;24 rgPrgNetRouting
%IF(%Vp) THEN (
			DW	OFFSET GetpNlsTables	;25 pNlsTables
			DW	OFFSET GetpFromTable	;26 pScreenStuff
			DW	OFFSET GetpCdt			;27 cdt
			DW	OFFSET GetpFromTable	;28 @contextState
) ELSE (
			DW	OFFSET GetpFromTable	;25 pNlsTables
			DW	OFFSET GetpFromTable	;26 pScreenStuff
			DW	OFFSET GetpCdt			;27 cdt
			DW	OFFSET GetpUnsupportedCase	;28 @contextState
)FI
			DW	OFFSET GetpFromTable	;29 psbEncryptionKey
			DW	OFFSET GetpSpecialKeys	; 30 Kbd Action List		BTOS
			DW	OFFSET GetpUnsupportedCase	; 31 Graphics control block	BTOS
			DW	OFFSET GetpPartitionStructureInternal	;32 pRgVidMemLineReal
%if(%ctosp)then(
			DW	OFFSET GetpUnsupportedCase	;33
)else(
			DW	OFFSET GetpIntSwtbl		;33
)fi
			DW	OFFSET GetpDiskStat		;34 pDiskStat block for MassioPros_MF
			DW	OFFSET GetpStat			;35 pStat block for MassioPros_MF
			DW	OFFSET GetpScratch		;36 sbScratchVolumeSpec for FS
			DW	OFFSET GetpFromTable	;37 pOEMSeg
			DW	OFFSET GetpFromTable	;38 pVf
			DW	OFFSET GetpFromTable	;39 pVideoConfig 
%if(%ctosp)then(
			DW	OFFSET GetprgprgRouting	;40 rgprgRouting
)else(
			DW	OFFSET GetpFromTable	;40 rgprgRouting
)fi
			DW	OFFSET GetpFromTable	;41 cphFileCache
%if(%ctosp)then(
			DW	OFFSET GetpFromTable	;42 GInfoSeg
			DW	OFFSET GetpFromTable	;43 swapFileNameInfo
)else(
			DW	OFFSET GetpUnsupportedCase	;42
			DW	OFFSET GetpUnsupportedCase	;43
)fi
			DW	OFFSET GetpFromTable	;44 sbUserName
			DW	OFFSET GetpPartitionStructureInternal	;45
			DW	OFFSET GetpUnsupportedCase	;46
			DW	OFFSET GetpUnsupportedCase	;47
			DW	OFFSET GetpUnsupportedCase	;48
			DW	OFFSET GetpUnsupportedCase	;49
%if(%Statistics)then(
			DW	OFFSET GetpFromTable		;50 prgpStatistics
)fi
			DW	OFFSET GetpFromTable	;51 cUserNumCritical

nSpecialCase	EQU	(OFFSET THIS WORD - OFFSET rgpProc)/2
oScatMin		EQU	nSpecialCase+80h

Data		ENDS


ASSUME	CS: %CmCommon, DS: Nothing, ES: Nothing

%if (%bsac) then (
;***
;	ChangeTrustLevel:PROCEDURE(userNum, TrustLevel) PUBLIC;
;***
ChangeTrustLevel PROC	FAR
argUserNum	EQU	8
argTrustLevel	EQU	6

	; OsSubEntry sets ES to address OS data segment
	mov		AX, DGroup
	mov		ES, AX
ASSUME	ES: DGroup, DS: Nothing

	push	BP
	mov		BP,SP
	cmp		ES:byte ptr UserNumACS,0
	je		ACSNotActive
	call		FetchUserNum
	cmp		AL,ES:byte ptr UserNumACS
	jne		InvalidUser

	mov		AX, [BP+2]
	mov		BX, [BP+4]
	cmp		ES:byte ptr fFirstCallFromAcs,0
	je		CheckCsIp
StoreCsIp:
	mov		ES:byte ptr fFirstCallFromAcs,0
	mov		ES:word ptr AcsCS, BX
	mov		ES:word ptr AcsIP, AX
	jmp		CsIpOk
CheckCsIp:
	cmp		ES:word ptr AcsCS, BX
	jne		InvalidUser
	cmp		ES:word ptr AcsIP, AX
	jne		InvalidUser
CsIpOk:
	mov		BX, [BP+argUserNum]
	cmp		BX, ES:word ptr nParDesc
	jae		BadUserNum
	shl		BX,1
	mov		AX, [BP+argTrustLevel]
	mov		ES:word ptr RgTrustLevel[BX],AX
	xor		AX,AX
	jmp		ThatsAll
ACSNotActive:
	mov		AX, 999
	jmp		ThatsAll
InvalidUser:
	mov		AX, 998
	jmp		ThatsAll
BadUserNum:
	mov		AX, ercBadPartitionHandle
ThatsAll:
	pop		BP
	RET		4

ChangeTrustLevel	ENDP

;***
;	CheckTrustLevel:PROCEDURE Erctype PUBLIC;
;
;	This procedure is called by the other system commons
;	Caller must put DGroup in ES
;	user number of the called program is passed in AX
;	ercOK or AccessDenied is returned in AX
;	WARNING : BX gets disturbed
;***
CheckTrustLevel PROC	FAR
	; caller must put DGroup in ES

	cmp		ES:byte ptr fBsacResident,0
	je		TrustedUser
	cmp		AL,ES:byte ptr UserNumACS
	jbe		TrustedUser
	mov		BX,AX
	shl		BX,1
	mov		AX,ES:word ptr RgTrustLevel[BX]
	or		AX,AX
	jnz		TrustedUser
UntrustedUser:
	mov		AX,ercAccessDenied
	jmp		ReturnBack
TrustedUser:
	xor		AX,AX
ReturnBack:
	RET
CheckTrustLevel		ENDP

)fi

%IF(%Mp)THEN(
;***
;	TestPartitionFlags:PROCEDURE(bIfTruebIfFalse, userNum) WORD;
;		User chooses flags to check by bit mask:
;			bIfTrue masks flags to check for TRUE
;			bIfFalse masks flags to check for FALSE
;			Both masks passed in 1 word, bIfTrue in low order byte.
;		Each bit represents a flag, mapping listed below.
;		Get index (8-1) of 1st bit matching condition, else 0.
;		Return ercs if defined, else 0FFXXh, XX=bit index 8-1.
;		Checks userNum ercBadPartitionHandle, partition ercPartitionSwapped.
;***
TestPartitionFlags	PROC FAR
argBitMasks	EQU	8
argUserNum	EQU	6
;	Caller must put DGroup in ES
ASSUME	ES: DGroup, DS: Nothing

	push	BP
	mov		BP, SP
	PUSH	DS
	mov		AX, DGroup
	mov		DS, AX
ASSUME	DS: DGroup

	MOV		BX, [BP+argUserNum]
	CMP		BX, 1					;people who use userNum 1 are really
	JNE		NotUserNumPrimary		;primary userNums.
	MOV		BX, userNumPrimary
	MOV		[BP+argUserNum], BX

NotUserNumPrimary:
	push	[BP+argUserNum]
	call	FValidLocalUN
    OR      AL, AL
    JNZ     Valid
    JMP     BadPartitionHandle  ; Exit early: structures don't exist.
Valid:
    MOV     BX, [BP+argUserNum]
    AND     BX, 03FFH
    MOV     [BP+argUserNum], BX

	SHL		BX, 1				; word index
	MOV		DI, BX
	PUSH	ES
	LES		BX, DWORD PTR pRgOExUcb
	MOV		BX, ES:[BX][DI]
	CMP		WORD PTR ES:[BX+cMassIoRq], 0FFFFh
	JNE		M09a
	POP		ES
	JMP		BadPartitionHandle
M09a:

;	Go through partition structures, collect flags in AL as bits.
;
	xor		AX,AX		; Clear bit pattern
	mov		CX,AX		; CX=0, used for CMP to set carry

	mov		BX, ES: [BX+oParDesc]	; BX=ExUcb.oParDesc
	pop		ES
	cmp		CL, DS: [BX+fPartitionVacant]	; IF ParDesc.fPartitionVacant
	rcl		AL, 1							; Store condition (carry) in AL
	cmp		CL, DS: [BX+fPartitionLocked]	; IF ParDesc.fPartitionLocked
	rcl		AL, 1							; Store condition (carry) in AL
	cmp		CL, DS: [BX+fBatchPartition]	; IF ParDesc.fBatchPartition
	rcl		AL, 1							; Store condition (carry) in AL
	cmp		CL, DS: [BX+fCCB]				; IF ParDesc.fCCB
	rcl		AL, 1							; Store condition (carry) in AL
%if(%ctosp)then(
	mov		bx, word ptr [BP+argUserNum]
	shl		bx, 1		; index sgAsib table
	mov		ds, rgsgAsib[bx]
ASSUME	DS: Nothing
	test	word ptr ds:[oAsibFlags], bitFreeze		
	jnz		PartitionSwapped	; in termination, u frozen

	mov		bx, ds:[oAsibSgUser]
)else(
	mov		BX, DS: [BX+saLowBound]	; BX=ParDesc.saLowBound
)fi
	or		bx, bx
	jz		PartitionNotPrimary

%if(%ctosp)then(
	push	es
	mov		dx, 8
	mov		es, dx
	mov		dl, es: [bx+5]	;access byte of desc for sgUser
	pop		es
	test	dl, 80h			;present bit
	jz		PartitionSwapped
)fi

	mov		DS, BX
ASSUME	DS: Nothing

;	We're in the partition now.
	mov		BX, DS: WORD PTR oTcb	; BX=ParCnfgBlock.oTcb (ASCB)
	cmp		CL, DS: [BX+ofExecScreen] ; IF ASCB.fExecScreen
	rcl		AL, 1				; Store condition (carry) in AL
	cmp		CL, DS: [BX+ofExecFont] ; IF ASCB.fExecFont
	rcl		AL, 1				; Store condition (carry) in AL

;	AL is 8 collected flag bits(8-1):
;		0,0, ParDesc.fPartitionVacant, ParDesc.fPartitionLocked,
;		ParDesc.fBatchPartition, ParDesc.fCCB, ASCB.fExecScreen,
;		ASCB.fExecFont

	mov		DI, 16		; Return TRUE ercs (i=1 to 8)
	mov		BX, [BP+argBitMasks]
	test	AL, BL		; BL=bit mask, return if AL bit TRUE
	JNZ		Ret1stBit

	xor		DI, DI		; Return FALSE ercs
	not		AL
	mov		BL, BH		; BL=bit mask, return if AL bit FALSE
	and		AL, BL
	jnz		Ret1stBit
;	return AX=iercOK=0

RetAXDS:
	POP		DS
ASSUME	ES: DGroup, DS: Nothing
	POP		BP
	RET		4

BadPartitionHandle:
	mov		AX, ercBadPartitionHandle
	jmp		SHORT RetAXDS

PartitionSwapped:
	mov		AX, ercPartitionSwapped
	jmp		SHORT RetAXDS

PartitionNotPrimary:
	mov		AX, ercPartitionNotPrimary
	jmp		SHORT RetAXDS

Ret1stBit:
	and		BL, AL		; BL=bits causing erc
	mov		CX, 8
@1:	ROL		BL, 1		; Test carry
	JB		RetCXDX		; Jump carry=1
	loop	@1
				;ercInconsistency, CX=0
RetCXDX:
	mov		BX, CX
	shl		BX, 1
	mov		AX, rgBitErc[BX][DI]
	jmp		SHORT RetAXDS

TestPartitionFlags	ENDP

;***
;	AssignKbd:PROCEDURE(userNum) PUBLIC;
;***
AssignKbd	PROC	FAR
argUserNum	EQU	6
	mov		AX, DGroup
	mov		ES, AX
ASSUME	ES: DGroup, DS: Nothing

	mov		oUserNum, OFFSET DGroup:UserNumKbd
AssignUser:
	push	BP
	mov		BP, SP

	mov		AX, bitCCBFalse
	push	AX
	push	[BP+argUserNum]		; AX=TestPartitionFlags(wMask, userNum);
	call	TestPartitionFlags	; erc if NOT fCCB
	or		AX, AX
	jnz		RetAX

	mov		BX, [BP+argUserNum]
	cmp		oUserNum, OFFSET DGroup:UserNumKbd
	jne		ChkUserNum	;if =, AsignKbd
	PUSH	ES
	PUSH	BX
	mov		AX, DGROUP:serviceExchKbd ;tell kbdpros about change
	PUSH	AX
	PUSH	1	;fake SA
	PUSH	BX	;fake RA
	CALL 	KSend	
	XOR		AX,AX
	POP		BX
	POP		ES
ChkUserNum:

	cmp		BX, 1
	jne		SetUserNum
	mov		BX, UserNumPrimary

SetUserNum:

%if (%bsac) then (
	mov		CX,BX
	call	FetchUserNum
	call	CheckTrustLevel
	or		AX,AX
	jnz		RetAx
	xor		AX,AX
	mov		BX,CX
)fi

	mov		SI, WORD PTR oUserNum
; enforce our slot bits on userNumKbd
	and		bx, 3ffh
	or		bx, wMySlotBits
	mov		ES: [SI], BX

RetAX:
	pop		BP
	RET		2

AssignKbd	ENDP


;***
;	AssignVidOwner:PROCEDURE(userNum) PUBLIC;
;***
AssignVidOwner	PROC	FAR
argUserNum	EQU	6
	mov		AX, DGroup
	mov		ES, AX
ASSUME	ES: DGroup, DS: Nothing
; don't set userNumVid on SRP - video does hardware stuff when 
; userNum=userNumVid.
	test	vf_fMf, 1
	jz		NotSrp
	xor     ax, ax
	ret		2 

NotSrp:
	mov		oUserNum, OFFSET DGroup:UserNumVid
	jmp		SHORT AssignUser

AssignVidOwner	ENDP


;***
;	SetSwapDisable:PROCEDURE(fNoSwap) PUBLIC;
;***
SetSwapDisable	PROC	FAR
argfNoSwap	EQU	6

	mov		AX, DGroup
	mov		ES, AX
ASSUME	ES: DGroup, DS: Nothing

	push	BP
	mov		BP, SP

; SetSwapDisable must work for non CCB users
;	mov		AX, bitCCBFalse
;	push	AX
;	call	FetchUserNum
;	push	AX
;	call	TestPartitionFlags ; erc if NOT fCCB
;	or		AX, AX
;	jnz		RetAX

; ContextStatus(userNum).bDontSwap bit 0 = fNoSwap
	call	FetchUserNum
	mov  	dx, ax			; save whole userNum
    AND     AX, 03FFH
	mov		BX, AX			; BX=userNum
	LES		DI,prgContextStatus
ASSUME	ES: Nothing, DS: Nothing
	mov		CL, ES:[DI][BX]
	rcr		CL, 1
	rcr		CL, 1			; Lose .bDontSwap bit 1.

	xor		AX, AX
; Compare zero to fNoSwap, set carry if fNoSwap>0.
	cmp		AL, [BP+argfNoSwap]	; Carry = 1 if flag <> 0
	rcl		CL, 1			; 2nd bit CL = fNoSwap.
	rcl		CL, 1
	mov		ES:[DI][BX], CL	;Update ContextStatus
%if (%ctosv) then (	
	push 	dx	; userNum
	push    word ptr [bp+argfNoSwap]
	call    SetSwapDisablePs
)fi
	jmp		RetAX

SetSwapDisable	ENDP


%if (%ctosv) then (
;	SetSwapDisablePs: PROCEDURE (userNum, fDisable) ercType REENTRANT
;		sets/resets 'remain active' state in PS. when set, PS ensures that
;		the user always has at least RMin frames (users are suspended when
;		they fall below RMin).
SetSwapDisablePS PROC NEAR
	PUSH BP
	MOV  BP, SP

; ISetPagingParameters requires OS DS
	PUSH DS
	MOV  AX, DGroup
	MOV  DS, AX

	PUSH WORD PTR [BP+6]	; userNum
	MOV  AX, eventDisableSwap
	TEST WORD PTR [BP+4],1	; fDisable
	JNE	 CallPs
	MOV  AX, eventEnableSwap
CallPs:
	PUSH AX
	PUSH 0
	PUSH 0
	PUSH 0
	CALL ISetPagingParameters
	XOR  AX, AX ; don't return errors - not p-series compatible.

	POP  DS
	POP  BP
 	RET  4
SetSwapDisablePS ENDP
)fi

%if (%ctosp) then(
;***
;	LockInContext:PROCEDURE(userNum) ercType PUBLIC;
;***
LockInContext	PROC	FAR
argUserNum	EQU	6

ASSUME	DS: Nothing
	push	BP
	mov		BP, SP
	mov		AX, DGroup
	mov		ES, AX
ASSUME	ES: DGroup

	mov		DI,	[BP+argUserNum]
	pushf
	cli										;DISABLE

	call	ValidateLUN
	or		AX, AX							;erc
	jnz		licExit
	
%if (%ctosv) then (
; user may not become inactive
	popf
	push	word ptr [BP+argUserNum]
	push	1
	call	SetSwapDisablePS
	jmp		licRet

)else(

	mov		[BP+argUserNum], DI
	mov		BX, oPcbRun
	mov		BX, ES:[BX+pcbUserNum]
	and		BX, 3FFh
	cmp		BX, DI
	jne		licNotMe
	or		AL, 1							;AL=fLockingSelf
licNotMe:
	shl		DI, 1
	mov		BX, rgSgAsib [DI]
	mov		ES, BX
ASSUME	ES: Nothing
	mov		BL, ES:[oAsibCSwapLock]
	cmp		BL, 0FFh
	je		licExitOk						;Overflow: user locked until gone
	or		AL, BL
	jz		licSwapInAndLock

;locking self or counter<>0 -> context resident: just bump counter
	inc		byte ptr ES:[oAsibCSwapLock]
	jmp		licExitOk	

licSwapInAndLock:
;not locking self and user currently not locked: request lock
	popf									;ENABLE
	mov		AX, DGroup
	mov		ES, AX
ASSUME	ES: DGroup
	mov		BX, oPcbRun

;build rq on stack
	push	[BP+argUserNum]					;fhUserNum
	push	1010h							;lrcSwapInContextAndLock
	push	0								;ercRet
	push	ES:[BX+pcbRespExch]				;respExch
	push	0								;userNum--Request will set it right
	push	0								;nRespPbCb nReqPbCb
	push	2								;rtCode sCtlInfo

	push	SS
	lea		AX, [BP-14]
	push	AX
	call	KRequestKWait

ASSUME	ES: Nothing
	mov		AX, [BP-6]						;AX=rq.ercRet
	add		SP, 14							;discard rq
	jmp		licRet
	
licExitOk:
	xor		AX, AX
)fi
licExit:
	popf									;ENABLE
licRet:
	pop		BP
	ret		2
LockInContext	ENDP


;***
;	UnLockInContext:PROCEDURE(userNum) ercType PUBLIC;
;***
UnLockInContext	PROC	FAR
argUserNum	EQU	6

ASSUME	DS: Nothing
	push	BP
	mov		BP, SP
	mov		AX, DGroup
	mov		ES, AX
ASSUME	ES: DGroup

	mov		DI,	[BP+argUserNum]
	pushf
	cli										;DISABLE

	call	ValidateLUN
	or		AX, AX							;erc
	jnz		ulicExit

%if (%ctosv) then (
	popf
	push	word ptr [BP+argUserNum]
	push	0	
	call	SetSwapDisablePS
	jmp		ulicRet

)else(

	shl		DI, 1
	mov		BX, rgSgAsib [DI]
	mov		ES, BX
ASSUME	ES: Nothing
	mov		BL, ES:[oAsibCSwapLock]
	or		BL, BL
	jnz		ulicLocked
	mov		AX, ercPartitionNotLocked
	jmp		ulicExit

ulicLocked:
	cmp		BL, 0FFh
	je		ulicExitOk						;LockInContext overflowed: DNFU
	dec		byte ptr ES:[oAsibCSwapLock]
	
ulicExitOk:
	xor		AX, AX
)fi
ulicExit:
	popf									;ENABLE
ulicRet:
	pop		BP
	ret		2
UnLockInContext	ENDP


ValidateLUN		PROC	NEAR
;
;On entry, DI=userNum (0->pcbRun.pcbUserNum, 1->userNumprimary)
;Return AX=erc (badPartitionHandle, partitionVacant) 
;			N.B. partitionSwapped is OK
;		DI=xlated userNum
;			N.B. 0 not returned (badPartitionHandle)
; BX hosed
; ES <- DGroup
;
ASSUME	ES: DGroup
ASSUME	DS:	Nothing
	push	DI								;parm
	call	FValidLocalUN					;side effect: ES=DGroup
	or		AX, AX
	jz		vlunBadUN

	cmp		DI, 1
	ja		vlunGotUN
	jb		vlunMe
	mov		DI, userNumPrimary
	jmp		vlunGotUN

vlunMe:
	mov		DI, oPcbRun
	mov		DI, ES:[DI+pcbUserNum]

vlunGotUN:
	and		DI, 3FFh
	jz		vlunBadUn						;userNum=0
	shl		DI, 1
	push	ES
	les		BX, DWORD PTR pRgOExUcb
	mov		BX, ES:[BX][DI]					;ES:BX=pExUcb
	cmp		word ptr ES:[BX+cMassIoRq], 0FFFFh
	je		vlunUnAllocated
	mov		BX, ES:[BX+oParDesc]
	pop		ES								;ES:BX=pParDesc
	cmp		byte ptr ES:[BX+fPartitionVacant], 0
	jne		vlunVacant
	
	shr		DI, 1							;xlated userNum
	xor		AX, AX							;ercOK
	ret

vlunVacant:
	mov		AX, ercPartitionVacant
	ret
vlunUnAllocated:
	pop		ES
vlunBadUN:
	mov		AX, ercBadPartitionHandle
	ret
ValidateLUN	ENDP
)fi %'end ctosp

)FI	%'End MP only

;***
;	SetpStructure:
;		procedure(wCase, userNum, oField, pb, cb) : ErcType
;
SetpStructure proc far
argwCase 		equ word ptr [bp+16]
argwUserNum 	equ word ptr [bp+14]
argoField		equ word ptr [bp+12]
argPb			equ dword ptr [bp+8]
argRa			equ word ptr [bp+8]
argSa			equ word ptr [bp+10]
argCb			equ word ptr [bp+6]

lCaseEcb  equ 13
lCaseAscb equ 3
lCaseParDesc equ 32
lCaseNetData equ 129
oPbMsgRet equ 10
oSbPartitionName equ 16

	mov		AX, DGroup
	mov		ES, AX
ASSUME	ES: DGroup, DS: Nothing

	push		bp
	mov		bp, sp
    PUSH    argwUserNum
    CALL    FValidLocalUN
    OR      AL, AL
	JNZ		SPSUserNumOk
	mov		ax, ercBadPartitionHandle
	jmp 	ExitSetP
SPSUserNumOk:	

%if (%bsac) then (
	cmp		AL,1
	jbe		GoAheadSetP
	mov		BX,AX
	PUSH    BX					; Save it for later
	call	FetchUserNum
	POP     BX					; Restore it now
	cmp		AX,BX
	je		GoAheadSetP
	call	CheckTrustLevel
	or		AX,AX
	jnz		ExitSetP
GoAheadSetP:
) fi

	mov		ax, argwCase
%if(%ctosp)then(
	cmp		ax, lCaseEcb
	je		SetEcb
	cmp		ax, lCaseNetData
	je		SetNetData
	cmp		ax, lCaseParDesc
	jne     SetPChkAscb
	jmp     SetParDesc
SetPChkAscb:
	cmp		ax, lCaseAscb
	jne     SetPChkScat
	jmp		SetAscb

SetPChkScat:
)fi

	cmp		ax, oScatMin
	jb		SetPNotImplemented
	test	ax, 3
	jnz		SetpBadPtr

	push	ax
	push	argSa
	push	argRa
	call	ErcWriteScat
;	jmp		ExitSetP		ignore ercBadPointer if RMOS scat can't be set.

ExitSetPErcOk:
	xor		ax, ax
ExitSetP:
	pop		bp
	ret		12

SetPNotImplemented:
	mov		ax, ercNotImplemented
	jmp		short ExitSetP

SetpBadPtr:
	mov		AX, ercBadPointer
	jmp		short ExitSetP

%if(%ctosp)then(
SetNetData:
	mov		cx, argcb
	jcxz		ExitSetPErcOk
	mov		ax, DGroup
	mov		es, ax
ASSUME ES:DGroup
	mov		ax, argoField
	mov		bx, offset DGroup:exchNetServer
	mov		di, bx
	cmp		ax, bx
	je		SetNetDataServerExch

	mov		bx, offset DGroup:cbNodeName
	cmp		ax, bx
	je		SetNetName0
	mov		ax, ercBadSetpStructureFieldOffset
	jmp		ExitSetP
SetNetName0:
	cmp		cx, 12
	jle		SetNetName1
	mov		ax, ercSetpStructureCbTooLargeForSb
	jmp		ExitSetP
SetNetName1:
	mov     cbNodeName, cl
	mov		di, offset DGroup:NodeName
SetNetDataServerExch:
	push		ds
	lds		si, argPb
ASSUME DS:Nothing
	cld
	repnz		movsb
	pop		ds
ASSUME DS:Nothing
	jmp		ExitSetPErcOK

SetEcb:
	mov		cx, argcb
	jcxz		ExitSetPErcOk
	les		di, pEcb
	push	ds
	lds		si, argPb
ASSUME ES:DGroup, DS:Nothing
	add		di, argoField
	cld
	repnz	movsb
	pop		ds
ASSUME DS:Nothing
	jmp		ExitSetPErcOk

SetAscb:
	mov		ax, argoField
	cmp		ax, oPbMsgRet
	je		SetAscb0
	jmp		SetPNotImplemented

SetAscb0:
; setting pb/cbMsgRet
	sub		sp, 4
	mov		di, sp

	push		argwCase
	push		argwUserNum
	push		ss
	push		di
	call		far ptr GetPStructure
	pop		di
	add		di, argoField
	pop		es
ASSUME ES:Nothing
	or		ax, ax
	jz		SetAscb1
	jmp		ExitSetP
SetAscb1:
	mov		ax, [argRa]
	stosw
	mov		ax, [argSa]
	stosw
	mov		ax, argCb
	stosw
	jmp		ExitSetPErcOk

SetParDesc:
	cmp		argoField, oSbPartitionName
	je		SetParDesc0
	jmp		SetPNotImplemented
SetParDesc0:
	mov		bx, argwUserNum
	or		bx, bx
	jnz		FetchPParDesc
	call		FetchUserNum
	mov		bx, ax
FetchPParDesc:
    AND     BX, 03FFH
	mov		ax, DGroup
	mov		es, ax
ASSUME ES:DGroup
	shl		bx, 1
	mov		DI, BX
	push	ES
	les		BX, DWORD PTR pRgOExUcb
ASSUME	ES:Nothing
	mov		BX, ES: [BX][DI]		; BX=oExUcb
	mov		DI, ES: [BX+oParDesc]	; DI=ExUcb.oParDesc
	pop		ES
ASSUME	ES:DGroup
	add		di, oSbPartitionName
	mov		ax, argCb
	mov		cx, ax
	stosb
	push		ds
	lds		si, argPb
ASSUME DS:Nothing
	cld
	repnz		movsb
	pop		ds
ASSUME DS:Nothing
	jmp		ExitSetPErcOk	

)fi

SetpStructure endp


;***
;	GetpStructure:PROCEDURE(wCase, userNum, ppRet) PUBLIC ErcType;
;***
GetpStructure	PROC	FAR
argpPRet	EQU	6
argUserNum	EQU	10
argCase		EQU	12
csRet   equ 4

	mov		AX, DGroup
	mov		ES, AX
ASSUME	ES: DGroup, DS: Nothing

	push	BP
	mov		BP, SP
	
%if (%bsac) then (
	mov		BX,[BP+argUserNum]
	cmp		BL,1
	jbe		GoAheadGetP
	cmp		BX,ES:nUcb
	jl		LocalUser
	Mov		AX,ercBadPartitionHandle
	Jmp		RetAx8
LocalUser:
	call	FetchUserNum
	cmp		AX,BX
	je		GoAheadGetP
	call	CheckTrustLevel
	or		AX,AX
	jnz		RetAx8
GoAheadGetP:
)fi
	
	mov		BX, [BP+argCase]
%IF(%ctosp) THEN (
	mov		AX, cUSeg
	not		AX	;cases 0FFFFh...(0FFFFh-cUseg) are dynamic Useg case's
	cmp     BX, AX
	jbe		CheckScat
	jmp		GetpUSegInternal
CheckScat:
)FI
	cmp		BX, oScatMin
	jb		SpecialCase

	test		BX, 3
	jnz		NotpScat

	cmp		bx, 400h	
;	ja		NotpScat
	jae		NotpScat

	cmp		bx, 270h
	jne		NotNls
%if(%ctosp)then(
	LES		BX, DWORD PTR pParKbdProfiles ;is there a table of profiles?
	MOV		DI,ES
	OR		DI,BX
	je		NotAltNls   ;no
	PUSH	BX
	PUSH	ES
	mov		AX,[BP+argUserNum]
	OR 		AX,AX
	jne		GetKbdProfile
	call	FetchUserNum
	AND     AX, 03FFH
GetKbdProfile:
	POP		ES
	POP		BX	
	mov		DI, AX
	shl		DI, 1

ASSUME	ES:Nothing
	MOV		AX, ES:[BX][DI]  ;partition kbd profile
	OR		AX,AX            ;is there a non-zero entry here?
	JNE		AltNls
)fi
NotAltNls:
	mov		AX, DGroup
	mov		ES, AX
ASSUME	ES: DGroup
	LES		AX,DWORD PTR prgInfoIkey0
ASSUME	ES:Nothing
	MOV		DX,ES
	MOV		DI,ES
	OR		DI,AX
	JNZ		CheckqDXAX
NotNls:
	mov		BX, DGroup
	mov		ES, BX
ASSUME	ES: DGroup
	mov		BX, [BP+argCase]
;	 Segment 0, Offset wCase is System Common Table ptr.
%if(%ctosp)then(
	mov		ax, [bp+csRet]
	xor		dx, dx
	cmp		ax, sgRealInterface
	jne		CallQReadScat
	dec		dx
CallQReadScat:
	push		bx
	push		dx
	call		QReadScat
)else(
	%if(%vp)then(	
	push		bx
	call		ReadScat
	)else(
	xor		AX, AX
	mov		ES, AX
ASSUME	ES: Nothing
	les		bx, DWORD PTR ES: [BX]
	)fi
	mov		DX, ES
	mov		AX, BX
)fi
	jmp		short RetqDXAX

ASSUME	ES: DGroup, DS: Nothing
SpecialCase:
	cmp		BX, nSpecialCase
	jae		BadSpecialCase

	SHL		BX, 1
	jmp		WORD PTR rgpProc[BX]

NotpScat:
	mov		AX, ercBadPointer
	jmp		SHORT RetAX8

BadSpecialCase:
	mov		AX, ercNotImplemented
	jmp		SHORT RetAX8

RetqDXAX:
	les		SI, DWORD PTR [BP+argpPRet]
ASSUME	ES: Nothing
	mov		ES: [SI], AX
	mov		ES: [SI+2], DX
RetAX8Ok:
	xor		AX, AX
RetAX8:
	pop		BP
	ret		8

%if(%ctosp)then(
AltNls:
	TEST	AX,bitNlsStyle
	JZ		NotAltNls
	mov		AX, DGroup
	mov		ES, AX
ASSUME	ES: DGroup
	LES		AX,DWORD PTR prgInfoIkey1
ASSUME	ES:Nothing
	MOV		DX,ES
	MOV		DI,ES
	OR		DI,AX
	JE		NotAltNls
CheckqDXAX:
; DX is a selector - check if it should be an sa
	mov		cx, DGroup
	mov		es, cx
assume es:dGroup
	mov		bx, [bp+csRet]
	cmp		bx, sgRealInterface
assume es:nothing
	jne		retqDXAX
	push		ax ; save the ra
	push		ax ; storage for saRet
	mov		si, sp

	push		dx ; erc = SaFromSn(sn, userNum, pSaRet)
	push		[bp+argUserNum]
	push		ss
	push		si
	call		SaFromSn
; check erc
	or		ax, ax
	jz		SaOk
; error return
	pop		dx
	pop		dx
	jmp		short	 RetAX8
SaOk:
	pop		dx ; saRet
	pop		ax ; ra
	jmp		short RetqDXAX
)fi

GetpStructure	ENDP


%if(%ctosp)then(
;***
;	GetprgpDebug:PROCEDURE(wCase, userNum, pprgpDebugRet);
;***
GetprgpDebug	PROC	NEAR

	; GetpStructure sets ES to address OS data segment
ASSUME	ES: DGroup, DS: Nothing

	mov		ax, [bp+csRet]
	cmp		ax, sgRealInterface
	jne		GetpFromTable

; rgpDebug is an array of pointers through which the debugger nub 
; and the non resident part of debugger communicate. Only one pointer
; in the array is meaningful to anyone else: rgpDebug(5) is prgBkpt,
; a pointer to the breakpoint table which is used by the code segment
; swapper of Ctos.lib. Debugger exports rgpDebug and rgpDebugReal. 
; rgpDebugReal is initialized to zeros. First time through here fix up
; rgpDebugReal(5) to alias rgpDebug(5).

saDbgBkptReal equ word ptr rgpDebugReal+22
raDbgBkptReal equ word ptr rgpDebugReal+20
saDbgBkpt equ word ptr rgpDebug+22
raDbgBkpt equ word ptr rgpDebug+20

; For SnFromSa to work, SS must equal DS, hence, we use ES for DGroup

	push	bp
	mov		bp, sp
	push	ax  ; local storage for SaFromSn

	cmp 	saDbgBkptReal, 0	
	jne 	short GetprgpDebugRet

	push	es ; save DGroup - SaFromSn will clobber it
	push 	saDbgBkpt		
	push	0	;userNum
	push	ss
	lea		ax, [bp-2]
	push	ax
	call	SaFromSn ;(snDbgBkpt, 0, @sa)
	pop		es

; pla is in first megabyte (saDbgBkpt is OS data segment)
	mov		ax, word ptr [bp-2]
	mov		saDbgBkptReal, ax
	mov		ax, raDbgBkpt
	mov		raDbgBkptReal, ax
	
GetprgpDebugRet:
	push	es ; save DGroup - SaFromSn will clobber it
	push	word ptr prgpDebugReal+2
	push 	0
	push	ss
	lea		ax, [bp-2]
	push	ax
	call	SaFromSn
	pop		es
	mov		dx, word ptr [bp-2]
	mov		ax, word ptr prgpDebugReal

	mov		sp, bp
	pop		bp
	jmp		RetqDXAX

GetprgpDebug	ENDP


;***
;	GetprgprgRouting:PROCEDURE(wCase, userNum, pprgprgRouting);
;***
GetprgprgRouting	PROC	NEAR

	; GetpStructure sets ES to address OS data segment
ASSUME	ES: DGroup, DS: Nothing

	mov		ax, [bp+csRet]
	cmp		ax, sgRealInterface
	jne		GetpFromTable
	jmp		BadSpecialCase

GetprgprgRouting	ENDP
)fi


;***
;	GetpFromTable:PROCEDURE(wCase, userNum, ppFromTableRet);
;***
GetpFromTable	PROC	NEAR

	; GetpStructure sets ES to address OS data segment
ASSUME	ES: DGroup, DS: Nothing

	sub		BX, iTableFirst+iTableFirst	;BX=iTable*2
	shl		BX, 1
	mov		ax, word ptr pTable[bx]
	mov		dx, word ptr pTable[bx+2]
%if(%ctosp)then(
	jmp		CheckqDXAX
)else(
	jmp		SHORT RetqDXAX
)fi

GetpFromTable	ENDP


;***
;	GetpIBusIDTable:PROCEDURE(wCase, userNum, ppIBusIDTableRet);
;***
GetpIBusIDTable	PROC	NEAR

	; GetpStructure sets ES to address OS data segment
ASSUME	ES: DGroup, DS: Nothing

	mov		ax, word ptr pIBusIDTable
	mov		dx, word ptr pIBusIDTable+2
%if(%ctosp)then(
	jmp		CheckqDXAX
)else(
	jmp		SHORT RetqDXAX
)fi

GetpIBusIDTable	ENDP

%if(NOT %ctosp)then(
GetpIntSwtbl	PROC	NEAR

ASSUME	ES: DGroup, DS: Nothing

	mov		ax, offset DGroup:IntSwtbl
	mov		dx, es
	jmp		SHORT RetqDXAX

GetpIntSwtbl	ENDP
)fi


GetpNlsTables proc near

ASSUME	ES: DGroup, DS: Nothing

	mov		ax, word ptr pNlsTables
	mov		dx, word ptr pNlsTables+2
	or		dx, dx
	jnz		ValidpNlsTables
	jmp		BadSpecialCase
ValidpNlsTables:
%if(%ctosp)then(
	jmp		CheckqDXAX
)else(
	jmp		SHORT RetqDXAX
)fi

GetpNlsTables endp


;***
;	GetpCDT:PROCEDURE(wCase, userNum, ppCDTRet);
;***
GetpCDT	PROC	NEAR

	; GetpStructure sets ES to address OS data segment
ASSUME	ES: DGroup, DS: Nothing

	mov		ax, word ptr pCDT
	mov		dx, word ptr pCDT+2
%if(%ctosp)then(
	jmp		CheckqDXAX
)else(
	jmp		SHORT RetqDXAX
)fi

GetpCDT	ENDP


;***
;	GetpDiskStat:PROCEDURE(wCase, userNum, ppDiskStatRet);
;***
GetpDiskStat	PROC	NEAR

	; GetpStructure sets ES to address OS data segment
ASSUME	ES: DGroup, DS: Nothing

	mov		ax, word ptr pDiskStat
	mov		dx, word ptr pDiskStat+2
%if(%ctosp)then(
	jmp		CheckqDXAX
)else(
	jmp		RetqDXAX
)fi

GetpDiskStat	ENDP


;***
;	GetpStat:PROCEDURE(wCase, userNum, ppStatRet);
;***
GetpStat	PROC	NEAR

	; GetpStructure sets ES to address OS data segment
ASSUME	ES: DGroup, DS: Nothing

	mov		ax, word ptr pStat
	mov		dx, word ptr pStat+2
%if(%ctosp)then(
	jmp		CheckqDXAX
)else(
	jmp		RetqDXAX
)fi

GetpStat	ENDP


;***
;	GetprgprgNetRouting:PROCEDURE(wCase, userNum, pprgprgNetRouting);
;***
GetprgprgNetRouting	PROC	NEAR

	; GetpStructure sets ES to address OS data segment
ASSUME	ES: DGroup, DS: Nothing

%IF(%ctosp) THEN (
	mov		ax, [bp+csRet]
	cmp		ax, sgRealInterface
	je		BSP
)FI
	test	vfGetpRgPRgNetRouting, 0FFh
	jz		BSP

	mov		ax, word ptr prgPrgNetRouting
	mov		dx, word ptr prgPrgNetRouting+2
%if(%ctosp)then(
	jmp		CheckqDXAX
)else(
	jmp		RetqDXAX
)fi
	
BSP:
	jmp		BadSpecialCase

GetprgprgNetRouting	ENDP


;***
;	GetpUnsupportedCase:PROCEDURE(wCase, userNum, ppNullRet);
;***
GetpUnsupportedCase	PROC	NEAR

	; GetpStructure sets ES to address OS data segment
ASSUME	ES: DGroup, DS: Nothing

	mov		AX, ercNotImplemented
	jmp		RetAX8

GetpUnsupportedCase	ENDP



%IF(%Mp)THEN(
;***
;	GetpRgLineMap:PROCEDURE(wCase, userNum, ppLineMapRet);
;***
GetpRgLineMapInternal PROC NEAR

	; GetpStructure sets ES to address OS data segment
ASSUME	ES: DGroup, DS: Nothing

%IF (%Vp OR %Mp) THEN (%' used to be just Vp.
; GetPrgLineMap is a system common subroutine	
	les		SI, DWORD PTR [BP+argpPRet]
	push		ES
	push		SI
	call		FAR PTR sc_GetPrgLineMap
; erc in ax
%if(%ctosp)then(
	or		ax, ax
	jnz		GetPRgLineMapExit
	les		SI, DWORD PTR [BP+argpPRet]
	mov		ax, es:[si]
	mov		dx, es:[si+2]
	jmp		CheckqDXAX
)fi

GetPRgLineMapExit:
	jmp		RetAX8
) else (
	mov		ax, word ptr pRgLineMap
	mov		dx, word ptr pRgLineMap+2
	jmp		RetqDXAX
)fi

GetpRgLineMapInternal ENDP


;***
;	GetpContextStatus:PROCEDURE(wCase, userNum, ppContextStatusRet);
;***
GetpContextStatus	PROC	FAR

	; GetpStructure sets ES to address OS data segment
ASSUME	ES: DGroup, DS: Nothing

	mov		ax, word ptr prgContextStatus
	mov		dx, prgContextStatus+2
%if(%ctosp)then(
	jmp		CheckqDXAX
)else(
	jmp		RetqDXAX
)fi

GetpContextStatus	ENDP


;***
;	GetpRgUserReadCount:PROCEDURE(wCase, userNum, ppRgUserReadCountRet);
;***
GetpRgUserReadCount	PROC	NEAR

	; GetpStructure sets ES to address OS data segment
ASSUME	ES: DGroup, DS: Nothing

	mov		ax, oRgUserReadCount
	mov		dx, ES		;DGroup
%if(%ctosp)then(
	jmp		CheckqDXAX
)else(
	jmp		RetqDXAX
)fi

GetpRgUserReadCount	ENDP


;***
;	GetpScratch:PROCEDURE(wCase, userNum, ppsbScratchVolumeSpec);
;***
GetpScratch	PROC	NEAR

	; GetpStructure sets ES to address OS data segment
ASSUME	ES: DGroup, DS: Nothing

	mov		ax, word ptr psbScratchVolumeSpec
	mov		dx, word ptr psbScratchVolumeSpec+2
%if(%ctosp)then(
	jmp		CheckqDXAX
)else(
	jmp		RetqDXAX
)fi

GetpScratch	ENDP


;***
;	GetpPartitionStructure:PROCEDURE(wCase, userNum, ppStructureRet) PUBLIC;
;***
GetpPartitionStructure	PROC	FAR
argCase	EQU	12
argUserNum	EQU	10


	mov		AX, DGroup
	mov		ES, AX
ASSUME	ES: DGroup, DS: Nothing

	push		BP
	mov		BP, SP

GetpPartitionStructureInternal:

	cmp		WORD PTR [BP+argUserNum], 1
	jne		TestUserZero
	mov		AX, userNumPrimary 
	mov		[BP+argUserNum], AX
	jmp		@01

TestUserZero:
	cmp		WORD PTR [BP+argUserNum], 0
	jne		@01
	call		FetchUserNum
	mov		[BP+argUserNum], AX
@01:
;	Set 'Clean' bit for users who getpRgpVidMemLine:
	cmp		WORD PTR [BP+argCase], caseRgpVidMemLine
	jne		@02
	mov		BX, oPcbRun			; For user CALLing, not user p is for.
	mov		BX, ES:[BX+pcbUserNum]
    AND     BX, 03FFH
	PUSH	ES					;Save ES (DGroup)
	LES		SI,prgContextState
	or		BYTE PTR ES:[BX][SI], bitClean
	POP		ES					;Restore ES
%IF (%Vp) THEN (
;   Notify VAM that rgpVidMemLine in use (for windowing)
	push	bx ; userNum
	call	sc_NotifyRgVidMemLineUser
)FI
@02:
;	Get mask of conditions erc.
	mov		BX, [BP+argCase]
	cmp		bx, casergpVidMemLineReal
	jne		@03
	mov		bx, casergpVidMemLine
	jmp		@033
@03:
	cmp		bx, casepParKbdInfo
	jne		@033
	mov		bx, ipParKbdInfo
@033:
	shl		BX, 1
	push		WORD PTR rgBitMask[BX]
	push		[BP+argUserNum]		
; AX=TestPartitionFlags(bitMask, userNum);
	call		TestPartitionFlags	
; erc if any flag set/reset wrongly.
	or		AX, AX
	jz		OK1
	jmp		RetAX8
OK1:

; ----------------------------------------------------------------
; In CTOSp, pVcb, pVLPB, and pRgVidMemLine contain selectors if 
; the task is protected and sas if the task is real.
; 
; The following cases exist for these pointers.
;
; 1. Task is protected - general facility works.  Caller is
;    always protected.  Just return the pointer.
;
; 2. Task is real
;    a. Caller is real - general facility works.  Just return
;       the pointer.
;    b. Caller is protected (i.e. VAM).  For pVLPB, return
;       ercNotImplemented.  For pVcb, construct a pointer using
;       the selector of pExParDesc and the stored ra.  For
;       pRgVidMemLine, construct a pointer using the selector of
;       pExParDesc and the stored ra minus the size of the 
;       rgVidMemLine.  Return the amended pointer.
;
; Also, the following cases exist for caseRgpVidMemLineReal,
; which is the alternate copy of rgPVidMemLine that is maintained
; for real mode tasks.
;
; 1. real mode operating system - always return error.
;
; 2. Task is protected mode - always return error.
;
; 3. Task is real mode
;    a. Caller is real - return error - caller should be using
;       case 7.
;    b. Caller is protected - construct pointer using selector
;       of exParDesc and ra from rgPVidMemLine. Return pointer.
;
; ----------------------------------------------------------------
; In CtosP, also do special checking when case is rgPVidMemLine and
; a real mode user is calling GetPStructure directly. 

; ----------------------------------------------------------------

		; General pPartitionTable routine:
		; SI=ParCnfgBlk offset of desired table.
		; CX=offset in table of desired ptr, =0 if pTable wanted.
	mov		BX, [BP+argCase]
	cmp		bx, casergpVidMemLineReal
	jne		@0
%if(%ctosp)then(
	mov		bx, casergpVidMemLine
)else(
	jmp		BadSpecialCase
)fi
@0:
	cmp		bx, casepParKbdInfo
	jne		@034
	mov		bx, ipParKbdInfo
@034:
	mov		AL, BYTE PTR rgoTable[BX]
	mov		SI, AX
	mov		AL, BYTE PTR rgoPtr[BX]
	mov		CX, AX

;	Address partition segment.
	MOV     BX,	[BP+argUserNum]
    AND     BX, 03FFH
%if(%ctosp)then(
	shl		bx, 1                ; BX=isgAsib
	mov		es, rgsgAsib[bx]
ASSUME	ES: Nothing
	mov		es, ES:[oAsibSgUser]
ASSUME	ES: Nothing
)else(
	SHL		BX, 1				; word index
	mov		DI, BX
	push	ES
	les		BX, DWORD PTR pRgOExUcb
ASSUME	ES:Nothing
	mov		BX, ES: [BX][DI]		; BX=oExUcb
	mov		BX, ES: [BX+oParDesc]	; BX=ExUcb.oParDesc
	pop		ES
ASSUME	ES:DGroup
	mov		AX, ES: [BX+saLowBound]	; AX=ParDesc.saLowBound
	mov		ES, AX
ASSUME	ES: Nothing
)fi

;	We're in the partition now.
	mov		BX, ES: [SI]		; BX=ParCnfgBlock.[SI] (oExParDesc,oBcb,oTcb)
%if(%ctosp)then(
	jcxz	@036				; CX=0 means return pTable.
)else(
	jmp		GotpTable
)fi

	add		BX, CX				; Ret a field of table (pVCB etc).
	mov		ax, word ptr ES: [BX]
	mov		dx, word ptr ES: [BX+2]

	mov		BX, [BP+argCase]
	cmp		bx, casepParKbdInfo
	jne		@035

	mov		bx, DGroup
	mov		es, bx
assume es:DGroup
	add		ax, ES: sBufOut
assume es:nothing

@035:


%if(%ctosp)then(
	mov		bx, [BP+argCase]
	cmp		bx, casepVlpb
	je		CheckMode
	cmp		bx, casepVcb
	je		CheckMode
	cmp		bx, casergpVidMemLine
	je		CheckMode
	cmp		bx, casergpVidMemLineReal
	je		CheckMode
	jmp		CheckqDXAX

@036:
	jmp		GotpTable			; CX=0 means return pTable.

CheckMode:
	push		ax ; save ra
	push		[bp+argUserNum]
	call		FRealUser
	xchg		ax,di	;DI bit [1,0] = [fRealSn,fRealUser]
	pop		ax ; restore ra

;	If caseRgpVidMemLineReal caller must be protected, task real

	cmp		WORD PTR [bp+argCase], caseRgpVidMemLineReal
	jne		@6
	test		di, bitRealUser
	jnz		@6
	jmp		BadSpecialCase	; protected mode task
@6:
	test		di, bitRealSn
	jz		@5 ; protected mode selectors

; the sns are real - determine mode of caller

	mov		cx, es ; exParDesc selector
	mov		bx, DGroup
	mov		es, bx
assume es:DGroup
	mov		bx, [bp+csRet]
	cmp		bx, sgRealInterface
	jne		ProtectedCaller

; real user, real caller, all done unless the case is
; pRgVidMemLineReal

	jmp		CheckpRgVidMemLineReal

ProtectedCaller: ; and real user
	mov		bx, [bp+argCase]
	cmp		bx, casepVlpb
	jne		@4
	jmp		BadSpecialCase ; pVlpb
@4: mov		dx, cx ; use exParDesc selector
	cmp		bx, casepVcb
	je		@5
	cmp		bx, caseRgpVidMemLineReal
	je		@5 
	sub		ax, srgpVidLine ;pRgVidMemLine

@5:	jmp		RetqDXAX	

CheckpRgVidMemLineReal: ; real user, real caller
	mov		bx, [bp+argCase]
	cmp		bx, caseRgpVidMemLineReal
	jne		@5
	jmp		BadSpecialCase ; pRgVidMemLineReal

assume es:nothing

)else(
	jmp		RetqDXAX
)fi

GotpTable:
	mov		ax, bx
	mov		dx, es
%if(%ctosp)then(
	jmp		CheckqDXAX
)else(
	jmp		RetqDXAX
)fi

GetpPartitionStructure	ENDP
)fi

;***********************************
;****  GetpUSeg
;***********************************
GetpUSeg	PROC	FAR
argCase		EQU	12
argUserNum	EQU	10
oUsegDesc 	EQU 6
	PUSH	BP
	MOV		BP, SP
	
GetpUSegInternal:
	PUSH	DS
	MOV		AX, DGroup
	MOV		DS, AX
ASSUME	DS:DGroup, ES:NOTHING

%IF(NOT(%CTOSP))THEN(
	MOV		AX, ercNotImplemented
) ELSE (
	CMP		WORD PTR [BP+argUserNum], 1
	JNE		TestUser
	MOV		AX, userNumPrimary 
	MOV		[BP+argUserNum], AX

TestUser:
	CMP		WORD PTR [BP+argUserNum], 0
	JNE		UserOk
	CALL	FetchUserNum
	MOV		[BP+argUserNum], AX
UserOk:
	PUSH	bitCCBFalse
	PUSH	[BP+argUserNum]		
	CALL	TestPartitionFlags	
	OR		AX, AX
	JZ		FlagsOk

; batch partitions have usegs too - 7/8/92 JM
	PUSH	bitBatchFalse
	PUSH	[BP+argUserNum]		
	CALL	TestPartitionFlags	
	OR		AX, AX
	JZ		FlagsOk

	JMP		GetpUSegErrorRet
FlagsOk:
	MOV     BX, [BP+argUserNum]
    AND     BX, 03FFH
	SHL		BX, 1
	MOV		ES, rgsgAsib[bx]
	MOV		ES, ES:[oAsibSgUser]
	MOV		BX, ES:[oUsegDesc]		; ES:BX -> UsegDesc
; build index to USegDesc.rgsg
; 	USegDesc is STRUCTURE (
; 		cUSeg WORD
;		rgsgUseg (1) WORD )
	MOV		SI, [BP+argCase]	;case grows from 0FFFFh down.
	NOT		SI
	SHL		SI, 1
	MOV		DX, ES:[BX][SI+2]
	XOR		AX, AX
	POP		DS ; restore user DS
ASSUME	DS:NOTHING

	JMP		CheckqDXAX ; CheckqDXAX does SaFromSn for real mode

GetpUSegErrorRet:
)FI
	POP		DS ; restore user DS
	POP		BP
	RET		8	
	
GetPuSeg	ENDP





%IF(NOT %Vp) THEN (
;***
;	QuietContext:PROCEDURE(ch, erc) PUBLIC;
;***
QuietContext	PROC	FAR
argErc	EQU	6
argUserNum	EQU	8
rqRCode	EQU	10

	push	BP
	mov		BP, SP
ASSUME	DS: DGroup

	CMP		WORD PTR [BP+argUserNum], 1
	JNE		@00
	MOV		AX, userNumPrimary
	MOV		[BP+argUserNum], AX
@00:
	MOV     BX, [BP+argUserNum]	; IF rgcRq(userNum) = 1
    AND     BX, 03FFH
	ADD		BX,pRgcRq
	MOV		ES,pRgcRq+2
	mov		AX, ercOk
	cmp		BYTE PTR ES:[BX], 1
	jne		m09b
	jmp		RetAX4
m09b:

;	Create request block.
	lea		DI, rqReset
	push	DS
	pop		ES
ASSUME	ES: DGroup

	CLD
	mov		AX, 2		;sCntlInfo
	STOSW
	xor		AX, AX		;nReqRespPbCb
	STOSW
	mov		AX, [BP+argUserNum]
	STOSW
	mov		BX, WORD PTR oPcbRun
	mov		AX, [BX+pcbRespExch]
	STOSW
	add		DI, 4		;ercRet, rcode
	mov		AX, [BP+argErc]
	STOSW

	xor		CX, CX
	mov		CL, BYTE PTR nSwappingRq
	LES		SI, pRgSwappingRq

@qLoop:
	LODS	WORD PTR ES:[SI]	;rqCode
	mov		rqReset+rqRCode, AX
	push	SI			;save it
	push	CX
	push	ES
	lea		AX, rqReset
	push	DS
	push	AX
	call	RequestKWait
	or		AX, AX
	jz		@qEnd

	cmp		AX, ercServiceNotAvail
	je		@qEnd
	push	AX
	call	Crash

@qEnd:
	pop		ES
	pop		CX
	pop		SI
	loop		@qLoop

	MOV     BX, [BP+argUserNum]
    AND     BX, 03FFH
	SHL		BX, 1				; word index
	mov		DI, BX
	push	ES
	les		BX, DWORD PTR pRgOExUcb
ASSUME	ES:Nothing
	mov		BX, ES:[BX][DI]	; BX=oExUcb
WaitForMassIoDone:
	cmp		WORD PTR ES:[BX+cMassIoRq], 0; DO WHILE ExUcb.cMassIoRq <> 0;
	jne		WaitForMassIoDone			;	END;
	pop		ES
ASSUME	ES:DGroup

	MOV     BX, [BP+argUserNum]	; IF rgcRq(userNum) <> 1
    AND     BX, 03FFH
	ADD		BX,prgcRq
	MOV		ES,pRgcRq+2
	xor		AX, AX
	cmp		BYTE PTR ES:[BX], 1
	je		RetAX4
	mov		AX, ercRequestsOutstanding

RetAX4:
ASSUME	DS: Nothing
	pop		BP
	RET		4

QuietContext	ENDP


;***
;	QuietForSwap:PROCEDURE(ch, erc) PUBLIC;
;***
QuietForSwap	PROC	FAR
argErc	EQU	6
argUserNum	EQU	8
rcQuietContext	EQU	1002h

	push	BP
	mov		BP, SP
	PUSH	DS
	mov		AX, DGroup
	mov		DS, AX
ASSUME	DS: DGroup

	CMP		WORD PTR [BP+argUserNum], 1
	JNE		UserNumOk
	MOV		AX, userNumPrimary
	MOV		[BP+argUserNum], AX
	
UserNumOk:
	mov		AX, bitVacantTrue + bitCCBFalse
	push	AX
	push	[BP+argUserNum]		; AX=TestPartitionFlags(wMask, userNum);
	call	TestPartitionFlags	; erc if Vacant or NOT fCCB
	or		AX, AX
	jnz		RetAXDS4

;	Tell Kernel which partition is being swapped.
	mov		AX, [BP+argUserNum]
	mov		userNumSwap, AX
	CALL		FAR PTR sc_LockVideoForModify	;AFTER userNumSwap set!

;	Create request block on stack.
	push	[BP+argErc]			;'fh'
	mov		AX, rcQuietContext	;rqCode
	push	AX
	sub		SP, 2				;ercRet
	mov		BX, WORD PTR oPcbRun
	push	[BX+pcbRespExch]	;respExch
	mov		AX, [BP+argUserNum]	;userNum
	push	AX
	xor		AX, AX				;nReqRespPbCb
	push	AX
	mov		AL, 2				;nCntlInfo
	push	AX

	lea		AX, [BP-16]
	push	SS
	push	AX
	CALL	KRequestKWait

	CALL		FAR PTR sc_UnLockVideoForModify	;BEFORE userNumSwap reset
	mov		userNumSwap, 0FFFFh	;turn off Kernel 'swap-Respond' interception.

	mov		AX, [BP-8]		; rq.ercRet

	lea		SP, [BP-2]		; preserve user DS on stack
RetAXDS4:
	POP		DS
ASSUME	DS: Nothing
	pop		BP
	RET		4

QuietForSwap	ENDP
)FI	%' End Not Vp only

;***
;	GetpSpecialKeys:PROCEDURE(wCase, userNum, ppSpecialKeys);
;***
GetpSpecialKeys	PROC	NEAR

ASSUME	ES: DGroup, DS: Nothing

	LES	AX, DWORD PTR pSpecialKeys
	MOV	DX, ES
	JMP	RetqDXAX

GetpSpecialKeys	ENDP


%CmCommon	ENDS

END
