/***
*stddef.h - definitions/declarations for common constants, types, variables
*
*	Copyright 1985-1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This file contains definitions and declarations for some commonly
*	used constants, types, and variables.
*	[POSIX/ANSI]
*
****/

#if !defined(_STDDEF_DEFINED)

#define _STDDEF_DEFINED

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif

/* define the NULL pointer value and the offsetof() macro */

#if (_MSC_VER >= 600)
#define NULL	((void _FAR_ *)0)
#elif (defined(M_I86SM) || defined(M_I86MM))
#define NULL	0
#else
#define NULL	0L
#endif

#define offsetof(s,m)	((size_t)&(((s *)0)->m))


/* define the implementation dependent size types */

typedef signed int ptrdiff_t;

typedef unsigned short size_t;

typedef char wchar_t;


/* define pointer to thread id value */

#if defined(_MT)
extern signed int _FAR_ *_threadid;
#endif

#endif /* !_STDDEF_DEFINED */
