/*
/   ctos.lib.h
/
/   Copyright 1991, Unisys Corporation.  All rights reserved.
/ 
/   CTOSLIB.Lib procedural interface prototypes
/ 
/   To use this library, you must include a #define statement in your source
/   for each CTOS routine that you will be calling before including this
/   file.  The case of the identifier in the #define statement is crucial.
/   If the case is incorrect, no error message will be generated during the
/   compile and the proper prototype will not be defined.
/ 
/   To help avoid this problem, it is recommended that the #define statements
/   include an illegal C character.  For example:
/ 
/       #define AllocExch         @
/       #define ErrorExitString   @
/       #include "ctos.lib.h"
/ 
/   For #define statements with the correct case, the identifier will be
/   un-defined by this header file and will be established as a procedure.
/   For those with incorrect case, the @ will be substituted in the code
/   where ever the identifier is used and will cause a compiler error, thus
/   identifying the problem.
/ 
/   As an alternative, you may wish to compile with the /W3 compiler switch.
/   This switch will cause warnings to be generated when a procedure is
/   called for which no prototype has been defined.  It will, however, cause
/   several other types of warning messages to be generated.
/ 
/ */

#if !defined _CTOSLIB
#define _CTOSLIB

typedef  unsigned char   Uchar  ;
typedef  unsigned int    Uint   ;
typedef  unsigned long   Ulong  ;
typedef  unsigned short  Ushort ;

typedef  void _far *     Pvoid  ;

#endif


#if defined AccessNVRam || defined All
#undef AccessNVRam
Ushort _far _cdecl AccessNVRam( Uint mode, Uint iByte, Pvoid pByteData ) ;
#endif

#if defined AcquireByteStreamC || defined All
#undef AcquireByteStreamC
Ushort _far _cdecl AcquireByteStreamC( Pvoid pBs, Pvoid pbDevSpec, Uint cbDevSpec, Uint mode, Pvoid pConfig, Pvoid pbTQ, Uint cbTQ, Pvoid pbRQ, Uint cbRQ, Uint cbRxMax, Uchar bMode ) ;
#endif

#if defined AddQueue || defined All
#undef AddQueue
Ushort _far _cdecl AddQueue( Pvoid pbQueueName, Uint cbQueueName, Pvoid pbFileSpec, Uint cbFileSpec, Uint wEntrysize, Uint wQueueType, Pvoid pQhRet ) ;
#endif

#if defined AddQueueEntry || defined All
#undef AddQueueEntry
Ushort _far _cdecl AddQueueEntry( Pvoid pbQueueName, Uint cbQueueName, Uchar fQueueIfNoServer, Uint priority, Uint queueType, Pvoid pEntry, Uint sEntry, Pvoid pDateTime, Uint repeatTime ) ;
#endif

#if defined AllocAllMemorySL || defined All
#undef AllocAllMemorySL
Ushort _far _cdecl AllocAllMemorySL( Pvoid pcParagraphRet, Pvoid ppSegmentRet ) ;
#endif

#if defined AllocAreaSL || defined All
#undef AllocAreaSL
Ushort _far _cdecl AllocAreaSL( Uint cbArea, Pvoid ppAreaRet ) ;
#endif

#if defined AllocExch || defined All
#undef AllocExch
Ushort _far _cdecl AllocExch( Pvoid pExchRet ) ;
#endif

#if defined AllocLdtSlot || defined All
#undef AllocLdtSlot
Ushort _far _cdecl AllocLdtSlot( Pvoid pSlRet ) ;
#endif

#if defined AllocMemoryFramesSL || defined All
#undef AllocMemoryFramesSL
Ushort _far _cdecl AllocMemoryFramesSL( Uint cFrames, Pvoid ppSegmentRet ) ;
#endif

#if defined AllocMemoryInit || defined All
#undef AllocMemoryInit
Ushort _far _cdecl AllocMemoryInit( Uint cBytes, Pvoid ppMemoryRet, Uchar fInit ) ;
#endif

#if defined AllocMemoryLL || defined All
#undef AllocMemoryLL
Ushort _far _cdecl AllocMemoryLL( Uint cBytes, Pvoid ppSegmentRet ) ;
#endif

#if defined AllocMemoryPermanent || defined All
#undef AllocMemoryPermanent
Ushort _far _cdecl AllocMemoryPermanent( Uint cBytes, Pvoid ppSegmentRet ) ;
#endif

#if defined AllocMemorySL || defined All
#undef AllocMemorySL
Ushort _far _cdecl AllocMemorySL( Uint cBytes, Pvoid ppSegmentRet ) ;
#endif

#if defined AllocMoverSegment || defined All
#undef AllocMoverSegment
Ushort _far _cdecl AllocMoverSegment( Ulong qb, Pvoid pMaRet ) ;
#endif

#if defined AllocUserNumbers || defined All
#undef AllocUserNumbers
Ushort _far _cdecl AllocUserNumbers( Uint cUserNum, Pvoid pUserNumBlockRet ) ;
#endif

#if defined AssignKbd || defined All
#undef AssignKbd
Ushort _far _cdecl AssignKbd( Uint ph ) ;
#endif

#if defined AssignVidOwner || defined All
#undef AssignVidOwner
Ushort _far _cdecl AssignVidOwner( Uint ph ) ;
#endif

#if defined AsyncRequest || defined All
#undef AsyncRequest
Ushort _far _cdecl AsyncRequest( Pvoid prq ) ;
#endif

#if defined AsyncRequestDirect || defined All
#undef AsyncRequestDirect
Ushort _far _cdecl AsyncRequestDirect( Uint exch, Pvoid prq ) ;
#endif

#if defined AtFileInit || defined All
#undef AtFileInit
Ushort _far _cdecl AtFileInit( Pvoid pbFileSpec, Uint cbFileSpec, Pvoid pBufferAt, Uint sBufferAt ) ;
#endif

#if defined AtFileNext || defined All
#undef AtFileNext
Ushort _far _cdecl AtFileNext( Pvoid pBufferAt, Pvoid pSdRet ) ;
#endif

#if defined Beep || defined All
#undef Beep
Ushort _far _cdecl Beep( void ) ;
#endif

#if defined BuildFileSpec || defined All
#undef BuildFileSpec
Uint _far _cdecl BuildFileSpec( Ushort userNum, Pvoid pbOutputSpec, Pvoid pcbOutputSpec, Pvoid pcbOutputSpecNoPW, Ushort cbOutputSpecMax, Uchar fDefaultPath, Pvoid pbNode, Ushort cbNode, Pvoid pbVol, Ushort cbVol, Pvoid pbDir, Ushort cbDir, Pvoid pbFile, Ushort cbFile, Uchar fDefaultPrefix, Pvoid pbPassword, Ushort cbPassword, Uchar fCanonical, Uchar bMode ) ;
#endif

#if defined BuildFullSpecFromPartial || defined All
#undef BuildFullSpecFromPartial
Uint _far _cdecl BuildFullSpecFromPartial( Ushort userNum, Pvoid pbOutputSpec, Pvoid pcbOutputSpec, Pvoid pcbOutputSpecNoPW, Ushort cbOutputSpecMax, Pvoid pbInputSpec, Ushort cbInputSpec, Uchar fDefaultPrefix, Uchar fCanonical, Uchar bSpecType ) ;
#endif

#if defined BuildLdtSlot || defined All
#undef BuildLdtSlot
Ushort _far _cdecl BuildLdtSlot( Uint sl, Ulong la, Uint limit, Uchar access ) ;
#endif

#if defined BuildRasterText || defined All
#undef BuildRasterText
Ushort _far _cdecl BuildRasterText( Pvoid pbChars, Uint cbChars, Pvoid pFont, Uchar bxyOffset, Uint cwLine, Uint wInterSpace, Uint wAttr, Uint pMem) ;
#endif

#if defined BuildSpecFromDir || defined All
#undef BuildSpecFromDir
Uint _far _cdecl BuildSpecFromDir( Pvoid pbOutputSpec, Pvoid pcbOutputSpec, Uint cbOutputSpecMax, Pvoid pbDir, Uint cbDir, Uchar bMode) ;
#endif

#if defined BuildSpecFromFile || defined All
#undef BuildSpecFromFile
Uint _far _cdecl BuildSpecFromFile( Pvoid pbOutputSpec, Pvoid pcbOutputSpec, Uint cbOutputSpecMax, Pvoid pbFile, Uint cbFile, Pvoid pbDefaultPrefix, Uint cbDefaultPrefix, Uchar bMode) ;
#endif

#if defined BuildSpecFromNode || defined All
#undef BuildSpecFromNode
Uint _far _cdecl BuildSpecFromNode( Pvoid pbOutputSpec, Pvoid pcbOutputSpec, Uint cbOutputSpecMax, Pvoid pbNode, Uint cbNode, Uchar bMode) ;
#endif

#if defined BuildSpecFromPassword || defined All
#undef BuildSpecFromPassword
Uint _far _cdecl BuildSpecFromPassword( Pvoid pbOutputSpec, Pvoid pcbOutputSpec, Uint cbOutputSpecMax, Pvoid pbPassword, Uint cbPassword, Uchar bMode) ;
#endif

#if defined BuildSpecFromVol || defined All
#undef BuildSpecFromVol
Uint _far _cdecl BuildSpecFromVol( Pvoid pbOutputSpec, Pvoid pcbOutputSpec, Uint cbOutputSpecMax, Pvoid pbVol, Uint cbVol, Uchar bMode ) ;
#endif

#if defined CacheClose || defined All
#undef CacheClose
Ushort _far _cdecl CacheClose( Ulong cachePoolHandle ) ;
#endif

#if defined CacheFlush || defined All
#undef CacheFlush
Ushort _far _cdecl CacheFlush( Ulong cachePoolHandle, Pvoid pCacheIdMask, Pvoid pCacheIdTemplate, Uint wControlMask, Uint wControlWord, Pvoid pcSelectedRet ) ;
#endif

#if defined CacheGetEntry || defined All
#undef CacheGetEntry
Ushort _far _cdecl CacheGetEntry( Ulong cachePoolHandle, Pvoid pCacheId, Uint wFlags, Pvoid ppCacheBufferRet, Pvoid pCacheEntryHandleRet ) ;
#endif

#if defined CacheGetStatistics || defined All
#undef CacheGetStatistics
Ushort _far _cdecl CacheGetStatistics( Ulong cachePoolHandle, Pvoid ppCsbRet ) ;
#endif

#if defined CacheGetStatus || defined All
#undef CacheGetStatus
Ushort _far _cdecl CacheGetStatus( Ulong cachePoolHandle, Pvoid pCacheID, Pvoid pControlWordRet ) ;
#endif

#if defined CacheInit || defined All
#undef CacheInit
Ushort _far _cdecl CacheInit( Pvoid pCacheMemoryTable, Uint sCacheMemoryTable, Uint sDataBuffer, Pvoid pFlushProc, Uint wDataAlignMask, Uint cMinWorkingSet, Pvoid pCachePoolHandleRet ) ;
#endif

#if defined CacheReleaseEntry || defined All
#undef CacheReleaseEntry
Ushort _far _cdecl CacheReleaseEntry( Ulong cachePoolHandle, Ulong cacheEntryHandle, Uint wControlMask, Uint wControlWord ) ;
#endif

#if defined CallRealCommIsr || defined All
#undef CallRealCommIsr
void _far _cdecl CallRealCommIsr( void ) ;
#endif

#if defined CfaFfVersion || defined All
#undef CfaFfVersion
Uint _far _cdecl CfaFfVersion( Pvoid pVerStruct, Uint sVerStruct, Pvoid pcbRet ) ;
#endif

#if defined CfaServerVersion || defined All
#undef CfaServerVersion
Uint _far _cdecl CfaServerVersion( Pvoid pVerStruct, Uint sVerStruct, Pvoid pcbRet ) ;
#endif

#if defined CfaWaVersion || defined All
#undef CfaWaVersion
Uint _far _cdecl CfaWaVersion( Pvoid pVerStruct, Uint sVerStruct, Pvoid pcbRet ) ;
#endif

#if defined Chain || defined All
#undef Chain
Ushort _far _cdecl Chain( Pvoid pbFileSpec, Uint cbFileSpec, Pvoid pbPassword, Uint cbPassword, Uint priority, Uint ercTermination, Uchar fDebug ) ;
#endif

#if defined ChangeCommLineBaudRate || defined All
#undef ChangeCommLineBaudRate
Ushort _far _cdecl ChangeCommLineBaudRate( Uint commLineHandle, Uint iRxTx, Uint baudRate ) ;
#endif

#if defined ChangeCursor || defined All
#undef ChangeCursor
Ushort _far _cdecl ChangeCursor( Pvoid pCuWa, Pvoid pIcon ) ;
#endif

#if defined ChangeFileLength || defined All
#undef ChangeFileLength
Ushort _far _cdecl ChangeFileLength( Uint fh, Ulong lfaNewFileSize ) ;
#endif

#if defined ChangeOpenMode || defined All
#undef ChangeOpenMode
Ushort _far _cdecl ChangeOpenMode( Uint fh, Pvoid pbPassword, Uint cbPassword, Uint newMode ) ;
#endif

#if defined ChangePriority || defined All
#undef ChangePriority
Ushort _far _cdecl ChangePriority( Uint priority ) ;
#endif

#if defined ChangeProcessPriority || defined All
#undef ChangeProcessPriority
Ushort _far _cdecl ChangeProcessPriority( Uint wProcessId, Uint priority ) ;
#endif

#if defined Check || defined All
#undef Check
Ushort _far _cdecl Check( Uint exchange, Pvoid ppMsgRet ) ;
#endif

#if defined CheckContextStack || defined All
#undef CheckContextStack
Ushort _far _cdecl CheckContextStack( void ) ;
#endif

#if defined CheckErc || defined All
#undef CheckErc
void _far _cdecl CheckErc( Ushort erc ) ;
#endif

#if defined CheckForOperatorRestartC || defined All
#undef CheckForOperatorRestartC
Ushort _far _cdecl CheckForOperatorRestartC( Pvoid pBs, Pvoid pfRestartRet ) ;
#endif

#if defined CheckPointBs || defined All
#undef CheckPointBs
Ushort _far _cdecl CheckPointBs( Pvoid pBs ) ;
#endif

#if defined CheckPointBsAsyncC || defined All
#undef CheckPointBsAsyncC
Ushort _far _cdecl CheckPointBsAsyncC( Pvoid pBs, Uchar fIsPartOfClose, Uint idExch, Pvoid pMsg, Uint rqCode ) ;
#endif

#if defined CheckPointBsC || defined All
#undef CheckPointBsC
Ushort _far _cdecl CheckPointBsC( Pvoid pBs, Uchar fIsPartOfClose ) ;
#endif

#if defined CheckPointBsLp || defined All
#undef CheckPointBsLp
Ushort _far _cdecl CheckPointBsLp( Pvoid pBs, Uchar fIsPartOfClose ) ;
#endif

#if defined CheckpointRsFile || defined All
#undef CheckpointRsFile
Ushort _far _cdecl CheckpointRsFile( Pvoid pRswa ) ;
#endif

#if defined CheckpointSysIn || defined All
#undef CheckpointSysIn
Ushort _far _cdecl CheckpointSysIn( void ) ;
#endif

#if defined CheckReadAsync || defined All
#undef CheckReadAsync
Ushort _far _cdecl CheckReadAsync( Pvoid pRq, Pvoid psDataRet ) ;
#endif

#if defined CheckUserActive || defined All
#undef CheckUserActive
Ushort _far _cdecl CheckUserActive( Uint userNum ) ;
#endif

#if defined CheckWriteAsync || defined All
#undef CheckWriteAsync
Ushort _far _cdecl CheckWriteAsync( Pvoid pRq, Pvoid psDataRet ) ;
#endif

#if defined CleanQueue || defined All
#undef CleanQueue
Ushort _far _cdecl CleanQueue( Uint qH ) ;
#endif

#if defined ClearPath || defined All
#undef ClearPath
Ushort _far _cdecl ClearPath( void ) ;
#endif

#if defined CloseAllFiles || defined All
#undef CloseAllFiles
Ushort _far _cdecl CloseAllFiles( void ) ;
#endif

#if defined CloseAllFilesLL || defined All
#undef CloseAllFilesLL
Ushort _far _cdecl CloseAllFilesLL( void ) ;
#endif

#if defined CloseAltMsgFile || defined All
#undef CloseAltMsgFile
Ushort _far _cdecl CloseAltMsgFile( Pvoid pMwa, Uint sMwa ) ;
#endif

#if defined CloseByteStream || defined All
#undef CloseByteStream
Ushort _far _cdecl CloseByteStream( Pvoid pBs ) ;
#endif

#if defined CloseDaFile || defined All
#undef CloseDaFile
Ushort _far _cdecl CloseDaFile( Pvoid pDawa ) ;
#endif

#if defined CloseErcFile || defined All
#undef CloseErcFile
Ushort _far _cdecl CloseErcFile( void ) ;
#endif

#if defined CloseFile || defined All
#undef CloseFile
Ushort _far _cdecl CloseFile( Uint fh ) ;
#endif

#if defined CloseMsgFile || defined All
#undef CloseMsgFile
Ushort _far _cdecl CloseMsgFile( void ) ;
#endif

#if defined ClosePSSession || defined All
#undef ClosePSSession
Ushort _far _cdecl ClosePSSession( Uint sh ) ;
#endif

#if defined CloseRsFile || defined All
#undef CloseRsFile
Ushort _far _cdecl CloseRsFile( Pvoid pRswa ) ;
#endif

#if defined CloseRTClock || defined All
#undef CloseRTClock
Ushort _far _cdecl CloseRTClock( Pvoid pRqTime ) ;
#endif

#if defined CloseServerMsgFile || defined All
#undef CloseServerMsgFile
Ushort _far _cdecl CloseServerMsgFile( void ) ;
#endif

#if defined CloseTape || defined All
#undef CloseTape
Uint _far _cdecl CloseTape( Uint th ) ;
#endif

#if defined CloseVidFilter || defined All
#undef CloseVidFilter
Uint _far _cdecl CloseVidFilter( void ) ;
#endif

#if defined CompactDateTime || defined All
#undef CompactDateTime
Ushort _far _cdecl CompactDateTime( Pvoid pExpDateTime, Pvoid pDateTimeRet ) ;
#endif

#if defined ConfigureSpooler || defined All
#undef ConfigureSpooler
Ushort _far _cdecl ConfigureSpooler( Uint channel, Pvoid pbPrinterName, Uint cbPrinterName, Pvoid pbQueueName, Uint cbQueueName, Pvoid pbConfigureFile, Uint cbConfigureFile, Uint priority, Uchar fBanner ) ;
#endif

#if defined ControlInterrupt || defined All
#undef ControlInterrupt
Ushort _far _cdecl ControlInterrupt( Uint tyDev, Uchar bOp ) ;
#endif

#if defined ConvertToSys || defined All
#undef ConvertToSys
Ushort _far _cdecl ConvertToSys( void ) ;
#endif

#if defined CopyFile || defined All
#undef CopyFile
Ushort _far _cdecl CopyFile( Uint fh, Pvoid pbToFileSpec, Uint cbToFilespec, Pvoid pbPassword, Uint cbPassword, Pvoid pBuffer, Uint sBuffer, Uint fOverwriteOk ) ;
#endif

#if defined CParams || defined All
#undef CParams
Uint _far _cdecl CParams( void ) ;
#endif

#if defined Crash || defined All
#undef Crash
void _far _cdecl Crash( Uint ercTermination ) ;
#endif

#if defined CreateAlias || defined All
#undef CreateAlias
Ushort _far _cdecl CreateAlias( Pvoid pArea, Pvoid pSnRet ) ;
#endif

#if defined CreateBigPartition || defined All
#undef CreateBigPartition
Ushort _far _cdecl CreateBigPartition( Pvoid pbPartitionName, Uint cbPartitionName, Ulong qParagraph, Uchar fRunBatch, Pvoid pPhRet ) ;
#endif

#if defined CreateContext || defined All
#undef CreateContext
Ushort _far _cdecl CreateContext( Uint stackSize, Uint userNum ) ;
#endif

#if defined CreateDir || defined All
#undef CreateDir
Ushort _far _cdecl CreateDir( Pvoid pbDirSpec, Uint cbDirSpec, Pvoid pbVolPassword, Uint cbVolPassword, Pvoid pbDirPassword, Uint cbDirPassword, Uint cSectors, Uint defaultFileProtectionLevel ) ;
#endif

#if defined CreateExecScreen || defined All
#undef CreateExecScreen
Ushort _far _cdecl CreateExecScreen( Uint sVidMap, Uint cColsScreen, Uint cLinesScreen ) ;
#endif

#if defined CreateFile || defined All
#undef CreateFile
Ushort _far _cdecl CreateFile( Pvoid pbFileSpec, Uint cbFileSpec, Pvoid pbPassword, Uint cbPassword, Ulong lfaFileSize ) ;
#endif

#if defined CreatePartition || defined All
#undef CreatePartition
Ushort _far _cdecl CreatePartition( Pvoid pbPartitionName, Uint cbPartitionName, Uint cParagraph, Uchar fRunBatch, Pvoid pPhRet ) ;
#endif

#if defined CreateProcess || defined All
#undef CreateProcess
Ushort _far _cdecl CreateProcess( Pvoid pProcessDescriptor ) ;
#endif

#if defined CreateUser || defined All
#undef CreateUser
Uint _far _cdecl CreateUser( Pvoid pbName, Uint cbName, Uint cpar, Pvoid pUserNumRet, Uint cbUserStruct ) ;
#endif

#if defined CSubparams || defined All
#undef CSubparams
Uint _far _cdecl CSubparams( Uint iParam ) ;
#endif

#if defined CurrentOsVersion || defined All
#undef CurrentOsVersion
Ushort _far _cdecl CurrentOsVersion( Pvoid pwRelease, Pvoid pwRevision ) ;
#endif

#if defined DbgBmPutChars || defined All
#undef DbgBmPutChars
Ushort _far _cdecl DbgBmPutChars( Uint col, Uint row, Pvoid pb, Uint cb ) ;
#endif

#if defined DbgBmScroll || defined All
#undef DbgBmScroll
Ushort _far _cdecl DbgBmScroll( void ) ;
#endif

#if defined DbgBmSwitch || defined All
#undef DbgBmSwitch
Ushort _far _cdecl DbgBmSwitch( Pvoid prgSaBm, Uint cbSaBm, Uchar fSave ) ;
#endif

#if defined DbgPosCursor || defined All
#undef DbgPosCursor
Ushort _far _cdecl DbgPosCursor( Uint iCol, Uint iLine ) ;
#endif

#if defined DbgPutChars || defined All
#undef DbgPutChars
Ushort _far _cdecl DbgPutChars( Uint iCol, Uint iLine, Pvoid pbText, Uint cbText ) ;
#endif

#if defined DbgSroll || defined All
#undef DbgSroll
Ushort _far _cdecl DbgSroll( void) ;
#endif

#if defined DCXVersion || defined All
#undef DCXVersion
Ushort _far _cdecl DCXVersion( Pvoid pVerStruct, Uint sVerStruct, Pvoid pcbRet ) ;
#endif

#if defined DeactivateRunFile || defined All
#undef DeactivateRunFile
Ushort _far _cdecl DeactivateRunFile( Uint userNumPartition ) ;
#endif

#if defined DeallocAliasForServer || defined All
#undef DeallocAliasForServer
Ushort _far _cdecl DeallocAliasForServer( Uint sgAlias, Uint userNumOwner ) ;
#endif

#if defined DeallocateRods || defined All
#undef DeallocateRods
Ushort _far _cdecl DeallocateRods( Uint spLow, Uint spHigh ) ;
#endif

#if defined DeallocExch || defined All
#undef DeallocExch
Ushort _far _cdecl DeallocExch( Uint exchange ) ;
#endif

#if defined DeallocMemoryLL || defined All
#undef DeallocMemoryLL
Ushort _far _cdecl DeallocMemoryLL( Pvoid pSegment, Uint cBytes ) ;
#endif

#if defined DeallocMemorySL || defined All
#undef DeallocMemorySL
Ushort _far _cdecl DeallocMemorySL( Pvoid pSegment, Uint cBytes ) ;
#endif

#if defined DeallocMoverSegment || defined All
#undef DeallocMoverSegment
Ushort _far _cdecl DeallocMoverSegment( Pvoid pMaRet, Ulong qb ) ;
#endif

#if defined DeallocRunFile || defined All
#undef DeallocRunFile
Ushort _far _cdecl DeallocRunFile( Ulong Id ) ;
#endif

#if defined DeAllocSg || defined All
#undef DeAllocSg
Ushort _far _cdecl DeAllocSg( Uint sg, Uint userNum ) ;
#endif

#if defined DeallocUserNumbers || defined All
#undef DeallocUserNumbers
Ushort _far _cdecl DeallocUserNumbers( Uint userNumBlockId ) ;
#endif

#if defined DeAllocVlpb || defined All
#undef DeAllocVlpb
Ushort _far _cdecl DeAllocVlpb( void ) ;
#endif

#if defined DefineCursor || defined All
#undef DefineCursor
Ushort _far _cdecl DefineCursor( Pvoid pCuWa, Pvoid pIcon, Pvoid pBuf, Uint sBuf, Uchar bType, Uchar fHotspot, Uchar fHardware, Uchar bPlane ) ;
#endif

#if defined DefineInterLevelStack || defined All
#undef DefineInterLevelStack
Ushort _far _cdecl DefineInterLevelStack( Uint iLevel, Pvoid pStack ) ;
#endif

#if defined DefineLocalPageMap || defined All
#undef DefineLocalPageMap
Ushort _far _cdecl DefineLocalPageMap( Pvoid pFrames, Uint saLocal, Uint cFrames ) ;
#endif

#if defined DeinstallQueueManager || defined All
#undef DeinstallQueueManager
Ushort _far _cdecl DeinstallQueueManager( Pvoid pUserNumRet ) ;
#endif

#if defined DeinstPSServer || defined All
#undef DeinstPSServer
Ushort _far _cdecl DeinstPSServer( Pvoid pPSUserNumRet ) ;
#endif

#if defined Delay || defined All
#undef Delay
Ushort _far _cdecl Delay( Uint n ) ;
#endif

#if defined DeleteByteStream || defined All
#undef DeleteByteStream
Ushort _far _cdecl DeleteByteStream( Pvoid pBswa ) ;
#endif

#if defined DeleteDaRecord || defined All
#undef DeleteDaRecord
Ushort _far _cdecl DeleteDaRecord( Pvoid pDawa, Ulong qiRecord ) ;
#endif

#if defined DeleteDir || defined All
#undef DeleteDir
Ushort _far _cdecl DeleteDir( Pvoid pbDirSpec, Uint cbDirSpec, Pvoid pbPassword, Uint cbPassword ) ;
#endif

#if defined DeleteFile || defined All
#undef DeleteFile
Ushort _far _cdecl DeleteFile( Uint fh ) ;
#endif

#if defined DeviceInService || defined All
#undef DeviceInService
Ushort _far _cdecl DeviceInService( Pvoid pTyDevRet ) ;
#endif

#if defined DirtyCode || defined All
#undef DirtyCode
Ushort _far _cdecl DirtyCode( Pvoid pDirty ) ;
#endif

#if defined DisableActionFinish || defined All
#undef DisableActionFinish
Ushort _far _cdecl DisableActionFinish( Uchar fDisable ) ;
#endif

#if defined DisableCluster || defined All
#undef DisableCluster
Ushort _far _cdecl DisableCluster( Uchar fDisablePoll, Uint timeInterval ) ;
#endif

#if defined DiscardInputBsC || defined All
#undef DiscardInputBsC
Ushort _far _cdecl DiscardInputBsC( Pvoid pBs, Pvoid pCbRet ) ;
#endif

#if defined DiscardOutputBsC || defined All
#undef DiscardOutputBsC
Ushort _far _cdecl DiscardOutputBsC( Pvoid pBs ) ;
#endif

#if defined DismountVolume || defined All
#undef DismountVolume
Ushort _far _cdecl DismountVolume( Pvoid pbVolName, Uint cbVolName, Pvoid pbPassword, Uint cbPassword ) ;
#endif

#if defined DoDirectRead || defined All
#undef DoDirectRead
Ushort _far _cdecl DoDirectRead( Uint fh, Pvoid p0, Uint c0, Pvoid p1, Uint c1, Pvoid p2, Uint c2, Uint w0, Uint w1 ) ;
#endif

#if defined DoDirectWrite || defined All
#undef DoDirectWrite
Ushort _far _cdecl DoDirectWrite( Uint fh, Pvoid p0, Uint c0, Pvoid p1, Uint c1, Pvoid p2, Uint c2, Uint w0, Uint w1 ) ;
#endif

#if defined Doze || defined All
#undef Doze
Ushort _far _cdecl Doze( Uint wTime ) ;
#endif

#if defined Draw || defined All
#undef Draw
Ushort _far _cdecl Draw( Uint x1, Uint y1, Uint x2, Uint y2, Uchar fShorten, Pvoid pParam ) ;
#endif

#if defined EnableSwapperOptions || defined All
#undef EnableSwapperOptions
Ushort _far _cdecl EnableSwapperOptions( Pvoid pProc, Uchar fFixup ) ;
#endif

#if defined EnterBootRom || defined All
#undef EnterBootRom
Ushort _far _cdecl EnterBootRom( Uint rES, Uint rDX ) ;
#endif

#if defined ErrorExit || defined All
#undef ErrorExit
void _far _cdecl ErrorExit( Uint ercTermination ) ;
#endif

#if defined ErrorExitString || defined All
#undef ErrorExitString
void _far _cdecl ErrorExitString( Ushort erc, Pvoid pb, Uint cb ) ;
#endif

#if defined EstablishQueueServer || defined All
#undef EstablishQueueServer
Ushort _far _cdecl EstablishQueueServer( Pvoid pbQueueName, Uint cbQueueName, Uint queueType, Uchar fUniqueServer ) ;
#endif

#if defined ExitAndRemove || defined All
#undef ExitAndRemove
void _far _cdecl ExitAndRemove( void ) ;
#endif

#if defined ExitCTOS || defined All
#undef ExitCTOS
void _far _cdecl ExitCTOS( void ) ;
#endif

#if defined ExpandAreaLL || defined All
#undef ExpandAreaLL
Ushort _far _cdecl ExpandAreaLL( Uint cbArea, Uint sa, Pvoid pRaRet ) ;
#endif

#if defined ExpandAreaSL || defined All
#undef ExpandAreaSL
Ushort _far _cdecl ExpandAreaSL( Uint cbArea, Uint sa, Pvoid pRaRet ) ;
#endif

#if defined ExpandDateTime || defined All
#undef ExpandDateTime
Ushort _far _cdecl ExpandDateTime( Ulong dateTime, Pvoid pExpDateTimeRet ) ;
#endif

#if defined ExpandLocalMsg || defined All
#undef ExpandLocalMsg
Ushort _far _cdecl ExpandLocalMsg( Pvoid pRgSd, Uint sRgSd, Pvoid pbFrom, Uint cbFrom, Pvoid pTo, Uint sTo, Pvoid pCbRet, Uchar fBs ) ;
#endif

#if defined ExpandSpec || defined All
#undef ExpandSpec
Uint _far _cdecl ExpandSpec( Pvoid pbFileSpec, Uint cbFileSpec, Pvoid pbPassword, Uint cbPassword, Pvoid pSpecRet, Uint sSpecMax, Uint specType ) ;
#endif

#if defined FatalError || defined All
#undef FatalError
void _far _cdecl FatalError( Ushort erc ) ;
#endif

#if defined FComparePointer || defined All
#undef FComparePointer
Uchar _far _cdecl FComparePointer( Pvoid p1, Pvoid p2, Uchar bCompareMode ) ;
#endif

#if defined FieldEdit || defined All
#undef FieldEdit
Uchar _far _cdecl FieldEdit( Uint iFrame, Uint iCol, Uint iLine, Uchar bFieldType, Uint cbFieldLength, Pvoid pbText, Uint cbText, Uint sTextMax, Pvoid pcbRet, Pvoid pChRet ) ;
#endif

#if defined FillBufferAsyncC || defined All
#undef FillBufferAsyncC
Ushort _far _cdecl FillBufferAsyncC( Pvoid pBs, Uint cbMin, Uint cbMax, Pvoid pPbRet, Pvoid pCbRet, Uint idExch, Pvoid pMsg, Uint rqCode ) ;
#endif

#if defined FillBufferC || defined All
#undef FillBufferC
Ushort _far _cdecl FillBufferC( Pvoid pBs, Uint cbMax, Pvoid pPbRet, Pvoid pCbRet ) ;
#endif

#if defined FillBufferLP || defined All
#undef FillBufferLP
Ushort _far _cdecl FillBufferLP( Pvoid pBs, Uint cbMax, Pvoid pPbRet, Pvoid pCbRet ) ;
#endif

#if defined FillFrame || defined All
#undef FillFrame
Ushort _far _cdecl FillFrame( Uint iFr, Uint iCol, Uint iLine, Uint bFill, Uint cToFill ) ;
#endif

#if defined FillFrameRectangle || defined All
#undef FillFrameRectangle
Ushort _far _cdecl FillFrameRectangle( Uint iFrame, Uint iCol, Uint iLine, Uint cbCols, Uint cbLines, Uchar chars, Uchar attr ) ;
#endif

#if defined FilterDebugInterrupts || defined All
#undef FilterDebugInterrupts
Ushort _far _cdecl FilterDebugInterrupts( Uint sgTss, Uint exchNotify, Uchar fV86Only ) ;
#endif

#if defined FlushBufferAsyncC || defined All
#undef FlushBufferAsyncC
Ushort _far _cdecl FlushBufferAsyncC( Pvoid pBs, Pvoid pb, Uint cbMin, Uint cbMax, Pvoid pCbRet, Uint idExch, Pvoid pMsg, Uint rqCode ) ;
#endif

#if defined FlushBufferC || defined All
#undef FlushBufferC
Ushort _far _cdecl FlushBufferC( Pvoid pBs, Pvoid pb, Uint cb, Pvoid pCbRet ) ;
#endif

#if defined FlushBufferLP || defined All
#undef FlushBufferLP
Ushort _far _cdecl FlushBufferLP( Pvoid pBs, Pvoid pb, Uint cb, Pvoid pCbWrittenRet ) ;
#endif

#if defined Format || defined All
#undef Format
Ushort _far _cdecl Format( Uint fh, Pvoid pBuffer, Uint sBuffer, Ulong lfa, Pvoid psDataRet ) ;
#endif

#if defined FormatDateTime || defined All
#undef FormatDateTime
Ushort _far _cdecl FormatDateTime( Ulong dateTime, Pvoid psbTemplate, Pvoid psbRet ) ;
#endif

#if defined FormatTime || defined All
#undef FormatTime
Ushort _far _cdecl FormatTime( Pvoid psbRet, Pvoid pExpDateTime ) ;
#endif

#if defined FormatTimeDt || defined All
#undef FormatTimeDt
Ushort _far _cdecl FormatTimeDt( Pvoid psbRet, Pvoid pExpDateTime ) ;
#endif

#if defined FormatTimeTm || defined All
#undef FormatTimeTm
Ushort _far _cdecl FormatTimeTm( Pvoid psbRet, Pvoid pExpDateTime ) ;
#endif

#if defined FormEdit || defined All
#undef FormEdit
Ushort _far _cdecl FormEdit( Pvoid pNlsTableArea, Uint iFrame, Uint iCol, Uint iLine, Uint nFields, Pvoid pbPrompt, Uint cbPrompt, Pvoid prgpFieldDescs, Uint sMaxFields, Uint maxCaptionLen, Pvoid pChRet ) ;
#endif

#if defined ForwardRequest || defined All
#undef ForwardRequest
Ushort _far _cdecl ForwardRequest( Uint iExch, Pvoid pRq ) ;
#endif

#if defined FProcessorSupportsProtectedMode || defined All
#undef FProcessorSupportsProtectedMode
Uchar _far _cdecl FProcessorSupportsProtectedMode( void ) ;
#endif

#if defined FProtectedMode || defined All
#undef FProtectedMode
Uchar _far _cdecl FProtectedMode( void ) ;
#endif

#if defined FrameBackspace || defined All
#undef FrameBackspace
Ushort _far _cdecl FrameBackspace( Uint iFrame, Pvoid pFrame, Pvoid piCol, Pvoid piLine ) ;
#endif

#if defined FreeLargeLL || defined All
#undef FreeLargeLL
Uchar _far _cdecl FreeLargeLL( void ) ;
#endif

#if defined FRmos || defined All
#undef FRmos
Uchar _far _cdecl FRmos( void ) ;
#endif

#if defined FSCableDrop || defined All
#undef FSCableDrop
Ushort _far _cdecl FSCableDrop( void ) ;
#endif

#if defined FsCanon || defined All
#undef FsCanon
void _far _cdecl FsCanon( Pvoid pb, Uint cb ) ;
#endif

#if defined FSrpUp || defined All
#undef FSrpUp
Uchar _far _cdecl FSrpUp( void ) ;
#endif

#if defined FValidPbCb || defined All
#undef FValidPbCb
Ushort _far _cdecl FValidPbCb( Pvoid pb, Uint cb ) ;
#endif

#if defined GenResString || defined All
#undef GenResString
Ushort _far _cdecl GenResString( Pvoid pStringRet, Uint cStringMax, Pvoid psStringRet ) ;
#endif

#if defined GetAltMsg || defined All
#undef GetAltMsg
Ushort _far _cdecl GetAltMsg( Pvoid pMwa, Uint sMwa, Uint iMsg, Pvoid pRgSd, Uint sRgSd, Pvoid pBuffer, Uint sBuffer, Pvoid pcbRet ) ;
#endif

#if defined GetAltMsgUnexpanded || defined All
#undef GetAltMsgUnexpanded
Ushort _far _cdecl GetAltMsgUnexpanded( Pvoid pMwa, Uint sMwa, Uint iMsg,  Pvoid pBuffer, Uint sBuffer, Pvoid pcbRet ) ;
#endif

#if defined GetAltMsgUnexpandedLength || defined All
#undef GetAltMsgUnexpandedLength
Ushort _far _cdecl GetAltMsgUnexpandedLength( Pvoid pMwa, Uint sMwa, Uint iMsg, Pvoid pcbRet ) ;
#endif

#if defined GetBoardInfo || defined All
#undef GetBoardInfo
Ushort _far _cdecl GetBoardInfo( Uint wSlot, Uint wCase, Pvoid pbInfoRet, Uint cbInfoMax ) ;
#endif

#if defined GetBsLfa || defined All
#undef GetBsLfa
Ushort _far _cdecl GetBsLfa( Pvoid pBSWA, Pvoid pLfaRet ) ;
#endif

#if defined GetCanonicalNodeAndVol || defined All
#undef GetCanonicalNodeAndVol
Ushort _far _cdecl GetCanonicalNodeAndVol( Pvoid pbNode, Uint cbNode, Pvoid pbCanonNode, Pvoid pcbCanonNode, Pvoid pbVol, Uint cbVol, Pvoid pbCanonVol, Pvoid pcbCanonVol ) ;
#endif

#if defined GetClusterId || defined All
#undef GetClusterId
Ushort _far _cdecl GetClusterId( Pvoid pRq, Pvoid pbRet ) ;
#endif

#if defined GetClusterStatus || defined All
#undef GetClusterStatus
Ushort _far _cdecl GetClusterStatus( Uint iLine, Pvoid pBufferRet, Uint sBufferMax ) ;
#endif

#if defined GetCommLineDmaStatus || defined All
#undef GetCommLineDmaStatus
Ushort _far _cdecl GetCommLineDmaStatus( Uint commLineHandle, Pvoid pStatus, Uint cbStatus ) ;
#endif

#if defined GetContiguousBm || defined All
#undef GetContiguousBm
Ushort _far _cdecl GetContiguousBm( Pvoid ppBm, Pvoid psBm ) ;
#endif

#if defined GetCoprocessorStatus || defined All
#undef GetCoprocessorStatus
Ushort _far _cdecl GetCoprocessorStatus( Pvoid pStatusRet ) ;
#endif

#if defined GetCParasOvlyZone || defined All
#undef GetCParasOvlyZone
Uint _far _cdecl GetCParasOvlyZone( void ) ;
#endif

#if defined GetDaiNumber || defined All
#undef GetDaiNumber
Ushort _far _cdecl GetDaiNumber( Pvoid pRq, Pvoid pbDAIret ) ;
#endif

#if defined GetDateTime || defined All
#undef GetDateTime
Ushort _far _cdecl GetDateTime( Pvoid pDateTimeRet ) ;
#endif

#if defined GetDirInfo || defined All
#undef GetDirInfo
Ushort _far _cdecl GetDirInfo( Pvoid pbDirectorySpec, Uint cbDirectorySpec, Pvoid pbDirectoryPW, Uint cbDirectoryPW, Pvoid pDirectoryEntryRet, Uint sDirectoryEntryMax ) ;
#endif

#if defined GetDirStatus || defined All
#undef GetDirStatus
Ushort _far _cdecl GetDirStatus( Pvoid pbDirname, Uint cbDirName, Pvoid pbPassword, Uint cbPassword, Uint statusCode, Pvoid pStatusRet, Uint sStatusMax ) ;
#endif

#if defined GetErc || defined All
#undef GetErc
Ushort _far _cdecl GetErc( Ushort erc, Pvoid pBuffer, Uint sBuffer, Pvoid pcbRet ) ;
#endif

#if defined GetErcLength || defined All
#undef GetErcLength
Ushort _far _cdecl GetErcLength( Ushort erc,  Pvoid pcbRet ) ;
#endif

#if defined GetFhLongevity || defined All
#undef GetFhLongevity
Ushort _far _cdecl GetFhLongevity( Uint fh, Pvoid pCodeRet ) ;
#endif

#if defined GetFileErc || defined All
#undef GetFileErc
Ushort _far _cdecl GetFileErc( Ushort erc, Pvoid pbFileName, Uint cbFileName, Pvoid pBuffer, Uint sBuffer, Pvoid pcbRet ) ;
#endif

#if defined GetFileStatus || defined All
#undef GetFileStatus
Ushort _far _cdecl GetFileStatus( Uint fh, Uint statusCode, Pvoid pStatusRet, Uint sStatusMax ) ;
#endif

#if defined GetFRmosUser || defined All
#undef GetFRmosUser
Ushort _far _cdecl GetFRmosUser( Uint userNum, Pvoid pUcharRet ) ;
#endif

#if defined GetHandleStatus || defined All
#undef GetHandleStatus
Ushort _far _cdecl GetHandleStatus( Pvoid pRoute, Uint sRoute, Uint fh, Pvoid pStatusRet, Uint sStatusRet ) ;
#endif

#if defined GetIBusDevInfo || defined All
#undef GetIBusDevInfo
Ushort _far _cdecl GetIBusDevInfo( Pvoid pInfo, Uint sInfo ) ;
#endif

#if defined GetKbdId || defined All
#undef GetKbdId
Ushort _far _cdecl GetKbdId( Pvoid pIdRet ) ;
#endif

#if defined GetLocalDaiNumber || defined All
#undef GetLocalDaiNumber
Ushort _far _cdecl GetLocalDaiNumber( Pvoid pDaiRet ) ;
#endif

#if defined GetMemoryInfo || defined All
#undef GetMemoryInfo
Ushort _far _cdecl GetMemoryInfo( Pvoid pInfoRet, Uint sInfoRet, Pvoid pcbRet ) ;
#endif

#if defined GetModuleID || defined All
#undef GetModuleID
Ushort _far _cdecl GetModuleID( Uint iBus, Uint nPos, Pvoid pModuleIDRet ) ;
#endif

#if defined GetMsg || defined All
#undef GetMsg
Uint _far _cdecl GetMsg( Uint iMsg, Pvoid pRgSd, Uint sRgSd, Pvoid pBufRet, Uint sBuf, Pvoid pcbRet ) ;
#endif

#if defined GetMsgUnexpanded || defined All
#undef GetMsgUnexpanded
Uint _far _cdecl GetMsgUnexpanded( Uint iMsg, Pvoid pBufRet, Uint sBuf, Pvoid pcbRet ) ;
#endif

#if defined GetMsgUnexpandedLength || defined All
#undef GetMsgUnexpandedLength
Uint _far _cdecl GetMsgUnexpandedLength( Uint iMsg, Pvoid pcbRet ) ;
#endif

#if defined GetNlsDateName || defined All
#undef GetNlsDateName
Ushort _far _cdecl GetNlsDateName( Pvoid pNlsTableArea, Uint iDateNameTable, Uint iDateName, Pvoid pbRet, Uint cbMax, Pvoid pcbRet ) ;
#endif

#if defined GetNlsKeycapText || defined All
#undef GetNlsKeycapText
Uint _far _cdecl GetNlsKeycapText( Pvoid pNlsTables, Uint iKeycap, Pvoid psbKeycapText ) ;
#endif

#if defined GetNlsTable || defined All
#undef GetNlsTable
Uint _far _cdecl GetNlsTable( Uint wTableID, Pvoid pMem, Uint sMem, Pvoid pbFileName, Uint cbFileName, Pvoid pbPassword, Uint cbPassword ) ;
#endif

#if defined GetOvlyStats || defined All
#undef GetOvlyStats
Ushort _far _cdecl GetOvlyStats( Pvoid pOvlyStatBlock, Uint sOvlyStatBlock ) ;
#endif

#if defined GetPartitionExchange || defined All
#undef GetPartitionExchange
Ushort _far _cdecl GetPartitionExchange( Uint ph, Pvoid pExchRet ) ;
#endif

#if defined GetPartitionHandle || defined All
#undef GetPartitionHandle
Ushort _far _cdecl GetPartitionHandle( Pvoid pbPartitionName, Uint cbPartitionName, Pvoid pPhRet ) ;
#endif

#if defined GetPartitionStatus || defined All
#undef GetPartitionStatus
Ushort _far _cdecl GetPartitionStatus( Uint ph, Uint statusCode, Pvoid pStatusRet, Uint sStatusMax ) ;
#endif

#if defined GetPartitionSwapMode || defined All
#undef GetPartitionSwapMode
Ushort _far _cdecl GetPartitionSwapMode( Uint userNumPartition, Pvoid pSwapModeRet ) ;
#endif

#if defined GetPAscb || defined All
#undef GetPAscb
Ushort _far _cdecl GetPAscb( Pvoid ppASCBRet ) ;
#endif

#if defined GetPNlsTable || defined All
#undef GetPNlsTable
Uint _far _cdecl GetPNlsTable( Pvoid pTable, Uint iTable, Pvoid ppRet ) ;
#endif

#if defined GetProcInfo || defined All
#undef GetProcInfo
Uint _far _cdecl GetProcInfo( Pvoid pMySlotRet, Pvoid pTypeRet, Pvoid pNumberRet, Pvoid pbNameRet, Uint cbNameMax, Pvoid pbNameLenRet ) ;
#endif

#if defined GetPSCounters || defined All
#undef GetPSCounters
Ushort _far _cdecl GetPSCounters( Uint sh, Pvoid pbBlockID, Uint cbBlockID, Pvoid pbCountRet, Uint cbCountRet ) ;
#endif

#if defined GetPStructure || defined All
#undef GetPStructure
Ushort _far _cdecl GetPStructure( Uint structCode, Uint ph, Pvoid ppStructRet ) ;
#endif

#if defined GetQMStatus || defined All
#undef GetQMStatus
Ushort _far _cdecl GetQMStatus( Uint wQueueType, Uchar fHealthCheck, Pvoid pStatusRet, Uint sStatusMax ) ;
#endif

#if defined GetRouteTable || defined All
#undef GetRouteTable
Ushort _far _cdecl GetRouteTable( Uint wCase, Pvoid pbTableRet, Uint cbTableMax ) ;
#endif

#if defined GetRsLfa || defined All
#undef GetRsLfa
Ushort _far _cdecl GetRsLfa( Pvoid pRswa, Pvoid pLfa ) ;
#endif

#if defined GetScsiInfo || defined All
#undef GetScsiInfo
Ushort _far _cdecl GetScsiInfo( Uint wModule, Uint wBus, Uint wFmt, Pvoid pBufInfo, Uint sBufInfo, Pvoid pCbRet ) ;
#endif

#if defined GetSegmentLength || defined All
#undef GetSegmentLength
Ushort _far _cdecl GetSegmentLength( Pvoid pSegment, Pvoid pcbRet ) ;
#endif

#if defined GetSerialNumber || defined All
#undef GetSerialNumber
Ushort _far _cdecl GetSerialNumber( Uint iProcessor, Pvoid pIdRet ) ;
#endif

#if defined GetSerialNumberOldOs || defined All
#undef GetSerialNumberOldOs
Ushort _far _cdecl GetSerialNumberOldOs( Uint iProcessor, Pvoid pIdRet ) ;
#endif

#if defined GetServerMsg || defined All
#undef GetServerMsg
Ushort _far _cdecl GetServerMsg( Uint iMsg, Pvoid pSdRet ) ;
#endif

#if defined GetSlotInfo || defined All
#undef GetSlotInfo
Uint _far _cdecl GetSlotInfo( Uchar bCode, Pvoid pbSlotArrayRet, Uint cbSlotArrayRet, Pvoid psProcessorCount ) ;
#endif

#if defined GetStamFileHeader || defined All
#undef GetStamFileHeader
Ushort _far _cdecl GetStamFileHeader( Pvoid pbFilespec, Uint cbFilespec, Pvoid pbPassword, Uint cbPassword, Pvoid pFileHeaderRet ) ;
#endif

#if defined GetStandardErcMsg || defined All
#undef GetStandardErcMsg
Ushort _far _cdecl GetStandardErcMsg( Ushort ercParam, Pvoid pErcBuf, Uint cbErcBuf, Pvoid pCbRet, Uint iMsgDefault ) ;
#endif

#if defined GetSysCmdInfo || defined All
#undef GetSysCmdInfo
Ushort _far _cdecl GetSysCmdInfo( Pvoid pbCommand, Uint cbCommand, Pvoid pbFileNameRet, Pvoid pcbFileNameRet, Pvoid pbCmdNameRet, Pvoid pcbCmdNameRet, Pvoid pbCaseRet, Pvoid pwNumParamsRet, Pvoid ppCmdRecRet ) ;
#endif

#if defined GetUcb || defined All
#undef GetUcb
Ushort _far _cdecl GetUcb( Pvoid pUcbRet, Uint sUcbMax ) ;
#endif

#if defined GetUserFileEntry || defined All
#undef GetUserFileEntry
Ushort _far _cdecl GetUserFileEntry( Pvoid pNlsTableArea, Pvoid pBuffer, Uint sBuffer, Pvoid pbFieldName, Uint cbFieldName, Pvoid pbValue, Uint sValueMax, Pvoid pcbValueRet ) ;
#endif

#if defined GetUserLocation || defined All
#undef GetUserLocation
Ushort _far _cdecl GetUserLocation( Uint userNum, Pvoid pbInfoRet, Uint cbInfoMax ) ;
#endif

#if defined GetUserNumber || defined All
#undef GetUserNumber
Ushort _far _cdecl GetUserNumber( Pvoid pUserNumberRet ) ;
#endif

#if defined GetUserStatus || defined All
#undef GetUserStatus
Ushort _far _cdecl GetUserStatus( Uint statusUserNum, Pvoid pStatusRet, Uint sStatusMax ) ;
#endif

#if defined GetVerifyCode || defined All
#undef GetVerifyCode
Ushort _far _cdecl GetVerifyCode( Pvoid pbDevSpec, Uint cbDevSpec, Pvoid pVerifyCodeRet ) ;
#endif

#if defined GetVhb || defined All
#undef GetVhb
Ushort _far _cdecl GetVhb( Pvoid pbDevSpec, Uint cbDevSpec, Pvoid pVhbRet, Uint sVhbMax ) ;
#endif

#if defined GetVideoInfo || defined All
#undef GetVideoInfo
Ushort _far _cdecl GetVideoInfo( Pvoid pInfoRet ) ;
#endif

#if defined GetWSUserName || defined All
#undef GetWSUserName
Ushort _far _cdecl GetWSUserName( Uint WSNum, Pvoid pWSUserNameRet, Uint sWSUserNameRetMax ) ;
#endif

#if defined HandleCursorIrpt || defined All
#undef HandleCursorIrpt
Ushort _far _cdecl HandleCursorIrpt( Pvoid pCuWa, Uint xPos, Uint yPos, Uchar fOn ) ;
#endif

#if defined HeapAlloc || defined All
#undef HeapAlloc
Ushort _far _cdecl HeapAlloc( Uint cBytes, Pvoid poMemoryRet ) ;
#endif

#if defined HeapFree || defined All
#undef HeapFree
Ushort _far _cdecl HeapFree( Pvoid pMemory ) ;
#endif

#if defined HeapInit || defined All
#undef HeapInit
Ushort _far _cdecl HeapInit( Uint cBytes, Pvoid pHeap ) ;
#endif

#if defined InitAltMsgFile || defined All
#undef InitAltMsgFile
Ushort _far _cdecl InitAltMsgFile( Pvoid pMwa, Uint sMwa, Pvoid pbMsgFile, Uint cbMsgFile, Pvoid pbPassword, Uint cbPassword, Pvoid pBuffer, Uint sBuffer, Pvoid pbCache, Uint cbCache ) ;
#endif

#if defined InitCharMap || defined All
#undef InitCharMap
Ushort _far _cdecl InitCharMap( Pvoid pMap, Uint sMap ) ;
#endif

#if defined InitCommLine || defined All
#undef InitCommLine
Ushort _far _cdecl InitCommLine( Pvoid pbSpec, Uint cbSpec, Pvoid pbClcb, Uint cbClcb, Pvoid pbRet, Uint cbRet ) ;
#endif

#if defined InitErcFile || defined All
#undef InitErcFile
Ushort _far _cdecl InitErcFile( Pvoid pBuffer, Uint sBuffer, Pvoid pbCache, Uint cbCache ) ;
#endif

#if defined InitLargeOverlays || defined All
#undef InitLargeOverlays
Ushort _far _cdecl InitLargeOverlays( Pvoid pOvlys, Uint cParasOvlyZone ) ;
#endif

#if defined InitLocalPageMap || defined All
#undef InitLocalPageMap
Ushort _far _cdecl InitLocalPageMap( Pvoid pLocalPageMap ) ;
#endif

#if defined InitMsgFile || defined All
#undef InitMsgFile
Uint _far _cdecl InitMsgFile( Pvoid pbMsgFile, Uint cbMsgFile, Pvoid pbPswd, Uint cbPswd, Pvoid pbBuffer, Uint cbBuffer, Pvoid pbCache, Uint cbCache ) ;
#endif

#if defined InitOverlays || defined All
#undef InitOverlays
Ushort _far _cdecl InitOverlays( Pvoid pOvlys, Uint sOvlyZone ) ;
#endif

#if defined InitSysCmds || defined All
#undef InitSysCmds
Ushort _far _cdecl InitSysCmds( Pvoid pbCmdFile, Uint cbCmdFile ) ;
#endif

#if defined InitVidFrame || defined All
#undef InitVidFrame
Ushort _far _cdecl InitVidFrame( Uchar iFrame, Uchar iColStart, Uchar iLineStart, Uchar nCols, Uchar nLines, Uchar borderDesc, Uchar bBorderChar, Uchar bBorderAttr, Uchar fDblHigh, Uchar fDblWide ) ;
#endif

#if defined InstallNet || defined All
#undef InstallNet
Ushort _far _cdecl InstallNet( Uint iCase, Pvoid pData, Uint sData ) ;
#endif

#if defined KillProcess || defined All
#undef KillProcess
Ushort _far _cdecl KillProcess( Uint pid ) ;
#endif

#if defined LinkFile || defined All
#undef LinkFile
Ushort _far _cdecl LinkFile( Uint fh, Pvoid pbFileName, Uint cbFileName, Pvoid pbPassword, Uint cbPassword ) ;
#endif

#if defined LoadBackgroundPalette || defined All
#undef LoadBackgroundPalette
Ushort _far _cdecl LoadBackgroundPalette( Pvoid pAttrs, Uint sAttrs ) ;
#endif

#if defined LoadColorStyleRam || defined All
#undef LoadColorStyleRam
Ushort _far _cdecl LoadColorStyleRam( Pvoid pAttrs ) ;
#endif

#if defined LoadFile || defined All
#undef LoadFile
Ushort _far _cdecl LoadFile( Uint fh, Uint priority, Uchar fSuspend, Uint userNumLoad, Pvoid pwFlags, Uint cbFlags ) ;
#endif

#if defined LoadFontRam || defined All
#undef LoadFontRam
Ushort _far _cdecl LoadFontRam( Uint fh, Pvoid pBuffer, Uint sBuffer ) ;
#endif

#if defined LoadInteractiveTask || defined All
#undef LoadInteractiveTask
Ushort _far _cdecl LoadInteractiveTask( Uint ph, Pvoid pbFileSpec, Uint cbFileSpec, Pvoid pbPassword, Uint cbPassword, Uint priority, Uchar fDebug ) ;
#endif

#if defined LoadKbdXlat || defined All
#undef LoadKbdXlat
Ushort _far _cdecl LoadKbdXlat( Uint id ) ;
#endif

#if defined LoadKbdXlatFh || defined All
#undef LoadKbdXlatFh
Ushort _far _cdecl LoadKbdXlatFh( Uint fh ) ;
#endif

#if defined LoadPrimaryTask || defined All
#undef LoadPrimaryTask
Ushort _far _cdecl LoadPrimaryTask( Uint ph, Pvoid pbFileSpec, Uint cbFileSpec, Pvoid pbPassword, Uint cbPassword, Uint priority ) ;
#endif

#if defined LoadRunFile || defined All
#undef LoadRunFile
Ushort _far _cdecl LoadRunFile( Uint fh, Uint priority, Uchar fSuspend, Pvoid pIdRet, Pvoid pPdbRet, Uint sPdbMax ) ;
#endif

#if defined LoadTask || defined All
#undef LoadTask
Ushort _far _cdecl LoadTask( Uint fh, Uint priority, Uchar fDebug ) ;
#endif

#if defined LockFile || defined All
#undef LockFile
Ushort _far _cdecl LockFile( Pvoid pFhret, Pvoid pbFilespec, Uint cbFilespec, Pvoid pbPasswd, Uint cbPasswd, Uint mode, Uint timeoutValue ) ;
#endif

#if defined LockIn || defined All
#undef LockIn
Uchar _far _cdecl LockIn( Uint wPort ) ;
#endif

#if defined LockInCache || defined All
#undef LockInCache
Uchar _far _cdecl LockInCache( Uint fh, Ulong lfa, Uint cb, Pvoid pcbLockedRet ) ;
#endif

#if defined LockInContext || defined All
#undef LockInContext
Uchar _far _cdecl LockInContext( Uint userNum ) ;
#endif

#if defined LockOut || defined All
#undef LockOut
void _far _cdecl LockOut( Uint wPort, Uchar bVal ) ;
#endif

#if defined LockRasterRegion || defined All
#undef LockRasterRegion
Ushort _far _cdecl LockRasterRegion( Uint xLow, Uint yLow, Uint xHigh, Uint yHigh ) ;
#endif

#if defined LockVideo || defined All
#undef LockVideo
void _far _cdecl LockVideo( void ) ;
#endif

#if defined LockVideoForModify || defined All
#undef LockVideoForModify
void _far _cdecl LockVideoForModify( void ) ;
#endif

#if defined LockXbis || defined All
#undef LockXbis
Ushort _far _cdecl LockXbis( Pvoid ppXbisRet ) ;
#endif

#if defined LogMsgIn || defined All
#undef LogMsgIn
Ushort _far _cdecl LogMsgIn( void ) ;
#endif

#if defined LogRespond || defined All
#undef LogRespond
Ushort _far _cdecl LogRespond( Pvoid pRqBlock ) ;
#endif

#if defined LogRequest || defined All
#undef LogRequest
Ushort _far _cdecl LogRequest( void ) ;
#endif

#if defined LookupField || defined All
#undef LookupField
Ushort _far _cdecl LookupField( Uint fh, Pvoid pBuffer, Uint sBuffer, Pvoid pbFieldName, Uint cbFieldNameMax, Pvoid pcbFieldName, Pvoid pbValue, Uint cbValueMax, Pvoid pcbValueRet, Uchar fAllowWhiteSpace ) ;
#endif

#if defined LookUpNumber || defined All
#undef LookUpNumber
Ushort _far _cdecl LookUpNumber( Uint fh, Pvoid pBuffer, Uint sBuffer, Pvoid pbFieldName, Uint cbFieldName, Pvoid pwRet ) ;
#endif

#if defined LookupReset || defined All
#undef LookupReset
Ushort _far _cdecl LookupReset( void ) ;
#endif

#if defined LookUpString || defined All
#undef LookUpString
Ushort _far _cdecl LookUpString( Uint fh, Pvoid pBuffer, Uint sBuffer, Pvoid pbFieldName, Uint cbFieldName, Pvoid prgRet, Uint iMax, Pvoid pcbRet ) ;
#endif

#if defined MakeDirectory || defined All
#undef MakeDirectory
Ushort _far _cdecl MakeDirectory( Pvoid pbFileSpec, Uint cbFileSpec, Pvoid pbPassword, Uint cbPassword, Pvoid pbDirPassword, Uint cbDirPassword, Uint cSectors, Uint defaultFileProtectionLevel ) ;
#endif

#if defined MakePermanent || defined All
#undef MakePermanent
Ushort _far _cdecl MakePermanent( void ) ;
#endif

#if defined MakePermanentP || defined All
#undef MakePermanentP
Ushort _far _cdecl MakePermanentP( Pvoid pProcInfo ) ;
#endif

#if defined MakeRecentlyUsed || defined All
#undef MakeRecentlyUsed
void _far _cdecl MakeRecentlyUsed( void ) ;
#endif

#if defined MapBusAddress || defined All
#undef MapBusAddress
Ushort _far _cdecl MapBusAddress( Pvoid pb, Uint cb, Uint wDmaBoundaryType, Pvoid pBusAddressRet, Pvoid pCbRet ) ;
#endif

#if defined MapCsIOvly || defined All
#undef MapCsIOvly
Ushort _far _cdecl MapCsIOvly( Uint cs, Pvoid piOvly ) ;
#endif

#if defined MapIOvlyCs || defined All
#undef MapIOvlyCs
Ushort _far _cdecl MapIOvlyCs( Uint IOv, Pvoid pCsRet ) ;
#endif

#if defined MapPStubPProc || defined All
#undef MapPStubPProc
Ushort _far _cdecl MapPStubPProc( Pvoid pStub, Pvoid pPProcRet ) ;
#endif

#if defined MapSgUserNum || defined All
#undef MapSgUserNum
Ushort _far _cdecl MapSgUserNum( Uint sn, Uchar fSwappedOnly, Pvoid pUserNumRet ) ;
#endif

#if defined MapXBusWindow || defined All
#undef MapXBusWindow
Ushort _far _cdecl MapXBusWindow( Uint bType, Uint bModule, Pvoid ppWindowRet, Uint sWindow, Pvoid pEarRet, Uint oWindowPort ) ;
#endif

#if defined MapXBusWindowLarge || defined All
#undef MapXBusWindowLarge
Ushort _far _cdecl MapXBusWindowLarge( Uint bType, Uint bMod, Pvoid prgpWindow, Uint srgpWindowRet, Pvoid pipWindowRetMac, Uint sWin, Pvoid pEar, Uint oWin ) ;
#endif

#if defined MarkKeyedQueueEntry || defined All
#undef MarkKeyedQueueEntry
Ushort _far _cdecl MarkKeyedQueueEntry( Pvoid pbQueueName, Uint cbQueueName, Pvoid pbKey1, Uint cbKey1, Uint oKey1, Pvoid pbKey2, Uint cbKey2, Uint oKey2, Pvoid pEntryRet, Uint sEntryRet, Pvoid pStatusBlock, Uint sStatusBlock ) ;
#endif

#if defined MarkNextQueueEntry || defined All
#undef MarkNextQueueEntry
Ushort _far _cdecl MarkNextQueueEntry( Pvoid pbQueueName, Uint cbQueueName, Uchar fReturnIfNoEntries, Pvoid pEntryRet, Uint sEntryRet, Pvoid pStatusBlock, Uint sStatusBlock ) ;
#endif

#if defined MediateIntHandler || defined All
#undef MediateIntHandler
Ushort _far _cdecl MediateIntHandler( Uchar fDeviceInt ) ;
#endif

#if defined MenuEdit || defined All
#undef MenuEdit
Ushort _far _cdecl MenuEdit( Pvoid pNlsTableArea, Uint iFrame, Uint iCol, Uint iLine, Pvoid pbPrompt, Uint cbPrompt, Pvoid pFieldDesc, Pvoid pChRet ) ;
#endif

#if defined Mode3DmaReload || defined All
#undef Mode3DmaReload
Ushort _far _cdecl Mode3DmaReload( void ) ;
#endif

#if defined MountVolume || defined All
#undef MountVolume
Ushort _far _cdecl MountVolume( Pvoid pbDevSpec, Uint cbDevSpec, Pvoid pbDevPassword, Uint cbDevPassword ) ;
#endif

#if defined MouseVersion || defined All
#undef MouseVersion
Ushort _far _cdecl MouseVersion( Pvoid pVerStruct, Uint sVerStruct, Pvoid pcbRet ) ;
#endif

#if defined MovBMoverSegment || defined All
#undef MovBMoverSegment
Ushort _far _cdecl MovBMoverSegment( Ulong maFrom, Ulong maTo, Uint cb ) ;
#endif

#if defined MoveFrameRectangle || defined All
#undef MoveFrameRectangle
Ushort _far _cdecl MoveFrameRectangle( Uint iSrcFrame, Uint iDstframe, Uint iSrcCol, Uint iSrcLine, Uint iDstCol, Uint iDstLine, Uint cCols, Uint cLines, Uchar fBlankSrc ) ;
#endif

#if defined MoveOverlays || defined All
#undef MoveOverlays
Ushort _far _cdecl MoveOverlays( Pvoid pNewOvly ) ;
#endif

#if defined NewProcess || defined All
#undef NewProcess
Ushort _far _cdecl NewProcess( Pvoid pProcessStruct, Uint userNum, Pvoid pPidRet ) ;
#endif

#if defined NlsCase || defined All
#undef NlsCase
Ushort _far _cdecl NlsCase( Pvoid pNlsTables, Uchar bCharIn, Pvoid pbCharOut, Uchar fUpper ) ;
#endif

#if defined NlsClass || defined All
#undef NlsClass
Ushort _far _cdecl NlsClass( Pvoid pNlsTables, Uchar bCharIn, Pvoid pbClassRet ) ;
#endif

#if defined NlsCollate || defined All
#undef NlsCollate
Ushort _far _cdecl NlsCollate( Pvoid pNlsTables, Pvoid pbString1, Uint cbString1, Pvoid pbString2, Uint cbString2, Pvoid pbColResRet, Pvoid pbPrioResRet ) ;
#endif

#if defined NlsFormatDateTime || defined All
#undef NlsFormatDateTime
Ushort _far _cdecl NlsFormatDateTime( Pvoid pNlsTableArea, Ulong DateTime, Pvoid pbTemplate, Uint cbTemplate, Pvoid prgDate, Uint cbMax, Pvoid pcbRet ) ;
#endif

#if defined NlsGetYesNoStrings || defined All
#undef NlsGetYesNoStrings
Ushort _far _cdecl NlsGetYesNoStrings( Pvoid pNlsTableArea, Pvoid prgSdStringsRet ) ;
#endif

#if defined NlsGetYesNoStringSize || defined All
#undef NlsGetYesNoStringSize
Ushort _far _cdecl NlsGetYesNoStringSize( Pvoid pNlsTables, Pvoid prgcbStringsRet ) ;
#endif

#if defined NlsNumberandCurrency || defined All
#undef NlsNumberandCurrency
Ushort _far _cdecl NlsNumberandCurrency( Pvoid pNlsTableArea, Pvoid ppTableRet ) ;
#endif

#if defined NlsParseTime || defined All
#undef NlsParseTime
Ushort _far _cdecl NlsParseTime( Pvoid pNlsTableArea, Pvoid psbString, Pvoid pExpDateTimeStruct ) ;
#endif

#if defined NlsSpecialCharacters || defined All
#undef NlsSpecialCharacters
Ushort _far _cdecl NlsSpecialCharacters( Pvoid pNlsTables, Uchar fOEMCharacters, Pvoid ppSpecialCharacters ) ;
#endif

#if defined NlsStdFormatDateTime || defined All
#undef NlsStdFormatDateTime
Ushort _far _cdecl NlsStdFormatDateTime( Pvoid pNlsTableArea, Uint iTemplate, Ulong DateTime, Pvoid prgRet, Uint cbMax, Pvoid pcbRet ) ;
#endif

#if defined NlsULCmpB || defined All
#undef NlsULCmpB
Ushort _far _cdecl NlsULCmpB( Pvoid pNlsTables, Pvoid pbString1, Pvoid pbString2, Uint cbStrings, Pvoid piNonCmpChrRet ) ;
#endif

#if defined NlsVerifySignatures || defined All
#undef NlsVerifySignatures
Ushort _far _cdecl NlsVerifySignatures( Pvoid pNlsTables, Uint cTables, Pvoid prgwTableIds, Pvoid prgwSignatures ) ;
#endif

#if defined NlsYesNoOrBlank || defined All
#undef NlsYesNoOrBlank
Ushort _far _cdecl NlsYesNoOrBlank( Pvoid pNlsTableArea, Pvoid pSdParam, Pvoid pbCase ) ;
#endif

#if defined NlsYesOrNo || defined All
#undef NlsYesOrNo
Ushort _far _cdecl NlsYesOrNo( Pvoid pNlsTables, Pvoid pSdParam, Pvoid pfYN ) ;
#endif

#if defined NotifyVidMemLineUser || defined All
#undef NotifyVidMemLineUser
Ushort _far _cdecl NotifyVidMemLineUser( Uint userNum ) ;
#endif

#if defined NPrint || defined All
#undef NPrint
void _far _cdecl NPrint( Pvoid pb, Uint cb ) ;
#endif

#if defined OldReadHardId || defined All
#undef OldReadHardId
Ushort _far _cdecl OldReadHardId( Pvoid pId ) ;
#endif

#if defined OldWriteHardId || defined All
#undef OldWriteHardId
Ushort _far _cdecl OldWriteHardId( Uint wId ) ;
#endif

#if defined OpenByteStream || defined All
#undef OpenByteStream
Ushort _far _cdecl OpenByteStream( Pvoid pBsRet, Pvoid pbFilename, Uint cbFilename, Pvoid pbPassword, Uint cbPassword, Uint mode, Pvoid pBufferArea, Uint sBufferArea ) ;
#endif

#if defined OpenByteStreamC || defined All
#undef OpenByteStreamC
Ushort _far _cdecl OpenByteStreamC( Pvoid pBs, Pvoid pbFileSpec, Uint cbFileSpec, Pvoid pbPassword, Uint cbPassword, Uint mode, Pvoid pBufferArea, Uint sBufferArea ) ;
#endif

#if defined OpenByteStreamLP || defined All
#undef OpenByteStreamLP
Ushort _far _cdecl OpenByteStreamLP( Pvoid pBs, Pvoid pbFilespec, Uint cbFilespec, Pvoid pbPassword, Uint cbPassword, Uint mode, Pvoid pBufferArea, Uint sBufferArea ) ;
#endif

#if defined OpenDaFile || defined All
#undef OpenDaFile
Ushort _far _cdecl OpenDaFile( Pvoid pDawaRet, Pvoid pbFilespec, Uint cbFilespec, Pvoid pbPassword, Uint cbPassword, Uint mode, Pvoid pBuffer, Uint sBuffer, Uint sRecord ) ;
#endif

#if defined OpenFile || defined All
#undef OpenFile
Ushort _far _cdecl OpenFile( Pvoid pFhRet, Pvoid pbFileSpec, Uint cbFileSpec, Pvoid pbPassword, Uint cbPassword, Uint mode ) ;
#endif

#if defined OpenFileLL || defined All
#undef OpenFileLL
Ushort _far _cdecl OpenFileLL( Pvoid pFhRet, Pvoid pbFileSpec, Uint cbFileSpec, Pvoid pbPassword, Uint cbPassword, Uint mode ) ;
#endif

#if defined OpenNlsFile || defined All
#undef OpenNlsFile
Ushort _far _cdecl OpenNlsFile( Pvoid pbFileName, Uint cbFileName, Pvoid pbPassword, Uint cbPassword, Pvoid ppNlsTableRet ) ;
#endif

#if defined OpenPSLogSession || defined All
#undef OpenPSLogSession
Ushort _far _cdecl OpenPSLogSession( Pvoid pbDevName, Uint cbDevName, Uint wBlockID, Uint wIterations, Uint wLogHeapSize, Pvoid pbShRet ) ;
#endif

#if defined OpenPSStatSession || defined All
#undef OpenPSStatSession
Ushort _far _cdecl OpenPSStatSession( Pvoid pbDevName, Uint cbDevName, Pvoid pbBlockID, Uint cbBlockID, Pvoid pbShRet, Uint cbShRet ) ;
#endif

#if defined OpenRsFile || defined All
#undef OpenRsFile
Ushort _far _cdecl OpenRsFile( Pvoid pRswaRet, Pvoid pbFilespec, Uint cbFilespec, Pvoid pbPassword, Uint cbPassword, Uint mode, Pvoid pBuffer, Uint sBuffer ) ;
#endif

#if defined OpenRTClock || defined All
#undef OpenRTClock
Ushort _far _cdecl OpenRTClock( Pvoid pRqTime ) ;
#endif

#if defined OpenServerMsgFile || defined All
#undef OpenServerMsgFile
Ushort _far _cdecl OpenServerMsgFile( Pvoid pbFileName, Uint cbFileName, Pvoid pbPassword, Uint cbPassword, Uchar fLLMemory ) ;
#endif

#if defined OpenTape || defined All
#undef OpenTape
Uint _far _cdecl OpenTape( Pvoid pbTapeName, Uint cbTapeName, Uchar fStreaming, Uchar fHighDensity, Uchar fClear, Uint Mode, Pvoid pThRet ) ;
#endif

#if defined OpenUserFile || defined All
#undef OpenUserFile
Uint _far _cdecl OpenUserFile( Pvoid pNlsTableArea, Pvoid pFhRet, Pvoid pBuffer, Uint sBuffer, Uint mode ) ;
#endif

#if defined OpenVidFilter || defined All
#undef OpenVidFilter
Uint _far _cdecl OpenVidFilter( void ) ;
#endif

#if defined OsVersion || defined All
#undef OsVersion
Ushort _far _cdecl OsVersion( Pvoid pVersionRet ) ;
#endif

#if defined OutputBytesWithWrap || defined All
#undef OutputBytesWithWrap
Ushort _far _cdecl OutputBytesWithWrap( Pvoid pbString, Uint cbString ) ;
#endif

#if defined OutputQuad || defined All
#undef OutputQuad
void _far _cdecl OutputQuad( Ulong q, Uint base, Uint field, Uchar bPad ) ;
#endif

#if defined OutputToVid0 || defined All
#undef OutputToVid0
Ushort _far _cdecl OutputToVid0( Pvoid pbString, Uint cbString ) ;
#endif

#if defined OutputWord || defined All
#undef OutputWord
void _far _cdecl OutputWord( Uint w, Uint base, Uint field, Uchar bPad  ) ;
#endif

#if defined PaFromP || defined All
#undef PaFromP
Ushort _far _cdecl PaFromP( Pvoid p, Uint userNum, Pvoid pPaRet ) ;
#endif

#if defined PaFromSn || defined All
#undef PaFromSn
Ushort _far _cdecl PaFromSn( Uint sn, Uint userNum, Pvoid pPaRet ) ;
#endif

#if defined ParseFileSpec || defined All
#undef ParseFileSpec
Uint _far _cdecl ParseFileSpec( Ushort userNum, Pvoid pbInputSpec, Ushort cbInputSpec, Uchar fDefaultPath, Pvoid pbNode, Pvoid pcbNode, Pvoid pbVol, Pvoid pcbVol, Pvoid pbDir, Pvoid pcbDir, Pvoid pbFile, Pvoid pcbFile, Pvoid pbPassword, Pvoid pcbPassword, Uchar fCanonical, Uchar bSpecType ) ;
#endif

#if defined ParseSpecForDir || defined All
#undef ParseSpecForDir
Uint _far _cdecl ParseSpecForDir( Pvoid pbInputSpec, Ushort cbInputSpec, Pvoid pbDefaultDir, Ushort cbDefaultDir, Pvoid pbDir, Pvoid pcbDir, Uchar bSpecType ) ;
#endif

#if defined ParseSpecForFile || defined All
#undef ParseSpecForFile
Uint _far _cdecl ParseSpecForFile(Pvoid pbInputSpec, Ushort cbInputSpec, Pvoid pbDefaultFile, Ushort cbDefaultFile, Pvoid pbFile, Pvoid pcbFile, Uchar bSpecType ) ;
#endif

#if defined ParseSpecForNode || defined All
#undef ParseSpecForNode
Uint _far _cdecl ParseSpecForNode( Pvoid pbInputSpec, Ushort cbInputSpec, Pvoid pbDefaultNode, Ushort cbDefaultNode, Pvoid pbNode, Pvoid pcbNode, Uchar bSpecType ) ;
#endif

#if defined ParseSpecForPassword || defined All
#undef ParseSpecForPassword
Uint _far _cdecl ParseSpecForPassword( Pvoid pbInputSpec, Ushort cbInputSpec, Pvoid pbDefaultPassword, Ushort cbDefaultPassword, Pvoid pbPassword, Pvoid pcbPassword, Uchar bSpecType ) ;
#endif

#if defined ParseSpecForVol || defined All
#undef ParseSpecForVol
Uint _far _cdecl ParseSpecForVol(Pvoid pbInputSpec, Ushort cbInputSpec, Pvoid pbDefaultVol, Ushort cbDefaultVol, Pvoid pbVol, Pvoid pcbVol, Uchar bSpecType ) ;
#endif

#if defined ParseTime || defined All
#undef ParseTime
Ushort _far _cdecl ParseTime( Pvoid psbString, Pvoid pExpDateTimeStruct ) ;
#endif

#if defined PDAssignMouse || defined All
#undef PDAssignMouse
Ushort _far _cdecl PDAssignMouse( Uint wUserNumber ) ;
#endif

#if defined PDGetCursorPos || defined All
#undef PDGetCursorPos
Ushort _far _cdecl PDGetCursorPos( Pvoid pwXPos, Pvoid pwYPos ) ;
#endif

#if defined PDGetCursorPosNSC || defined All
#undef PDGetCursorPosNSC
Ushort _far _cdecl PDGetCursorPosNSC( Pvoid pwXPos, Pvoid pwYPos ) ;
#endif

#if defined PDInitialize || defined All
#undef PDInitialize
Ushort _far _cdecl PDInitialize( void ) ;
#endif

#if defined PDLoadCursor || defined All
#undef PDLoadCursor
Ushort _far _cdecl PDLoadCursor( Pvoid pCursorShape, Uint sCursorShape, Uint bType) ;
#endif

#if defined PDLoadSystemCursor || defined All
#undef PDLoadSystemCursor
Ushort _far _cdecl PDLoadSystemCursor( Pvoid pCursorShape, Uint sCursorShape, Uint bType) ;
#endif

#if defined PDQueryControls || defined All
#undef PDQueryControls
Ushort _far _cdecl PDQueryControls( Pvoid pStruct, Uint sStruct ) ;
#endif

#if defined PDQuerySystemControls || defined All
#undef PDQuerySystemControls
Ushort _far _cdecl PDQuerySystemControls( Pvoid pStruct, Uint sStruct ) ;
#endif

#if defined PDReadCurrentCursor || defined All
#undef PDReadCurrentCursor
Ushort _far _cdecl PDReadCurrentCursor( Pvoid pCursorShape, Uint sCursorShape, Uint pbType ) ;
#endif

#if defined PDReadIconFile || defined All
#undef PDReadIconFile
Ushort _far _cdecl PDReadIconFile( Uint fh, Pvoid pIcon, Uint sIcon, Pvoid pWorkArea, Uint sWorkArea, Pvoid pcbRet ) ;
#endif

#if defined PDSetCharMapVirtualCoordinates || defined All
#undef PDSetCharMapVirtualCoordinates
Ushort _far _cdecl PDSetCharMapVirtualCoordinates( Uint wXMin, Uint wYMin, Uint wXMax, Uint wYMax ) ;
#endif

#if defined PDSetControls || defined All
#undef PDSetControls
Ushort _far _cdecl PDSetControls( Pvoid pStruct, Uint sStruct ) ;
#endif

#if defined PDSetCursorDisplay || defined All
#undef PDSetCursorDisplay
Ushort _far _cdecl PDSetCursorDisplay( Uchar fOn ) ;
#endif

#if defined PDSetCursorPos || defined All
#undef PDSetCursorPos
Ushort _far _cdecl PDSetCursorPos( Uint wXPos, Uint wYPos ) ;
#endif

#if defined PDSetCursorPosNSC || defined All
#undef PDSetCursorPosNSC
Ushort _far _cdecl PDSetCursorPosNSC( Uint wXPos, Uint wYPos ) ;
#endif

#if defined PDSetCursorType || defined All
#undef PDSetCursorType
Ushort _far _cdecl PDSetCursorType( Uchar bType ) ;
#endif

#if defined PDSetMotionRectangle || defined All
#undef PDSetMotionRectangle
Ushort _far _cdecl PDSetMotionRectangle( Uint wXMin, Uint wYMin, Uint wDX, Uint wDY ) ;
#endif

#if defined PDSetMotionRectangleNSC || defined All
#undef PDSetMotionRectangleNSC
Ushort _far _cdecl PDSetMotionRectangleNSC( Uint wXMin, Uint wYMin, Uint wDX, Uint wDY ) ;
#endif

#if defined PDSetSystemControls || defined All
#undef PDSetSystemControls
Ushort _far _cdecl PDSetSystemControls( Pvoid pStruct, Uint sStruct ) ;
#endif

#if defined PDSetTracking || defined All
#undef PDSetTracking
Ushort _far _cdecl PDSetTracking( Uchar fTracking ) ;
#endif

#if defined PDSetVirtualCoordinates || defined All
#undef PDSetVirtualCoordinates
Ushort _far _cdecl PDSetVirtualCoordinates( Uint wXMin, Uint wYMin, Uint wXMax, Uint wYMax ) ;
#endif

#if defined PDSetWindow || defined All
#undef PDSetWindow
Ushort _far _cdecl PDSetWindow( Uint wNormMinX, Uint wNormMinY, Uint wNormMaxX, Uint wNormMaxY, Uint userNum, Uint wWinId ) ;
#endif

#if defined PDTranslateNSCToVC || defined All
#undef PDTranslateNSCToVC
Ushort _far _cdecl PDTranslateNSCToVC( Uint wNSCX, Uint wNSCY, Pvoid pwVCX, Pvoid pwVCY ) ;
#endif

#if defined PDTranslateVCToNSC || defined All
#undef PDTranslateVCToNSC
Ushort _far _cdecl PDTranslateVCToNSC( Uint wVCX, Uint wVCY, Pvoid pwNSCX, Pvoid pwNSCY ) ;
#endif

#if defined PosCursor || defined All
#undef PosCursor
Ushort _far _cdecl PosCursor( Pvoid pCuWa, Uint xPos, Uint yPos ) ;
#endif

#if defined PosFrameCursor || defined All
#undef PosFrameCursor
Ushort _far _cdecl PosFrameCursor( Uint iFrame, Uint iCol, Uint iLine ) ;
#endif

#if defined PrintAltMsg || defined All
#undef PrintAltMsg
Uint _far _cdecl PrintAltMsg( Pvoid pMwa, Uint sMwa, Uint iMsg, Pvoid pRgSd, Uint sRgSd, Pvoid pBswa ) ;
#endif

#if defined PrintErc || defined All
#undef PrintErc
Uint _far _cdecl PrintErc( Ushort erc, Pvoid pBSWA ) ;
#endif

#if defined PrintFileClose || defined All
#undef PrintFileClose
Uint _far _cdecl PrintFileClose( void ) ;
#endif

#if defined PrintFileOpen || defined All
#undef PrintFileOpen
Uint _far _cdecl PrintFileOpen( Pvoid pSdFileName ) ;
#endif

#if defined PrintFileStatus || defined All
#undef PrintFileStatus
Uint _far _cdecl PrintFileStatus( Uchar bCode, Uint Status ) ;
#endif

#if defined PrintMsg || defined All
#undef PrintMsg
Uint _far _cdecl PrintMsg( Uint iMsg, Pvoid pRgSd, Uint sRgSd, Pvoid pBswa ) ;
#endif

#if defined ProgramColorMapper || defined All
#undef ProgramColorMapper
Ushort _far _cdecl ProgramColorMapper( Pvoid pNewPalette, Uint sNewPalette, Pvoid pNewControlInfo, Uint sNewControlInfo, Pvoid pOldPalette, Uint sOldPalette, Pvoid pOldControlInfo, Uint sOldControlInfo ) ;
#endif

#if defined PSCloseSession || defined All
#undef PSCloseSession
Ushort _far _cdecl PSCloseSession( Uint sh ) ;
#endif

#if defined PSDeinstServer || defined All
#undef PSDeinstServer
Ushort _far _cdecl PSDeinstServer( Pvoid pPSUserNumRet ) ;
#endif

#if defined PSend || defined All
#undef PSend
Ushort _far _cdecl PSend( Uint exchange, Pvoid pMsg ) ;
#endif

#if defined PSGetCounters || defined All
#undef PSGetCounters
Ushort _far _cdecl PSGetCounters( Uint sh, Pvoid pbBlockId, Uint cbBlockId, Pvoid pbCountRet, Uint cbCountRet ) ;
#endif

#if defined PSOpenLogSession || defined All
#undef PSOpenLogSession
Ushort _far _cdecl PSOpenLogSession( Pvoid pbDevName, Uint cbDevName, Uint wBlockID, Uint wIterations, Uint wLogHeapSize, Pvoid pbShRet ) ;
#endif

#if defined PSOpenStatSession || defined All
#undef PSOpenStatSession
Ushort _far _cdecl PSOpenStatSession( Pvoid pbDevName, Uint cbDevName, Pvoid pbBlockDesc, Uint cbBlockDesc, Pvoid pbShRet ) ;
#endif

#if defined PSReadLog || defined All
#undef PSReadLog
Ushort _far _cdecl PSReadLog( Uint sh, Pvoid pbLogData, Uint cbLogData, Pvoid pbDataCntRet ) ;
#endif

#if defined PSResetCounters || defined All
#undef PSResetCounters
Ushort _far _cdecl PSResetCounters( Uint sh, Pvoid pbBlockId, Uint cbBlockId ) ;
#endif

#if defined PurgeMcr || defined All
#undef PurgeMcr
Ushort _far _cdecl PurgeMcr( void ) ;
#endif

#if defined PutBackByte || defined All
#undef PutBackByte
Ushort _far _cdecl PutBackByte( Pvoid pBswa, Uchar b ) ;
#endif

#if defined PutByte || defined All
#undef PutByte
void _far _cdecl PutByte( Uchar b, Uint base ) ;
#endif

#if defined PutChar || defined All
#undef PutChar
void _far _cdecl PutChar( Uchar c ) ;
#endif

#if defined PutCharsAndAttrs || defined All
#undef PutCharsAndAttrs
Ushort _far _cdecl PutCharsAndAttrs( Uint iFrame, Uint iCol, Uint iLine, Pvoid pbText, Uint cbText, Pvoid pbAttrs, Uint cbAttrs ) ;
#endif

#if defined PutFrameAttrs || defined All
#undef PutFrameAttrs
Ushort _far _cdecl PutFrameAttrs( Uint iFrame, Uint iCol, Uint iLine, Uint attr, Uint nPos ) ;
#endif

#if defined PutFrameChars || defined All
#undef PutFrameChars
Ushort _far _cdecl PutFrameChars( Uint iFrame, Uint iCol, Uint iLine, Pvoid pbText, Uint cbText ) ;
#endif

#if defined PutFrameCharsAndAttrs || defined All
#undef PutFrameCharsAndAttrs
Ushort _far _cdecl PutFrameCharsAndAttrs( Uint iFrame, Uint iCol, Uint iLine, Pvoid pbText, Uint cbText, Pvoid pbAttrs, Uint cbAttrs ) ;
#endif

#if defined PutPointer || defined All
#undef PutPointer
void _far _cdecl PutPointer( Pvoid pValue, Uint radix ) ;
#endif

#if defined PutQuad || defined All
#undef PutQuad
void _far _cdecl PutQuad( Ulong q, Uint radix ) ;
#endif

#if defined PutWord || defined All
#undef PutWord
void _far _cdecl PutWord( Uint wValue, Uint radix ) ;
#endif

#if defined QueryBigMemAvail || defined All
#undef QueryBigMemAvail
Ushort _far _cdecl QueryBigMemAvail( Pvoid pqMemAvailRet ) ;
#endif

#if defined QueryBoardInfo || defined All
#undef QueryBoardInfo
Ushort _far _cdecl QueryBoardInfo( Uint wSlot, Uint wCase, Pvoid pbInfoRet, Uint cbInfoMax ) ;
#endif

#if defined QueryBounds || defined All
#undef QueryBounds
Ushort _far _cdecl QueryBounds( Uint iFrame, Pvoid pcCols, Pvoid pcLines ) ;
#endif

#if defined QueryCharsAndAttrs || defined All
#undef QueryCharsAndAttrs
Ushort _far _cdecl QueryCharsAndAttrs( Uint iFrame, Uint iCol, Uint iLine, Pvoid pbText, Uint cbText, Pvoid pbAttrs, Uint cbAttrs ) ;
#endif

#if defined QueryCoprocessor || defined All
#undef QueryCoprocessor
Ushort _far _cdecl QueryCoprocessor( Pvoid pbStatusRet ) ;
#endif

#if defined QueryCursor || defined All
#undef QueryCursor
Ushort _far _cdecl QueryCursor( Uint iFrame, Pvoid piCol, Pvoid piLine ) ;
#endif

#if defined QueryCursorPosition || defined All
#undef QueryCursorPosition
Ushort _far _cdecl QueryCursorPosition( Pvoid pCuWa, Pvoid pxPosRet, Pvoid pyPosRet ) ;
#endif

#if defined QueryDaLastRecord || defined All
#undef QueryDaLastRecord
Ushort _far _cdecl QueryDaLastRecord( Pvoid pDawa, Pvoid pqiRecordRet ) ;
#endif

#if defined QueryDaRecordStatus || defined All
#undef QueryDaRecordStatus
Ushort _far _cdecl QueryDaRecordStatus( Pvoid pDawa, Ulong qiRecord, Pvoid pStatusRet ) ;
#endif

#if defined QueryDcb || defined All
#undef QueryDcb
Ushort _far _cdecl QueryDcb( Pvoid pbDevSpec, Uint cbDevSpec, Pvoid pDcbRet, Uint sDcbMax ) ;
#endif

#if defined QueryDefaultRespExch || defined All
#undef QueryDefaultRespExch
Ushort _far _cdecl QueryDefaultRespExch( Pvoid pExchRet ) ;
#endif

#if defined QueryDeviceName || defined All
#undef QueryDeviceName
Ushort _far _cdecl QueryDeviceName( Pvoid pRoute, Uint sRoute, Uint iDev, Pvoid pBuf, Uint sBuf, Pvoid pcbRet ) ;
#endif

#if defined QueryDeviceNames || defined All
#undef QueryDeviceNames
Ushort _far _cdecl QueryDeviceNames( Pvoid pRoute, Uint sRoute, Pvoid pBuf, Uint sBuf, Pvoid pcbRet ) ;
#endif

#if defined QueryDiskGeometry || defined All
#undef QueryDiskGeometry
Ushort _far _cdecl QueryDiskGeometry( Pvoid pbDevName, Uint cbDevName, Pvoid pbPassword, Uint cbPassword, Pvoid pDiskGeometryRet, Uint sDiskGeometryRet ) ;
#endif

#if defined QueryExitRunFile || defined All
#undef QueryExitRunFile
Ushort _far _cdecl QueryExitRunFile( Pvoid pbExitRunFileRet, Uint cbExitRunFileRet, Pvoid pbPasswordRet, Uint cbPasswordRet, Pvoid pbPriorityRet ) ;
#endif

#if defined QueryFrameAttrs || defined All
#undef QueryFrameAttrs
Ushort _far _cdecl QueryFrameAttrs( Uint iFrame, Uint iCol, Uint iLine, Uint sBuff, Pvoid pRetBuf, Pvoid pcbRet ) ;
#endif

#if defined QueryFrameBounds || defined All
#undef QueryFrameBounds
Ushort _far _cdecl QueryFrameBounds( Uint iFrame, Pvoid pcCols, Pvoid pcLines ) ;
#endif

#if defined QueryFrameChar || defined All
#undef QueryFrameChar
Ushort _far _cdecl QueryFrameChar( Uint iFrame, Uint iCol, Uint iLine, Pvoid pbRet ) ;
#endif

#if defined QueryFrameCharsAndAttrs || defined All
#undef QueryFrameCharsAndAttrs
Ushort _far _cdecl QueryFrameCharsAndAttrs( Uint iFrame, Uint iCol, Uint iLine, Pvoid pbText, Uint cbText, Pvoid pbAttrs, Uint cbAttrs ) ;
#endif

#if defined QueryFrameCursor || defined All
#undef QueryFrameCursor
Ushort _far _cdecl QueryFrameCursor( Uint iFrame, Pvoid piCol, Pvoid piLine ) ;
#endif

#if defined QueryFrameString || defined All
#undef QueryFrameString
Ushort _far _cdecl QueryFrameString( Uint iFrame, Uint iCol, Uint iLine, Uint sBuff, Pvoid pRetBuf, Pvoid pcbRet ) ;
#endif

#if defined QueryKbdLEDs || defined All
#undef QueryKbdLEDs
Ushort _far _cdecl QueryKbdLEDs( Pvoid pLEDsRet ) ;
#endif

#if defined QueryKbdState || defined All
#undef QueryKbdState
Ushort _far _cdecl QueryKbdState( Pvoid pKbdDescRet ) ;
#endif

#if defined QueryLdtR || defined All
#undef QueryLdtR
Ushort _far _cdecl QueryLdtR( Uint userNum, Pvoid pLdtrRet ) ;
#endif

#if defined QueryLoadAddress || defined All
#undef QueryLoadAddress
Ushort _far _cdecl QueryLoadAddress( Uint userNum, Pvoid pSaRet ) ;
#endif

#if defined QueryMail || defined All
#undef QueryMail
Uint _far _cdecl QueryMail( Pvoid pNMsgsRet, Pvoid pIPrecedenceRet ) ;
#endif

#if defined QueryMemAvail || defined All
#undef QueryMemAvail
Ushort _far _cdecl QueryMemAvail( Pvoid pcParagraphRet ) ;
#endif

#if defined QueryModule || defined All
#undef QueryModule
Ushort _far _cdecl QueryModule( Uint userNum, Pvoid pFBigRet ) ;
#endif

#if defined QueryModulePosition || defined All
#undef QueryModulePosition
Ushort _far _cdecl QueryModulePosition( Pvoid pPosRet, Uint bus, Uint typeCode, Uint iModule ) ;
#endif

#if defined QueryNodeName || defined All
#undef QueryNodeName
Ushort _far _cdecl QueryNodeName( Pvoid psbRet, Uint cSbRet ) ;
#endif

#if defined QueryProcessNumber || defined All
#undef QueryProcessNumber
Ushort _far _cdecl QueryProcessNumber( Pvoid pProcessNumberRet ) ;
#endif

#if defined QueryRequestInfo || defined All
#undef QueryRequestInfo
Ushort _far _cdecl QueryRequestInfo( Uint rq, Pvoid pStatusRet, Uint sStatusRetMax ) ;
#endif

#if defined QueryUserLocation || defined All
#undef QueryUserLocation
Ushort _far _cdecl QueryUserLocation( Uint userNum, Pvoid pbInfoRet, Uint cbInfoMax ) ;
#endif

#if defined QueryVidBs || defined All
#undef QueryVidBs
Ushort _far _cdecl QueryVidBs( Pvoid pBSWA, Pvoid pBsVidStateRet ) ;
#endif

#if defined QueryVideo || defined All
#undef QueryVideo
Ushort _far _cdecl QueryVideo( Pvoid pVideoInfo, Uint sVideoInfo ) ;
#endif

#if defined QueryVidHdw || defined All
#undef QueryVidHdw
Ushort _far _cdecl QueryVidHdw( Pvoid pBuffer, Uint sBuffer ) ;
#endif

#if defined QueryWSNum || defined All
#undef QueryWSNum
Ushort _far _cdecl QueryWSNum( Pvoid pWSNumRet ) ;
#endif

#if defined QueryZoomBoxPosition || defined All
#undef QueryZoomBoxPosition
Ushort _far _cdecl QueryZoomBoxPosition( Pvoid piColRet, Pvoid piLineRet ) ;
#endif

#if defined QueueMgrVersion || defined All
#undef QueueMgrVersion
Ushort _far _cdecl QueueMgrVersion( Pvoid pVerStruct, Uint sVerStruct, Pvoid pcbRet ) ;
#endif

#if defined RasterOp || defined All
#undef RasterOp
Ushort _far _cdecl RasterOp( Pvoid pSrc, Uint xSrcStart, Uint ySrcStart, Pvoid pDest, Uint xDestStart, Uint yDestStart, Pvoid pPat, Uint xSize, Uint ySize, Uint wPlanes, Uchar bMode, Pvoid pMem ) ;
#endif

#if defined RasterOpText || defined All
#undef RasterOpText
Ushort _far _cdecl RasterOpText( Pvoid pMem, Uint cwSrcLine, Pvoid pBitmap, Uint x, Uint y, Uint wWidth, Uint wHeight, Uchar bMode, Uchar bPlane, Uint wColor ) ;
#endif

#if defined ReadFile || defined All
#undef ReadFile
Ushort _far _cdecl ReadFile( Uint fh, Pvoid pBufferRet, Uint sBufferMax, Ulong lfa, Pvoid psDataRet ) ;
#endif

#if defined ReadActionCode || defined All
#undef ReadActionCode
Ushort _far _cdecl ReadActionCode( Pvoid pCodeRet ) ;
#endif

#if defined ReadActionKbd || defined All
#undef ReadActionKbd
Ushort _far _cdecl ReadActionKbd( Uchar fGlobal, Pvoid pActionCharRet ) ;
#endif

#if defined ReadAsync || defined All
#undef ReadAsync
Ushort _far _cdecl ReadAsync( Ushort fh, Pvoid pBuffer, Uint sBuffer, Ulong lfa, Pvoid pRq, Uint exchangeReply ) ;
#endif

#if defined ReadBsRecord || defined All
#undef ReadBsRecord
Ushort _far _cdecl ReadBsRecord( Pvoid pBs, Pvoid pb, Uint cb, Pvoid pCbReadRet ) ;
#endif

#if defined ReadByte || defined All
#undef ReadByte
Ushort _far _cdecl ReadByte( Pvoid pBs, Pvoid pbRet ) ;
#endif

#if defined ReadBytes || defined All
#undef ReadBytes
Ushort _far _cdecl ReadBytes( Pvoid pBs, Uint cbMax, Pvoid pPbRet, Pvoid pCbRet ) ;
#endif

#if defined ReadByteStreamParameterC || defined All
#undef ReadByteStreamParameterC
Ushort _far _cdecl ReadByteStreamParameterC( Pvoid pBs, Uint wParamNum, Pvoid pwParamRet ) ;
#endif

#if defined ReadCommLineStatus || defined All
#undef ReadCommLineStatus
Ushort _far _cdecl ReadCommLineStatus( Uint commLineHandle, Uint wStatusMask, Pvoid pwStatus ) ;
#endif

#if defined ReadDaFragment || defined All
#undef ReadDaFragment
Ushort _far _cdecl ReadDaFragment( Pvoid pDawa, Ulong qiRecord, Pvoid pRecordRet, Uint rbFragment, Uint cbFragment ) ;
#endif

#if defined ReadDaRecord || defined All
#undef ReadDaRecord
Ushort _far _cdecl ReadDaRecord( Pvoid pDawa, Ulong qiRecord, Pvoid pRecordRet ) ;
#endif

#if defined ReadDirSector || defined All
#undef ReadDirSector
Ushort _far _cdecl ReadDirSector( Pvoid pbDirSpec, Uint cbDirSpec, Pvoid pbPassword, Uint cbPassword, Uint iSector, Pvoid pBufferRet ) ;
#endif

#if defined ReadHardId || defined All
#undef ReadHardId
Ushort _far _cdecl ReadHardId( Pvoid pId ) ;
#endif

#if defined ReadInputEvent || defined All
#undef ReadInputEvent
Ushort _far _cdecl ReadInputEvent( Uint wMode, Pvoid pEventBlock, Uint sEventBlock ) ;
#endif

#if defined ReadInputEventNSC || defined All
#undef ReadInputEventNSC
Ushort _far _cdecl ReadInputEventNSC( Uint wMode, Pvoid pEventBlock, Uint sEventBlock ) ;
#endif

#if defined ReadKbd || defined All
#undef ReadKbd
Ushort _far _cdecl ReadKbd( Pvoid pCharRet ) ;
#endif

#if defined ReadKbdDataDirect || defined All
#undef ReadKbdDataDirect
Ushort _far _cdecl ReadKbdDataDirect( Uint mode, Pvoid pDataRet ) ;
#endif

#if defined ReadKbdDirect || defined All
#undef ReadKbdDirect
Ushort _far _cdecl ReadKbdDirect( Uint mode, Pvoid pCharRet ) ;
#endif

#if defined ReadKbdSemiCoded || defined All
#undef ReadKbdSemiCoded
Ushort _far _cdecl ReadKbdSemiCoded( Pvoid prgbKbdData ) ;
#endif

#if defined ReadKbdStatus || defined All
#undef ReadKbdStatus
Ushort _far _cdecl ReadKbdStatus( Uint wSequence, Pvoid pUserNumRet, Pvoid pStatusRet ) ;
#endif

#if defined ReadKeyedQueueEntry || defined All
#undef ReadKeyedQueueEntry
Ushort _far _cdecl ReadKeyedQueueEntry( Pvoid pbQueueName, Uint cbQueueName, Pvoid pbKey1, Uint cbKey1, Uint oKey1, Pvoid pbKey2, Uint cbKey2, Uint oKey2, Pvoid pEntryRet, Uint sEntryRet, Pvoid pStatusBlock, Uint sStatusBlock ) ;
#endif

#if defined ReadKeySwitch || defined All
#undef ReadKeySwitch
Ushort _far _cdecl ReadKeySwitch( void ) ;
#endif

#if defined ReadMcr || defined All
#undef ReadMcr
Ushort _far _cdecl ReadMcr( Uint mode, Pvoid pBufferRet, Uint sBufferMax, Pvoid pcbRet ) ;
#endif

#if defined ReadNextQueueEntry || defined All
#undef ReadNextQueueEntry
Ushort _far _cdecl ReadNextQueueEntry( Pvoid pbQueueName, Uint cbQueueName, Ulong qeh, Pvoid pEntryRet, Uint sEntryRet, Pvoid pStatusBlock, Uint sStatusBlock ) ;
#endif

#if defined ReadPSLog || defined All
#undef ReadPSLog
Ushort _far _cdecl ReadPSLog( Uint sh, Pvoid pbLogData, Uint cbLogData, Pvoid psDataRet ) ;
#endif

#if defined ReadRsRecord || defined All
#undef ReadRsRecord
Ushort _far _cdecl ReadRsRecord( Pvoid pRswa, Pvoid pRecordRet, Uint sRecordMax, Pvoid pcbRet ) ;
#endif

#if defined ReadStatusC || defined All
#undef ReadStatusC
Ushort _far _cdecl ReadStatusC( Pvoid pBs, Uint wStatusMask, Pvoid pwStatusRet ) ;
#endif

#if defined ReadSwap || defined All
#undef ReadSwap
Ushort _far _cdecl ReadSwap( Uint userNum, Pvoid p, Pvoid pbBuffer, Uint cbBuffer, Pvoid pORet, Pvoid pcbRet ) ;
#endif

#if defined ReadTapeRecords || defined All
#undef ReadTapeRecords
Uint _far _cdecl ReadTapeRecords( Uint th, Uint nRecords, Pvoid pb, Uint cb, Pvoid pNRecordsRet, Pvoid pcbRet ) ;
#endif

#if defined ReadToNextField || defined All
#undef ReadToNextField
Ushort _far _cdecl ReadToNextField( Uint fh, Pvoid pBuffer, Uint sBuffer, Pvoid pLines, Uint cLinesMax, Uint wLineSize, Pvoid pcLines ) ;
#endif

#if defined ReceiveCommLineDma || defined All
#undef ReceiveCommLineDma
Ushort _far _cdecl ReceiveCommLineDma( Uint commLineHandle, Pvoid pbRecvBuffer, Uint cbRecvBuffer, Pvoid pcbRet ) ;
#endif

#if defined ReinitLargeOverlays || defined All
#undef ReinitLargeOverlays
Ushort _far _cdecl ReinitLargeOverlays( Uint cParasOvlyZone ) ;
#endif

#if defined ReinitOverlays || defined All
#undef ReinitOverlays
Ushort _far _cdecl ReinitOverlays( Uint sOvlyZone ) ;
#endif

#if defined ReinitStubs || defined All
#undef ReinitStubs
Ushort _far _cdecl ReinitStubs( Pvoid pStaticsDescTarget ) ;
#endif

#if defined ReleaseByteStream || defined All
#undef ReleaseByteStream
Ushort _far _cdecl ReleaseByteStream( Pvoid pBs ) ;
#endif

#if defined ReleaseByteStreamC || defined All
#undef ReleaseByteStreamC
Ushort _far _cdecl ReleaseByteStreamC( Pvoid pBs ) ;
#endif

#if defined ReleaseByteStreamLP || defined All
#undef ReleaseByteStreamLP
Ushort _far _cdecl ReleaseByteStreamLP( Pvoid pBswa ) ;
#endif

#if defined ReleasePermanence || defined All
#undef ReleasePermanence
Ushort _far _cdecl ReleasePermanence( void ) ;
#endif

#if defined ReleaseRsFile || defined All
#undef ReleaseRsFile
Ushort _far _cdecl ReleaseRsFile( Pvoid pRswa ) ;
#endif

#if defined RemakeAliasForServer || defined All
#undef RemakeAliasForServer
Ushort _far _cdecl RemakeAliasForServer( Uint sg, Uint userNum, Pvoid pSgRet ) ;
#endif

#if defined RemapBusAddress || defined All
#undef RemapBusAddress
Ushort _far _cdecl RemapBusAddress( Ulong busAddress, Pvoid pb, Uint cb, Uint wDmaBoundaryType, Pvoid pBusAddressRet, Pvoid pCbRet ) ;
#endif

#if defined RemoveCursor || defined All
#undef RemoveCursor
Ushort _far _cdecl RemoveCursor( Pvoid pCuWa ) ;
#endif

#if defined RemoveDirectory || defined All
#undef RemoveDirectory
Ushort _far _cdecl RemoveDirectory( Uint fh ) ;
#endif

#if defined RemoveFfsBrackets || defined All
#undef RemoveFfsBrackets
Ushort _far _cdecl RemoveFfsBrackets( Pvoid pbLevel, Uint cbLevel, Pvoid ppbToken, Pvoid pcbToken, Uint lFfsLeftBracket, Uint lFfsRightBracket ) ;
#endif

#if defined RemoveKeyedQueueEntry || defined All
#undef RemoveKeyedQueueEntry
Ushort _far _cdecl RemoveKeyedQueueEntry( Pvoid pbQueueName, Uint cbQueueName, Pvoid pbKey1, Uint cbKey1, Uint oKey1, Pvoid pbKey2, Uint cbKey2, Uint oKey2 ) ;
#endif

#if defined RemoveMarkedQueueEntry || defined All
#undef RemoveMarkedQueueEntry
Ushort _far _cdecl RemoveMarkedQueueEntry( Pvoid pbQueueName, Uint cbQueueName, Ulong qeh ) ;
#endif

#if defined RemovePartition || defined All
#undef RemovePartition
Ushort _far _cdecl RemovePartition( Uint ph ) ;
#endif

#if defined RemoveQueue || defined All
#undef RemoveQueue
Ushort _far _cdecl RemoveQueue( Uint qh ) ;
#endif

#if defined RenameByteStream || defined All
#undef RenameByteStream
Ushort _far _cdecl RenameByteStream( Pvoid pBswa, Pvoid pbNewFileSpec, Uint cbNewFileSpec, Pvoid pbPassword, Uint cbPassword ) ;
#endif

#if defined RenameFile || defined All
#undef RenameFile
Ushort _far _cdecl RenameFile( Uint fh, Pvoid pbNewFileSpec, Uint cbNewFileSpec, Pvoid pbPassword, Uint cbPassword ) ;
#endif

#if defined ReopenFile || defined All
#undef ReopenFile
Ushort _far _cdecl ReopenFile( Pvoid pFhRet, Pvoid pbFileSpec, Uint cbFileSpec, Pvoid pbPassword, Uint cbPassword, Uint mode ) ;
#endif

#if defined Request || defined All
#undef Request
Ushort _far _cdecl Request( Pvoid pRq ) ;
#endif

#if defined RequestDirect || defined All
#undef RequestDirect
Ushort _far _cdecl RequestDirect( Uint iExch, Pvoid pRq ) ;
#endif

#if defined RequestRemote || defined All
#undef RequestRemote
Ushort _far _cdecl RequestRemote( Uint bRemoteCPUId, Pvoid pRq ) ;
#endif

#if defined ReScheduleMarkedQueueEntry || defined All
#undef ReScheduleMarkedQueueEntry
Ushort _far _cdecl ReScheduleMarkedQueueEntry( Pvoid pbQueueName, Uint cbQueueName, Ulong qeh ) ;
#endif

#if defined RescheduleProcess || defined All
#undef RescheduleProcess
Ushort _far _cdecl RescheduleProcess( Uint wProcessId ) ;
#endif

#if defined ReserveBusAddress || defined All
#undef ReserveBusAddress
Ushort _far _cdecl ReserveBusAddress( Uint cb, Pvoid pBusAddressRet ) ;
#endif

#if defined ReservePartitionMemory || defined All
#undef ReservePartitionMemory
Ushort _far _cdecl ReservePartitionMemory( Uint cb, Uchar fLongLived, Pvoid pMhRet ) ;
#endif

#if defined ResetAllSegs || defined All
#undef ResetAllSegs
Ushort _far _cdecl ResetAllSegs( void ) ;
#endif

#if defined ResetCommLine || defined All
#undef ResetCommLine
Ushort _far _cdecl ResetCommLine( Uint commLineHandle ) ;
#endif

#if defined ResetFrame || defined All
#undef ResetFrame
Ushort _far _cdecl ResetFrame( Uint iFrame ) ;
#endif

#if defined ResetIBusHandler || defined All
#undef ResetIBusHandler
Ushort _far _cdecl ResetIBusHandler( Uint wID, Pvoid pProc ) ;
#endif

#if defined ResetMemoryLL || defined All
#undef ResetMemoryLL
Ushort _far _cdecl ResetMemoryLL( void ) ;
#endif

#if defined ResetMemorySL || defined All
#undef ResetMemorySL
Ushort _far _cdecl ResetMemorySL( void ) ;
#endif

#if defined ResetPSCounters || defined All
#undef ResetPSCounters
Ushort _far _cdecl ResetPSCounters( Uint sh, Pvoid pbBlockID, Uint cbBlockID ) ;
#endif

#if defined ResetTimerInt || defined All
#undef ResetTimerInt
Ushort _far _cdecl ResetTimerInt( Pvoid pTPIB ) ;
#endif

#if defined ResetVideo || defined All
#undef ResetVideo
Ushort _far _cdecl ResetVideo( Uchar nCols, Uchar nLines, Uchar fAttr, Uchar bSpace, Pvoid psMapRet ) ;
#endif

#if defined ResetVideoGraphics || defined All
#undef ResetVideoGraphics
Ushort _far _cdecl ResetVideoGraphics( Uchar nCols, Uchar nLines, Uchar fAttr, Uchar bSpace, Pvoid psMapRet, Uint nPixelsWide, Uint nPixelsHigh, Uint nPlanes, Uchar fBackgroundColor ) ;
#endif

#if defined ResetXBusMIsr || defined All
#undef ResetXBusMIsr
Ushort _far _cdecl ResetXBusMIsr( Uint ih ) ;
#endif

#if defined Respond || defined All
#undef Respond
Ushort _far _cdecl Respond( Pvoid pRq ) ;
#endif

#if defined ResumeContext || defined All
#undef ResumeContext
Ushort _far _cdecl ResumeContext( void ) ;
#endif

#if defined ReuseAlias || defined All
#undef ReuseAlias
Ushort _far _cdecl ReuseAlias( Uint snAlias, Pvoid pSource ) ;
#endif

#if defined ReUseAliasLarge || defined All
#undef ReUseAliasLarge
Ushort _far _cdecl ReUseAliasLarge( Uint snAlias, Uint snSource, Ulong dOffsetSource, Uint limit ) ;
#endif

#if defined RewriteMarkedQueueEntry || defined All
#undef RewriteMarkedQueueEntry
Ushort _far _cdecl RewriteMarkedQueueEntry( Pvoid pbQueueName, Uint cbQueueName, Ulong qeh, Pvoid pEntry, Uint sEntry ) ;
#endif

#if defined RgParam || defined All
#undef RgParam
Ushort _far _cdecl RgParam( Uint iParam, Uint jParam, Pvoid pSdRet ) ;
#endif

#if defined RgParamInit || defined All
#undef RgParamInit
Ushort _far _cdecl RgParamInit( Pvoid pVarParams, Uint sVarParams, Uint cParams ) ;
#endif

#if defined RgParamSetEltNext || defined All
#undef RgParamSetEltNext
Ushort _far _cdecl RgParamSetEltNext( Pvoid pSd ) ;
#endif

#if defined RgParamSetListStart || defined All
#undef RgParamSetListStart
Ushort _far _cdecl RgParamSetListStart( Uint iParam ) ;
#endif

#if defined RgParamSetSimple || defined All
#undef RgParamSetSimple
Ushort _far _cdecl RgParamSetSimple( Uint iParam, Pvoid pSd ) ;
#endif

#if defined RkvsVersion || defined All
#undef RkvsVersion
Ushort _far _cdecl RkvsVersion( Pvoid pbSpec, Uint cbSpec, Pvoid pVerStruct, Uint sVerStruct, Pvoid pcbRet ) ;
#endif

#if defined sbPrint || defined All
#undef sbPrint
void _far _cdecl sbPrint( Pvoid pb ) ;
#endif

#if defined ScanToGoodRsRecord || defined All
#undef ScanToGoodRsRecord
Ushort _far _cdecl ScanToGoodRsRecord( Pvoid pRSWA, Ulong qbSkipMax, Pvoid pLfaScanStartRet, Pvoid pqbRet ) ;
#endif

#if defined ScrollFrame || defined All
#undef ScrollFrame
Ushort _far _cdecl ScrollFrame( Uint iFrame, Uint iLineStart, Uint iLineMax, Uint cLines, Uchar fUp ) ;
#endif

#if defined ScrollRasterLines || defined All
#undef ScrollRasterLines
Ushort _far _cdecl ScrollRasterLines( Uint iLineStart, Uint iLineMax, Uint iLineReplace, Uint cbLines, Uint nDelay ) ;
#endif

#if defined ScrubFile || defined All
#undef ScrubFile
Ushort _far _cdecl ScrubFile( Uint fh ) ;
#endif

#if defined ScsiCdbDataIn || defined All
#undef ScsiCdbDataIn
Ushort _far _cdecl ScsiCdbDataIn( Uint pathHandle, Uint wTimeout, Pvoid pCdb, Uint sCdb, Pvoid pDataInRet, Uint sDataInMax, Pvoid pCbDataRet, Pvoid pStatusRet, Pvoid pExtSenseRet, Uint sExtSenseMax ) ;
#endif

#if defined ScsiCdbDataInAsync || defined All
#undef ScsiCdbDataInAsync
Ushort _far _cdecl ScsiCdbDataInAsync( Uint pathHandle, Uint wTimeout, Pvoid pCdb, Uint sCdb, Pvoid pDataInRet, Uint sDataInMax, Pvoid pExtSenseRet, Uint sExtSenseMax, Pvoid pRq, Uint exchangeReply ) ;
#endif

#if defined ScsiCdbDataOut || defined All
#undef ScsiCdbDataOut
Ushort _far _cdecl ScsiCdbDataOut( Uint pathHandle, Uint wTimeout, Pvoid pCdb, Uint sCdb, Pvoid pDataOut, Uint sDataOut, Pvoid pCbDataRet, Pvoid pStatusRet, Pvoid pExtSenseRet, Uint sExtSenseMax ) ;
#endif

#if defined ScsiCdbDataOutAsync || defined All
#undef ScsiCdbDataOutAsync
Ushort _far _cdecl ScsiCdbDataOutAsync( Uint pathHandle, Uint wTimeout, Pvoid pCdb, Uint sCdb, Pvoid pDataOut, Uint sDataOut, Pvoid pExtSenseRet, Uint sExtSenseMax, Pvoid pRq, Uint exchangeReply ) ;
#endif

#if defined ScsiClosePath || defined All
#undef ScsiClosePath
Ushort _far _cdecl ScsiClosePath( Uint pathHandle ) ;
#endif

#if defined ScsiManagerNameQuery || defined All
#undef ScsiManagerNameQuery
Ushort _far _cdecl ScsiManagerNameQuery( Pvoid pbProcessorName, Uint cbProcessorName, Pvoid pSbScsiManagerNameRet, Uint sSbScsiManagerNameMax ) ;
#endif

#if defined ScsiOpenPath || defined All
#undef ScsiOpenPath
Ushort _far _cdecl ScsiOpenPath( Pvoid pbScsiManagerName, Uint cbScsiManagerName, Uchar hostAdapter, Uchar targetId, Uchar LUN, Pvoid pPathHandleRet, Pvoid pPathParameters, Uint sPathParameters, Pvoid pbPassword, Uint cbPassword, Uint mode ) ;
#endif

#if defined ScsiQueryInfo || defined All
#undef ScsiQueryInfo
Ushort _far _cdecl ScsiQueryInfo( Uint wModule, Uint wBus, Uint wFmt, Pvoid pScsiInfoRet, Uint sScsiInfoMax, Pvoid pCbScsiInfoRet ) ;
#endif

#if defined ScsiQueryPathParameters || defined All
#undef ScsiQueryPathParameters
Ushort _far _cdecl ScsiQueryPathParameters( Uint pathHandle, Pvoid pPathParametersRet, Uint sPathParametersMax ) ;
#endif

#if defined ScsiRequestSense || defined All
#undef ScsiRequestSense
Ushort _far _cdecl ScsiRequestSense( Uint pathHandle, Uint wTimeout, Pvoid pExtSenseRet, Uint sExtSenseMax, Pvoid pCbExtSenseRet, Pvoid pStatusRet ) ;
#endif

#if defined ScsiReset || defined All
#undef ScsiReset
Ushort _far _cdecl ScsiReset( Uint pathHandle ) ;
#endif

#if defined ScsiSetPathParameters || defined All
#undef ScsiSetPathParameters
Ushort _far _cdecl ScsiSetPathParameters( Uint pathHandle, Pvoid pPathParameters, Uint sPathParameters ) ;
#endif

#if defined ScsiTargetCdbCheck || defined All
#undef ScsiTargetCdbCheck
Ushort _far _cdecl ScsiTargetCdbCheck( Uint pathHandle, Pvoid pBusIdRet, Pvoid pCdbRet, Uint sCdbMax ) ;
#endif

#if defined ScsiTargetCdbWait || defined All
#undef ScsiTargetCdbWait
Ushort _far _cdecl ScsiTargetCdbWait( Uint pathHandle, Pvoid pBusIdRet, Pvoid pCdbRet, Uint sCdbMax ) ;
#endif

#if defined ScsiTargetDataReceive || defined All
#undef ScsiTargetDataReceive
Ushort _far _cdecl ScsiTargetDataReceive( Uint pathHandle, Pvoid pCdbRet, Uint sCdbMax, Pvoid pDataRet, Uint sDataMax, Pvoid pCbDataRet, Pvoid pStatusRet, Pvoid pExtSenseRet, Uint sExtSenseMax ) ;
#endif

#if defined ScsiTargetDataReceiveAsync || defined All
#undef ScsiTargetDataReceiveAsync
Ushort _far _cdecl ScsiTargetDataReceiveAsync( Uint pathHandle, Pvoid pCdbRet, Uint sCdbMax, Pvoid pDataRet, Uint sDataMax, Pvoid pExtSenseRet, Uint sExtSenseMax, Pvoid pRq, Uint exchangeReply ) ;
#endif

#if defined ScsiTargetDataTransmit || defined All
#undef ScsiTargetDataTransmit
Ushort _far _cdecl ScsiTargetDataTransmit( Uint pathHandle, Pvoid pCdbRet, Uint sCdbMax, Pvoid pData, Uint sData, Pvoid pCbDataRet, Pvoid pStatusRet, Pvoid pExtSenseRet, Uint sExtSenseMax ) ;
#endif

#if defined ScsiTargetDataTransmitAsync || defined All
#undef ScsiTargetDataTransmitAsync
Ushort _far _cdecl ScsiTargetDataTransmitAsync( Uint pathHandle, Pvoid pCdbRet, Uint sCdbMax, Pvoid pData, Uint sData, Pvoid pExtSenseRet, Uint sExtSenseMax, Pvoid pRq, Uint exchangeReply ) ;
#endif

#if defined ScsiTargetOperationsAbort || defined All
#undef ScsiTargetOperationsAbort
Ushort _far _cdecl ScsiTargetOperationsAbort( Uint pathHandle ) ;
#endif

#if defined ScsiWaitCdbAsync || defined All
#undef ScsiWaitCdbAsync
Ushort _far _cdecl ScsiWaitCdbAsync( Pvoid pRq, Pvoid pCbDataRet, Pvoid pStatusRet ) ;
#endif

#if defined ScsiWaitTargetDataAsync || defined All
#undef ScsiWaitTargetDataAsync
Ushort _far _cdecl ScsiWaitTargetDataAsync( Pvoid pRq, Pvoid pCbDataRet, Pvoid pStatusRet ) ;
#endif

#if defined Send || defined All
#undef Send
Ushort _far _cdecl Send( Uint exchange, Pvoid pMsg ) ;
#endif

#if defined SendBreakC || defined All
#undef SendBreakC
Ushort _far _cdecl SendBreakC( Pvoid pBs ) ;
#endif

#if defined ServeRq || defined All
#undef ServeRq
Ushort _far _cdecl ServeRq( Uint requestCode, Uint exchange ) ;
#endif

#if defined ServiceOverlayA || defined All
#undef ServiceOverlayA
Ushort _far _cdecl ServiceOverlayA( Pvoid p, Uint tyService ) ;
#endif

#if defined ServiceOverlayB || defined All
#undef ServiceOverlayB
Ushort _far _cdecl ServiceOverlayB( Uint sl, Uint tyService ) ;
#endif

#if defined ServiceOverlayC || defined All
#undef ServiceOverlayC
Ushort _far _cdecl ServiceOverlayC( Pvoid pb, Uint w, Uint tyService ) ;
#endif

#if defined Set386TrapHandler || defined All
#undef Set386TrapHandler
Ushort _far _cdecl Set386TrapHandler( Uint iTrap, Pvoid pTrapHandler ) ;
#endif

#if defined SetAlphaColorDefault || defined All
#undef SetAlphaColorDefault
Ushort _far _cdecl SetAlphaColorDefault( Uchar bMode ) ;
#endif

#if defined SetBsLfa || defined All
#undef SetBsLfa
Ushort _far _cdecl SetBsLfa( Pvoid pBswa, Ulong lfa ) ;
#endif

#if defined SetDaBufferMode || defined All
#undef SetDaBufferMode
Ushort _far _cdecl SetDaBufferMode( Pvoid pDawa, Uint mode ) ;
#endif

#if defined SetDateTime || defined All
#undef SetDateTime
Ushort _far _cdecl SetDateTime( Uint seconds, Uint dayTimes2 ) ;
#endif

#if defined SetDateTimeMode || defined All
#undef SetDateTimeMode
Ushort _far _cdecl SetDateTimeMode( Uchar modeDate, Uchar modeTime, Uchar modeFormat ) ;
#endif

#if defined SetDefaultTrapHandler || defined All
#undef SetDefaultTrapHandler
Ushort _far _cdecl SetDefaultTrapHandler( Uint iTrap, Pvoid pTrapHandler, Pvoid ppRet ) ;
#endif

#if defined SetDeltaPriority || defined All
#undef SetDeltaPriority
Ushort _far _cdecl SetDeltaPriority( Uint ph, Uint delta ) ;
#endif

#if defined SetDeviceHandler || defined All
#undef SetDeviceHandler
Ushort _far _cdecl SetDeviceHandler( Uint tyDev, Pvoid pIntHandler, Uint saData, Uchar fRaw ) ;
#endif

#if defined SetDevParams || defined All
#undef SetDevParams
Ushort _far _cdecl SetDevParams( Pvoid pbDevSpec, Uint cbDevSpec, Pvoid pbPassword, Uint cbPassword, Uint paramCode ) ;
#endif

#if defined SetDirStatus || defined All
#undef SetDirStatus
Ushort _far _cdecl SetDirStatus( Pvoid pbDirName, Uint cbDirName, Pvoid pbPassword, Uint cbPassword, Uint statusCode, Pvoid pStatus, Uint sStatus ) ;
#endif

#if defined SetDiskGeometry || defined All
#undef SetDiskGeometry
Ushort _far _cdecl SetDiskGeometry( Pvoid pbDevName, Uint cbDevName, Pvoid pbPassword, Uint cbPassword, Pvoid pDiskGeometry, Uint sDiskGeometry ) ;
#endif

#if defined SetDispMsw287 || defined All
#undef SetDispMsw287
Ushort _far _cdecl SetDispMsw287( Uint msw ) ;
#endif

#if defined SetExitRunFile || defined All
#undef SetExitRunFile
Ushort _far _cdecl SetExitRunFile( Pvoid pbExitRunFile, Uint cbExitRunFile, Pvoid pbPassword, Uint cbPassword, Uint priority ) ;
#endif

#if defined SetFhLongevity || defined All
#undef SetFhLongevity
Ushort _far _cdecl SetFhLongevity( Uint fh, Uint iCode ) ;
#endif

#if defined SetField || defined All
#undef SetField
Ushort _far _cdecl SetField( Uint fh, Pvoid pBuffer, Uint sBuffer, Pvoid pbFieldName, Uint cbFieldName, Pvoid pbValue, Uint cbValue ) ;
#endif

#if defined SetFieldNumber || defined All
#undef SetFieldNumber
Ushort _far _cdecl SetFieldNumber( Uint fh, Pvoid pBuffer, Uint sBuffer, Pvoid pbFieldName, Uint cbFieldName, Uint w ) ;
#endif

#if defined SetFileStatus || defined All
#undef SetFileStatus
Ushort _far _cdecl SetFileStatus( Uint fh, Uint statusCode, Pvoid pStatus, Uint sStatus ) ;
#endif

#if defined SetFSConfigParams || defined All
#undef SetFSConfigParams
Ushort _far _cdecl SetFSConfigParams( Pvoid pbConfigBuff, Uint cbConfigBuff ) ;
#endif

#if defined SetIBusHandler || defined All
#undef SetIBusHandler
Ushort _far _cdecl SetIBusHandler( Uint wID, Pvoid pProc ) ;
#endif

#if defined SetImageMode || defined All
#undef SetImageMode
Ushort _far _cdecl SetImageMode( Pvoid pBswa, Uchar mode ) ;
#endif

#if defined SetImageModeC || defined All
#undef SetImageModeC
Ushort _far _cdecl SetImageModeC( Pvoid pBswa, Uchar mode ) ;
#endif

#if defined SetIntHandler || defined All
#undef SetIntHandler
Ushort _far _cdecl SetIntHandler( Uint iInt, Pvoid pIntHandler, Uint saData, Uchar fDeviceInt, Uchar fRaw ) ;
#endif

#if defined SetKbdLed || defined All
#undef SetKbdLed
Ushort _far _cdecl SetKbdLed( Uint iLed, Uchar fOn ) ;
#endif

#if defined SetKbdSemicodedMode || defined All
#undef SetKbdSemicodedMode
Ushort _far _cdecl SetKbdSemicodedMode( Uchar fEnable ) ;
#endif

#if defined SetKbdUnencodedMode || defined All
#undef SetKbdUnencodedMode
Ushort _far _cdecl SetKbdUnencodedMode( Uchar fOn ) ;
#endif

#if defined SetLdtRDs || defined All
#undef SetLdtRDs
Ushort _far _cdecl SetLdtRDs( Uint sgLdtr, Uint sgDs ) ;
#endif

#if defined SetLPIsr || defined All
#undef SetLPIsr
Ushort _far _cdecl SetLPIsr( Pvoid pLpIsr, Uint saData ) ;
#endif

#if defined SetMsgRet || defined All
#undef SetMsgRet
Ushort _far _cdecl SetMsgRet( Pvoid pb, Uint cb ) ;
#endif

#if defined SetNode || defined All
#undef SetNode
Ushort _far _cdecl SetNode( Pvoid pbNodeName, Uint cbNodeName ) ;
#endif

#if defined SetPartitionExchange || defined All
#undef SetPartitionExchange
Ushort _far _cdecl SetPartitionExchange( Uint exchange ) ;
#endif

#if defined SetPartitionLock || defined All
#undef SetPartitionLock
Ushort _far _cdecl SetPartitionLock( Uchar fLock ) ;
#endif

#if defined SetPartitionName || defined All
#undef SetPartitionName
Ushort _far _cdecl SetPartitionName( Uint userNumPartition, Pvoid pbName, Uint cbName ) ;
#endif

#if defined SetPartitionSwapMode || defined All
#undef SetPartitionSwapMode
Ushort _far _cdecl SetPartitionSwapMode( Uint userNumPartition, Uint wSwapMode ) ;
#endif

#if defined SetPath || defined All
#undef SetPath
Ushort _far _cdecl SetPath( Pvoid pbVolSpec, Uint cbVolSpec, Pvoid pbDirName, Uint cbDirName, Pvoid pbPassword, Uint cbPassword ) ;
#endif

#if defined SetPrefix || defined All
#undef SetPrefix
Ushort _far _cdecl SetPrefix( Pvoid pbPrefix, Uint cbPrefix ) ;
#endif

#if defined SetPStructure || defined All
#undef SetPStructure
Ushort _far _cdecl SetPStructure( Uint structCode, Uint ph, Ushort oField, Pvoid pb, Uint cb ) ;
#endif

#if defined SetRsLfa || defined All
#undef SetRsLfa
Ushort _far _cdecl SetRsLfa( Pvoid pRswa, Ulong lfaSet ) ;
#endif

#if defined SetScreenVidAttr || defined All
#undef SetScreenVidAttr
Ushort _far _cdecl SetScreenVidAttr( Uint iAttr, Uchar fOn ) ;
#endif

#if defined SetSegmentAccess || defined All
#undef SetSegmentAccess
Ushort _far _cdecl SetSegmentAccess( Uint sn, Uint bAccess ) ;
#endif

#if defined SetStyleRam || defined All
#undef SetStyleRam
Ushort _far _cdecl SetStyleRam( Uchar fAlphaColor ) ;
#endif

#if defined SetStyleRamEntry || defined All
#undef SetStyleRamEntry
Ushort _far _cdecl SetStyleRamEntry( Uint iEntry, Uchar bVal ) ;
#endif

#if defined SetSwapDisable || defined All
#undef SetSwapDisable
Ushort _far _cdecl SetSwapDisable( Uchar fDisable ) ;
#endif

#if defined SetSysInMode || defined All
#undef SetSysInMode
Ushort _far _cdecl SetSysInMode( Uint iMode, Uchar fhSysIn ) ;
#endif

#if defined SetTimerInt || defined All
#undef SetTimerInt
Ushort _far _cdecl SetTimerInt( Pvoid pTPIB ) ;
#endif

#if defined SetTrapHandler || defined All
#undef SetTrapHandler
Ushort _far _cdecl SetTrapHandler( Uint iTrap, Pvoid pTrapHandler ) ;
#endif

#if defined SetUpMailNotification || defined All
#undef SetUpMailNotification
Ushort _far _cdecl SetUpMailNotification( Pvoid pbMailUser, Uint cbMailUser, Pvoid pbMailCenter, Uint cbMailCenter, Pvoid pbMailPassword, Uint cbMailPassword, Uchar bMinPrecedence ) ;
#endif

#if defined SetUserFileEntry || defined All
#undef SetUserFileEntry
Ushort _far _cdecl SetUserFileEntry( Pvoid pNlsTableArea, Pvoid pBuffer, Uint sBuffer, Pvoid pbFieldName, Uint cbFieldName, Pvoid pbValue, Uint cbValue ) ;
#endif

#if defined SetVerifyCode || defined All
#undef SetVerifyCode
Ushort _far _cdecl SetVerifyCode( Pvoid pbDevSpec, Uint cbDevSpec, Uint verifyCode ) ;
#endif

#if defined SetVideoTimeout || defined All
#undef SetVideoTimeout
Ushort _far _cdecl SetVideoTimeout( Uint nMinutes ) ;
#endif

#if defined SetWSUserName || defined All
#undef SetWSUserName
Ushort _far _cdecl SetWSUserName( Pvoid pbUserName, Uint cbUserName ) ;
#endif

#if defined SetXBusMIsr || defined All
#undef SetXBusMIsr
Ushort _far _cdecl SetXBusMIsr( Pvoid pIhRet, Pvoid pIntHandler, Uint saData ) ;
#endif

#if defined SgFromSa || defined All
#undef SgFromSa
Ushort _far _cdecl SgFromSa( Uint Sa, Uint userNum, Pvoid pSgRet ) ;
#endif

#if defined ShortDelay || defined All
#undef ShortDelay
Ushort _far _cdecl ShortDelay( Uint n ) ;
#endif

#if defined ShrinkAreaLL || defined All
#undef ShrinkAreaLL
Ushort _far _cdecl ShrinkAreaLL( Pvoid pArea, Uint cbArea ) ;
#endif

#if defined ShrinkAreaSL || defined All
#undef ShrinkAreaSL
Ushort _far _cdecl ShrinkAreaSL( Pvoid pArea, Uint cbArea ) ;
#endif

#if defined ShrinkPartition || defined All
#undef ShrinkPartition
Ushort _far _cdecl ShrinkPartition( void ) ;
#endif

#if defined SnFromSr || defined All
#undef SnFromSr
Ushort _far _cdecl SnFromSr( Uint sr, Pvoid pSnRet ) ;
#endif

#if defined SpaMoverVersion || defined All
#undef SpaMoverVersion
Ushort _far _cdecl SpaMoverVersion( Pvoid pVerStruct, Uint sVerStruct, Pvoid pcbRet ) ;
#endif

#if defined SpaRamDiskVersion || defined All
#undef SpaRamDiskVersion
Ushort _far _cdecl SpaRamDiskVersion( Pvoid pVerStruct, Uint sVerStruct, Pvoid pcbRet ) ;
#endif

#if defined SpoolerPassword || defined All
#undef SpoolerPassword
Ushort _far _cdecl SpoolerPassword( Pvoid pbPrinterName, Uint cbPrinterName, Pvoid pbPassword, Uint cbPassword ) ;
#endif

#if defined SpoolerVersion || defined All
#undef SpoolerVersion
Ushort _far _cdecl SpoolerVersion( Pvoid pVerStruct, Uint sVerStruct, Pvoid pcbRet ) ;
#endif

#if defined SrFromSn || defined All
#undef SrFromSn
Ushort _far _cdecl SrFromSn( Uint sn, Uint userNum, Pvoid pSrRet ) ;
#endif

#if defined StatisticsVersion || defined All
#undef StatisticsVersion
Ushort _far _cdecl StatisticsVersion( Pvoid pVerStruct, Uint sVerStruct, Pvoid pcbRet ) ;
#endif

#if defined StringsEqual || defined All
#undef StringsEqual
Uchar _far _cdecl StringsEqual( Pvoid psbString1, Pvoid psbString2 ) ;
#endif

#if defined SuspendProcess || defined All
#undef SuspendProcess
Ushort _far _cdecl SuspendProcess( Ushort pid ) ;
#endif

#if defined SuspendUser || defined All
#undef SuspendUser
Ushort _far _cdecl SuspendUser( Uint userNum ) ;
#endif

#if defined SwapContextUser || defined All
#undef SwapContextUser
Ushort _far _cdecl SwapContextUser( Uint userNum ) ;
#endif

#if defined SwapDebuggerVideo || defined All
#undef SwapDebuggerVideo
Ushort _far _cdecl SwapDebuggerVideo( Pvoid pbCharMap, Uint cbCharMap, Uchar fSave ) ;
#endif

#if defined SwapInContext || defined All
#undef SwapInContext
Uint _far _cdecl SwapInContext( Uint Usernum ) ;
#endif

#if defined SwapInContextAndLock || defined All
#undef SwapInContextAndLock
Uint _far _cdecl SwapInContextAndLock( Uint Usernum ) ;
#endif

#if defined SwapXBusEar || defined All
#undef SwapXBusEar
Uint _far _cdecl SwapXBusEar( Uint NewEar ) ;
#endif

#if defined SystemCommonCheck || defined All
#undef SystemCommonCheck
Ushort _far _cdecl SystemCommonCheck( Uint iProc ) ;
#endif

#if defined SystemCommonConnect || defined All
#undef SystemCommonConnect
Ushort _far _cdecl SystemCommonConnect( Uint iProc, Pvoid pProc ) ;
#endif

#if defined SystemCommonInstall || defined All
#undef SystemCommonInstall
Ushort _far _cdecl SystemCommonInstall( Uint iProc, Pvoid pProcNew, Pvoid prgbParamDesc, Uint cbParamDesc, Uint tyOperation, Pvoid pInfoRet, Uint sInfoRet ) ;
#endif

#if defined SystemCommonQuery || defined All
#undef SystemCommonQuery
Ushort _far _cdecl SystemCommonQuery( Uint iProc, Pvoid pInfoRet, Uint sInfoRet ) ;
#endif

#if defined TapeOperation || defined All
#undef TapeOperation
Uint _far _cdecl TapeOperation( Uint th, Uchar fFast, Uchar command, Uint subOp ) ;
#endif

#if defined TapeStatus || defined All
#undef TapeStatus
Uint _far _cdecl TapeStatus( Uint th, Pvoid pStatusRet ) ;
#endif

#if defined TapeVersion || defined All
#undef TapeVersion
Uint _far _cdecl TapeVersion( Pvoid pbSpec, Uint cbSpec, Pvoid pVerStruct, Uint sVerStruct, Pvoid pcbRet ) ;
#endif

#if defined TerminateAllOtherContexts || defined All
#undef TerminateAllOtherContexts
Ushort _far _cdecl TerminateAllOtherContexts( Ushort erc ) ;
#endif

#if defined TerminateContext || defined All
#undef TerminateContext
Ushort _far _cdecl TerminateContext( void ) ;
#endif

#if defined TerminateContextUser || defined All
#undef TerminateContextUser
Ushort _far _cdecl TerminateContextUser( Uint userNum, Ushort erc ) ;
#endif

#if defined TerminatePartitionTasks || defined All
#undef TerminatePartitionTasks
Ushort _far _cdecl TerminatePartitionTasks( Uint ph ) ;
#endif

#if defined TerminateQueueServer || defined All
#undef TerminateQueueServer
Ushort _far _cdecl TerminateQueueServer( Pvoid pbQueueName, Uint cbQueName ) ;
#endif

#if defined TextEdit || defined All
#undef TextEdit
Ushort _far _cdecl TextEdit( Uchar ch, Pvoid ptdUser ) ;
#endif

#if defined TransmitCommLineDma || defined All
#undef TransmitCommLineDma
Ushort _far _cdecl TransmitCommLineDma( Uint commLineHandle, Pvoid pbXmitBuffer, Uint cbXmitBuffer ) ;
#endif

#if defined TruncateDaFile || defined All
#undef TruncateDaFile
Ushort _far _cdecl TruncateDaFile( Pvoid pDawa, Ulong qiRecord ) ;
#endif

#if defined TsConnect || defined All
#undef TsConnect
Ushort _far _cdecl TsConnect( Uint iVpModule, Uint th, Uint device, Uchar fAdd ) ;
#endif

#if defined TsDataChangeParams || defined All
#undef TsDataChangeParams
Ushort _far _cdecl TsDataChangeParams( Uint lh, Pvoid pbLineControl, Uint cbLineControl ) ;
#endif

#if defined TsDataCheckpoint || defined All
#undef TsDataCheckpoint
Ushort _far _cdecl TsDataCheckpoint( Uint lh, Uint cTimeout ) ;
#endif

#if defined TsDataCloseLine || defined All
#undef TsDataCloseLine
Ushort _far _cdecl TsDataCloseLine( Uint lh, Uint cTimeout ) ;
#endif

#if defined TsDataOpenLine || defined All
#undef TsDataOpenLine
Ushort _far _cdecl TsDataOpenLine( Pvoid pLhRet, Pvoid pbLineSpec, Uint cbLineSpec, Pvoid pbLineControl, Uint cbLineControl, Pvoid pbDialString, Uint cbDialString, Pvoid pcbStringRet ) ;
#endif

#if defined TsDataRead || defined All
#undef TsDataRead
Ushort _far _cdecl TsDataRead( Uint lh, Uint cTimeout, Pvoid pbData, Uint cbDataMin, Uint cbDataMax, Pvoid pcbDataRet ) ;
#endif

#if defined TsDataRetrieveParams || defined All
#undef TsDataRetrieveParams
Ushort _far _cdecl TsDataRetrieveParams( Uint lh, Pvoid pStatusRet, Uint sStatusRetMax ) ;
#endif

#if defined TsDataUnacceptCall || defined All
#undef TsDataUnacceptCall
Ushort _far _cdecl TsDataUnacceptCall( Pvoid pbLineSpec, Uint cbLineSpec ) ;
#endif

#if defined TsDataWrite || defined All
#undef TsDataWrite
Ushort _far _cdecl TsDataWrite( Uint lh, Uint cTimeout, Pvoid pbData, Uint cbData, Pvoid pcbDataRet ) ;
#endif

#if defined TsDeinstall || defined All
#undef TsDeinstall
Ushort _far _cdecl TsDeinstall( Uint iVpModule, Pvoid pPhRet, Ushort erc ) ;
#endif

#if defined TsDial || defined All
#undef TsDial
Ushort _far _cdecl TsDial( Uint iVpModule, Uint line, Pvoid pbDialString, Uint cbDialString, Uint cErrorTimeout, Pvoid pcbStringRet ) ;
#endif

#if defined TsDoFunction || defined All
#undef TsDoFunction
Ushort _far _cdecl TsDoFunction( Uint iVpModule, Uint function ) ;
#endif

#if defined TsGetStatus || defined All
#undef TsGetStatus
Ushort _far _cdecl TsGetStatus( Uint iVpModule, Pvoid pStatusRet, Uint sStatusRetMax, Uchar fNoWait ) ;
#endif

#if defined TsHold || defined All
#undef TsHold
Ushort _far _cdecl TsHold( Uint iVpmodule, Uint line ) ;
#endif

#if defined TsOffHook || defined All
#undef TsOffHook
Ushort _far _cdecl TsOffHook( Uint iVpModule, Pvoid pThRet, Uint line ) ;
#endif

#if defined TsOnHook || defined All
#undef TsOnHook
Ushort _far _cdecl TsOnHook( Uint iVpModule, Uint line ) ;
#endif

#if defined TsQueryConfigParams || defined All
#undef TsQueryConfigParams
Ushort _far _cdecl TsQueryConfigParams( Uint iVpModule, Pvoid pConfigRet, Uint sConfigRetMax, Pvoid pbFileSpecRet, Uint cbFileSpecRetMax, Pvoid pcbFileSpecRet ) ;
#endif

#if defined TsReadTouchTone || defined All
#undef TsReadTouchTone
Ushort _far _cdecl TsReadTouchTone( Uint iVpModule, Uint device, Pvoid pbDigits, Uint cbDigitsMax, Pvoid pcbDigitsRet, Uchar bStopDigit, Uint cTimeout ) ;
#endif

#if defined TsRing || defined All
#undef TsRing
Ushort _far _cdecl TsRing( Uint iVpModule, Uchar hz ) ;
#endif

#if defined TsSetConfigParams || defined All
#undef TsSetConfigParams
Ushort _far _cdecl TsSetConfigParams( Uint iVpModule, Pvoid pConfig, Uint sConfig ) ;
#endif

#if defined TsVersion || defined All
#undef TsVersion
Ushort _far _cdecl TsVersion( Uint iVpModule, Pvoid pVerStruct, Uint sVerStruct, Pvoid pcbRet ) ;
#endif

#if defined TsVoiceConnect || defined All
#undef TsVoiceConnect
Ushort _far _cdecl TsVoiceConnect( Uint iVpModule, Uchar fTelephoneUnit, Uchar fLine0, Uchar fLine1 ) ;
#endif

#if defined TsVoicePlaybackFromFile || defined All
#undef TsVoicePlaybackFromFile
Ushort _far _cdecl TsVoicePlaybackFromFile( Uint iVpModule, Pvoid pWorkArea, Uint sWorkArea, Pvoid pVoiceControl, Uint sVoiceControl, Pvoid pLfaLast, Pvoid pqSampleLast, Pvoid pStatusRet ) ;
#endif

#if defined TsVoiceRecordToFile || defined All
#undef TsVoiceRecordToFile
Ushort _far _cdecl TsVoiceRecordToFile( Uint iVpModule, Pvoid pWorkArea, Uint sWorkArea, Pvoid pVoiceControl, Uint sVoiceControl, Pvoid pLfaLast, Pvoid pqSampleLast, Pvoid pStatusRet ) ;
#endif

#if defined TsVoiceStop || defined All
#undef TsVoiceStop
Ushort _far _cdecl TsVoiceStop( Uint iVpModule ) ;
#endif

#if defined TurnOffMailNotification || defined All
#undef TurnOffMailNotification
Ushort _far _cdecl TurnOffMailNotification( void ) ;
#endif

#if defined ULCmpB || defined All
#undef ULCmpB
Uint _far _cdecl ULCmpB( Pvoid prgbString1, Pvoid prgbString2, Uint cbString ) ;
#endif

#if defined UndeleteFile || defined All
#undef UndeleteFile
Uint _far _cdecl UndeleteFile( Uint fhbNum, Pvoid pbFileSpec, Uint cbFileSpec, Pvoid pbPassword, Uint cbPassword ) ;
#endif

#if defined UnlockFile || defined All
#undef UnlockFile
Ushort _far _cdecl UnlockFile( Uint lockFh ) ;
#endif

#if defined UnlockInCache || defined All
#undef UnlockInCache
Ushort _far _cdecl UnlockInCache( Uint fh, Ulong lfa, Uint cb, Pvoid pcbUnlockedRet ) ;
#endif

#if defined UnlockInContext || defined All
#undef UnlockInContext
Ushort _far _cdecl UnlockInContext( Uint userNum ) ;
#endif

#if defined UnlockRaster || defined All
#undef UnlockRaster
Ushort _far _cdecl UnlockRaster( void ) ;
#endif

#if defined UnLockVideo || defined All
#undef UnLockVideo
void _far _cdecl UnLockVideo( void ) ;
#endif

#if defined UnLockVideoForModify || defined All
#undef UnLockVideoForModify
void _far _cdecl UnLockVideoForModify( void ) ;
#endif

#if defined UnlockXbis || defined All
#undef UnlockXbis
Ushort _far _cdecl UnlockXbis( void ) ;
#endif

#if defined UnmapBusAddress || defined All
#undef UnmapBusAddress
Ushort _far _cdecl UnmapBusAddress( Ulong busAddress ) ;
#endif

#if defined UnmarkQueueEntry || defined All
#undef UnmarkQueueEntry
Ushort _far _cdecl UnmarkQueueEntry( Pvoid pbQueueName, Uint cbQueueName, Ulong qeh ) ;
#endif

#if defined UnsuspendProcess || defined All
#undef UnsuspendProcess
Ushort _far _cdecl UnsuspendProcess( Ushort pid ) ;
#endif

#if defined UnsuspendUser || defined All
#undef UnsuspendUser
Ushort _far _cdecl UnsuspendUser( Uint userNum ) ;
#endif

#if defined UnzoomBox || defined All
#undef UnzoomBox
Ushort _far _cdecl UnzoomBox( Pvoid pBoxDesc ) ;
#endif

#if defined UpdateFSDeviceName || defined All
#undef UpdateFSDeviceName
Ushort _far _cdecl UpdateFSDeviceName( Pvoid pDevNameBlock ) ;
#endif

#if defined UpdateOverlayLru || defined All
#undef UpdateOverlayLru
void _far _cdecl UpdateOverlayLru( Pvoid pProcInfo ) ;
#endif

#if defined UpdateRouteTable || defined All
#undef UpdateRouteTable
Ushort _far _cdecl UpdateRouteTable( Uint wCase, Pvoid pbTableEntry, Uint cbTableEntry ) ;
#endif

#if defined VacatePartition || defined All
#undef VacatePartition
Ushort _far _cdecl VacatePartition( Uint ph ) ;
#endif

#if defined VamStatus || defined All
#undef VamStatus
Uint _far _cdecl VamStatus( void ) ;
#endif

#if defined Wait || defined All
#undef Wait
Ushort _far _cdecl Wait( Uint exchange, Pvoid ppMsgRet ) ;
#endif

#if defined WaitLong || defined All
#undef WaitLong
Ushort _far _cdecl WaitLong( Uint exchange, Pvoid ppMsgRet ) ;
#endif

#if defined Waitp || defined All
#undef Waitp
Ushort _far _cdecl Waitp( Uint exchange, Pvoid ppMsgRet ) ;
#endif

#if defined WildCardInit || defined All
#undef WildCardInit
Ushort _far _cdecl WildCardInit( Pvoid pb, Uint cb, Pvoid pFxhBlock, Uint sFxhBlock ) ;
#endif

#if defined WildCardMatch || defined All
#undef WildCardMatch
Uchar _far _cdecl WildCardMatch( Pvoid pbWild, Uint cbWild, Pvoid pbTarget, Uint cbTarget ) ;
#endif

#if defined WildCardNext || defined All
#undef WildCardNext
Ushort _far _cdecl WildCardNext( Pvoid pFxhBlock, Pvoid pSdValueRet ) ;
#endif

#if defined WriteFile || defined All
#undef WriteFile
Ushort _far _cdecl WriteFile( Uint fh, Pvoid pBuffer, Uint sBuffer, Ulong lfa, Pvoid psDataRet ) ;
#endif

#if defined WriteAsync || defined All
#undef WriteAsync
Ushort _far _cdecl WriteAsync( Ushort fh, Pvoid pBuffer, Uint sBuffer, Ulong lfa, Pvoid pRq, Uint exchangeReply ) ;
#endif

#if defined WriteBsRecord || defined All
#undef WriteBsRecord
Ushort _far _cdecl WriteBsRecord( Pvoid pBs, Pvoid pb, Uint cb, Pvoid pCbWrittenRet ) ;
#endif

#if defined WriteByte || defined All
#undef WriteByte
Ushort _far _cdecl WriteByte( Pvoid pBs, Uchar b ) ;
#endif

#if defined WriteByteStreamParameterC || defined All
#undef WriteByteStreamParameterC
Ushort _far _cdecl WriteByteStreamParameterC( Pvoid pBs, Uint wParamNum, Uint wParam ) ;
#endif

#if defined WriteCommLineStatus || defined All
#undef WriteCommLineStatus
Ushort _far _cdecl WriteCommLineStatus( Uint commLineHandle, Uint wStatusMask, Uint wStatus ) ;
#endif

#if defined WriteDaFragment || defined All
#undef WriteDaFragment
Ushort _far _cdecl WriteDaFragment( Pvoid pDawa, Ulong qiRecord, Pvoid pRecord, Uint rbFragment, Uint cbFragment ) ;
#endif

#if defined WriteDaRecord || defined All
#undef WriteDaRecord
Ushort _far _cdecl WriteDaRecord( Pvoid pDawa, Ulong qiRecord, Pvoid pRecord ) ;
#endif

#if defined WriteHardId || defined All
#undef WriteHardId
Ushort _far _cdecl WriteHardId( Uint wID ) ;
#endif

#if defined WriteIBusDevice || defined All
#undef WriteIBusDevice
Ushort _far _cdecl WriteIBusDevice( Uint wId, Pvoid pb, Uint cb ) ;
#endif

#if defined WriteIBusEvent || defined All
#undef WriteIBusEvent
Ushort _far _cdecl WriteIBusEvent( Pvoid pb, Uint cb ) ;
#endif

#if defined WriteLed || defined All
#undef WriteLed
Ushort _far _cdecl WriteLed( Uchar bLedData ) ;
#endif

#if defined WriteLog || defined All
#undef WriteLog
Ushort _far _cdecl WriteLog( Pvoid pbRecord, Uint cbRecord ) ;
#endif

#if defined WriteRsRecord || defined All
#undef WriteRsRecord
Ushort _far _cdecl WriteRsRecord( Pvoid pRswa, Pvoid pRecord, Uint sRecord ) ;
#endif

#if defined WriteStatusC || defined All
#undef WriteStatusC
Ushort _far _cdecl WriteStatusC( Pvoid pBs, Uint wStatusMask, Uint wStatus ) ;
#endif

#if defined WriteSwap || defined All
#undef WriteSwap
Ushort _far _cdecl WriteSwap( Uint userNum, Pvoid p, Pvoid pBuffer, Uint cbBuffer ) ;
#endif

#if defined WriteTapeRecords || defined All
#undef WriteTapeRecords
Uint _far _cdecl WriteTapeRecords( Uint th, Uint nRecords, Pvoid pb, Uint cb, Pvoid pCRecordsRet, Pvoid pCbRet ) ;
#endif

#if defined XbifVersion || defined All
#undef XbifVersion
Uint _far _cdecl XbifVersion( Pvoid pVerStruct, Uint sVerStruct, Pvoid pcbRet ) ;
#endif

#if defined ZoomBox || defined All
#undef ZoomBox
Uint _far _cdecl ZoomBox( Pvoid pBoxDesc, Uint sCols, Uint sLines, Uchar fFinalBox ) ;
#endif

#if defined ZPrint || defined All
#undef ZPrint
void _far _cdecl ZPrint( Pvoid pb ) ;
#endif

#undef All

