/***
*assert.h - define the assert macro
*
*	Copyright 1985-1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	Defines the assert(exp) macro.
*	[POSIX/ANSI/System V]
*
****/

#if !defined(_ASSERT_DEFINED)

#define _ASSERT_DEFINED

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif

#undef	assert

#if defined(NDEBUG)

#define assert(exp)	((void)0)

#else

void _FAR_ _cdecl _assert(void _FAR_ *, void _FAR_ *, unsigned int);
#define assert(exp) \
	( (exp) ? (void) 0 : _assert(#exp, __FILE__, __LINE__) )

#endif /* NDEBUG */

#endif /* !_ASSERT_DEFINED */
