/* syncstatus.c -- monitor for sync.run */

#include "sync.h"

char ProcName[4];
struct syncrq *rq, rqblk = {2, 0, 1, 0, 0, 0, 0, 0, 0, ProcName, 4};

int RqNumber[MAXPARAMS];
int currentline = 1;
int numrqs;

main()
{
	/* initialize request block */
	checkerc(getusernumber(&rqblk.userNum));
	checkerc(allocexch(&rqblk.exchResp));

	getrqnumbers();
	initscreen();

	while(TRUE) {
		checkkbd();
		monitor();
	}
}

monitor()
{
	int erc, i;

	/* request each value in RqNumber array and store result */
	for(i = 0; i < numrqs; i++) {
		rqblk.rqCode = RqNumber[i];
		erc = request(&rqblk);
		if(erc != 0 && erc != 33)
			errorexit(erc);
		if(erc == 33) {
			checkerc(putframechars(0, 35, 7 + i, " Free  ", 7));
			checkerc(putframechars(0, 56, 7 + i, "    ", 4));
		} else {
			checkerc(wait(rqblk.exchResp, &rq));
			checkerc(putframechars(0, 35, 7 + i, "Waiting", 7));
			checkerc(putframechars(0, 56, 7 + i, ProcName, 4));
		}
	}
}

checkkbd()
{
	int i, erc;
	char ch;

	/* loop for 2 seconds or 20 tenths */
	for(i = 0; i < 20; i++) {
		if(!readkbddirect(1, &ch))
			switch (ch) {
				case '\004' :			/* FINISH */
				case '\007' :			/* CANCEL */
					do_exit();
				case '\001' :
					go_up();
					break;
				case '\013' :
					go_down();
					break;
				case '\037' : 			/* F10 */
					do_purge();
					break;
				default :
					beep();
		}
	}
}

getrqnumbers()
/* add any user requests to RqNumber array */
{
	char param[40];
	int erc, i, numparams, number;

	/* first add default sync request numbers */
	for(i = 0; i < SYNCRQS; i++)
		RqNumber[i] = RQBASE + i;

	/* get param and convert to sync request number */
	if(!(numparams = CSubParams(1))) {
		numrqs = SYNCRQS;
		return;
	}
	if(numparams > MAXPARAMS - SYNCRQS) {
		nprint ("Too many request numbers given.");
		exit();
	}
	for(i = 0; i < numparams; i++) {
		getparam(1, i, param);
		number = hextou(param);
		if(!number || (number > SYNCRQS && number < USERRQBASE)) {
			nprint(param);
			nprint(" is an invalid sync request number.\n");
			if(number)					/* if in illegal range */
				nprint("Numbers from 1 to 3FFF are reserved for the O.S.\n");
			do_exit();
		}
		erc = queryrequestinfo(number, NULL, 0);
		if(erc) {
			nprint(param);
			nprint(" is not a valid request code.");
			exit();
		}
		RqNumber[i+SYNCRQS] = number;
	}
	numrqs = numparams + SYNCRQS;
}

initscreen()
{
	char rqname[6];
	int i;

	checkerc(resetframe(0));

	/* write heading */
	checkerc(putframechars(0, 31, 2, "SRP Sync Status", 15));
	checkerc(putframeattrs(0, 31, 2, UNDERLINE, 15));
	checkerc(putframechars(0, 10, 5, "Request Number", 14));
	checkerc(putframeattrs(0, 10, 5, UNDERLINE, 14));
	checkerc(putframechars(0, 35, 5, "Status", 6));
	checkerc(putframeattrs(0, 35, 5, UNDERLINE, 6));
	checkerc(putframechars(0, 53, 5, "Processor", 9));
	checkerc(putframeattrs(0, 53, 5, UNDERLINE, 9));

	/* write request names */
	strcpy(rqname, "Sync 1");
	for(i = 0; i < SYNCRQS; i++, rqname[5]++)
		checkerc(putframechars(0, 14, 7 + i, rqname, 6));
	for(i = SYNCRQS; i < numrqs; i++) {
		utohex(RqNumber[i], rqname);
		checkerc(putframechars(0, 14, 7 + i, rqname, strlen(rqname)));
	}

	/* print soft keys */
	checkerc(putframechars(0, 7, 24, "      ", 8));
	checkerc(putframeattrs(0, 1, 24, INVERSE, 20));
	checkerc(putframechars(0, 32, 24, "            ", 15));
	checkerc(putframeattrs(0, 26, 24, INVERSE, 27));
	checkerc(putframechars(0, 64, 24, "       Free", 13));
	checkerc(putframeattrs(0, 58, 24, INVERSE, 20));

	/* print initial status and highlight 1st line */
	monitor();
	highlight(currentline);
}

do_purge()
{
	int erc;

	checkerc(putframeattrs(0, 14, 6 + currentline, HIGHLIGHT, 46));
	rqblk.rqCode = RqNumber[currentline - 1];
	erc = request(&rqblk);
	if(erc == 0)
		checkerc(wait(rqblk.exchResp, &rq));
	if(erc != 0 && erc != 33)
		errorexit(erc);
	rqblk.fDeinstall = 0;
	checkerc(putframeattrs(0, 14, 6 + currentline, INVERSE, 46));
}

go_down()
{
	clear(currentline);
	if(++currentline > numrqs)
		currentline = 1;
	highlight(currentline);
}

go_up()
{
	clear(currentline);
	if(--currentline == 0)
		currentline = numrqs;
	highlight(currentline);
}

highlight(i)
int i;
{
	checkerc(putframeattrs(0, 14, 6 + i, INVERSE, 46));
}

clear(i)
int i;
{
	checkerc(putframeattrs(0, 14, 6 + i, 0, 46));
}

do_exit()
{
	checkerc(resetframe(0));
	exit();
}

utohex(u, str)						/* convert unsigned to hex string */
unsigned u;
char str[];
{
	int i, j;

	for(i = 0, j = 4096; i < 4; i++) {
		str[i] = (u / j) + '0';
		u %= j;
		j /= 16;
	}
	str[i++] = 'h';
	str[i] = '\0';
}

hextou(s)							/* convert hex string to unsigned */
char s[];
{
	int i, n;

	for(n = i = 0; toupper(s[i]); i++) 
		if(s[i] >= '0' && s[i] <= '9')
			n = n * 16 + s[i] - '0';
		else 
			if(s[i] >= 'A' && s[i] <= 'F')
				n = n * 16 + s[i] - 'A' + 10;
			else
				break;
	return(n);
}

