/* FooServer.c -- Test server using the Server.lib.  Stores a buffer of open
 * 		file specs, then writes them to a file and deinstalls. 
 *
 * Log:
 *	10/28/85 JA Created - PLM
 *	2/7/86 TB Converted to C
 */

/*
 *	Compiling instructions:
 *
 *	CC86
 *	 Source files		FooServer.c
 *	 [Object files]
 *	 [Model]			Medium
 *
 *	Linking instructions:
 *
 *	Link
 *	 Object Modules		Server.obj FooServer.obj
 *	 Run File Name		FooServer.run
 *
 *	The following link errors are acceptable -
 *
 *	Unresolved Externals:
 *
 *	INITIALIZE in file(s):  SERVER.OBJ
 *	START in file(s):  SERVER.OBJ
 *	TIMER in file(s):  SERVER.OBJ
 *	HANDLERESPOND in file(s):  SERVER.OBJ
 *	HANDLEMESSAGE in file(s):  SERVER.OBJ
 *	CLEANUP in file(s):  SERVER.OBJ
 *	RQTIME in file(s):  SERVER.OBJ
 *	RGFONT in file(s):  SERVER.OBJ
 *	SRGFONT in file(s):  SERVER.OBJ
*/

/* Return values indicating how to handle requests - */
#define lOk 					0
#define lRespond 				1
#define lForward				2
#define lPass					3
#define lOkDeinstall		 0x10
#define lRespondDeinstall	 0x11
#define lForwardDeinstall	 0x12

/* application-specific definitions */
#define RQOPENFILE 				4
#define RQOPENFILELL 		   97
#define IBHEXERC				5
#define ERCNOTIMPLEMENTED		7
#define BUFFERSIZE			 1024
#define NULL			(char *)0

typedef unsigned int word;


/* Structures supplied by library routine - */

extern struct SysConfigType {
	char fill[36];
	char fMultiPartition;
} *pConfig;

extern struct {
	char fill[64];
	char cbName;
	char rgName[30];
} *pASCB;

extern struct {
	char level;
	char nLines;
	char nColMin;
	char nColMax;
} VidHdwr;

struct rqtype {
	char sCntInfo;
	char RtCode;
	char nReqPbCb;
	char nRespPbCb;
	word userNum;
	word exchResp;
	word ercRet;
	word rqCode;
	word fh;
	word lfaLow;
	word lfaHigh;
	char *p0;
	word s0;
	char *p1;
	word s1;
	char *p2;
	word s2;
	char *p3;
	word s3;
};

extern word wVersion;

extern int exchServe;

/* Structures defined by every server - */

unsigned rgServeRq[] = { RQOPENFILE, RQOPENFILELL };
unsigned nServeRq = sizeof(rgServeRq);

/*scratch space for deinstall, 1 word per rqCode in rgServeRq*/
unsigned rgRqExch[sizeof(rgServeRq)];


/* Optional structures
 *
 * struct TrbType {
 *		word counter
 *			,counterReload
 *			,cEvents
 *			,exchResp
 *			,ercRet
 *			,rqCode;
 * } rqTime;
 *
 * char rgFont[] = "[sys]<sys>sys.font";
 *
 * int  sRgFont = sizeof(rgFont);
 */


/* Routine for interrupt to call to send a message to the server.*/
PokeServer(w)
word w;
{
	CrashIfErcNotOk(Send(exchServe, &w));
}

/* Application specific declarations - */
char *pBuf;
int  ib, erc;
char postScript[] = " erc xxxxh";

/* Application local subroutines - */
char rgHex[] = "0123456789ABCDEF";

ConvertWHex(w, pRet)
word w;
char pRet[];
{
	int i;

	for(i = 3; i; i--) {
		pRet[i] = rgHex[w & 0xF];
		w = w >> 4;
	}
}

/*Standard routines that may be present in all servers.*/

Initialize()
/* This procedure is called after requests are verified but
 * before requests are actually served.  All OS calls are valid here.
 * Do error checking, memory or exchange allocation, config file reading,
 * extraction of arguments from the command form etc.
 *
 * This example server checks the os type, then allocates and clears a buffer
 * for use during the processing of requests.
 */
{
	char *calloc();

	if(!pConfig->fMultiPartition)
		ErrorExitString(ERCNOTIMPLEMENTED, "OS must be MultiPartition", 25);
	pBuf = calloc(BUFFERSIZE, 1);
	
	/* Set message to be printed upon successful installation - */
	CheckErc(SetMsgRet("Installation complete.", 22));
}

/* Requests have been served.  Installation succeeds or fails.
 * From now on all routines must use RequestDirect to issue OS calls listed
 * in rgServeRq above, issuing the rqs to the exchange recorded in rgRqExch.
 * Other requests may still be issued via procedural interface (by name).
 *
 * Some OS calls now no longer work after ConvertToSys.  System services have
 * no video structures so calls to VAM or VDM are illegal (PutFrameChars etc).
 * In SinglePartition os,
 *		memory allocation/deallocation is illegal,
 *		exchange allocation is illegal,
 *		files must be opened using OpenFileLL,
 *		interrupt routines may no longer be set,
 *		bytestreams are not supported.
 *  In MultiPartition os,
 *		memory deallocation will work, then the memory may be reallocated,
 *		 but long-lived memory is gone,
 *		exchanges may be freely allocated,
 *		files operate normally,
 *		interrupt routines may be set/reset normally,
 *		bytestreams are supported.
 */


/* Optional:
 *
 * This procedure is called once after installation.  Do things that need
 *  not occur unless installation is successful, such as starting the timer.
 * Start()
 * {
 *		rqTime.counter = rqTime.counterReload;
 * }
 */

/* The following four routines are called as messages are received.
 * Only one routine is ever called at once, i.e. no problems with
 * reentrancy, recursion or semaphores.
 *
 * Each routine returns a word which may have the following values -
 *		lOk				the routine discharged the request itself; do nothing
 *		lRespond		the request has been processed, respond to the user
 *		lForward		the request should be forwarded to the regular handler
 *		lPass			like lForward, but when it is done call HandleRespond
 *		lOkDeinstall	like lOk; also deinstall the service
 *		lRespondDeinstall like lRespond; also deinstall the service
 *		lForwardDeinstall like lForward; also deinstall the service
 *
 * HandleRequest would return different values in each sort of server.
 * A pure system service uses lRespond.  An asynchronous server uses lOk.
 * lForward and lPass are used by one-way and two-way filters, respectively.
 *
 * Timer and HandleMessage always return lOk.
 * HandleRespond returns lRespond or maybe lOk.
 *
 * The Deinstall values are the same as the regular values except after
 * discharging the request, the system service unserves the requests, flushes
 * the exchange and exits.
 */


/* Optional
 *
 * rqTimer has counted down to 0.  See OS call OpenRTClock.
 * Timer(pRq)
 * char *pRq;
 * {
 * 		return(lOk);
 * }
 */


HandleRequest(pRq)
/* An original request has been issued whose request code field matches
 * one of those in the rgServeRq array.  Perform applications-specific
 * operations.  Fields of the request block based on the pointer pRq
 * that may be changed are -
 *		pRq->ercRet		error code to be returned to caller
 *		pRq->pb->		response buffer(s) pointed to by the request block
 * Any request block field may be examined.  See Operating System, VOL 1
 * for a description of request blocks.
 */
struct rqtype *pRq;
{
	/* This example server records the name of every file opened, until its
	 *  name buffer is full.  It then deinstalls.  This is a two-way filter.
	 */
	if(BUFFERSIZE - ib >= pRq->s0) {
		strncpy(pBuf + ib, pRq->p0, pRq->s0);
		ib += pRq->s0;
		return(lPass);
	} else
		return(lForwardDeinstall);
}


HandleRespond(pRq)
/* A request block has come back via Respond.  It was previously received
 * at HandleRequest, which returned with the code lPass.  The request was
 * passed to the normal receiver of that request, which completed it and
 * Responded back to us.  This routine may now examine the results of the
 * operation, and then must let the request be Responded.
 */
struct rqtype *pRq;
{
	/* This example server records the error code returned from any open. */
	if(BUFFERSIZE - ib >= sizeof(postScript)) {
		ConvertWHex(pRq->ercRet, &postScript[IBHEXERC]);
		strncpy(pBuf + ib, postScript, strlen(postScript));
		ib += strlen(postScript);
		return(lRespond);
	} else
		return(lRespondDeinstall);
}


/* Optional
 * HandleMessage(w)
 *   An interrupt routine has sent a one-word message to the server.
 *   This message may be a data byte or word, or it may indicate some
 *   condition such as "buffer full".
 *   The interrupt routine cannot make requests, so it must "poke" the
 *   server somehow, and the server makes the requests.
 * 
 *   The interrupt routine could have set a flag that is checked by the
 *   server, but then the flag would have to be polled, e.g. every 1/10th
 *   second the timer routine could check the flag.  Sending a message
 *   usually is a better solution because the condition is noticed instantly,
 *   also without using any processor time for polling.
 *
 * word w;
 * {
 * 		return(lOk);
 * }
 */


Cleanup()
/* The server is deinstalling.  The requests have been served back to their
 * original destinations.  All requests pending have been discharged.
 * The server process is about to disappear.  Do any final operations
 * such as writing a log entry or flushing a buffer.
 * It is ok to issue requests by name that this server had been serving.
 */
{
	word fh, cbWrite;

	/* This example server writes the name buffer to a pre-existing file. */
	if(!OpenFile(&fh, "[sys]<sys>OpenNames.dat", 23, NULL, 0, 0x6D6D)) {
		erc = Write(fh, pBuf, BUFFERSIZE, 0L, &cbWrite);
		erc = CloseFile(fh);
	}
	beep();
}
