%IF(NOT %*IsDef(%AgentCache)) THEN (%SET(AgentCache,1))FI
;*****************************************************************************
; WsAgent_all.asm
; Workstation Agent
; This module contains code that is common to all hardware types.
;*****************************************************************************

$include(:f1:vfequ.idf)

;*****************************************************************************
;  PUBLIC PROCEDURES
;*****************************************************************************
PUBLIC WsAgent
PUBLIC MasterWentDown
PUBLIC FSrpUpProc
PUBLIC FMasterRqSentTestAndClear
PUBLIC GetClstrGenerationNumber

;*****************************************************************************
;  LITERALS
;*****************************************************************************

%if(%ctosp)then(
sgVirtualLowMem            equ 28h
sgGdt                      equ 8h
atPParamBlock              equ 250h
maskPresent                equ 80h

)fi
ascbUserName               EQU 64
devSpec                    EQU 1
dirSpec                    EQU 2
fileSpec                   EQU 3
fileSpec2                  EQU 4
fileSpecP2S2               EQU 5
maskSpecType               EQU 7
maskRouteFh                EQU 8
maskSpecPW                 EQU 10H
maskEscape                 EQU 40H
maskOpenFh                 EQU 40H
maskCloseFh                EQU 6
maskReadWrite              EQU 80H
pageSize                   EQU 512
sapASCB                    EQU 25h    ; ASCB is at 250h, so we need only sa
sizeWsStats                EQU 44

;*****************************************************************************
; Request block definition
;*****************************************************************************
rq              EQU 0
rqSCntlInfo     EQU rq
rqRtInfo        EQU rq+1
rqNReqPbCb      EQU rq+2
rqNRespPbCb     EQU rq+3
rqUserNum       EQU rq+4
rqRespExch      EQU rq+6
rqErcRet        EQU rq+8
rqCode          EQU rq+10
rqFh            EQU rq+12
rqLfa           EQU rq+14
rqpBuf          EQU rq+18
rqsBuf          EQU rq+22
rqpsDataRet     EQU rq+24
rqssDataRet     EQU rq+28
rqReadWriteData EQU rq+30

;*****************************************************************************
; UserTable definition. We have one entry per user indexed by userNumber. 
; We set pRqAgentReset to HandleRequest.pRq after we have processed a resetAgent request and we could not Respond because some non-sys requests were in transmission. When a request marked reset is returned from the Master, we decrement nWaitingForReset. When this is zero, we Respond(pRqAgentReset).
;*****************************************************************************
utFlags            EQU 0	; ** Warning:
utnWaitingForReset EQU 1	; ** Change table def here and in TermPros
utpTerminationRq   EQU 2	; **
							; **
utSize EQU 6				; **

; Values of utFlags:

fClusterTermRqSent EQU 1
fRqSentToMaster    EQU 2
fSetVerifyRqSent EQU 4
fUserNameSent    EQU 8

;*****************************************************************************
;  EXTERNAL PROCEDURES
;*****************************************************************************
EXTRN Crash:FAR
EXTRN KRespond:FAR
EXTRN OpenRTClock:FAR
EXTRN PrepareIdSearch:FAR
EXTRN ReInitXBlocks:FAR
EXTRN Respond:FAR
EXTRN Timeout:FAR
EXTRN KWait:FAR
EXTRN EnterBootRom:FAR

%IF (%AgentCache) THEN (
EXTRN CacheFlush:FAR
EXTRN CacheGetEntry:FAR
EXTRN CacheReleaseEntry:FAR
)FI%'

;*****************************************************************************
;  EXTERNAL DATA
;*****************************************************************************
DGroup GROUP DATA
Data SEGMENT PUBLIC 'DATA'

EXTRN cRcbMax:WORD								
EXTRN ercMasterDown:WORD						;in WsLph
EXTRN fOldMaster:BYTE							;in WsLph
EXTRN findIdRetryCount:BYTE						;in WsLph
EXTRN fMulPar:BYTE
EXTRN lineState:WORD							;in WsLph
EXTRN masterRevisionLevel:BYTE
EXTRN nUcb:WORD
EXTRN nXBlk:WORD
EXTRN pRgOUcb:DWORD
EXTRN nTerminationRq:WORD						
EXTRN pRgTerminationRq:DWORD
EXTRN pRgpRgRouting:DWORD
EXTRN prgRcMax:DWORD
EXTRN prgRqNoRemoteTermination:DWORD
EXTRN nRqNoRemoteTermination:WORD

EXTRN msgLph:WORD
; When we get a message that is a pointer to msgLph, the Line Protocol Handler is sending us a message.
EXTRN fMsgLphQueued:BYTE

msgMasterDown    EQU 1
msgMasterUp      EQU 2
msgXBlockIn      EQU 4
msgXBlockFill    EQU 8
msgReinitXBlocks EQU 10H

EXTRN saXBlockIn:WORD
EXTRN saXBlockOut:WORD
; saFreeList is the list of free XBlocks. The Agent must return an XBlock to the free list when it has been emptied. 
EXTRN saFreeList:WORD
EXTRN saXBlockCurrent:WORD
EXTRN sumSimpleRqTimeLow:WORD
EXTRN sumSimpleRqTimeHigh:WORD
EXTRN nSimpleRqLow:WORD
EXTRN nSimpleRqHigh:WORD
EXTRN maxSimpleRqTime:WORD
EXTRN sumGetDtRqTimeLow:WORD
EXTRN sumGetDtRqTimeHigh:WORD
EXTRN nGetDtRq:WORD
EXTRN maxGetDtRqTime:WORD
EXTRN sumBlockRqTimeLow:WORD
EXTRN sumBlockRqTimeHigh:WORD
EXTRN nBlockRqLow:WORD
EXTRN nBlockRqHigh:WORD
EXTRN maxBlockRqTime:WORD

EXTRN userExchFirst:WORD
EXTRN userNumLast:WORD
EXTRN vf:BYTE
EXTRN wsStats:WORD

EXTRN parityEnablePortNGen:WORD
EXTRN pfRebootClstr:DWORD	; fRebootClstr initialized by HwIdService_p
EXTRN pBootBlock:DWORD

;*****************************************************************************
;  GLOBAL DATA
;*****************************************************************************
PUBLIC wClstrVersion, fSrpUp, fOldStyle, exchAgent, oRgUserTable, oUserTable, rcbAvailHead, rcbAvailTail, rcbWaitingHead, rcbWaitingTail, nXBlockBoundary, nWaitingRequests, nXBlocksToSend, oRcbFirst, oRcbLast, pWsAgentMsg, rqSetVerify, cSrpRestart, timerRq, sXbMaxFast, sXbData
PUBLIC cRcbAfterTerm, cRespondBeforeRcb

wClstrVersion DW 0
fSrpUp DB 0
fOldStyle DB 0					;true if Iws with stationAddress set by switches
exchAgent DW ?
; The following two variables are for marks on the wall -- just to be
; sure things are working.  In general, the two counts should match.
; cRespondBeforeRcb gets incremented when we respond to an rcb that has
; not come back because we saw the RemoteTermination response go by.
; cRcbAfterTerm gets incremented when we get
; a response back for an rcb we have already responded to.
cRcbAfterTerm DW 0
cRespondBeforeRcb DW 0
EVEN
oRgUserTable DW 0				;Initialized by WsInit
oUserTable DW 0

;*****************************************************************************
; These are the lists of rcbs. Each list has a head and a tail. A list 
; is empty when both the head and the tail of the list point to the list. 
; This makes it very efficient to chain and unchain entries (4 MOVs). It also
; means you never need to know what list you are unchaining from. It makes it
; a little harder to know when you are at the end of the list. 
;*****************************************************************************
rcbAvailHead         DW DGROUP:rcbAvailHead
rcbAvailTail         DW DGROUP:rcbAvailHead
rcbWaitingHead       DW DGROUP:rcbWaitingHead
rcbWaitingTail       DW DGROUP:rcbWaitingHead

; XBlock cannot cross a 128K boundary. Any XBlocks that do will be discarded
; by InitWs, and this count will be incremented for audit 
nXBlockBoundary DW 0

nWaitingRequests DW 0
nXBlocksToSend   DW 0
oRcbFirst DW 0         ; initialized by WsInit
oRcbLast DW 0          ; initialized by WsInit 
pWsAgentMsg LABEL DWORD
raWsAgentMsg DW 0
saWsAgentMsg DW 0
;*****************************************************************************		
; ClusterTerm request
; oRgClusterTerm is set up by initialization code. It points to an array that
; we will fix up to contain the list of termination codes that get routed to
; the Agent (that's us). 
;*****************************************************************************		
;*rqClusterTerm  DW 2            ;sCntlInfo, sRtInfo
;*               DW 1            ;nReqPbCb, nRespPbCb
;*               DW 0            ;userNum goes directly to XBlock
;*               DW 0            ;response exchange goes directly to XBlock
;*               DW 0            ;ercRet
;*               DW rcResetAgent ;rqCode
;*termErc        DW 0 
;*oRgClusterTerm DW 0            ;initialized by WsInit 
;*               DW DGroup       ;pointer to rgClusterTerm
;*sTermRqCode    DW 0

;*****************************************************************************
; SetVerify request
; We send one to the master when we see the first request for each user. These
; are only used by masters before 8.0.
;*****************************************************************************		
rqSetVerify DW 2            ;sCntlInfo, sRtInfo
            DW 0            ;nReqPbCb, nRespPbCb
            DW 0            ;userNum goes directly to XBlock
            DW 0            ;response exchange goes directly to XBlock
            DW 0            ;ercRet
            DW rcSetVerify  ;rqCode
cSrpRestart DW 0 

;*****************************************************************************
; SetWsUserName request
; We send one to the master when the master first comes up. We do this so that
; the master will always get the user name if the master restarts
;*****************************************************************************		
rqSetUserName DW 6			;sCntlInfo, sRtInfo
            DW 1   	        ;nReqPbCb, nRespPbCb
            DW 0    	    ;userNum goes directly to XBlock
            DW 0            ;response exchange goes directly to XBlock
            DW 0            ;ercRet
            DW rcSetWsUserName  ;rqCode
; The next three words are not used by the SetWsUserName request, so put some
; variables here to conserve space.
sXbData 	DW 0			;Set up by WsInit depending on nSectorPerXBlock
	 		DW 0
sXbMaxFast 	DW 0			;Obsolete

pUserName   DW 0
            DW 0
sUserName   DB 0
            DB 0

;*****************************************************************************
; Timer Request Block
; Used to determine when the master goes down if we don't hear from the master every 2 seconds.
;*****************************************************************************		
timerRq       LABEL WORD
trbInterval   DW 20
trbResetValue DW 0
trbCEvents    DW 1
trbRespExch   DW exchAgent
trbErcRet     DW 0
trbRqCode     DW 0

;*****************************************************************************
; Timer Request Block
; Used to collect timing data on request turnaround time.
;*****************************************************************************	
PUBLIC rqClock	
rqClock DW 0FFFFh
        DW 0FFFFh
        DW 1
        DW 0
        DW 0
        DW 0

%IF (%AgentCache) THEN (
;*****************************************************************************
; Agent Cache handles, block pointers
;*****************************************************************************	
PUBLIC cphAgentCache, pCachedFiles, pCachedFhs
PUBLIC sAgentCacheBlock, fAgentCacheDefaultEnable
cphAgentCache DD ?			; cache pool handle for pool holding disk blocks
pCachedFiles DD ?			; cache block containing cachedFile structure lists
pCachedFhs   DD ?			; cache block containing cachedFh structure lists
sAgentCacheBlock DW 0
fAgentCacheDefaultEnable DB ?
)FI%'

%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;*****************************************************************************
; VARIABLES FOR DEBUGGING
;*****************************************************************************

fCrashIfMasterDown 		DB 0
PUBLIC fCrashIfMasterDown
EVEN
PUBLIC downSaXBlockOut, downSaXBlockIn, downSaXBlockCurrent, downSaFreeList, downSaFreeListNext, downSaXBlockInNext

downSaXBlockOut 		DW 0
downSaXBlockIn 			DW 0
downSaXBlockInNext 		DW 0
downSaXBlockCurrent 	DW 0
downSaFreeList 			DW 0
downSaFreeListNext 		DW 0

PUBLIC upSaXBlockOut, upSaXBlockIn, upSaXBlockCurrent, upSaFreeList, upSaFreeListNext, upSaXBlockInNext

upSaXBlockOut 			DW 0
upSaXBlockIn 			DW 0
upSaXBlockInNext 		DW 0
upSaXBlockCurrent 		DW 0
upSaFreeList 			DW 0
upSaFreeListNext 		DW 0
PUBLIC agentLog, agentLogIndex
agentLogBufferSize 		EQU 20
agentLogEntrySize 		EQU 4
agentLogIndexMax 		EQU (agentLogBufferSize-1)*agentLogEntrySize
agentLogIndex 			DW agentLogIndexMax
agentLog 				DW 0
						DW 0
						DB (agentLogBufferSize-1)*agentLogEntrySize DUP (0)
PUBLIC logRqBuffer, logRqBufferIndex
logRqEntrySize 			EQU 8    ;known to WsLph_all
logRqBufferSize 		EQU 100    ;known to WsLph_all
logRqBufferIndexMax EQU (logRqBufferSize-1)*logRqEntrySize ;known to WsLph_all
logRqBufferIndex 		DW logRqBufferIndexMax		;so we will start at zero
logRqBuffer 			LABEL WORD
PUBLIC logRqPoint, logRqCode, logRqErcRet, logRqoRcb
logRqPoint 				DW 0
; 1 = request comes in
; 2 = request responded to without being queued
; 3 = request queued
; 4 = request is sent to master
; 5 = request comes back from master
; 6 = request responded to
; 7 = request purged
; 8 = request reset -- wait for it to return before purging
; 9 = master went down
; 10 = master came up
logRqCode 				DW 0
logRqErcRet 			DW 0
logRqoRcb				DW 0
						DB  logRqEntrySize*logRqBufferSize DUP(0)

PUBLIC logRqInBuffer, logRqInBufferIndex
logRqInEntrySize 		EQU 2
logRqInBufferSize 		EQU 20
logRqInBufferIndexMax 	EQU (logRqInBufferSize-1)*logRqInEntrySize
logRqInBufferIndex 		DW logRqInBufferIndexMax	;so we will start at zero
logRqInBuffer 			LABEL WORD
						DB  logRqInEntrySize*logRqInBufferSize DUP(0)

PUBLIC logXBlockOutBuffer, logXBlockOutIndex
logXBlockOutEntrySize 	EQU 34
logXBlockOutSize 		EQU 20
logXBlockOutIndexMax 	EQU (logXBlockOutSize-1)*logXBlockOutEntrySize
logXBlockOutIndex 		DW logXBlockOutIndexMax		;so we will start at zero
logXBlockOutBuffer 		LABEL WORD
						DB (logXBlockOutSize)*logXBlockOutEntrySize DUP (0)

PUBLIC logTermRcbHead, logTermRcbBuffer
nRcb 					EQU 22
sRcbBuffer 				EQU nRcb*rcbSize
logTermRcbHead 			DW 0
logTermRcbBuffer 		LABEL WORD
						DB (sRcbBuffer) DUP (0)

EXTRN pollSequenceNumber: WORD
EXTRN pollState: WORD
PUBLIC logDownBuffer, logDownBufferIndex, logDownSequence, logDownLineState, logDownPollState, logDownErc
logDownBufferSize 		EQU 20
logDownEntrySize 		EQU 8
logDownBufferIndexMax 	EQU (logDownBufferSize-1)*logDownEntrySize
logDownBufferIndex 		DW logDownBufferIndexMax
logDownBuffer 			LABEL WORD
logDownSequence 		DW 0
logDownLineState 		DW 0
logDownPollState 		DW 0
logDownErc 				DW 0
						DB (logDownBufferSize-1)*logDownEntrySize DUP (0)

PUBLIC downUserTable1
downUserTable1 			DW 0
						DW 0
						DW 0
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

; Allocated user number support.
EXTRN pbUNBlkSHR:    DWORD
EXTRN pnUNBlocks:    DWORD
EXTRN prgwUNOwner:   DWORD
EXTRN pwLocalUser:   DWORD
lFreeUN             EQU 0FFFFH

fLocalUser DB 0     ; Variable used to indicate if the OS "owns" the user
                    ; number in the request block.

; rgCache* maps request codes to rcb flag masks.
rgCacheRc   DW rcOpenFile
			DW rcOpenFileLL
			DW rcReOpenFile
			DW rcRemakeFh
			DW rcCloseFile
			DW rcDeleteFile
			DW rcCloseAllFiles
			DW rcCloseAllFilesLL
			DW rcChangeFileLength
			DW rcSetFileStatus
rgCacheFl   DB rcbOpenFh
			DB rcbOpenFh
			DB rcbOpenFh
			DB rcbOpenFh
			DB rcbCloseFh
			DB rcbCloseFh
			DB rcbCloseAll
			DB rcbCloseAll
			DB rcbChangeLength
			DB rcbChangeLength
sCacheRc  EQU 10


Data ENDS

WsAgentCode SEGMENT PUBLIC 'CODE'
	ASSUME CS: WsAgentCode, DS: DGroup
WsAgentGroup GROUP WsAgentCode		; for WsAgentGroup:OFFSET foo addresses

WsAgent PROC FAR
;*****************************************************************************
;This is the Agent process. 
;*****************************************************************************

;Clear direction flag once and for all for this process.
	CLD									
%IF (%f9) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
; This code has been moved to InitWs1.plm. Keep the code around in case we
; need it for a cluster code package that will run on 9.0.
	LEA  AX,timerRq
	PUSH DS
	PUSH AX
	CALL OpenRTClock
	OR   AX,AX
	JNZ  TimerError
; Open Timer Request Block to collect request turnaround timing statistics.
	LEA  AX,rqClock
	PUSH DS
	PUSH AX
	CALL OpenRTClock
	OR   AX,AX
	JZ   StartIdSearch
TimerError:
	PUSH AX
	CALL Crash
StartIdSearch:
	CALL PrepareIdSearch
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
; start searching for an ID.
WsAgentWaitLoop:
	PUSH exchAgent
	LEA  AX,pWsAgentMsg
	PUSH DS
	PUSH AX
	CALL KWait
;*****************************************************************************
;We get three possible messages:
;(1) a pointer to our timerRq if a timeout occurs. This means the master 
;	went down.
;(2) a pointer to msgLph means the WsLph routines have sent us a message
;(5) anything else is a request that has been routed to our exchange.
;*****************************************************************************
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  DI,agentLogIndex
	ADD  DI,agentLogEntrySize
	CMP  DI,agentLogIndexMax
	JBE  agentLogIndexOk
	MOV  DI,0
agentLogIndexOk:
	MOV  agentLogIndex,DI
	MOV  AX,raWsAgentMsg
	MOV  agentLog[DI],AX
	MOV  AX,saWsAgentMsg
	MOV  agentLog+2[DI],AX
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

; See if this message is in our own DS space. If not, we have a new request.
	MOV  AX,DS
	CMP  saWsAgentMsg,AX
	JNE  NewRequestReceived
; The message is in our DS space. See if it's a timer request. If so, we have
; a timeout.
	MOV  AX,raWsAgentMsg
	CMP  AX,OFFSET DGROUP: timerRq
	JNE  TestMsgLph
	CALL Timeout
	JMP  WsAgentWaitLoop
TestMsgLph:
; See if it's a message from the Line Protocol Handler.
	CMP  AX,OFFSET DGROUP: msgLph
	JNE  NewRequestReceived
	MOV  fMsgLphQueued, 0	; signal WsLph that its OK to send more msgLphs
	CALL ProcessMsgLph
	JMP  WsAgentWaitLoop
NewRequestReceived:
	CALL HandleRequest
	JMP  WsAgentWaitLoop
WsAgent ENDP

ProcessMsgLph PROC NEAR
PUBLIC ProcessMsgLph
;*****************************************************************************
; msgLph tells us what the Line Protocol Handler wants us to do:
;    msgMasterUp
;    msgMasterDown
;    msgXBlockIn:   saXBlockIn points to a list of XBlocks that returned
;    msgXBlockFill: saFreeList points to XBlock available to fill
;    msgReinitXBlocks: reinitialize all XBlocks.
; Process each bit that is set.
;*****************************************************************************
	CLI								;Disable
	MOV  AX,msgLph

	TEST AL,msgXBlockIn				;Have we received an XBlock?
	JZ   TestXBlockFill
	MOV  ES,saXBlockIn				;ES points to XBlockIn
	XOR  DX,DX						;Zero next pointer of response block 
	XCHG DX,ES:[xbSaLink]			;DX points to next in list, if any
	MOV  saXBlockIn,DX				;saXBlockIn points to next
	OR   DX,DX						;Is the list empty?
	JNZ  CallHandleResponse			;No, there will be another to process
	AND  AL,0FFh-msgXBlockIn		;List is empty afther this, so
	MOV  msgLph,AX					;Zero XBlockIn bit
CallHandleResponse:
	STI								;Enable
	CALL HandleResponse				;ES points to XBlock that returned
	JMP  ProcessMsgLph				;See if we have another XBlockIn

TestXBlockFill:
	TEST AL,msgXBlockFill			;Do we have an XBlock to fill?
	JZ   TestMasterDown				;No
	AND  AL,0FFh-msgXBlockFill
	MOV  msgLph,AX
; If the master has gone down, don't send out any requests
	TEST AL,msgMasterDown+msgReinitXBlocks
	JNZ  TestMasterDown
	STI								;Enable
	CALL PrepareRequest				;Fill XBlock
	JMP  ProcessMsgLph					

TestMasterDown:
	TEST AL,msgMasterDown			;Has the master gone down?
	JZ   TestMasterUp				;No
	AND  AL,0FFh-msgMasterDown
	MOV  msgLph,AX
	STI								;Enable
	CALL FAR PTR MasterWentDown
	JMP  ProcessMsgLph

TestMasterUp:
	TEST AL,msgMasterUp				;Has the master come up?
	JZ   TestReinit					;No
	AND  AL,0FFh-msgMasterUp
	MOV  msgLph,AX
	STI								;Enable
	CALL MasterCameUp
	JMP  ProcessMsgLph

TestReinit:
	TEST AL,msgReinitXBlocks		;Need to reinit XBlocks?
	JZ   ProcessMsgLphRet			;No
	CALL ReinitX
; Don't turn off the bit until we have reinitialized XBlocks.
	AND  msgLph,0FFFFh-msgReinitXBlocks
	JMP  ProcessMsgLph

ProcessMsgLphRet:
	STI								;Enable
	RET
ProcessMsgLph ENDP
MasterCameUp PROC NEAR
PUBLIC MasterCameUp
;*****************************************************************************
; The master has just come up.
; Increment cSrpRestart. The local file system likes to know when the Master
; has gone down so that it can ask for the time and send the user name again. 
;*****************************************************************************
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  AX,saXBlockOut
	MOV  upSaXBlockOut,AX
	MOV  AX,saXBlockIn
	MOV  upSaXBlockIn,AX
	MOV  ES,AX
	MOV  AX,ES:[xbSaLink]
	MOV  upSaXBlockInNext,AX
	MOV  AX,saXBlockCurrent
	MOV  upSaXBlockCurrent,AX
	MOV  AX,saFreeList
	MOV  upSaFreeList,AX
	MOV  ES,AX
	MOV  AX,ES:[xbSaLink]
	MOV  upSaFreeListNext,AX

	MOV  DI,logRqBufferIndex
	ADD  DI,logRqEntrySize
	CMP  DI,logRqBufferIndexMax
	JBE  logRqBufferIndexOk7
	MOV  DI,0
logRqBufferIndexOk7:
	MOV  logRqBufferIndex,DI
	MOV  logRqPoint[DI],10 			  ;Master came up
	MOV  logRqCode[DI],0
	MOV  logRqoRcb[DI],0
	MOV  logRqErcRet[DI],0
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	MOV  AX,cSrpRestart	
	INC  AX
	CMP  AX,8
	JNE  UpdateSrpRestart
	MOV  AX,1
UpdateSrpRestart:
	MOV  cSrpRestart,AX
	MOV  fSrpUp,0FFh
	RET
MasterCameUp ENDP

ReinitX PROC NEAR
;*****************************************************************************
; We got a message from the LPH to reinitialize the XBlocks.  We do this
; when the master goes down and comes back up with different size XBlocks.
; We cannot reinitialize them from the LPH because we could be in the
; process of using one to send a request to the master.
;*****************************************************************************
PUBLIC ReinitX
; Make sure all the XBlocks are free before we reinitialize them.
	CLI
	CMP  saXBlockOut,0		
	JZ   NoXBlockOut
	MOV  ES,saXBlockOut
	MOV  AX,saFreeList				;AX is pointer to free list of XBlocks
	MOV  ES:[xbSaLink],AX			;Chain XBlock being freed to free list
	MOV  saFreeList,ES				;freeList points to XBlock freed
	MOV  saXBlockOut,0
NoXBlockOut:
	CMP  saXBlockCurrent,0
	JZ   CurrentFree
	MOV  ES,saXBlockCurrent
	MOV  AX,saFreeList				;AX is pointer to free list of XBlocks
	MOV  ES:[xbSaLink],AX			;Chain XBlock being freed to free list
	MOV  saFreeList,ES				;freeList points to XBlock freed
	MOV  saXBlockCurrent,0
CurrentFree:
	XOR  AX,AX					;AX will count XBlocks in free list
	MOV  CX,saFreeList
ReTestLast:
	JCXZ ReGotCount
	INC  AX						;Increment number in free list	
	MOV  ES,CX					;ES points to next XBlock
	MOV  CX,ES:[xbSaLink]
	JMP  ReTestLast
ReGotCount:
; Be sure all the XBlocks are free.  If not, then it's a bug!
; Add in the number of XBlocks we threw away because of DMA boundary.
	ADD  AX,nXBlockBoundary
	CMP  AX,nXBlk
	JE   ReCountOk
	PUSH ercInternalConsistencyCheck
	CALL Crash
ReCountOk:
	STI
	CALL ReinitXBlocks
	RET
ReinitX ENDP

MasterWentDown PROC FAR
;*****************************************************************************
; The master just went down. ercMasterDown has the erc.
; Purge all the waiting requests.
; This procedure can be called by Timeout in case of a timeout.
; This procedure is called by ProcessMsgLph if we get a message from the
; LineProtocolHandler telling us the master went down. This happens if the
; master goes down because of too many errors or because we saw a SNRM 
; addressed to us.
;*****************************************************************************
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  DI,oRgUserTable
	MOV  AX,[DI+6]
	MOV  downUserTable1,AX
	MOV  AX,[DI+8]
	MOV  downUserTable1+2,AX
	MOV  AX,[DI+10]
	MOV  downUserTable1+4,AX

	MOV  DI,logDownBufferIndex
	ADD  DI,logDownEntrySize
	CMP  DI,logDownBufferIndexMax
	JBE  logDownBufferIndexOk8
	MOV  DI,0
logDownBufferIndexOk8:
	MOV  logDownBufferIndex,DI
	MOV  AX,pollSequenceNumber
	MOV  logDownSequence[DI],AX
	MOV  AX,lineState
	MOV  logDownLineState[DI],AX
	MOV  AX,pollState
	MOV  logDownPollState[DI],AX
	MOV  AX,ercMasterDown
	MOV  logDownErc[DI],AX

	MOV  AX,saXBlockOut
	MOV  downSaXBlockOut,AX
	MOV  AX,saXBlockIn
	MOV  downSaXBlockIn,AX
	MOV  ES,AX
	MOV  AX,ES:[xbSaLink]
	MOV  downSaXBlockInNext,AX
	MOV  AX,saXBlockCurrent
	MOV  downSaXBlockCurrent,AX
	MOV  AX,saFreeList
	MOV  downSaFreeList,AX
	MOV  ES,AX
	MOV  AX,ES:[xbSaLink]
	MOV  downSaFreeListNext,AX

	MOV  DI,logRqBufferIndex
	ADD  DI,logRqEntrySize
	CMP  DI,logRqBufferIndexMax
	JBE  logRqBufferIndexOk8
	MOV  DI,0
logRqBufferIndexOk8:
	MOV  logRqBufferIndex,DI
	MOV  logRqPoint[DI],9   			;Master went down
	MOV  logRqCode[DI],0
	MOV  logRqoRcb[DI],0
	MOV  logRqErcRet[DI],0
	CMP  fCrashIfMasterDown,0FFh
	JNE  DontCrashIfMasterDown
	MOV  AX,ercMasterDown
	PUSH AX
	CALL Crash
DontCrashIfMasterDown:
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	LES  BX, pfRebootClstr		; ES:BX points to fRebootClstr
	MOV  AL, ES:BYTE PTR [BX]
	CMP  AL, 0
	JE   NoNeedToReboot
	LES  BX, pBootBlock
	MOV  AL, ES:BYTE PTR 9[BX] ; bootBlock.bWsBootDevClass
	MOV  AH, ES:BYTE PTR 10[BX]; bootBlock.bWsType
	CMP  AL, 3
	JNE  BootLocal
	MOV  BX, 11h		;reboot from comm
	MOV  DL, AH
	JMP  EnterAwsOrNGenBootROM
BootLocal:
	MOV  BX,10h		;Reboot from local
	MOV  DX,0h

EnterAwsOrNGenBootROM:
%if(%ctosp) then(
	PUSH BX	; bootrom ES
	PUSH DX ; bootrom dx (wstype)
	MOV  DX,parityEnablePortNGen	; disable parity
	XOR  AX,AX
	OUT  DX,AX
	CALL EnterBootRom
)else (
	MOV  ES, BX	
	MOV  BL,DL
	MOV  DX,parityEnablePortNGen	; disable parity
	XOR  AX,AX
	OUT  DX,AX
	MOV  DL,BL
; Note: ES and DL contain dump parameters for the boot rom.
	%jmp 0FFFFh:0
)fi
NoNeedToReboot:
	CMP  saXBlockOut,0		
	MOV  ES,saXBlockOut
	JZ   NoXBlockToFree
	CALL FreeXBlockOut
NoXBlockToFree:
	CMP  saXBlockCurrent,0
	MOV  ES,saXBlockCurrent
	JZ   XBlockCurrentFree
	CALL FreeXBlock
	MOV  saXBlockCurrent,0
XBlockCurrentFree:
	XOR  AX,AX
	MOV  masterRevisionLevel,AL
	MOV  fOldMaster,AL
	MOV  findIdRetryCount,AL
	MOV  fSrpUp,AL
	INC  wClstrVersion
	MOV  nWaitingRequests,AX
	MOV  BX,rcbWaitingHead
TestLastToPurge:
	CMP  BX,OFFSET DGROUP:rcbWaitingHead
	JE   RespondToTermRequests
	MOV  AX,ercMasterDown
	CALL RespondToRcb
	JMP  TestLastToPurge
RespondToTermRequests:
; Check to see if we are waiting for requests to return from the master so we
; can respond to a termination request. The requests will never come back, so
; respond to any outstanding termination requests.
	MOV  DI,oRgUserTable
	MOV  CX,nUcb
TestWaitingForReset:
	XOR  AX,AX
;*	CMP  BYTE PTR utnWaitingForReset[DI],AL
;*	MOV  BYTE PTR utnWaitingForReset[DI],AL
	MOV  BYTE PTR utFlags[DI],AL
;*	JE   NextWaitingForReset
;*	PUSH CX
;*	PUSH DI
;*	CALL RespondToTerminationRq
;*	POP  DI
;*	POP  CX
;*NextWaitingForReset:
	ADD  DI,utSize
	LOOP TestWaitingForReset
%IF (%AgentCache) THEN (
	MOV  AX, lAnyUserNum
	XOR  CX, CX
	CALL AgentCacheUnregisterHandle
)FI%'
	CALL PrepareIdSearch
	RET
MasterWentDown ENDP


HandleRequest PROC NEAR
PUBLIC HandleRequest
;*****************************************************************************
; pWsAgentMsg points to a new request.
;*****************************************************************************
	PUSH BP
	LES  BX,pWsAgentMsg					;ES:BX point to new request
; ES:BX point to new request
; See if the master is up. If not, return an erc to the user.
	CMP  fSrpUp,0FFh
	JE   MasterIsUp
	MOV  AX,ES:[BX+rqErcRet]
	OR   AX,AX
; If erc is already set (e.g. ercNoSuchFile) then request came from
; LfsToMaster. So we want to return that erc to the client,
; not ercMasterIsDown.
	JNZ  RespondToNewRequest1
	MOV  AX,ercMasterIsDown
RespondToNewRequest1:
	JMP  RespondToNewRequest

MasterIsUp:
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  DI,logRqInBufferIndex
	ADD  DI,logRqInEntrySize
	CMP  DI,logRqInBufferIndexMax
	JBE  logRqInBufferIndexOk
	MOV  DI,0
logRqInBufferIndexOk:
	MOV  logRqInBufferIndex,DI
	MOV  AX,ES:[BX+rqCode]
	MOV  logRqInBuffer[DI],AX
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

;Verify if Request Data is greater than XBlock Size, prevent system hang
	MOV  CL,ES:[BX+rqRtInfo]	;CL = routing info
	MOV  AX,ES:[BX+rqCode]		;AX = request code
	PUSH ES						;Save pointer to rq
	PUSH BX
	CALL GetRqLevel				;on return, SI = word index of level
	LES  BX, prgRcMax
	CMP  AX,ES:[BX][SI]	
	JAE  RestoreRqPointer		;rq code not in our table
	SHL  SI,1
	LES  BX, prgPrgRouting
	LES  BX,DWORD PTR ES:[BX][SI]
	XCHG AX,SI					;AX = level*4, SI = rqCode
	SHL  SI, 2
	MOV  CL,ES:[BX][SI+3]			;CL = NetRouting byte
RestoreRqPointer:
	POP  BX						;Restore pointer to rq
	POP  ES
	TEST CL,maskReadWrite		;All this done to see if piecemeal request
	JNZ  XBlockCheckDone

;Calculate total size of request data, can in fit in XBlock?
	MOV  DX,0Ch					;Rq Header
	ADD  DL,ES:[BX+rqSCntlInfo]	;Control Info
	MOV  DI,BX
	ADD  DI,DX					;ES:DI points to first pb/cb pair

	ADD  DX,xbHeaderSize		;XBlock Header
	XOR  CX,CX
	ADD  CL,ES:[BX+rqNReqPbCb]	;Request pb/cb pairs
	ADD  CL,ES:[BX+rqNRespPbCb]	;Response pb/cb pairs
	MOV  AX,6
	MUL  CX
	ADD  DX,AX					;DX = headers, control info and pb/cb stuff

	MOV  CL,ES:[BX+rqNReqPbCb]	;CX = nReqPbCb
	JCXZ CalculationComplete
CalculateNext:					;Add all request buffers
	ADD  DX,ES:[DI+4]			;Next pb/cb count value
	INC  DX
	AND  DX,0FFFEh				;align on word boundary
	ADD  DI,6
	Loop CalculateNext			;Index next pb/cb
CalculationComplete:
	MOV  AX,sXbData				;Finally, can we fit in the XBlock?
	ADD  AX,xbHeaderSize
	CMP  DX,AX
	JLE  XBlockCheckDone		;Yes, now we can continue 
	MOV  AX,ercXBufTooSmall		;No, return an error
	JMP  RespondToNewRequest

XBlockCheckDone:
;	MOV  WORD PTR ES:[BX+rqErcRet],0		;Set rq.ercRet = 0
; Preserve rqErcRet so LfsToMaster rqs can keep local erc if srp also ercs.
	MOV  DX,ES:[BX+rqUserNum]				;DX = userNum
	MOV  BP,ES:[BX+rqCode]					;BP = rqCode

%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  DI,logRqBufferIndex
	ADD  DI,logRqEntrySize
	CMP  DI,logRqBufferIndexMax
	JBE  logRqBufferIndexOk
	MOV  DI,0
logRqBufferIndexOk:
	MOV  logRqBufferIndex,DI
	MOV  logRqPoint[DI],1   				;Request comes in
	MOV  logRqCode[DI],BP
	MOV  logRqoRcb[DI],0
	MOV  logRqErcRet[DI],0
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

; Allocated user number support.

	MOV  DI, DX                 ; Move user number into DI.
	LES  BX, pbUNBlkSHR         ; ES:BX points to bUNBlkSHR
	MOV  CL, ES:[BX]
	SHR  DI, CL                 ; Shift user number to find which "block"
                                ; it falls in.
	LES  BX, pnUNBlocks         ; ES:BX points to nUNBlocks
	CMP  ES:[BX], DI            ; If it is too large, then return an error.
	JB   BadUserNumber
	SHL  DI, 1                  ; *2 for WORD index.
	LES  BX, prgwUNOwner        ; ES:BX points to rgwUNOwner
	MOV  CX, ES:[BX][DI]
	CMP  CX,lFreeUN             ; If the user number is un-allocated then
	JE   BadUserNumber          ; return an error.
	JMP  GoodUserNumber

BadUserNumber:
	MOV  AX,ercBadUserNum
;PUSH AX
;CALL Crash
	JMP  RespondToNewRequest1

GoodUserNumber:
; end allocated user number support

; Set up oUserTable to index UserTable entry by userNum.
	CALL GetUserTableIndexDX				;Returns with userTableIndex in DI
	TEST BYTE PTR utFlags[DI],fSetVerifyRqSent
	JNZ  TestUserNameSent
; We need to send a SetVerify request for this user. The SetVerify request is
; only used by masters older than 8.0, but we keep doing this for 
; compatibility.
	MOV  AX,DGroup
	MOV  CX,OFFSET DGROUP:rqSetVerify
	CALL GetRcb
RespondToNewRequest3:
	JAE   MoveTable
	JMP   RespondToNewRequest1
MoveTable:
	MOV  DI,oUserTable
	OR   BYTE PTR utFlags[DI],fSetVerifyRqSent
; Initialize Rcb to send SetVerify request for this user.
	INC  nWaitingRequests
PUBLIC TestUserNameSent
TestUserNameSent:
	TEST BYTE PTR utFlags[DI],fUserNameSent
	JNZ  TestTerminationRequest
%if(%ctosp)then(
	mov  ax, sgVirtualLowMem
	mov  es, ax
	mov  di, es:[atPParamBlock+2]   ; Is pAscb valid?
	verr di
 	jnz  TestTerminationRequest
	mov  ax, sgGdt
	mov  es, ax
	and  di, 0FFF8h
	test byte ptr es:[di+5], maskPresent		; Is saAscb present?
	jz   TestTerminationRequest
	mov  ax, sgVirtualLowMem
	mov  es, ax
	les  di, dword ptr es:[atPParamBlock]
)else(
	MOV  AX,sapASCB
	MOV  ES,AX
	LES  	DI,DWORD PTR ES:[0]
; ES:DI point to ASCB
)fi
	mov  ax, es
 	or   ax, ax   ; Is pAscb null?
 	jz   TestTerminationRequest
	ADD  DI,ascbUserName
	MOV  AL,ES:[DI]						;AL = size of userName in ASCB
	OR   AL,AL							;Has userName been set?
	JZ   TestTerminationRequest
	MOV  sUserName,AL					;Store size of userName
	INC  DI
	MOV  pUserName,DI
	MOV  pUserName+2,ES					;Store pointer to userName
	MOV  AX,DGroup
	MOV  CX,OFFSET DGROUP:rqSetUserName
	CALL GetRcb
	JC   RespondToNewRequest3
	MOV  DI,oUserTable
	OR   BYTE PTR utFlags[DI],fUserNameSent
	INC  nWaitingRequests

TestTerminationRequest:

;*PUBLIC TestTerminationRequest
;*; Check to see if this is a termination request.
;*	LES  DI,pRgTerminationRq
;*	MOV  CX,nTerminationRq
;*	MOV  AX,BP							;AX = request code
;*	REPNZ SCASW 
;*	MOV  DI,oUserTable
;*	MOV  CL,utFlags[DI]					;CL = utFlags
;*	JNE  TestTerminating				;Not a termination request
;*; This is a termination request. See if this is the first one in the list ;*that
;*; will be sent to us by the termination process. 
;*	XOR  AX,AX							;Set ercOk
;*	TEST CL,fClusterTermRqSent
;*; For each termination request after the first, we simply respond to it. We
;*; won't respond to the CloseAllFiles request until the ClusterTerm request
;*; returns. Note that if this is an old master that can handle only one
;*; termination request at a time, fClusterTermRqSent will not be set unless we
;*; did not send any requests to the master since the last termination.
;*	JZ   FirstTerminationRq
;*	JMP  RespondToNewRequest
;*FirstTerminationRq:
;*; If this termination request did not come from a system exchange, treat it
;*; like a normal request.
;*	LES  BX,pWsAgentMsg
;*	MOV  AX,ES:[BX+rqRespExch]
;*	CMP  AX,userExchFirst
;*	JAE  TestTerminating
;*; This is the first termination request. See if we have sent any requests to
;*; the master since the last termination. This optimization is not available
;*; for single-partition versions of the OS.
;*	CMP  fMulPar,0
;*	JE   TestMultipleTermination			;Single-partition OS
;*	TEST CL,fRqSentToMaster
;*	JZ   RespondToFirstTermRq				;We have not
;*TestMultipleTermination:
;*; We have sent requests other than GetDateTime to the master since the last
;*; termination request. See if the master can handle all of the termination
;*; requests at once.
;*	CMP  masterRevisionLevel,90h
;*	JA   SendMultipleTermination
;*; This master must handle termination requests one at a time. Check to see if
;*; this is a ResetAgent request.
;*	CMP  BP,rcResetAgent
;*	JE   HandleResetAgent
;*	JMP  QueueRequest
;*HandleResetAgent:
;*; Save pointer to termination request in UserTable entry so that we can
;*; respond to it when all the outstanding requests are in.
;*	LES  BX,pWsAgentMsg						;ES:BX point to new request
;*	MOV  utpTerminationRq[DI],BX
;*	MOV  utpTerminationRq+2[DI],ES
;*	CALL PurgeWaitingRequests
;*	MOV  DI,oUserTable
;*	CALL RespondToTerminationRq
;*	JC   RespondToNewRequest2
;*	JMP  HandleRequestRet
;*
;*SendMultipleTermination:
;*	PUSH DX									;Save user number
;*	CALL PurgeWaitingRequests
;*	POP  DX									;DX = user number
;*	JNC  QueueClusterTermRq
;*RespondToNewRequest2:
;*	JMP  RespondToNewRequest
;*QueueClusterTermRq:
;*; Queue a ClusterTerm request.
;*	MOV  AX,DGroup
;*	MOV  CX,OFFSET DGROUP:rqClusterTerm
;*	CALL GetRcb
;*	JC   RespondToNewRequest
;*; Increment the number of requests outstanding to include the ClusterTerm
;*; request. This is just one more request that we must wait for before we can
;*; respond to the last termination request.
;*	MOV  DI,oUserTable
;*	INC  BYTE PTR utnWaitingForReset[DI]
;*	INC  nWaitingRequests
;*	CALL MakeRgClusterTerm
;*RespondToFirstTermRq:
;*	MOV  DI,oUserTable
;*	OR   BYTE PTR utFlags[DI],fClusterTermRqSent
;*	XOR  AX,AX								;Set ercOk
;*	JMP  SHORT RespondToNewRequest			;Respond to first termination rq
;*
;*TestTerminating:
;*	LES  SI,pWsAgentMsg
;*; Come here if this is not a termination request.
;*; DI = oUserTable
;*; CL = utFlags
;*; DX = user number
;*; ES:SI point to client request.
;*	TEST CL,fClusterTermRqSent
;*	JZ   TestBeingTerminated
;*	CMP  BP,rcCloseAllFiles
;*;Don't return erc608. Hack so Vacated partitions are useable when re-created.
;*;	JNE  UserStillTerminating
;*	JE   Hack1
;*	AND  BYTE PTR utFlags[DI],0FFh - fClusterTermRqSent - fRqSentToMaster
;*	JMP  TestBeingTerminated
;*Hack1:
;*
;*; We are terminating and, this is a CloseAllFiles request. The CloseAllFiles
;*; request follows the last termination request. We are finished sending
;*; termination requests now.
;*	AND  BYTE PTR utFlags[DI],0FFh - fClusterTermRqSent - fRqSentToMaster
;*; Save pointer to CloseAllFiles request in the UserTable entry so that we can
;*; respond to it when all the outstanding requests are in.
;*	MOV  utpTerminationRq[DI],SI
;*	MOV  utpTerminationRq+2[DI],ES
;*; If all outstanding requests have returned (including the ClusterTerm
;*; request), we can respond to the CloseAllFiles request.
;*	CALL RespondToTerminationRq
;*	JMP  HandleRequestRet
;*
;*TestBeingTerminated:
;*; ES:SI point to client request.
;*; DX = user number
;*	CMP  BYTE PTR utnWaitingForReset[DI],0
;*	JE   QueueRequest
;*UserStillTerminating:
;*; We should not receive any more user requests until the user has finished
;*; terminating. 
;*	MOV  AX,ES:[SI+rqRespExch]
;*	CMP  AX,userExchFirst
;*	JB   QueueRequest	
;*	CMP  fMulPar,0
;*	JNE  RefuseRequestsWhileTerminating
;*; If this is a SinglePartition system, we could receive requests from system
;*; services. All users have the same number.
;*	CALL FSysRequest
;*	JNZ  QueueRequest					;Jump if system request
;*RefuseRequestsWhileTerminating:
;*; If a task is terminating, another process that belongs to the same task
;*; (such as the Executive's Timer task) could still send us requests. Refuse
;*; them until the 	user has finished terminating.
;*	MOV  AX,ercBeingReset
;*	JMP  SHORT RespondToNewRequest

QueueRequest:
PUBLIC QueueRequest
; Queue request to send to the master.
; BP contains rqCode. If any request other than GetDateTime gets sent to the
; master, set fRqSentToMaster. This will cause us to send termination requests
; to the master when the user terminates.
;*	CMP  BP,rcGetDateTime
;*	JE   GetRcbForNewRequest
	PUSH DI	;oUserTable
	LES  DI,prgRqNoRemoteTermination
	MOV  CX,nRqNoRemoteTermination
	MOV  AX,BP
	CLD
	REPNE SCASW
	POP	 DI
	JE   GetRcbForNewRequest	
	MOV  DI,oUserTable	;request requires user to be terminated at master
	OR   BYTE PTR utFlags[DI],fRqSentToMaster
GetRcbForNewRequest:
	MOV  AX,WORD PTR pWsAgentMsg+2
	MOV  CX,WORD PTR pWsAgentMsg
	CALL GetRcb
	JC   RespondToNewRequest
	INC  nWaitingRequests
	JMP  SHORT HandleRequestRet
RespondToNewRequest:
PUBLIC RespondToNewRequest
	LES  BX,pWsAgentMsg						;ES:BX point to new request
	MOV  ES:[BX+rqErcRet],AX
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  DI,logRqBufferIndex
	ADD  DI,logRqEntrySize
	CMP  DI,logRqBufferIndexMax
	JBE  logRqBufferIndexOk1
	MOV  DI,0
logRqBufferIndexOk1:
	MOV  logRqBufferIndex,DI
	MOV  logRqPoint[DI],2   ;Request responded to without being queued
	MOV  logRqErcRet[DI],AX
	MOV  AX,ES:[BX+rqCode]
	MOV  logRqCode[DI],AX
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	PUSH ES
	PUSH BX
	CALL KRespond
HandleRequestRet:
PUBLIC HandleRequestRet
	CALL PrepareRequest				; Fill XBlocks for new rcbs, if possible.

%IF (%VerifyWaitingRequests) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	CALL VerifyWaitingRequests
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	POP  BP
	RET
HandleRequest ENDP

;*MakeRgClusterTerm PROC NEAR
;*PUBLIC MakeRgClusterTerm
;*;****************************************************************************;**		
;*; Build list of termination requests that are routed to the WsAgent. We must
;*; build the list each time because a ServeRq could change the exchange served
;*; by a request.
;*;****************************************************************************;**		
;*	LES  DI,pRgTerminationRq
;*	MOV  CX,nTerminationRq
;*	XOR  SI,SI					;SI = word index of rgTermRq
;*TestTermRqExchange:
;*	MOV  AX,ES:[DI]				;AX = next term rq code
;*	CMP  AX,rcResetAgent
;*	JE   TestNextTermRq
;*	PUSH ES						;Save pointer to next rgTerminationRq
;*	PUSH SI						;Save index of rgTermRq
;*	PUSH AX						;SAVE rqCode
;*	CALL GetRqLevel				;on return, SI = word index of level
;*	SHL  SI,1					;SI is level index of ptr array
;*	LES  BX,rgPrgRqExchg[SI]	;ES:BX = rgPrgRqExchg(level)
;*	MOV  SI,AX					;SI=rqCode-level
;*	CMP  BYTE PTR ES:[BX][SI],exchAgent
;*	POP  AX						;restore rqCode with level
;*	POP  SI						;SI is index of rgClusterTerm
;*	POP  ES						;ES:DI points to current rgTerminationRq
;*	JNE  TestNextTermRq
;*; This request code gets routed to the Agent, so put it in rgClusterTerm
;*	MOV  BX,oRgClusterTerm
;*	MOV  [BX][SI],AX
;*	INC  SI
;*	INC  SI						;SI is word index of next rgClusterTerm
;*TestNextTermRq:
;*	INC  DI        				;DI is word index of rgTerminationRq
;*	INC  DI
;*	LOOP TestTermRqExchange
;*	MOV  sTermRqCode,SI			;save size in ClusterTerm request
;*	RET
;*MakeRgClusterTerm ENDP

GetRcb PROC NEAR
PUBLIC GetRcb
;*****************************************************************************
; DX has user number
; AX:CX has pointer to request
; Unchain an Rcb from the free list, initialize it, and chain it onto the
; waiting list.
; On return, BX points to the new rcb.
; If no rcb is available, the carry flag is set on return, and ercAgentNoRoom
; is in AX
;*****************************************************************************
	MOV  BX,rcbAvailHead
	CMP  BX,OFFSET DGROUP:rcbAvailHead
	JNE  RcbAvailable
; Check to see if rcbs have been initialized.
	CMP  oRcbLast,0
	JNE  RcbNotAvailable
; Initialize queue of rcbs.
	PUSH AX
	PUSH ES
	PUSH CX
	PUSH DI
	PUSH DS
	POP  ES
	MOV  DI,oRcbFirst				;ES:DI points to first rcb
	MOV  AX,RcbSize
	MUL  cRcbMax					;AX = rcbSize * cRcbMax
	MOV  CX,AX						;CX = size of rcb array
	SHR  CX,1						;in words
	XOR  AX,AX
	CLD
	REPNZ STOSW
	MOV  CX,cRcbMax
	MOV  DI,BX						;DI = OFFSET rcbAvailHead
	MOV  BX,oRcbFirst
	MOV  rcbAvailHead,BX
RcbInit:
	MOV  rcbPrev[BX],DI				;Set prev pointer
	LEA  AX,rcbSize[BX]				;AX points to next rcb
	MOV  rcbNext[BX],AX				;Set next pointer
	MOV  DI,BX						;DI points to prev rcb
	MOV  BX,AX						;BX points to next rcb
	LOOP RcbInit
; Set prev pointer of last rcb to point to head of list
	LEA  AX,rcbAvailHead
	MOV  rcbNext[DI],AX
	MOV  oRcbLast,DI					;Save pointer to last rcb
	MOV  rcbAvailTail,DI
	POP  DI
	POP  CX
	POP  ES
	POP  AX
	JMP  GetRcb
RcbNotAvailable:
	MOV  AX,ercAgentNoRoom
	STC
	RET
RcbAvailable:
	MOV  rcbsaRq,AX					;Initialize Sa of request
	MOV  rcbraRq,CX					;Initialize Ra of request
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  DI,logRqBufferIndex
	ADD  DI,logRqEntrySize
	CMP  DI,logRqBufferIndexMax
	JBE  logRqBufferIndexOk2
	MOV  DI,0
logRqBufferIndexOk2:
	MOV  logRqBufferIndex,DI
	MOV  logRqPoint[DI],3 			;Request queued
	PUSH ES
	PUSH BX
	MOV  ES,AX
	MOV  BX,CX
	MOV  AX,ES:[rqCode+BX]
	MOV  logRqCode[DI],AX
	POP  BX
	POP  ES
	MOV  logRqoRcb[DI],BX
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	CALL UnchainRcb
	MOV  DI,rcbWaitingTail
	CALL ChainRcb
	MOV  AX,rqClock
	MOV  rcbRqStartTime,AX
	XOR  AX,AX
	MOV  rcbFlags,AL
	MOV  rcbErcRet,AX
	MOV  rcbsBufOutTotal,AX
	MOV  rcboCf,AX
	MOV  rcbsBufInTotal,AX
	MOV  rcbSaXBlock,AX
	MOV  rcbState,stateWaitingForXmit
	MOV  rcbUserNum,DX
	MOV  rcbnOutstanding,1
	RET
GetRcb ENDP

;*PurgeWaitingRequests PROC NEAR
;*PUBLIC PurgeWaitingRequests
;*****************************************************************************		
; pWsAgentMsg points to termination request.
; DI and oUserTable have index of UserTable entry.
; DX has user number.
; We must do something with all the non-sys requests that are waiting. For
; requests that have not yet been transmitted, we can Respond to them and take
; them off the waiting list. For requests that have already been transmitted,
; we will have to mark them "reset" and wait for them to be returned from the
; Master. Return with carry set if error.
;*****************************************************************************		
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;*	PUSH DI
;*	MOV  SI,oRcbFirst
;*	LEA  DI,logTermRcbBuffer
;*	PUSH DS
;*	POP  ES
;*	MOV  CX,sRcbBuffer/2
;*	REPNZ MOVSW
;*	MOV  AX,rcbWaitingHead
;*	MOV  logTermRcbHead,AX
;*	POP  DI
)FI ;*;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;*	MOV  AX,ercBeingReset
;*	CMP  BYTE PTR utnWaitingForReset[DI],0
; If this user is already being reset, or if there is no rcb available, return
; with Carry set and erc in AX.
;*	JNE  PurgeErrorRet
;*	MOV  AX,ercAgentNoRoom
;*	MOV  BX,rcbWaitingHead
;*	CMP  rcbAvailHead,OFFSET DGROUP: rcbAvailHead
;*	JNE  TestLastWaitingRequest
;*PurgeErrorRet:
;*	STC
;*	RET
;*NextWaitingRequest:
;*	MOV  BX,rcbNext[BX]
;*TestLastWaitingRequest:
;*	CMP  BX,OFFSET DGROUP:rcbWaitingHead
;*	JNE  PurgeNext
;*	JMP  WaitingRequestsPurged
;*PurgeNext:
; BX points to the next waiting rcb. Load ES:SI to point to the client request
; associated with the rcb to see if this is a request to be purged.
;*	LES  SI,rcbpRq
; ES:SI point to queued client request.
;*	CMP  WORD PTR ES:[SI+rqCode],rcResetAgent
;*	JE   NextWaitingRequest				;Don't purge ResetAgent requests
;*	CMP  fMulPar,0
;*	JE   TestUserSinglePartition
;*	CMP  ES:[SI+rqUserNum],DX			;DX = userNumber
;*	JMP  SHORT TestPurge
;*TestUserSinglePartition:
;*	CALL FSysRequest
;*TestPurge:
;*	JNZ  NextWaitingRequest
;*
;*PurgeWaitingRequest:
;*PUBLIC PurgeWaitingRequest
;*; BX points to an rcb that we must purge.
;*	CMP  rcbState,stateInXmit
;*	JNE  RespondToWaitingRequest
; The rcb has already been sent to the master. If no pieces are outstanding,
; we can respond to this request, otherwise we must wait for all pieces to
; return from the master.
;*	CMP  rcbnOutstanding,0
;*	JE   	RespondToWaitingRequest
;*	MOV  rcbState,stateReset
;*	MOV  DI,oUserTable
;*	INC  BYTE PTR utnWaitingForReset[DI]
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;*	MOV  DI,logRqBufferIndex
;*	ADD  DI,logRqEntrySize
;*	CMP  DI,logRqBufferIndexMax
;*	JBE  logRqBufferIndexOk5
;*	MOV  DI,0
;*logRqBufferIndexOk5:
;*	MOV  logRqBufferIndex,DI
;*	MOV  logRqPoint[DI],8  		 ;Request Reset
;*	MOV  logRqoRcb[DI],BX
;*	PUSH BX
;*	LES  BX,rcbpRq
;*	MOV  AX,ES:[BX+rqCode]
;*	MOV  logRqCode[DI],AX
;*	POP  BX
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
; If this is a piecemeal request, we have not decremented nWaitingRequests
; unless the last piece has been sent. See if we need to decrement
; nWaitingRequests.
;*	TEST rcbFlags,rcbfPiecemeal			;Is it a piecemeal request?
;*	JZ   NextWaitingRequest				;No
;*	TEST rcbFlags,rcbFinishedSending	;Have we finished sending?
;*	JNZ  NextWaitingRequest				;Yes
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;*	OR   rcbFlags,rcbFinishedSending	;for check in RespondToRcb
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;*	DEC  nWaitingRequests
;*	JMP  NextWaitingRequest
;*RespondToWaitingRequest:
; This request is queued and has not been sent yet, so we can simply respond
; to the client, dequeue the request, and decrement nWaitingRequests.
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;*	MOV  DI,logRqBufferIndex
;*	ADD  DI,logRqEntrySize
;*	CMP  DI,logRqBufferIndexMax
;*	JBE  logRqBufferIndexOk6
;*	MOV  DI,0
;*logRqBufferIndexOk6:
;*	MOV  logRqBufferIndex,DI
;*	MOV  logRqPoint[DI],8  				;Request Purged
;*	MOV  logRqoRcb[DI],BX
;*	PUSH BX
;*	LES  BX,rcbpRq
;*	MOV  AX,ES:[BX+rqCode]
;*	MOV  logRqCode[DI],AX
;*	POP  BX
;*	LES  SI,pWsAgentMsg					;ES:SI point to termination request
;*	MOV  AX,ES:[rqFh+SI]				;AX = fh from termination request
;*	MOV  logRqErcRet[DI],AX
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;*	LES  SI,pWsAgentMsg					;ES:SI point to termination request
;*	MOV  AX,ES:[rqFh+SI]				;AX = fh from termination request
;*	PUSH DX								;Save userNumber
;*	CALL RespondToRcb
;*	POP  DX								;Restore userNumber
;*	DEC  nWaitingRequests
;*	JMP  TestLastWaitingRequest			;BX = address of next waiting rcb
;*WaitingRequestsPurged:
;*ResetAgentRet:
;*	CLC									;Turn off carry for good exit
;*	RET
;*PurgeWaitingRequests ENDP
;*RespondToTerminationRq PROC NEAR
;*PUBLIC RespondToTerminationRq
;*****************************************************************************		
; DI and oUserTable have index of UserTable entry.
; utpTerminationRq points to the termination request we wish to respond to.
; We can respond only if we are not waiting for any client requests to return.
;*****************************************************************************		
;*	CMP  BYTE PTR utnWaitingForReset[DI],0
; See if we will have to wait for the requests to come in before we can
; respond to this request. 
;*	JNE  RespondToTerminationRqRet
; All outstanding requests have returned. It is possible that the ClusterTerm
; request could return before we receive the CloseAllFiles request. In this
; case, there is not yet a termination request to respond to.
;*	XOR  AX,AX
;*	XCHG AX,utpTerminationRq[DI+2]
;*	OR   AX,AX
;*	JZ   RespondToTerminationRqRet
;*	PUSH AX
;*	PUSH utpTerminationRq[DI]
;*	CALL KRespond
;*RespondToTerminationRqRet:
;*	RET
;*RespondToTerminationRq ENDP
HandleResponse PROC NEAR
PUBLIC HandleResponse
;*****************************************************************************
; ES points to a list of XBlocks that contains a new response to a request
; that we sent to the Master.
; AX contains msgLph.
;*****************************************************************************
	PUSH BP
	MOV  BP,SP
saRespXBlock   EQU WORD PTR [BP-2]
oRcb           EQU WORD PTR [BP-4]
pRq            EQU DWORD PTR[BP-8]
raRq           EQU WORD PTR[BP-8]
saRq           EQU WORD PTR[BP-6]
oClientPbCb    EQU WORD PTR[BP-10]
oBufPbCb       EQU WORD PTR[BP-12]
nRespToMove    EQU BYTE PTR[BP-14]
cbSent         EQU WORD PTR[BP-16]
sHandleResponseVariables EQU 16

	SUB  SP,sHandleResponseVariables
	MOV  saRespXBlock,ES				;Save address of XBlock
; Get count of bytes transferred from the first word of data.
; Get oRcb from response exchange of request.
	MOV  AX,ES:[xbCbDataSent]
	MOV  BX,ES:[xbRqRespExch]
	MOV  cbSent,AX						;Save count actually transferred
	MOV  oRcb,BX						;Save pointer to rcb
	DEC  rcbnOutstanding
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  DI,logRqBufferIndex
	ADD  DI,logRqEntrySize
	CMP  DI,logRqBufferIndexMax
	JBE  logRqBufferIndexOk3
	MOV  DI,0
logRqBufferIndexOk3:
	MOV  logRqBufferIndex,DI
	MOV  logRqPoint[DI],6   			;Request responded to
	MOV  AX,ES:[xbRqErcRet]
	MOV  logRqErcRet[DI],AX
	LES  SI,rcbPrq						;ES:SI point to client rq
	MOV  AX,ES:[rqCode+SI]
	MOV  logRqCode[DI],AX
	MOV  logRqoRcb[DI],BX
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	CMP  rcbState,stateReset			;Has this rcb already been reset?
	JE   SendResponse1
	LES  DI,rcbPrq						;ES:DI point to client rq
	MOV  saRq,ES						;Save pointer to client rq
	MOV  raRq,DI
	CMP  WORD PTR ES:[DI+rqCode],rcSetVerify
;*	JNE  TestClusterTerm
;*	JNE  HandleClientResponse
	JNE  TestRemoteTerm
SendResponse1:
; This is a SetVerify request that returned or a request that
; has already been responded to. Dequeue rcb.
	JMP  SendResponse

TestRemoteTerm:
	CMP  WORD PTR ES:[DI+rqCode],rcRemoteTermination
	JNE  HandleClientResponse
HandleRemoteTerm:
; Jim Frandeen: 4/16/91
; This is a response to a RemoteTermination request.  Check to see if
; there are any other requests for this user in the rcb queue.  This would 
; leave an rcb in our queue with a pointer to a request that will eventually 
; be discarded by the OS. This would cause us trouble (GP fault) later on if 
; we tried to access rcbpRq, and the saRq has been recycled.
; This could happen if a server did not serve a termination request.  
; It can also happen on a file system request because the file system 
; termination (CloseAllFiles) goes out after the RemoteTermination request.
	MOV  CX,rcbUserNum					;CX has userNum being terminated
	MOV  BX,rcbWaitingHead
TestRemoteLast:
	CMP  BX,OFFSET DGROUP:rcbWaitingHead
	JE   TestRemoteTermDone
	CMP  BX,oRcb						;Is this rcb of RemoteTerm request?
	JE   TestRemoteNext					;Yes
	CMP  rcbState,stateReset			;Has this rcb already been reset?
	JE   TestRemoteNext					;Yes
	CMP  CX,rcbUserNum					;Is this the user being terminated?
	JNE  TestRemoteNext					;No
; We found one!
	LES  DI,rcbpRq
	MOV  WORD PTR ES:[rqErcRet+DI],ercPartitionTerminating
	INC  cRespondBeforeRcb				;Leave a mark on the wall
; Set state in the rcb to reset.  This lets us know we have already responded
; to the request.  If and when a response comes back from the master, we will
; free the rcb.
	MOV  rcbState,stateReset
; Save the request code in the ra portion of the pRq field.  If we get a
; lot of reset rcbs that never get responded to, this will give us a clue
; as to what server is not responding to termination requests.
	MOV  AX,ES:[DI+rqCode]				;AX = request code
	MOV  WORD PTR rcbpRq,AX
	MOV  WORD PTR rcbpRq+2,0
	PUSH BX								;Save offset of current rcb
	PUSH CX								;Save userNum being terminated
; Respond to the request.
	PUSH ES								;sa of rq for respond
	PUSH DI								;ra of rq for respond
	CALL KRespond
	POP  CX								;CX has userNum being terminated
	POP  BX								;BX points to rcb just terminated
	
TestRemoteNext:
	MOV  BX,rcbNext[BX]
	JMP  TestRemoteLast
TestRemoteTermDone:
	MOV  BX,oRcb						;BX points to rcb of remote term
	LES  DI,rcbpRq						;ES:DI points to remote term rq
	MOV  AX,WORD PTR ES:[rqErcRet+DI]
	JMP  SendResponse					;AX has ercRet of RemoteTerm


;*TestClusterTerm:
;*	CMP  WORD PTR ES:[DI+rqCode],rcResetAgent
;*	JNE  HandleClientResponse
;*HandleClusterTermResponse:
;*PUBLIC HandleClusterTermResponse
;*; This is a ClusterTerm request that has returned.
;*; Set up oUserTable to index UserTable entry by userNum.
;*	CALL GetUserTableIndex				;Returns with userTableIndex in DI
;*; Decrement the number of requests we must wait for before we can respond to
;*; the last termination request (the CloseAllFiles request).
;*	DEC  BYTE PTR utnWaitingForReset[DI]
;*; Respond to the CloseAllFiles request if we have received it.
;*	CALL RespondToTerminationRq
;*	JMP  SendResponse					;Dequeue ClusterTerm response
HandleClientResponse:
PUBLIC HandleClientResponse
; This is not a SetVerify or ClusterTerm request that returned.
; ES:DI point to client rq associated with this rcb.
	CMP  rcbState,stateInXmit
	JE   CheckPiecemeal
;*	CMP  rcbState,stateReset
;*	JE   ResetRqReturned
; If the state is not inXmit or reset, then we were not expecting this rcb.
	MOV  AX,ercInconsistency
	PUSH AX
	CALL Crash

;*ResetRqReturned:
;*PUBLIC ResetRqReturned
; This user is being terminated, and we were waiting for this request to
; return. If this is the last outstanding piece, we can respond to this
; request.
;*	CMP  rcbnOutstanding,0
;*	JNE  HandleResponseRet1
;*	MOV  ES,saRespXBlock
%IF (%Iws) THEN (
;*	MOV  AL,ES:[xbRqErcRet]
;*	MOV  AH,ES:[xbRqErcRet+2]				;AX = ercRet
) ELSE (
;*	MOV  AX,ES:[xbRqErcRet]					;AX = ercRet
)FI
;*	CALL GetUserTableIndex
;*	CALL RespondToRcb						;First, respond to client
;*	MOV  DI,oUserTable
;*	DEC  BYTE PTR utnWaitingForReset[DI]
; If all outstanding requests have been responded to, so we can respond to the
; termination request.
;*	CALL RespondToTerminationRq
;*HandleResponseRet1:
;*	JMP  HandleResponseRet

CheckPiecemeal:
; This is not a SetVerify or ClusterTerm request that returned, and the user
; is not terminating.
; ES:DI point to client rq associated with this rcb.
	TEST rcbFlags,rcbfPiecemeal
	JNZ  HandlePiecemealResponse
	JMP  HandleSimpleResponse
HandlePiecemealResponse:
PUBLIC HandlePiecemealResponse
	MOV  ES,saRespXBlock
	MOV  BX,oRcb
%IF (%AgentCache) THEN (
	TEST rcbFlags,rcbCached
	JZ   GetsDataRet
	CALL AgentCacheData					; BX=oRcb, ES=saXBlock
	MOV  ES,saRespXBlock
	MOV  BX,oRcb
GetsDataRet:
)FI%'
; ES points to XBlock that contains request.
; BX points to rcb.
; Get the count of data actually transferred. The psDataRet pointer of the rq
; in the buffer contains the offset of the sDataRet field from cbDataSent.
	MOV  DI,ES:[xbRqpsDataRet]			;DI = byte index in buffer of count
	MOV  CX,ES:[xbCbDataSent+DI]		;CX = count of data transferred
; ES points to XBlock that contains request.
; BX points to rcb.
; CX is sDataRet
	LDS  SI,rcbpRq						;DS:SI point to client rq
	MOV  DX,[SI+rqsBuf]					;DX = total bytes to transfer
; DS:SI point to client request.
; We know that for a Read there is no request data.
; For a Write, there is request data.
	CMP  BYTE PTR [SI+rqnReqPbCb],0		;Is this a read request?
	JE   HandlePiecemealReadResponse	; Yes
; Write
; Increment sBufInTotal by the count of data transferred.
	ADD  SS:rcbsBufInTotal, CX
	JMP  GetErcReturned

%IF (%AgentCache) THEN (
CachedDataReturnedOk PROC NEAR
	PUSH BP
	MOV  BP,SP
	SUB  SP, 4
	MOV  saRespXBlock, ES
	MOV  oRcb, BX
	DEC  rcbnOutstanding
	MOV  CX, AX
	LDS  SI, rcbpRq
; DS:SI point to client rq
; ES points to XBlock
; BX has pointer to rcb
; CX has count of data transferred.
	JMP  Short CalculateDeltaLfa
CachedDataReturnedOk ENDP

UnlockFinished PROC NEAR
	PUSH BP
	MOV  BP,SP
	SUB  SP, 4
	MOV  saRespXBlock, ES
	MOV  oRcb, BX
	XOR  AX, AX
; ES points to XBlock
; BX has pointer to rcb
; AX is erc
	JMP  SendResponse
UnlockFinished ENDP
)FI%'

GetErcReturnedJmp:
	JMP  GetErcReturnedJmp

HandlePiecemealReadResponse:
PUBLIC HandlePiecemealReadResponse
ReadDataReturnedOk:
PUBLIC ReadDataReturnedOk
; A read request has returned.
; ES points to XBlock that contains request.
; DS:SI point to client request.
; BX points to rcb.
; CX has count of data transferred.

; Calculate address to move from. The pBuf field in the buffer has the offset
; of the data from xbCbDataSent in the buffer.
	MOV  AX, saRespXBlock					;Data from xBlock
	MOV  ES:[xbRqpBuf+2], AX
	ADD  ES:WORD PTR[xbRqpBuf],xbCbDataSent	;byte index in buffer of data

CalculateDeltaLfa:
; DS:SI point to client rq
; ES points to XBlock
; BX has pointer to rcb
; CX has count of data transferred.
; Calculate address to move to. This is the sum of the pBuf in the client rq
; plus (response.lfa - clientRq.lfa)

	MOV  AX,ES:[xbrqLfa]				;AX = response.lfaLow
	MOV  DX,ES:[xbrqLfa+2]				;DX = response.lfaHigh
	SUB  AX,[SI+rqLfa]					;Subtract clientRq.lfa
	SBB  DX,[SI+rqLfa+2]
%IF (NOT %AgentCache) THEN (
	JZ   UpdatepBuf
; We cannot transfer more than 64K bytes. Then AX:DX cannot be more than 64K.
	MOV  AX,ercInconsistency
	PUSH AX
	CALL Crash

) ELSE (%' AgentCache
; User rq four cases
;  1: xfer starts in middle of block, spans to next block      |..XXXXXX|
;  2: xfer starts in middle of block, ends in middle of block  |..XXX...|
;  3: xfer starts aligned with block, spans to next block      |XXXXXXXX|
;  4: xfer starts aligned with block, ends in middle of block  |XXXXX...|
; In cases 2 and 4, may have ercEom.
; In case of reading from cache, ercEom set, sDataRet reduced (perhaps 0).
; Adjust xb.pBuf, ibUserBuf(AX), sDataRet(CX) per user request.
; Set or clear rcbfUserEom.
; DX is fCase1or2
	PUSH DX
; If sDataRet exceeds user request, trim.
	MOV  DI, AX
	ADD  DI, CX						; dLfaStartBlock+sDataRet=dLfaEndBlock
	ADC  DX, 0						; DX=0,1 or 0FFFFh
	JS   NothingGained				; case 2, eof before any needed data
	JNZ  Adjust						; >=64k xfer, last block, case 4
									; (cache block xfer rounds up to/past 64k)
; can't do SUB here, previous JZ would skip it.
	CMP  DI, [SI+rqsBuf]			; dLfaEndBlock >= cbDesired ?
	JAE  Adjust						; Block extends beyond that requested
;  Less available than requested.  If not a full block, generate ercEom.
	MOV  DI, [SI+rqsBuf]			; Need whole block, none extra.
	CMP  CX, SS:sAgentCacheBlock
	JE   Adjust						; Not the last piece, more to come. Case1,3
	OR   SS:rcbFlags,rcbfUserEom	; Generate ercEom.

Adjust:
	SUB  DI, [SI+rqsBuf]			; dLfaEndBlock - cbDesired = cbExtra
	SUB  CX, DI						; Trim any excess xfer.
	POP  DX
; AX is ibUserBuffer
; CX is sDataRet
; DX is fCase1or2

; If cases 3,4 skip buffer-start adjustment.
	OR   DX, DX
	JZ   UpdatepBuf

; Cases 1,2
; 1st piece of non-aligned xfer yields negative user buffer index.
; Skip over uninteresting part.
	SUB  ES:[xbRqpBuf], AX			; oBufferData - (-cbUninteresting)
	ADD  CX, AX						; sDataRet-cbUninteresting
	JNS  AdjustStart				; Careful - flags after ADD different
NothingGained:
; CX (sDataRet) wasn't even large enough to get past uninteresting stuff.
; Nothing in this buffer user wants.
	XOR  CX, CX
AdjustStart:
	XOR  AX, AX						; Start of user buffer
)FI%'

UpdatepBuf:
; DS:SI point to client rq
; ES points to XBlock
; BX has pointer to rcb
; AX=ibUserBuffer
; CX=sDataXfer

	MOV  DI,[SI+rqpBuf]
; Add AX to the pointer in ES:DI to give us the pointer to the next byte of
; data in the client's input buffer so we can move the data. 
	ADD  DI,AX
	MOV  AX,[SI+rqpBuf+2]			;AX:DI point to clientRq.pBuf
	LDS  SI,ES:DWORD PTR[xbRqpBuf]	;DS:SI point to data to move
	MOV  ES,AX						;ES:DI point to clientRq.pBuf
; DS:SI point to data to move
; ES:DI contain clientRq.pBuf
; BX has pointer to rcb
; CX has count of data transferred.
	ADD  SS:rcbsBufInTotal, CX
	OR   AX, AX						; If user pBuf.sa = 0, don't move bytes.
	JZ   GetErcReturned				; Probably LockInCache request.
	%MOVGOOD
GetErcReturned:
; Save the erc if it is greater than the erc we already have. This permits us
; to save the most important erc for piecemeal requests. For example, if we
; get a read error for one piece, we don't want to return EOM on the last
; piece.
	PUSH SS
	POP  DS
ASSUME DS:DGroup
	MOV  ES,saRespXBlock
; DS points to DGroup
; ES points to XBlock
; BX points to rcb
	MOV  AX,ES:[xbRqErcRet]					;AX = erc returned in request
	CMP  AX,rcbErcRet
	JBE  TestEomReturned
SaveErcReturned:
	MOV  rcbErcRet,AX
TestEomReturned:
	CMP  AX,ercEom
	JNE  TestAllPiecesSent
; We got EOM on the last piece, so quit sending pieces.
	TEST rcbFlags,rcbfEom					;Is this the first EOM?
	JNZ  TestAllPiecesReturned				;no
	OR   rcbFlags,rcbfEom
; Decrement nWaitingRequests if we have not already done so when we sent the
; last piece.
	TEST rcbFlags,rcbFinishedSending
	JNZ  TestAllPiecesReturned								
	DEC  nWaitingRequests
	JMP  SHORT TestAllPiecesReturned
TestAllPiecesSent:
PUBLIC TestAllPiecesSent
	TEST rcbFlags,rcbFinishedSending+rcbfEom
	JZ   HandleResponseRet2				;All pieces not sent yet
TestAllPiecesReturned:
	CMP  rcbnOutstanding,0
	JE   PiecemealRequestFinished		;All pieces not returned yet
HandleResponseRet2:
	JMP  HandleResponseRet				;All pieces not returned yet
PiecemealRequestFinished:
; The piecemeal request has finished.  Store the total bytes transferred in the
; client's sDataRet field.
%IF (%AgentCache) THEN (
	TEST rcbFlags,rcbCached
	JZ   KeepRcbErc
; Since block reads may get ercEom when user read didn't pass eof,
; coerce rcbErcRet if it isn't something bad.
	CMP  rcbErcRet,ercOk
	JE   TestSetEom
	CMP  rcbErcRet,ercEom
	JNE  KeepRcbErc
TestSetEom:
	MOV  rcbErcRet,ercOk
	TEST rcbFlags,rcbfUserEom
	JZ   KeepRcbErc
	MOV  rcbErcRet,ercEom
KeepRcbErc:
)FI%'
	MOV  CX,rcbsBufInTotal
	MOV  AX,rcbErcRet
	LDS  SI,rcbPrq						;DS:SI point to client rq
	CMP  WORD PTR [SI+rqssDataRet], 0	;Check for nil ssDataRet
	JE   SendResponseJmp				;AX contains ercRet
	LDS  SI,DWORD PTR [SI+rqpsDataRet]	;DS:SI point to client sDataRet field
	MOV  [SI],CX						;Store total bytes transferred
SendResponseJmp:
	JMP  SendResponse					;AX contains ercRet
HandleSimpleResponse:
PUBLIC HandleSimpleResponse
; ES:DI point to client rq associated with this rcb.
%IF (%AgentCache) THEN (
;BX is oRcb
; ChangeFileLength or SetFileStatus complete?  Update cf.
	TEST rcbFlags,rcbChangeLength
	JZ   ACNotChangeLength
	MOV  SI, rcboCf
	OR   SI, SI
	JZ   ACNotChangeLength
	MOV  CX, ES:[DI+rqCode]				; save for below
	MOV  ES, WORD PTR pCachedFiles+2	; undo half the writelock
	DEC  ES:cfcWriteLock[SI]			; RespondToRcb will undo other half
	PUSH DS
	MOV  DS,saRespXBlock
ASSUME DS:Nothing
	MOV  EDX,DS:[xbrqLfa]					; save for below
	CMP  DS:WORD PTR [xbRqErcRet],ercOk
	POP  DS
ASSUME DS:DGroup
	JNE  ACCLCleanup
	CMP  CX, rcChangeFileLength
	JE   ACChangeLength
; SetFileStatus ercOk.  Record cfLfaFlags.cfLfa30Bit
	CMP  DX, 17			; SetFileStatus(17) means lfas 32 bit
	JNE  ACCLCleanup
	AND  ES:cfLfaFlags[SI], NOT cfLfa30Bit
	JMP  ACCLCleanup
ACChangeLength:
; If cfLfaLast <> F's then update
	TEST ES:cfLfaFlags[SI], cfLfaInvalid
	JNZ  ACCLCleanup
	MOV  DL, ES:cfLfaFlags[SI]	; preserve cfLfa flags
	MOV  ES:cfLfaLast[SI], EDX
ACCLCleanup:
	MOV  ES,saRq
ACNotChangeLength:
)FI%'
; Calculate address of first response pb/cb pair.
	MOV  CX,ES:[DI+rqnReqPbCb]			;CL = nReqPbCb, CH = nRespPbCb
	MOV  nRespToMove,CH
	MOV  AL,6
	MUL  CL								;AX = 6*nReqPbCb
	ADD  AL,ES:[DI]						;AX = 6*nReqPbCb + sCntlInfo
	ADD  AL,12							;AX = 6*nReqPbCb + sCntlInfo + 12
	ADD  DI,AX							;ES:DI point to first response pb/cb
	MOV  SI,AX
	ADD  SI,xbRq						;SI indexes first pb/cb in buffer
%IF (%AgentCache) THEN (
;ES:DI point to 1st rq resp pbcb
;SI indexes 1st buffer resp pbcb
;BX is oRcb
; If OpenFh request, if ercOk, then register fh in cachedFile structure.
; If CloseFh request, if ercOk, then unregister fh.
; If CloseAllFiles request, if ercOk, then unregister all fh for user.
	TEST rcbFlags,rcbOpenClose
	JZ   TestLastResponsePair
	MOV  DS,saRespXBlock				;DS:SI point to first pb/cb in buffer
ASSUME DS:Nothing

	PUSH DI
	PUSH SI
	MOV  AX, SS:rcbUserNum

	TEST SS:rcbFlags,rcbCloseFh
	JNZ  DoACUH
	MOV  CX,ES:[DI+4]					;rq.sdFhRet.cb
	MOV  DS:[SI+4],CX					;buffer.sdFhRet.cb
	CMP  DS:WORD PTR [xbRqErcRet],ercOk
	JNE  ACCleanup
	CALL AgentCacheRegisterHandle		;(DS:SI=psdFhRet, AX=userNum)
	JMP  Short ACCleanup

DoACUH:
	CMP  DS:WORD PTR [xbRqErcRet],ercOk
	JNE  ACCleanup
	MOV  CX, DS:[xbrqFh]
	TEST SS:rcbFlags, rcbCloseAll XOR rcbCloseFh	; CloseAll?
	JZ   CallACUH
	XOR  CX, CX							; Close all handles
CallACUH:
	CALL AgentCacheUnregisterHandle		;(CX=fhClose, AX=userNum)

ACCleanup:
	POP  SI
	POP  DI
	MOV  ES,saRq

)FI%'
TestLastResponsePair:
	CMP  nRespToMove,0					;Are we finished moving response data?
	JE   GetErcRet
	MOV  DS,saRespXBlock				;DS:SI point to first pb/cb in buffer
	MOV  oClientPbCb,DI					;Save address of next pb/cb pair
	MOV  oBufPbCb,SI					;Save offset of next buffer pb/cb
; DS:SI point to next response pb/cb pair of buffer
; ES:DI point to next response pb/cb pair in client rq
; Get the index of the next response data in the buffer from the next pb in 
; the buffer.
; Get the count of the number of characters from the cb in the buffer.	 
	MOV  BX,[SI]				;BX = byte offset of next data in the buffer
	MOV  CX,[SI+4]				;CX = cb of next pb/cb pair in buffer
; If the offset is zero, then no data was returned for this pb/cb pair.
	OR   BX,BX
	JZ   NextResponseData
; Check to be sure the count is not greater than the cb in the client rq.
	CMP  CX,ES:[DI+4]
	JA   XBuffTooSmall
; Check to be sure the count will not go past the number of characters
; actually transmitted.
	MOV  AX,BX
	ADD  AX,CX
	CMP  AX,cbSent
	JLE  MoveResponseData
XBuffTooSmall:
PUBLIC XBuffTooSmall
	MOV  AX,ercXBufTooSmall
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	PUSH AX
	CALL Crash
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	JMP  SHORT SendResponse
MoveResponseData:
PUBLIC MoveResponseData
; DS:SI point to next response pb/cb pair of buffer
; ES:DI point to next response pb/cb pair in client rq
; CX contains the next client cb
; BX = offset of next data in the buffer from xbCbDataSent
	LES  DI,DWORD PTR ES:[DI]
	MOV  SI,BX						;SI = offset of next data in the buffer
; DS:SI point to next data in the buffer offset from xbCbDataSent
; ES:DI contain next client response pb (dest)
	ADD  SI,xbCbDataSent
	%MOVGOOD
NextResponseData:
PUBLIC NextResponseData
	MOV  SI,oBufPbCb
	ADD  SI,6					;DS:SI point to next buffer response pb/cb 
	MOV  DI,oClientPbCb
	ADD  DI,6
	MOV  ES,saRq				;ES:DI point to next client pb/cb
	DEC  nRespToMove
	JMP  TestLastResponsePair
GetErcRet:
	MOV  ES,saRespXBlock
	MOV  AX,ES:[xbRqErcRet]					;AX = ercRet
SendResponse:
	PUSH SS
	POP  DS
ASSUME DS:DGroup
	MOV  BX,oRcb
	CALL RespondToRcb
HandleResponseRet:
	MOV  ES,saRespXBlock
	CALL FreeXBlock
%IF (%VerifyWaitingRequests) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	CALL VerifyWaitingRequests
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	MOV  SP,BP
	POP  BP
	RET
HandleResponse ENDP

PrepareRequest PROC NEAR
PUBLIC PrepareRequest
	PUSH BP
	MOV  BP,SP
;*****************************************************************************
; THIS ROUTINE NO LONGER CALLS BitStartWrite!  ALL POLLING DONE IN LPH.
;*****************************************************************************
saReqXBlock  EQU WORD PTR [BP-2]
oRcb         EQU WORD PTR [BP-4]
pRq          EQU DWORD PTR[BP-8]
saRq         EQU WORD PTR[BP-6]
raRq         EQU WORD PTR[BP-8]
ceh          EQU DWORD PTR[BP-8]	; same space as pRq
oClientPbCb  EQU WORD PTR[BP-10]
oBufPbCb     EQU WORD PTR[BP-12]
iPbCb        EQU BYTE PTR[BP-13]
nReqToMove   EQU BYTE PTR[BP-14]

pBuf         EQU DWORD PTR[BP-18]
saBuf        EQU WORD PTR[BP-16]
raBuf        EQU WORD PTR[BP-18]
nReqRespPbCb EQU WORD PTR[BP-20]
nReqPbCb     EQU BYTE PTR[BP-20]
;nRespPbCb    EQU BYTE PTR[BP-19]
sBufOutNext  EQU WORD PTR[BP-22]
sPrepareRequestVariables EQU 22

	SUB  SP,sPrepareRequestVariables
	MOV  AL, BYTE PTR msgLph
	TEST AL,msgMasterDown				;Has the master gone down?
	JZ   TestRcbWaiting					;No
; If the master went down, return.
PrepareBailOut:
	STI
	JMP  PrepareRequestRet
TestRcbWaiting:
	MOV  BX,rcbWaitingHead
	CMP  nWaitingRequests,0
	JE   PrepareBailOut ; Yes,
; the WsLph sent us an XBlock to fill, but there are no waiting requests.
; WsLph only has us fill an XBlock when nWaitingRequests <> 0. It is possible
; that the WsLph saw nWaitingRequests <> 0, but we were processing a response
; that had ercEom. The Eom caused us to stop sending pieces, and we set 
; nWaitingRequests to zero.

; Don't get an XBlock if we are about to reinitialize XBlocks.
	TEST msgLph,msgReinitXBlocks
	JNZ  PrepareBailOut
	CLI									;Get an XBlock to fill
	MOV  AX, saFreeList
	OR   AX, AX
	JZ   PrepareBailOut
	MOV  ES, AX
	MOV  AX, ES:[xbSaLink]
	CMP  AX,0							;Last XBlock?
	JE   PrepareBailOut					;Yes, leave for receiving.
	MOV  saReqXBlock,ES					;Save pointer to buffer
	MOV  saFreeList, AX					;Unlink from free list.
	STI

TestLastRcb:
	MOV  oRcb,BX						;Save offset of rcb
	CMP  BX,OFFSET DGROUP:rcbWaitingHead
	JNE  TestWaitingRcb					; All rcbs in xmit, or xblocks queued.
	MOV  ES, saReqXBlock
	CALL FreeXBlock
	JMP  PrepareRequestRet

TestWaitingRcb:
	CMP  rcbState,stateReset
	JL   RctStateOK
	JMP  NextWaitingRcb
RctStateOK:
	LES  DI,rcbpRq						;ES:DI point to client request 
	MOV  saRq,ES						;Save pointer to client rq
	MOV  raRq,DI
	MOV  CL,ES:[rqRtInfo+DI]			;CL = rtInfo from request
	MOV  AX,ES:[rqCode+DI]				;AX = rqCode
	CALL GetRqLevel						;on return, SI = word index of level
	LES  BX, prgRcMax
	CMP  AX,ES:[BX][SI]					;Is rqCode > rgRcMax(level)?
; If the request code is not in our table, then this request was routed to us
; by the Kernel because rtInfo <> 0.
	JAE  RqNotDefined					;CC >= if rqCode not in our table
	SHL  SI,1							;SI is level index of ptr array
	LES  BX, prgPrgRouting
	LES  BX,DWORD PTR ES:[BX][SI]		;ES:BX = rgPrgRouting(level)
	XCHG AX,SI							;AX=level*4, SI=rqCode
	SHL SI, 2
	MOV  CL, ES:[BX][SI+3]				;CL = NetRouting byte from table
RqNotDefined:
PUBLIC RqNotDefined
; CL = routing code
	MOV  BX,oRcb						;BX points to rcb
	LES  DI,rcbpRq						;ES:DI point to request for this rcb
	MOV  AX,sXbData						;AX = max size we can send
	CMP  rcbState,stateWaitingForXmit
	JNE  TestInXmitJmp
; This rcb is waiting to be sent. Change the state to inXmit. 
	MOV  rcbState,stateInXmit
; See if this is a read/write request that may have to be broken up.
	TEST CL,maskReadWrite
	JZ   SendSimpleRcbJmp

%IF (%AgentCache) THEN (
; Optimization to avoid cache code
	CMP  WORD PTR pCachedFhs+2, 0
	JE   HandleNotCachedJmp
; Requirement for cache operations to work: sXbData >= sAgentCacheBlock
	CMP  AX, sAgentCacheBlock
	JB   HandleNotCachedJmp

; Establish a cachedFile.  Process for Write, LockIn, Unlock, or Read.
	PUSH CX
	MOV  CX, ES:[rqFh+DI]
	MOV  AX, ES:[rqUserNum+DI]
	CALL AgentCacheLookupHandle			;DH=cfcWriteLock
	POP  CX
	MOV  AX,sAgentCacheBlock			;AX = max size we can send
	LES  DI,rcbpRq						;ES:DI point to request for this rcb
	CMP  rcboCf, 0
	JE   HandleNotCachedJmp

; Reads go through cache; Writes flush cache.
	CMP  ES:BYTE PTR[rqNReqPbCb+DI],1
	JNE  ReadCached						;Write request has 1 request pair

; Write on cached file.  For duration of write, reads of overlapping data must
; be defeated.  First, flush affected cache blocks.  Second, lock the file
; from cache updates until write returns.  This is simpler than calculating
; which Read cache updates lie within outstanding writes.
	PUSH CX
	CALL AgentCacheWrite				;ES:DI=pRq, BX=oRcb.
	POP  CX
	LES  DI,rcbpRq						;ES:DI point to request for this rcb
	MOV  AX,sXbData						;AX = max size we can send
HandleNotCachedJmp:
	JMP  HandleNotCached				; Treat as ordinary request.

SendSimpleRcbJmp:
	JMP  SendSimpleRcb

TestInXmitJmp:
	JMP  TestInXmit

ReadCached:
; ES:DI  pRq
; DS:BX  pRcb
; DH     cfcWriteLock
; Always cache-process LockIn,UnlockIn requests.
; Only cache-process Read when fAgentCacheDefaultEnable is true, else
; for files that may have data in the cache because of a LockIn.
; Cached read must go through "piecemeal" code to get cache stuff done.
	MOV  DL, rcbfPiecemeal+rcbCache
	CMP  ES:WORD PTR [rqCode+DI], rcLockInCache
	JNE  TestUnlock
; LockInCache
	MOV  DL, rcbfPiecemeal+rcbLockIn
	MOV  ES, WORD PTR pCachedFiles+2
	MOV  DI, rcboCf
	OR   ES:cfcWriteLock[DI], cfLocked
	LES  DI,rcbpRq						;ES:DI point to request for this rcb
	JMP  Short ReadAlign

TestUnlock:
	CMP  ES:WORD PTR [rqCode+DI], rcUnlockInCache
	JNE  TestCached
; UnlockInCache
	MOV  AX, ES:rqsBuf[DI]				; Set *rq.psDataRet = rq.sBuf.
	LES  SI, ES:DWORD PTR rqpsDataRet[DI]
	MOV  ES:[SI], AX
	MOV  ES, WORD PTR pCachedFiles+2	; Clear cfLocked
	MOV  SI, rcboCf
	AND  ES:cfcWriteLock[SI], cfWritten	; "NOT cfLocked"
	MOV  ES, WORD PTR rcbpRq+2
	CALL AgentCacheWrite				;ES:DI=pRq, BX=oRcb.
	MOV  ES,saReqXBlock					;ES points to buffer, BX=oRcb.
	OR   rcbFlags, rcbCached			; So RespondToRcb won't dec cWriteLock.
	CALL UnlockFinished
	JMP  TestRcbWaiting

TestCached:
	TEST SS:fAgentCacheDefaultEnable, 1
	JNZ  ReadAlign
	TEST DH, cfLocked
	JNZ  ReadAlign
; Not in cache.  Abort caching.
NotCached:
	MOV  ES, WORD PTR pCachedFiles+2
	MOV  DI, rcboCf
	DEC  ES:cfcRef[DI]
	MOV  rcboCf, 0
	LES  DI,rcbpRq						;ES:DI point to request for this rcb
	JMP  Short HandleNotCached

ReadAlign:
	OR   rcbFlags, DL
	MOV  DX, AX							; If 1st xfer unaligned, align.
	DEC  DX
	AND  DX, ES:[rqLfa+DI]
	SUB  DX, AX
	NEG  DX								;  sXbData-(lfa MOD sXbData)
	JNZ  StoreNextPieceSize				; Not aligned, partial transfer
	JMP  SendMaxSize					; Aligned xfer, full size

HandleNotCached:
)FI%'
; This is a read/write request. See if the data will fit in the XBlock.
	CMP  ES:[rqsBuf+DI],AX				;Is total to send > sXbData?
	JBE  SendSimpleRcb					;no
; This request must be sent in pieces.
	OR   rcbFlags,rcbfPiecemeal
	JMP  SHORT SendMaxSize

TestInXmit:
	CMP  rcbState,stateInXmit
	JNE  NextWaitingRcb
; This rcb is already in transmission. See if it's a piecemeal request.
	TEST rcbFlags,rcbfPiecemeal
	JZ   NextWaitingRcb

PiecemealRequest:
PUBLIC PiecemealRequest
; This is a piecemeal request. See if we need to send another piece. Don't
; send another piece if we already got EOM or if we have already sent all the
; pieces.
	TEST rcbFlags,rcbfEom+rcbFinishedSending
	JNZ  NextWaitingRcb
	MOV  DX,ES:[rqsBuf+DI]			;DX = total to send if read/write request
	SUB  DX,rcbsBufOutTotal				;DX = total left to send
	INC  rcbnOutstanding
%IF (%AgentCache) THEN (
	TEST rcbFlags, rcbCached
	JZ   TestXbData
	MOV  AX, sAgentCacheBlock
TestXbData:
)FI%'
	CMP  DX,AX							;is total left to send <= max size?
	JBE  StoreNextPieceSize				;yes
SendMaxSize:
	XCHG AX,DX							;no, DX = max size we can send
StoreNextPieceSize:
	MOV  sBufOutNext,DX					; cbUserWants (cache reads sXbData)
	JMP  SHORT SendRcb
NextWaitingRcb:
	MOV  BX,rcbNext[BX]
	JMP  TestLastRcb


SendSimpleRcb:
	DEC  nWaitingRequests
%IF (%AgentCache) THEN (
	CMP  WORD PTR pCachedFhs+2, 0
	JE   SendRcb
; Remember what type of request, so HandleResponse can figure out what to do.
	MOV   AX, ES:[DI+rqCode]
	PUSH  DS
	POP   ES
	LEA   DI, rgCacheRc
	MOV   CX, sCacheRc
	MOV   SI, CX
	CLD
	REPNE SCASW
	JNE   SendRcb
	SUB	  SI, CX
	DEC   SI
	MOV   AL, rgCacheFl[SI]
	OR    rcbFlags, AL
)FI%'

SendRcb:
PUBLIC SendRcb
	MOV  DX,rcbUserNum					;DX = userNumber

; 2.4 - Allocated user number support.
; 8/22/90 Removed by JA.  Ucb no longer referenced by WsAgent!

; BX points to rcb to send.
; DX = userNumber
	MOV  ES,saReqXBlock				;ES points to buffer
	MOV  DI,xbRq					;DI is index of first byte of rq in buffer
	MOV  AL,rcbFlags				;AL = rcbFlags
	LDS  SI,pRq						;DS:SI point to client rq
; DS:SI point to the client request block (source)
; ES:DI point to the request in the buffer (destination)
	MOV  CX,[SI+rqnReqPbCb]
	MOV  nReqRespPbCb,CX			;Save nReqRespPbCb from client rq
; Move the first two words of data from the client rq to the buffer:
; sCntlInfo, sRtInfo, nReqPbCb, nRespPbCb
	MOVSW
	MOVSW
; Move the user number from the rcb into the buffer. We move from the rcb
; instead of the client rq so that we need only one copy of requests that we
; create -- SetVerify requests and ClusterTerm (ResetAgent) requests.
	CALL MoveDxToBuff

; Move the address of the rcb into the response exchange field of the request
; in the buffer. When the request comes back, this tells us what rcb it
; belongs to.
	XCHG AX, BX
	STOSW
	XCHG AX, BX
	INC  SI
	INC  SI
; Move the next two words of the request into the buffer: ercRet and rqCode
	MOVSW
	MOVSW
	TEST AL,rcbfPiecemeal
	JNZ  SendPiecemealRequest
	JMP  SendSimpleRequest
SendPiecemealRequest:
PUBLIC SendPiecemealRequest
; This is a piecemeal request. Move the fh field into the buffer.
; DS:SI point to the control info part of the client request
; ES:DI point to the control info part of the buffer.
	MOVSW
; The next field to move is the lfa. This is the sum of the lfa in the client
; rq plus the total number of bytes sent so far.
	MOV  AX,[SI]					;AX = lfa low from client rq
	MOV  DX,[SI+2]					;DX = lfa high from client rq
	MOV  CX,SS:rcbsBufOutTotal		;CX = sBufOutTotal
	ADD  AX,CX						;AX = new lfa low
	ADC  DX,0						;DX = new lfa high
	CALL MoveAxDxToBuff
%IF (%AgentCache) THEN (
	TEST SS:rcbFlags, rcbCached
	JZ   LfaCorrect
; Align lfa stored in buff.
	MOV  AX, SS:sAgentCacheBlock
	DEC  AX
	NOT  AX
	AND  ES:[DI-4], AX
LfaCorrect:
)FI%'
; The next field to move is the pBuf field. This is the sum of the pBuf in the client rq plus the total number of bytes sent so far.
	MOV  AX,[SI]					;AX = ra of pBuf from client rq
	MOV  DX,[SI+2]					;DX = sa of pBuf from client rq
	ADD  AX,CX						;Add sBufOutTotal to ra of pBuf
;	JNC  MovePBuf
;	ADD  DX,1000h - cant work in ctosp
;MovePBuf:
; Save pBuf. If this is a write, we will use it to move the data into the
; buffer. The pBuf that we store in the request is actually the offset in the
; buffer of the data from cbDataSent, which always follows sDataRet.
	MOV  raBuf,AX
	MOV  saBuf,DX
	MOV  AX,xbrqReadWriteData-xbCbDataSent
	XOR  DX,DX
	CALL MoveAxDxToBuff
; Now update sBufOutTotal by sBufOutNext
	MOV  DX,sBufOutNext
	ADD  CX,DX
	MOV  SS:rcbsBufOutTotal,CX
; If sBufOutTotal = sBuf from client rq, then this is the last piece, so
; decrement nWaitingRequests and set a flag finishedSending so that we will
; not send any more pieces.
	CMP  [SI],CX					;[SI] is sBuf from client rq
	JA   MoveSbuf
	DEC  SS:nWaitingRequests
	OR   SS:rcbFlags,rcbFinishedSending
MoveSbuf:
%IF (%AgentCache) THEN (
	TEST SS:rcbFlags,rcbCached
	JZ   StoreCb
	MOV  DX, SS:sAgentCacheBlock
StoreCb:
)FI%'
; The next field to move is sBuf, contained in DX (sBufOutNext).
	CALL MoveDxToBuff
; The next data we move is the psDataRet and sDataRet fields from the
; client rq.
	MOVSW
	MOVSW
	MOVSW
; DS:SI point to the byte following the sDataRet field in the client rq.
; ES:DI point to the first byte of data in the buffer.
; DX is number of characters to transfer this piece.
; If this is a write request, we need to move in the data to write. If this is
; a read request, this request is ready.
	CMP  nReqPbCb,1
	JNE  RequestDataFinishedJmp		;Write request has 1 request pair
	LDS  SI,pBuf					;DS:SI contain pBuf from client rq
	MOV  CX,DX						;CX = sBuf
	%MOVGOOD
RequestDataFinishedJmp:
	JMP  RequestDataFinished

SendSimpleRequest:
PUBLIC SendSimpleRequest
; This is not a piecemeal request. We have moved the first 6 words of the
; request into the buffer.
; DS:SI point to the control info part of the client request.
; ES:DI point to the control info part of the buffer.
; Move the control info from the client request into the buffer.
	XOR  CX,CX
	MOV  CL,ES:[xbRq]				;CX = sCntlInfo
	REPNZ MOVSB
; DS:SI point to the first pb/cb pair of the client request. 
; ES:DI point to the first pb/cb pair in the buffer.
; Move the pb/cb pairs into the buffer.
	MOV  oClientPbCb,SI				;save offset of next client pb/cb pair
	MOV  oBufPbCb,DI				;save offset of next buffer pb/cb pair
	MOV  DX,nReqRespPbCb			;DL = nReqPbCb DH = nRespPbCb
	MOV  nReqToMove,DL
	MOV  CL,DL
	ADD  CL,DH						;CX = nReqPbCb + nRespPbCb
	JZ   RequestDataFinished1
	MOV  AL,6
	MUL  CL
	XCHG CX,AX						;CX = 6*(nReqPbCb + nRespPbCb)
	SHR  CX,1
	REPNZ MOVSW
	MOV  SI,oClientPbCb
	MOV  BX,oBufPbCb
	MOV  iPbCb,0
	OR   DL,DL						;DL = nReqPbCb
	JNZ  SetupPb
RequestDataFinished1:
	JMP  RequestDataFinished		;no request data
SetupPb:
PUBLIC SetupPb
; DS:SI point to the next request pb/cb pair of the client request. 
; ES:DI point to the next byte of data in the buffer.
; ES:BX point to the next request pb/cb pair in the buffer. 
; Change the pb in the buffer to be an offset of the data in the buffer from
; xbCbDataSent. This offset is used by old masters to determine where the data
; is.
	MOV  AX,DI
	INC  AX
	AND  AL,0FEh					;Round to even boundary in buffer
	MOV  DI,AX
	SUB  AX,xbCbDataSent			;AX = offset of data from xbCbDataSent
	MOV  ES:[BX],AX					;Store offset in buffer
	MOV  WORD PTR ES:[BX+2],0		;sa of pointer is zero in buffer
	MOV  CX,[SI+4]					;CX = cb of next client pb/cb pair
	LDS  SI,DWORD PTR [SI]			;DS:SI contain next client pb

MoveRequestData:
PUBLIC MoveRequestData
; DS:SI contain the next request pb from the client request 
; CX = cb of client request
; ES:DI point to the next byte of data in the buffer.
; CX contains the count of bytes to move
; ES:BX point to the next request pb/cb pair in the buffer. 
	PUSH AX							; check if selector is zero
	MOV  AX,DS
	OR   AX,AX
	POP  AX
	JZ   SHORT NextRequestData		; if so, skip it to avoid GP fault

	%MOVGOOD

NextRequestData:
	MOV  DS,saRq
	MOV  SI,oClientPbCb				;DS:SI point to current client pb/cb
	MOV  BX,oBufPbCb				;ES:BX points to current pb/cb in buffer
	ADD  SI,6						;DS:SI point to next client pb/cb
	ADD  BX,6
	INC  iPbCb						;Increment index of pb/cb 
	DEC  nReqToMove
	JZ   RequestDataFinished
	MOV  oClientPbCb,SI
	MOV  oBufPbCb,BX
	JMP  SetupPb

RequestDataFinished:
PUBLIC RequestDataFinished
	PUSH SS
	POP  DS
ASSUME DS:Dgroup
; DS points to DGroup
; ES:DI point to the next byte of data in the buffer.
; ES:BX point to the 1st response pbcb in the buffer.
	INC  DI
	AND  DI,0FFFEh						;Round to even boundary
	CMP  masterRevisionLevel,91h
	JB   StoreBytesTransferred
	CMP  WORD PTR ES:[xbRqCode],rcGetDateTime
	JNE  StoreBytesTransferred
; This is a GetDateTime request, and the master would like to know what errors
; we have detected. Send them on the end of the GetDateTime request.
	LEA  SI,wsStats
	MOV  CX,sizeWsStats/2
	REPNZ MOVSW
StoreBytesTransferred:
; Store the number of bytes transfered in the buffer for the master to check.
	MOV  AX,DI						;DI is index from xbCbDataSent
	SUB  AX,xbCbDataSent
	MOV  ES:[xbCbDataSent],AX		;Store cbDataSent in buffer
; Store the number of bytes to transfer in the buffer. Add two for station
; address and frame.
	INC  AX
	INC  AX
	MOV  ES:[xbCbData],AX
SendFrameToMaster:
%IF (%AgentCache) THEN (
; If request returns handle, make sdfhRet.cb big enough for cache info.
	MOV  DI, BX
; ES:DI point to 1st response pbcb.
	MOV  BX, oRcb
	MOV  AL, rcbFlags
	AND  AL, rcbOpenClose
	CMP  AL, rcbOpenFh
	JNE  SatisfyCached
	CMP  ES:WORD PTR [DI+4],sFid
	JAE  QueueFrame
	MOV  ES:WORD PTR [DI+4],sFid
SatisfyCached:
; If LockIn, modify XBlock to be a read request.
	TEST rcbFlags, rcbLockIn
	JZ   TestProbeCache
	MOV  ES:WORD PTR xbrqSCntlInfo, 0006h
	MOV  ES:WORD PTR xbRqNReqPbCb, 0200h
	MOV  ES:WORD PTR xbrqCode,  rcRead
TestProbeCache:
; If read, if cache block exists, return data immediately.
	TEST rcbFlags, rcbCached
	JZ   TestChangeLength
	CALL AgentCacheSatisfyRead		;BX=oRcb, ES=saXBlock
	JNZ  QueueFrame					; returns Z flag: success
	JMP  TestRcbWaiting				; success, next rcb
TestChangeLength:
	TEST rcbFlags, rcbChangeLength
	JZ   QueueFrame
; Lock cached file for modification
	MOV  AX, ES:[xbrqUsernum]
	MOV  CX, ES:[xbrqFh]
	CALL AgentCacheLookupHandle
	CMP  rcboCf, 0
	JE   TCLDone
	ADD  ES:cfcWriteLock[SI], 2		;must be >1 to be locked
TCLDone:
	MOV  ES,saReqXBlock				;ES points to buffer

QueueFrame:
) ELSE (
	MOV  BX, oRcb					;Queue XBlock on rcb for sending
)FI%'
	MOV  ES:WORD PTR [xbSaLink], 0	;End of xblock linked list
	MOV  AX, ES
	CLI								;Disable
	MOV  CX, rcbsaXBlock
	OR   CX, CX
	JNZ  QueueNextXBlock
	MOV  rcbsaXBlock, ES
	JMP  Short QueueXBlockDone
QueueNextXBlock:
	MOV  ES, CX
	MOV  CX, ES:[xbSaLink]
	OR   CX, CX
	JNZ  QueueNextXBlock
	MOV  ES:[xbSaLink], AX
QueueXBlockDone:
	INC  nXBlocksToSend
	STI								;Enable

%IF (%VerifyWaitingRequests) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	CALL VerifyWaitingRequests
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  DI,logXBlockOutIndex
	ADD  DI,logXBlockOutEntrySize
	CMP  DI,logXBlockOutIndexMax
	JBE  logXBlockOutIndexOk
	MOV  DI,0
logXBlockOutIndexOk:
	MOV  logXBlockOutIndex,DI
	MOV  AX,DGroup
	MOV  ES,AX						;ES points to DGroup
	LEA  DI,logXBlockOutBuffer[DI]	;ES:DI point to log entry
	MOV  DS,saReqXBlock				;DS points to XBlock
	MOV  SI,xbStation				;DS:SI point to xbStation
	MOV  CX,logXBlockOutEntrySize/2
	REPNZ MOVSW
	MOV  AX,DGroup
	MOV  DS,AX						;DS points to DGroup
ASSUME DS:Dgroup
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	MOV  DI,logRqBufferIndex
	ADD  DI,logRqEntrySize
	CMP  DI,logRqBufferIndexMax
	JBE  logRqBufferIndexOk4
	MOV  DI,0
logRqBufferIndexOk4:
	MOV  logRqBufferIndex,DI
	MOV  logRqPoint[DI],4   		;Request goes out
	MOV  ES,saReqXBlock
	MOV  AX,ES:[xbRqCode]
	MOV  logRqCode[DI],AX
	MOV  AX,ES:[xbRqRespExch]
	MOV  logRqoRcb[DI],AX
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

	JMP  TestRcbWaiting
PrepareRequestRet:
	AND  msgLph, NOT msgXBlockFill
	MOV  SP,BP
	POP  BP
	RET
PrepareRequest ENDP


ChainRcb PROC NEAR
PUBLIC ChainRcb
;*****************************************************************************		
; Chain rcb onto list.
; On entry, BX points to rcb to chain, and 
; DI points to prev rcb or list head if none.
; On return, SI points to next rcb or list head if none.
;*****************************************************************************		
	MOV  SI,rcbNext[DI]			;SI points to next rcb in list or list head
	MOV  rcbNext[BX],SI			;set next pointer of rcb being chained.
	MOV  rcbPrev[BX],DI			;set prev pointer of rcb being chained
								;to point to prev rcb or head of list.
	MOV  rcbPrev[SI],BX			;prev pointer of next rcb points to rcb
								;being chained
	MOV  rcbNext[DI],BX			;next pointer of prev rcb points to rcb
								;being chained
	RET
ChainRcb ENDP

UnchainRcb PROC NEAR
PUBLIC UnchainRcb
;*****************************************************************************		
; Unchain Rcb from whatever list it is in.
; On entry, BX points to rcb to unchain.
; On return, SI points to next rcb or list head if none, and
; DI points to prev rcb or list head if none.
;*****************************************************************************		
	MOV  SI,rcbNext[BX]			;SI points to next rcb or list head if none
	MOV  DI,rcbPrev[BX]			;DI points to prev rcb or list head if none
; Unchain this rcb from the prev pointer of the next rcb.
	MOV  rcbPrev[SI],DI
; Unchain this rcb from the next pointer of the previous rcb.
	MOV  rcbNext[DI],SI
	RET
UnchainRcb ENDP

GetUserTableIndex PROC NEAR
	MOV  DX,rcbUserNum

GetUserTableIndexDX:			;UserNum is already in DX
	MOV  AL,utSize
	MUL  DL
	ADD  AX,oRgUserTable
	MOV  oUserTable,AX			;Save index of UserTable entry
	XCHG DI,AX					;DI points to UserTable entry
	RET
GetUserTableIndex ENDP

RespondToRcb PROC NEAR
PUBLIC RespondToRcb
;*****************************************************************************
; BX points to rcb to respond to.
; AX contains erc.
; Free any XBlocks chained to the rcb.
; Unchain the rcb from the waiting list and chain it onto the avail list.
; On return, BX points to the next rcb in the list.
;*****************************************************************************

; Any XBlocks unsent?
	CMP  rcbSaXBlock, 0
	JE   ReturnRequest
	PUSH AX						;Save erc
	MOV  ES, rcbSaXBlock	
	MOV  AX, ES:[xbSaLink]		;Unlink XBlock from rcb
	MOV  rcbSaXBlock, AX
	DEC  nXBlocksToSend
	CALL FreeXBlock
	POP  AX						;Restore erc
	JMP  RespondToRcb

ReturnRequest:
%IF (%AgentCache) THEN (
	CMP  rcboCf, 0						; Write has NOT rcbCached, but oCf<>0
	JE   RTRTime
	MOV  ES, WORD PTR pCachedFiles+2
	MOV  DI, rcboCf
	DEC  ES:cfcRef[DI]
	TEST rcbFlags, rcbCached
	JNZ  RTRTime
	DEC  ES:cfcWriteLock[DI]			; Write complete.  Dec cfcWriteLock.
RTRTime:
)FI%'

	CMP  rcbState,stateReset
	MOV  rcbState,0
	JNE  GetpClientRq
; We already responded if the remote termination request went by.
	MOV  CX,rcResetAgent		;CX = rcResetAgent if we already responded
; Mark on the wall for debugging.  In general, we should get an rcb back
; for every cRespondBeforeRcb.  If we don't then some server is not
; responding to termination requests properly.
	INC  cRcbAfterTerm
	JMP  SHORT CalcTurnaround
GetpClientRq:
	LES  DI,rcbpRq
	MOV  CX,ES:[rqCode+DI]		;CX = rqCode from request
	CMP  ES:WORD PTR [rqErcRet+DI], 0	;ercOk?
	JE   AcceptReturnedErc		;keep local erc if not ok
	OR   AX,AX
	JNZ  CalcTurnaround			; and server returned erc too
AcceptReturnedErc:
	MOV  ES:[rqErcRet+DI],AX	;Store ercRet

CalcTurnaround:
; Calculate the turnaround time for this request.
	MOV  AX,rcbRqStartTime		;AX = startTime
	MOV  DX,rqClock				;DX = endTime
	CMP  DX,AX					;Is endTime > startTime?
	JBE  SaveElapsedTime		;No
; The clock counts down, so it must have counted down to zero and then
; restarted.
	SUB  DX,AX					;DX = endTime - startTime
	MOV  AX,0FFFFh				;AX = reset value of clock
SaveElapsedTime:
	SUB  AX,DX							
	XOR  DX,DX
; AX = number of elapsed ticks from the time the request was received until we
; received the response from the master.
	TEST rcbFlags,rcbfPiecemeal
	JZ   TestGetDtRq
	ADD  sumBlockRqTimeLow,AX
	ADC  sumBlockRqTimeHigh,DX
	INC  nBlockRqLow
	ADC  nBlockRqHigh,DX
	CMP  AX,maxBlockRqTime
	JBE  RqTimeFinished
	MOV  maxBlockRqTime,AX
	JMP  SHORT RqTimeFinished
TestGetDtRq:
	CMP  CX,rcGetDateTime
	JNE  SaveSimpleRqElapsedTime
	ADD  sumGetDtRqTimeLow,AX
	ADC  sumGetDtRqTimeHigh,DX
	INC  nGetDtRq
	CMP  AX,maxGetDtRqTime
	JBE  RqTimeFinished
	MOV  maxGetDtRqTime,AX
	JMP  SHORT RqTimeFinished
SaveSimpleRqElapsedTime:
	ADD  sumSimpleRqTimeLow,AX
	ADC  sumSimpleRqTimeHigh,DX
	INC  nSimpleRqLow
	ADD  nSimpleRqHigh,DX
	CMP  AX,maxSimpleRqTime
	JBE  RqTimeFinished
	MOV  maxSimpleRqTime,AX

RqTimeFinished:
; CX = rqCode from request
	CALL UnchainRcb
	PUSH SI							;Save pointer to next rcb in list
	MOV  DI,rcbAvailTail
	CALL ChainRcb
;If ResetAgent, of if we already responded, don't respond
	CMP  CX,rcResetAgent
	JE   RespondToRcbRet			
	CMP  CX,rcSetVerify
	JE   RespondToRcbRet			;If SetVerifyCount, don't respond
	MOV  AX,rcbraRq
; See if this is a SetWsUserName request that we sent
	CMP  AX,OFFSET DGROUP: rqSetUserName
	JNE  RespondRcb
	MOV  BX,ES
	MOV  DI,DS
	CMP  DI,BX
	JE   RespondToRcbRet
RespondRcb:
	PUSH ES							;sa of rq for respond
	PUSH AX							;ra of rq for respond
	CALL KRespond
RespondToRcbRet:
	POP  BX							;BX points to next rcb in list
	RET
RespondToRcb ENDP

MoveAxDxToBuff PROC NEAR
PUBLIC MoveAxDxToBuff
;*****************************************************************************
;*****************************************************************************
	STOSW
	INC  SI
	INC  SI
MoveDxToBuff:
	XCHG AX, DX
	STOSW
	XCHG AX, DX
	INC  SI
	INC  SI
	RET
MoveAxDxToBuff ENDP

FreeXBlockOut:
	CLI								;Disable
	MOV  saXBlockOut,0
;*****************************************************************************
; We had found an XBlock to xmit, but the master has gone down.
; Return XBlock pointed to by saXBlock to the free list.
;*****************************************************************************

FreeXBlock PROC NEAR
PUBLIC FreeXBlock
;*****************************************************************************
; ES points to XBlock to free.
; We just handled a response in saXBlockIn, and we free the XBlock.
;*****************************************************************************
	CLI								;Disable
	MOV  AX,saFreeList				;AX is pointer to free list of XBlocks
	MOV  ES:[xbSaLink],AX			;Chain XBlock being freed to free list
	MOV  saFreeList,ES				;freeList points to XBlock freed
	OR   msgLph, msgXBlockFill		;XBlock available for filling
	STI								;Enable
	RET
FreeXBlock ENDP

GetRqLevel PROC NEAR
PUBLIC GetRqLevel
;*****************************************************************************
; AX = rqCode
; On exit, SI = pointer index of level, AX = rqCode with level bits removed.
; Must not disturb CX
;*****************************************************************************
	MOV  SI,AX						;SI = rqCode
	SHR  AH, 4
	MOV  AL,AH
	XOR  AH,AH						;AX is request level
	XCHG AX,SI						;SI=level, AX=rqCode
	CMP  AX,0FFE0h					;>= -32 ?
	JB   NotUserDirect
	MOV  SI,16						;User is "level 16"
	NOT  AX							; ,indexes in reverse order.
NotUserDirect:
	AND  AH,0Fh  					;Strip away level bits
	SHL  SI,1						;SI is level index of word array
	RET								;If so, set condition code >=
GetRqLevel ENDP

%IF (%VerifyWaitingRequests) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
VerifyWaitingRequests PROC NEAR
PUBLIC VerifyWaitingRequests
;*****************************************************************************
; Make sure nWaitingRequests is actually the number waiting in the queue
;*****************************************************************************
	XOR  AX,AX						;count number waiting in AX
	MOV  BX,OFFSET DGROUP:rcbWaitingHead
TestNextWaiting:
	MOV  BX,rcbNext[BX]
	CMP  BX,OFFSET DGROUP:rcbWaitingHead
	JE   TestWaitingCount
	CMP  rcbState,stateWaitingForXmit
	JNE  TestWaitingInXmit
IncWaiting:
	INC  AX
	JMP  TestNextWaiting
TestWaitingInXmit:
	CMP  rcbState,stateInXmit
	JNE  TestNextWaiting
; This rcb is already in transmission. See if it's a piecemeal request.
	TEST rcbFlags,rcbfPiecemeal
	JZ   TestNextWaiting
	TEST rcbFlags,rcbfEom+rcbFinishedSending
	JNZ  TestNextWaiting
	JMP  IncWaiting
TestWaitingCount:
	CMP  AX,nWaitingRequests
	JE   WaitingOk
WaitingRequestsError:
PUBLIC WaitingRequestsError
	MOV  AX,3
	PUSH AX
	CALL Crash
WaitingOk:
	RET
VerifyWaitingRequests ENDP
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

; File system calls here to find if cluster running.
FSrpUpProc PROC FAR
	PUSH	DS
	MOV		AX, DGroup
	MOV		DS, AX
ASSUME DS:DGroup
	MOV		AL, fSrpUp
	XOR		AH, AH
	POP		DS
ASSUME DS:Nothing
	RET
FSrpUpProc ENDP


; os-enh ...
; GetClstrGenerationNumber 
;		- to determine if the link with the server went down
;		  since a user/service last communicated with the server.
GetClstrGenerationNumber PROC FAR
pVersionRet EQU DWORD PTR SS:[BX+6]
	push	ds
	mov		ax, dgroup
	mov		ds, ax
ASSUME DS:DGroup
	mov		bx, sp
	les		bx, pVersionRet
	mov		ax, wclstrversion
	mov		es:[bx], ax
	xor		ax, ax
	mov		al, fSrpUp
;	mov		ah, stationaddress
	mov		es:[bx+2], ax
	xor		ax, ax
	pop		ds
	ret		4
GetClstrGenerationNumber ENDP

; TermPros calls here it find if a request was sent to master since last reset.
;		fRqSent=FMasterRqSentTestAndClear(userNum);
FMasterRqSentTestAndClear PROC FAR
userNum		EQU		WORD PTR SS:[BX+6]
	PUSH	DS
	MOV		AX, DGroup
	MOV		DS, AX
ASSUME DS:DGroup
	MOV		BX, SP
	MOV		BX, userNum
	AND		BX, 3FFh
	MOV		AX, 6
	MUL		BX
	XCHG	AX, BX		; BX=(userNum AND 3FFh)*6
	ADD		BX, orgUserTable
	XOR		AX, AX
	TEST	BYTE PTR [BX], fRqSentToMaster
	JZ		FMRSRet
	DEC		AL
; clear fRqSentToMaster bit - 06/26/93 
	AND		BYTE PTR [BX], NOT fRqSentToMaster 
FMRSRet:
	POP		DS
ASSUME DS:Nothing
	RET	2
FMasterRqSentTestAndClear ENDP

%IF (%AgentCache) THEN (
$MOD386

; For CacheFlush
cidMask DB 0,0,0,0,0FFh,0FFh,0FFh,0FFh

ACRHRetJmp:
	JMP  ACRHRet

PUBLIC AgentCacheRegisterHandle
AgentCacheRegisterHandle PROC NEAR
;DS:SI point to block.sdFhRet
	PUSH AX									; userNum
	PUSH BP
	MOV  BP, SP
	CMP  SS:WORD PTR pCachedFiles+2, 0		; Is cache configured?
	JE   ACRHRetJmp

	MOV  SI, DS:[SI]
	ADD  SI, xbCbDataSent
	TEST DS:BYTE PTR fidFhRet[SI+1], 80h	; Ct net handle?
	JNZ  ACRHRetJmp

; Find existing cachedFile entry, or create a new entry.
	LES  DI, SS:pCachedFiles
	LODSW			; Skip fhRet, not part of checksum
	LODSW
	XCHG AX, CX
	LODSW
	ADD  CX, AX
	LODSW
	ADD  CX, AX
	LODSW
	ADD  CX, AX
	LODSW
	ADD  CX, AX
	CMP  CX, lFidChecksum
	JNE  ACRHRetJmp
	SUB  SI, sFid

	MOV  AX, DS:fidFileIdentifier[SI]		; find this fid
	MOV  CX, DS:fidFileIdentifier[SI+2]
	JCXZ ACRHRetJmp							; Fid high word=0 -> no fid for fh
	CMP  CX, 0FFFFh							; Fid high word=0FFFFh -> ditto
	JE   ACRHRetJmp

ACRHFileLoop:; DO WHILE prev.oNext <> .oHead;
	MOV  BX, DI
	MOV  DI, ES:cfoNext[DI]
	CMP  DI, SS:WORD PTR pCachedFiles
	JE   ACRHCreate
	CMP  ES:cfFileIdentifier[DI], AX
	JNE  ACRHFileLoop
	CMP  ES:cfFileIdentifier[DI+2], CX
	JNE  ACRHFileLoop

; Found cachedFile entry for this fid.
; ES:BX point to nodePrev
; ES:DI point to nodeMRU
; DS:SI point to fid
; Unlink cachedFile
	MOV  AX, ES:cfoNext[DI]			; AX=nodeMRU.oNext
	MOV  ES:cfoNext[BX], AX			; nodePrev.oNext=AX
	XCHG AX, BX						; ES:AX point to nodePrev
	MOV  BX, SS:WORD PTR pCachedFiles ; ES:BX point to cachedFileBlock
	CMP  ES:cfboTail[BX], DI
	JNE  ACRHDisposeCf
	MOV  ES:cfboTail[BX], AX		; New tail ptr = nodePrev
ACRHDisposeCf:

; Verify modificationSync.
; ES:BX point to cachedFile block
; ES:DI point to nodeMRU
; DS:SI point to fid
	MOV  AX, DS:fidModificationSync[SI]
	CMP  AX, ES:cfModificationSync[DI]
	JNE  ACRHFlush
	MOV  AX, DS:fidModificationSync[SI+2]
	CMP  AX, ES:cfModificationSync[DI+2]
	JE   ACRHAddCfMRU

ACRHFlush:
	CALL AgentCacheFlush			; ES:BX=pCachedFiles, ES:DI->nodeFlush
; Then create new cachedFile, cachedFh structures.
	LES  DI, SS:pCachedFiles

ACRHCreate:
; DS:SI point to block.FhRet (fid)
; ES:DI point to cachedFile block
	MOV  BX, DI
; ES:BX point to cachedFile block
; Any cachedFile structures on free list?
	MOV  DI, ES:cfboFree[BX]
	CMP  DI, lEndOfList
	JNE  ACRHTakeCf

; Flush cachedFile from LRU end of in-use list
; DS:SI point to block.FhRet (fid)
; ES:BX point to cachedFile block
	MOV  DI, ES:cfboTail[BX]
	TEST ES:cfcRef[DI], cfInUse
	JNZ  ACRHRetJmp2				; Tail node in use!  All probably in use.
	MOV  DI, BX
	MOV  AX, ES:cfboTail[BX]
ACRHTailLoop:
	MOV  DX, ES:cfoNext[DI]
	CMP  DX, AX						; Points to tail node? ES:DI is nodePrev.
	JE   ACRHTailUnlink
	MOV  DI, DX
	JMP  ACRHTailLoop
ACRHTailUnlink:
; Found nodePrev.  Unlink nodeTail.
	MOV  ES:cfoNext[DI], BX			; Cheat: know nodeTail.oNext is BX
	MOV  ES:cfboTail[BX], DI
	MOV  DI, AX						; ES:DI point to nodeTail.
	JMP  ACRHFlush

ACRHRetJmp2:
	JMP  ACRHRet

ACRHTakeCf:
; Take 1st entry on free list.
	MOV  AX, ES:cfoNext[DI]
	MOV  ES:cfboFree[BX], AX
; Fill out entry.
	MOVSW					; Skip fidFhRet, cfoNext (filled in later)
	XOR  AX, AX
	STOSB					; cfcWriteLock
	STOSB					; cfcRef
	MOVSW					; modificationSync low
	MOVSW					; modificationSync high
	MOVSW					; fileIdentifier low
	MOVSW					; fileIdentifier high
	DEC  AX					; 0FFFFh
	STOSW					; cfLfaLast low
	STOSW					; cfLfaLast high
	SUB  DI, sCf
	SUB  SI, sFid-2

ACRHAddCfMRU:
; ES:BX point to cachedFile block
; ES:DI point to nodeMRU
; DS:SI point to fid
; Link cachedFile to MRU end of in-use list.
	MOV  AX, ES:cfboHead[BX]
	MOV  ES:cfoNext[DI], AX
	MOV  ES:cfboHead[BX], DI
	CMP  AX, BX				; BX=.oHead
	JNE  ACRHAddFh
	MOV  ES:cfboTail[BX], DI

ACRHAddFh:
; ES:DI point to cachedFile structure
; DS:SI point to block.fid

; Add fh block referencing cachedFile.
	INC  ES:cfcRef[DI]
	JO   ACRHNoCfh			; If cRef overflow don't add another cfh.
	JZ   ACRHNoCfh			; 7Fh->80h or 0FFh->0
	LODSW					; AX=fhRet, DI=oCf
	XCHG AX, DX				; DX=fhRet, DI=oCf
	XCHG AX, DI				; DX=fhRet, AX=oCf
	LES  BX, SS:pCachedFhs
; If Remake or Reopen search for cfh that matches.
; ES:BX point to cachedFhBlock
; DS:SI point to block.fid
	MOV  CX, [BP+2]
; DX=fhRet, AX=oCf, CX=userNum
ACRHFhLoop:
	MOV  DI, BX
; ES:DI point to cachedFh
	MOV  BX, ES:cfhoNext[DI]
	CMP  BX, SS:WORD PTR pCachedFhs
	JE   ACRHFhNew
	CMP  ES:cfhUserNum[BX], CX
	JNE  ACRHFhLoop
	CMP  ES:cfhFh[BX], DX
	JNE  ACRHFhLoop
; Found matching cfh, don't need a new one.
	MOV  ES:cfhoCf[BX], AX		; oCf should match, make sure.
	JMP  ACRHRet

; No matching cfh, make a new one.
ACRHFhNew:
	MOV  DI, ES:cfboFree[BX]
	CMP  DI, lEndOfList
	JNE  ACRHTakeCfh
; Flush cachedFh from LRU end of in-use list
;  What if rcbs outstanding?  Punt, don't cache for now.
	XCHG AX, DI				; DI=oCf
ACRHNoCfh:
	MOV  ES, SS:WORD PTR pCachedFiles+2
	DEC  ES:cfcRef[DI]
	JMP  Short ACRHRet

ACRHTakeCfh:
; Unlink from free list
	MOV  CX, ES:cfhoNext[DI]
	MOV  ES:cfboFree[BX], CX
; Link to in-use list
	MOV  CX, ES:cfboHead[BX]
	MOV  ES:cfhoNext[DI], CX
	MOV  ES:cfboHead[BX], DI
	CMP  CX, BX				; BX=.oHead
	JNE  ACRHBuildFh
	MOV  ES:cfboTail[BX], DI

ACRHBuildFh:
; Fill out entry
; DX=fhRet, AX=oCf
; ES:DI point to cachedFh structure
	SCASW					; Ignore result, ES:DI point to cfhoCf
	STOSW					; cfhoCf
	XCHG AX, DX
	STOSW					; cfhFh
	MOV  AX, [BP+2]
	STOSW					; cfUserNum

ACRHRet:
	POP  BP
	POP  AX
	RET
AgentCacheRegisterHandle ENDP

PUBLIC AgentCacheUnregisterHandle
AgentCacheUnregisterHandle PROC NEAR
; AX=userNum, CX=fhClose
; Flush any cachedFh structure corresponding.
	LES  DI, SS:pCachedFhs
	MOV  DX, ES
	OR   DX, DX				; Is cache configured?
	JZ   ACUHRet

ACUHFhLoop:
	MOV  BX, DI
ACUHStutter:
	MOV  DI, ES:cfhoNext[BX]
	CMP  DI, SS:WORD PTR pCachedFhs
	JE   ACUHRet
	JCXZ ACUHCheckUser		; fhClose=0 means CloseAllFiles
	CMP  ES:cfhFh[DI], CX
	JNE  ACUHFhLoop
ACUHCheckUser:
	CMP  AX, lAnyUserNum
	JE   ACUHFoundCfh		; lAnyUserNum means MasterWentDown
	CMP  ES:cfhUserNum[DI], AX
	JNE  ACUHFhLoop

ACUHFoundCfh:
; Found the cachedFh structure.  Unlink, free it.
; ES:BX point to nodePrev
; ES:DI point to nodeFlush
; AX=userNum
; CX=fhClose
; Free from in-use list
	MOV  DX, ES:cfhoNext[DI]
	MOV  ES:cfhoNext[BX], DX
	MOV  SI, SS:WORD PTR pCachedFhs 	; ES:BX point to cachedFhBlock
	CMP  ES:cfboTail[SI], DI
	JNE  ACUHDisposeCfh
	MOV  ES:cfboTail[SI], BX			; New tail ptr = nodePrev
ACUHDisposeCfh:
; Put on free list
; ES:BX point to nodePrev
; ES:DI point to nodeFlush
; ES:SI point to cachedFhBlock
; AX=userNum
; CX=fhClose
	MOV  DX, ES:cfboFree[SI]
	MOV  ES:cfhoNext[DI], DX
	MOV  ES:cfboFree[SI], DI
; Count down cachedFile.cRef
	MOV  SI, ES:cfhoCf[DI]
	MOV  ES, SS:WORD PTR pCachedFiles+2
	DEC  ES:cfcRef[SI]
; If written, inc modificationSync
	TEST ES:cfcWriteLock[SI], cfWritten
	JZ   ACUHResume
	DEC  ES:cfcWriteLock[SI]; clear "written" state
	ADD  ES:WORD PTR cfModificationSync[SI], 1
	ADC  ES:WORD PTR cfModificationSync[SI+2],0
ACUHResume:
	MOV  ES, SS:pCachedFhs+2
	JCXZ ACUHStutter		; If CloseAllFiles, keep searching.
;	JMP  Short ACUHStutter	; RemakeFh/ReOpenFile may return existing handles

ACUHRet:
	RET
AgentCacheUnregisterHandle ENDP

PUBLIC AgentCacheLookupHandle
AgentCacheLookupHandle PROC NEAR
ASSUME DS:DGroup
; AX=userNum, CX=fh
; If cachedFh structure exists, link rcb to cachedFile.
	LES  DI, pCachedFhs
	MOV  DX, ES
	OR   DX, DX				; Is cache configured?
	JZ   ACLHRet

ACLHFhLoop:
	MOV  SI, DI
	MOV  DI, ES:cfhoNext[DI]
	CMP  DI, SS: WORD PTR pCachedFhs
	JE   ACLHRet
	CMP  ES:cfhFh[DI], CX
	JNE  ACLHFhLoop
	CMP  ES:cfhUserNum[DI], AX
	JNE  ACLHFhLoop

; ES:DI point to the cachedFh structure.
; ES:SI point to nodePrev
; Free from in-use list
	MOV  AX, ES:cfhoNext[DI]
	MOV  ES:cfhoNext[SI], AX
	XCHG AX, SI							; AX=nodePrev
	MOV  SI, SS:WORD PTR pCachedFhs 	; ES:BX point to cachedFhBlock
	CMP  ES:cfboTail[SI], DI
	JNE  ACLHDisposeCfh
	MOV  ES:cfboTail[SI], AX			; New tail ptr = nodePrev
ACLHDisposeCfh:
; Put on head of in-use list
; ES:AX point to nodePrev
; ES:DI point to nodeFound
; ES:SI point to cachedFhBlock
	MOV  AX, ES:cfboHead[SI]
	MOV  ES:cfhoNext[DI], AX
	MOV  ES:cfboHead[SI], DI
	CMP  AX, SI				; SI=.oHead
	JNE  ACLHLinkRcb
	MOV  ES:cfboTail[SI], DI

ACLHLinkRcb:
; Link to rcb
	MOV  SI, ES:cfhoCf[DI]
	MOV  rcboCf, SI
; Count up cachedFile.cRef
	MOV  ES, WORD PTR pCachedFiles+2
	INC  ES:cfcRef[SI]
	MOV  DH, ES:cfcWriteLock[SI]

ACLHRet:	; DH=cfcWriteLock when rcboCf <> 0
	RET
AgentCacheLookupHandle ENDP

AgentCacheFlush PROC NEAR
; ES:BX point to cachedFile block
; ES:DI point to nodeFlush
; DS:SI point to fid, preserved
	PUSH SI
; Link flushed cachedFile onto free list
	MOV  AX, ES:cfboFree[BX]
	MOV  ES:cfoNext[DI], AX
	MOV  ES:cfboFree[BX], DI

; Free any cachedFh structures for this cachedFile.
; Assert: all cachedFh.fh are modePeek or modeZombie.
	LES  SI, SS:pCachedFhs
ACFFhLoop:
	MOV  BX, SI
ACFFhStutter:
	MOV  SI, ES:cfhoNext[BX]
	CMP  SI, SS:WORD PTR pCachedFhs
	JE   ACFFlushCp
	CMP  ES:cfhoCf[SI], DI
	JNE  ACFFhLoop
; cachedFh was for this flushed cachedFile.  Free cachedFh.
; ES:BX point to nodePrev
; ES:SI point to nodeFlush
	MOV  AX, ES:cfhoNext[SI]			; AX=nodeFlush.oNext
	MOV  ES:cfhoNext[BX], AX			; nodePrev.oNext=AX
	XCHG AX, BX							; ES:AX point to nodePrev
	MOV  BX, SS:WORD PTR pCachedFhs 	; ES:BX point to cachedFhBlock
	CMP  ES:cfboTail[BX], SI
	JNE  ACFDisposeCfh
	MOV  ES:cfboTail[BX], AX			; New tail ptr = nodePrev
ACFDisposeCfh:
; Link flushed cachedFh onto free list
	MOV  CX, ES:cfboFree[BX]
	MOV  ES:cfoNext[SI], CX
	MOV  ES:cfboFree[BX], SI
	XCHG AX, BX
	JMP  Short ACFFhStutter

ACFFlushCp:
; Flush cache pool of any blocks dedicated to flushed cachedFile
	PUSH AX			; cSelectedRet reserved on stack
	MOV  AX, SP
	PUSH SS:WORD PTR cphAgentCache+2
	PUSH SS:WORD PTR cphAgentCache
	PUSH CS
	PUSH OFFSET WsAgentGroup:cidMask
	PUSH SS:WORD PTR pCachedFiles+2		; pcfFileIdentifier.sa
	LEA  BX, cfFileIdentifier[DI-4]		; cid is |vda|fid|
	PUSH BX
	PUSH mCacheValid					; mask=mCacheValid, value=0 invalidates
	PUSH 0
	PUSH SS
	PUSH AX
	CALL CacheFlush;(cph, pCidMask, pCidTemplate, wMask, wValue, pCSelectedRet)
	POP  AX			; cSelectedRet, who cares

	POP  SI
	RET
AgentCacheFlush ENDP

PUBLIC AgentCacheData
AgentCacheData PROC NEAR ; BX=oRcb, ES=saXBlock
	PUSH DS
	PUSH BP
	MOV  BP, SP
	PUSH WORD PTR rcbFlags			; For LockIn check on Release
	PUSH ES							; saXBlock, for POP before MOVS
	MOV  AX, ES:[xbrqLfa]
	MOV  DX, ES:[xbrqLfa+2]
	MOV  DI, ES:[xbRqpsDataRet]		;DI = byte index in buffer of count
	MOV  CX, ES:[xbCbDataSent+DI]	;CX = count of data transferred
	MOV  SI, ES:[xbRqErcRet]
	MOV  ES, WORD PTR pCachedFiles+2
	MOV  DI, rcboCf
	CMP  ES:cfcWriteLock[DI], 1		; 0 or 1 = no write outstanding
	JG   ACDRetJmp					; Don't cache when writes outstanding
	CMP  ES:cfcWriteLock[DI], cfLocked+1 ; 80h or 81h ditto
	JA   ACDRetJmp					; Don't cache when writes outstanding
	OR   ES:BYTE PTR cfcRef[DI], cfTryCache	; cf has data in cache (hopefully)
	TEST ES:cfLfaFlags[DI], cfLfa30Bit
	JZ   ACD32
	AND  DX, 3FFFh					; Strip override,noretry bits
ACD32:
; Build cid
	PUSH ES:WORD PTR cfFileIdentifier[DI+2]
	PUSH ES:WORD PTR cfFileIdentifier[DI]
	PUSH DX							; lfa
	PUSH AX
; If ercEom, set cfLfaLast.
	CMP  SI, ercEom
	JE   SetLfaLast
	CMP  SI, ercOk
	JE   NoEom
ACDRetJmp:
	JMP  ACDRet						; Some other erc, don't cache.
SetLfaLast:
	JCXZ NoEom						; cbRet=0 -> not true EOM
	ADD  AX, CX
	ADC  DX, 0
	MOV  AL, ES:cfLfaFlags[DI]		; Preserve cfLfaFlags
	AND  AL, NOT cfLfaInvalid
	MOV  ES:WORD PTR cfLfaLast[DI], AX
	MOV  ES:WORD PTR cfLfaLast[DI+2], DX
NoEom:
	MOV  AX, SP						; cid address
	SUB  SP, 8						; pBlockRet, pCehRet
; Probe cache
	PUSH WORD PTR cphAgentCache+2
	PUSH WORD PTR cphAgentCache
	PUSH SS							; pCid
	PUSH AX
	PUSH 0
	SUB  AX, 4
	PUSH SS							; ppBlockRet
	PUSH AX
	SUB  AX, 4
	PUSH SS							; pCehRet
	PUSH AX
	CALL CacheGetEntry				;(cph, pCid, wFlags, ppBlockRet, pCehRet)
	CMP  AX, ercOk
	JE   ACDStore
	CMP  AX, ercCacheMiss
	JNE  ACDRet
ACDStore:
	POP  AX							; cehRet
	POP  DX
	POP  DI							; pBlockRet
	POP  ES
 	ADD  SP, 8						; pop cid
	POP  DS							; saXBlock
	MOV  SI, DS:[xbrqpBuf]
	ADD  SI, xbCbDataSent			;byte index in buffer of data
	MOV  CX, SS:sAgentCacheBlock
	%MOVGOOD

; Release cache block.
	POP  CX							; rcbFlags
	PUSH SS:WORD PTR cphAgentCache+2
	PUSH SS:WORD PTR cphAgentCache
	PUSH DX							; cehRet
	PUSH AX
	AND  CX, rcbLockIn
	JZ   ACDMask
	MOV  CX, mCacheSticky
ACDMask:
	PUSH CX							; rcbCache:(0,0)
	PUSH CX							; rcbLockIn:(mCacheSticky,mCacheSticky)
	CALL CacheReleaseEntry			; (cph, ceh, wMask, wValue) 

ACDRet:
	MOV  SP, BP
	POP  BP
	POP  DS
	RET
AgentCacheData ENDP

ACWRetJmp:
	JMP  ACWRet

AgentCacheWrite PROC NEAR
; ES:DI point to write rq
; BX points to rcb
	PUSH BP
	MOV  BP, SP
; Flush because of Write or UnlockInCache.
	MOV  AX, sAgentCacheBlock
	DEC  AX

	MOV  CX, ES:rqsBuf[DI]
	JCXZ ACWRetJmp
	MOV  DX, ES:rqLfa[DI]
	AND  DX, AX
	ADD  CX, DX					;CX=size spanning cache blocks
	NOT  AX
	AND  AX, ES:rqLfa[DI]
	MOV  DX, ES:rqLfa[DI+2]		;(DX,AX)=lfa of 1st block affected

; For write, mark cachedFile dirty.
	CMP  ES:WORD PTR [rqCode+DI], rcUnlockInCache
	MOV  ES, WORD PTR pCachedFiles+2
	MOV  DI, rcboCf
	JE   Short ACWCid

; Lock cachedFile for read update,
; mark dirty so modificationSync updated on close
; ("dirty" is inc'ing so will never dec to 0 again)
	TEST ES:cfcWriteLock[DI], cfWritten
	JNZ  ACWWriteLock
	STC
ACWWriteLock:
	ADC  ES:cfcWriteLock[DI], 1	; inc, +1 if was 0 (0->2)

ACWCid:
	TEST ES:cfcRef[DI], cfTryCache	; If not in cache, skip flush
	JZ   ACWRetJmp

	PUSH BX						; Save oRcb
; Build cid
	TEST ES:cfLfaFlags[DI], cfLfa30Bit
	JZ   ACWPushCid
	AND  DX, 3FFFh				; Strip override,noretry bits
ACWPushCid:
	PUSH ES:WORD PTR cfFileIdentifier[DI+2]
	PUSH ES:WORD PTR cfFileIdentifier[DI]
	PUSH DX							; lfa
	PUSH AX
	
%IF(0) THEN (%' Now notice ChangeFileLength, only scrag eom if being written.
; If any write to eom cache block or later, invalidate eom block.
; Eom block may be partially invalid, mustn't ever return invalid part.
; (If noticed ChangeFileLength, could know exactly where eom was.)
; Calculate (DX,AX) = lfaEndOfWrite.
	ADD  AX, CX
	ADC  DX, 0
	CMP  DX, ES: WORD PTR cfLfaLast[DI+2]
	JB   ACWNotEom
	MOV  BX, sAgentCacheBlock
	NEG  BX
	AND  BX, ES: WORD PTR cfLfaLast[DI]
	CMP  AX, BX
	JBE  ACWNotEom
; Write passes lfaLast cache block.  Invalidate that block.
	PUSH ES: WORD PTR cfLfaLast[DI+2]
	PUSH BX
	MOV  ES: WORD PTR cfLfaLast[DI], 0FFFFh
	MOV  ES: WORD PTR cfLfaLast[DI+2], 0FFFFh
	JMP  Short ACWFlushOneBlock
ACWNotEom:
	PUSH 0
	PUSH 0
)FI%'

ACWFlushOneBlock:
	SUB  SP, 8						; pBlockRet, pCehRet
	PUSH CX							; Save cbToFlush

; Probe cache
	PUSH WORD PTR cphAgentCache+2
	PUSH WORD PTR cphAgentCache
	LEA  AX, [BP-10]
	PUSH SS							; pCid
	PUSH AX
	PUSH mCacheDontSteal
	LEA  AX, [BP-14]
	PUSH SS							; ppBlockRet
	PUSH AX
	LEA  AX, [BP-18]
	PUSH SS							; pCehRet
	PUSH AX
	CALL CacheGetEntry				;(cph, pCid, wFlags, ppBlockRet, pCehRet)
	CMP  AX, ercOk
	POP  CX
	POP  AX							; cehRet
	POP  DX
	POP  BX							; pBlockRet
	POP  BX
	JNE  ACWNext					; erc <> ercOk

	PUSH CX							; Save cbToFlush
; Release cache block, invalidating it.
	PUSH WORD PTR cphAgentCache+2
	PUSH WORD PTR cphAgentCache
	PUSH DX							; cehRet
	PUSH AX
	PUSH mCacheValid				; mask=Valid, value=0 means invalidate
	PUSH 0
	CALL CacheReleaseEntry			; (cph, ceh, wMask, wValue) 
	POP  CX

ACWNext:
	MOV  AX, sAgentCacheBlock
	ADD  WORD PTR [BP-10], AX
	ADC  WORD PTR [BP-8],  0
	SUB  CX, AX
	JA   ACWFlushOneBlock

%IF(0) THEN (
	POP  AX							; lfaLast <> 0?
	POP  DX
	MOV  CX, AX
	OR   CX, DX
	JCXZ ACWDone
	MOV  [BP-10], DX				; Flush that block too.
	MOV  [BP-8], AX
	XOR  CX, CX
	JMP  ACWNotEom
)FI%'

ACWDone:
	ADD  SP, 8						; pop cid
	POP  BX							; oRcb

ACWRet:
	POP  BP
	RET
AgentCacheWrite ENDP

PUBLIC AgentCacheSatisfyRead
AgentCacheSatisfyRead PROC NEAR	; Return Z flag: success or failure.
; ES points to xblock
; BX points to rcb
	PUSH ES							; Save for later
	PUSH BX
	MOV  AX, ES:[xbrqLfa]
	MOV  DX, ES:[xbrqLfa+2]
	MOV  ES, WORD PTR pCachedFiles+2
	MOV  DI, rcboCf
; If no cache entries for this cf, return early
	TEST ES:cfcRef[DI], cfTryCache
	JNZ  ACSRCid
	POP  BX							; oRcb saved
	POP  ES							; saReqXBlock saved
	OR   AX, 1						; clear Z flag
	JMP  ACSRRet
ACSRCid:
; Build cid
	TEST ES:cfLfaFlags[DI], cfLfa30Bit
	JZ   ACSRPushCid
	AND  DX, 3FFFh					; Strip override,noretry bits
ACSRPushCid:
	PUSH ES:WORD PTR cfFileIdentifier[DI+2]
	PUSH ES:WORD PTR cfFileIdentifier[DI]
	PUSH DX							; lfa
	PUSH AX
	MOV  AX, SP						; cid address
	PUSH ES:WORD PTR cfLfaLast[DI+2]; save in case block found
	PUSH ES:WORD PTR cfLfaLast[DI]
; Probe cache
	PUSH WORD PTR cphAgentCache+2
	PUSH WORD PTR cphAgentCache
	PUSH SS
	PUSH AX
	PUSH mCacheDontSteal
	PUSH saReqXBlock				; ppBlockRet
	PUSH xbrqpBuf
	LEA  AX, ceh
	PUSH SS
	PUSH AX
	CALL CacheGetEntry				;(cph, pCid, wFlags, ppBlockRet, pCehRet)
	POP  CX							; lfaLast saved
	POP  DX
	ADD  SP, 8						; pop cid
	POP  BX							; oRcb saved
	POP  ES							; saReqXBlock saved
	OR   AX, AX
	JNZ  ACSRRet
; Found block matching read request piece.  Satisfy piece locally.
;  If eof block, trim returned size, set ercEom.
; (DX,CX)=lfaLast
	MOV  AX, ES:[xbrqLfa+2]	
	TEST CX, cfLfa30Bit
	JZ   ACSR32
	AND  AX, 3FFFh					; Strip override,noretry bits
ACSR32:
	CMP  DX, AX
	MOV  AX, sAgentCacheBlock
	JA   ReturnCacheData
	JE   CheckEofBlock
PastEofBlock:
; User lfa long past eof.  0 sDataRet.
	XOR  AX, AX
	JMP  ReturnCacheData
CheckEofBlock:
	TEST CX, cfLfaInvalid
	JNZ  ReturnCacheData			; Not really eof block, lfaLast invalid
	XOR  CL, CL						; remove cfLfa flags
	MOV  DX, CX						; save ibEof
	DEC  AX
	AND  DX, AX
	NOT  AX
	AND  CX, AX
	NEG  AX							; AX=sAgentCacheBlock
	CMP  CX, ES:[xbrqLfa]
	JB   PastEofBlock
	JNE  ReturnCacheData
; Eof block.  Trim sDataRet, set ercEom.
	XCHG AX, DX						; AX=ibEof in last block
	CMP  ES:WORD PTR [xbRqErcRet], ercOk
	JNE  ReturnCacheData
	MOV  ES:WORD PTR [xbRqErcRet], ercEom
ReturnCacheData:
	PUSH WORD PTR rcbFlags			;Remember how to release
	CALL CachedDataReturnedOk		;ES=saXBlock, BX=oRcb, AX=sDataRet
; .. and unlock cache block.
	POP  AX
	PUSH WORD PTR cphAgentCache+2
	PUSH WORD PTR cphAgentCache
	PUSH WORD PTR ceh+2
	PUSH WORD PTR ceh
	AND  AX, rcbLockIn
	JZ   ACSRRelease
	MOV  AX, mCacheSticky
ACSRRelease:
	PUSH AX
	PUSH AX
	CALL CacheReleaseEntry			; (cph, ceh, wMask, wValue) 
	XOR  AX, AX						; Set Z flag
ACSRRet:
	RET
AgentCacheSatisfyRead ENDP


public SsRaFromO

SsRaFromO proc far
	push bp
	mov  bp, sp
	mov bx, word ptr [bp+6]
	push ss
	pop es
	pop  bp
	ret 2	
SsRaFromO endp
)FI%' AgentCache

WsAgentCode ENDS

; LOG
; 7/23/84 by Jim Frandeen: Created file
; 12/3/84 by Jim Frandeen: If termination request did not come from a system
; exchange, treat it like a normal request.
; 3/1/85 by Jim Frandeen: Fix bug that caused requests to fail if they had odd
; number of control info bytes. Change protocol for iFrames: when we send an
; IFrame, if we have another iFrame queued, set the high bit of xbCbDataSent
; (the second word of the frame) to tell the master to poll us again. Do this
; only the the revision level of the master > 90h.
; 3/15/85 by JA: add LEA SI, ucbPrefix+1[BX] so prefix would get expanded.
; 4/1/85 by Jim Frandeen: Move OpenRtc and Init code to InitWs1.plm
; 4/28/86 by DR: ctosp - do not reference pAscb if zero
; 5/13/86 by RLM: ES not set up in MasterWentDown causes DS to be put on free
; list
; 5/22/86 by JA: Don't return erc608. Hack so Vacated partitions are useable
; when re-created.
; 8-21/86 by RLM: getrqLevel strips level off of AX (rqCode) on return
; incorrect rqcode stored in termination packet sent to master.
; 9/23/86 by DR: CTOS II 2.0 merge
; 12/22/86 JA Only expand pwd in 2nd pbcb, not 3rd...
;  2/05/87 RLM moverequestdata must do byte and word move or GP fault.
;  2/18/87 RLM don't pick up cb of request until validitation of read/write
;  rq, caused limit fault.
;  9/22/87 JM/RLM, PUBLIC rqClock.
;  10/1/87 JM, remove code for special handling of termination requests - 
;		termination requests now handled like simple requests.
;		Also add prgRqNoRemoteTermination list of requests which cause
;		fRqSentToMaster not to be set.
;  10/29/87 JA/RLM remove sXbMax to sysgen.
;  12-23-87 RLM clear utflags in masterwentdown so setwsusername will be sent
;				when master comes back up.
;  04/21/88 JM use long pointer to address UCB.
;  08/22/88 JM remove obsolete FSysRequest.
;  11/02/88 JM remove spec expansion - now done in the kernel.
;  11/16/89 JA MasterWentDown clear utFlags.
;  02/26/90 JA add FSrpUpProc, FMasterRqSentTestAndClear.
;  03/01/90 JA add exchAgent PUBLIC.
;  04/16/90 AT Merged CTOS/XE 3.0 and CTOS/VM 3.3.
;  04/26/90 DR After piecemeal read, check for nil psDataRet before store
;  04/26/90 JC Added allocated user number support
;              Added BTOS fRebootClstr feature 
;  08/22/90 JA ProcessMsgLph check xblock out first so faster ack to master.
;  08/23/90 JA Fill XBlocks when rcb received:  Lph ready to send when polled.
;  09/28/90 JA/JMR MasterWentDown free saXBlockCurrent too.
;  11/26/90 JC Changed fRebootClstr variable to pfRebootClstr
;  12/13/90 JA Add AgentCache code.  Reorder some stmts to accomodate.
;  01/04/91 JA LockInCache, UnlockInCache.
;  01/16/91 JM make cache only look at file system requests.
;  02/08/91 JA QueueFrame put xblock to send on end of rcb.saXBlockOut list.
;  03/07/91 JC Add check for request data greater than xblock size
;  03/13/91 JM fix 03/07/91 netRouting lookup.
;  04/03/91 JA Fix AgentCache LockInCache, UnlockInCache, noFreeCachedFile.
;  04/03/91 JA Fix AgentCache maybe duplicate cfh; check fid.checksum.
;  04/16/91 JF When RemoteTerm response passes through, flush rcb queue
;			for any other rcbs that belong to user being terminated.
;			Remove IWS code.
;  05/02/91 JA Fix AgentCacheUnregisterHandle to preserve AX for ACUHStutter.
;  05/03/91 JA Fix AgentCacheRegisterHandle to avoid duplicate cfh.
;  05/14/91 by JF, Move ReInitXBlocks to Agent process from LPH.
;  05/28/91 by JF, When we verify XBlock count, include the ones we
;				threw away because of DMA boundary.
;				Change logic of RemoteTermination: change rcbs to stateReset
;				until response comes back from server.  Fix remote term
;				to get ercRet from remote term request.
;  05/29/91 JA/mtr Restore SI properly after building cf (cf. ACRHAddCfMRU - 1)
;--3.3 shipped--
;  08/07/91 JM  merge Affie's GetClstrGenerationNumber stuff.
;  02/27/92 JA  SendSimpleRcb don't do cache stuff if no cache.
;  10/19/92 JA  Agent Cache notice ChangeFileLength, SetFileStatus(17).
;  12/03/92 JA  AgentCacheWrite push 0,0 gone, fix BP-'s.
;  12/22/92 JA  fix ercEom problem with agent cache.
;  3/12/93  JA  Set cflfaLast only if cbRet <> 0.  SetFileStatus in rgCacheRc.
;  3/19/93  JA  cfLfaFlags[DI] not [SI] in AgentCacheSatisfyRead.
;  4/06/93  JF  Init rcbs here instead of in InitClstr so we can use DS
;				allocation with soft bus version of cluster.
;  5/26/93  JA  HandleResponse leave ercRet if not ercOk and server returned
;				erc too(for LfsToMaster).
;				Also HandleRequest ditto if master down.
;  6/07/93  JA  HandleRequest don't clear rqErcRet!
;  6/17/93  JM  synchronize with WsLph to not queue multiple msgLph's on 
;				exchAgent - cures ercNoLinkBlock crash on busy systems.
;				don't crash on ercBadUserNum.
;				FMasterRqSentTestAndClear clears the fRqSentToMaster bit!
