		NAME	PCHWS
		PAGE	60,132
		TITLE	20 MAY 85: BATCH+ Working Storage
		.SALL

Code		SEGMENT	WORD PUBLIC 'Code'
Code		ENDS
Data		SEGMENT	PARA PUBLIC 'Data'
Data		ENDS
Stack		SEGMENT	PARA STACK 'Stack'
Stack		ENDS

		ASSUME	CS:Code
		ASSUME	DS:Data
		ASSUME	SS:Stack
		ASSUME	ES:Nothing

		INCLUDE	PCHEQUS.INC

;..............................................................................
;
;	Create a pre-defined entry in the Symbol Table (i.e. the original
;	entries for the reserved words)

SymDec		MACRO	$Symbol,$Routine,$Operator,$SignBit
IFIDN <$Symbol>,<>
 IF1
		%OUT	***Both Symbol and Routine names must be present
 ENDIF
		EXITM
ENDIF
IFIDN <$Routine>,<>
 IF1
		%OUT	***Both Symbol and Routine names must be present
 ENDIF
		EXITM
ENDIF
SymDec$		=	THIS NEAR
		DB	'&$Symbol'
IF 8-($-SymDec$)
		DB	8-($-SymDec$) DUP(' ')
ENDIF
IFIDN <$Operator>,<>
		DW	$+5
		DB	MASK ST$Reserved OR MASK ST$True
ELSE
 IFIDN <$Operator>,<FUNCTION>
		DW	$+5
		DB	MASK ST$Reserved OR MASK ST$Function OR MASK ST$True
 ELSE
		DW	$+6
		DB	MASK ST$Reserved OR MASK ST$Operator OR MASK ST$True
 ENDIF
ENDIF
Code		SEGMENT
		EXTRN	$Routine&:NEAR
Code		ENDS
		DW	$Routine
IFDIF <$Operator>,<>
 IFDIF <$Operator>,<FUNCTION>
  IFIDN <$SignBit>,<SignBit>
		DB	80h OR $Operator
  ELSE
		DB	$Operator
  ENDIF
 ENDIF
ENDIF
		ENDM

;..............................................................................
;
;	Declare a fixed (reserved) data variable in the Symbol Table

SymItem		MACRO	$Name,$Value,$Boolean,$Type
IFIDN <$Name>,<>
 IF1
		%OUT	***Both Name and TRUE or FALSE must be present
 ENDIF
		EXITM
ENDIF
IFIDN <$Boolean>,<>
 IF1
		%OUT	***Both Name and TRUE or FALSE must be present
 ENDIF
		EXITM
ELSE
 IFIDN <$Boolean>,<TRUE>
 ELSE
  IFDIF <$Boolean>,<FALSE>
   IF1
		%OUT	***Invalid TRUE or FALSE parameter
   ENDIF
		EXITM
  ENDIF
 ENDIF
ENDIF
SymItem$	=	THIS NEAR
		DB	'&$Name'
IF 8-($-SymItem$)
		DB	8-($-SymItem$) DUP(' ')
ENDIF
IFIDN <$Value>,<>
		DW	$+6
ELSE
		DW	$+5
ENDIF
IFIDN <$Boolean>,<TRUE>
 IFIDN <$Type>,<CHAR>
		DB	MASK ST$True	;Implied CHAR
 ELSE
		DB	MASK ST$Decimal OR MASK ST$Numeric OR MASK ST$True
 ENDIF
ELSE
 IFIDN <$Type>,<CHAR>
		DB	0		;FALSE, implied CHAR
 ELSE
		DB	MASK ST$Decimal OR MASK ST$Numeric
 ENDIF
ENDIF
IFIDN <$Value>,<>
		DW	$+2
		DB	0
ELSE
 IFNDEF $Value
Code		SEGMENT
		EXTRN	$Value&:BYTE
Code		ENDS
 ENDIF
		DW	$Value
ENDIF
		ENDM

		PAGE

Data		SEGMENT

		PUBLIC	HashTable,UAdd,USub,SymbolTable,Environment,SymbolEnd

		EVEN
HashTable	LABEL	WORD
		DW	256 DUP(0)	;Mark as all empty to start

ValueFalse	DB	3,0,0,0,0FFh
ValueTrue	DB	3,0,0,1,0FFh
ValueQuote	DB	1,'"',0FFh

		EVEN
UAdd		LABEL	BYTE
		SymDec	?,UnaryAdd,OP$ADD,SignBit

USub		LABEL	BYTE
		SymDec	?,UnarySub,OP$SUB,SignBit

SymbolTable	LABEL	BYTE
		SymDec	OPTIONS,OptionRtn
		SymDec	OP,OptionRtn
		SymDec	OPTN,OptionRtn
		SymDec	IF,IfRtn
		SymDec	WHILE,WhileRtn
		SymDec	XIF,XifRtn
		SymDec	ELSE,ElseRtn
		SymDec	BEGIN,BeginRtn
		SymDec	END,EndRtn
		SymDec	DO,DoRtn
		SymDec	UNTIL,UntilRtn
		SymDec	ASSIGN,AssignRtn
		SymDec	SET,SetRtn
		SymDec	DEBUG,DebugRtn
		SymDec	DISCARD,DiscardRtn
		SymDec	ABTIF,AbortIfRtn
		SymDec	ABORT,AbortRtn
		SymDec	KEYIN,KeyInRtn
		SymDec	BEEP,BeepRtn
		SymDec	CLICK,ClickRtn
		SymDec	INCLUDE,IncludeRtn
		SymDec	EXIT,ExitRtn
		SymDec	STOP,StopRtn
		SymDec	OPEN,OpenRtn
		SymDec	CLOSE,CloseRtn
		SymDec	READ,ReadRtn
		SymDec	WRITE,WriteRtn
		SymDec	LOGON,LogOnRtn
		SymDec	LOGOFF,LogOffRtn
		SymDec	STAMP,StampRtn
		SymDec	SIGNAL,SignalRtn
		SymDec	USERPROG,UserProgRtn
		SymDec	FFILE,FindFileRtn,FUNCTION
		SymDec	FPROT,FileProtRtn,FUNCTION
		SymDec	BIT,BitRtn,FUNCTION
		SymDec	UNBIT,UnBitRtn,FUNCTION
		SymDec	TTYPE,TypeRtn,FUNCTION
		SymDec	&,LogicalAND,OP$AND
		SymDec	|,LogicalOR,OP$OR
		SymDec	&&,BinaryAND,OP$LAND
		SymDec	||,BinaryOR,OP$LOR
		SymDec	!(,BadStatement,OP$LParen
		SymDec	!),BadStatement,OP$RParen
		SymDec	##,BreakPoint
		SymDec	!+,Add,OP$ADD
		SymDec	!-,Subtract,OP$SUB
		SymDec	~,LogicalNOT,OP$NOT
		SymDec	!*,Multiply,OP$MUL
		SymDec	!/,Divide,OP$DIV
		SymDec	!!,BinaryXOR,OP$XOR
		SymDec	!>!>,ShiftRight,OP$SHR
		SymDec	!<!<,ShiftLeft,OP$SHL
		SymDec	!=,Equals,OP$EQ
		SymDec	!<,LessThan,OP$LT
		SymDec	!>,GreaterThan,OP$GT
		SymDec	!>!=,NotLess,OP$GEQ
		SymDec	!<!=,NotGreater,OP$LEQ
		SymDec	!~!=,NotEqual,OP$NEQ
		SymDec	\,Replace,OP$Replace
		SymDec	\\,Concatenate,OP$Concat
		SymDec	.,LengthOf,OP$Length
		SymDec	!:,SSPrep,OP$SSP
		SymDec	^,Substring,OP$SSTR
		SymDec	[,Match,OP$Match
		SymDec	[[,ScanDelimiter,OP$Scan
		SymDec	~[[,ScanUneq,OP$ScanUnequal
		SymItem	NULL,,TRUE,CHAR
		SymItem	FALSE,ValueFalse,FALSE,NUMERIC
		SymItem	NO,ValueFalse,FALSE,NUMERIC
		SymItem	OFF,ValueFalse,FALSE,NUMERIC
		SymItem	QQUOTE,ValueQuote,TRUE,CHAR
		SymItem	TRUE,ValueTrue,TRUE,NUMERIC
		SymItem	YES,ValueTrue,TRUE,NUMERIC
		SymItem	ON,ValueTrue,TRUE,NUMERIC

Environment	LABEL	BYTE
		SymItem	DOSLEVEL,DosVersion,TRUE,NUMERIC
		SymItem	MEMSIZE,MemorySize,TRUE,NUMERIC
		SymItem	ABTFLAG,AbortFlag,FALSE,CHAR
		SymItem	PRTAVAIL,PrtAvailable,FALSE,NUMERIC
		SymItem	BOOTDRV,BootDrive,TRUE,NUMERIC
		SymItem	CHNCMDFL,ChainCmdFile,FALSE,CHAR
		SymItem	CMDLINE,CommandLine,FALSE,CHAR

SymbolEnd	DB	0FFh		;End of the Symbol Table
		DB	511 DUP(0)

Data		ENDS

		END
