		PAGE	60,132
		TITLE	21 MAY 85: BATCH+ Command Line Scanner

ProgramPrefix	SEGMENT	AT 0
ProgramPrefix	ENDS
Code		SEGMENT	WORD PUBLIC 'Code'
Code		ENDS
Data		SEGMENT	PARA PUBLIC 'Data'
Data		ENDS
Stack		SEGMENT	PARA STACK 'Stack'
Stack		ENDS

		ASSUME	CS:Code
		ASSUME	DS:Data
		ASSUME	SS:Stack
		ASSUME	ES:ProgramPrefix

		INCLUDE	PCHEQUS.INC

ProgramPrefix	SEGMENT
ProgramExit:	INT	20		;Terminate the program
		DB	8		;Reserved for MS-DOS
TerminateAddr	DD	?		;Termination address
CtrlCAddr	DD	?		;CtrlC--C exit address
HardErrorAddr	DD	?		;Fatal error exit address
ReservedMsDos	DB	30 DUP(?)	;Reserved for MS-DOS
DosFunction:	INT	21		;Guaranteed call to DOS Functions
		RET
		DB	9 DUP(?)	;Reserved for MS-DOS
FCB1		DB	16 DUP(?)	;Unopened FCB for file 1
FCB2		DB	16 DUP(?)	;Unopened FCB for file 2
		DB	8 DUP(?)	;Reserved for MS-DOS
UnformattedParm	DB	128 DUP(?)	;Command line after command name
ProgramPrefix	ENDS

Stack		SEGMENT
		DB	512 DUP(0)
Stack		ENDS

Data		SEGMENT
		EXTRN	SymbolTable:BYTE,CurrentSymbol:BYTE

PspBase		DW	?		;Segment base of Program Segment Prefix
InputFH		DW	?		;File Handle of Batch+ script
CmdSize		DB	?		;Size of unformatted parameters below
CmdLine		DB	128 DUP(?)	;Copy of command line parameters
SignOn		DB	'BatchPlus 1.0  21 MAY 85$'
TestName	DB	'A:\TEST.CHN',0

Data		ENDS

Code		SEGMENT
		EXTRN	MakeTree:NEAR,ClearCurrSymbol:NEAR,BadCommandLine:NEAR
		EXTRN	SymbolLookup:NEAR,SymbolCreate:NEAR

CmdStart:	INT	3		;Debug (change to NOP in final release)
		PUSH	DS		;Save original data segment base
		XOR	AX,AX		;Mark stack with a zero return
		PUSH	AX
		MOV	AX,Data		;Initialize our own data segment
		MOV	ES,AX		;But keep it in ES for a while
		MOV	ES:PspBase,DS	;Keep a copy of Program Segment Prefix
		CLD			;Block transfer in upward direction
		MOV	SI,OFFSET UnformattedParm	;Point into PSP params
		MOV	DI,OFFSET CmdSize	;Save area for CmdLine
		LODSB			;AL = count of bytes in command line
		STOSB			;Keep it whether zero or not
		XOR	AH,AH
		MOV	CX,AX		;Transfer to CX for loop control
		 JCXZ	NoParms
		REPNZ MOVSB		;Keep a copy of the Command Line...
NoParms:	MOV	AX,ES		;Move data segment base...
		MOV	DS,AX		;...into DS where it belongs
		MOV	AH,09h		;Display string
		MOV	DX,OFFSET SignOn
		INT	21h
		MOV	BX,OFFSET SymbolTable	;Hash the Symbol Table into...
		CALL	MakeTree	;...multiple trees rooted in Hash Table
		MOV	AX,3D00h	;Open the input CHAIN file
		MOV	DX,OFFSET TestName
		INT	21h
		 JB	SHORT Exit
		MOV	InputFH,AX	;Keep copy of input file handle
		CALL	SetEnvironment
		CMP	CmdSize,0	;Any keywords on parameter line?
		 JE	SHORT NoSpecs	;Nope
		PUSH	DS		;Maybe...look for ';' before keywords
		POP	ES
		MOV	DI,OFFSET UnformattedParm
		MOV	AL,';'
		MOV	CL,CmdSize
		XOR	CH,CH
		REPNZ SCAS UnformattedParm
		 JNE	SHORT NoSpecs	;Parameters, but no semicolon
ParseCommand:	CALL	ClearCurrSymbol	;Get and clear a symbol area
NextCommand:	LODSB			;Get the next character
		CMP	AL,','		;Ignore strings of commas...
		 JE	NextCommand
CmdCat:		STOSB			;Add the new character onto the symbol
		LODSB			;Get the next character
		CMP	AL,' '		;Control?
		 JE	SHORT BreakSymbol	;Yes, end of symbol name
		CMP	AL,'='		;Start of assignment?
		 JNE	CmdCat		;Not yet, keep on building
BreakSymbol:	MOV	SI,OFFSET CurrentSymbol	;SI ==> start of name
		CMP	BYTE PTR [SI],' '	;Empty symbol?
		 JE	BadCommandLine	;Yes, bomb out
		CALL	SymbolLookup	;Check if the symbol is a reserved word
		 JNZ	ReservedWord	;It had better be 'OPTIONS='...
		MOV	AL,[SI]		;Symbol names must start out alpha...
		MOV	BX,OFFSET XlatTable
		XLAT
		OR	AL,AL		;Zero = alphabetic ASCII
		 JNZ	BadCommandLine	;Too bad!
SymbolAlpha:	CALL	SymbolCreate	;Valid name, create an entry in table
NoSpecs		THIS	NEAR
ReservedWord	THIS	NEAR
Exit:		INT	3
		MOV	AX,4C00h	;Terminate process
		INT	21h
		JMP	$
Code		ENDS

;..............................................................................
;
;	Establish the initial environment values
;
;	The symbol table contains addresses of routines that return the
;	appropriate data.  Execution of the routine(s) substitutes a
;	resolved value field for the routine address in the symbol table.
;	If necessary, values are allocated and initialized beyond the
;	current table and the table linkages fixed accordingly.

Data		SEGMENT

		EXTRN	Environment:BYTE
		EXTRN	SymbolEnd:BYTE
MaxDrive	DB	0

Data		ENDS

Code		SEGMENT

SetEnvironment	PROC
		MOV	AH,19h		;Get Current Disk number in AL
		INT	21h
		MOV	AH,0Eh		;Select Disk and set it...
		MOV	DL,AL		;...to current disk just returned
		INT	21h
		MOV	MaxDrive,AL	;Total number of drives supported
		MOV	BX,OFFSET Environment	;Variables in symbol table
EnvironLoop:	MOV	DX,BX		;Calculate next entry
		ADD	DX,0Dh
		PUSH	DX		;And save it so routines need not
		CALL	[BX].ST$ValueLink	;Resolve value of variable
		POP	BX			;Onward to the next entry
		CMP	BX,OFFSET SymbolEnd	;End of the Symbol Table?
		 JNE	EnvironLoop
		RET
SetEnvironment	ENDP
Code		ENDS

;..............................................................................
;
;	The following are all routines to resolve initial environment
;	values.  They are called with BX ==> symbol table entry and alter
;	[BX+0Bh] to point to the value of the resolved variable.  GetSpace
;	is used to allocate new space in the symbol table.

Code		SEGMENT
		EXTRN	GetSpace:NEAR

		PUBLIC	DosVersion
DosVersion	PROC
		ADD	BX,0Bh		;BX ==> variable address field
		MOV	AL,2		;Need two bytes for version
		CALL	GetSpace	;This also fixes link in symbol table
		PUSH	BX		;Save it, BX ==> free space
		MOV	AH,30h		;Ask for DOS Version
		INT	21h
		POP	BX
		MOV	[BX],AX		;Major and minor versions stashed away
		RET
DosVersion	ENDP

		PUBLIC	MemorySize
MemorySize	PROC
		ADD	BX,0Bh
		MOV	AL,2
		CALL	GetSpace
		MOV	WORD PTR [BX],0
		RET
MemorySize	ENDP

		PUBLIC	AbortFlag
AbortFlag	PROC
		ADD	BX,0Bh
		MOV	AL,2
		CALL	GetSpace
		MOV	WORD PTR [BX],0
		RET
AbortFlag	ENDP

		PUBLIC	PrtAvailable
PrtAvailable	PROC
		ADD	BX,0Bh
		MOV	AL,2
		CALL	GetSpace
		MOV	WORD PTR [BX],0
		RET
PrtAvailable	ENDP

		PUBLIC	BootDrive
BootDrive	PROC
		ADD	BX,0Bh
		MOV	AL,2
		CALL	GetSpace
		MOV	WORD PTR [BX],0
		RET
BootDrive	ENDP

		PUBLIC	ChainCmdFile
ChainCmdFile	PROC
		ADD	BX,0Bh
		MOV	AL,2
		CALL	GetSpace
		MOV	WORD PTR [BX],0
		RET
ChainCmdFile	ENDP

		PUBLIC	CommandLine
CommandLine	PROC
		ADD	BX,0Bh
		MOV	AL,2
		CALL	GetSpace
		MOV	WORD PTR [BX],0
		RET
CommandLine	ENDP

Code		ENDS

		END	CmdStart
