PAGE	55,132
TITLE	(C) COPYRIGHT ADAPTEC, 1993 AIC-6360 BIOS Main Code
NAME	SBIOS
.286p

;****************************************************************************;
;                                                                            ;
;   Module Name:  AIC-6360 BIOS Main Code                   		     ;
;									     ;
;   basecode: 	  557304-00						     ;
;                                                                            ;
;   Author:       Tom Shea /Arlen Young                                      ;
;                                                                            ;
;   History:      10/21/88 First Revision Coded                              ;
;                 04/04/89 CKM - fixed dispatch table entry for function     ;
;                          20H (buffer control) in concurrent mode handler.  ;
;		  7/14/89  Added support for Int 19H servicing		     ;
;		  03/21/90 Editted for 1520.				     ;
;		  09/20/89  debug					     ;
;		  06/20/91  J.P. - Added floptical support, restructured     ;
;			    module to eliminate translation layer	     ;
;			    inherited from old 1540 BIOS, added		     ;
;			    pass-thru, support for new 255/63 BIOS	     ;
;			    translation scheme,support for new identify	     ;
;			    SCSI devices (AH=06) function		     ;
;									     ;
;		  02/10/92 REM Modified for TEAC FC-1-10 4M Floppy Support   ;
;			   All SCSI floppy support were moved to a separate  ;
;			   module.					     ;
;		  04/01/93 YWL - Modified base code # and banner for V1.01L  ;
;				 pilot release.				     ;
;	                                                                     ;
;   Description:  This module contains the Basic SCSI BIOS code which        ;
;                 should not generally change between versions for           ;
;                 different hardware and/or customers.                       ;
;                                                                            ;
;                 The SCSI BIOS allows Adaptec host adapters to support      ;
;                 up to 2 SCSI CCS hard drives under DOS without a device    ;
;                 driver.  The system may have a standard hard disk          ;
;                 controller running concurrently with the host adapter      ;
;                 BIOS with the total drive count limited to 2.              ;
;                 Booting capability is provided from the first hard         ;
;                 drive in the system.                                       ;
;                                                                            ;
;****************************************************************************;

;****************************************************************************;
;                                                                            ;
;   Copyright 1989-1993 Adaptec, Inc.  All rights reserved. This software contains;
;   the valuable trade secrets of Adaptec.  The software is protected under  ;
;   copyright laws as an unpublished work of Adaptec.  Notice is for infor-  ;
;   mational purposes only and does not imply publication.  The user of this ;
;   software may make copies of the software for use with parts manufactured ;
;   by Adaptec or under license from Adaptec and for no other use.           ;
;                                                                            ;
;****************************************************************************;


PAGE


;  Include Files

include sbios.inc
include biosequs.inc
include global.inc

SUBTTL External Routines
PAGE


CODE SEGMENT PUBLIC 'CODE'
ASSUME  CS:CODE,DS:NOTHING,ES:NOTHING,SS:NOTHING

; External Routines
EXTRN Do_DiskIO:near		;atsbios.asm
EXTRN ChkDsk:near		;atsbios.asm
EXTRN HaInit:near		;atsbios.asm
EXTRN HaInitCleanup:near	;atsbios.asm
EXTRN SetTmo:near		;atsbios.asm
EXTRN CheckTmo:NEAR		;atsbios.asm
EXTRN EnableTimer:near		;atsbios.asm
EXTRN PupDelay:near		;atsbios.asm
EXTRN set_scb_10:near		;atsbios.asm
EXTRN set000:near		;atsbios.asm
EXTRN set010:near		;atsbios.asm
EXTRN cvtstat:near		;atsbios.asm
EXTRN DspMsg_short:near		;atsbios.asm
EXTRN GetXlatMode:near		;atsbios.asm
EXTRN AllowRerouter:near	;atsbios.asm
EXTRN getxcfg1byte:near		;atsbios.asm

EXTRN Get_Jumpers:NEAR		;biosdrvr.asm
EXTRN rst_scsi:near		;biosdrvr.asm
EXTRN bios_driver:near		;biosdrvr.asm

EXTRN scsi_flop_init:near	;floppy.asm
EXTRN FlopCmdDone:near		;floppy.asm
EXTRN HDMediaTbl:near		;floppy.asm
EXTRN GetSecsPerTrk:near	;floppy.asm

EXTRN DosUtil:near		;format.asm or dummyfmt.asm based on options
				;picked

EXTRN InitMsg:near		;b636opt.asm
EXTRN LINEFD:near		;b636opt.asm
EXTRN DspMsg:near		;b636opt.asm
EXTRN Targ_0:near		;b636opt.asm
EXTRN NoDevices_Msg:BYTE
EXTRN ROM_BLOCKS:ABS            ;b636opt.asm

extrn Int4BInit:near		;int4b.asm

;  External data

EXTRN jmpmsg0:BYTE		;display messages in b636opt.asm
EXTRN jmpmsg1:BYTE
EXTRN jmpmsg2:BYTE		 ;	     .
EXTRN jmpmsg3:BYTE		 ;	     .
EXTRN jmpmsg4:BYTE		 ;	     .
EXTRN jmpmsg5:BYTE		 ;	     .
EXTRN jmpmsg6:BYTE		 ;	    \ /
EXTRN jmpmsg7:BYTE
EXTRN jmpmsg8:BYTE
EXTRN jmpmsg9:BYTE
EXTRN jmpms10:BYTE
EXTRN jmpms11:BYTE
EXTRN jmpms12:BYTE

EXTRN prog0:BYTE		;progress messages in b636opt.asm
EXTRN prog2:BYTE
EXTRN prog3:BYTE
EXTRN prog4:BYTE

;******************************************************************************
;
;	Sparrow device port definitions
;
;******************************************************************************

	EXTRN	BasePort:ABS		;base port address

dmacntrl1 EQU	BasePort+13h		;dma control 1			(write/read)
sparstack EQU	BasePort+1Dh		;16 byte stack in Sparrow	(write/read)


SUBTTL Code Segment: Identification Header
PAGE


; *** BIOS Identification Header ***

        DB      55H                     ;Id Byte #1
        DB      0AAH                    ;Id Byte #2
BIOSLEN DB      ROM_BLOCKS              ;BIOS Length in 512 byte Pages
        jmp     Near Ptr InitBio        ;Jump to Initialization

; *** Other Standardized entry points ***
        jmp     DosUtil                 ;Jump to Format Utility
	jmp     foreverloop             ;dummy DMA diagnostic

	db 'Adaptec BIOS:AIC-6360 Ver 1.20L',01h,00h
	db 'Copyright Adaptec,Inc. 1993'

; *** Default Drive Parameter Table ***


SUBTTL Code Segment: Bios Initialization
PAGE

; *** InitBio - Initialize SCSI BIOS into System
;
;       Entry: Nothing
;
;       Exit:  BP set to 1 if error occurred
;

        ASSUME DS:NOTHING,ES:NOTHING

	PUBLIC InitBio
InitBio proc    far

        call    InitMsg                 ;Display BIOS Initialization Banner

        ASSUME  DS:SysBioData
        mov     ax,SysBioData           ;Point DS to System BIOS Data area
        mov     ds,ax

        ASSUME  ES:IntVec
        mov     ax,IntVec               ;Point ES to Interrupt vector table
        mov     es,ax

        push    CurTim                  ;Push the current time
        push    CurTim+2
        mov     CurTim,0                ;Reset Current time
        mov     CurTim+2,0

        call    EnableTimer             ;Enable timer Interrupt for Timeouts

        call    HaInit                  ;Initialize host adapter hardware
        jnc   	init_routines
	mov	bp,1
	jmp	short InitBioDone

init_routines:

	call	scsi_flop_init		;floptical service routine init
	call	harddisk_init		;hard disk service routine init
	call	Int4BInit
	call	HaInitCleanup		;Finish ha init housekeeping

InitBioDone:

        mov     ax,CurTim               ;Get elapsed timer ticks
        pop     CurTim+2                ;Restore original timer count
        pop     CurTim
        add     CurTim,ax               ;and adjust for elapsed time
        adc     CurTim+2,0              ;ripple carry

        ret                             ;and return

InitBio endp


;  ** harddisk_init - hard disk service routine iniitialization **
;
;       Entry: DS --> System Data Area
;              ES --> Interrupt Vector Table
;
;       Exit:   BP = 1 if error occurred
;

harddisk_init	proc	near

	mov	Disk_or_Flopt,Disk_req	;Disk I/O requests coming up
	mov	cx,PUPTMO
        call    PupDelay                ;Delay for some drives to recover
                                        ;from a hard reset

        cmp     HrdCnt,2                ;How many drives already installed ?
        jae     TooManyDrvs             ;If 2 or more, we're done !
        cmp     HrdCnt,1
        jne     NoDrives
        call    SysInitCcr              ;If 1, setup for Target 0 as Drive D:

	IFDEF	B636			;for motherboard application,
	jc	InitFld$		;  don't return error to system BIOS
					;  for no SCSI drive connected.
	ELSE				;for 1520 application,
        jc      InitFld			;  return all errors to system BIOS.
	ENDIF

        jmp     BufInit

TooManyDrvs:
	mov	di,OFFSET prog0		;display message:
	call	DspMsg3			;  SCSI BIOS not installed.
	jmp	InitBi1

NoDrives:
        call    SysInitNcr              ;If 0, setup for Target 0 as Drive C:
					;and Target 1 as Drive D: if installed

	IFDEF	B636			;for motherboard applications,
	jc	InitFld$		;  don't return error to system BIOS
					;  for no SCSI drive connected.
	ELSE				;for 1520 application,
	jc	InitFld			;  return all errors to system BIOS.
	ENDIF

BufInit:

InitPsd:

InitBi1:
        mov     di,OFFSET LINEFD
        call    DspStr
        ret

InitBi2:
        mov     bp,0                    ;If passed, set Ok status
        ret

	IFDEF	B636
	EXTRN	vidmsg1:NEAR
InitFld$:
	cmp	di,OFFSET vidmsg1
	je	InitBi2			;jump if drive not connected:  no error
	ENDIF

InitFld:
        cmp	byte ptr Flopticals_found,1 ;no disk drives found - were
					    ;there any flopticals found?
	jne	indicate_error		    ;only report error if no
	jmp	short InitBi2	            ;disks or flopticals were found

indicate_error:
	mov	dl,2			;force delay in DspMsg_short	
	mov	di,OFFSET NoDevices_Msg
	call	DspMsg_short
        mov     bp,1                    ;If failed, flag error
	ret

harddisk_init	endp


SUBTTL SysInitNcr - Non-concurrent System Initialization
PAGE

; *** SysInitNcr - Non-concurrent System Initialization
;
;       Entry: DS --> System Data Area
;              ES --> Interrupt Vector Table
;
;       Exit:  C set if error occurred
;		BP is passed thru error exit from ChkDsk.
;                 (Required only for motherboard option.)
;

        ASSUME DS:SysBioData,ES:IntVec

SysInitNcr       proc    near

        mov     dl,00H                  ;Check if Target 0 is installed
        call    ChkDsk
        jnc     NcrInitCont             ;If not, initialization is done
        ret

NcrInitCont:
	mov	dl,0
	mov	di,OFFSET prog2		;display progress message
	call	DspMsg_short

        inc     HrdCnt                  ;Increment the system hard disk count

        cli                             ;Disable interrupts

        mov     ax,es:Int13H            ;Move floppy service from Int 13H
        mov     es:Int40H,ax            ;to Int 40H
        mov     ax,es:Int13H+2
        mov     es:Int40H+2,ax

        mov     es:Int13H,OFFSET NcrInt ;Set Int 13H to non-concurrent
        mov     es:Int13H+2,CS          ;SCSI Int 13H request handler

	call	Get_Jumpers		;boot jumper installed?
	test	ax,enboot
	jz	noboot			;  jump if no
	mov	es:Int19h,OFFSET BootReq ;Set Int 19h to boot handler
	mov	es:Int19h+2,CS		;address
noboot:

        sti                             ;Re-enable interrupts


	mov	di,OFFSET prog3		;display progress message
	call	DspMsg3

        mov     dl,01H                  ;Check if Target 1 is installed
        call    ChkDsk
        jc      NcrInitDone

	mov	dl,01h		
	mov	di,OFFSET prog4		;display progress message
	call	DspMsg_short

        inc     HrdCnt


NcrInitDone:

        clc
        ret

SysInitNcr       endp


SUBTTL SysInitCcr - Concurrent System Initialization
PAGE

; *** SysInitCcr - Concurrent System Initialization
;
;       Entry: DS --> System Data Area
;              ES --> Interrupt Vector Table
;
;       Exit:  C set if error occurred
;		BP is passed thru error exit from ChkDsk.
;                 (Required only for motherboard option.)
;

        ASSUME DS:SysBioData,ES:IntVec

SysInitCcr       proc    near

        mov     dl,00H                  ;Check if Target 0 is installed
        call    ChkDsk
        jc      CcrInitDone             ;If not, initialization is done
	mov	dl,0
	mov	di,OFFSET prog4		;display progress message
	call	DspMsg_short

        inc     HrdCnt                  ;Increment the system hard disk count

        cli                             ;Disable interrupts

        mov     ax,es:Int13H            ;Move old Int13H service
        mov     es:Int46H,ax            ;to Int 46H
        mov     ax,es:Int13H+2
        mov     es:Int46H+2,ax

        mov     es:Int13H,OFFSET CcrInt ;Set Int 13H to concurrent
        mov     es:Int13H+2,CS          ;SCSI Int 13H request handler

        sti                             ;Re-enable interrupts
        clc                             ;No error

CcrInitDone:

        ret

SysInitCcr       endp


SUBTTL CodeSegment: Non-concurrent Request Dispatcher
PAGE

; *** NcrInt - Non-concurrent Int 13H Request Dispatcher
;
;       Entry:  AH - Int 13H command code
;               DL - Drive number
;               All other register values depend on command code
;
;       Exit:   AH - Status of the operation
;               C set if Status is non-zero
;               All other register values depend on command code
;
;       This code determines if the request is designated for one of the
;       SCSI drives supported under the BIOS.  If not, control is passed
;       to the original Int13H handler.  If so, control is passed to a
;       Non-concurrent request handler for the specified command.  Before a
;       SCSI request handler is called, the command code and drive number
;       are value checked and the target Id is setup.
;

        ASSUME DS:Nothing,ES:Nothing

NcrInt  proc    far

        sti                             ;Enable interrupts
        test    dl,80H                  ;Is this a Floppy command ?
        jnz     NcrIsScsi
        int     40H                     ;If so, execute floppy command
        ret     2                       ;Return, discarding saved flags

NcrIsScsi:
	cmp	ah,ALTRESET
	je	small_stack_alloc
	cmp	ah,RESET
	jne	HDalloc_SCB
small_stack_alloc:
	push	bp		
	sub	sp,2			;only allocate 1 word of stack for
	mov	bp,sp			;reset function because an scb
	jmp	short NcrIsScsi_cont	;is not needed and we may own
					;int 40 as well which would also
					;have allocated an scb (if dl = 80
					;or above) causing 2 scbs to be
					;allocated - too much stack usage!
HDalloc_SCB:
	
	push	bp			;allocate scb structure on stack
	sub	sp,SIZE scb_struct
	mov	bp,sp
NcrIsScsi_cont:	
        push    bx                      ;Save registers
        push    cx
        push    dx
        push    si
        push    di
        push    ds
        push    es

        mov     si,SysBioData           ;Set DS to BIOS Data Area
        mov     ds,si
        ASSUME  DS:SysBioData

        cmp     ah,NcrCmdMax            ;Check command is within range
        jbe     NcrCmdOk
        jmp     BadCmd                  ;If out of range, reject command

NcrCmdOk:
	cmp	ah,ALTRESET
	je	NcrDriveOK
	cmp	ah,RESET
	jne	check_the_range
	jmp	NcrDriveOK
check_the_range:	
        cmp     dl,80H                  ;Check drive id is in range
        je      NcrDriveOk
	cmp	dl,81H			;2nd drive may be o.k. - check
        jne	out_of_range		;low ram to make sure
	cmp	byte ptr HrdCnt,2
	je	NcrDriveOk
	cmp	ah,IDENTIFY_SCSIDEVS	;ah = 06H?
	je	NcrDriveOk
	jmp	out_of_range
        cmp     ah,0                    ;Check for Disk Reset command
        je      NcrDriveOk              ;If so, ignore bad drive number

        cmp     ah,0DH                  ;Check for Alternate Disk Reset
        je      NcrDriveOk
out_of_range:
        jmp     BadCmd                  ;If out of range, reject command

NcrDriveOk:

	mov	Disk_or_Flopt,Disk_req	;Disk I/O request
	cmp	ah,IDENTIFY_SCSIDEVS	;ah = 06H?
	jne	parse_function
	jmp	IdScsi
parse_function:
        and     dl,1                    ;Convert drive number to SCSI Target #
after_parse:
        push    ax                      ;Get Offset into jump Table
        mov     al,ah
        xor     ah,ah
        sal     ax,1
        mov     si,ax
        pop     ax
        add     si,OFFSET CS:NcrTbl     ;Add to jump Table base
        jmp     CS:[si]

NcrTbl  LABEL   Near
        DW      OFFSET  DskRst          ;00H - Disk Reset
        DW      OFFSET  GetStat         ;01H - Get Last Status
        DW      OFFSET  ReadWrt         ;02H - Read sector
        DW      OFFSET  ReadWrt         ;03H - Write sector
        DW      OFFSET  Verify          ;04H - Verify sector
        DW      OFFSET  BadCmd          ;05H - Invalid
        DW      OFFSET  IdScsi          ;06H - Adaptec Special
        DW      OFFSET  BadCmd          ;07H - Invalid
        DW      OFFSET  GetDpm          ;08H - Get drive parameters
        DW      OFFSET  InitDp          ;09H - Initialize drive parameters
        DW      OFFSET  BadCmd          ;0AH - Invalid
        DW      OFFSET  BadCmd          ;0BH - Invalid
        DW      OFFSET  DskSeek         ;0CH - Seek
        DW      OFFSET  AltRst          ;0DH - Reset hard disk only
        DW      OFFSET  BadCmd          ;0EH - Read buffer
        DW      OFFSET  BadCmd          ;0FH - Write buffer
        DW      OFFSET  NormCmd         ;10H - Test unit ready
        DW      OFFSET  NormCmd         ;11H - Recalibrate
        DW      OFFSET  BadCmd          ;12H - Invalid
        DW      OFFSET  BadCmd          ;13H - Invalid
        DW      OFFSET  NormCmd         ;14H - Controller diagnostic
        DW      OFFSET  GetType         ;15H - Get disk type

NcrCmdMax  EQU     15H                  ;Maximum command value

NcrInt  endp


SUBTTL CodeSegment: Concurrent Request Dispatcher
PAGE


; *** CcrInt - Concurrent Int 13H Request Dispatcher
;
;       Entry:  AH - Int 13H command code
;               DL - Drive number
;               All other register values depend on command code
;
;       Exit:   AH - Status of the operation
;               C set if Status is non-zero
;               All other register values depend on command code
;
;       This code determines if the request is designated for the
;       SCSI drive supported under the BIOS.  If not, control is passed
;       to the original Int13H handler.  If so, control is passed to a
;       Concurrent request handler for the specified command.  Before a
;       SCSI request handler is called, the command code and drive number
;       are value checked and the target Id is setup.
;

        ASSUME DS:Nothing,ES:Nothing

CcrInt  proc    far


        sti                             ;Enable interrupts
	cmp     ah,RESET                ;Check for Reset command
        jne     try_altreset               ;or alternate disk reset
	jmp	short its_a_reset
try_altreset:
        cmp     ah,ALTRESET             ;If either of the reset commands
        jne     not_a_reset		;handle here
its_a_reset:
	push	bp		
	sub	sp,2			;only allocate 1 word of stack for
	mov	bp,sp			;reset function because an scb
	jmp	CcrIsScsi_cont 		;is not needed and we may own
					;int 40 as well which would also
					;have allocated an scb (if dl = 80
					;or above) causing 2 scbs to be
					;allocated - too much stack usage!
not_a_reset:
        cmp     dl,81H                  ;Is this request for Drive 81H?
        je      CcrIsScsi
	cmp	dl,80h			;Is this request for Drive 80h?
	je	CcrDrv80		;  jump if yes

CcrIn0:
	int     46H                     ;If not, execute original Int 13H
        ret     2                       ;Return, discarding saved flags


CcrDrv80:				;Int 13h call for Drive 80h
	cmp	ah,GETPARA		;command = Get Drive Parameters?
	jne	CcrIn0			;  jump if no
			;yes - Let host BIOS execute the command.  Then,
			;intercept the return, and redefine reg dl.
	int	46h
	push	si
	push	ds
	mov	si,SysBioData		;ds -> BIOS Data Area
	mov	ds,si
	ASSUME	ds:SysBioData
	mov	dl,HrdCnt		;pass out drive count
	pop	ds
	pop	si
	ret	2			;return, discarding saved flags


CcrisScsi:

	push	bp			;allocate scb structure on stack
	sub	sp,SIZE scb_struct
	mov	bp,sp
CcrisScsi_cont:	
        push    bx                      ;Save registers
        push    cx
        push    dx
        push    si
        push    di
        push    ds
        push    es

        mov     si,SysBioData           ;Set DS to BIOS Data Area
        mov     ds,si
        ASSUME  DS:SysBioData

        cmp     ah,CcrCmdMax            ;Check command is within range
        jbe     CcrCmdOk
        jmp     BadCmd                  ;If out of range, reject command

CcrCmdOk:

	mov	Disk_or_Flopt,Disk_req	;Disk I/O request
	cmp	ah,RESET		;do not alter dl for reset, alt reset
	je	CcrCmd0
	cmp	ah,ALTRESET
	je	CcrCmd0
	cmp	ah,IDENTIFY_SCSIDEVS	;ah = 06H?
	jne	parse_functionn
	jmp	CcrIdScsi
parse_functionn:
        mov     dl,0                    ;Convert drive number to SCSI Target #
CcrCmd0:
        push    ax                      ;Get Offset into jump Table
        mov     al,ah
        xor     ah,ah
        sal     ax,1
        mov     si,ax
        pop     ax
        add     si,OFFSET CS:CcrTbl     ;Add to jump Table base
        jmp     CS:[si]

CcrTbl  LABEL   Near
        DW      OFFSET  CcrDskRst       ;00H - Disk Reset
        DW      OFFSET  GetStat         ;01H - Get Last Status
        DW      OFFSET  ReadWrt         ;02H - Read sector
        DW      OFFSET  ReadWrt         ;03H - Write sector
        DW      OFFSET  Verify          ;04H - Verify sector
        DW      OFFSET  BadCmd          ;05H - Invalid
        DW      OFFSET  CcrIdScsi       ;06H - Adaptec Special
        DW      OFFSET  BadCmd          ;07H - Invalid
        DW      OFFSET  GetDpm          ;08H - Get drive parameters
        DW      OFFSET  InitDp          ;09H - Initialize drive parameters
        DW      OFFSET  BadCmd          ;0AH - Invalid
        DW      OFFSET  BadCmd          ;0BH - Invalid
        DW      OFFSET  DskSeek         ;0CH - Seek
        DW      OFFSET  CcrAltRst       ;0DH - Reset hard disk only
        DW      OFFSET  BadCmd          ;0EH - Read buffer
        DW      OFFSET  BadCmd          ;0FH - Write buffer
        DW      OFFSET  NormCmd         ;10H - Test unit ready
        DW      OFFSET  NormCmd         ;11H - Recalibrate
        DW      OFFSET  BadCmd          ;12H - Invalid
        DW      OFFSET  BadCmd          ;13H - Invalid
        DW      OFFSET  NormCmd         ;14H - Controller diagnostic
        DW      OFFSET  GetType         ;15H - Get disk type

CcrCmdMax  EQU     15H                  ;Maximum command value

CcrInt  endp


SUBTTL Disk Reset Routines
PAGE

; *** DskRst - Reset Non-concurrent Disk System
;
;       Entry:  AH - 00H
;
;       Exit:   AH - Status of Operation
;               C set if Status is Nonzero
;

DskRst:

        mov     dl,0                    ;Reset the floppy system
        int     40H
;REM 01/17/93
;  Ignore FDC error so system
;  can boot without FDC
;	IFNDEF	Intel			;Intel special:  don't check for error
;        jnc     DoDisk                  ;If failed,
;        jmp     CmdDone2                ;Return failed
;	ENDIF

DoDisk:
	call	rst_scsi		;reset bus if busy
	mov	ah,stat00
	clc
        jmp     CmdDone2



; *** CcrDskRst - Reset Concurrent Disk System
;
;	Reset all disks in system, including the floppy, up thru the drive
;	specified in dl.
;
;       Entry:  AH - 00H
;
;       Exit:   AH - Status of Operation
;               C set if Status is Nonzero
;

CcrDskRst:

        cmp     dl,81h                  ;Check Drive number for our Hard Drive
        jae     HardDskRst

					;dl = 0, 1, 80 -
	dec	HrdCnt			;temporarily decrement count
	int	46h			;  so that Int 46h does not attempt
	inc	HrdCnt			;  to reset Drive 81h.
	jmp	CmdDone2

HardDskRst:				;dl > = 81:  one of our hard drives
        mov     dl,80H                  ;Reset the rest of the system first.
        dec     HrdCnt                  ;Temporarily decrement count
        int     46H                     ; so that Int 46H does not attempt
        inc     HrdCnt                  ; to reset Drive 81H.
        jnc     DoScsi                  ;If failed,
        jmp     CmdDone2                ;Return failed

DoScsi:
	call	rst_scsi		;reset bus if busy
	mov	ah,stat00
	clc
        jmp     CmdDone2


SUBTTL Get Status of Last Operation
PAGE


; *** GetStat - Get Status of Last Operation
;
;       Entry:  AH - 01H
;
;       Exit:   AH - Status of last operation
;               C set if status is Nonzero
;

GetStat:
	
        mov     ah,OpStat               ;Move Operation Status into AH
        mov     OpStat,NoError          ;Set Operation Status to no Error
        xor     al,al                   ;clear out remaining sector count
        clc
        jmp     CmdDone_cont            ;Complete command



SUBTTL Special Adaptec Identification Routine
PAGE

; *** IdScsi - Special Adaptec Scsi Identification command - non-concurrent
;
;Old Style request:

;       Entry:  AH - 06H
;
;       Exit:   AH - 00H
;               BX - 80H     Indicating non-concurrent operation
;
;New Style request:
;
;	Entry:  AH - 06H
;		DL - Drive number (80 or 81)
;		CL - C0H (Max Cyl and Min Sector)
;		CH - FFH (Max Cyl)
;		DH - FFH (Max Head)
;		ES:BX -> Buffer allocated as follows:
;			Byte 0 - 'A'
;			Byte 1 - 'D'
;			Byte 2 - 'P'
;			Byte 3 - 'T'
;			Byte 4 - Requested Length
;			Byte 5 - Actual Length
;			Bytes 6..13 Host Adapter ID
;			Byte 14 - Target ID
;			Byte 15 - Logical Unit Number
;			Byte 16,17 - Host Adapter Identifier (Base port)
;
;	Exit:	AH - 00H
;		CY clear
;		Actual length is set to 12 (return bytes 6-17)
;		Logical Unit is set to zero.
;		Host Adapter Identifier is set to base I/O port.
;
;		If register pass-ins are not correct or 'ADPT; string
;		is not in buffer, then command will default to old-syle
;		request.


IdScsi:

	call	Chk_Valid_06	        ;Is this a new or old style call?
	jnc	its_valid
        mov     bx,80H                  ;Indicate non-concurrent operation
        jmp     IdScDone

its_valid:
	shl	si,1
	test	si,0FFFFh
	jnz	SkipTargetID

	; set dl to target ID
	and	dl,1
SkipTargetID:
	mov	dh, 1
	call	word ptr cs:Func06_Tbl[si]
	jnc	IdScDone
	jmp	BadCmd


; *** CcrIdScsi - Special Adaptec Scsi Identification command - concurrent
;
;       Entry:  AH - 06H
;
;       Exit:   AH - 00H
;               BX - 81H     Indicating concurrent operation
;

CCrIdScsi:

	call	Chk_Valid_06
	jnc	its_validcc
        mov     bx,81H                  ;Indicate non-concurrent operation
	jmp	IdScDone

its_validcc:
	shl	si, 1
	test	si, 0FFFFh
	jnz	skipTargetID1
	; set target ID to 0
	mov	dl,0
skipTargetID1:
	mov	dh, 1
	call	word ptr cs:Func06_Tbl[si]
	jnc	IdScDone
	jmp	BadCmd

	; entry point for floppy module
	public	fill_in_the_rest
fill_in_the_rest:
	call	fill_IdScsi_struct	;fill in return structure

IdScDone:

        mov     ah,NoError

        push    bp                      ;Save base pointer
        mov     bp,sp                   ;point bp to regs saved on stack
        mov     [bp + 7 * 2],bx         ;Replace saved BX with return value
        pop     bp                      ;restore base pointer

        clc
        jmp     common_fin


SUBTTL Chk_Valid_06

;***************************************************************************
;
;	call	Chk_Valid_06
;
;	Parameters:
;		None
;	Exit:	CY clear valid request
;		SI		0	SCSI ID
;				1	SET ENTRY POINT
;				2	CLEAR ENTRY POINT
;				3	GET HA CONFIG
;			
;		CY set if not in conformance with new style of IdScsi request
;	Registers Modified
;		BX
;	abstract:
;		 check IdScsi request (AH=06h) for validity.
;
	public	Chk_Valid_06
Chk_Valid_06:
	cmp	cx,0ffc0h
	jne	notnew
	cmp	dh,0ffh
	jne	notnew
	; check for SCSI ID
	cmp	word ptr es:[bx],'DA'
	jne	cv6_0000
	cmp	word ptr es:[bx+2],'TP'
	jne	notnew
	sub	si, si
	ret
cv6_0000:
	; check for rerouter functions
	cmp	word ptr es:[bx],'00'
	jne	notnew
	cmp	byte ptr es:[bx+2],'0'
	jne	notnew
	cmp	byte ptr es:[bx+2],'0'
	jb	notnew
	cmp	byte ptr es:[bx+3],'2'
	ja	notnew
	mov	al, byte ptr es:[bx+3]
	sub	al, '0'
	inc	al
	sub	ah, ah
	mov	si, ax
	ret
notnew:
	stc
	ret

;***************************************************************************
;
;	call	Fill_IdScsi_Struct
;
;	Entry:  ES:BX -> buffer allocated for Identify SCSI devices request
;		DL - target ID
;		DH - 	0		non-concurrent or floppy
;			1		concurrent and not floppy
;
;	Exit:	AH - 00H
;		CY clear
;		Actual length is set to 12 (return bytes 6-17)
;		Logical Unit is set to zero.
;		Host Adapter Identifier is set to base I/O port.
;
;		CY set
;		Invalid parameters.  Request rejected.
;
;	Abstract:
;		fills in return structure for Identify SCSI devices

Fill_IdScsi_Struct	proc	near

	test	dh, 1
	jz	FIS_0000

	and	dl,01h			;convert to Target Id
	cmp	dl,0
	je	fis_0000
	cmp	byte ptr HrdCnt,2	;is ID 1 valid?
	je	fis_0000
	stc
	jmp	short fis_ret		;no - its not!

FIS_0000:
	mov	byte ptr es:[bx]+14,dl		;insert Target ID
	mov	byte ptr es:[bx]+5,12		;# bytes returned = 12
	mov	byte ptr es:[bx]+15,0		;no support for LUNS curently
	mov	word ptr es:[bx]+16,BasePort	;insert base I/O port
	mov	byte ptr es:[bx]+6,'A'
	mov	byte ptr es:[bx]+7,'H'
	mov	byte ptr es:[bx]+8,'A'
	mov	byte ptr es:[bx]+9,'-'
	mov	word ptr es:[bx]+10,'51'
	mov	word ptr es:[bx]+12,'02'
	clc
FIS_ret:
	ret

Fill_IdScsi_Struct	endp

SUBTTL Set Rerouter Entry Point Routine
PAGE

;***************************************************************************
;
;	call	Set_Rrtr_Entry
;
;	Entry:
;		AH	06h
;		CL	C0h
;		CH	FFh
;		DL	Drive Number
;		DH	FFh
;
;	ES:BX -> buffer allocated with following fields:
;
;		Bytes 0..3	'0000'
;		Byte4		Requested length
;		Byte5*		Actual Length
;		Byte6		Host Adapter ID
;		Bytes 7..8	Reserved
;		Bytes 9..10	Offset of rerouter entry point
;		Bytes 11..12	Code segment of rerouter entry point
;
;		Note: * set by BIOS
;
;	Exit:	AH - 00H
;		CY clear
;		Actual length is set to 0
;
;		CY set
;		Invalid parameters.  Request rejected.
;
;	Registers Modified:
;		AX, DX, DI
;	Abstract:
;		sets rerouter entry point.
;

Set_Rrtr_Entry	proc	near

	cli

	call	AllowRerouter
	jnc	SRE_0000

	ret

SRE_0000:
	; Turn ON Bit 0 of xcfg1 stack byte
	mov	dx,dmacntrl1
	mov	al,xcfg1 or enstk32
	out	dx,al
	mov	dl,LOW sparstack
	in	al,dx
	or	al,REROUTER_ON
	mov	ah,al
	mov	dl,LOW dmacntrl1
	mov	al,xcfg1 or enstk32
	out	dx,al
	mov	dl,LOW sparstack
	mov	al,ah
	out	dx,al

	; set rerouter pointer in stack bytes bios_rr_off and bios_rr_seg.

						; store offset in stack
	mov	dl,LOW dmacntrl1
	mov	al,bios_rr_off or enstk32
	out	dx,al
	mov	ax,word ptr es:[bx+9]		; rerouter offset from buffer
	mov	dl,LOW sparstack
	out	dx,al
	xchg	ah,al
	out	dx,al
						; store segment in stack
	mov	ax,word ptr es:[bx+11]		; rerouter segment from buffer
	out	dx,al
	xchg	ah,al
	out	dx,al

	clc
	ret
Set_Rrtr_Entry	endp

SUBTTL Clear Rerouter Entry Point Routine
PAGE

;***************************************************************************
;
;	call	Clear_Rrtr_Entry
;
;	Entry:
;		AH	06h
;		CL	C0h
;		CH	FFh
;		DL	Drive Number
;		DH	FFh
;
;	ES:BX -> buffer allocated with following fields:
;
;		Bytes 0..3	'0001'
;		Byte4		Requested length
;		Byte5*		Actual Length
;		Byte6		Host Adapter ID
;
;		Note: * set by BIOS
;
;	Exit:	AH - 00H
;		CY clear
;		Actual length is set to 0
;
;		CY set
;		Invalid parameters.  Request rejected.
;
;	Abstract:
;		Clears rerouter entry point.
;

Clr_Rrtr_Entry	proc	near

	cli
	call	AllowRerouter
	jnc	CRE_0000
	ret

CRE_0000:
	; Turn OFF Bit 0 of xcfg1
	mov	dl,LOW dmacntrl1
	mov	al,xcfg1 or enstk32
	out	dx,al
	mov	dl,LOW sparstack
	in	al,dx
	and	al,NOT REROUTER_ON
	mov	ah,al
	mov	dx,dmacntrl1
	mov	al,xcfg1 or enstk32
	out	dx,al
	mov	dl,LOW sparstack
	xchg	al,ah
	out	dx,al
	clc
	ret

Clr_Rrtr_Entry	endp

;***************************************************************************
;
;	call	Get_HA_Config
;
;	Entry:
;		AH	06h
;		CL	C0h
;		CH	FFh
;		DL	Drive Number
;		DH	FFh
;
;	ES:BX -> buffer allocated with following fields:
;
;		Bytes 0..3	'0002'
;		Byte4		Requested length
;		Byte5*		Actual Length
;		Byte6		Host Adapter ID
;
;		Byte7*		Signature byte 0.  If 55h, Bytes 8..18 valid.
;		Byte8*		Port A Config.
;		Byte9*		Port B Config.
;		Bytes 10..17*	SCSI ID 0..7 Sync Neg. Flags
;		Byte 18*	Disk Geometry.
;				Bits 7-1	Reserved
;				Bit 0		0	32 Sectors per track
;							64 Heads
;						1	63 Sectors per track
;							255 Heads
;
;		Byte 19*	Signature byte 1.  Iff 55h, Byte 20 is valid.
;		Byte 20*	Floppy info byte.
;				Bits 7-6	No. of SCSI floppies attached
;				Bits 5-3	SCSI ID of 2nd floppy
;				Bits 2-0	SCSI ID of 1st floppy
;
;		Byte 21*	Signature byte 2. If 55h, Bytes 22..27 valid.
;		Bytes 22..23	Reserved
;		Bytes 24..25	Offset of rerouter
;		Bytes 26..27	Code segment of rerouter
;
;		Bytes 28..29	6360 ROM BIOS Base Address
;		Bytes 30..31	6360 ROM BIOS Length in 512-byte units
;
;		Note: * set by BIOS
;
;	Exit:	AH - 00H
;		CY clear
;		Actual length is set to 0
;
;		CY set
;		Invalid parameters.  Request rejected.
;
;	Registers Modified:
;		AX, CX, DX, DI
;	Abstract:
;		Clears rerouter entry point.
;

Get_HA_Config	proc	near

	cli
	call	AllowRerouter
	jnc	GHC_OK
	ret

GHC_OK:

	; set ROM BIOS location.  This is always true.
	mov	byte ptr es:[bx+5],31		; actual length 31
	mov	word ptr es:[bx+28],cs		; BIOS code segment
	mov	al,BIOSLEN			; BIOS length lo byte
	mov	byte ptr es:[bx+30],al
	mov	byte ptr es:[bx+31],0		; BIOS length hi byte

	; set signature bytes to invalid
	mov	byte ptr es:[bx+7],0		; Signature Byte0
	mov	byte ptr es:[bx+19],0		; Signature Byte1
	mov	byte ptr es:[bx+21],0		; Signature Byte2

	; check if valid sparrow configurations
	mov	dx,dmacntrl1
	xor	al,al
	out	dx,al
	mov	dx,sparstack
	in	al,dx

	cmp	al, SIGNATURE_6360
	jz	GHC_0001                ;=> AIC-6360 BIOS signature

	cmp	al, key0code6360
	jne	GHC_ret                 ;=> AIC-6360 BIOS signature

GHC_0001:
	; set signature bytes to invalid
	mov	byte ptr es:[bx+7], 055h	; Signature Byte0
	; stack now points to byte 1
	in	al,dx				; port A
	mov	es:[bx+8],al
	in	al,dx				; port B
	; save port B in ah
	mov	ah,al
	mov	es:[bx+9],al

	; pull out sync tx options
	mov	cx, 8
	push	bx
	; point es:di to es:bx
	; set bl to ID 0, bh to host adapter ID
	mov	di, bx
	xor	bx, bx
	mov	bh, es:[di+8]
	and	bh, 07h
GHC_0000:
	; skip host ID
	xor	al, al
	cmp	bl, bh
	je	GHC_0100

	;derive pointer to data transfer option
	mov	al,bh		;host adapter scsi id to al
	mov	dl,bl		;target scsi id to dl
	sub	al,dl
	and	al,07h		;al = ha id - target id
	add	al,synspd-1	;al = byte number in stack of transfer option
	mov	dl,LOW dmacntrl1;byte for current target
	out	dx,al
	mov	dl,LOW sparstack
	in	al,dx

GHC_0100:
	mov	es:[di+10], al
	inc	bl
	inc	di
	loop	GHC_0000
	pop	bx

	; set disk geometry bit.  New translation is enabled if 6360
	; compatibility mode is ON.
	shr	ah,1
	and	ah, XLATE_1GB
	mov	es:[bx+18],ah

	; pass back rerouter address if installed
	call	getxcfg1byte
	test	al,REROUTER_ON
	jz	GHC_0200
	mov	byte ptr es:[bx+21], 055h	; Signature Byte2
	mov	word ptr es:[bx+22], 0

	; read off rerouter from stack
	mov	dl,LOW dmacntrl1
	mov	al,bios_rr_off or enstk32
	out	dx,al
	mov	al,sparstack
	out	dx,al
	in	al,dx
	xchg	al,ah
	in	al,dx
	mov	word ptr es:[bx+24], ax
	in	al,dx
	xchg	al,ah
	in	al,dx
	mov	word ptr es:[bx+26], ax

GHC_0200:
	; point stack to 0Ah element
	mov	dl, LOW dmacntrl1
	mov	al, flpt0inf1
	out	dx, al
	mov	dl, LOW sparstack
	in	al, dx
	mov	ah, al
	in	al, dx

	test	ax, 0707h
	jz	GHC_ret
	mov	byte ptr es:[bx+19], 055h	; Signature Byte1
	ror	ax, 8
	mov	cx, ax
	and	cx, 0707h
	shl	ch, 3
	or	cl, ch

	and	ax, 0707h
	xor	dx, dx
	sub	dl, ah
	adc	dh, 0
	xor	dl, dl
	sub	dl, al
	adc	dh, 0
	shl	dh, 6
	or	cl, dh
	mov	es:[bx+20], cl
GHC_ret:
	clc
	ret

Get_HA_Config	endp

;***************************************************************************
;
;	call	chk_rr
;
;	Entry:
;		None
;	Exit:
;		Carry Flag Clear
;			Rerouter in place
;		Carry Flag Set
;			No rerouter
;	Abstract:
;		Checks for presence of rerouter
;
	public	chk_rr
chk_rr proc near
	mov	dx, dmacntrl1
	xor	al, al
	out	dx, al
	mov	dl, LOW sparstack
	in	al, dx
	mov	ah, al
	cmp	ah, SIGNATURE_6360
	je	cr_0000                 ;=> AIC-6360 BIOS signature
	cmp	ah, Key0code6360
	je	cr_0000                 ;=> AIC-6360 BIOS signature
	stc
	ret
cr_0000:
	call	getxcfg1byte
	and	al,REROUTER_ON
	sub	al,0
cr_ret:
	ret
chk_rr endp

SUBTTL Get Drive Parameters Routine
PAGE

; *** GetDpm - Get Drive Parameters routine
;
;       Entry:  AH - 08H
;               DL - Target Id #
;
;       Exit:   AH - Status of operation
;               C set if status is Nonzero
;
;

GetDpm:
	push	ax
	call	send_read_cap
	mov	dl,ah
	pop	ax
        jnc     GetDpmOk                ;Check for error

	mov	ah,dl
        xor     cx,cx                   ;If error, occurred zero out CX and DX
        xor     dh,dh
        mov     dl,HrdCnt               ;Report number of drives in DL
        stc                             ;return an error

        jmp     GDPDone                 ;Special return so CX,DX are intact

GetDpmOk:
	push	ax
 	mov	bx,bp
	add	bx,paralist   		;overlay part of scb structure

	mov	dl,Target		;set up for call to GetXlatMode
	call	GetXlatMode
	jc	oldxlat_Dpm

newxlat_Dpm:
	mov	ax,es:[bx+2]
	mov	dx,es:[bx+0]
	; compute # of cylinders in dx:ax
	; number cyls. = dx:ax / bx
	xchg	ah,al
	xchg	dh,dl
	mov	bx,NEW_HEADCNT * NEW_SEC_PER_TRK
	div	bx

	; ax = no. of cyls., dx = remainder
        mov     dh,NEW_HEADCNT-1        ;store max head number
        mov     dl,HrdCnt               ;Store drive count

	mov	cx,ax
	mov	ah,NEW_SEC_PER_TRK
	cmp	cx,1024
	jbe	CylOk
	mov	cx,1024
	jmp	short CylOk

oldxlat_Dpm:
	mov	ch,es:[bx+1]
	mov	cl,es:[bx+2]
	shr	cx,3

        mov     dh,HEADCNT-1            ;store max head number
        mov     dl,HrdCnt               ;Store drive count

	mov	ah,SECS_PER_TRK

        cmp     cx,1024                 ;limit cylinder to 1024
        jbe     CylOk
        mov     cx,1024

CylOk:

        dec     cx                      ;normalize cylinder to zero

        xchg    cl,ch                   ;put in format in definition
        shl     cl,6
        or      cl,ah                   ;put max sector number in cl

	pop	ax
	cmp	ah,015h			;is this for Get Type ?
					;  - code is shared with GetType
	je	GetTypeSecCnt

        clc
        mov     ah,NoError

GDPDone:

        push    bp                      ;Save base pointer
        mov     bp,sp                   ;point bp to saved regs
        mov     [bp + 6 * 2],cx         ;Replace saved CX with return value
        mov     [bp + 5 * 2],dx         ;Replace saved DX with return value
        pop     bp                      ;restore base pointer

        jmp     CmdDone

; *** send_read_cap - sends a read capacity command
;
;       Entry:  AH - 08H
;               DL - Target Id #
;
;

	PUBLIC send_read_cap
send_read_cap:

	mov	Target,dl		;Set up for a Read Capacity command
	mov	CmdByte,cmd25	
	mov	ax,ss		
	mov	es,ax
 	mov	bx,bp
	add	bx,paralist   		;overlay part of scb structure
	mov	Xfer_Offset,bx
	mov	ax,8			;transfer 8 bytes
	call	set010
	mov	WORD PTR [bp].ddcb+7,0	
	call	Do_diskIO		;Execute the command
 	ret



; *** InitDp - Initialize Drive Pair Routine
;
;       Entry:  AH - 09H
;
;       Exit:   AH - 00H
;               C reset
;
;       Does nothing as CCS/SCSI drives are self configuring.
;

InitDp:

        mov     ah,NoError
        clc
        jmp     CmdDone


SUBTTL  Disk Seek Routine
PAGE

; *** DskSeek - Perform a Seek Operation
;
;       Entry:  AH - 0CH
;               CL - bits 7,6 high bits of 10 bit cylinder number
;                  - bits 5-0 sector number (1 based)
;               CH - low byte of 10 bit cylinder number
;               DH - Head Number
;               DL - Target Id #
;
;       Exit:   AH - Status of last operation
;               C set if status is Nonzero
;
;	Performs no actual seeks.  Relies on SCSI drive to perform
;	implicit seeks.
;
DskSeek:

        mov     ah,NoError
        clc
        jmp     CmdDone


SUBTTL Alternate Disk Reset Routines
PAGE

; *** AltRst - Reset Non-concurrent Fixed Disk System
;
;       Entry:  AH - 0DH
;
;       Exit:   AH - Status of Operation
;               C set if Status is Nonzero
;

AltRst:
	call	rst_scsi		;reset SCSI bus if busy
	mov	ah,stat00
	clc
        jmp     CmdDone2


; *** CcrAltRst - Reset Concurrent Fixed Disk System
;
;	Reset only the hard disks, up thru the number specified in dl.
;
;       Entry:  AH - 0DH
;
;       Exit:   AH - Status of Operation
;               C set if Status is Nonzero
;

CcrAltRst:

	cmp	dl,80h
	ja	HardDskAlt		;jump if dl > = 81h
	je	CcrAltR0		;jump if dl = 80h
        mov     ah,InvCmd
	stc
 	jmp	CmdDone2		;if dl < 80h, error.

CcrAltR0:				;dl = 80h:  reset drive 80h only
	dec	HrdCnt
	int	46h
	inc	HrdCnt
	jmp	CmdDone2

HardDskAlt:				;dl > = 80h:  reset drive 80h & 81h

        mov     dl,80h			;Reset system hard disk 80h
        dec     HrdCnt                  ;Temporarily decrement hard drive
        int     46H                     ;  count so Int 46H does not try
        inc     HrdCnt                  ;  to reset Drive 81H.
        jnc     AltScsi                 ;If failed,
        jmp     CmdDone2                 ;Return failed

AltScsi:
	call	rst_scsi		;reset SCSI bus if busy
	mov	ah,stat00
	clc
        jmp     CmdDone2


; *** NormCmd - Test Drive Ready, Recalibrate and
;              controller Diagnostic Routine
;
;       Entry:  AH - 10H,11H,14h
;		dl = scsi target number
;
;       Exit:   AH - Status of Operation
;               C set if Status is Nonzero
;

NormCmd:
	mov	Target,dl		
	mov	CmdByte,cmd00		;test unit ready request?
	cmp	ah,10h
	je	normcmd_cont
	mov	CmdByte,cmd01		;recalibrate request?
	cmp	ah,11h
	je	normcmd_cont
	mov	ah,stat00		;must be Diagnostic request -
	clc				;just return no error
	jmp	CmdDone

normcmd_cont:

	mov	Xfer_Offset,0		
	xor	ax,ax			;no bytes to transfer
	call	set000			
	call	Do_diskIO		;Execute the command
	jmp	CmdDone	


SUBTTL Get Drive Type Routine
PAGE

; *** GetType - Get Drive Type routine
;
;       Entry:  AH - 15H
;               DL - Target Id #
;
;       Exit:   AH - 03H if drive present
;                  - 00H if drive not present
;               CX - Number of sectors MSB
;               DX - Number of sectors LSB
;               C reset
;
;

GetType:

	push	ax
	call	send_read_cap
	pop	ax
        jnc     GetTypeOk               ;Check for error
        xor     cx,cx                   ;If error, occurred zero out CX and DX
        xor     dx,dx
        mov     ah,00H                  ;Clear out ah
        stc                             ;Return with error
        jmp     GTDone

GetTypeOK:

	jmp	GetDpmOk

GetTypeSecCnt:
	;dh = number of heads, cx = cylinder and sector count

	mov	bl,dh
	xor	bh,bh
					;Build sector count in CX:DX
	mov	ax,cx
	and	ax,3Fh			;ax = number of sectors
	xchg	cl,ch
	shr	ch,6			;cx = number cylinders
	mul	cx			;dx:ax =
	mul	bx
	mov	cx,ax
	xchg	dx,cx
        mov     ah,3                    ;Flag DASD drive
        clc

GTDone:

        push    bp                      ;Save base pointer
        mov     bp,sp                   ;point bp to regs saved on stack
        mov     [bp + 6 * 2],cx         ;Replace saved CX with return value
        mov     [bp + 5 * 2],dx         ;Repalce saved DX with return value
        pop     bp                      ;restore base pointer

        jmp     CmdDone                 ;Special return so CX,DX are intact


; *** BadCmd - Reject Int 13H request
;

        public  BadCmd
BadCmd proc     near

        mov     ah,InvCmd
        stc
        jmp     CmdDone

BadCmd endp


; *** CmdDone - Restore registers and return
;

        public  CmdDone, CmdDone_cont
CmdDone proc    near

        mov     OpStat,ah

CmdDone_cont:
        pop     es
        pop     ds
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
	jc	error_exit
	add	sp,SIZE scb_struct
ret_to_caller:
	pop	bp

	public ret_to_caller2
ret_to_caller2:

        mov     al,0                	;Zero out AL for unknown reason

        retf    2
error_exit:
	add	sp,SIZE scb_struct
	stc			    	;the add instruction above clears
	jmp	short ret_to_caller 	;the carry so set it manually

CmdDone endp


; *** CmdDone2 - Restore registers and return
;

        public  CmdDone2,CmdDone2_cont
CmdDone2 proc    near

        mov     OpStat,ah

CmdDone2_cont:
        pop     es
        pop     ds
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx

	jc	error_exit2
	add	sp,2			;only 1 word was allocated for BIOS
					;use for reset routines (disk/floptical)
ret2_to_caller:
	pop	bp
        mov     al,0                    ;Zero out AL for unknown reason
        retf    2

error_exit2:

	add	sp,2		    	;only 1 word was allocated for BIOS use	
	stc			    	;the add instruction above clears
	jmp	short ret2_to_caller 	;the carry so set it manually

CmdDone2 endp


SUBTTL Disk/Floptical Read/Write I/O Routine
PAGE

; *** ReadWrt - Perform Floptical/Disk Read or Write I/O Operation
;
;       Entry:  AH - 02H (Read) or 03H (Write)
;               AL - Sector count
;               ES:BX - Address of Buffer
;               CL - bits 7,6 high bits of 10 bit cylinder number
;                  - bits 5-0 sector number (1 based)
;               CH - low byte of 10 bit cylinder number
;               DH - Head Number
;               DL - Target Id #
;               DS points to system BIOS Data Area
;
;       Exit:   AH - Status of operation
;               C set if status is Nonzero
;

	PUBLIC ReadWrt
ReadWrt:


	mov	Target,dl		
	mov	CmdByte,cmd28		;extended read
	cmp	ah,02h
	je	ReadWrt_cont
	mov	CmdByte,cmd2A		;extended write
ReadWrt_cont:
	mov	Xfer_Offset,bx		;offset of data xfer (es = segment)
	call	BIOS_to_LBA		;convert hd/sec/cyl to SCSI LBA
	call	set_scb_10		;LBA returned in dh-cx
	call	Do_diskIO		;Execute the command
common_fin:
	pushf
	cmp	byte ptr Disk_or_Flopt,Disk_req ;Disk or Floptical Request?
	je	fin_DskRdWrt

fin_FloptRdWrt:
	popf				;preserve CY flag from diskIO
	jmp	FlopCmdDone

fin_DskRdWrt:
	popf				;preserve CY flag from diskIO
	jmp	CmdDone



SUBTTL Verify - Disk/Floptical Verify I/O Routine
PAGE

; *** Verify - Perform a Disk/Floptical Verify Operation
;
;       Entry:  AH - 04H
;               AL - Sector count
;               CL - bits 7,6 high bits of 10 bit cylinder number
;                  - bits 5-0 sector number (1 based)
;               CH - low byte of 10 bit cylinder number
;               DH - Head Number
;               DL - Target Id #
;
;       Exit:   AH - Status of operation
;               C set if status is Nonzero
;


	PUBLIC Verify
Verify:

	push	ax
	push	bx
	push	cx
	push	dx
	mov	Target,dl		
	mov	CmdByte,cmd2f		;verify command
	mov	Xfer_Offset,bx		;offset of data xfer (es = segment)
	call	BIOS_to_LBA		;convert hd/sec/cyl to SCSI LBA
	call	set_scb_10		;LBA returned in dh-cx
	call	Do_diskIO		;Execute the command
	pop	dx			;retriev original dx,cx,bx
	pop	cx
	pop	bx
	jnc	verify_successful
	
        cmp     ah,InvCmd               ;Check for invalid command
        je      TryRead                 ;If this error occurred, try a Read
	add	sp,2			;discard old ax
	stc                             ;If other error, return error
	jmp	short common_fin

TryRead:

	pop	ax			;recover original ax
	mov	Target,dl		
	mov	CmdByte,cmdff		;try a read with no xfer to host
	mov	Xfer_Offset,bx		;offset of data xfer (es = segment)
	call	BIOS_to_LBA		;convert hd/sec/cyl to SCSI LBA
	call	set_scb_10		;LBA returned in dh-cx
	call	Do_diskIO		;Execute the command
	jnc	TryRead_Done
	cmp	ah,BEROVR 		;Expect Data Overrun error
	je	ignore_DO
	stc
	jmp	short TryRead_Done

ignore_DO:
	xor	ah,ah	
	clc
TryRead_Done:
	jmp	short common_fin
Verify_successful:
	add	sp,2			 ;discard old ax
	clc
	jmp	short common_fin


	ASSUME es:nothing


SUBTTL BIOS_to_LBA	
PAGE

; *** BIOS_to_LBA - Convert BIOS head/sec/cyl address to SCSI LBA
;
;       Entry:  AH - 02H (Read) or 03H (Write)
;               AL - Sector count
;               ES:BX - Address of Buffer
;               CL - for disk: bits 7,6 high bits of 10 bit cylinder number
;                  -           bits 5-0 sector number (1 based)
;		   - for floptical: sector number
;               CH - for disk:low byte of 10 bit cylinder number
;		   - for floptical: track number
;               DH - Head Number
;               DL - Target Id #
;               DS   points to system BIOS Data Area
;
;       Exit:   dx-cx = SCSI LBA
;

	PUBLIC	BIOS_to_LBA


	PUBLIC BIOS_to_LBA
BIOS_to_LBA	proc	near

	
	cmp	Disk_or_Flopt,Disk_req	;disk or floptical request?
	jne	floptical_conversion	;use appropriate xlat algorithm

disk_conversion:
	
	push	ax
	push	bx
	push	es

	push	cx
	push	dx

	push	cx
	call	GetXlatMode
	pop	cx
	jc	old_xlat

new_xlat:

	shr	cl,6	
	xchg	ch,cl			;cyl # in now in cx
	mov	ax,(NEW_SEC_PER_TRK * NEW_HEADCNT) ;ax = secs per cyl
	mul	cx			;result in dx-ax
	mov	cx,ax			;move it to bx-cx
	mov	bx,dx			;Cyl# * (hds per cyl * spt) in bx-cx
	pop	dx			;restore original dx (dh = head #)
	xchg	dh,dl
	xor	dh,dh			;head # in dl
	mov	ax,NEW_SEC_PER_TRK
	jmp	short common_xlat	;jump to common portion of disk/flopt
					;translation algorithm
old_xlat:	

	shr	cl,6	
	xchg	ch,cl			;cyl # in now in cx
	mov	ax,(SECS_PER_TRK * HEADCNT) ;ax = secs per cyl
	mul	cx			;result in dx-ax
	mov	cx,ax			;move it to bx-cx
	mov	bx,dx			;Cyl# * (hds per cyl * spt) in bx-cx
	pop	dx			;restore original dx (dh = head #)
	xchg	dh,dl
	xor	dh,dh			;head # in dl
	mov	ax,SECS_PER_TRK

common_xlat:

	mul	dl			;result in ax
	add	cx,ax			;add it in
	adc	bx,0
	pop	ax			;retrieve original cx (cl has sector # in low 6 bits)
	and	al,3fh  		;get sector bits
	xor	ah,ah
	dec	al			;make sector # zero-based
	add	cx,ax
	adc	bx,0			;add in sector requested
	mov	dx,bx

	pop	es			;restore regs
	pop	bx
	pop	ax			;LBA in dx-cx	
	ret


floptical_conversion:

	push	ax
	push	bx
	push	es

	push	cx
	push	dx
	xor	cl,cl			;for floppy, ch = track number
	xchg	ch,cl			;now cx = track(cyl)
	push	cx
	call	GetSecsPerTrk		;SPT returned in al,
					;  number of heads in cl

get_secs_per_cyl:

	mul	cl			;secs per cyl in ax
	pop	cx			;restore cylinder #
	mul	cx			;result in dx-ax
	mov	cx,ax			;move it to di-cx
	mov	bx,dx			;Cyl# * (hds per cyl * spt) in bx-cx
	pop	dx			;restore original dx (dh = head #)
	xchg	dh,dl
	xor	dh,dh			;head # in dl
	push	cx
	call	GetSecsPerTrk  	       	;SPT returned in al
	pop	cx
	jmp	short common_xlat	;jump to common portion of disk/flopt
					;translation algorithm

ASSUME	es:nothing

BIOS_to_LBA	endp

	ASSUME es:nothing

SUBTTL   Console Display Routines
PAGE

; *** DspStr - Display String on Screen
;
;       Entry: CS:di - Pointer to Null (\0) terminated character string
;
;       Exit: none
;
;	pass thru:  al

public  DspStr
DspStr  proc    near

	push	bp
	push	ax
	mov	bp,di
        mov     ah,0eh                  ;Index write teletype to active page
        mov     si,0                    ;Offset into character string

DspStrLoop:
        mov     al,cs:[bp][si]          ;Get character
        cmp     al,0                    ;EOLN?
        je      DspStrQuit              ;Yes, exit

        push    ax                      ;Save
        int     10h                     ;Display the character
        pop     ax                      ;Restore

        inc     si                      ;Bump offset pointer
        jmp     DspStrLoop

DspStrQuit:
	pop	ax
	pop	bp
        ret

DspStr  endp


; *** DspErr - Display Error Message on Screen
;
;       Entry: CS:di - Pointer to Null (\0) terminated error message
;
;       Exit: none
;
;	pass thru:  al

        PUBLIC  DspErr
DspErr	proc    near

        push    di
        mov     di,OFFSET LINEFD        ;Output a Linefeed First
        call    DspStr
        pop     di
        call    DspStr                  ;Now the indicated message
        ret

DspErr	endp


;  Display Message Class #3  subroutine
;
;	Display boot progress message to screen.
;
;	pass in:  di = pointer to message to be displayed
;
;	pass thru:  everything except flags

	PUBLIC	DspMsg3
DspMsg3	PROC	NEAR

	push	ax
	call	Get_Jumpers		;jumpered for messages?
	and	al,msgdsply0
	jz	Dsp3M1
	cmp	al,msgdsply0
	jne	Dsp3M0
Dsp3M1:	pop	ax			;return if no
	ret

Dsp3M0:	push	si
	call	DspStr
	pop	si
	pop	ax

	push	bx			;hold displayed line
	push	cx
	mov	bx,SHORTTMO
	shr	bx,2			;adjust timeout
	call	SetTmo
Dsp3M2:	call	CheckTmo
	jnc	Dsp3M2
	pop	cx
	pop	bx

	ret

;  Display Message Class #3  subroutine
;
;	Display boot progress message to screen.
;	Used instead of DspMsg3 where the timer is not defined.
;
;	pass in:  di = pointer to message to be displayed
;
;	pass thru:  everything except flags

DspMsg3a:

	push	ax
	call	Get_Jumpers		;jumpered for messages?
	and	al,msgdsply0
	jz	Dsp3aM1
	cmp	al,msgdsply0
	jne	Dsp3aM0
Dsp3aM1:
	pop	ax			;return if no
	ret

Dsp3aM0:
	push	si
	call	DspStr
	pop	si
	pop	ax

	push	bx			;hold displayed line
	push	cx			;for ~2 sec on 8 MHz cpu.
	mov	bx,0000h
	mov	cx,004h
Dsp3aM2:
	dec	bx
	jnz	Dsp3aM2
	dec	cx
	jnz	Dsp3aM2
	pop	cx
	pop	bx

	ret

DspMsg3	ENDP


SUBTTL System Boot Routines/Data
PAGE


; *** BootFloppy - Boot from floppy disk drive
;
;       Entry: DS --> Interrupt Vector Table
;              ES --> not defined
;
;   Note: If successful, this routine will jump to the boot record, never to
;         return.  If unsuccessful, this routine will simply return.
;
        ASSUME  ds:nothing,es:nothing

BootFloppy	proc	near
	
	mov	dx,0			;Reference first floppy drive
	mov	cx,3			;Set a retry count

FBoot1:					;Loop
	push	cx	
	call	LoadFloppyBoot		;Attempt to load the boot record
	pop	cx
	jc	FBoot2			;jump if error
	jmp	BootRec			;If successful, jump to boot code
		
FBoot2:
	cmp	ah,BERHNG		;If failed with controller hang
	jne	FBoot3
	ret				;Return (failed)

FBoot3:
        loop	FBoot1          	;Until retries exhausted
        ret	                	;Return (failed)

BootFloppy	endp


; *** BootFixed - Boot from fixed disk drive
;
;       Entry: DS --> Interrupt Vector Table
;              ES --> not defined
;
;   Note: If successful, this routine will jump to the boot record, never to
;         return.  If unsuccessful, this routine will simply return.

        ASSUME  ds:IntVec,es:nothing

BootFixed	proc	near

        mov     dl,80h			;Reference hard disk 0
        mov	cx,3			;Set a retry count

HBoot1:		                	;Loop
        push	cx		
	call	LoadHardBoot		;Attempt to load the boot record
	pop	cx
	jc	HBoot3
	cmp	word ptr BootRec+510,0AA55H ;Check for AA55 in last 2 bytes
	jne	HBoot2
	jmp	BootRec			;If there, jump to the boot code

HBoot2:
	ret

HBoot3:
	loop	HBoot1			;Until retries exhausted
        ret	 			;Return (failed)

BootFixed	endp


; *** BootReq - Service a boot request Interrupt (Int 19H)
;
;   Service a boot request interrupt.
;
;	ENTRY:	Interrupts might be disabled
;

	ASSUME	ds:Nothing,es:Nothing
	public	BootReq
BootReq	proc	far

BootLoop:
	mov	ax,IntVec		;Set Interrupt 1EH to address of
	mov	ds,ax			;high-density floppy parameter table
	ASSUME	ds:IntVec
	mov	Int1Eh,OFFSET HDMediaTbl
	mov	Int1Eh+2,cs
	sti				;Re-enable interrupts

	call	BootFloppy		;Attempt to Boot from the floppy
	call	BootFixed		;Attempt to Boot from the Fixed Disk

	int	18h			;If failed, execute ROM BASIC
	jmp	BootLoop		;If Int 18h returns, try again

BootReq	endp


; *** LoadFloppyBoot - Load Boot record from floppy drive
;
;	ENTRY:	
;		DL - Id of drive to load boot sector from
;
;	EXIT:
;
;		C set if unable to load boot sector
;

	ASSUME  ds:IntVec,es:Nothing

LoadFloppyBoot	proc	near

	mov	ah,0			;Reset the floppy controller
	int	13h		
	jnc	LoadFB1
	ret				;If failed, return failed

LoadFB1:
	mov	ax,ds			;Read boot record
	mov	es,ax
        ASSUME  es:IntVec
	mov	bx,OFFSET BootRec
	mov	dh,0
	mov	cx,0001H
	mov	al,1
	mov	ah,02h			;Issue a READ through Int 13h
	int	13h
	ret

LoadFloppyBoot	endp


; *** LoadHardBoot - Load Boot record from Hard drive
;
;	ENTRY:	
;		DL - Id of drive to load boot sector from
;
;	EXIT:
;
;		C set if unable to load boot sector
;

	ASSUME  ds:IntVec,es:Nothing

LoadHardBoot	proc	near

	mov	ax,ds			;Read boot record
	mov	es,ax
        ASSUME  es:IntVec
	mov	bx,OFFSET BootRec
	mov	dh,0
	mov	cx,0001H
	mov	al,1
	mov	ah,02h			;Issue a READ through Int 13h
	int	13h
	ret

LoadHardBoot	endp

SUBTTL Sense Data to Disk/Floptical BIOS Status Translation Table
PAGE

; *** Sense Code to Disk/Floptical BIOS status translation table

        public  ECDTBL
ECDTBL     LABEL     BYTE

        DB     BERNUL          ;00H - No additional sense information
        DB     BERCNT          ;01H - No index/sector signal
        DB     BERSEK          ;02H - No seek complete
        DB     BERCNT          ;03H - Write fault
        DB     BER_FLOP_NOTRDY          ;04H - Drive not ready
        DB     BERCNT          ;05H - Drive not selected
        DB     BERSEK          ;06H - No track zero found
        DB     BERCNT          ;07H - Multiple drives selected
        DB     BERCNT          ;08H - Logical unit communication failure
        DB     BERCNT          ;09H - Track following error
        DB     BERCNT          ;0AH - Reserved
        DB     BERCNT          ;0BH - Reserved
        DB     BERCNT          ;0CH - Reserved
        DB     BERCNT          ;0DH - Reserved
        DB     BERCNT          ;0EH - Reserved
        DB     BERCNT          ;0FH - Reserved
        DB     BERECC          ;10H - ID CRC or ECC error
        DB     BERECC          ;11H - Unrecovered Read error of data blocks
        DB     BERAMK          ;12H - No address mark found in ID field
        DB     BERAMK          ;13H - No address mark found in data field
        DB     BERREC          ;14H - No record found
        DB     BERSEK          ;15H - Seek positioning error
        DB     BERREC          ;16H - Data synchroniztion mark error
        DB     BERCOR          ;17H - Recovered read data with retries
        DB     BERCOR          ;18H - Recovered read data with correction
        DB     BERCNT          ;19H - Defect list error
        DB     BERCMD          ;1AH - Parameter overrun
        DB     BERCNT          ;1BH - Synchronous transfer error
        DB     BERCNT          ;1CH - Primary defect list not found
        DB     BERCNT          ;1DH - Compare error
        DB     BERCOR          ;1EH - Recovered ID with ECC correction
        DB     BERCNT          ;1FH - Reserved
        DB     BERCMD          ;20H - Invalid command operation code
        DB     BERAMK          ;21H - Illegal logical block address
        DB     BERCMD          ;22H - Illegal function for device type
        DB     BERCNT          ;23H - Reserved
        DB     BERCMD          ;24H - Illegal field in CDB
        DB     BERCMD          ;25H - Invalid LUN
        DB     BERCMD          ;26H - Invalid field in parameter list
        DB     BERWPT          ;27H - Write protected
        DB     BER_MEDIA_CHANGE ;28H - Medium changed
        DB     BER_FLOP_NOTRDY          ;29H - Power on reset or bus device reset
        DB     BER_MEDIA_CHANGE ;2AH - Mode select parameters changed
        DB     BERCNT          ;2BH - Reserved
        DB     BERCNT          ;2CH - Reserved
        DB     BERCNT          ;2DH - Reserved
        DB     BERCNT          ;2EH - Reserved
        DB     BERCNT          ;2FH - Reserved
        DB     BERREC          ;30H - Incompatible cartridge
        DB     BERREC          ;31H - Medium format corrupted
        DB     BERREC          ;32H - No defect spare location available
        DB     BERCNT          ;33H - Reserved
        DB     BERCNT          ;34H - Reserved
        DB     BERCNT          ;35H - Reserved
        DB     BERCNT          ;36H - Reserved
        DB     BERCNT          ;37H - Reserved
        DB     BERCNT          ;38H - Reserved
        DB     BERCNT          ;39H - Reserved
        DB     BER_FLOP_NOTRDY	       ;3AH - Medium Not Present
        DB     BERCNT          ;3BH - Reserved
        DB     BERCNT          ;3CH - Reserved
        DB     BERCNT          ;3DH - Reserved
        DB     BER_FLOP_NOTRDY          ;3EH - Logical Unit has not self-configured yet
        DB     BERCNT          ;3FH - Reserved
        DB     BERCNT          ;40H - RAM failure
        DB     BERCNT          ;41H - Data path diagnostic failure
        DB     BERCNT          ;42H - Power on diagnostic failure
        DB     BERCNT          ;43H - Message reject error
        DB     BERCNT          ;44H - Internal controller error
        DB     BER_FLOP_NOTRDY          ;45H - Select/reselect failed
        DB     BERDNR          ;46H - Unsuccessful soft reset
        DB     BERCNT          ;47H - SCSI interface parity error
        DB     BERCNT          ;48H - Initiator detected error
        DB     BERCNT          ;49H - Inappropriate/illegal message
        DB     BERCNT          ;> 49H - Reserved

        public  CSNMAX
CSNMAX  EQU     49H

;
; Function Table for Function 6 ADAPTEC specials
;
	public	Func06_Tbl
Func06_Tbl	label byte
	DW	OFFSET	Fill_IdScsi_Struct	; fill ID structure
	DW	OFFSET	Set_Rrtr_Entry		; set entry
	DW	OFFSET	Clr_Rrtr_Entry		; clear entry
	DW	OFFSET	Get_HA_Config		; get HA config


        ASSUME  DS:SysBioData

foreverloop:
	jmp	SHORT $

CODE ENDS

end

