;
;	Tables of Escape sequences for each type of CRT terminal.
;
;	Each table starts on a 128 byte sector boundary
;
;	Each table consists of 16 control sequences consisting of up to
;	7 bytes and cursor addressing info (ADDOFF) consisting of three bytes
;	Each control sequence begins with a count byte, which is the
;	count of the characters to be sent to the CRT, followed by those
;	characters, followed by the delay in milliseconds needed by the CRT.
;
;	ADDOFF specifies whether the cursor address is sent in binary or
;	ASCII, whether the row or column coordinate is sent first, and the
;	offset to add to the row and column coordinates.
;
;	BYTE 1 : Bit 0 : 0 = ROW first then COLUMN
;	                 1 = COLUMN first then ROW
;	         Bit 7 : 0 = Address in binary
;	                 1 = Address in ASCII
;
;	BYTE 2 : First coordinates offset.
;	BYTE 3 : Second coordinates offset.
;
;

ESC	EQU	1BH			; escape character

	ORG	100H			; Start first one at 100H
;
;	(1)	ACT IV
;
	DB	1,14H,0,0,0,0,0		;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,0,0			;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	1,1FH,4,0,0,0,0		;EOS
	DB	1,1EH,0,0,0,0,0		;EOL
	DB	1,1,0,0,0,0,0		;INSERT LINE
	DB	1,17H,0,0,0,0,0		;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	1,1,0,0,0,0,0		;REVERSE SCROLL
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(2)	ADDS REG 20
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,6BH,4,0,0,0	;EOS
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(3)	ADDS REG 30 - 60
;
	ORG	($ AND 0FF80H) + 80H
	DB	4,1BH,2CH,'Y',2CH,0,0	;CURSOR LEADIN
	DB	1,2CH,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1,0CH,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	3,1BH,2CH,'k',4,0,0	;EOS
	DB	3,1BH,2CH,'K',2,0,0	;EOL
	DB	3,1BH,2CH,'M',2,0,0	;INSERT LINE
	DB	3,1BH,2CH,'l',2,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	3,1BH,2CH,'b',0,0,0	;ENABLE STATUS LINE
	DB	3,1BH,2CH,'B',0,0,0	;DISABLE STATUS LINE
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(4)	ADM-3A
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1,1AH,2,0,0,0,0		;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS
	DB	0,0,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(5)	ANSI STANDARD - VT100, Ann Arbor AMBASSADOR, etc.
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,5BH,0,0,0,0	;CURSOR LEADIN
	DB	1,3BH,0,0,0,0,0		;CHARS between X and Y.
	DB	1,48H,0,0,0,0,0		;CURSOR LEAD OUT
	DB	80H,1H,1H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	4,1BH,5BH,30H,4AH,0AH,0	;EOS
	DB	4,1BH,5BH,30H,4BH,0,0	;EOL
	DB	4,1BH,5BH,31H,4CH,0,0	;INSERT LINE
	DB	4,1BH,5BH,31H,4DH,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	4,1BH,5BH,31H,4CH,0,0	;REVERSE SCROLL
	DB	4,1BH,5BH,37H,6DH,0,0	;BEGIN REVERSE VIDEO
	DB	4,1BH,5BH,30H,6DH,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(6)	BEEHIVE - But not all of them.
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,46H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,4AH,4,0,0,0	;EOS
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	2,1BH,4CH,03,0,0,0	;INSERT LINE
	DB	2,1BH,4DH,66H,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,4CH,03,0,0,0	;REVERSE SCROLL
	DB	03,1BH,64H,50H,0,0,0	;BEGIN REVERSE VIDEO
	DB	03,1BH,64H,40H,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(7)	DATAMEDIA
;
	ORG	($ AND 0FF80H) + 80H
	DB	1,1EH,0,0,0,0,0		;CURSOR LEADIN.
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	1,0,0			;ADDOFF
	DB	1,0CH,4,0,0,0,0		;CLEAR SCREEN - not used.
	DB	1,0BH,4,0,0,0,0		;EOS
	DB	1,1DH,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(8)	DEC VT-52
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN.
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,4AH,08,0,0,0	;EOS
	DB	2,1BH,4BH,03,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,49H,0,0,0,0	;REVERSE SCROLL
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(9)	DYNABYTE 57
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,43H,0,0,0,0	;CURSOR LEADIN.
	DB	1,2CH,0,0,0,0,0		;CHARS between X and Y.
	DB	1,0DH,0,0,0,0,0		;CURSOR LEAD OUT
	DB	80H,0,0			;ADDOFF
	DB	1,0CH,08,0,0,0,0	;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS - N/A
	DB	0,0,0,0,0,0,0		;EOL - N/A
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(10)	HAZELTINE
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,7EH,11H,0,0,0,0	;CURSOR LEADIN.
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	1,0,0			;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,7EH,18H,4,0,0,0	;EOS
	DB	2,7EH,0FH,0,0,0,0	;EOL
	DB	2,7EH,1AH,2,0,0,0	;INSERT LINE
	DB	2,7EH,13H,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,7EH,1AH,0,0,0,0	;REVERSE SCROLL
	DB	2,7EH,1FH,0,0,0,0	;BEGIN DOUBLE INTENSITY
	DB	2,7EH,19H,0,0,0,0	;END DOUBLE INTENSITY
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(11)	HEATH/ZENITH H19/Z19
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,4AH,4,0,0,0	;EOS
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	2,1BH,4CH,0,0,0,0	;INSERT LINE
	DB	2,1BH,4DH,0,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,4CH,0,0,0,0	;REVERSE SCROLL
	DB	2,1BH,70H,0,0,0,0	;BEGIN REVERSE VIDEO
	DB	2,1BH,71H,0,0,0,0	;END REVERSE VIDEO
	DB	5,1BH,78H,31H,1BH,77H,0	;ENABLE STATUS LINE
	DB	5,1BH,79H,31H,1BH,76H,0	;DISABLE STATUS LINE
	DB	03,1BH,78H,36H,0,0,0	;ENTER VISUAL MODE
	DB	03,1BH,79H,36H,0,0,0	;EXIT VISUAL MODE
;
;
;	(12)	HP 2621
;
	ORG	($ AND 0FF80H) + 80H
	DB	03,1BH,26H,61H,0,0,0	;CURSOR LEADIN.
	DB	1,72H,0,0,0,0,0		;CHARS between X and Y.
	DB	1,43H,0,0,0,0,0		;CURSOR LEAD OUT
	DB	80H,0,0			;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,4AH,4,0,0,0	;EOS
	DB	2,1BH,4BH,2,0,0,0	;EOL
	DB	2,1BH,4CH,2,0,0,0	;INSERT LINE
	DB	2,1BH,4DH,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,4CH,2,0,0,0	;REVERSE SCROLL
	DB	4,1BH,26H,64H,42H,0,0	;BEGIN REVERSE VIDEO
	DB	4,1BH,26H,64H,40H,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(13)	IBM 3101
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN FOR
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,4AH,4,0,0,0	;EOS
	DB	2,1BH,49H,0,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO
	DB	0,0,0,1,0,0,0		;ENABLE STATUS LINE
	DB	0,0,0,1,0,0,0		;DISABLE STATUS LINE
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(14)	INFO 100
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,66H,0,0,0,0	;CURSOR LEADIN.
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	1,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,4AH,2,0,0,0	;EOS
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LIN - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LIN - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(15)	INTERTUBE II - No EOS
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN.
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1,0CH,2,0,0,0,0		;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS - N/A
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(16)	INTERTUBE II with EOS.
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN.
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,6BH,2,0,0,0	;EOS
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(17)	ISC 8063
;
	ORG	($ AND 0FF80H) + 80H
	DB	1,03H,0,0,0,0,0		;CURSOR LEADIN.
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	1,0,0			;ADDOFF
	DB	1,0CH,2,0,0,0,0		;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS
	DB	0,0,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(18)	PERKIN ELMER 550
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,58H,0,0,0,0	;CURSOR LEADIN.
	DB	2,1BH,59H,0,0,0,0	;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	2,1BH,4BH,30,0,0,0	;CLEAR SCREEN & Delay
	DB	0,0,0,0,0,0,0		;EOS - N/A
	DB	2,1BH,49H,20,0,0,0	;EOL & Delay
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(19)	SD SYSTEMS VDB 8024
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN.
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1,1AH,2,0,0,0,0		;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS
	DB	0,0,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	2,1,0AH,0,0,0,0		;FORWARD SCROLL
	DB	2,2,0AH,0,0,0,0		;REVERSE SCROLL
	DB	1,12H,0,0,0,0,0		;BEGIN REVERSE VIDEO
	DB	1,11H,0,0,0,0,0		;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	1,1,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(20)	SOROC 120
;
	ORG	($ AND 0FF80H) + 80H
	DB	4,0,0,1BH,3DH,0,0	;CURSOR LEADIN.
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1,0CH,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,59H,0AH,0,0,0	;EOS
	DB	2,1BH,54H,03,0,0,0	;EOL
	DB	0,1BH,45H,2,0,0,0	;INSERT LINE - 140 only
	DB	0,1BH,52H,2,0,0,0	;DELETE LINE - 140 only
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,1BH,45H,2,0,0,0	;REVERSE SCROLL - 140 only
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(21)	SUPERBRAIN - No EOS
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN.
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1,0CH,0,0,0,0,0		;CLEAR SCREEN
	DB	00,1BH,7EH,6BH,0,0,0	;EOS (Until Intertek fixes their BUG.)
	DB	03,1BH,7EH,4BH,0,0,0	;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(22)	SWTP CT82
;
	ORG	($ AND 0FF80H) + 80H
	DB	1,0BH,0,0,0,0,0		;CURSOR LEADIN.
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	1,0,0			;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	1,16H,2,0,0,0,0		;EOS
	DB	1,06H,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(23)	TELERAY
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,59H,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,4AH,4,0,0,0	;EOS
	DB	2,1BH,4BH,0,0,0,0	;EOL
	DB	2,1BH,4CH,2,0,0,0	;INSERT LINE
	DB	2,1BH,4DH,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,4CH,2,0,0,0	;REVERSE SCROLL
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(24)	TELEVIDEO 920, 912
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,59H,2,0,0,0	;EOS
	DB	2,1BH,54H,0,0,0,0	;EOL
	DB	2,1BH,45H,2,0,0,0	;INSERT LINE
	DB	2,1BH,52H,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,45H,2,0,0,0	;REVERSE SCROLL
	DB	2,1BH,6AH,0,0,0,0	;BEGIN REVERSE VIDEO
	DB	2,1BH,6BH,0,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(25)	TELEVIDEO 950, 910
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN FOR
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	0,0,0,0,0,0,0		;CLEAR SCREEN - not used.
	DB	2,1BH,59H,2,0,0,0	;EOS
	DB	2,1BH,54H,0,0,0,0	;EOL
	DB	2,1BH,45H,2,0,0,0	;INSERT LINE
	DB	2,1BH,52H,2,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,1BH,45H,2,0,0,0	;REVERSE SCROLL
	DB	3,1BH,47H,34H,0,0,0	;BEGIN REVERSE VIDEO
	DB	3,1BH,47H,30H,0,0,0	;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(26)	XEROX 820
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1,1AH,2,0,0,0,0		;CLEAR SCREEN
	DB	1,11H,0,0,0,0,0		;EOS
	DB	1,18H,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE - N/A
	DB	0,0,0,0,0,0,0		;DELETE LINE - N/A
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL - N/A
	DB	0,0,0,0,0,0,0		;BEGIN REVERSE VIDEO - N/A
	DB	0,01H,0,0,0,0,0		;END REVERSE VIDEO - N/A
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(27)	TEC 511  <CRL>
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,1BH,3DH,0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,20H,20H		;ADDOFF
	DB	1,18H,175,0,0,0,0	;CLEAR SCREEN
	DB	0,0,0,0,0,0,0		;EOS
	DB	0,0,0,0,0,0,0		;EOL
	DB	0,0,0,0,0,0,0		;INSERT LINE
	DB	0,0,0,0,0,0,0		;DELETE LINE
	DB	1,0AH,42,0,0,0,0	;FORWARD SCROLL
	DB	0,0,0,0,0,0,0		;REVERSE SCROLL
	DB	0,0,0,0,0,0,0		;BEGIN HIGHLIGHT
	DB	0,0,0,0,0,0,0		;END HIGLIGHT
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE
;
;
;	(28)	Chad's Emulog special
;
	ORG	($ AND 0FF80H) + 80H
	DB	2,ESC,'=',0,0,0,0	;CURSOR LEADIN
	DB	0,0,0,0,0,0,0		;CHARS between X and Y.
	DB	0,0,0,0,0,0,0		;CURSOR LEAD OUT
	DB	0,' ',' '		;ADDOFF
	DB	1,19H,0,0,0,0,0		;CLEAR SCREEN
	DB	1,17H,0,0,0,0,0		;EOS
	DB	1,18H,0,0,0,0,0		;EOL
	DB	2,ESC,'E',0,0,0,0	;INSERT LINE
	DB	2,ESC,'R',0,0,0,0	;DELETE LINE
	DB	1,0AH,0,0,0,0,0		;FORWARD SCROLL
	DB	2,ESC,'E',0,0,0,0	;REVERSE SCROLL
	DB	1,10H,0,0,0,0,0		;BEGIN REVERSE VIDEO
	DB	1,11H,0,0,0,0,0		;END REVERSE VIDEO
	DB	0,0,0,0,0,0,0		;ENABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;DISABLE STATUS LINE - N/A
	DB	0,0,0,0,0,0,0		;ENTER VISUAL MODE
	DB	0,0,0,0,0,0,0		;EXIT VISUAL MODE

	END
