	TITLE	'Z-80 Disassembler for 8080A'
	ORG	0100H
BDOS	EQU	05H
CTLTBL	EQU	1C00H
FCB	EQU	5CH
STACK	EQU	1BFDH
SYMTBL	EQU	2200H
TBUF	EQU	80H
;
START:	CALL	ENTRY
	DB	'RESOURCE by Ward Christensen'
	DB	0DH,0AH,'(AS OF 07/31/80)'
	DB	0DH,0AH,'Z-80 Version 2'
	DB	0DH,0AH,'$Copyright 1980'
ENTRY:	POP	D
	MVI	C,9
	CALL	BDOS
	LXI	H,0
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
	CALL	PRTSTR
	DB	0DH,0AH,'Memory open to '
	DB	0
	LHLD	6
	DCX	H
	CALL	PRWORD
	CALL	CRLF
	CALL	CRLF
L0174:	CALL	INITBL
NXCMD:	XRA	A
	STA	WFIFLG
	STA	QUIFLG
	LXI	SP,STACK
	CALL	GTCMD
L0184:	LXI	H,CMDBUF+2
	MOV	A,M
	CPI	0DH
	JZ	NXCMD
	CPI	';'
	JZ	CMCMNT
	CPI	'A'
	JZ	CMATMT
	CPI	'B'
	JZ	CMBLD
	CPI	'C'
	JZ	CMCTL
	CPI	'D'
	JZ	CMDUMP
	CPI	'E'
	JZ	CMENTR
	CPI	'F'
	JZ	CMFIND
	CPI	'K'
	JZ	CMKILL
	CPI	'L'
	JZ	CMLIST
	CPI	'O'
	JZ	CMOFST
	CPI	'P'
	JZ	CMPRLG
	CPI	'Q'
	JZ	CMQIET
	CPI	'R'
	JZ	CMREAD
	CPI	'S'
	JZ	CMSAVE
	CPI	'T'
	JZ	CMTRIM
	CPI	'U'
	JZ	CMUSEC
	CPI	'X'
	JZ	CMPURG
	CPI	'Z'
	JZ	CMEOF
	CPI	'?'
	JZ	CMSTTS
CMERR:	XRA	A
	STA	WFIFLG
	STA	QUIFLG
	CALL	PRTSTR
	DB	'?',0DH,0AH,0
	JMP	NXCMD
;
CMTRIM:	LDA	TRMFLG
	CMA
	STA	TRMFLG
	ORA	A
	JZ	TRMOF
	CALL	PRTSTR
	DB	'Trim On',0DH,0AH,0
	JMP	NXCMD
;
TRMOF:	CALL	PRTSTR
	DB	'Trim Off',0DH,0AH,0
	JMP	NXCMD
;
CMPURG:	CALL	PRTSTR
	DB	'Y/N purge all symbols & '
	DB	'CTL?',0
	CALL	GTCMD
	LDA	CMDBUF+2
	CPI	'Y'
	JZ	L0174
	CPI	'N'
	JZ	NXCMD
	JMP	CMPURG
;
CMPRLG:	LXI	H,CMDBUF+3
	MOV	A,M
	CPI	0DH
	JZ	CMERR
	CALL	GTVAL
	CPI	' '
	JZ	L0241
	CPI	','
	JNZ	CMERR
L0241:	INX	H
	PUSH	D
	PUSH	H
	MVI	A,1
	STA	WFIFLG
	CALL	L1A7E
	DB	9,'.LOC',9,0
	POP	H
	POP	D
	MOV	A,D
	CALL	XO0
	MOV	A,E
	CALL	XO
	MVI	A,'H'
	CALL	TYPE
	CALL	CRLF
	PUSH	D
	CALL	GTVAL
	CPI	0DH
	JNZ	CMERR
	POP	B
	LXI	H,SYMTBL
L0272:	INX	H
	INX	H
	MOV	A,M
	ORA	A
	JZ	NXCMD
	DCX	H
	DCX	H
	MOV	A,M
	SUB	C
	INX	H
	MOV	A,M
	SBB	B
	JC	L028C
	DCX	H
	MOV	A,M
	SUB	E
	INX	H
	MOV	A,M
	SBB	D
	JC	L02D9
L028C:	PUSH	H
	PUSH	B
	INX	H
	MOV	B,M
	PUSH	H
	INX	H
	MOV	A,M
	DCX	H
	CPI	'A'
	JC	L02E5
L0299:	INX	H
	MOV	A,M
	CPI	'+'
	JZ	L02E5
	CPI	'-'
	JZ	L02E5
	DCR	B
	JNZ	L0299
	POP	H
	MOV	B,M
	MVI	A,1
	STA	WFIFLG
L02B0:	INX	H
	MOV	A,M
	CALL	TYPE
	DCR	B
	JNZ	L02B0
	CALL	L1A7E
	DB	9,'=',9,0
	POP	B
	POP	H
	MOV	A,M
	ORA	A
	CNZ	XO0
	DCX	H
	MOV	A,M
	CALL	XO
	MVI	A,'H'
	CALL	TYPE
	CALL	CRLF
	XRA	A
	STA	WFIFLG
	INX	H
L02D9:	INX	H
	MOV	A,M
	CALL	ADDF
	INX	H
	CALL	L1ABF
	JMP	L0272
;
L02E5:	POP	H
	POP	B
	POP	H
	JMP	L02D9
;
CMQIET:	MVI	A,1
	STA	QUIFLG
	LXI	D,CMDBUF+2
	LXI	H,CMDBUF+3
L02F6:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	CPI	0DH
	JNZ	L02F6
	JMP	L0184
;
	DB	'Congratulations, you found '
	DB	'the patch area!'
CMDUMP:	LHLD	L1B1B
	PUSH	H
	XCHG
	LHLD	DMPCNT
	DAD	D
	SHLD	L1B1D
	POP	D
	LXI	H,CMDBUF+3
	MOV	A,M
	CPI	0DH
	JZ	L038B
	CPI	'S'
	JZ	DUSYMT
	CPI	'='
	JZ	SDUCNT
	CPI	','
	JZ	L035D
L0351:	CALL	GTVAL
	PUSH	H
	LHLD	DMPCNT
	DAD	D
	SHLD	L1B1D
	POP	H
L035D:	CPI	0DH
	JZ	L0376
	CPI	' '
	JZ	L036C
	CPI	','
	JNZ	CMERR
L036C:	INX	H
	PUSH	D
	CALL	GTVAL
	XCHG
	SHLD	L1B1D
	POP	D
L0376:	LHLD	OFFSET
	PUSH	H
	DAD	D
	SHLD	L1B1B
	LHLD	L1B1D
	POP	D
	DAD	D
	SHLD	L1B1D
	CPI	0DH
	JNZ	CMERR
L038B:	LHLD	L1B1B
L038E:	CALL	L1ABF
	PUSH	H
	CALL	L087C
	CALL	PRWORD
	POP	H
	PUSH	H
	CALL	PRSPC
L039D:	MOV	A,M
	CALL	XO
	INX	H
	MOV	A,L
	ANI	3
	CZ	PRSPC
	MOV	A,L
	ANI	7
	CZ	PRSPC
	MOV	A,L
	ANI	0FH
	JNZ	L039D
	CALL	PSTAR
	POP	H
L03B8:	MOV	A,M
	CPI	' '
	JC	L03C3
	CPI	7FH
	JC	L03C5
L03C3:	MVI	A,'.'
L03C5:	CALL	TYPE
	INX	H
	MOV	A,L
	ANI	0FH
	JZ	L03D7
	ANI	7
	CZ	PRSPC
	JMP	L03B8
;
L03D7:	CALL	PSTAR
	CALL	CRLF
	SHLD	L1B1B
	LDA	L1B1D
	SUB	L
	LDA	L1B1D+1
	SBB	H
	JNC	L038E
	JMP	NXCMD
;
SDUCNT:	INX	H
	CALL	GTVAL
	INX	H
	DCX	D
	XCHG
	SHLD	DMPCNT
	XCHG
	CPI	','
	JZ	L0351
	CPI	' '
	JZ	L0351
	CPI	0DH
	JZ	NXCMD
	JMP	CMERR
;
DUSYMT:	LXI	H,CMDBUF+4
	MOV	A,M
	CPI	'.'
	JNZ	L0423
	CALL	L1872
	CALL	L1798
	JNC	L0426
	LHLD	L1B4B
	JMP	L0426
;
L0423:	LXI	H,SYMTBL
L0426:	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	MOV	A,M
	ORA	A
	JZ	NXCMD
	XCHG
	CALL	PRWORD
	XCHG
	MOV	B,M
	INX	H
L0436:	MOV	A,M
	CALL	TYPE
	INX	H
	DCR	B
	JNZ	L0436
	CALL	CRLF
	CALL	L1ABF
	JMP	L0426
;
L0448:	LHLD	OFFSET
	CALL	PRWORD
	CALL	CRLF
	JMP	NXCMD
;
CMOFST:	LXI	H,CMDBUF+3
	MOV	A,M
	CPI	0DH
	JZ	L0448
	CALL	GTVAL
	CPI	0DH
	JNZ	CMERR
	XCHG
	SHLD	OFFSET
	JMP	NXCMD
;
GFNAM:	LDA	WRTFLG
	ORA	A
	JNZ	RRQERR
	STA	FCB
	STA	FCB+12
	LXI	H,CMDBUF+3
	LDA	CMDBUF+4
	CPI	' '
	JZ	CMERR
	CPI	':'
	JNZ	L0493
	LDA	CMDBUF+3
	SUI	'@'
	STA	FCB
	INX	H
	INX	H
L0493:	LXI	D,FCB+1
	MVI	B,8
	CALL	L04A1
	MVI	B,3
	CALL	L04A1
	RET
;
L04A1:	MOV	A,M
	CPI	0DH
	JZ	L04BE
	INX	H
	CPI	'.'
	JZ	L04BE
	STAX	D
	INX	D
	DCR	B
	JNZ	L04A1
L04B3:	MOV	A,M
	CPI	0DH
	RZ
	CPI	'.'
	INX	H
	RZ
	JMP	L04B3
;
L04BE:	MVI	A,' '
	STAX	D
	INX	D
	DCR	B
	JNZ	L04BE
	RET
;
CMATMT:	MVI	A,1
	STA	L1B4F
	XRA	A
	STA	SYBFLG
	JMP	L04E2
;
CMBLD:	MVI	A,1
	STA	SYBFLG
	JMP	L04E2
;
CMLIST:	XRA	A
	STA	SYBFLG
	STA	L1B4F
L04E2:	XRA	A
	STA	WFIFLG
	LDA	LISCNT
	STA	LISCNT+1
	STA	L1B35
	LXI	H,CMDBUF+3
	MOV	A,M
	CPI	0DH
	JZ	L052A
	CPI	','
	JZ	L051E
	CPI	' '
	JZ	L051E
	CPI	'='
	JZ	SLICNT
L0507:	CALL	GTVAL
	XCHG
	SHLD	PCNTR
	XCHG
	CPI	0DH
	JZ	L052A
	CPI	' '
	JZ	L051E
	CPI	','
	JNZ	CMERR
L051E:	INX	H
	CALL	GTVAL
	XCHG
	SHLD	L1B25
	XRA	A
	STA	L1B35
L052A:	CALL	L1ABF
	LDA	L1B35
	ORA	A
	JZ	L053E
	LDA	LISCNT+1
	DCR	A
	JM	NXCMD
	JMP	L054C
;
L053E:	LHLD	L1B25
	LDA	PCNTR
	SUB	L
	LDA	PCNTR+1
	SBB	H
	JNC	NXCMD
L054C:	LDA	L1B4F
	ORA	A
	JZ	L0586
	LHLD	PCNTR
	XCHG
	LHLD	OFFSET
	DAD	D
	MVI	B,8
L055D:	MOV	A,M
	CALL	L1AFE
	JC	L0586
	INX	H
	DCR	B
	JNZ	L055D
L0569:	MOV	A,M
	CALL	L1AFE
	INX	H
	JNC	L0569
	DCX	H
	CALL	L087C
	XCHG
	PUSH	D
	LHLD	PCNTR
	XCHG
	MVI	A,'B'
	CALL	L0B9E
	POP	D
	MVI	A,'I'
	CALL	L0B9E
L0586:	LHLD	DOCTBL
	MOV	A,H
	ORA	L
	JZ	L05C0
	LHLD	PCNTR
	XCHG
	CALL	L0D87
	JC	L05C0
	INX	H
	INX	H
	MOV	B,M
L059B:	MVI	A,1
	STA	WFIFLG
	CALL	SEMIC
	XRA	A
	ORA	B
	JZ	L05BD
L05A8:	INX	H
	MOV	A,M
	CPI	5CH
	JNZ	L05B6
	CALL	CRLF
	DCR	B
	JMP	L059B
;
L05B6:	CALL	TYPE
	DCR	B
	JNZ	L05A8
L05BD:	CALL	CRLF
L05C0:	LHLD	PCNTR
	XCHG
	CALL	L0C51
	DCX	H
	JC	L05CE
	INX	H
	INX	H
	INX	H
L05CE:	MOV	A,M
	CPI	'I'
	JZ	L061E
	CPI	'E'
	JZ	CMEOF
	PUSH	PSW
	INX	H
	MOV	E,M
	INX	H
	MOV	D,M
	PUSH	D
	LHLD	PCNTR
	XCHG
	CALL	L0EB4
	POP	H
	SHLD	L1B48
	XCHG
	XRA	A
	STA	WFIFLG
	POP	PSW
	CPI	'S'
	JZ	L0648
	CPI	'B'
	JZ	L06A9
	CPI	'W'
	JZ	L067B
	CALL	TYPE
	CALL	PRTSTR
	DB	': INVALID CTL ENTRY'
	DB	0DH,0AH,0
	JMP	NXCMD
;
L061E:	CALL	DLINE
	XRA	A
	STA	WFIFLG
	JMP	L052A
;
SLICNT:	INX	H
	CALL	GTVAL
	MOV	A,E
	ORA	A
	JZ	CMERR
	STA	LISCNT
	MOV	A,M
	INX	H
	CPI	','
	JZ	L0507
	CPI	' '
	JZ	L0507
	CPI	0DH
	JZ	NXCMD
	JMP	CMERR
;
L0648:	PUSH	D
	LDA	PCNTR
	CMA
	MOV	L,A
	LDA	PCNTR+1
	CMA
	MOV	H,A
	INX	H
	DAD	D
	MVI	A,1
	STA	WFIFLG
	CALL	L1A7E
	DB	'.BLKB',9,0
	MOV	A,H
	CALL	XO0
	MOV	A,L
	CALL	XO
	MVI	A,'H'
	CALL	TYPE
	CALL	CRLF
	POP	H
	SHLD	PCNTR
	JMP	L052A
;
L067B:	MVI	A,1
	STA	WFIFLG
	CALL	L1A7E
	DB	'.WORD',9,0
	LHLD	PCNTR
	XCHG
	LHLD	OFFSET
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	CALL	L106E
	LHLD	PCNTR
	INX	H
	INX	H
	SHLD	PCNTR
	JMP	L052A
;
L06A3:	CALL	CRLF
	JMP	L052A
;
L06A9:	MVI	A,1
	STA	WFIFLG
L06BB:	LHLD	PCNTR
	XCHG
	LHLD	OFFSET
	DAD	D
	MOV	A,M
	CPI	' '
	JC	NPRTC	;NOT PRINTABLE
	CPI	7FH
	JC	L0722	;VISIBLE ASCII
NPRTC:	CALL	L1A7E
	DB	'.BYTE',9,0
	XRA	A
	STA	L1B4A
MORINV:	MOV	A,M	;RESTORE BYTE
	CPI	0AH
	JC	L06E6
L06D3:	CALL	XO0
	MVI	A,'H'
	CALL	TYPE
	LDA	L1B4A
	ADI	2
	STA	L1B4A
	JMP	L06EB
;
L06E6:	ORI	'0'
	CALL	TYPE
L06EB:	INX	H
	XCHG
	LHLD	PCNTR
	INX	H
	SHLD	PCNTR
	XCHG
L06F5:	LDA	L1B48
	CMP	E
	JNZ	L0703
	LDA	L1B49
	CMP	D
	JZ	L078D
L0703:	LHLD	PCNTR
	XCHG
	CALL	L17EA
	JNC	L06A3
	LDA	L1B4A
	ADI	2
	STA	L1B4A
	CPI	19H
	JNC	L06A3
	LHLD	PCNTR
	XCHG
	LHLD	OFFSET
	DAD	D
	MOV	A,M
	CPI	' '
	JC	NXINV
	CPI	7FH
	JC	L06A3
NXINV:	MVI	A,','
	CALL	TYPE
	JMP	MORINV
;
L0722:	CALL	L1A7E
	DB	'.ASCII',9,0
	XRA	A
	STA	L1B4A
	MVI	A,27H
	CALL	TYPE
	LDA	L1B4A
	INR	A
	STA	L1B4A
	MOV	A,M
L072F:	CALL	TYPE
	MOV	A,M
	CPI	27H
	CZ	TYPE
	INX	H
	XCHG
	LHLD	PCNTR
	INX	H
	SHLD	PCNTR
	XCHG
	LDA	L1B48
	CMP	E
	JNZ	L0750
	LDA	L1B49
	CMP	D
	JZ	L0788
L0750:	PUSH	H
	LHLD	PCNTR
	XCHG
	CALL	L17EA
	POP	H
	JNC	L0788
	LDA	L1B4A
	INR	A
	STA	L1B4A
	CPI	'#'
	JNC	L0780
	CPI	19H
	JC	L0775
	DCX	H
	MOV	A,M
	INX	H
	CPI	' '
	JZ	L0788
L0775:	MOV	A,M
	CPI	' '
	JC	L0780
	CPI	7FH
	JC	L072F
L0780:	MVI	A,27H
	CALL	TYPE
	JMP	L06A3
;
L0788:	MVI	A,27H
	CALL	TYPE
L078D:	CALL	CRLF
	JMP	L052A
;
CMSTTS:	CALL	PRTSTR
	DB	'SYMTBL=',0
	LXI	H,SYMTBL
	CALL	PRWORD
	LHLD	SYMTP
	CALL	PRWORD
	CALL	CRLF
	CALL	PRTSTR
	DB	'PC    =',0
	LHLD	PCNTR
	CALL	PRWORD
	CALL	CRLF
	CALL	PRTSTR
	DB	'OFFSET=',0
	LHLD	OFFSET
	CALL	PRWORD
	CALL	CRLF
	LHLD	DOCTBL
	MOV	A,H
	ORA	L
	JZ	NODOCT
	CALL	PRTSTR
	DB	'COMNTS=',0
	LHLD	DOCTBL
	CALL	PRWORD
	LHLD	DOCEND
	CALL	PRWORD
	CALL	CRLF
NODOCT:	CALL	PRTSTR
	DB	'CTLTBL=',0
	LXI	H,CTLTBL
	CALL	PRWORD
L0808:	MOV	A,M
	INX	H
	ANA	M
	INX	H
	INX	H
	INR	A
	JNZ	L0808
	DCX	H
	DCX	H
	DCX	H
	CALL	PRWORD
	CALL	CRLF
	JMP	NXCMD
;
CMFIND:	LXI	H,CMDBUF+3
	MOV	A,M
	CPI	0DH
	JZ	L0853
	CALL	GTVAL
	XCHG
	SHLD	L1B2F
	LHLD	OFFSET
	SHLD	L1B2D
	XCHG
	CPI	0DH
	JZ	L0853
	CPI	' '
	JZ	L0843
	CPI	','
	JNZ	CMERR
L0843:	INX	H
	CALL	GTVAL
	CPI	0DH
	JNZ	CMERR
	LHLD	OFFSET
	DAD	D
	SHLD	L1B2D
L0853:	LHLD	L1B2F
	XCHG
L0857:	CALL	L1ABF
	LHLD	L1B2D
	MOV	A,M
	INX	H
	SHLD	L1B2D
	CMP	E
	JNZ	L0857
	MOV	A,M
	CMP	D
	JNZ	L0857
	PUSH	H
	PUSH	D
	CALL	L087C
	DCX	H
	CALL	PRWORD
	POP	D
	POP	H
	CALL	PRSPC
	JMP	L0857
;
L087C:	LDA	OFFSET
	CMA
	MOV	E,A
	LDA	OFFSET+1
	CMA
	MOV	D,A
	INX	D
	DAD	D
	RET
;
CMEOF:	CALL	L0EB4
	MVI	A,1
	STA	WFIFLG
	CALL	L1A7E
	DB	'.END',0DH,0AH,0
	XRA	A
	STA	WFIFLG
	LDA	WRTFLG
	ORA	A
	JZ	NXCMD
	MVI	A,1AH
	CALL	L19E6
	CALL	L19A7
	XRA	A
	STA	WRTFLG
	CALL	PRTSTR
	DB	'++ASM FILE CLOSED++',0DH
	LDAX	B
	NOP
	JMP	NXCMD
;
CMREAD:	CALL	GFNAM
	LDA	WRTFLG
	ORA	A
	JNZ	RRQERR
	LXI	H,FCB+9
	LXI	D,SYMLIT
	MVI	C,3
	CALL	CMPSTR
	JNZ	L08F6
	LXI	H,SYMTBL
	CALL	L09C9
	SHLD	SYMTP
	INX	H
	INX	H
	MVI	M,0
	JMP	CMSTTS
;
L08F6:	LXI	H,FCB+9
	LXI	D,COMLIT
	MVI	C,3
	CALL	CMPSTR
	JNZ	L0947
	CALL	FOPEN
	LHLD	OFFSET
	MOV	A,H
	CPI	1EH
	JC	L097A
	LXI	D,START
	DAD	D
L0914:	PUSH	H
	XCHG
	MVI	C,1AH
	CALL	BDOS
	LXI	D,FCB
	MVI	C,14H
	CALL	BDOS
	ORA	A
	JNZ	L092F
	POP	H
	LXI	D,TBUF
	DAD	D
	JMP	L0914
;
L092F:	POP	H
	CALL	PRWORD
	CALL	L087C
	CALL	PRWORD
	CALL	CRLF
	LXI	D,TBUF
	MVI	C,1AH
	CALL	BDOS
	JMP	NXCMD
;
L0947:	LXI	H,FCB+9
	LXI	D,CTLLIT
	MVI	C,3
	CALL	CMPSTR
	JNZ	L0958
	JMP	L0CF1
;
L0958:	LXI	H,FCB+9
	LXI	D,DOCLIT
	MVI	C,3
	CALL	CMPSTR
	JNZ	CMERR
	CALL	L0DFB
	LHLD	DOCTBL
	CALL	L09C9
	SHLD	DOCEND
	MVI	M,0FFH
	INX	H
	MVI	M,0FFH
	JMP	CMSTTS
;
L097A:	CALL	PRTSTR
	DB	'++NO, THAT WOULD OVERLAY '
	DB	'THE DISASSEMBLER',0DH,0AH
	DB	'BECAUSE OFFSET IS TOO SMALL: '
	DB	0
	JMP	L0448
;
L09C9:	CALL	FOPEN
L09CC:	CALL	RDFCHR
	CPI	1AH
	RZ
	CPI	9
	JZ	L09CC
	CPI	0DH
	JZ	L09CC
	CPI	0AH
	JZ	L09CC
	CALL	L0A05
	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	PUSH	H
	INX	H
	MVI	B,0
L09EC:	CALL	RDFCHR
	CPI	9
	JZ	L09FF
	CPI	0DH
	JZ	L09FF
	MOV	M,A
	INX	H
	INR	B
	JMP	L09EC
;
L09FF:	XTHL
	MOV	M,B
	POP	H
	JMP	L09CC
;
L0A05:	LXI	D,0
L0A08:	CPI	' '
	RZ
	CPI	1AH
L0A0D:	JZ	L0B62
	CPI	':'
	JC	L0A17
	SUI	7
L0A17:	SUI	'0'
	XCHG
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	ADD	L
	MOV	L,A
	XCHG
	CALL	RDFCHR
	CPI	1AH
	JZ	L0B62
	JMP	L0A08
;
CMSAVE:	CALL	GFNAM
	LDA	WRTFLG
	ORA	A
	JNZ	RRQERR
	LXI	H,FCB+9
	LXI	D,SYMLIT
	MVI	C,3
	CALL	CMPSTR
	JNZ	L0A9A
	LXI	H,SYMTBL
L0A47:	CALL	L1986
L0A4A:	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	MOV	A,M
	INX	H
	MOV	B,A
	ORA	A
	JZ	L0A73
	CALL	L0A7E
	MVI	A,' '
	CALL	L19E6
L0A5D:	MOV	A,M
	CALL	L19E6
	INX	H
	DCR	B
	JNZ	L0A5D
	MVI	A,0DH
	CALL	L19E6
	MVI	A,0AH
	CALL	L19E6
	JMP	L0A4A
;
L0A73:	MVI	A,1AH
	CALL	L19E6
	CALL	L19A7
	JMP	NXCMD
;
L0A7E:	MOV	A,D
	CALL	HEXL
	CALL	L19E6
	MOV	A,D
	CALL	HEXR
	CALL	L19E6
	MOV	A,E
	CALL	HEXL
	CALL	L19E6
	MOV	A,E
	CALL	HEXR
	JMP	L19E6
;
L0A9A:	LXI	H,FCB+9
	LXI	D,CTLLIT
	MVI	C,3
	CALL	CMPSTR
	JZ	SAVCTL
	LXI	H,FCB+9
	LXI	D,DOCLIT
	MVI	C,3
	CALL	CMPSTR
	JZ	SAVDOC
	LXI	H,FCB+9
	LXI	D,ASMLIT
	MVI	C,3
	CALL	CMPSTR
	JNZ	CMERR
	MVI	A,1
	STA	WRTFLG
	XRA	A
	STA	WFIFLG
	CALL	L1986
	CALL	PRTSTR
	DB	'++WRITING .ASM ENABLED'
	DB	0DH,0AH,'USE Z COMMAND OR '
	DB	'E CONTROL TO CLOSE FILE++'
	DB	0DH,0AH,0
	JMP	NXCMD
;
SAVDOC:	CALL	L0DFB
	LHLD	DOCEND
	INX	H
	INX	H
	MVI	M,0
	LHLD	DOCTBL
	JMP	L0A47
;
RRQERR:	CALL	PRTSTR
	DB	'++NO FILE ACCESSES PERMITTED '
	DB	'UNTIL .ASM CLOSED',0DH,0AH
	DB	0
	JMP	NXCMD
;
L0B62:	CALL	PRTSTR
	DB	'++UNEXPECTED EOF',0DH,0AH
	DB	0
	JMP	NXCMD
;
CMCTL:	LXI	H,CMDBUF+3
	MOV	A,M
	CPI	0DH
	JZ	L0C73
	CALL	GTVAL
	CPI	0DH
	JZ	L0C6D
	CPI	' '
	JZ	L0B96
	CPI	','
	JNZ	CMERR
L0B96:	INX	H
	MOV	A,M
	CALL	L0BB0
	JMP	NXCMD
;
L0B9E:	PUSH	H
	PUSH	D
	PUSH	PSW
	CALL	L0C51
	DCX	H
	JC	L0BAB
	INX	H
	INX	H
	INX	H
L0BAB:	POP	PSW
	POP	D
	CMP	M
	POP	H
	RZ
L0BB0:	STA	INTYP
	CALL	L0C51
	JC	L0BFB
	LDA	INTYP
	CPI	'I'
	JZ	L0C4D
	CPI	'W'
	JZ	L0C4D
	CPI	'B'
	JZ	L0C4D
	CPI	'S'
	JZ	L0C4D
	CPI	'E'
	JZ	L0C4D
	CPI	'K'
	JNZ	CMERR
	XCHG
	LXI	H,3
	DAD	D
	XCHG
L0BE0:	MOV	A,M
	INX	H
	ANA	M
	DCX	H
	INR	A
	JZ	L0BF5
	MVI	B,3
L0BEA:	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCR	B
	JNZ	L0BEA
	JMP	L0BE0
;
L0BF5:	DCX	H
	DCX	H
	DCX	H
	JMP	NODOCT
;
L0BFB:	LDA	INTYP
	CPI	'K'
	JZ	CMERR
	CPI	'E'
	JZ	L0C1C
	CPI	'B'
	JZ	L0C1C
	CPI	'W'
	JZ	L0C1C
	CPI	'I'
	JZ	L0C1C
	CPI	'S'
	JNZ	CMERR
L0C1C:	PUSH	D
	PUSH	H
	LXI	H,CTLTBL
L0C21:	MOV	A,M
	INX	H
	ANA	M
	INX	H
	INX	H
	INR	A
	JNZ	L0C21
	INX	H
	INX	H
	INX	H
	XCHG
	LXI	H,-3
	DAD	D
	POP	B
L0C33:	DCX	H
	DCX	D
	MOV	A,M
	STAX	D
	MOV	A,E
	CMP	C
	JNZ	L0C33
	MOV	A,D
	CMP	B
	JNZ	L0C33
	MOV	H,B
	MOV	L,C
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	LDA	INTYP
	MOV	M,A
	RET
;
L0C4D:	INX	H
	INX	H
	MOV	M,A
	RET
;
L0C51:	LXI	H,CTLTBL
L0C54:	MOV	A,M
	INX	H
	ANA	M
	DCX	H
	INR	A
	STC
	RZ
	INX	H
	MOV	A,D
	CMP	M
	DCX	H
	RC
	JNZ	L0C67
	MOV	A,E
	CMP	M
	RZ
	RC
L0C67:	INX	H
	INX	H
	INX	H
	JMP	L0C54
;
L0C6D:	CALL	L0C51
	JMP	L0C76
;
L0C73:	LXI	H,CTLTBL
L0C76:	CALL	L1ABF
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	MOV	A,D
	ANA	E
	INR	A
	JNZ	L0C86
	JMP	NODOCT
;
L0C86:	PUSH	D
	PUSH	H
	CALL	L17EA
	JC	L0C9F
L0C8E:	MOV	A,M
	CALL	TYPE
	INX	H
	DCR	B
	JNZ	L0C8E
	MVI	A,':'
	CALL	TYPE
	CALL	CRLF
L0C9F:	POP	H
	POP	D
	CALL	PRSPC
	CALL	PRSPC
	XCHG
	CALL	PRWORD
	MVI	A,','
	CALL	TYPE
	XCHG
	MOV	A,M
	CALL	TYPE
	CALL	CRLF
	INX	H
	JMP	L0C76
;
SAVCTL:	CALL	L1986
	LXI	H,CTLTBL
L0CC2:	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	MOV	A,D
	ANA	E
	INR	A
	JZ	L0CE6
	CALL	L0A7E
	MVI	A,','
	CALL	L19E6
	MOV	A,M
	CALL	L19E6
	MVI	A,0DH
	CALL	L19E6
	MVI	A,0AH
	CALL	L19E6
	INX	H
	JMP	L0CC2
;
L0CE6:	MVI	A,1AH
	CALL	L19E6
	CALL	L19A7
	JMP	NXCMD
;
L0CF1:	CALL	FOPEN
	LXI	H,CTLTBL
L0CF7:	CALL	RDFCHR
	LXI	D,0
L0CFD:	CPI	1AH
	JZ	L0D2A
	CPI	','
	JZ	L0D1E
	CPI	':'
	JC	L0D0E
	SUI	7
L0D0E:	SUI	'0'
	XCHG
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	ADD	L
	MOV	L,A
	XCHG
	CALL	RDFCHR
	JMP	L0CFD
;
L0D1E:	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	CALL	RDFCHR
	MOV	M,A
	INX	H
	JMP	L0CF7
;
L0D2A:	MVI	M,0FFH
	INX	H
	MVI	M,0FFH
	JMP	NODOCT
;
CMCMNT:	CALL	L0DFB
	LXI	H,CMDBUF+3
	MOV	A,M
	CPI	0DH
	JZ	L0DAB
	CALL	GTVAL
	INX	H
	CPI	0DH
	JZ	L0DA5
	CPI	' '
	JZ	L0D51
	CPI	','
	JNZ	CMERR
L0D51:	PUSH	H
	CALL	L0D87
	JC	L0D63
	CALL	L0DD6
	POP	H
	PUSH	H
	MOV	A,M
	CPI	0DH
	JZ	NXCMD
L0D63:	LHLD	DOCEND
	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	POP	D
	MVI	B,0
	PUSH	H
L0D6E:	INX	H
	LDAX	D
	MOV	M,A
	INX	D
	INR	B
	LDAX	D
	CPI	0DH
	JNZ	L0D6E
	INX	H
	SHLD	DOCEND
	MVI	M,0FFH
	INX	H
	MVI	M,0FFH
	POP	H
	MOV	M,B
	JMP	NXCMD
;
L0D87:	LHLD	DOCTBL
L0D8A:	MOV	A,M
	INX	H
	ANA	M
	DCX	H
	INR	A
	STC
	RZ
	INX	H
	MOV	A,D
	CMP	M
	DCX	H
	JNZ	L0D9B
	MOV	A,E
	CMP	M
	RZ
L0D9B:	INX	H
	INX	H
	MOV	A,M
	CALL	ADDF
	INX	H
	JMP	L0D8A
;
L0DA5:	CALL	L0D87
	JMP	L0DAE
;
L0DAB:	LHLD	DOCTBL
L0DAE:	CALL	L1ABF
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	MOV	A,D
	ANA	E
	INR	A
	JZ	NXCMD
	XCHG
	CALL	PRWORD
	XCHG
	MVI	A,';'
	CALL	TYPE
	MOV	B,M
L0DC6:	INX	H
	MOV	A,M
	CALL	TYPE
	DCR	B
	JNZ	L0DC6
	CALL	CRLF
	INX	H
	JMP	L0DAE
;
L0DD6:	MOV	A,M
	INX	H
	ANA	M
	INR	A
	RZ
	DCX	H
	PUSH	D
	MOV	D,H
	MOV	E,L
	INX	H
	INX	H
	MOV	A,M
	CALL	ADDF
	INX	H
	MVI	B,0
L0DE8:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	MOV	C,A
	ANA	B
	INR	A
	MOV	B,C
	JNZ	L0DE8
	XCHG
	DCX	H
	DCX	H
	SHLD	DOCEND
	POP	D
	RET
;
L0DFB:	LHLD	DOCTBL
	MOV	A,H
	ORA	L
	RNZ
	CALL	PRTSTR
	DB	'++COMMAND IGNORED++',0DH
	DB	0AH,'++Issue ''UNNNN'' to tell '
	DB	'RESOURCE to use address '
	DB	'NNNN',0DH,0AH,'as the start '
	DB	'of the comments table',0DH
	DB	0AH,0
	JMP	NXCMD
;
CMUSEC:	LXI	H,CMDBUF+3
	MOV	A,M
	CPI	0DH
	JZ	CMERR
	CPI	'.'
	JZ	CMERR
	CALL	GTVAL
	XCHG
	MOV	A,H
	CPI	1FH
	JC	L0E9D
	SHLD	DOCTBL
	SHLD	DOCEND
	MVI	M,0FFH
	INX	H
	MVI	M,0FFH
	JMP	NXCMD
;
L0E9D:	CALL	PRTSTR
	DB	'++NO!! <2300H!',0DH,0AH
	DB	0
	JMP	NXCMD
;
L0EB4:	PUSH	D
	PUSH	H
	MVI	A,1
	STA	WFIFLG
	LHLD	PCNTR
	XCHG
	CALL	L17EA
	JC	L0EF6
	MOV	C,B
	PUSH	H
L0EC7:	MOV	A,M
	CPI	'+'
	JZ	L0EF5
	CPI	'-'
	JZ	L0EF5
	INX	H
	DCR	C
	JNZ	L0EC7
	POP	H
	CALL	PSTRG
	MVI	A,':'
	CALL	TYPE
	LDA	TRMFLG
	ORA	A
	JNZ	L0EF6
	CALL	TABC
	CALL	TABC
	CALL	SEMIC
	LHLD	PCNTR
	CALL	PRWORD
	CALL	CRLF
	JMP	L0EF6
;
L0EF5:	POP	H
L0EF6:	XRA	A
	STA	WFIFLG
	CALL	PRSPC
	CALL	PRSPC
	LHLD	PCNTR
	CALL	PRWORD
	MVI	A,1
	STA	WFIFLG
	CALL	TABC
	POP	H
	POP	D
	RET
;
DLINE:	CALL	L0EB4
	XRA	A
	STA	INDX
	LHLD	PCNTR
	XCHG
	LHLD	OFFSET
	DAD	D
	SHLD	PGPTR
	XCHG
	INX	H	;COUNT OVER SINGLE BYTE
	SHLD	PCNTR
	XCHG
	MOV	B,M
	LXI	H,OPCT-7
L0F2D:	LXI	D,7
ULP:	DAD	D
	MOV	A,M
	ORA	A
	JZ	PRDB
	ANA	B
	MOV	C,A
	INX	H
	MOV	A,M
	CMP	C
	JNZ	ULP
	INX	H
	MOV	A,M
	STA	INTYP
	MVI	B,5
PROLP:	INX	H
	MOV	A,M
	CPI	1	;INDX VALUE FLAG
	JNZ	PRO2
	LDA	INDX
	ORA	A
	JMP	PRO1
;
PRO2:	CPI	'.'
PRO1:	CNZ	TYPE
	DCR	B
	JNZ	PROLP
	LHLD	PCNTR
	LDA	INTYP
	ANI	3FH
	CPI	4
	JC	FOUND
	CPI	9
	JNC	FOUND
	INX	H	;2 BYTE AT LEAST
	CPI	6
	JC	L0F75
	INX	H	;3 BYTE INSTR
L0F75:	SHLD	PCNTR
FOUND:	MOV	E,A
	MVI	D,0
	LXI	H,JMPTBL
;
	DAD	D
	DAD	D
	DAD	D
	PUSH	H
	LHLD	PGPTR
	RET
;
INCPC:	PUSH	H
	LHLD	PCNTR
	INX	H
	SHLD	PCNTR
	POP	H
	RET
;			LGTH	OPRND	EXMPL
JMPTBL:	JMP	TYPE0	;1	NONE	DAA
	JMP	TYPE1	;1	REG	ADD
	JMP	TYPE2	;1	REG	INR
	JMP	TYPE3	;1	XR	STAX
	JMP	TYPE4	;2	R,DATA	MVI
	JMP	TYPE5	;2	DATA	OUT
	JMP	TYPE6	;3	XR,ADDR	LXI
	JMP	TYPE7	;3	ADDR	LHLD
	JMP	TYPE8	;3	ADDR	JZ
	JMP	TYPE9	;1	NONE	RZ
	JMP	TYP10	;1	NR.	RST
	JMP	TYP11	;1	R,R	MOV
	JMP	TYP12	;2	"CB"	BIT
	JMP	TYP13	;2/4	"ED"	LDI
	JMP	TYP14	;2/4	"DD"	SRL
	JMP	TYP15	;2/4	"FD"	RL
	JMP	TYP16	;2	NONE	JR
	JMP	TYP17	;2	FLAG	JR C
	JMP	TYP18	;2	N,R	BIT
	JMP	TYP19	;X/Y INDEX
	JMP	TYP20	;4	X/Y,ADD	LXI
	JMP	TYP21	;3	D(),R	MOV
	JMP	TYP22	;3	REG	ADD
	JMP	TYP23	;3
	JMP	TYP24	;4
;	
TYPE0:	JMP	CRLF
;
TYP22:	CALL	INCPC	;FOR DD/FD INSTRS
TYPE1:	CALL	TABC
T1B:	CALL	REG
	JMP	CRLF
;
TYP23:	CALL	INCPC
TYPE2:	CALL	TABC
	CALL	REGM
	JMP	CRLF
;
TYPE3:	CALL	TABC
	CALL	XR
	JMP	CRLF
;
TYP24:	CALL	INCPC
	CALL	INCPC
TYPE4:	CALL	TABC
	CALL	REGM
	CALL	COMMA
	JMP	T52
;
TYPE5:	CALL	TABC
T52:	LHLD	PGPTR
	INX	H
	LDA	INDX
	ORA	A
	JZ	T52A
	INX	H
T52A:	SHLD	PGPTR
L1017:	LHLD	PGPTR
	MOV	A,M
	CPI	' '
	JC	PHEXB
	CPI	5BH
	JNC	PHEXB
	LDA	INTYP
	CPI	4
	JC	PHEXB
	CPI	6
	JNC	PHEXB
	MOV	A,M
	CALL	QCHAR
	MVI	A,27H
	CALL	TYPE
	CALL	TABC
	CALL	SEMIC
PHEXB:	MOV	A,M
	CPI	0AH
	JC	NO2CH
	CALL	XO0
	MVI	A,'H'
	CALL	TYPE
	JMP	CRLF
;
NO2CH:	ADI	'0'
	CALL	TYPE
	JMP	CRLF
;
TYPE6:	CALL	TABC
	LHLD	PGPTR
	MOV	A,M
	CALL	XR
	CALL	COMMA
PRT2X:	LHLD	PGPTR
	INX	H
	MOV	E,M
	INX	H
	MOV	D,M
L106E:	PUSH	D
	CALL	L17EA
	JNC	L1084
	LDA	SYBFLG
	ORA	A
	JZ	L108D
	POP	D
	PUSH	D
	CALL	L173A
	JMP	L108D
;
L1084:	CALL	PSTRG
	LDA	TRMFLG
	ORA	A
	JZ	TRMLB2
	POP	D
	JMP	CRLF
TRMLB2:	CALL	TABC
	CALL	SEMIC
L108D:	POP	D
	MOV	A,D
	ORA	E
	MVI	A,'0'
	JZ	L10A3
	MOV	A,D
	ORA	A
	JZ	L10A9
	CALL	XO0
	MOV	A,E
	CALL	XO
L10A1:	MVI	A,'H'
L10A3:	CALL	TYPE
	JMP	CRLF
;
L10A9:	MOV	A,E
	CPI	0AH
	JC	L10B5
	CALL	XO0
	JMP	L10A1
;
L10B5:	ADI	'0'
	JMP	L10A3
;
TYPE7:	CALL	TABC
	JMP	PRT2X
;
TYPE8:	CALL	GETCC
	JMP	TYPE7
;
TYPE9:	CALL	GETCC
	JMP	CRLF
;
TYP10:	CALL	TABC
	LHLD	PGPTR
	MOV	A,M
	RAR
	RAR
	RAR
	ANI	7
	ORI	'0'
	CALL	TYPE
	JMP	CRLF
;
TYP21:	CALL	INCPC	;THEN FALL THRU
;
TYP11:	CALL	TABC
	CALL	REGM
CMREG:	CALL	COMMA
	JMP	T1B
;
PRTRL:	MOV	C,L
	MOV	A,H
	JMP	PRT2X
;
TYP13:	INX	H
	SHLD	PGPTR
	MOV	B,M
	LXI	H,EDTBL-7
	CALL	INCPC
	JMP	L0F2D
;
TYP14:	MVI	A,'X'
	JMP	IXIYC
;
TYP15:	MVI	A,'Y'
;
IXIYC:	STA	INDX
	CALL	INCPC	;ACCNT FOR PREFIX BYTE
	INX	H	;SKIP DD/FD
	MOV	A,M	;BYTE 2 MAY BE OPCODE
	CPI	0CBH
	JNZ	IXIYT
	INX	H
	MOV	A,M
	STA	DISPL	;FROM THIRD BYTE
TYP12:	INX	H
	MOV	B,M	;ACTUAL OPCODE HERE
	SHLD	PGPTR
	CALL	INCPC
	LXI	H,CBTBL-7
	JMP	L0F2D
;
IXIYT:	PUSH	PSW
	SHLD	PGPTR	;SAVE OPCODE PNTR
	INX	H
	MOV	A,M
	STA	DISPL	;FROM THIRD BYTE
	POP	PSW	;RECOV OPCODE
	MOV	B,A
	LXI	H,DDTBL-7
	JMP	L0F2D
;
TYP16:	CALL	TABC
	INX	H
	MOV	A,M
	CALL	INCPC
	LHLD	PCNTR
	MOV	E,A
	MVI	D,0
	CMP	D
	JP	NTNEG
	DCR	D
NTNEG:	DAD	D
	XCHG
	JMP	L106E
;
TYP17:	MOV	A,M
	RAR
	RAR
	ANI	6
	PUSH	H
	CALL	PCC
	POP	H
	JMP	TYP16
;
TYP18:	CALL	TABC
	MOV	A,M
	RAR
	RAR
	RAR
	ANI	7
	ORI	'0'
	CALL	TYPE
	JMP	CMREG
;
TYP19:	CALL	TABC
	LDA	INDX
	CALL	TYPE
	JMP	CRLF
;
TYP20:	SHLD	PGPTR
	CALL	TABC
	LDA	INDX
	CALL	TYPE
	CALL	COMMA
	CALL	INCPC
	CALL	INCPC
	JMP	PRT2X
;
XADSP:	LDA	INDX
	ORA	A
	MVI	A,'M'
	JZ	TYPE
	INX	H
	MOV	A,M
	PUSH	H
	LDA	DISPL
	MOV	H,A
	ORA	A
	JP	POSIT
	MVI	A,'-'
	CALL	TYPE
	MOV	A,H
	CMA
	INR	A
POSIT:	CPI	64H
	JC	LT100
	SBI	64H
	MOV	H,A
	MVI	A,'1'
	CALL	TYPE
	MOV	A,H
LT100:	MVI	L,0
TENLP:	SUI	0AH
	JM	TENOK
	INR	L
	JMP	TENLP
;
TENOK:	ADI	0AH
	MOV	H,A
	MVI	A,'0'
	ADD	L
	CALL	TYPE
	MOV	A,H
	ADI	'0'
	POP	H
	CALL	TYPE
	LXI	H,INDX-1
	MVI	B,3
	JMP	PSTRG
;
COMMA:	MVI	A,','
	JMP	TYPE
;
TABC:	MVI	A,9
	JMP	TYPE
;
SEMIC:	MVI	A,';'
	JMP	TYPE
;
PRDB:	CALL	L1A7E
	DB	'.BYTE',9,0
	LDA	INDX
	ORA	A
	JZ	DB1PR
	LHLD	PGPTR
	DCX	H
	MOV	A,M
	CALL	XO0
	MVI	A,'H'
	CALL	TYPE
	CALL	COMMA
DB1PR:	MVI	A,4
	STA	INTYP
	JMP	L1017
;
GETCC:	LHLD	PGPTR
	MOV	A,M
	RAR
	RAR
	ANI	0EH
PCC:	LXI	H,CCTAB
	CALL	ADDF
	MOV	A,M
	CALL	TYPE
	INX	H
	MOV	A,M
	CPI	'.'
	CNZ	TYPE
	RET
;
QCHAR:	PUSH	PSW
	MVI	A,27H
	CALL	TYPE
	POP	PSW
	CPI	27H
	JNZ	TYPE
	PUSH	PSW
	CALL	TYPE
	POP	PSW
	JMP	TYPE
;
XR:	LHLD	PGPTR
	MOV	A,M
	RAR
	RAR
	RAR
	ANI	6
	CPI	6
	JNZ	L127A
	MOV	A,M
	ANI	0CFH
	CPI	0C1H
	JZ	L1264
	CPI	0C5H
	JZ	L1264
	MVI	A,'S'
	CALL	TYPE
	MVI	A,'P'
	JMP	TYPE
;
L1264:	CALL	L1A7E
	MOV	D,B
	MOV	D,E
	MOV	D,A
	NOP
	RET
;
REGM:	LHLD	PGPTR
	MOV	A,M
	RAR
	RAR
	RAR
	JMP	L127A
;
REG:	LHLD	PGPTR
	MOV	A,M
L127A:	LXI	H,REGTBL
	ANI	7
	CALL	ADDF
	MOV	A,M
	CPI	'M'
	JZ	XADSP
	JMP	TYPE
;
ADDF:	ADD	L
	MOV	L,A
	RNC
	INR	H
	RET
;
XO0:	CPI	0A0H
	JC	XO
	PUSH	PSW
	MVI	A,'0'
	CALL	TYPE
	POP	PSW
	JMP	XO
;
PSTRG:	MOV	A,M
	CALL	TYPE
	INX	H
	DCR	B
	JNZ	PSTRG
	RET
;
CCTAB:	DB	'NZ'
	DB	'Z.'
	DB	'NC'
	DB	'C.'
	DB	'PO'
	DB	'PE'
	DB	'P.'
	DB	'M.'
;
REGTBL:	DB	'BCDE'
	DB	'HLMA'
;
OPCT:	DB	0FFH,0CBH,12,'.....'
	DB	0FFH,0EDH,13,'.....'
	DB	0FFH,0DDH,14,'.....'
	DB	0FFH,0FDH,15,'.....'
	DB	0FFH,0CEH,5,'ACI..'
	DB	0F8H,88H,1,'ADC..'
	DB	0F8H,80H,1,'ADD..'
	DB	0FFH,0C6H,5,'ADI..'
	DB	0F8H,0A0H,1,'ANA..'
	DB	0FFH,0E6H,5,'ANI..'
	DB	0C7H,0C4H,8,'C....'
	DB	0FFH,0CDH,7,'CALL.'
	DB	0FFH,2FH,0,'CMA..'
	DB	0FFH,3FH,0,'CMC..'
	DB	0F8H,0B8H,1,'CMP..'
	DB	0FFH,0FEH,5,'CPI..'
	DB	0FFH,27H,0,'DAA..'
	DB	0CFH,9,3,'DAD..'
	DB	0C7H,5,2,'DCR..'
	DB	0CFH,0BH,3,'DCX..'
	DB	0FFH,0F3H,0,'DI...'
	DB	0FFH,10H,16,'DJNZ.'
	DB	0FFH,0FBH,0,'EI...'
	DB	0FFH,8,40H,'EXAF.'
	DB	0FFH,0D9H,40H,'EXX..'
	DB	0FFH,76H,0,'HLT..'
	DB	0FFH,0DBH,5,'IN...'
	DB	0C7H,4,2,'INR..'
	DB	0CFH,3,3,'INX..'
	DB	0C7H,0C2H,8,'J....'
	DB	0FFH,0C3H,7,'JMP..'
	DB	0FFH,18H,16,'JMPR.'
	DB	0E7H,20H,17,'JR...'
	DB	0FFH,3AH,7,'LDA..'
	DB	0EFH,0AH,3,'LDAX.'
	DB	0FFH,2AH,7,'LHLD.'
	DB	0CFH,1,6,'LXI..'
	DB	0C0H,40H,11,'MOV..'
	DB	0C7H,6,4,'MVI..'
	DB	0FFH,0,0,'NOP..'
	DB	0F8H,0B0H,1,'ORA..'
	DB	0FFH,0F6H,5,'ORI..'
	DB	0FFH,0D3H,5,'OUT..'
	DB	0FFH,0E9H,0,'PCHL.'
	DB	0CFH,0C1H,3,'POP..'
	DB	0CFH,0C5H,3,'PUSH.'
	DB	0C7H,0C0H,9,'R....'
	DB	0FFH,17H,0,'RAL..'
	DB	0FFH,1FH,0,'RAR..'
	DB	0FFH,0C9H,0,'RET..'
	DB	0FFH,0FH,0,'RRC..'
	DB	0FFH,7,0,'RLC..'
	DB	0C7H,0C7H,10,'RST..'
	DB	0F8H,98H,1,'SBB..'
	DB	0FFH,0DEH,5,'SBI..'
	DB	0FFH,22H,7,'SHLD.'
	DB	0FFH,0F9H,0,'SPHL.'
	DB	0FFH,32H,7,'STA..'
	DB	0EFH,2,3,'STAX.'
	DB	0FFH,37H,0,'STC..'
	DB	0F8H,90H,1,'SUB..'
	DB	0FFH,0D6H,5,'SUI..'
	DB	0FFH,0EBH,0,'XCHG.'
	DB	0F8H,0A8H,1,'XRA..'
	DB	0FFH,0EEH,5,'XRI..'
	DB	0FFH,0E3H,0,'XTHL.'
	DB	0
;
CBTBL:	DB	0C0H,40H,18,'BIT..'
	DB	0C0H,80H,18,'RES..'
	DB	0C0H,0C0H,18,'SET..'
	DB	0F8H,0,1,'RLCR.'
	DB	0F8H,8,1,'RRCR.'
	DB	0F8H,10H,1,'RALR.'
	DB	0F8H,18H,1,'RARR.'
	DB	0F8H,20H,1,'SLAR.'
	DB	0F8H,28H,1,'SRAR.'
	DB	0F8H,38H,1,'SRLR.'
	DB	0
;
EDTBL:	DB	0FFH,43H,7,'SBCD.'
	DB	0FFH,53H,7,'SDED.'
	DB	0FFH,73H,7,'SSPD.'
	DB	0FFH,4BH,7,'LBCD.'
	DB	0FFH,5BH,7,'LDED.'
	DB	0FFH,4FH,0,'STAR.'
	DB	0FFH,5FH,0,'LDAR.'
	DB	0FFH,47H,0,'STAI.'
	DB	0FFH,57H,0,'LDAI.'
	DB	0FFH,7BH,7,'LSPD.'
	DB	0FFH,44H,0,'NEG..'
	DB	0FFH,45H,0,'RETN.'
	DB	0FFH,4DH,0,'RETI.'
	DB	0FFH,46H,0,'IM0..'
	DB	0FFH,56H,0,'IM1..'
	DB	0FFH,5EH,0,'IM2..'
	DB	0FFH,0A0H,0,'LDI..'
	DB	0FFH,0B0H,0,'LDIR.'
	DB	0FFH,0A8H,0,'LDD..'
	DB	0FFH,0B8H,0,'LDDR.'
	DB	0FFH,0A1H,0,'CCI..'
	DB	0FFH,0B1H,0,'CCIR.'
	DB	0FFH,0A9H,0,'CCD..'
	DB	0FFH,0B9H,0,'CCDR.'
	DB	0FFH,0A2H,0,'INI..'
	DB	0FFH,0B2H,0,'INIR.'
	DB	0FFH,0AAH,0,'IND..'
	DB	0FFH,0BAH,0,'INDR.'
	DB	0FFH,0A3H,0,'OUTI.'
	DB	0FFH,0B3H,0,'OUTIR'
	DB	0FFH,0ABH,0,'OUTD.'
	DB	0FFH,0BBH,0,'OUTDR'
	DB	0CFH,42H,3,'DSBC.'
	DB	0CFH,4AH,3,'DADC.'
	DB	0FFH,67H,0,'RRD..'
	DB	0FFH,6FH,0,'RLD..'
	DB	0C7H,40H,2,'INP..'
	DB	0C7H,41H,2,'OUTP.'
	DB	0CFH,42H,3,'DSBC.'
	DB	0CFH,4AH,3,'DADC.'
	DB	0
;
DDTBL:	DB	0FFH,29H,19,'DAD',1,'.'
	DB	0CFH,9,3,'DAD',1,'.'
	DB	0FFH,0E1H,19,'POP..'
	DB	0FFH,0E5H,19,'PUSH.'
	DB	0FFH,22H,7,'SI',1,'D.'
	DB	0FFH,2AH,7,'LI',1,'D.'
	DB	0FFH,23H,19,'INX..'
	DB	0FFH,2BH,19,'DCX..'
	DB	0C7H,46H,21,'MOV..'
	DB	0F8H,70H,21,'MOV..'
	DB	0FFH,86H,22,'ADD..'
	DB	0FFH,8EH,22,'ADC..'
	DB	0FFH,96H,22,'SUB..'
	DB	0FFH,9EH,22,'SBB..'
	DB	0FFH,0A6H,22,'ANA..'
	DB	0FFH,0AEH,22,'XRA..'
	DB	0FFH,0B6H,22,'ORA..'
	DB	0FFH,0BEH,22,'CMP..'
	DB	0FFH,34H,23,'INR..'
	DB	0FFH,35H,23,'DCR..'
	DB	0FFH,36H,24,'MVI..'
	DB	0FFH,21H,20,'LXI..'
	DB	0FFH,0F9H,0,'SPI',1,'.'
	DB	0FFH,0E3H,0,'XTI',1,'.'
	DB	0FFH,0E9H,0,'PCI',1,'.'
	DB	0
;
L173A:	LXI	H,CMDBUF
	MVI	M,'L'
	INX	H
	MOV	A,D
	CALL	L189F
	MOV	A,E
	CALL	L189F
	LXI	H,CMDBUF
	MVI	B,5
L174D:	CALL	L1798
	JC	L1757
	MOV	M,E
	INX	H
	MOV	M,D
	RET
;
L1757:	PUSH	H
	PUSH	D
	PUSH	B
	LHLD	SYMTP
	MOV	D,H
	MOV	E,L
	MOV	A,B
	ADI	3
	ADD	L
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A
	SHLD	SYMTP
	INX	H
	INX	H
	MVI	M,0
	DCX	H
	DCX	H
	MOV	B,H
	MOV	C,L
	LHLD	L1B4B
L1776:	MOV	A,E
	CMP	L
	JNZ	L1780
	MOV	A,D
	CMP	H
	JZ	L1787
L1780:	DCX	D
	DCX	B
	LDAX	D
	STAX	B
	JMP	L1776
;
L1787:	POP	B
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	MOV	M,B
	POP	D
L178F:	INX	H
	LDAX	D
	MOV	M,A
	INX	D
	DCR	B
	JNZ	L178F
	RET
;
L1798:	PUSH	D
	PUSH	H
	LXI	H,SYMTBL
L179D:	POP	D
	PUSH	D
	INX	H
	INX	H
	PUSH	H
	MOV	A,M
	INX	H
	ORA	A
	JZ	L17E0
	CMP	B
	JC	L17CC
	JNZ	L17D6
	MOV	C,A
	CALL	CMPSTR
	JZ	L17C5
	JC	L17E0
L17B9:	POP	H
	MOV	A,M
	INX	H
	ADD	L
	MOV	L,A
	JNC	L179D
	INR	H
	JMP	L179D
;
L17C5:	POP	H
	DCX	H
	DCX	H
	POP	D
	POP	D
	ORA	A
	RET
;
L17CC:	MOV	C,A
	CALL	CMPSTR
	JNC	L17B9
	JMP	L17E0
;
L17D6:	MOV	C,B
	CALL	CMPSTR
	JZ	L17E0
	JNC	L17B9
L17E0:	POP	H
	DCX	H
	DCX	H
	SHLD	L1B4B
	POP	H
	POP	D
	STC
	RET
;
L17EA:	LXI	H,SYMTBL
L17ED:	MOV	A,M
	INX	H
	CMP	E
	JNZ	L17F8
	MOV	A,M
	CMP	D
	JZ	L1807
L17F8:	INX	H
	MOV	A,M
	ORA	A
	STC
	RZ
	INX	H
	ADD	L
	MOV	L,A
	JNC	L17ED
	INR	H
	JMP	L17ED
;
L1807:	INX	H
	MOV	A,M
	INX	H
	MOV	B,A
	ORA	A
	RNZ
	STC
	RET
;
CMENTR:	LXI	H,CMDBUF+3
	CALL	GTVAL
	MOV	A,M
	CPI	' '
	JZ	L1820
	CPI	','
	JNZ	CMERR
L1820:	INX	H
	MOV	A,M
	CPI	'.'
	JNZ	CMERR
	PUSH	D
	CALL	L1872
	POP	D
	CALL	L174D
	JMP	NXCMD
;
	RET
;
CMKILL:	LXI	H,CMDBUF+3
	MOV	A,M
	CPI	'.'
	JNZ	CMERR
	CALL	L1872
	CALL	L1798
	JC	CMERR
	MOV	B,H
	MOV	C,L
	INX	H
	INX	H
	MOV	A,M
	ADD	L
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A
	INX	H
	XCHG
	LHLD	SYMTP
L1855:	MOV	A,E
	CMP	L
	JNZ	L185F
	MOV	A,D
	CMP	H
	JZ	L1866
L185F:	LDAX	D
	STAX	B
	INX	B
	INX	D
	JMP	L1855
;
L1866:	MOV	H,B
	MOV	L,C
	SHLD	SYMTP
	INX	H
	INX	H
	MVI	M,0
	JMP	NXCMD
;
L1872:	INX	H
	MVI	B,0
	PUSH	H
L1876:	MOV	A,M
	INX	H
	INR	B
	CPI	'+'
	JZ	L1876
	CPI	'-'
	JZ	L1876
	CPI	'0'
	JC	L1897
	CPI	':'
	JC	L1876
	CPI	'A'
	JC	L1897
	CPI	5BH
	JC	L1876
L1897:	DCR	B
	JZ	CMERR
	DCX	H
	XCHG
	POP	H
	RET
;
L189F:	PUSH	PSW
	CALL	HEXL
	MOV	M,A
	INX	H
	POP	PSW
	CALL	HEXR
	MOV	M,A
	INX	H
	RET
;
HEXL:	RAR
	RAR
	RAR
	RAR
HEXR:	ANI	0FH
	CPI	0AH
	JC	HEXRN
	ADI	7
HEXRN:	ADI	'0'
	RET
;
XO:	PUSH	PSW
	CALL	HEXL
	CALL	TYPE
	POP	PSW
	CALL	HEXR
	JMP	TYPE
;
PRWORD:	MOV	A,H
	CALL	XO
	MOV	A,L
	CALL	XO
PRSPC:	MVI	A,' '
	JMP	TYPE
;
GTVAL:	MOV	A,M
	CPI	'.'
	JZ	GTSYMB
	LXI	D,0
HEXBI:	MOV	A,M
	CPI	'0'
	RC
	CPI	':'
	JC	CVNUM
	CPI	'A'
	RC
	CPI	'G'
	RNC
	SUI	7
CVNUM:	SUI	'0'
	XCHG
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	ADD	L
	MOV	L,A
	XCHG
	INX	H
	JMP	HEXBI
;
GTSYMB:	CALL	L1872
	PUSH	D
	CALL	L1798
	JC	CMERR
	MOV	E,M
	INX	H
	MOV	D,M
	POP	H
	MOV	A,M
	RET
;
FOPEN:	PUSH	H
	LXI	H,START
	SHLD	OFIPTR
	XRA	A
	STA	FCB+32
	LXI	D,FCB
	MVI	C,0FH
	CALL	BDOS
	POP	H
	INR	A
	RNZ
	CALL	PRTSTR
	DB	'++FILE NOT FOUND',0DH,0AH
	DB	0
	JMP	NXCMD
;
RDFCHR:	PUSH	H
	LHLD	OFIPTR
	MOV	A,H
	CPI	1
	JNZ	L195B
	PUSH	B
	PUSH	D
	LXI	D,FCB
	MVI	C,14H
	CALL	BDOS
	ORA	A
	POP	D
	POP	B
	LXI	H,TBUF
	JNZ	L1962
L195B:	MOV	A,M
	INX	H
	SHLD	OFIPTR
	POP	H
	RET
;
L1962:	CPI	3
	JC	L1980
	CALL	PRTSTR
	DB	'++UNEXPECTED EOF',0DH,0AH
	DB	0
	JMP	NXCMD
;
L1980:	MVI	A,1AH
	MOV	M,A
	JMP	L195B
;
L1986:	PUSH	H
	LXI	D,FCB
	MVI	C,13H
	CALL	BDOS
	LXI	D,FCB
	MVI	C,16H
	CALL	BDOS
	INR	A
	JZ	CMERR
	XRA	A
	STA	FCB+32
	LXI	H,TBUF
	SHLD	OFIPTR
	POP	H
	RET
;
L19A7:	LXI	D,FCB
	MVI	C,15H
	CALL	BDOS
	ORA	A
	JNZ	L19D3
	LXI	D,FCB
	MVI	C,10H
	CALL	BDOS
	INR	A
	RNZ
	CALL	PRTSTR
	DB	'++CLOSE ERROR',0DH,0AH
	NOP
	JMP	NXCMD
;
L19D3:	CALL	PRTSTR
	DB	'++WRITE ERROR',0DH,0AH
	NOP
L19E6:	PUSH	H
	LHLD	OFIPTR
	MOV	M,A
	INR	L
	SHLD	OFIPTR
	POP	H
	RNZ
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,FCB
	MVI	C,15H
	CALL	BDOS
	ORA	A
	JNZ	L19D3
	LXI	H,TBUF
	SHLD	OFIPTR
	POP	H
	POP	D
	POP	B
	RET
;
CRLF:	MVI	A,0DH
	CALL	TYPE
	MVI	A,0AH
	JMP	TYPE
;
PSTAR:	MVI	A,'*'
TYPE:	PUSH	B
	PUSH	D
	PUSH	H
	MOV	E,A
	PUSH	D
	MVI	C,2
	LDA	QUIFLG
	ORA	A
	CZ	BDOS
	POP	D
	LDA	WRTFLG
	LXI	H,WFIFLG
	ANA	M
	MOV	A,E
	CNZ	L19E6
	MOV	A,E
	CPI	0AH
	JNZ	L1A41
	LDA	L1B35
	ORA	A
	JZ	L1A41
	LXI	H,LISCNT+1
	DCR	M
L1A41:	POP	H
	POP	D
	POP	B
	RET
;
GTCMD:	CALL	PSTAR
	LXI	D,CMDBUF
	MVI	A,'N'
	STAX	D
	MVI	C,0AH
	CALL	BDOS
	LXI	H,CMDBUF+1
	MOV	E,M
	MVI	D,0
	DAD	D
	INX	H
	MVI	M,0DH
	LXI	H,CMDBUF+1
LTUCNV:	INX	H
	MOV	A,M
	CPI	0DH
	JZ	CRLF
	CPI	61H
	JC	LTUCNV
	CPI	7BH
	JNC	LTUCNV
	ANI	5FH
	MOV	M,A
	JMP	LTUCNV
;
PRTSTR:	XRA	A
	STA	WFIFLG
	STA	QUIFLG
L1A7E:	XTHL
L1A7F:	MOV	A,M
	CALL	TYPE
	INX	H
	MOV	A,M
	ORA	A
	JNZ	L1A7F
	INX	H
	XTHL
	RET
;
INITBL:	XRA	A
	STA	SYMTBL+2
	LXI	H,SYMTBL
	SHLD	SYMTP
	MVI	A,0DH
	STA	CMDBUF+3
	LXI	H,0FFFFH
	SHLD	CTLTBL
	MVI	A,'I'
	STA	CTLTBL-1
	LHLD	DOCTBL
	MOV	A,H
	ORA	L
	RZ
	SHLD	DOCEND
	MVI	M,0FFH
	INX	H
	MVI	M,0FFH
	RET
;
CMPSTR:	LDAX	D
	CMP	M
	RNZ
	INX	D
	INX	H
	DCR	C
	JNZ	CMPSTR
	RET
;
L1ABF:	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,0BH
	CALL	BDOS
	ORA	A
	JZ	L1AFA
	MVI	C,1
	CALL	BDOS
	CPI	3
	JZ	ABORT
	CALL	CRLF
	JMP	NXCMD
;
ABORT:	CALL	PRTSTR
	DB	0DH,0AH,'ABORT Y/N '
	NOP
	MVI	C,1
	CALL	BDOS
	ANI	5FH
	CPI	'Y'
	JZ	0
	JMP	NXCMD
;
L1AFA:	POP	H
	POP	D
	POP	B
	RET
;
L1AFE:	CPI	0DH
	RZ
	CPI	0AH
	RZ
	ORA	A
	RZ
	CPI	' '
	RC
	CPI	7FH
	CMC
	RET
;
	DB	'('
INDX:	DB	0,')',0
DISPL:	DB	0
TRMFLG:	DB	0
L1B1B:	DW	START
L1B1D:	DW	0180H
OFFSET:	DW	0
SYMTP:	DW	SYMTBL
PCNTR:	DW	START
L1B25:	DW	START
PGPTR:	DW	START
DOCTBL:	DW	0
DOCEND:	DW	0
L1B2D:	DW	0
L1B2F:	DW	0
DMPCNT:	DW	0FFH
LISCNT:	DW	0A16H
L1B35:	DB	1
ASMLIT:	DB	'ASM'
COMLIT:	DB	'COM'
CTLLIT:	DB	'CTL'
SYMLIT:	DB	'SYM'
DOCLIT:	DB	'DOC'
WFIFLG:	DB	0
WRTFLG:	DB	0
QUIFLG:	DB	0
L1B48:	DB	0
L1B49:	DB	0
L1B4A:	DB	0
L1B4B:	DW	0
OFIPTR:	DW	0
L1B4F:	DB	0
SYBFLG:	DB	0
INTYP:	DB	0,0,0
CMDBUF:	DS	002CH
	END
