	TITLE   'MOVCPM - CPM MOVE UTILITY VERS.6  (C) DIGITAL RESEARCH'
        PAGE    40
; 
; LOCATIONS OF INFORMATION FROM THE COMMAND LINE ARE PUT INTO
; DEFAULT BUFFERS BY THE CONSOLE COMMAND PROCESSOR CCP.
; 
ARG1    EQU     5DH             ; FIRST "FILENAME" (NO. OF K)
ARG2    EQU     6DH             ; 2ND "FILENAME" (BLANK OR *)
BDOS    EQU     5               ; LOCATION OF JUMP TO BDOS
REBOOT  EQU     0               ; LOCATION TO JUMP TO FOR REBOOT
SYSTEM  EQU     900H            ; WHERE MOVCPM'S COPY OF SYSTEM RESIDES
SERIALC EQU     0D0AH           ; START OF SERIAL NUMBER IN CCP.
SERIALB EQU     1200H           ; START OF SERIAL NUMBER IN BDOS
SIZE    EQU     801H            ; WHERE LENGTH OF SYSTEM IS STORED
LENGTH  EQU     1B00H           ; CURRENT LENGTH OF CPM SYSTEM
CR      EQU     0DH
LF      EQU     0AH
; 
; 0980H - START OF SYSTEM BOOTSTRAP
; 0A00H - START OF RESIDENT IMAGE OF  0K  CPM SYSTEM
; 0D0AH - SIX CHARACTER SERIAL NUMBER IN CCP IN MOVCPM
; 1200H - SIX CHARACTER SERIAL NUMBER IN BDOS IN MOVCPM
; 1E80H - START OF BIOS ( BASIC INPUT / OUTPUT SYSTEM )
; 2400H - START ADDRESS OF RELOCATION BIT TABLE
; 26B0H - REL. TABLE ADDRESS FOR START OF BIOS
; 277FH - END ADDRESS OF RELOCATION BIT TABLE
; 
; INTERNAL ADDRESSES IN MOVCPM FOR 2D DISCUS VERSION
;
; 1E80H - SIGN ON MESSAGE, TERMINATING WITH A BINARY ZERO
; 1EF0H - SIGN ON MESSAGE OUTPUT ROUTINE
; 1F00H - MAIN BIOS JUMP TABLE
; 2278H - DENSITY TABLE, ONE BYTE FOR EACH DRIVE A,B,C,D
; 2280H - USER AREA ( USER I/O )
; 26B0H - REL. TABLE ADDRESS FOR START OF BIOS ( SIGN ON MESSAGE )
; 26C0H - REL. TABLE ADDRESS FOR MAIN BIOS JUMP TABLE
; 2730H - REL. TABLE ADDRESS FOR USER AREA JUMP TABLE
;
        PAGE
        ORG     100H
;
FIRST:  JMP     START
; 
        DB      'CPMOVE VERS 6 COPYRIGHT (C) DIGITAL RESEARCH, 1978'
; 
        DB      ' COPYRIGHT (C) LIFEBOAT ASSOCIATES, 1979 '
; 
; 
START:  LXI     SP,SIZE-1
; 
        LXI     D,ARG1
        LDAX    D               ; GET FIRST ARG . MIGHT BE NO. OF K
        CPI     ' '
        JZ      UNSPEC          ; JUMP IF NO NUMBER TYPED IN COMMAND
        CPI     '?'
        JZ      UNSPEC          ; RECOGNIZE BLANK OR ? AS NO-NUMBER
; 
; 
; IF WE ARE HERE, THERE IS A DECIMAL NUMBER AT 5DH  TO BE READ
; 
        LXI     H,0             ; H WILL CONTAIN THE VALUE OF THE NUMBER
DIGIT:  LDAX    D               ; GET NEXT DIGIT (ASCII)
        INX     D               ; INCREMENT DIGIT POINTER
        CPI     ' '
        JZ      TESTNO          ; FINISHED GETTING NUMBER IF BLANK OR NULL
        ORA     A               ; TEST FOR NULL (0)
        JZ      TESTNO
        SUI     '0'             ; SUBTRACT ASCII 0 CONVERT DIGIT TO NUMBER
        CPI     10              ; MAKE SURE IT WAS REALLY A DIGIT (0-9)
        JNC     INVAL           ; JUMP IF NOT
        DAD     H               ; DOUBLE ACCUMULATED VALUE
        PUSH    H               ; SAVE RESULT
        DAD     H               ; DOUBLE IT AGAIN
        DAD     H               ; AND AGAIN
        POP     B               ; NOW GET RESULT SAVE ABOVE AND ADD TO VALUE
        DAD     B               ; WE HAVE NOW MULTIPLIED VALUE BY 10
        MOV     C,A             ; NOW ADD TO IT THE VALUE OF THE NEW DIGIT
        MVI     B,0
        DAD     B
        JMP     DIGIT           ; AND GO BACK FOR NEXT DIGIT
; 
; 
TESTNO: MOV     A,H             ; GET HIGH BYTE OF NUMBER OF K SPECIFIED
        ORA     A               ; IF IT'S NOT ZERO, NUMBER > 255
        JNZ     INVAL           ; AND THEREFORE NOT A VALID MEMORY SIZE
        MOV     A,L             ; GET LOW BYTE
        CPI     17              ; SYSTEM MUST BE AT LEAST 17K
        JC      INVAL           ; SO ERROR IF < 17
; 
; 
; NOW MULTIPY NO. OF K BY 1024 TO GET SPECIFIED MEMORY SIZE
; 
        MVI     L,0             ; L WAS SAVED IN A ABOVE
        MOV     H,A             ; THIS MULTIPLIES BY 256
        DAD     H               ; MULTIPLY BY 2
        DAD     H               ; MULTIPLY BY 2 AGAIN
        JMP     PUTK            ; H=MEMORY SIZE IN BYTES
; 
; 
INVAL:  LXI     D,INVMSG        ; INVALID MEMORY SIZE
        CALL    MSG             ; TO CONSOLE
        JMP     REBOOT          ; REBOOT SYSTEM
; 
; 
INVMSG:
        DB  CR,LF,'Invalid memory size.$'
; 
; 
; COME HERE IF MEMORY SIZE WAS NOT SPECIFIED IN COMMAND LINE
; 
UNSPEC: LXI     H,0             ; SET UP TO FIND MEMORY SIZE
BLOCK:  INR     H               ; POINT TO 1ST LOCATION OF NEXT PAGE
        JZ      FOUND           ; GET OUT IF WRAPPED OVER 64K
        MOV     A,M             ; GET 1ST BYTE OF PAGE POINTED TO BY H
        CMA                     ; COMPLEMENT IT
        MOV     M,A             ; AND PUT IT BACK
        CMP     M               ; NOW READ BACK AND COMPARE
        CMA                     ; RESTORE MEMORY BEFORE JUMPING
        MOV     M,A
        JZ      BLOCK           ; KEEP LOOPING IF MEMORY VALID
FOUND:  MOV     A,H             ; L=0, HL= NO. OF BYTES OF MEMORY.
        ANI     0FCH            ; TRUNCATE TO NEAREST 256
        MOV     H,A             ; DROP TO A MULTIPLE OF 1024
PUTK:   PUSH    H               ; SAVE TRUNCATED MEMORY SIZE ON STACK
        MOV     A,H             ; TAKE NUMBER OF PAGES ANS DIVIDE BY 4 
        RRC                     ; TO GET NUMBER OF K.
        RRC
        ANI     3FH
        JNZ     SKIP
        MVI     A,64            ; MAXIMUM NO. K
SKIP:   LXI     H,SIZEK         ; POINTER TO SIZE IN K STORAGE
        MOV     M,A             ; SAVE IT
        MOV     B,A             ; SAVE NUMBER OF K IN B
        LXI     H,'00'          ; GET 2 ASCII ZERO'S
        SHLD    CPMMSG+15
CNVRT1: LXI     H,CPMMSG+16     ; CONVERT #K TO 2-DIGIT ASCII
        INR     M               ; INCREMENT LOW DIGIT
        MOV     A,M             ; GET ITS NEW VALUE
        CPI     '9'+1
        JC      CNV1A           ; CONTINUE IF IN RANGE 0-9
        MVI     M,'0'           ; ELSE CARRY INTO HIGH DIGIT
        DCX     H
        INR     M
CNV1A:  DCR     B               ; DECREMENT REST OF NUMBER
        JNZ     CNVRT1          ; AND CONTINUE IN LOOP IF NOT YET ZERO
; 
        LXI     H,SIZEK
        MOV     B,M             ; NUMBER OF K TO B
        LXI     H,'00'          ; 2 ASCII ZERO'S
        SHLD    CPM2MSG+18
CNVRT2: LXI     H,CPM2MSG+19
        INR     M
        MOV     A,M
        CPI     '9'+1
        JC      CNV2A
        MVI     M,'0'
        DCX     H
        INR     M
CNV2A:  DCR     B               ; DECREMENT NO. OF K
        JNZ     CNVRT2
; 
        LXI     D,CPMMSG        ; CONSTRUCTING . . . MESSAGE
        CALL    MSG             ; TO CONSOLE
; 
; 
        LXI     H,SIZE          ; GET LENGTH OF SYSTEM IN BYTES
        MOV     C,M
        INX     H
        MOV     B,M
        PUSH    B               ; SAVE LENGTH IN B AND ON STACK
; 
; 
; SEARCH SYSTEM FOR A COPY OF THE STRING "K VERS".
; SEARCH STARTS AT 900H AND CONTINUES TO 900H+LENGTH
; 
; 
        LXI     H,SYSTEM
SEARCH: LXI     D,KVERS         ; POINT AT STRING "K VERS"
        MOV     A,B
        ORA     C
        JZ      NOFIND          ; EXIT IF NOT FOUND
        DCX     B               ; DECREMENT SEARCH COUNT, SAVE ON STACK
        PUSH    B
                ; 
        MVI     C,6             ; SET STRING LENGTH FOR COMPARE LOOP
        PUSH    H               ; SAVE CURRENTLY SEARCH ADDRESS ON STACK
NEXT:   XCHG
COMPR:  LDAX    D               ; LOOP TO MATCH STRINGS
        CPI     ' '             ; FOUND THE SPACE ?
        JZ      YES
        ANI     5FH
YES:    CMP     M
        XCHG
        JZ      BUMP
NEWLOC: POP     H
        INX     H
        POP     B
        JMP     SEARCH
; 
BUMP:   INX     D
        INX     H
        DCR     C
        JNZ     NEXT
; 
GOTIT:  POP     H               ; STRING FOUND- GET ITS LOCATION
        POP     B               ; CLEAN UP STACK
        DCX     H               ; POINT TO 2ND DIGIT OF NUMBER OF K
        LXI     D,CPMMSG+16
        LDAX    D               ; GET ASCII NUMBER OF K FROM STRING
        MOV     M,A             ; AND PUT IT INTO STRING JUST FOUND.
        DCX     H
        DCX     D
        LDAX    D
        MOV     M,A
; 
; 
NOFIND: LDA     BDOS+1          ; GET LOW BYTE OF CURRENT BDOS ADDRESS
        CPI     6               ; THIS BYTE IS NORMALLY 6, BUT IS CHANGED
        MVI     A,0             ; BY SID OR DDT AND RESTORED ON RETURN
        JNZ     SYNC1           ; SYNCRONIZATION ERROR IF BYTE NOT 6
        POP     B               ; GET SYSTEM LENGTH
        POP     H               ; GET MEMORY SIZE IN BYTES
        MOV     A,L             ; SUBTRACT B FROM H TO GET MSIZE-LENGTH
        SUB     C               ; THIS IS ADDRESS NEW SYSTEM WILL RUN AT
        MOV     L,A
        MOV     A,H
        SBB     B
        MOV     H,A
        SHLD    NEWSYS          ; SAVE THIS ADDRESS AT NEWSYS AND IN D
; 
        LXI     H,SYSTEM        ; POINT TO START OF SYSTEM
        DAD     B               ; LOADED WITH MOVCPM.COM
        PUSH    B               ; SAVE LENGTH
; 
; 
; LOOP TO PERFORM THE RELOCATION.
; MSIZE-LENGTH+100H IS ADDED TO EACH ADDRESS 
; MARKED BY A '1' IN THE RELOCATION BIT TABLE.
; 
; 
REL1:   POP     B               ; GET LENGTH
        PUSH    H               ; SAVE TABLE ADDRESS
        LHLD    NEWSYS
        XCHG                    ; ADDRESS OF NEW SYSTEM IN D
        LXI     H,100H
        DAD     D               ; H IS NOW NEWSYS+100H
        LXI     D,SYSTEM        ; IF NOT A SPACE, SET DE TO PUT
REL2:   MOV     A,B             ; NEW SYSTEM IN PLACE FOR SYSGEN
        ORA     C
        JZ      FINISH          ; JUMP IF COUNT HAS REACHED ZERO
REL3:   DCX     B               ; DECREMENT BYTE COUNT
        MOV     A,E             ; LOW BYTE OF CURRENT ADDRESS IN NEW SYST.
        ANI     7               ; IF A MULTIPLE OF 8, GET ANOTHER
        JNZ     REL4            ; BYTE OF THE RELOCATION TABLE
        XTHL                    ; GET H=CURRENT ADDRESS IN TABLE
        MOV     A,M             ; GET THE BYTE THERE
        INX     H               ; INCREMENT TABLE ADDRESS
        XTHL                    ; PUT IT BACK ON STACK
        MOV     L,A
REL4:   MOV     A,L             ; TEST NEXT BIT OF CURRENT TABLE BYTE
        RAL
        MOV     L,A
        JNC     REL5            ; IF NOT SET, CONTINUE IN LOOP
; 
; GET HIGH BYTE OF ADDRESS AT CURRENT LOCATION IN NEW SYSTEM.
; 
        LDAX    D
        ADD     H               ; ADD HIGH BYTE OF  100H+EXECUTION ADDR
        STAX    D               ; AND PUT BACK IN NEW SYSTEM
REL5:   INX     D               ; POINT TO NEXT BYTE OF NEW SYSTEM
        JMP     REL2
; 
; 
FINISH: POP     D               ; CLEAN UP STACK
; 
; 
; COMPARE SERIAL NUMBER OF NEW SYSTEM WITH THAT OF THE
; SYSTEM THAT IS CURRENTLY RUNNING.
; 
        LXI     D,SERIALB       ; ADDR OF SER# IN BDOS IN MOVCPM
        LHLD    BDOS+1
        MVI     L,0             ; ADDRESS OF SERIAL NO. IN CURRENT SYSTEM
        MVI     C,6             ; LOOP COUNT
SERLP:  LDAX    D
        CMP     M
        JNZ     SYNC1
        INX     H
        INX     D
        DCR     C
        JNZ     SERLP
; 
        LDA     ARG2            ; FIND SECOND ITEM IN COMMAND LINE
        CPI     ' '             ; IF BLANK, SYSTEM IS TO BE PLACED
        JZ      EXEC            ; AT IT'S EXECUTION ADDRESS
; 
; 
; IF 900-97FH IS ALL ZEROES THEN MOVE THE WHOLE SYSTEM
; DOWN 80H BYTES FFROM 980H TO 900H ( SYSGEN POSITION )
; 
        MVI     B,80H
        LXI     H,SYSTEM
TEST1:  MOV     A,M
        ORA     A
        JNZ     NOMOVE
        INX     H
        DCR     B
        JNZ     TEST1
; 
        LHLD    SIZE            ; GET SYSTEM LENGTH
        LXI     B,-80H
        DAD     B
        MOV     B,H
        MOV     C,L             ; BC = LENGTH-128
        LXI     H,SYSTEM+80H
        LXI     D,SYSTEM
        CALL    MOVE
; 
NOMOVE: LHLD    SIZE            ; GET SYSTEM LENGTH
        MOV     B,H
        MOV     C,L
        LXI     H,SYSTEM
        DAD     B
        MOV     B,H             ; C IS ALREADY 0 - B = NUMBER OF
;                               ; PAGES IN THE NEW SYSTEM
; 
; 
; PUT NUMBER OF PAGES IN THE NEW SYSTEM INTO THE
; "SAVE XX CPMXX" MESSAGE TEXT.
; 
        LXI     H,'00'
        SHLD    SAVE00
PUTN:   DCR     B
        JZ      PUTK2
        LXI     H,SAVE00+1
        INR     M
        MOV     A,M
        CPI     '9'+1
        JC      PUTN
        MVI     M,'0'
        DCX     H
        INR     M
        JMP     PUTN
; 
PUTK2:  LHLD    CPMMSG+15
        SHLD    CPM00           ; PUT NO. OF K IN MESSAGE
        LXI     D,ENDMSG
        CALL    MSG             ; OUTPUT MESSAGE TO CONSOLE
        JMP     REBOOT          ; RETURN TO CP/M
; 
EXEC:   LXI     H,SIZE
        MOV     C,M
        INX     H
        MOV     B,M
        LHLD    NEWSYS
        XCHG
        LXI     H,SYSTEM
        CALL    MOVE
; 
SYSGO:  LXI     D,1600H
        LHLD    NEWSYS
        DAD     D
        PCHL                    ; JUMP TO NEW SYSTEM
; 
        DB      1
SYNERR: XRA     A
SYNE1:  DCR     A
        JNZ     SYNE1
        LXI     H,76F3H         ; PUT DI,HLT WHERE CALL BDOS WILL RETURN
        SHLD    SYNC1-1
        LXI     H,SYSCAL
        MVI     M,0CDH          ; CHANGE INSTR. AT SYSCAL "JMP" > "CALL"
        LXI     D,SYNMSG-5
        LXI     H,5
        DAD     D
        XCHG                    ; GET SYNC ERR MESSAGE ADDRESS IN DE
        JMP     MSG             ; OUTPUT MESSAGE AND HANG
; 
MOVE:   MOV     A,C
        ORA     B
        RZ
        MOV     A,M
        STAX    D
        INX     H
        INX     D
        DCX     B
        JMP     MOVE
; 
LMOVE:  MOV     A,C
        ORA     B
        RZ
        MOV     A,M
        STAX    D
        DCX     H
        DCX     D
        DCX     B
        JMP     LMOVE
; 
MSG:    MVI     C,9
SYSCAL: JMP     5
; 
        DB      1
SYNC1:  LXI     H,SYNERR        ; SET JUMP AT SYNC2 TO SYNERR
        SHLD    SYNC2+1
        JMP     SYNC2
; 
SYNC2:  JMP     SYNC2
; 
SYNMSG:
        DB      CR,LF,'Syncronization error.$'
; 
NEWSYS: DB      0,0
SIZEK:  DB      0
;
CPMMSG:
        DB      CR,LF,'Constructing '
        DB      '00K CP/M Version 1.4   ',CR,LF
        DB      'for Disk Jockey 2D.$'
; 
CPM2MSG:
        DB      CR,LF,'System requires 00K of memory.$'
; 
ENDMSG:
        DB      CR,LF,CR,LF,'New CP/M in memory at 900H'
        DB      ' (sysgen position)'
        DB      CR,LF,'is ready for "SYSGEN" or "SAVE '
SAVE00:
        DB      '00 CPM'
CPM00:
        DB      '00.COM"$'
; 
KVERS:
        DB      'K VERS'
; 
; 
        END
