
    MEMTEST3 -- 11:56.AM Wednesday 13 April 83

    maclib sal80
    INITIALIZE?
;   maclib frzscrn
;   maclib get8hex
    maclib blockmov
;   maclib compare
;   maclib cmpstrs
;   maclib divide
;   maclib multiply
;   maclib findstr
;   maclib response
;   maclib parms
;   maclib pic-optn
;   maclib <your macro filename(s)>
;   Z80?
    RMAC?

;;;;;;;;    most EQUs are in the header files

    maclib standard
    maclib memtest

;;;;;;;;    set up ORG

;   if ?rmac
;    org 0
;   else
;    org 100h
;   endif

;;;;;;;;    PUBLICs and EXTRNs go here

    EXTRN report$error,end$stack

    PUBLIC end$hi$stack,hi$code,end$hi$code
    PUBLIC @code$size,test$lo$memory

;;;;;;;;    data segment

    if ?RMAC ! CSEG ! endif
    ;
    ;   Here, both data and code are CSEGed to force
    ;   LINK to put the data table in front of the code,
    ;   and the whole package in high memory, without
    ;   snide remarks and unnecessary arm-wrestling.
    ;

overlay$data:

;;;;;;;;    (DBs, DWs, DSs go here)

;;;;;;;;common$data            db '####################################'
;;;;;;;;    {the line of '#'s is for visual verification of overlay placement}

?cpmspc             db FALSE
?prgspc             db FALSE
?savcpm             db FALSE
?movprg             db FALSE
?need$restore$cpm   db FALSE
?did$restore$cpm    db FALSE
?delay              db FALSE
?dcounter           db 0
?bit$shift          db 1
?pass$counter       db 0
?timing             db 0
?pattern            db FALSE
?mask               ds 1
?byte               ds 1
?terminates         db TRUE
?errors$to$disk     db FALSE

;@dma$ptr           dw dma$bufr
                    ds 2
@lo$sav$base        ds 2
@hi$sav$top         ds 2
@top$cpm$save       ds 2
@prior$stkptr       ds 2
@hi$base            ds 2
@code$size          dw (end$hi$code - hi$code)
@prgtop             ds 2
;@main$size         dw ((end$code-code)+(end$data-data))
                    ds 2
@cpm$size           ds 2
@prg$size           ds 2
@stkptr$low         dw end$stack
@stkptr$high        dw (end$hi$stack-2)
@warmboot           ds 2
@iterations         dw 1
@err$addr           ds 2
@lowr$bndry         dw 0
@uppr$bndry         dw TOP$OF$RAM
@lo$addr$extnsn     dw 0
@hi$addr$extnsn     dw 0

space$err$msg:      db 'Not enough space to move MEMTEST and/or save CP/M$'

;;;;;;;;    stack goes here {to enable overlay with HI$PRG}

hi$stack:           ds STACK$SIZE
end$hi$stack:
stkptr:
end$overlay$data:   ds 0
hi$code:

;;;;;;;;   local (non-LIB) macro definitions and subroutines go here


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;    Most of the code below is documented in MT2.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


test$lo$memory:
    SAVE$DUBLS?
    IF? ?timing;    initialize the restart location
      CALL? init$rst
    ENDIF?
    LOAD? A,?bit$shift
    SAVE? PSW
    LOAD? A,?pass$counter
    SAVE? PSW
    CALL? write$memory; low,high
    CALL? conditional$delay
    RESTORE? PSW
    STORE? A,?pass$counter
    RESTORE? PSW
    STORE? A,?bit$shift
    RESTORE$DUBLS?
    CALL? read$memory
    CALL? restore$prg
    RETURN?
 

init$rst:
    SAVE$DUBLS?
    mvi A,POPSW;        {don't want to return to there}
    STORE? A,@TSTRST
    mvi A,JUMP
    STORE? A,@TSTRST+1
    lxi H,report$error@
    STORE? HL,@TSTRST+2
    RESTORE$DUBLS?
    RETURN?


report$error@:
;
;   This ugly bit of ad-hockery exists to provide
;   a target for the jump from the TSTRST area
;   and to do the things that have to be done
;   in order to get the error-message outputted
;   and go on with the test.  The ugliness of the
;   code rather strongly suggests that a fundamental
;   design error was made somewhere.
;
;   The RESTORE$PRG and RESTORE$AREA$UNDER$TEST calls
;   are also done from COMPARE$MASK, three pages down
;   from here.  BE WARNED.
;
    SAVE? DE,HL
    SAVE? PSW
    CALL? restore$prg
    RESTORE? PSW
    RESTORE? HL,DE
    CALL? report$error;    {which is now back in low memory}
    SAVE? DE,HL
    SAVE? PSW
    CALL? restore$area$under$test
    RESTORE? PSW
    RESTORE? HL,DE
    RETURN?;    {to the CONTINUE label in READ$MEMORY}


write$memory:
    IF? ?timing;   fill it with TSTRSTs
      ; adjust @lowr$bndry if necessary
      SAVE? DE,HL
      LOAD? HL,@lowr$bndry
      lxi D,TOP$OF$RST$AREA
      IF? HL,LT?,DE
        xchg
        STORE? HL,@lowr$bndry
        NEWLINE? 
        STRING$TO$CONS? 'Dynamic Timing test resets bottom-of-memory to '
        mvi A,TOP$OF$RST$AREA
        BYT$HEX$TO$CONS?
        NEWLINE?
      ENDIF?      
      RESTORE? HL,DE
      REPEAT?
        mvi M,TSTRST
        inx H
      ENDREPEAT? HL,GE?,DE,inline
    ELSE?;         fill it with patterns
      IF? ?pattern
        REPEAT?
          LOAD? A,?pass$counter;
          xra H ! xra L
           mov M,A
          inx H
        ENDREPEAT? HL,GE?,DE,inline
      ELSE?
        REPEAT?
          LOAD? A,?bit$shift
          xra H ! xra L
          mov M,A
          inx H
        ENDREPEAT? HL,GE?,DE,inline
      ENDELSE?
    ENDELSE?
    RETURN?


wait:
    lxi B,WAIT$FACTOR
    DO? BC
      xra A
      DO? A
        xthl
        xthl
      ENDDO?
    ENDDO?
    RETURN?


conditional$delay:
    IF? ?delay
      mov B,A;     {[A] = ?delay, from the IF?-test}
      mvi A,1
      STORE? A,?dcounter
      dcr B
      WHILE? B,NE?,0
        LOAD? A,?dcounter
        rlc
        STORE? A,?dcounter
        dcr B
      ENDWHILE?
      DO? ?dcounter
        SAVE? BC
        CALL? wait
        RESTORE? BC
      ENDDO?
    ENDIF?
    RETURN?


compare$mask    MACRO
;
;   The calls to RESTORE$PRG, REPORT$ERROR@
;   and RESTORE$AREA$UNDER$TEST also occur
;   in HI$REPORT$ERROR@ three pages back
;   from here.  BE WARNED.
;
    cmp M
    IF? ,ZERCLR?;    {no match}
      SAVE? DE,HL
      SAVE? PSW;
      CALL? sav$err$regs
      CALL? restore$prg
      CALL? report$error;    {lives in MT2 module}
      CALL? restore$area$under$test
      RESTORE? PSW
      RESTORE? HL,DE
    ENDIF?
    ENDM


sav$err$regs:
    STORE? A,?mask
    mov A,M
    STORE? A,?byte
    STORE? HL,@err$addr
    RETURN?


restore$prg:
;
;   MOVE$PRG/RESTORE$PRG are swapping routines:
;   The AREA that PRG lives in must be saved and
;   restored even when PRG is "out".  That's because,
;   when PRG is "out", the AREA is under test and the
;   image created by the WRITE$MEMORY phase must
;   be preserved in between error messages.  There
;   is a HI$PRG region which holds the image of
;   PRG and an AREA$SAVE region which holds the
;   image of the AREA when PRG is restored to write
;   out an error message.  When PRG is restored,
;   the area under test is first saved, then the
;   message is reported and then the area is restored.
;   Unfortunately for the clarity of this exposition,
;   the saving and restoration of the area is less
;   symmetric than in the SAVE$CPM/RESTORE$CPM case,
;   and the save/restore prg area code appears BOTH
;   in REPORT$ERROR@   A N D  (sob!!)  at the end
;   of the COMPARE$MASK macro.
;
;   (Such ugliness often breeds bugs, but I don't 
;   see a cleaner way to do it.)
;
;   Clobbers all registers
;
    ;
    ; save area under test
    ;
    lxi H,TBASE
    LOAD? DE,@lo$sav$base
    LOAD? BC,@prg$size
    BLOCK$MOVE?
    ;
    ; restore program
    ;
    lxi D,TBASE
    LOAD? HL,@hi$base
    LOAD? BC,@prg$size
    BLOCK$MOVE?
    RETURN?


restore$area$under$test:
    LOAD? HL,@lo$sav$base
    lxi D,TBASE
    LOAD? BC,@prg$size
    BLOCK$MOVE?
    RETURN?


read$memory:
    IF? ?timing;   insert RET and then CALL?
      REPEAT?
        SAVE? DE,HL
        mvi M,RTRN
        call $+3
        xthl
        lxi D,(continue-$+1)
        dad D
        xthl
        pchl
continue:
        RESTORE? HL,DE
        mvi M,TSTRST
        inx H
      ENDREPEAT? HL,GE?,DE,inline
    ELSE?;         fill it with patterns
      IF? ?pattern
        REPEAT?
          LOAD? A,?pass$counter;
          xra H ! xra L
          compare$mask
          inx H
        ENDREPEAT? HL,GE?,DE,inline
      ELSE?
        REPEAT?
          LOAD? A,?bit$shift
          xra H ! xra L
          compare$mask
          inx H
        ENDREPEAT? HL,GE?,DE,inline
      ENDELSE?
    ENDELSE?
    RETURN?

end$hi$code:

    END

