	TITLE	'17 AUG 78 W/MON LLB'
	ORG	2000H
COUNTS	EQU	$

;	MODE 0 - POLLING (EMULATE CENTRAL SITE AND MODEM)
;
;    BUTTON BUTTON BUTTON BUTTON BUTTON BUTTON SWITCH SWITCH
;       1      2      3      4      5      6      7      8
;
;    1- CLEAR COUNTER SELECTED BY THUMBWHEEL SWITCH SETTING
;    2- SET POLL IDLE VALUE FROM THUMBWHEEL SWITCHES
;    3- SEND CANNED TEST MESSAGE TO TA
;    4- STEP TA TO NEXT ONE (STEP RATE IS 2 HZ)
;    5-
;    6-
;    7- SEND LOOPBACK MESSAGES TO SELECTED TA INSTEAD OF ORIG
;    8- SEND INCORRECT CRC ON MESSAGES TO TERMINALS
;
;	MODE 0 COUNTERS
;
US1BBB	DW	$-$	;IA AND TA SPACE
US1POLC	DB	$-$	;POLLS SENT
US1PRC	DB	$-$	;POLL RESPONSES RECEIVED
US1MRC	DB	$-$	;MESSAGED RECEIVED
US1MSC	DB	$-$	;MESSAGES SENT
CRCE1	DB	$-$	;CRC ERROR ON MESSAGES
US1BUSTC DB	$-$	;BUSTED MESSAGES
US1BTAC	DB	$-$	;MESSAGES WITH ODD TA
US1BPC	DB	$-$	;BAD IA ON POLL RESPONSE
US1BIAC	DB	$-$	;BAD IA ON MESSAGE
US1NCTSC DB	$-$	;TI TRANSMITTING BEFORE CTS
US1TRYC	DB	$-$	;TI ATTEMPTED TO RESPOND (UNSCSFULY)
US1NPRC	DB	$-$	;POLL TIMEOUTS- NO RESPONSE TO POLL
US1NGAC	DB	$-$	;NO GOAHEAD ON A RECEIVED XMISSION
US1SIA	DB	$-$	;IA OF TI WHICH IS STREAMING
	ORG	COUNTS
;
;	MODE 1 - RESPONDING TO POLLS (EMULATE TI)
;
;    BUTTON BUTTON BUTTON BUTTON BUTTON BUTTON SWITCH SWITCH
;       1      2      3      4      5      6      7      8
;
;    1- CLEAR COUNTER SELECTED BY THUMBWHEEL SWITCH SETTING
;    2-
;    3- SEND CANNED MESSAGE FROM SELECTED TA
;    4- STEP TA TO NEXT ONE (STEP RATE IS 2 HZ)
;    5- SEND @@RES MESSAGE FROM SELECTED TA
;    6-
;    7-
;    8- SEND INCORRECT CRC ON MESSAGES
;
;	COUNTERS FOR MODE 1
;
US2BBB	DW	$-$	;ROOM FOR IA AND TA
US2POLC	DB	$-$	;POLLS RECEIVED
US2SPCC	DB	$-$	;POLL RESPONSES SENT
US2MSC	DB	$-$	;MESSAGES RECEIVED
US2MSGC	DB	$-$	;MESSAGES SENT
US2BPCC	DB	$-$	;BAD CRC ON POLL
US2BUSTC DB	$-$	;BUSTED MESSAGES
US2BTAC	DB	$-$	;BAD TA ON MESSAGE
US2BPEC	DB	$-$	;BAD EOM ON POLL
US2BMCC	DB	$-$	;BAD CRC ON MESSAGE
US2BC1C	DB	$-$	;BAD C1 IN MESSAGE
US2UMSGC DB	$-$	;LITES MESSAGES RCVD
US2WMC	DB	$-$	;MESSAGES TO WRONG TA RCVD
US2MSTAT DB	$-$	;STATUS-AT-A-GLANCE LIGHTS
;
;ADDED POLL TIMEOUT AND ATTEMPTED RESPONSE COUNTERS 25MAY77
;ADDED DISABLE INT AT INIT                          25MAY77
;ADDED POLL TIMER BYTE AND SET TIMER WHEN POLLING   26MAY77
;INIT TA IN DDASP    DISABLE INT'S IN I/O ROUTINES  26MAY77
;REDESIGN CPULOOP TO SERVICE USART FASTER           27MAY77
;LOAD SP AT STARTUP                                 28MAY77
;ISSUE USART COMMANDS ONLY WHEN TX RDY STATUS IS ON 17JUN77
;RSYN1 WAS UNDEFINED- FIX IT                        17JUN77
;ERRORS IN SABFLIP TABLE ON E, N, U, V, W           18JUN77
;BEGINNING TO RECONSTRUCT ADDITIONAL ROUTINES       18JUN77
;WORKING ON RESPOND-TO-POLL LOGIC                   27JUN77
;WORKING ON RESPOND-TO-POLL LOGIC                   28JUN77
;ISSUE USART 2 COMMAND ONLY WHEN TX RDY STATUS IS ON29JUN77
;CLEAR US2XF AND DISABLE TRANSMIT                   29JUN77
;FIX RETURN TO CPULOOP IN US2RSYNC                  30JUN77
;ENABLE CLOCK IN US2 I/O ROUTINES                   30JUN77
;IMPLEMENT STATUS-AT-A-GLANCE DISPLAY FOR MODE 1    30JUN77
;ADD @@RES MESSAGE TO MODE 1                        30JUN77
;ADD TRANSLATE TABLES AND BEEP FUNCTION             30JUN77
;CLEAN UP CRC CHECK ON MESSAGES MODE 0               1JUL77
;ADD POLL DELAY OF .2 SEC TO MODE 0                  1JUL77
;CLEAR LOOP BUSY FLAG                                1JUL77
;FIX TERMINAL CUMMUNICATION CODE                     4JUL77
;ADD ANSWERBACK AND MULTI BUFFER LOGIC               5JUL77
;FIX ANSWERBACK AND MULTI BUFFER LOGIC               5JUL77
;NEVER RESET BUFFER PTRS TO IMSG1 START (MODE 1)     5JUL77
;ONLY ANSWERBACK AFTER SEGMENT IS PRINTED            5JUL77
;ADD BAD CRC BUTTON TO MODE 0 AND 1 XMIT             6JUL77
;ADD INDIRECT LOOPBACK BUTTON   MODE 0               6JUL77
;SET POLL IDLE VALUE TO 5/10 SECOND                  6JUL77
;SET POLL TIMEOUT VALUE TO 2/10 SECOND               6JUL77
;COMPLEMENT THE LIGHTS                               7JUL77
;FIX CRC AND INDIRECT LOOPBACK SWITCH POLARITIES     7JUL77
;ADD POLLTIME SET CAPABILITY TO MODE 0              14JUL77
;ADD CANNED TEST MESSAGE TO MODE 0                  14JUL77
;ELIMINATE OLD BUTTON EQUATE USAGE                  14JUL77
;ADD INFORMATIVE COMMENTS                           14JUL77
;FIX INFORMATIVE COMMENTS                           15JUL77
;ADD MULTIPLE IA POLLING                            18JUL77
;CHANGE LOOP CONTROL IN ALLCLEAR FROM 32 TO 16      19JUL77
;FIX C1 C2 OF TEST MESSAGE MODE 0                    1AUG77
;GENERALIZE I/O ROUTINES FOR EXPANSION              12SEP77
;ADD TERMINAL CODE FOR MODE 0                       13SEP77
;SPLIT IMSG1 AND IBUF BUFFER USAGE                  13SEP77
;ADD UC1IA AND UC1TA                                19SEP77
;CLEAR UC1IA ON CANCEL                              19SEP77
;ALLOW GENERATION OF 000 FROM TERMINAL              19SEP77
;ADD ROOM FOR A8 MORE LEVELS IN ALL STACKS          20SEP77
;MOVE STACK SETUP INTO INDIVIDUAL INIT ROUTINES     20SEP77
;FIX MODE 1 STACK SETUP IN DDARP                    20SEP77
;ADD DCX H IN STERM1 CODE                           21SEP77
;ADD LF AFTER RECEIVED CR TO TERMINAL               21SEP77
;CLEAR UC1IA IN DDASP                               21SEP77
;PERMIT LF FROM TERMINAL IN MODE 0                  21SEP77
;CHANGE TRANSLATE TABLES FOR UNIFORMITY             27SEP77
;ADD 1024 BYTES TO TERMINAL BUFFER                  13OCT77
;INHIBIT POLL WHILE RECEIVING                       30JUN78
;ADD MONITOR AT 1800H                               12JUL78
;ADD INIT OF DL-1416 AND SUBROUTINE TO SET THEM     12JUL78
;REDUCE SIZE OF TERMINAL BUFFER                     12JUL78
;TURN OFF THE SONALERT ON RESET                     12JUL78


	ORG	0	
	
	DI			;PREVENT CLOCK INTERRUPT
	JMP	DDAINIT		;RESET ENTRYPOINT

	ORG	038H	
	JMP	CLOCK		;RESTART 7 (CLOCK INTERRUPT)

;	ENTERED AT ZERO AFTER RESET OR POWER-UP

DDAINIT	LXI	SP,LOOPS	;SET UP INITIAL STACK POINTER

;	INIT THE ALPHA DISPLAYS

	LXI	H,2C00H		;ADRS OF LEFT GROUP
	MVI	M,0CEH		;MOVE A CHAR
	INX	H		;MOVE LEFT A CHAR
	MVI	M,0D2H		;ADD ANOTHER CHAR
	INX	H		
	MVI	M,0CFH		;AND ANOTHER
	INX	H		;STEP TO NEXT CHAR
	MVI	M,0CDH		;ANOTHER
	LXI	H,2800H		;ADRS OF RIGHT GROUP
	MVI	M,0CEH		;STORE A CHAR **********
	MVI	M,0A0H		;PUT IN A BLANK
	INX	H		
	MVI	M,0A7H		;AN APPOSTROPHE
	INX	H		;BUMP
	MVI	M,0CEH		;A CHAR
	INX	H		;BUMP
	MVI	M,0C9H		;LAST CHAR
	XRA	A		;GET A ZERO
	STA	2800H		;CLEAR ANY CURSORS
	STA	2C00H		;ON BOTH DISPLAYS
	STA	2C00H		
	MVI	A,0BEH		;KILL SONALERT- TURN ON LIGHT
;				;AND SET FOR EXTERNAL CLOCK
	OUT	3CH		
	MVI	A,0FFH		;TURN OUT THE LEDS
	OUT	LIGHT0		
	MVI	A,MSABRE		
	OUT	US1C		;SET 3 USARTS TO SABRE SYNCHRONOUS
	OUT	US2C		
	OUT	US3C		
	XRA	A		;TELL ALL SABRE USARTS WHAT A
	OUT	US1C		;SABRE SYNC 1 WILL LOOK LIKE
	OUT	US2C		;TO THEM
	OUT	US3C		
	MVI	A,40Q		;SAME THING FOR SYNC 2
	OUT	US1C		
	OUT	US2C		
	OUT	US3C		
	MVI	A,MASCII		
	OUT	US0C		;SET OTHER USART TO ASCII ASYNC
	MVI	A,CASCII		
	OUT	US0C		;SET RTS- AND OTHER STUFF

;	TEST FOR MONITOR REQUEST (MODE 15)

	IN	THUMB		;READ THE THUMBWHEELS
	ANI	0F0H		;GET MODE DIGIT
	JZ	MONITOR		;JUMP IF MODE 15
	XRA	A		;CLEAR ACC
	STA	ABCOUNT		;CLEAR COUNT OF ANSWERBACKS TO SEND
	STA	US2XA		;CLEAR TRANSMIT ACTIVE FLAGS
	STA	US2XF		;AND MESSAGE READY FLAG
	STA	US1CMD		;CLEAR USART COMMANDS
	STA	US2CMD		
	STA	US3CMD		
	STA	CLKRT1		;CLEAR USART 1 RTS-CTS TIMER
	STA	US1PS		;CLEAR POLL SWITCH
	STA	US2TM		;CLEAR MSG-FROM-TERMINAL FLAG
	STA	US1LF		;CLEAR LOOPBACK BUSY FLAG
	STA	IMSGR1		;CLEAR MSG READY SWITCH
	STA	US1TIMER	;CLEAR POLL TIMER
	STA	US1RTSF		;CLEAR REQUEST-TO-SEND FLAG
	IN	THUMB		;GET THE THUMBWHEEL SWITCHES
	CMA			;FLIP THEM (ACTIVE LOW)
	ANI	HO4		;KEEP THE LEFT DECK
	JZ	DDASP		;JUMP TO SEND POLLS IF MODE 0
	CPI	10H		;ARE WE TO RESPOND TO POLLS ?
	JZ	DDARP		;YES
	CALL	ALLCLEAR	;GO CLEAR THE COUNTERS
	JMP	CPULOOP0		

;	MODE	0

;	WE ARE TO SEND POLLS- SET UP TO DO IT

DDASP	MVI	A,SABPOLL	;SET UP A COMMAND TO FIRE UP USART 1
	STA	US1CMD		;SAVE IT
	ORI	SYNC		;ADD HUNT MODE BIT
	OUT	US1C		;SLAP IT TO THE USART
	IN	US1D		;CLEAR POSSIBLE RX RDY STATUSI
	IN	US1D		
	MVI	A,ONE		
	STA	US1PS		;SET POLL SWITCH
	MVI	A,EIGHT		;SET UP DEFAULT RTS-CTS DELAY
	STA	US1RTS		
	IN	THUMB		;GET IA FROM THUMBWHEELS
	CMA			;THEY ARE ACTIVE LOW
	CALL	IAADJ		;ADJUST THE IA
	STA	IA		;SAVE THE IA
	STA	PIA		;SET UP POLLING IA CELL
	XRA	A		;CLEAR THE SECONDARY IA'S
	STA	IA2		
	STA	IA3		
	STA	STOPPER		;SET FLAG TO STOP POLL TABLE SEARCH
	STA	LPIA		;CLEAR LAST POLLED IA CELL
	STA	UC1IA		;CLEAR TERMINAL MONITOR IA
	STA	US1PLR		;CLEAR MSG RCVD FLAG
	LXI	H,IA		;SET UP POLL TABLE ADRS
	SHLD	PIAP		
	LXI	H,CPULOOP1	;GET VECTOR TO APPROPRIATE LOOP
	SHLD	CPR1X1		;SET USART 1 RETURN ADRS
	SHLD	CPX1X1		;SET USART 1 SEND RETURN ADRS
	SHLD	CPX0X2		;SET USART 0 SEND RETURN ADRS TWO
	SHLD	CPR0X1		;SET USART 0 RETURN ADRS
	LXI	H,CPUL1A		
	SHLD	CPX0X1		;SET USART 0 SEND RETURN ADRS
	LXI	H,IBUF		;GET THE TERMINAL BUFFER ADRS
	SHLD	US0RPTR		;SET UP USART 0 READ POINTER
	SHLD	US0WPTR		;SET UP USART 0 WRITE POINTER
	SHLD	US2RPTR		;SET UP USART 2(1) READ POINTER
	SHLD	SOMLOC		;ALSO SET UP SOM LOCATION
	MVI	M,0FFH		;PUT END-OF-DATA FLAG INTO BUFFER
	LXI	H,US0IDLE	;INIT USART 0 RECEIVE STACK
	SHLD	STACKRA		
	LXI	H,US0SEND	;INIT USART 0 SEND STACK
	SHLD	STACKXA		
	LXI	H,US1IDLE	;INIT USART 1 RECEIVE STACK
	SHLD	STACKRB		
	LXI	H,US1SEND	;INIT USART 1 SEND STACK
	SHLD	STACKXB		
	LXI	H,STACKRA		
	SHLD	US0RS		;SET UP STACK POINTER FOR USART 0 RX
	LXI	H,STACKXA		
	SHLD	US0XS		;SET UP STACK POINTER FOR USART 0 TX
	LXI	H,STACKRB		
	SHLD	US1RS		;SET UP STACK POINTER FOR USART 1 RX
	LXI	H,STACKXB		
	SHLD	US1XS		;SET UP STACK POINTER FOR USART 1 TX
	MVI	A,TWO		;INIT TA TO 2
	STA	TA		
	MVI	A,FIVE		
	STA	POLLTIME	;SET INIT POLL FREQ TO 2/SEC
	CALL	ALLCLEAR	;GO CLEAR ALL THE COUNTERS
	JMP	CPULOOP1	;GO TO CPULOOP FOR THIS FUNCTION

;	THIS IS THE INFAMOUS MODE 1
;	WE ARE TO RESPOND TO POLLING

DDARP	MVI	A,CSABRE+1	;SET USART RXEN TXEN AND DTR
	STA	US2CMD		;AND SAVE AS COMMAND
	ORI	SYNC		;ADD HUNT MODE BIT
	OUT	US2C		;FIRE UP THE USART
	IN	US2D		;USART MAY HAVE FALSE RX RDY STATUS
	IN	US2D		;THIS SHOULD CLEAR IT
	IN	THUMB		;GET THE THUMBWHEEL SWITCHES
	CMA			;TO GET THE IA TO USE
	CALL	IAADJ		;GO ADJUST THE IA
	STA	IA		;SET IA TO ACTUAL LINE VALUE
	MVI	A,TWO		;SET TA TO 02 FOR BEGINNING
	STA	TA		
	LXI	H,IBUF		;GET BUFFER ADRS
	SHLD	SOMLOC		;SET UP INITIAL START OF MSG
	SHLD	US0RPTR		;SET USART 0 READ POINTER
	SHLD	US2RPTR		;SET USART 2 READ POINTER
	SHLD	US0WPTR		;SET USART 0 WRITE POINTER
	MVI	M,0FFH		;INIT BUFFER
	LXI	H,CPULOOP2	;GET ADRS OF PROPER LOOP
	SHLD	CPR0X1		;SET USART 0 RCVR RETURN ADRS
	SHLD	CPR2X1		;SET USART 2 RCVR RETURN ADRS
	SHLD	CPX0X2		;SET USART 0 SEND RETURN TWO
	SHLD	CPX2X1		;SET USART 2 SEND RETURN ADRS
	LXI	H,CPUL2A	;GET USART 2 XMIT RETURN TWO
	SHLD	CPX2X2		;STORE IT
	LXI	H,CPUL2X	;GET USART 0 SEND RETURN TWO
	SHLD	CPX0X1		;STORE IT
	LXI	H,US0IDLE	;INIT USART 0 RECEIVER STACK
	SHLD	STACKRA	
	LXI	H,US0SEND	;INIT USART 0 TRANSMIT STACK
	SHLD	STACKXA	
	LXI	H,US2IDLE	;INIT USART 2 RECEIVER STACK
	SHLD	STACKRB	
	LXI	H,US2SEND	;INIT USART 2 TRANSMIT STACK
	SHLD	STACKXB	
	LXI	H,STACKRA	;SET UP STACK FOR USART 0 RX
	SHLD	US0RS	
	LXI	H,STACKXA	;SET UP STACK FOR USART 0 TX
	SHLD	US0XS	
	LXI	H,STACKRB	;SET UP STACK FOR USART 2 RX
	SHLD	US2RS	
	LXI	H,STACKXB	;SET UP STACK FOR USART 2 TX
	SHLD	US2XS	
	CALL	ALLCLEAR	;GO CLEAR ALL THE COUNTERS
	JMP	CPULOOP2	;GO TO CPU LOOP FOR THIS TASK

;	CPU LOOP READS USART STATUS AND CALLS ROUTINES
;	TO PROPERLY HANDLE THE SITUATIONS

CPULOOP0 JMP	CPULOOP0		

CPULOOP1 LXI	SP,LOOPS	;GET A STACK FOR THE LOOP
	IN	MISC		;GET MISC INPUT REGISTER
	RAR			;SEE IF CLOCK IS INTERRUPTING
	JC	CPUL1		;JUMP IF YES
	EI			;OTHERWISE ENABLE INTERRUPTS
CPUL1	IN	US1C		;GET USART STATUS
	RAR			;MOVE TX RDY TO CARRY FLAG
	JC	US1TXRDY	;JUMP IF READY
	RAR			;MOVE RX RDY TO CARRY FLAG
	JC	US1RXRDY	;JUMP IF A CHAR IN RECEIVER
	IN	US0C		;GET USART 0 STATUS
	RAR			
	RAR			;POSITION RCVR READY BIT IN CARRY
	JC	US0RXRDY	;GO HANDLE CHAR IF READY
	RAL			;GET THE TX READY BIT
	JC	US0TXRDY	;JUMP IF IT IS ALSO READY
CPUL1A	CALL	THUMBS		;DISPLAY COUNTERS
	JMP	CPULOOP1	;BACK TO THE TOP OF THE LOOP

CPULOOP2 LXI	SP,LOOPS	;GET A STACK FOR THE LOOP
	IN	MISC		;GET MISC INPUT REGISTER
	RAR			;SEE IF CLOCK IS INTERRUPTING
	JC	CPUL2		;JUMP IF YES
	EI			;OTHERWISE ENABLE INTERRUPTS
CPUL2	IN	US2C		;GET USART STATUS
	RAR			;MOVE TX RDY TO CARRY FLAG
	JC	US2TXRDY	;JUMP IF READY
CPUL2A	IN	US2C		;GET USART 2 STATUS AGAIN
	RAR			;SHIFT OFF TX RDY BIT
	RAR			;MOVE RX RDY BIT TO CARRY
	JC	US2RXRDY	;JUMP IF A CHAR IN RECEIVER
	IN	US0C		;GET ASYNC CONTROLLER STAT TOO
	RAR			
	RAR			;GET RCV RDY BIT
	JC	US0RXRDY	;JUMP IF READY
CPUS2	IN	US0C		;GET USART 0 STATUS AGAIN
	RAR			;GET TX RDY BIT
	JC	US0TXRDY	;GO SEE IF SOMETHING TO SEND
CPUL2X	CALL	THUMBS		;DISPLAY COUNTERS
	JMP	CPULOOP2	;BACK TO THE TOP OF THE LOOP

CPULOOP3 LXI	SP,LOOPS	;GET A STACK FOR THE LOOP
	IN	MISC		;GET MISC INPUT REGISTER
	RAR			;SEE IF CLOCK IS INTERRUPTING
	JC	CPUL3		;JUMP IF YES
	EI			;OTHERWISE ENABLE INTERRUPTS
CPUL3	IN	US3C		;GET USART STATUS
	RAR			;MOVE TX RDY TO CARRY FLAG
	JC	US3TXRDY	;JUMP IF READY
	RAR			;MOVE RX RDY BIT TO CARRY
	JC	US3RXRDY	;JUMP IF A CHAR IN RECEIVER
	CALL	THUMBS		;DISPLAY COUNTERS
	JMP	CPULOOP3	;BACK TO THE TOP OF THE LOOP

;	READ THE THUMBWHEELS TO SELECT A COUNTER
;	FOR DISPLAY

THUMBS	IN	THUMB		;GET THE THUMBWHEEL SWITCHES
	CMA			;THEY ARE ACTIVE LOW
	ANI	0FH		;GET COUNTER NBR
	MOV	B,A		;SAVE IN B
	CPI	TWO		;SEE IF IA OR TA DISPLAY REQUEST
	JC	BGIATA		;JUMP IF YES
	MOV	A,B		;GET THE COUNTER STUFF BACK
	LXI	H,COUNTS	;GET COUNTER ADDRESSES
	ADD	L		
	MOV	L,A		;ADD SWITCHES TO ADRS
	MOV	A,M		;GET THE COUNTER
	CMA			;FLIP THE BITS
	OUT	LIGHT0		;PUT IT UP IN LIGHTS
	SHLD	PCOUNT		;SAVE PRESENT COUNTER ADRS
; LOOK FOR PUSHBUTTON COMMANDS FROM CE
BUTTON	IN	BUTTONS		;GET THE BUTTON REGISTER
	ANI	0FH		;SEE IF LOW ORDER 4 BITS ARE OFF
	JZ	SETSECIA	;GO SET SECONDARY IA IF OFF (ON)
	IN	BUTTONS		;GET THE BUTTON REGISTER
	CMA			;THE ARE ACTIVE LOW
	RAL			;IS THE CLEAR BUTTON DEPRESSED ?
	RNC			;RETURN IF NOT
	RAL			;SEE IF TOP TWO BUTTONS BOTH ON
	JC	BUTTSP		;IF YES, GO SET POLL IDLE TIMER
	MVI	M,ZIP		;CLEAR THE SELECTED COUNT
	RET			;AND RETURN

BUTTSP	IN	THUMB		;GET THE THUMBWHEEL SWITCH SETTINGS
	CMA			;FLIP THEM
	JNZ	BUTTNZ		;JUMP IF NOT ZERO TIME
	INR	A		;IF ZERO CHANGE TO ONE
BUTTNZ	STA	POLLTIME	;AND SET THE POLL IDLE TIMER
	RET			;DONE

SETSECIA IN	THUMB		;GET THE THUMBWHEEL SWITCHES
	CMA			;THEY ARE ACTIVE LOW
	MOV	B,A		;SAVE THEM IN B
	CALL	IAADJ		;ADJUST TO ACTUAL LINE VALUE
	STA	IA2		;SAVE THE SECONDARY IA
	MOV	A,B		;GET THE THUMBWHEELS BACK
	RRC			;POSITION HIGH ORDER 4
	RRC			;BITS FOR IAADJ
	RRC			
	RRC			
	CALL	IAADJ		;ADJUST TO IA VALUE
	STA	IA3		;SAVE THE SECONDARY IA
	RET			;RETURN

;	CLEAR ALL OF THE COUNTERS
;	THIS HAPPENS AT RESET AND UPON PUSHBUTTON COMMAND

ALLCLEAR LXI	H,COUNTS	;BEGINNING OF COUNTS AREA
	XRA	A		;CLEAR ACCUM
	MVI	C,16		;SET LIMIT COUNTER
ACLEAR	MOV	M,A		;CLEAR A BYTE
	INX	H		;BUMP POINTER
	DCR	C		;DECR COUNT
	JNZ	ACLEAR		;LOOP UNTIL ALL COUNTS CLEARED
	RET			

BGIATA	LXI	H,IA		;POINT TO IA
	ADD	L		;ADD A TO POINTER
	MOV	L,A		
	MOV	A,M		;GET THE IA OR TA
	CMA			;FLIP THE BITS
	OUT	LIGHT0		;DISPLAY IT
	LXI	H,COUNTS	;POINT OUT INTO SPACE
	JMP	BUTTON		;CONTINUE

;	USART 0 ASYNC ASCII CONTROLLER

US0RXRDY DI			;PREVENT CLOCK INTERRUPT
	LHLD	US0RS		;GET THE RECEIVER STACK
	SPHL			;PUT INTO STACK POINTER
	RET			;ENTER THE PROCESSING CODE

GUS0X	LXI	H,ZIP		;CLEAR HL REGISTER PAIR
	DAD	SP		;GET THE STACK POINTER
	SHLD	US0RS		;SAVE THE ROUTINE'S STACK
RS0X	LHLD	CPR0X1		;GET CPULOOP RETURN ADRS
	PCHL			;GO TO IT

;	USART 1 POLLING SABRE CONTROLLER

US1RXRDY DI			;PREVENT CLOCK INTERRUPT
	LHLD	US1RS		;GET RECEIVER STACK
	SPHL			;PLACE INTO THE STACK POINTER
	RET			;GO TO THE PROCESSOR

GUS1X	LXI	H,ZIP		;CLEAR HL REGISTER PAIR
	DAD	SP		;GET THE STACK
	SHLD	US1RS		;SAVE THE ROUTINE'S STACK
	LHLD	CPR1X1		;GET CPULOOP RETURN ADRS
	PCHL			;GO TO IT

;	USART 2 MONITOR FOR SABRE

US2RXRDY DI			;DISABLE CLOCK
	LHLD	US2RS		;GET THE RECEIVER'S STACK
	SPHL			;RESTORE TOE THE STACK POINTER
	RET			;GO TO THE HANDLING ROUTINE

GUS2X	LXI	H,ZIP		;CLEAR THE HL PAIR
	DAD	SP		;GET THE STACK POINTER
	SHLD	US2RS		;SAVE THE ROUTINE'S STACK
	LHLD	CPR2X1		;GET THE CPULOOP RETURN ADRS
	PCHL			;RETURN TO CPU LOOP

;	USART 3 IN-SERVICE TI MONITOR

US3RXRDY DI			;PREVENT CLOCK FROM INTERRUPTING
	LHLD	US3RS		;GET THE RECEIVER'S STACK
	SPHL			;RESTORE IT
	RET			;BACK TO THE RECEIVER ROUTINE

GUS3X	LXI	H,ZIP		;CLEAR HL PAIR
	DAD	SP		;GET THE RECEIVER'S CURRENT STACK
	SHLD	US3RS		;SAVE IT FOR NEXT TIME
	LHLD	CPR3X1		;CONTINUE AT THE CPULOOP
	PCHL			

;	USART 0 ASYNC ASCII TRANSMITTER

US0TXRDY LHLD	US0RPTR		;GET BUFFER POINTER
	MOV	A,M		;GET THE CHAR TO BE SENT
	CPI	0FFH		;IS IT DATA OR END-OF-BUFFER ?
	JZ	XS0XA		;EXIT IF END-OF-STUFF FLAG
	DI			;LOCK OUT THE CLOCK
	LHLD	US0XS		;GET THE XMTR STACK
	SPHL			;RESTORE IT
	RET			;GO TO THE XMTR ROUTINE

XS0X	LXI	H,ZIP		;CLEAR HL
	DAD	SP		;GET CURRENT STACK POINTER
	SHLD	US0XS		;SAVE IT FOR NEXT TIME
XS0XA	LHLD	CPX0X1		;EXIT TO CPU LOOP
	PCHL			

;	USART 1 POLLING SABRE CONTROLLER

US1TXRDY DI			;STOP CLOCK INTERRUPTS
	LXI	H,US1CMD	;GET ADRS OF COMMAND STORAGE
	LDA	RSYN1		;GET RESYNC SWITCH
	ORA	A		;TEST IT FOR ZERO
	JZ	NRSYN1		;JUMP IF NOT TO RESYNC
	ORA	M		;COMBINE RESYNC SW WITH COMMAND
	OUT	US1C		;GIVE IT TO USART
	IN	US1D		;USART MAY HAVE FALSE RX RDY STATUS
	IN	US1D		;SO READ TWO CHARS TO CLEAR IT
	XRA	A		;ZERO THE RESYNC SWITCH
	STA	RSYN1		
	JMP	NRSYN1A		;GO SEND A CHAR IF DESIRED

NRSYN1	MOV	A,M		;GET THE COMMAND FOR USART
	OUT	US1C		;WRITE IT
NRSYN1A	LHLD	US1XS		;GET THE STACK FOR THIS XMTR
	SPHL			;RESTORE IT
	RET			;GO THE THE XMTR ROUTINE

XS1X	LXI	H,ZIP		;CLEAR HL
	DAD	SP		;GET TRANSMITTER'S STACK
	SHLD	US1XS		;SAVE IT
	LHLD	CPX1X1		;RETURN TO CONTROL LOOP
	PCHL			

;	USART 2 SABRE MONITOR

US2TXRDY LXI	H,US2CMD	;GET USART COMMAND BYTE
	LDA	RSYN2		;GET RESYNC FLAG
	ORA	A		;TEST IT FOR ZERO
	JZ	NRSYN2		;JUMP IF NOT TO RESYNC
	ORA	M		;COMBINE RESYNC SW WITH COMMAND
	OUT	US2C		;GIVE IT TO USART
	IN	US2D		;USART MAY HAVE FALSE RX RDY STATUS
	IN	US2D		;SO READ TWO CHARS TO CLEAR IT
	XRA	A		;ZERO THE RESYNC SWITCH
	STA	RSYN2		
	JMP	NRSYN2A		;GO SEND A CHAR IF DESIRED

NRSYN2	MOV	A,M		;GET COMMAND FOR USART
	OUT	US2C		;WRITE IT
NRSYN2A	LDA	US2XA		;GET TRANSMIT ACTIVE FLAG
	ORA	A		;IS IT ACTIVE ? (NONZERO IS ACTIVE)
	JZ	XS2XA		;JUMP TO CPULOOP IF NOT ACTIVE
	DI			;PREVENT CLOCK INTERRUPTS
	LHLD	US2XS		;GET THE STACK FOR THIS GUY
	SPHL			;RESTORE IT
	RET			;RETURN TO TRAMSMITTER PROCESSOR

XS2X	LXI	H,ZIP		;CLEAR HL PAIR
	DAD	SP		;GET THE TRANSMIT STACK
	SHLD	US2XS		;SAVE IT FOR NEXT TIME
	LHLD	CPX2X1		;RETURN TO CPULOOP
	PCHL			

XS2XA	LHLD	CPX2X2		;RETURN TO CPULOOP
	PCHL			

;	USART 3 TI MONITOR

US3TXRDY DI			;DON'T ALLOW CLOCK INTERRUPTS
	LXI	H,US3CMD	;GET ADRS OF COMMAND STORAGE
	LDA	RSYN3		;GET RESYNC SWITCH
	ORA	A		;TEST IT FOR ZERO
	JZ	NRSYN3		;JUMP IF NOT TO RESYNC
	ORA	M		;COMBINE RESYNC SW WITH COMMAND
	OUT	US3C		;GIVE IT TO USART
	IN	US3D		;USART MAY HAVE FALSE RX RDY STATUS
	IN	US3D		;SO READ TWO CHARS TO CLEAR IT
	XRA	A		;ZERO THE RESYNC SWITCH
	STA	RSYN3		
	JMP	NRSYN3A		;GO SEND A CHAR IF DESIRED

NRSYN3	MOV	A,M		;GET COMMAND FOR USART
	OUT	US3C		;WRITE IT
NRSYN3A	LHLD	US3XS		;GET THE OLD STACK FOR XMTR
	SPHL			;RESTORE IT
	RET			;CONTINUE WITH XMTR PROCESSING

XS3X	LXI	H,ZIP		;CLEAR HL PAIR
	DAD	SP		;GET THE TRANSMITTER'S STACK
	SHLD	US3XS		;SAVE IT FOR NEXT TIME
	LHLD	CPX3X1		
	PCHL			

;	USART 0

US0IDLE	DCX	SP		;BACK OFF STACK POINTER 2 BYTES
	DCX	SP		
	CALL	US0RCVA		;GET THE DATA
	MOV	B,A		;SAVE CHAR IN B
	CPI	CONTX		;SEE IF RESET (CONTROL-X)
	JZ	US0CAN		;JUMP TO CANCEL CURRENT MSG
	CALL	ASC2SAB		;GET THE SABRE EQUIVALENT
	ORA	A		;DOES ONE EXIST ?
	JZ	US0BEEP		;BEEP IF NOT
	MOV	A,B		;RESTORE THE CHAR TO A
	CPI	LF		;IS IT A LINEFEED ?
	JNZ	US0SOK		;JUMP IF NOT
	ORI	HOBIT		;SET HIGH-ORDER BIT TO KEEP IT
US0SOK	LHLD	US0WPTR		;GET TERMINAL BUFFER WRITE PTR
US0ILOOP MOV	M,A		;STORE THE CHAR
	CALL	IBUFWRAP	;ADVANCE THE POINTER
	SHLD	US0WPTR		;STORE NEXT WRITE POINTER
	MVI	M,0FFH		;FLAG END OF STORED-STUFF
	CPI	CR		;WAS IT A CARRIAGE RETURN ?
	JNZ	RS0X		;JUMP IF NOT
	MVI	A,LF		;OTHERWISE DO LINEFEED TOO
	JMP	US0ILOOP	;GO STORE LINEFEED

US0BEEP	MVI	A,07		;REPLACE CHAR WITH BELL CODE
	JMP	US0SOK		;GO STORE IT IN BUFFER

US0CAN	LHLD	US0WPTR		;GET CURRENT BUFFER POINTER
	CALL	IBUFWRAP	;BUMP THE HL POINTER
	CALL	IBUFWRAP	;BY TWO TO SKIP CR AND LF
	SHLD	SOMLOC		;SET NEXT ADRS INTO SOM LOCATION
	XRA	A		;CLEAR THE TERMINAL IA
	STA	UC1IA		;ON CANCEL
	MVI	A,CR		;REPLACE CANCEL WITH CR
	JMP	US0SOK		;GO DISPLAY CR AND LF

;	USART 1	RECEIVER FOR WHEN WE ARE POLLING (MODE 0)

US1IDLE	DCX	SP		;DON'T DESTROY IDLE ROUTINE ADRS
	DCX	SP		
US1RCVR	LDA	US1CMD		;GET THE USART COMMAND
	ANI	CTS		;SEE IF CTS IS SET
	JZ	US1NOCTS	;ERROR IF NOT
	MVI	A,0FFH		;GET ALL BITS
	STA	US1PLR		;SET MSG RECV FLAG
US1RNCTS MVI	C,ZIP		;CLEAR CRC TO ZERO
	CALL	US1RCVA		;GO GET A CHAR
US1TGA	CPI	SGA		;IS IS A POLL RESPONSE ?
	JZ	US1POLLR	;JUMP IF YES
;	POSSIBLY AN INPUT MESSAGE
	LDA	UC1IA		;GET THE TERMINAL IA USED
	ORA	A		;IS THERE ONE ?
	JZ	US1NUC		;JUMP IF NO
	CMP	B		;IS IT WHAT WE RECEIVED ?
	JZ	US1UCM		;JUMP IF YES
US1NUC	ORA	B		;SEE IF ZERO (BAD TROUBLE)
	JZ	US1BIA		;JUMP IF BAD
	CPI	18H		;SEE IF WITHIN IA RANGE
	JNC	US1BIA		;JUMP IF BAD IA
	ANI	08		;CHK FOR ILLEGAL BIT ON
	JNZ	US1BIA		;ERROR IF ON
	LDA	PIA		;NOW THAT WE HAVE SPENT SO MUCH TIME
	CMP	B		;FINDING OUT IT IS A GOOD IA
	JNZ	US1BIA		;ERROR IF NOT EXPECTED IA
	LDA	US1LF		;GET LOOP READY FLAG
	ORA	A		;SEE IF ALREADY BUSY
	JNZ	US1NLP		;JUMP IF BUSY
	MVI	A,ONE		;SET LOOP FLAG TO INDICATE BUSY
	STA	US1LF		
	LXI	H,IMSG1		;GET BUFFER ADRS
US1HL	MOV	M,B		;SAVE IA
	INX	H		;BUMP POINTER
	CALL	US1RCV		;GET THE TA
	MOV	M,A		;SAVE IT
	RAR			;SEE IF IT IS ODD/EVEN
	JC	US1BTA		;ERROR IF ODD
US1HLA	LDA	US1MRC		;GET MSG RCVD COUNTER
	INR	A		;BUMP COUNTER
	STA	US1MRC		;STORE IT
US1RLOOP INX	H		;ADVANCE POINTER
	XCHG			;SAVE HL INTO DE
	LXI	H,-IMSGEND1	;GET NEGATIVE OF END ADRS
	DAD	D		;ADD CURRENT ADRS
	XCHG			;RESTORE HL
	JC	US1WRAP		;JUMP IF AT THE END
	CALL	US1RCV		;GET INPUT CHAR
	MOV	M,A		;STORE IT
	ORA	A		;TEST FOR ZERO
	JZ	US1BUST		;JUMP IF BUST
	CPI	SYNC1		;TEST FOR SYNC PATTERN
	JZ	US1BUST		;A BUST IF YES
	ANI	SGA		;KEEP LOW ORDER 4 BITS
	CPI	SEOM		;IS IT ONE OF THE EOMS ?
	JZ	US1REOM		;JUMP IF YES
	JMP	US1RLOOP	;CONTINUE IF STILL ROOM

US1WRAP	DCX	H		;BACK THE POINTER OFF OF THE END
SEOMXE	MVI	C,ONE		;SET EARLY STOP FLAG
SEOMX	MVI	M,EOMC		;MAKE SURE EOM IS EOMC
	XCHG			;TEMPORARILY SAVE HL INTO DE
	LXI	H,-IMSGR1	;GET NEGATIVE OF BYTE BEFORE BUFFER
	DAD	D		;ADD WHERE WE ENDED UP
	XCHG			;RESTORE HL
	JNC	US1FLOOP	;JUMP IF NOT IN RAM BUFFER
	SHLD	IMSGEND1	;SAVE END ADRS OF MSG
	MVI	A,ONE		
	STA	IMSGR1		;TELL XMTR THE MSG IS IN
	MOV	A,C		;GET THE CRC OR EARLY FLAG
	ORA	A		;DID WE COMPLETE PROPERLY ?
	JNZ	US1EX1		;JUMP IF NO- DON'T COUNT POLL RESP
US1FLOOP CALL	US1RCV		;GET CHAR AFTER CRC
	ORA	A		;IS IT ZERO ? (AN ERROR)
	JZ	US1NGA		;YES- GO COUNT THE PROBLEM
	CPI	SYNC1		;IS IT THE START OF A SYNC PATTERN ?
	JZ	US1FLOP		;DROP IT IF YES- WAIT FOR SYNC2
	JMP	US1TGA		;GO SEE IF IT IS A GA OR IA

US1FLOP	CALL	US1RCV		;GET THE NEXT CHAR
	CPI	SYNC1		;IS IT ANOTHER SYNC1 ?
	JZ	US1FLOP		;FLUSH IT IF IT IS
	CPI	SYNC2		;IS IT A SYNC 2 ?
	JZ	US1RNCTS	;IF SO GO READ NEXT MSG
US1NGA	LXI	H,US1NGAC	;POINT TO NO GOAHEAD COUNTER
	INR	M		;COUNT IT
	JMP	US1RESYN	;LOOK FOR ANOTHER TRANSMISSION

US1REOM	CALL	US1RCV		;RECEIVE THE CRC
	MOV	A,C		;GET THE RESULT
	ORA	A		;ZERO ?
	JZ	SEOMX		;GOOD IF YES
	XCHG			;SAVE HL INTO DE
	LXI	H,CRCE1		
	INR	M		;BUMP CRC ERROR COUNTER
	XCHG			;RESTORE BUFFER POINTER FROM DE
	JMP	SEOMX		;PROCESS THE MSG ANYWAY

US1BUST	LXI	H,US1BUSTC		
	INR	M		;COUNT THE BUSTED MSG
	JMP	US1RESYN	;GO LOOK FOR SYNC

US1NLP	LXI	H,1000H		;POINT BUFFER POINTER INTO PROM
	JMP	US1HL		

US1NOCTS LXI	H,US1NCTSC	;GET POINTER TO COUNTER
	INR	M		;COUNT XMIT WITHOUT CTS
	JMP	US1RNCTS	;CONTINUE AS IF NOTHING HAPPENED

;	MESSAGE MAY BE FROM MONITORED IA TA

US1UCM	CALL	US1RCV		;READ THE TA
	LXI	H,1000H		;POINT THE STORE POINTER INTO ROM
	LDA	UC1TA		
	CMP	B		;IS THIS THE PROPER TA ?
	JNZ	US1HLA		;REJOIN OLD CODE IF NOT
	LHLD	US0WPTR		;GET THE USART 0 WRITE POINTER
US1UCLOO CALL	US1RCV		;GET A CHAR OF MSG
	CALL	SAB2ASC		;TRANSLATE IT INTO ASCII
	CPI	80H		;IS IT AN EOM ?
	JNC	US1UEOM		;JUMP IF YES
US1UCLP	MOV	M,A		;STORE IT IF NOT
	CALL	IBUFWRAP	;ADVANCE THE STORE POINTER
	CPI	CR		;WAS THE CHAR A CR ?
	JNZ	US1UCNL		;JUMP IF NOT
	MVI	A,LF		;ADD LINEFEED AFTER CARRIAGE RETURN
	JMP	US1UCLP		;GO STORE IT

US1UCNL	MVI	M,0FFH		;PUT END-OF-STUFF FLAG IN BUFFER
	SHLD	US0WPTR		;STORE THE UPDATED POINTER
	JMP	US1UCLOO	;GO GET MORE CHARS

;	AN EOM WAS RECEIVED

US1UEOM	MVI	M,'*'		;PUT ASTERISK INTO BUFFER
	CALL	IBUFWRAP	;BUMP THE POINTER
	ANI	03		;KEEP BOTTOM TWO BITS OF THE EOM
	ADI	'A'		;ADD TO 'A'
;	THIS MAKES EOM A, B, C OR D FOR EOMS P, I, C OR U
	MOV	M,A		;STORE EOM INDICATOR INTO BUFFER
	CALL	IBUFWRAP	;BUMP THE POINTER
	MVI	M,0FFH		;SET END-OF-STUFF FLAG
	CALL	US1RCV		;READ THE CRC CHAR
	CALL	SAB2ASC		;TRANSLATE INTO ASCII
	MOV	M,A		;STORE IT
	CALL	IBUFWRAP	;ADVANCE STORE POINTER AGAIN
	MVI	A,'*'		;GET AN ASTERISK
	ADD	C		;DESTROY THE * IF CRC WAS BAD
	MOV	M,A		;STORE * OR GARBAGE
	CALL	IBUFWRAP	;ADVANCE POINTER AGAIN
	SHLD	US0WPTR		;SAVE THE UPDATED POINTER
	MVI	M,0FFH		;FLAG END-OF-DATA
	JMP	US1FLOOP	;LOOK FOR NEXT MSG

;	RECEIVING A RESPONSE TO OUR POLL

US1POLLR CALL	US1RCV		;READ THE IA
	CPI	CO67		;IS IT OK ?
	JNZ	US1BPIA		;JUMP IF NO
US1PRCX	LXI	H,US1PRC	;COUNT THE POLL RESPONSE
	INR	M		
;	FORCE THE USART TO RESYNC
US1RESYN XRA	A		;CLEAR A
	STA	US1PLR		;CLEAR MSG RCV FLAG
	CALL	US1RCV		;MAKE SURE WE HAVEN'T JUST READ CRC
	LXI	H,RSYN1		;GET USART RESYNC SWITCH ADRS
	MVI	M,SYNC		;SET THE ENTER HUNT MODE BIT
	LDA	POLLTIME	;GET POLL IDLE TIMER VALUE
	STA	US1TIMER	;SET IT
	LXI	H,US1FUNC		
	MVI	M,ONE		;SET THE POLL FUNCTION FLAG
	LHLD	PIAP		;GET POLLED IA POINTER
	MOV	A,M		;GET THE IA
	STA	LPIA		;SAVE IT AS LAST IA POLLED
	DCX	H		;BACK HL UP TO NEXT IA TO POLL
	MOV	A,M		;GET IT
	ORA	A		;IS IT ZERO ?
	JZ	PIAW		;JUMP TO WRAP TABLE IF YES
PIAN	STA	PIA		;SAVE IT FOR TRANSMITTER
	SHLD	PIAP		;SAVE THE NEW POINTER
	JMP	GUS1X		;EXIT

PIAW	LXI	H,IA		;GET THE ADRS OF FIRST IA IN TABLE
	MOV	A,M		;GET THE FIRST GUY
	JMP	PIAN		;GO STORE HIM

US1BPIA	LXI	H,US1BPC		
	INR	M		;BUMP COUNTER OF BAD IA ON POLLR
	JMP	US1RESYN	;RESYNC

US1BIA	LXI	H,US1BIAC		
	INR	M		;COUNT INVALID IA'S
US1EX1	XRA	A		
	STA	US1LF		;CLEAR THE LOOP BUSY FLAG
	JMP	US1RESYN		

US1BTA	LXI	H,US1BTAC		
	INR	M		;COUNT BAD TA'S
	JMP	US1RESYN		

;	RECEIVER FOR WHEN WE ARE RESPONDING TO POLLS (MODE 1)

US2IDLE	DCX	SP		
	DCX	SP		
	IN	MISC		;GET CLOCK AND OTHER STUFF
	RAR			;GET CLOCK STATUS INTO CARRY
	JC	US2CLKIR	;JUMP IF CLOCK IS INTERRUPTING
	EI			;ENABLE INTERRUPTS SO IT CAN
US2CLKIR EQU	$		
US2RCVR	MVI	C,ZIP		;CLEAR THE CRC
	CALL	US2RCVA		;GET A CHAR
	CPI	SGA		;IS IT A GO-AHEAD ?
	JZ	US2RGA		;JUMP IF YES
	LDA	IA		;GET OUR IA
	CMP	B		;DO THEY MATCH ?
	JZ	US2RIA		;JUMP IF YES
;	RESYNC THE USART
US2RSYNC CALL	US2RCV		;READ ONE MORE CHAR
	LXI	H,RSYN2		;POINT TO RESYNC FLAG
	MVI	M,SYNC		;SET HUNT MODE FLAG
	JMP	GUS2X		;EXIT

;	WE RECEIVED A GO-AHEAD

US2RGA	CALL	US2RCV		;GET IA FROM POLL
	LDA	IA		;GET OUR IA
	CMP	B		;IS THIS POLL TO US ?
	JNZ	US2RSYNC	;RESYNC IF NOT
;	POLL IS FOR US - VERIFY EOM AND CRC
	CALL	US2RCV		;READ THE EOM
	CPI	EOMC		;IS IT AN EOMC ?
	JNZ	US2BPE		;JUMP IF NO
	CALL	US2RCV		;READ THE CRC
	MOV	A,C		;GET THE NEW RESULT
	ORA	A		;TEST FOR A ZERO RESULT
	JNZ	US2BPC		;IF NONZERO IS BAD CRC
;	VALID POLL HAS BEEN RECEIVED
	INR	A		;GET A NON-ZERO ACCUM
	STA	US2XA		;ENABLE THE TRANSMITTER
	LDA	US2CMD		;GET THE CURRENT USART COMMAND
	ORI	RTSTXEN		;ADD RTS AND TX ENABLE
	STA	US2CMD		;SAVE NEW COMMAND
	LXI	H,US2POLC	;POINT TO COUNTER OF POLLS RCVD
	INR	M		;BUMP IT
	LDA	US2MSTAT	;GET MSG STATUS-AT-A-GLANCE
	XRI	PLITE		;BLINK POLL-RECEIVED LIGHT
	STA	US2MSTAT		
	JMP	US2RSYNC	;LOOK FOR NEXT POLL

;	A MESSAGE IS COMING FOR US

US2RIA	CALL	US2RCV		;READ THE TA
	RAR			;SEE IF LOW ORDER BIT IS ON
	JC	US2BTA		;IF SO IT HAS A BAD TA
	LDA	TA		;GET THE TA
	CMP	B		;DOES IT MATCH WHAT WE GOT
	JNZ	US2WMCA		;NO- GO COUNT WRONG TA
	LXI	H,US2MSC	;COUNT MSGS RECEIVED
	INR	M		
	LDA	US2MSTAT	;GET STATUS DISPLAY
	ORI	MLITE		;SET MSG RCVD LIGHT
	STA	US2MSTAT		
	LDA	US2TM		;SEE IF WE HAVE SENT A TERM MSG
	ORA	A		;IF ZERO, WE HAVEN'T
	JNZ	US2TMSG		;JUMP IF THIS IS RESPONSE TO ONE
	CALL	US2RCV		;READ THE C1 CHAR
	CPI	S1		;IS IT ERASE/WRITE ?
	JZ	US2EW		;JUMP IF YES
	CPI	S9		;IS IT UNSOLICITED MSG LIGHT ?
	JZ	US2UMSG		;JUMP IF YES
	CPI	SNOP		;IS IT WRITE/CONTINUE ?
	JZ	US2WC		;JUMP IF YES
	LXI	H,US2BC1C		
	INR	M		;COUNT THE BAD C1 CHAR
	JMP	US2RSYNC	;RESYNC TO FIND NEXT ONE

US2WMCA	LXI	H,US2WMC		
	INR	M		;COUNT THE MSG TO WRONG TA
	LDA	US2MSTAT	;GET STATUS DISPLAY BYTE
	ORI	WTLITE		;SET WRONG-TA INDICATION
	STA	US2MSTAT		
	JMP	US2RSYNC	;LOOK FOR ANOTHER MSG

;	COMMAND WAS AN ERASE/WRITE

US2EW	LDA	US2MSTAT	;GET STATUS DISPLAY
	ORI	EWLITE		;SET ERASE/WRITE STATUS INDICATION
	STA	US2MSTAT	;SAVE NEW STATUS
	CALL	US2RCV		;READ C2 CHAR
US2EW0	LXI	D,345		;ALLOW FOR 345 DATA CHARS
US2EW1	CALL	US2RCV		;READ A CHAR
	ORA	A		;IS IT ZERO ?
	JZ	US2BUST		;JUMP IF YES- IT IS BUSTED
	CPI	SYNC1		;IS IT SYNC 1 ?
	JZ	US2BUST		;IF SO IS ALSO BUSTED
	CALL	SAB2ASC		;TRANSLATE TO ASCII
	CPI	80H		;IS IT ONE OF THE EOMS ?
	JNC	US2EOM		;JUMP IF YES
	DCX	D		;DECREMENT CHAR COUNTER
	MOV	A,D		
	ORA	E		;DID COUNT GO TO ZERO ?
	JNZ	US2EW1		;LOOP IF NOT YET
;	LOST AN EOM SOMEWHERE
US2BUST	LXI	H,US2BUSTC		
	INR	M		;COUNT THE BUST
	LDA	US2MSTAT	;GET STATUS DISPLAY
	ORI	BULITE		;SET BUSTED MSG INDICATOR
	STA	US2MSTAT		
	JMP	US2RSYNC	;LOOK FOR NEXT MSG

;	A POLL TO US HAD NO EOMC IN IT

US2BPE	LXI	H,US2BPEC		
	INR	M		;COUNT BAD EOM ON POLL
	JMP	US2RSYNC	;LOOK FOR MORE GARBAGE

;	A POLL TO US HAD A BAD CRC

US2BPC	LXI	H,US2BPCC	;COUNT CRC ERROR ON POLL
	INR	M		
	JMP	US2RSYNC	;LOOK FOR ANOTHER ONE

;	TA RECEIVED WAS ODD AND THEREFORE BAD

US2BTA	LXI	H,US2BTAC		
	INR	M		;COUNT ODD TA
	LDA	US2MSTAT	;GET STATUS DISPLAY
	ORI	BTLITE		;SET ODD TA INDICATION
	STA	US2MSTAT		
	JMP	US2RSYNC	;LOOK FOR ANOTHER MSG/POLL

;	MSG RECEIVED IS COMPLETE, CHECK CRC

US2EOM	MOV	D,A		;SAVE THE EOM
	CALL	US2RCV		;READ THE CRC
	MOV	A,C		;GET THE RESULT
	ORA	A		;IS IT ZERO ? (GOOD IS ZERO)
	JZ	US2RSYNC	;IF GOOD, GO LOOK FOR ANOTHER MSG
;	CRC ERROR ON THE RECEIVED MSG
US2CRCE	LXI	H,US2BMCC	;POINT TO COUNTER OF BAD CRC'S
	INR	M		;COUNT THE CRC ERROR
	LDA	US2MSTAT	;GET THE STATUS DISPLAY
	ORI	CLITE		;SET THE BAD CRC INDICATION
	STA	US2MSTAT	;STORE NEW INDICATORS
	JMP	US2RSYNC	;LOOK FOR SYNC

;	C1 IS SABRE 9 (LIGHTS MSG)

US2UMSG	LXI	H,US2UMSGC	;GET UMSG COUNTER ADRS
	LXI	D,0004		;NOT MANY CHARS IN ONE OF THESE
	JMP	US2EW1		;MERGE WITH ERASE/WRITE CODE

;	C1 IS SABRE NOP (WRITE CONTINUE)

US2WC	LDA	US2MSTAT	;GET THE STATUS DISPLAY BYTE
	ORI	WCLITE		;SET WRITE CONTINUE LIGHT ON
	STA	US2MSTAT		
	JMP	US2EW0		;GO LOOK FOR EOM

US2TMSG	LHLD	US0WPTR		;GET WRITE PTR FOR BUFFER
	MVI	M,0FFH		;INSTALL A STOP IN THE BUFFER
US2TML	CALL	US2RCV		;GO GET A CHAR OF THE MSG
	ORA	A		;WAS IT ZERO ?
	JZ	US2BUST		;IF YES IT IS BAD STUFF
	CPI	SYNC1		;IS IT SYNC ONE ?
	JZ	US2BUST		;IF SO IT IS MORE BAD STUFF
	MOV	A,B		;GET THE CHAR BACK
	CALL	SAB2ASC		;TRANSLATE INTO ASCII
SENLF	MOV	M,A		;STORE IT INTO THE BUFFER
	CALL	IBUFWRAP	;ADVANCE THE STORE POINTER
	SHLD	US0WPTR		;SAVE UPDATED POINTER
	SHLD	SOMLOC		;ALSO ADVANCE START-OF-MSG LOC
	MVI	M,0FFH		;SET END OF BUFFER FLAG
	CPI	80H		;IS IT ONE OF THE EOMS ?
	JNC	US2EOM		;JUMP IF YES
	CPI	CR		;WAS THE CHAR A CR ?
	JNZ	US2TML		;NO GO LOOK FOR MORE CHARS
	MVI	A,LF		;INSERT A LINEFEED AFTER CR
	JMP	SENLF		;GO STORE IT

;	ASCII TERMINAL HANDLER (TRANSMIT SIDE) USART 0

US0SEND	DCX	SP		;BACK OFF THE STACK
	DCX	SP		;BY TWO BYTES
	LHLD	US0RPTR		;GET READ POINTER
	MOV	A,M		;GET CHAR FROM BUFFER
	CPI	ENTER		;IS IT ENTER ?
	JZ	US0ENTER	;JUMP IF YES
	CPI	80H		;IS IT ONE OF THE EOMS ?
	JNC	US0EOM		;JUMP IF YES
US0NEOM	OUT	US0D		;ECHO THE CHAR TO THE TERMINAL
US0SW	CALL	IBUFWRAP	;BUMP POINTER
	SHLD	US0RPTR		;SAVE IT
	LHLD	CPX0X2		;BACK TO TOP OF LOOP
	PCHL			

US0ENTER LHLD	SOMLOC		;GET START OF MSG ADRS
	SHLD	US2RPTR		;SAVE AS NEXT READ POINTER
	STA	US2XF		;SET XMIT FLAG
	LHLD	US0RPTR		;RESTORE READ POINTER
	JMP	US0SW		;GO ADVANCE POINTER AND RETURN

US0EOM	CPI	84H		;ISOLATE THE EOM RANGE
	JNC	US0NEOM		;JUMP IF NOT REALLY AN EOM
	RAR			;DOES IT REQUIRE AN ANSWERBACK ?
	JNC	US0EOM1		;JUMP IF IT DOES NOT
	LDA	ABCOUNT		;GET THE PRESEND A/B COUNTER
	INR	A		;BUMP IT
	STA	ABCOUNT		;AND SAVE THE NEW VALUE
	MOV	A,M		;GET THAT EOM BACK
US0EOM1	RAR			;GET THE UNLOCK BIT
	RAR			
	JNC	US0SW		;JUMP IF NOT TO UNLOCK KEYBOARD
	XRA	A		;NOW CLEAR THE TERMINAL MSG FLAG
	STA	US2TM		;SINCE ALL DATA HAS BEEN PRINTED
	JMP	US0SW		;GO ADVANCE POINTERS

;	TRANSMITTER ROUTINE FOR TRANSMITTING SABRE POLLS (MODE 0)

US1SEND	DCX	SP		;DON'T DESTROY DEFAULT ADRS
	DCX	SP		
	LDA	US1PLR		;GET MSG-RCV FLAG
	ORA	A		
	JNZ	US1SS		;JUMP IF SET
	LDA	US1PS		;GET THE POLL SWITCH
	ORA	A		;TEST FOR ZERO
	JNZ	SPOLL1		;GO SEND POLL IF NONZERO
US1SS	LDA	IMSGR1		;SEE IF MSG IS READY
	ORA	A		
	JNZ	SMSG1		;GO SEND IT IF IT IS READY
	LDA	US2XF		;GET THE TERMINAL MSG FLAG
	ORA	A		;IS IT ZERO ?
	JNZ	STERM1		;JUMP IF NO- MSG PENDING
	IN	BUTTONS		;GET THE BUTTON REGISTER
	CMA			
	ANI	M0STEST		;SEE IF 'SEND TEST MSG' BUTTON IS ON
	JNZ	SENDT0		;JUMP IF YES
	STA	ST0SW		;CLEAR THE BUTTON-ON FLAG
US1SZIP	MVI	B,ZIP		
	CALL	XSAB1		;SEND ZERO IF NOTHING ELSE TO DO
	JMP	XS1X		;AND EXIT

;	SEND A SABRE POLL

SPOLL1	CPI	TWO		;IS THIS FROM POLL RESP OR TIMEOUT ?
	JNC	US1TIMO		;JUMP IF FROM A TIMEOUT
SPOLL1A	IN	MISC		;GET MISC INPUT PORT
	CMA			;FLIP IT
	ANI	TWO		;IS REQUEST TO SEND STILL UP ?
	JZ	SPOLL1B		;JUMP IF NOT
	LDA	US1SIA		;GET THE STREAMING INDICATOR
	ORA	A		;IS IT SET ?
	JNZ	SPOLL1B		;JUMP IF SET- DON'T FLAG THE STREAM
	LDA	LPIA		;GET THE GUY LAST POLLED
	STA	US1SIA		;SAVE AS THE STREAMING IA
;	CRANK OUT THE POLL
SPOLL1B	CALL	US1SYNCS	;SEND SYNC1 SYNC2 AND CLEAR CRC
	MVI	B,SGA		;GET A GO-AHEAD
	CALL	XSAB1		;SEND IT
	LDA	PIA		;GET THE IA
	MOV	B,A		
	CALL	XSAB1		;SEND IT
	XRA	A		
	STA	US1PS		;CLEAR POLL SWITCH
	STA	US1RTSF		;CLEAR RTS UP FLAG
	STA	CLKRT1		;CLEAR RTS-CTS TIMER
	MVI	A,FOX		;SET POLL TIMEOUT TO 15/10 SECOND
	STA	US1TIMER		
	MVI	A,TWO		;SET POLL FUNCTION FLAG FOR TIMEOUT
	STA	US1FUNC		
	LXI	H,US1POLC		
	INR	M		;COUNT THE POLL
SPO1X	MVI	B,EOMC		;GET AN EOMC
	CALL	XSAB1		;SEND IT
SPO1XX	MOV	B,C		;GET THE CRC COMPUTED SO FAR
	CALL	XSAB1		;SEND IT
	JMP	XS1X		;EXIT

;	A TIMEOUT- CHECK FOR PARTICULARS

US1TIMO	LDA	US1RTSF		;GET RTS FLAG
	ORA	A		;IS IT ZERO ?
	JZ	US1TIMX		;YES- IS PURE TIMEOUT- JUMP
	LXI	H,US1TRYC	;THE TI TRIED AT LEAST
	INR	M		;COUNT THE TRY
	JMP	SPOLL1A		;POLL AGAIN

US1TIMX	LXI	H,US1NPRC	;COUNT NO RESPONSE TO POLL
	INR	M		
	JMP	SPOLL1A		;GO POLL AGAIN

;	WE HAVE A LOOPBACK MSG TO SEND TO TERMINAL

SMSG1	CALL	US1SYNCS	;SEND SYNC1 SYNC2 AND CLEAR CRC
	LXI	H,IMSG1		;POINT TO THE MSG
	MOV	B,M		;GET THE IA
	CALL	XSAB1		;SEND IT (AND INX HL)
	IN	BUTTONS		;GET THE BUTTON REGISTER
	ANI	M0ILOOP		;IS THE INDIRECT LOOPBACK BIT ON ?
	JNZ	SMSG1A		;JUMP IF NOT- LOOP TO ORIGINATOR
	LDA	TA		;GET THE SETABLE TA
	MOV	B,A		;PUT IT INTO B FOR XSAB1
	JMP	SMSG1B		;GO SEND IT

SMSG1A	MOV	B,M		;GET THE TA OF THE MSG ORIGINATOR
SMSG1B	CALL	XSAB1		;SEND IT
	MVI	B,SNOP		;GET A SABRE NOP
	CALL	XSAB1		;SEND IT AS C1
	MVI	B,SNOP		;GET ANOTHER NOP
	CALL	XSAB1		;SEND IT AS C2
	DCX	H		;XSAB1 HAS INX'D HL SO WE MUST DECR HL
	DCX	H		
XMSG1L	MOV	A,M		;GET A CHAR
	CPI	EOMC		;IS IT EOM ?
	JZ	SPO1XT		;JUMP IF YES
	MOV	B,A		
	CALL	XSAB1		;SEND THE CHAR
	JMP	XMSG1L		;GO LOOK FOR MORE

SPO1XT	XRA	A		
	STA	IMSGR1		;CLEAR THE MSG SWITCH
	STA	US1LF		;CLEAR THE LOOP BUSY FLAG
	LXI	H,US1MSC		
	INR	M		;COUNT THE MSG SENT
	IN	BUTTONS		;GET THE BUTTON REGISTER
	ANI	M0CRC		;SEE IF A BAD CRC IS REQUESTED
	JNZ	SPO1X		;GO SEND EOM AND GOOD CRC IF NOT
	INR	C		;MESS UP THE CRC
	JMP	SPO1X		;GO SEND EOM AND BAD CRC

;	SEND MSG FROM TERMINAL

STERM1	XRA	A		
	STA	US2XF		;CLEAR THE TRANSMIT FLAG
	CALL	US1SYNCS	;SEND SYNC1 SYNC2 AND CLEAR THE CRC
	LHLD	US2RPTR		;GET THE READ POINTER
	MOV	A,M		;GET THE IA FROM BUFFER
	CALL	ASC2SAB		;TRANSLATE IT INTO SABRE
	ANI	MASK6		
	STA	UC1IA		;SAVE IT
	MOV	B,A		
	CALL	XSAB1		;SEND IT
	DCX	H		
	CALL	IBUFWRAP	;ADVANCE THE POINTER
	MOV	A,M		;GET THE TA FROM THE BUFFER
	CALL	ASC2SAB		;MAP IT INTO SABRE
	ANI	MASK6		
	STA	UC1TA		;SAVE THE TRANSLATED VALUE
ST1LOOP0 MOV	B,A		
	CALL	XSAB1		;SEND IT
	DCX	H		
ST1LOOP1 CALL	IBUFWRAP	;ADVANCE THE POINTER
	MOV	A,M		;GET THE CHAR
	CPI	07		;IS IT A BELL ?
	JZ	ST1LOOP1	;FLUSH IT IF IT IS
	CPI	LF		;ALSO FLUSH ANY LINEFEEDS
	JZ	ST1LOOP1		
	CPI	ENTER		;IS IT CONTROL-D ?
	JZ	ST1ENTER	;JUMP IF YES
	CALL	ASC2SAB		;TRANSLATE IT INTO SABRE
	ANI	MASK6		
	JMP	ST1LOOP0	;GO SEND IT

;	PREVIOUS CHARACTER SENT WAS AN EOM

ST1ENTER LXI	H,US1MSC	
	INR	M		;COUNT A MSG SENT
	IN	BUTTONS		;GET THE BUTTON REGISTER
	ANI	M0CRC		;IS THE BAD CRC SWITCH ON ?
	JNZ	SPO1XX		;JUMP IF NO
	INR	C		;MESS UP THE CRC CHAR
	JMP	SPO1XX		;GO SEND THE BAD CRC CHAR

;	SEND A CANNED MSG

SENDT0	LDA	ST0SW		;IS THE BUTTON STILL ON FROM PREVIOUS
	ORA	A		;TEST MSG ?
	JNZ	US1SZIP		;JUMP IF YES
	MVI	A,0FFH		
	STA	ST0SW		;SET THE BUTTON-ON FLAG
	CALL	US1SYNCS	;SEND SYNC1 SYNC2 AND CLEAR CRC CHAR
	LDA	LPIA		;GET THE IA
	MOV	B,A		;INTO B FOR XSAB1
	CALL	XSAB1		;SEND IT
	LDA	TA		;GET THE TA
	MOV	B,A		
	CALL	XSAB1		;SEND IT
	LXI	H,SABTESTM	;POINT TO THE CANNED TEST MSG
SENDT0L	MOV	A,M		;GET A CHAR OF THE MSG
	CALL	ASC2SAB		;TRANSLATE IT INTO SABRE CODE
	CPI	EOMC		;IS IT THE EOM ?
	JZ	SPO1XT		;JUMP IF YES
	MOV	B,A		
	CALL	XSAB1		;SEND IT
	JMP	SENDT0L		;LOOP UNTIL ALL DONE

;	TRANSMITTER FOR WHEN WE ARE RESPONDING TO POLLS (MODE 1)

US2SEND	DCX	SP		;DON'T LET ME MESS UP DEFAULT
	DCX	SP		;ROUTINE ADRS
	IN	MISC		;GET THE CLOCK STATUS
	RAR			;MOVE IT ONLY TO CARRY FLAG
	JC	US2CLKIX	;JUMP IF CLOCK IS INTERRUPTING
	EI			;ENABLE INTS IF NOT SO IT CAN
US2CLKIX MVI	B,SYNC1		
	CALL	US2XMT		;SEND SYNC 1
	MVI	B,SYNC2		
	CALL	US2XMT		;SEND SYNC 2
US2SEL	MVI	C,ZIP		;CLEAR CRC
	IN	BUTTONS		;GET THE BUTTON REGISTER
	CMA			;IT IS ACTIVE LOW
	ANI	M1SEND+M1SENDR	;ISOLATE SEND BUTTON
	JNZ	SENDONE		;GO SEND A MSG
	LDA	US2XF		;CHECK FOR TERMINAL SEND FLAG
	ORA	A		;NON-ZERO MEANS MSG READY
	JNZ	SENDENT		;JUMP IF MSG TO BE SENT
US2SAB	LDA	ABCOUNT		;GET COUNT OF ANSWERBACK TO GO
	ORA	A		;ARE THERE ANY REMAINING ?
	JZ	US2SPOLL	;IF NOT, GO SEND POLL RESPONSE
	DCR	A		;DECREMENT THE COUNT
	STA	ABCOUNT		;SAVE IT
	LDA	IA		;GET OUR IA
	MOV	B,A		;INTO B FOR US2XMT
	CALL	US2XMT		;SEND IT
	LDA	TA		;GET THE CURRENT TA
	MOV	B,A		
	CALL	US2XMT		;SEND IT
	MVI	B,EOMI		;GET AN EOMI
	CALL	US2XMT		;SEND IT
	MOV	B,C		;GET THE CRC CHAR COMPUTED SO FAR
	CALL	US2XMT		;SEND IT
	JMP	US2SEL		;GO CHECK FOR MSGS TO BE SENT

;	SEND A POLL RESPONSE

US2SPOLL MVI	B,SGA		;GET A GO-AHEAD
	CALL	US2XMT		;SEND IT
	MVI	B,CO67		;GET CPU IA
	CALL	US2XMT		;SEND IT
	MVI	B,ZIP		;SEND SOME ZIPS SO JAY'S
	CALL	US2XMT		;MUXED MODEMS CAN'T CHOP
	MVI	B,ZIP		;US OFF
	CALL	US2XMT		
	MVI	B,ZIP		
	CALL	US2XMT		
	LDA	US2CMD		;GET THE CURRENT COMMAND
	ANI	KILLXMT+1	;KNOCK OUT REQUEST TO SEND
	STA	US2CMD		;SAVE UPDATED COMMAND
	LXI	H,US2SPCC		
	INR	M		;COUNT POLL RESPONSES SENT
	XRA	A		
	STA	US2XA		;CLEAR SOFTWARE ENABLE FLAG
	JMP	XS2X		;EXIT TO SUPERVISOR

;	SEND A CANNED MSG FROM TA

SENDONE	LDA	IA		;GET IA
	MOV	B,A		;INTO B FOR XMIT ROUTINE
	CALL	US2XMT		;SEND IT
	LDA	TA		;GET TA
	MOV	B,A		
	CALL	US2XMT		;SEND IT
	IN	BUTTONS		;GET THE BUTTON AGAIN
	CMA			;FLIP THEM
	ANI	M1SENDR		;WAS IT @@RES MSG REQUEST ?
	JNZ	SENDR2		;JUMP IF YES
	LXI	H,MESSAGE	;POINT TO INPUT MSG
SENDM	MOV	B,M		;GET A BYTE
	CALL	US2XMT		;SEND IT
	MOV	A,M		;LOOK AGAIN AT THAT CHAR
	CPI	EOMC		;WAS IT EOMC ?
	JZ	SENDEOMC	;JUMP IF YES
	INX	H		;NOT- STEP TO NEXT CHAR
	JMP	SENDM		;LOOP UNTIL EOMC

SENDEOMC IN	BUTTONS		;GET THE BUTTON REGISTER
	ANI	M1CRC		;SEE IF A BAD CRC IS WANTED
	JNZ	SENDCRC		;JUMP IF NO- GO SEND GOOD CRC
	INR	C		;CORRUPT THE CRC
SENDCRC	MOV	B,C		;GET THE CRC
	CALL	US2XMT		;SEND IT
	XRA	A		
	STA	US2MSTAT	;BLANK THE STATUS-AT-A-GLANCE LIGHTS
	LXI	H,US2MSGC	
	INR	M		;BUMP MSGS SENT COUNTER
	JMP	US2SEL		;GO CHECK FOR MORE TO BE SENT

;	SEND USER-COMPOSED MSG

SENDENT	STA	US2TM		;SET MSG-FROM-TERMINAL FLAG
	XRA	A		
	STA	US2XF		;CLEAR TRANSMIT FLAG
	LDA	IA		;GET IA
	MOV	B,A		;INTO B FOR XMIT
	CALL	US2XMT		;SEND IT
	LDA	TA		;GET OUR TA
	MOV	B,A		
	CALL	US2XMT		;SEND IT
	LHLD	US2RPTR		;GET ADRS OF FIRST CHAR
SENDENT1 MOV	A,M		;GET THE CHAR
	CPI	07		;IS IT A BELL CHAR ?
	JZ	SENDE1W		;DROP IT IF IT IS
	CPI	LF		;IS IT A LINEFEED ?
	JZ	SENDE1W		;DROP IT ALSO
	CPI	ENTER		;IS IT ENTER ?
	JZ	SENDEOMC	;JUMP IF YES
	CALL	ASC2SAB		;TRANSLATE IT INTO SABRE CODE
	ANI	MASK6		
	MOV	B,A		
	CALL	US2XMT		;SEND TRANSLATED CHAR
SENDE1W	CALL	IBUFWRAP	;BUMP THE POINTER
	JMP	SENDENT1	;GO SEND NEXT CHAR

SENDR2	LXI	H,RMSG		;POINT TO @@RES MSG
	JMP	SENDM		;GO SEND IT

;	1 KHZ REALTIME CLOCK ROUTINE

CLOCK	PUSH	PSW		
	PUSH	H		
	LXI	H,CLK1		;POINT TO 8-BIT COUNTER OF MSECS
	INR	M		;BUMP IT
	IN	MISC		;GET MISCELLANEOUS INPUT PORT
	CMA			;FLIP IT
	ANI	TWO		;IS RTS UP FROM TI ON USART 1 ?
	JZ	CLKNRTS1	;JUMP IF NO
	LDA	CLKRT1		;GET RTS-CTS DELAY TIMER
	ORA	A		;SEE IF ZERO
	JNZ	CLKRT1A		;JUMP IF NO- NOT FIRST TIME THRU
	LXI	H,US1RTSF	;GET REQUEST-TO-SEND FLAG
	MVI	M,ONE		;SET IT
	LDA	US1RTS		;GET USART RTS-CTS DELAY VALUE
	JMP	CLKRT1S		;GO STORE IT

CLKSRTS1 LDA	US1CMD		;GET CURRENT USART 1 COMMAND
	ORI	CTS		;SET DTR (CTS TO TI)
	JMP	CLKNR1X		;GO SAVE AND SEND IT

CLKRT1A	DCR	A		;DECREMENT TIMER
	JZ	CLKSRTS1	;IF GOING ZERO- GO SET CTS
CLKRT1S	STA	CLKRT1		;STORE NEW TIMER STATE
CLKNRTS1 LDA	US1CMD		;GET CURRENT USART 1 COMMAND
	ANI	0FFH - CTS	;KNOCK OUT DTR (CTS TO TI)
CLKNR1X	STA	US1CMD		;SAVE NEW COMMAND
	LDA	CLK10		;GET COUNTER FOR GENERATION OF TENTHS
	ORA	A		;IS IT ZERO ALREADY ?
	JZ	CLK10W		;YES- GO SET UP PROPER VALUE
	DCR	A		;DECREMENT THE COUNTER
	STA	CLK10		;SAVE NEW COUNT
CLKEXIT	POP	H		
	POP	PSW		
	RET			

CLK10W	MVI	A,CLKC		;SET COUNTER TO 100
	STA	CLK10		
	LHLD	CLK16		;GET THE 16-BIT COUNTER
	INX	H		;BUMP IT
	SHLD	CLK16		;SAVE IT
	LDA	US1TIMER	;GET USART 1 POLL TIMER
	ORA	A		;ZERO ?
	JZ	CLKHS1		;SKIP IF ZERO
	DCR	A		;DECREMENT THE COUNTER
	JNZ	CLKHS0		;GO STORE NEW TIMER VALUE IF NONZERO
	LDA	US1FUNC		;TIME'S UP- SET APPROPRIATE FLAG
	STA	US1PS		;IN POLL SWITCH
	JMP	CLKHS1		;SKIP THE STORE- LEAVE IT AT ONE

CLKHS0	STA	US1TIMER	;SAVE NEW TIMER VALUE
CLKHS1	LXI	H,HALFSEC	;POINT TO HALF SECOND TIMER
	DCR	M		;DECREMENT IT
	JNZ	CLKSHS		;GET OUT IF NOT TIME YET
	IN	BUTTONS		;GET THE BUTTON REGISTER
	CMA			;FLIP IT
	ANI	M0TA		;IS TA BUMP BUTTON ON ?
	JZ	CLKRHS		;JUMP IF NO
	LDA	TA		;GET THE CURRENT TA VALUE
CLKSZ	ADI	TWO		;BUMP TO NEXT VALID TA VALUE
	ANI	MASK6		;CAN'T BE BIGGER THAN 6 BITS
	JZ	CLKSZ		;BUMP AGAIN IF WENT TO ZERO
	STA	TA		;SAVE IT
CLKRHS	MVI	M,05		;RESET HALF SECOND TIMER VALUE
CLKSHS	JMP	CLKEXIT		;GET OUT

;	RECEIVE AN ASCII CHAR FROM ASYNC CONTROLLER

US0RCV	PUSH	B		
	PUSH	D		
	PUSH	H		;SAVE ALL REGS EXCEPT PSW
	CALL	GUS0X		;GO WAIT FOR RECEIVER READY STATUS
	POP	H		
	POP	D		
	POP	B		;RESTORE REGISTERS
US0RCVA	IN	US0D		;GET THE CHAR
	ANI	PARITY		;KNOCK OFF THE PARITY BIT
	MOV	B,A		;CHAR ALSO INTO B
	RET			

;	RECEIVE A SABRE CHAR FROM USART 1

US1RCV	PUSH	B		
	PUSH	D		;SAVE ALL REGS EXCEPT PSW
	PUSH	H		
	CALL	GUS1X		;GO AWAIT RX READY STATUS
	POP	H		
	POP	D		
	POP	B		;RESTORE REGS
US1RCVA	IN	US1D		;READ THE CHAR
	CALL	FIX		;AROUND AND OVER
	MOV	B,A		;CHAR INTO B
	CALL	CRC		;ADD IT INTO THE CRC
	RET			

;	RECEIVE A SABRE CHAR FROM USART 2

US2RCV	PUSH	B		
	PUSH	D		;SAVE ALL REGS EXCEPT PSW
	PUSH	H		
	CALL	GUS2X		;GO AWAIT RX READY STATUS
	POP	H		
	POP	D		;RESTORE REGISTERS
	POP	B		
US2RCVA	IN	US2D		;READ THE CHAR
	CALL	FIX		;TURN AROUND AND FLIP IT
	MOV	B,A		;CHAR INTO B
	CALL	CRC		;ADD IT INTO THE GROWING CRC
	RET			

;	TRANSMIT A CHAR TO USART 0

US0XMT	PUSH	B		
	PUSH	D		
	PUSH	H		;SAVE ALL EXCEPT PSW
	CALL	XS0X		;WAIT FOR TRANSMIT READY STATUS
	POP	H		
	POP	D		;RESTORE REGISTERS
	POP	B		
	MOV	A,B		;GET THE CHAR FROM B
	OUT	US0D		;SEND IT
	RET			

;	TRANSMIT A CHAR TO USART 1

XSAB1	PUSH	B		
	PUSH	D		;SAVE ALL REGS EXCEPT PSW
	PUSH	H		
	CALL	XS1X		;GO WAIT FOR TX READY STATUS
	POP	H		
	POP	D		;RESTORE REGISTERS
	POP	B		
	CALL	CRC		;ADD NEW CHAR INTO CRC
	CALL	FIX		;TURN AROUND AND FLIP
	OUT	US1D		;SEND IT
	INX	H		;BUMP THE DATA POINTER
	RET			

;	TRANSMIT A CHAR TO USART 2

US2XMT	PUSH	B		
	PUSH	D		;SAVE ALL REGS EXCEPT PSW
	PUSH	H		
	CALL	XS2X		;GO WAIT FOR TX READY STATUS
	POP	H		
	POP	D		;RESTORE REGISTERS
	POP	B		
	CALL	CRC		;ADD NEW CHAR INTO CRC
	CALL	FIX		;TURN AROUND AND FLIP
	OUT	US2D		;SEND IT
	RET			

;	WRAP BUFFER POINTER IN HL

IBUFWRAP INX	H		;BUMP IT
	XCHG			;TEMPSAVE INTO DE
	LXI	H,-IBUFE	;GET COMPLEMENT OF END ADRS
	DAD	D		;ADD CURRENT POINTER
	JNC	IBNW		;JUMP IF NOT AT OR PAST END
	LXI	H,IBUF		;WRAP POINTER TO START OF BUFFER
	RET			

IBNW	XCHG			;RESTORE POINTER FROM DE
	RET			;RETURN WITH UPDATED POINTER

;	TRANSLATE ASCII CHAR INTO SABRE CODE

ASC2SAB	PUSH	H		;SAVE HL
	ANI	PARITY		;KNOCK OFF HIGH-ORDER BIT
	LXI	H,ASCSABT	;GET TABLE START
	ADD	L		;ADD CHAR TO TABLE START
	MOV	L,A		;SUM INTO L
	MOV	A,M		;GET THE TRANSLATED CHAR
	POP	H		;RESTORE PREV HL
	RET			

;	TRANSLATE SABRE CODE CHAR INTO ASCII

SAB2ASC	PUSH	H		;SAVE HL
	LXI	H,SABASCT	;GET TABLE BASE
	ANI	MASK6		;ENSURE NO GARBAGE IN BYTE
	ADD	L		;ADD CHAR TO TABLE BASE
	MOV	L,A		;COMPLETE INDEX
	MOV	A,M		;GET THE CHAR
	POP	H		;RESTORE HL
	RET			

;	SEND SYNCS AND CLEAR THE CRC VALUE TO ZERO

US1SYNCS MVI	B,SYNC1		;GET A SYNC ONE
	CALL	XSAB1		;TRANSMIT IT
	MVI	B,SYNC2		;GET A SYNC TWO
	CALL	XSAB1		;TRANSMIT IT
	MVI	C,ZIP		;CLEAR THE CRC
	RET			

IAADJ	ANI	0FH		;KNOCK OFF GARBAGE
	CPI	EIGHT		;SEE IF BELOW IA 8
	RC			;RETURN IF SO
	ADI	EIGHT		;ADJUST BY 8 IF 8 OR MORE
	RET			

;	DISPLAY MESSAGE IN ALPHA DISPLAY

ADISP	MOV	A,M		;SAVE FIRST CHAR
	ORI	80H		
	MOV	B,A		
	LXI	D,2C03H		;GET LEFT CHAR ADRS
	STAX	D		;STORE IT
	STAX	D		;TWICE
	INX	H		
	DCX	D		;ADJUST THE POINTERS
	MOV	A,M		;GET A CHAR
	ORI	80H		
	STAX	D		;STORE IT
	INX	H		
	DCX	D		;ADJUST POINTERS
	MOV	A,M		;GET NEXT CHAR
	ORI	80H		
	STAX	D		;STORE IT
	INX	H		
	DCX	D		;MOVE POINTERS
	MOV	A,M		
	ORI	80H		
	STAX	D		;STORE CHAR
	LXI	D,2803H		;GET OTHER DISPLAY ADRS
	MOV	A,B		;RESTORE FIRST CHAR
	STAX	D		;DISPLAY IT
	INX	H		;STEP TO NEXT CHAR
	MOV	A,M		;GET IT
	ORI	80H		
	STAX	D		;DISPLAY IT
	INX	H		
	DCX	D		;ADJUST POINTERS
	MOV	A,M		;GET NEXT CHAR
	ORI	80H		
	STAX	D		;STORE IT
	INX	H		
	DCX	D		;MOVE POINTERS
	MOV	A,M		;GET NEXT
	ORI	80H		
	STAX	D		;AND STORE
	INX	H		
	DCX	D		;POINT TO LAST CHAR
	MOV	A,M		;GET IT
	ORI	80H		
	STAX	D		;STORE IT
	XRA	A		;ENSURE ARE NO CURSORS
	STA	2800H		
	STA	2C00H		
	RET			

;	SABRE IS UPSIDE DOWN AND BACKWARDS
;	THIS ROUTINE TURNS IT AROUND AND FLIPS IT UPRIGHT

FIX	PUSH	H		;SAVE HL
	LXI	H,SABFLIP	;GET START OF FLIP TABLE
	ANI	MASK6		;KNOCK OFF ACCIDENTAL GARBAGE
	ADD	L		;ADD CHAR TO TABLE START
	MOV	L,A		;PUT BACK INTO L
	MOV	A,M		;GET THE FIXED CHAR
	POP	H		;RESTORE HL
	RET			

;	CRC COMPUTATION ROUTINE FOR DDA

CRC	PUSH	H		;SAVE HL
	MVI	H,CRCT SHR 8	;GET CRC TABLE START
	MOV	A,C		;GET OLD CRC FROM REGISTER C
	XRA	B		;COMBINE WITH NEW CHAR
	ADI	CRCT AND 0FFH	;ADD REST OF TABLE ADRS
	MOV	L,A		
	MOV	C,M		;GET NEW CRC VALUE
	MOV	A,B		;GET CHAR INTO ACCUM
	POP	H		;RESTORE HL
	RET		

MESSAGE	DB	01,35Q		;LITTLE DINKY CANNED MSG

RMSG	DB	32,32,41,53,18,29	;@@RES MSG

SABTESTM DB	'%%0123456789@ABCDEFGHIJKLMNOP'
	DB	'QRSTUVWXYZ /.,-*#',13,10,04

	ORG	1C00H		

;	CRC COMPUTATION TABLE

CRCT	DB 00,33,35,02,39,06,04,37,47,14,12,45,08,41,43,10
	DB 63,30,28,61,24,57,59,26,16,49,51,18,55,22,20,53
	DB 31,62,60,29,56,25,27,58,48,17,19,50,23,54,52,21
	DB 32,01,03,34,07,38,36,05,15,46,44,13,40,09,11,42

;	TURN SABRE RIGHTSIDE-UP AND FRONTWARDS

SABFLIP	DB 63,31,47,15,55,23,39,07,59,27,43,11,51,19,35,03
	DB 61,29,45,13,53,21,37,05,57,25,41,09,49,17,33,01
	DB 62,30,46,14,54,22,38,06,58,26,42,10,50,18,34,02
	DB 60,28,44,12,52,20,36,04,56,24,40,08,48,16,32,00

ASCSABT	DB 00,00,00,35Q,29,00,00,00,60,15Q,14,00,00,12,00,00
	DB 75Q,00,00,00,44,55Q,00,00,00,00,00,46,00,00,00,00
	DB 28,64,15,43,48,16,12,00,31,46,11,00,27,26,59,17
	DB 10,01,02,03,04,05,06,07,08,09,42,00,00,47,30,58
	DB 32,49,50,51,52,53,54,55,56,57,33,34,35,36,37,38
	DB 39,40,41,18,19,20,21,22,23,24,25,00,63,00,14,63
	DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
	DB 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

SABASCT	DB 33,49,50,51,52,53,54,55,56,57,48,42,38,129,94,34
	DB 37,47,83,84,85,86,87,88,89,90,45,44,32,130,62,40
	DB 64,74,75,76,77,78,79,80,81,82,58,35,126,131,41,61
	DB 36,65,66,67,68,69,70,71,72,73,63,46,60,128,92,95

COUNTL	EQU	16		;LENGTH OF COUNTER AREA

	ORG	COUNTS+COUNTL

;	STACKS FOR EVERYONE

	DW	0000,0000,0000,0000,0000,0000,0000,0000
	DW	0000,0000,0000,0000,0000,0000,0000,0000
STACKRA	DW	0000
	DW	0000,0000,0000,0000,0000,0000,0000,0000
	DW	0000,0000,0000,0000,0000,0000,0000,0000
STACKRB	DW	0000
MMDATA	DS	64		
MMREGS	DW	0000,0000,0000,0000,0000,0000,0000,0000
	DW	0000,0000,0000,0000,0000,0000,0000,0000
STACKRC	DW	0000
MMUSRBR	DW	0000,0000,0000,0000,0000,0000,0000,0000
	DW	0000,0000,0000,0000,0000,0000,0000,0000
STACKXA	DW	0000
	DW	0000,0000,0000,0000,0000,0000,0000,0000
	DW	0000,0000,0000,0000,0000,0000,0000,0000
STACKXB	DW	0000
	DW	0000,0000,0000,0000,0000,0000,0000,0000
	DW	0000,0000,0000,0000,0000,0000,0000,0000
STACKXC	DW	0000
	DW	0000,0000,0000,0000,0000,0000,0000,0000
	DW	0000,0000,0000,0000,0000,0000,0000,0000

LOOPS	EQU	$		

IMSGR1	DB	00	;MSG READY SWITCH FOR LOOPBACK
IMSG1	DS	302	;ROOM FOR 302 BYTES OF LOOP MSG
IMSGEND1 DW	0000	;END OF IMSG1 MSG ACTUAL ADRS
IBUF	DS	1320	;TERMINAL INPUT/OUTPUT BUFFER
IBUFE	EQU	$	;END OF IBUF MSG BUFFER
US0CMD	DB	00	;USART COMMAND FOR USART 0
US1CMD	DB	00	;USART COMMAND FOR USART 1
US2CMD	DB	00	;USART COMMAND FOR USART 2
US3CMD	DB	00	;USART COMMAND FOR USART 3

RSYN1	DB	00	;USART 1 RESYNC SWITCH
RSYN2	DB	00	;USART 2 RESYNC SWITCH
RSYN3	DB	00	;USART 3 RESYNC SWITCH

US1FUNC	DB	00	;POLL TIMER FUNCTION FLAG
US1TIMER DB	00	;USART 1 POLL TIMER
US1RTSF	DB	00	;USART 1 TI RAISED RTS FLAG
US1RTS	DB	00	;USART 1 RTS-CTS DELAY VALUE
US1PS	DB	00	;POLL SWITCH
US1LF	DB	00	;LOOPBACK BUSY FLAG
US1PLR	DB	00	;USART 1 MSG RECV FLAG

US2TM	DB	00	;TERMINAL EXPECTING A RESPONSE FLAG
US2XF	DB	00	;TERMINAL HAS MSG TO SEND FLAG

PCOUNT	DW	0000	;ADRS OF PRESENT COUNTER
ABCOUNT	DB	00	;NBR OF ANSWERBACKS TO BE SENT
ST0SW	DB	00	;CANNED MSG BUTTON-ON FLAG

US0RS	DW	0000	;USART 0 RECEIVER STACK SAVE AREA
US1RS	DW	0000	;USART 1 RECEIVER STACK SAVE AREA
US2RS	DW	0000	;USART 2 RECEIVER STACK SAVE AREA
US3RS	DW	0000	;USART 3 RECEIVER STACK SAVE AREA
US0XS	DW	0000	;USART 0 TRANSMITTER STACK SAVE AREA
US1XS	DW	0000	;USART 1 TRANSMITTER STACK SAVE AREA
US2XS	DW	0000	;USART 2 TRANSMITTER STACK SAVE AREA
US3XS	DW	0000	;USART 3 TRANSMITTER STACK SAVE AREA
US0RA	DB	00	;USART 0 RECEIVER ACTIVE FLAG
US2XA	DB	00	;USART 2 TRANSMIT ACTIVE FLAG

CPR0X1	DW	0000	;USART 0 RECEIVER CPULOOP RETURN
CPR0X2	DW	0000	;USART 0 RECEIVER CPULOOP RETURN TWO
CPR1X1	DW	0000	;USART 1 RECEIVER CPULOOP RETURN
CPR1X2	DW	0000	;USART 1 RECEIVER CPULOOP RETURN TWO
CPR2X1	DW	0000	;USART 2 RECEIVER CPULOOP RETURN
CPR2X2	DW	0000	;USART 2 RECEIVER CPULOOP RETURN TWO
CPR3X1	DW	0000	;USART 3 RECEIVER CPULOOP RETURN
CPR3X2	DW	0000	;USART 3 RECEIVER CPULOOP RETURN TWO
CPX0X1	DW	0000	;USART 0 TRANSMIT CPULOOP RETURN
CPX0X2	DW	0000	;USART 0 TRANSMIT CPULOOP RETURN TWO
CPX1X1	DW	0000	;USART 1 TRANSMIT CPULOOP RETURN
CPX1X2	DW	0000	;USART 1 TRANSMIT CPULOOP RETURN TWO
CPX2X1	DW	0000	;USART 2 TRANSMIT CPULOOP RETURN
CPX2X2	DW	0000	;USART 2 TRANSMIT CPULOOP RETURN TWO
CPX3X1	DW	0000	;USART 3 TRANSMIT CPULOOP RETURN
CPX3X2	DW	0000	;USART 3 TRANSMIT CPULOOP RETURN TWO

SOMLOC	DW	0000	;START OF MSG ADRS
US0RPTR	DW	0000	;ASYNC CONTROLLER NEXT-READ-POINTER
US2RPTR	DW	0000	;SABRE CONTROLLER NEXT-READ-POINTER
US0WPTR	DW	0000	;ASYNC CONTROLLER NEXT-WRITE-POINTER

PIAP	DW	IA	;POINTER INTO POLL TABLE
STOPPER	DB	00	;DON'T MOVE THIS
IA3	DB	00	;SECONDARY SECONDARY IA
IA2	DB	00	;SECONDARY IA
IA	DB	00	;IA WE ARE POLLING/RESPONDING TO
TA	DB	00	;TA WE ARE USING

PIA	DB	00	;IA TO BE POLLED NEXT
LPIA	DB	00	;IA LAST POLLED

UC1IA	DB	00	;IA USED BY TERMINAL IN MODE 0
UC1TA	DB	00	;TA USED BY TERMINAL IN MODE 0

CLK1	DB	00	;8-BIT CONTINUOUS CLOCK COUNTER
CLK10	DB	00	;DIVIDE-BY-100 TO GET TENTHS COUNTER
CLK16	DW	0000	;FREE RUNNING 16-BIT COUNT OF TENTHS
CLKRT1	DB	00	;USART 1 RTS-CTS DELAY TIMER
HALFSEC	DB	00	;HALF SECOND TIMER
POLLTIME DB	00	;POLL DELAY TIMER VALUE (TENTHS)

;	EQUATES

;	TEMP EQUATE TO ELIMINATE ASSEMBLY ERRORS
US3IDLE	EQU	$	;********************************
US3SEND	EQU	$	;********************************

MONITOR	EQU	1800H	;ADRS OF MONITOR PROM
CI	EQU	1BFDH	;CHAR INPUT ROUTINE
CO	EQU	1BFAH	;CHAR OUTPUT ROUTINE

SGA	EQU	17Q	;SABRE GO-AHEAD CHAR
SNOP	EQU	20Q	;SABRE NOP CHAR
SYNC1	EQU	77Q	;FIRST SABRE SYNC CHAR
SYNC2	EQU	76Q	;SECOND SABRE SYNC CHAR
SEOM	EQU	15Q	;TEST FOR SABRE EOM
EOMI	EQU	15Q	;SABRE EOM INCOMPLETE
EOMC	EQU	35Q	;SABRE EOM COMPLETE
EOMU	EQU	55Q	;SABRE EOM UNSOLICITED
EOMPB	EQU	75Q	;SABRE EOM PUSHBUTTON
ENTER	EQU	04	;ENTER BUTTON ON LOCAL CRT
CONTX	EQU	18H	;CONTROL-X (CANCEL RESET ETC.)
HO4	EQU	0F0H	;MASK FOR HIGH-ORDER 4 BITS
HOBIT	EQU	80H	;MASK FOR HIGH-ORDER BIT
N2HOB	EQU	40H	;MASK FOR NEXT-TO-HIGH-ORDER BIT
DSR	EQU	80H	;USART DSR STATUS BIT
PARITY	EQU	7FH	;MASK TO KNOCK OFF PARITY BIT
CR	EQU	0DH	;ASCII CARRIAGE RETURN
LF	EQU	0AH	;ASCII LINEFEED
STAR	EQU	'*'	;ASCII ASTERISK
CSABRE	EQU	06	;RXEN AND DTR USART BITS
SABPOLL	EQU	25H	;RTS RXEN AND TXEN BITS
RTSTXEN	EQU	21H	;RTS AND TXEN USART BITS
CTS	EQU	02	;USART 1 CTS BIT (DTR ON USART)
S1	EQU	01	;SABRE 1
S9	EQU	09	;SABRE 9

US0D	EQU	30H	;USART 0 DATA PORT
US0C	EQU	US0D+1	;USART 0 CONTROL PORT
US1D	EQU	32H	;USART 1 DATA PORT
US1C	EQU	US1D+1	;USART 1 CONTROL PORT
US2D	EQU	34H	;USART 2 DATA PORT
US2C	EQU	US2D+1	;USART 2 CONTROL PORT
US3D	EQU	36H	;USART 3 DATA PORT
US3C	EQU	US3D+1	;USART 3 CONTROL PORT
BUTTONS	EQU	38H	;BUTTON REGISTER ADRS
LIGHT0	EQU	39H	;LIGHT REGISTER OUTPUT PORT ADRS
THUMB	EQU	3AH	;THUMBWHEEL SWITCH ADRS
MISC	EQU	3BH	;MISC INPUT PORT ADRS

MSABRE	EQU	04	;MODE INSTRUCTION FOR SABRE SYNC
MASCII	EQU	0FAH	;MODE INSTRUCTION FOR ASCII ASYNC
CASCII	EQU	27H	;COMMAND INSTR FOR TX AND RX

;	MESSAGE STATUS-AT-A-GLANCE EQUATES

PLITE	EQU	80H	;POLL RECEIVED
MLITE	EQU	40H	;MSG RECEIVED (RIGHT TA)
WTLITE	EQU	20H	;MSG RECEIVED (WRONG TA)
BTLITE	EQU	10H	;MSG RECEIVED (ODD TA)
EWLITE	EQU	08	;ERASE/WRITE C1 ON MSG
WCLITE	EQU	04	;WRITE CONTINUE C1 ON MSG
BULITE	EQU	02	;BUSTED MSG
CLITE	EQU	01	;CRC ERROR ON MSG

TXRDY	EQU	01	;USART TRANSMITTER READY STATUS
RXRDY	EQU	02	;USART RECEIVER READY STATUS

ZIP	EQU	00		
ONE	EQU	01		
TWO	EQU	02		
FIVE	EQU	05		
EIGHT	EQU	08		
FOX	EQU	0FH		

SYNC	EQU	80H	;ENTER HUNT MODE USART COMMAND
CO67	EQU	67Q	;IA FOR CENTRAL SITE
CLKC	EQU	100	;COUNTER VALUE FOR MSECS TO TENTHS
MASK6	EQU	77Q	;6-BIT MASK
KILLXMT	EQU	0DEH	;MASK TO KILL RTS AND TX ENABLE

;	MODE 0 BUTTON REGISTER EQUATES

M0REGC	EQU	80H	;CLEAR REGISTER SELECTED BY THUMBS
M0PIDLE	EQU	40H	;SET POLL IDLE VALUE (WITH M0REGC)
M0STEST	EQU	20H	;SEND CANNED TEST MSG
M0TA	EQU	10H	;ADVANCE TA TO NEXT VALUE
M0X	EQU	08	;UNUSED
M0XX	EQU	04	;UNUSED
M0ILOOP	EQU	02	;INDIRECT LOOPBACK BUTTON
M0CRC	EQU	01	;SEND BAD CRC

;	MODE 1 BUTTON REGISTER EQUATES

M1REGC	EQU	80H	;CLEAR REGISTER SELECTED BY THUMBS
M1X	EQU	40H	;UNUSED
M1SEND	EQU	20H	;SEND CANNED MSG TO SABRE
M1TA	EQU	10H	;STEP TA TO NEXT VALUE
M1SENDR	EQU	08	;SEND @@RES MSG
M1XX	EQU	04	;UNUSED
M1XXX	EQU	02	;UNUSED
M1CRC	EQU	01	;SEND BAD CRC TO SABRE

	END	DDAINIT		
